// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageSwitchCollectionGetReader is a Reader for the StorageSwitchCollectionGet structure.
type StorageSwitchCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageSwitchCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageSwitchCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageSwitchCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageSwitchCollectionGetOK creates a StorageSwitchCollectionGetOK with default headers values
func NewStorageSwitchCollectionGetOK() *StorageSwitchCollectionGetOK {
	return &StorageSwitchCollectionGetOK{}
}

/*
StorageSwitchCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageSwitchCollectionGetOK struct {
	Payload *models.StorageSwitchResponse
}

// IsSuccess returns true when this storage switch collection get o k response has a 2xx status code
func (o *StorageSwitchCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage switch collection get o k response has a 3xx status code
func (o *StorageSwitchCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage switch collection get o k response has a 4xx status code
func (o *StorageSwitchCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage switch collection get o k response has a 5xx status code
func (o *StorageSwitchCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage switch collection get o k response a status code equal to that given
func (o *StorageSwitchCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage switch collection get o k response
func (o *StorageSwitchCollectionGetOK) Code() int {
	return 200
}

func (o *StorageSwitchCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches][%d] storageSwitchCollectionGetOK %s", 200, payload)
}

func (o *StorageSwitchCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches][%d] storageSwitchCollectionGetOK %s", 200, payload)
}

func (o *StorageSwitchCollectionGetOK) GetPayload() *models.StorageSwitchResponse {
	return o.Payload
}

func (o *StorageSwitchCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageSwitchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageSwitchCollectionGetDefault creates a StorageSwitchCollectionGetDefault with default headers values
func NewStorageSwitchCollectionGetDefault(code int) *StorageSwitchCollectionGetDefault {
	return &StorageSwitchCollectionGetDefault{
		_statusCode: code,
	}
}

/*
StorageSwitchCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageSwitchCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage switch collection get default response has a 2xx status code
func (o *StorageSwitchCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage switch collection get default response has a 3xx status code
func (o *StorageSwitchCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage switch collection get default response has a 4xx status code
func (o *StorageSwitchCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage switch collection get default response has a 5xx status code
func (o *StorageSwitchCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage switch collection get default response a status code equal to that given
func (o *StorageSwitchCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage switch collection get default response
func (o *StorageSwitchCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageSwitchCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches][%d] storage_switch_collection_get default %s", o._statusCode, payload)
}

func (o *StorageSwitchCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches][%d] storage_switch_collection_get default %s", o._statusCode, payload)
}

func (o *StorageSwitchCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageSwitchCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
