// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageSwitchGetReader is a Reader for the StorageSwitchGet structure.
type StorageSwitchGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageSwitchGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageSwitchGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageSwitchGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageSwitchGetOK creates a StorageSwitchGetOK with default headers values
func NewStorageSwitchGetOK() *StorageSwitchGetOK {
	return &StorageSwitchGetOK{}
}

/*
StorageSwitchGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageSwitchGetOK struct {
	Payload *models.StorageSwitch
}

// IsSuccess returns true when this storage switch get o k response has a 2xx status code
func (o *StorageSwitchGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage switch get o k response has a 3xx status code
func (o *StorageSwitchGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage switch get o k response has a 4xx status code
func (o *StorageSwitchGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage switch get o k response has a 5xx status code
func (o *StorageSwitchGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage switch get o k response a status code equal to that given
func (o *StorageSwitchGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage switch get o k response
func (o *StorageSwitchGetOK) Code() int {
	return 200
}

func (o *StorageSwitchGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches/{name}][%d] storageSwitchGetOK %s", 200, payload)
}

func (o *StorageSwitchGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches/{name}][%d] storageSwitchGetOK %s", 200, payload)
}

func (o *StorageSwitchGetOK) GetPayload() *models.StorageSwitch {
	return o.Payload
}

func (o *StorageSwitchGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageSwitch)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageSwitchGetDefault creates a StorageSwitchGetDefault with default headers values
func NewStorageSwitchGetDefault(code int) *StorageSwitchGetDefault {
	return &StorageSwitchGetDefault{
		_statusCode: code,
	}
}

/*
StorageSwitchGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageSwitchGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage switch get default response has a 2xx status code
func (o *StorageSwitchGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage switch get default response has a 3xx status code
func (o *StorageSwitchGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage switch get default response has a 4xx status code
func (o *StorageSwitchGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage switch get default response has a 5xx status code
func (o *StorageSwitchGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage switch get default response a status code equal to that given
func (o *StorageSwitchGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage switch get default response
func (o *StorageSwitchGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageSwitchGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches/{name}][%d] storage_switch_get default %s", o._statusCode, payload)
}

func (o *StorageSwitchGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/switches/{name}][%d] storage_switch_get default %s", o._statusCode, payload)
}

func (o *StorageSwitchGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageSwitchGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
