// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTapeDeviceCollectionGetParams creates a new TapeDeviceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTapeDeviceCollectionGetParams() *TapeDeviceCollectionGetParams {
	return &TapeDeviceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTapeDeviceCollectionGetParamsWithTimeout creates a new TapeDeviceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewTapeDeviceCollectionGetParamsWithTimeout(timeout time.Duration) *TapeDeviceCollectionGetParams {
	return &TapeDeviceCollectionGetParams{
		timeout: timeout,
	}
}

// NewTapeDeviceCollectionGetParamsWithContext creates a new TapeDeviceCollectionGetParams object
// with the ability to set a context for a request.
func NewTapeDeviceCollectionGetParamsWithContext(ctx context.Context) *TapeDeviceCollectionGetParams {
	return &TapeDeviceCollectionGetParams{
		Context: ctx,
	}
}

// NewTapeDeviceCollectionGetParamsWithHTTPClient creates a new TapeDeviceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTapeDeviceCollectionGetParamsWithHTTPClient(client *http.Client) *TapeDeviceCollectionGetParams {
	return &TapeDeviceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
TapeDeviceCollectionGetParams contains all the parameters to send to the API endpoint

	for the tape device collection get operation.

	Typically these are written to a http.Request.
*/
type TapeDeviceCollectionGetParams struct {

	/* AliasMapping.

	   Filter by alias.mapping
	*/
	AliasMapping *string

	/* AliasName.

	   Filter by alias.name
	*/
	AliasName *string

	/* AliasesMapping.

	   Filter by aliases.mapping
	*/
	AliasesMapping *string

	/* AliasesName.

	   Filter by aliases.name
	*/
	AliasesName *string

	/* BlockNumber.

	   Filter by block_number
	*/
	BlockNumber *int64

	/* Density.

	   Filter by density
	*/
	Density *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* DeviceID.

	   Filter by device_id
	*/
	DeviceID *string

	/* DeviceNamesNoRewindDevice.

	   Filter by device_names.no_rewind_device
	*/
	DeviceNamesNoRewindDevice *string

	/* DeviceNamesRewindDevice.

	   Filter by device_names.rewind_device
	*/
	DeviceNamesRewindDevice *string

	/* DeviceNamesUnloadReloadDevice.

	   Filter by device_names.unload_reload_device
	*/
	DeviceNamesUnloadReloadDevice *string

	/* DeviceState.

	   Filter by device_state
	*/
	DeviceState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FileNumber.

	   Filter by file_number
	*/
	FileNumber *int64

	/* Formats.

	   Filter by formats
	*/
	Formats *string

	/* Interface.

	   Filter by interface
	*/
	Interface *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* Online.

	   Filter by online
	*/
	Online *bool

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReservationType.

	   Filter by reservation_type
	*/
	ReservationType *string

	/* ResidualCount.

	   Filter by residual_count
	*/
	ResidualCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* StoragePortName.

	   Filter by storage_port.name
	*/
	StoragePortName *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* Wwnn.

	   Filter by wwnn
	*/
	Wwnn *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tape device collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceCollectionGetParams) WithDefaults() *TapeDeviceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tape device collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := TapeDeviceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithTimeout(timeout time.Duration) *TapeDeviceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithContext(ctx context.Context) *TapeDeviceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithHTTPClient(client *http.Client) *TapeDeviceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAliasMapping adds the aliasMapping to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithAliasMapping(aliasMapping *string) *TapeDeviceCollectionGetParams {
	o.SetAliasMapping(aliasMapping)
	return o
}

// SetAliasMapping adds the aliasMapping to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetAliasMapping(aliasMapping *string) {
	o.AliasMapping = aliasMapping
}

// WithAliasName adds the aliasName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithAliasName(aliasName *string) *TapeDeviceCollectionGetParams {
	o.SetAliasName(aliasName)
	return o
}

// SetAliasName adds the aliasName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetAliasName(aliasName *string) {
	o.AliasName = aliasName
}

// WithAliasesMapping adds the aliasesMapping to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithAliasesMapping(aliasesMapping *string) *TapeDeviceCollectionGetParams {
	o.SetAliasesMapping(aliasesMapping)
	return o
}

// SetAliasesMapping adds the aliasesMapping to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetAliasesMapping(aliasesMapping *string) {
	o.AliasesMapping = aliasesMapping
}

// WithAliasesName adds the aliasesName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithAliasesName(aliasesName *string) *TapeDeviceCollectionGetParams {
	o.SetAliasesName(aliasesName)
	return o
}

// SetAliasesName adds the aliasesName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetAliasesName(aliasesName *string) {
	o.AliasesName = aliasesName
}

// WithBlockNumber adds the blockNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithBlockNumber(blockNumber *int64) *TapeDeviceCollectionGetParams {
	o.SetBlockNumber(blockNumber)
	return o
}

// SetBlockNumber adds the blockNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetBlockNumber(blockNumber *int64) {
	o.BlockNumber = blockNumber
}

// WithDensity adds the density to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDensity(density *string) *TapeDeviceCollectionGetParams {
	o.SetDensity(density)
	return o
}

// SetDensity adds the density to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDensity(density *string) {
	o.Density = density
}

// WithDescription adds the description to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDescription(description *string) *TapeDeviceCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithDeviceID adds the deviceID to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDeviceID(deviceID *string) *TapeDeviceCollectionGetParams {
	o.SetDeviceID(deviceID)
	return o
}

// SetDeviceID adds the deviceId to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDeviceID(deviceID *string) {
	o.DeviceID = deviceID
}

// WithDeviceNamesNoRewindDevice adds the deviceNamesNoRewindDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDeviceNamesNoRewindDevice(deviceNamesNoRewindDevice *string) *TapeDeviceCollectionGetParams {
	o.SetDeviceNamesNoRewindDevice(deviceNamesNoRewindDevice)
	return o
}

// SetDeviceNamesNoRewindDevice adds the deviceNamesNoRewindDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDeviceNamesNoRewindDevice(deviceNamesNoRewindDevice *string) {
	o.DeviceNamesNoRewindDevice = deviceNamesNoRewindDevice
}

// WithDeviceNamesRewindDevice adds the deviceNamesRewindDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDeviceNamesRewindDevice(deviceNamesRewindDevice *string) *TapeDeviceCollectionGetParams {
	o.SetDeviceNamesRewindDevice(deviceNamesRewindDevice)
	return o
}

// SetDeviceNamesRewindDevice adds the deviceNamesRewindDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDeviceNamesRewindDevice(deviceNamesRewindDevice *string) {
	o.DeviceNamesRewindDevice = deviceNamesRewindDevice
}

// WithDeviceNamesUnloadReloadDevice adds the deviceNamesUnloadReloadDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDeviceNamesUnloadReloadDevice(deviceNamesUnloadReloadDevice *string) *TapeDeviceCollectionGetParams {
	o.SetDeviceNamesUnloadReloadDevice(deviceNamesUnloadReloadDevice)
	return o
}

// SetDeviceNamesUnloadReloadDevice adds the deviceNamesUnloadReloadDevice to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDeviceNamesUnloadReloadDevice(deviceNamesUnloadReloadDevice *string) {
	o.DeviceNamesUnloadReloadDevice = deviceNamesUnloadReloadDevice
}

// WithDeviceState adds the deviceState to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithDeviceState(deviceState *string) *TapeDeviceCollectionGetParams {
	o.SetDeviceState(deviceState)
	return o
}

// SetDeviceState adds the deviceState to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetDeviceState(deviceState *string) {
	o.DeviceState = deviceState
}

// WithFields adds the fields to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithFields(fields []string) *TapeDeviceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFileNumber adds the fileNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithFileNumber(fileNumber *int64) *TapeDeviceCollectionGetParams {
	o.SetFileNumber(fileNumber)
	return o
}

// SetFileNumber adds the fileNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetFileNumber(fileNumber *int64) {
	o.FileNumber = fileNumber
}

// WithFormats adds the formats to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithFormats(formats *string) *TapeDeviceCollectionGetParams {
	o.SetFormats(formats)
	return o
}

// SetFormats adds the formats to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetFormats(formats *string) {
	o.Formats = formats
}

// WithInterface adds the interfaceVar to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithInterface(interfaceVar *string) *TapeDeviceCollectionGetParams {
	o.SetInterface(interfaceVar)
	return o
}

// SetInterface adds the interface to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetInterface(interfaceVar *string) {
	o.Interface = interfaceVar
}

// WithMaxRecords adds the maxRecords to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithMaxRecords(maxRecords *int64) *TapeDeviceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithNodeName(nodeName *string) *TapeDeviceCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithNodeUUID(nodeUUID *string) *TapeDeviceCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOnline adds the online to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithOnline(online *bool) *TapeDeviceCollectionGetParams {
	o.SetOnline(online)
	return o
}

// SetOnline adds the online to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetOnline(online *bool) {
	o.Online = online
}

// WithOrderBy adds the orderBy to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithOrderBy(orderBy []string) *TapeDeviceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReservationType adds the reservationType to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithReservationType(reservationType *string) *TapeDeviceCollectionGetParams {
	o.SetReservationType(reservationType)
	return o
}

// SetReservationType adds the reservationType to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetReservationType(reservationType *string) {
	o.ReservationType = reservationType
}

// WithResidualCount adds the residualCount to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithResidualCount(residualCount *int64) *TapeDeviceCollectionGetParams {
	o.SetResidualCount(residualCount)
	return o
}

// SetResidualCount adds the residualCount to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetResidualCount(residualCount *int64) {
	o.ResidualCount = residualCount
}

// WithReturnRecords adds the returnRecords to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithReturnRecords(returnRecords *bool) *TapeDeviceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *TapeDeviceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithSerialNumber(serialNumber *string) *TapeDeviceCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithStoragePortName adds the storagePortName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithStoragePortName(storagePortName *string) *TapeDeviceCollectionGetParams {
	o.SetStoragePortName(storagePortName)
	return o
}

// SetStoragePortName adds the storagePortName to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetStoragePortName(storagePortName *string) {
	o.StoragePortName = storagePortName
}

// WithType adds the typeVar to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithType(typeVar *string) *TapeDeviceCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithWwnn adds the wwnn to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithWwnn(wwnn *string) *TapeDeviceCollectionGetParams {
	o.SetWwnn(wwnn)
	return o
}

// SetWwnn adds the wwnn to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetWwnn(wwnn *string) {
	o.Wwnn = wwnn
}

// WithWwpn adds the wwpn to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) WithWwpn(wwpn *string) *TapeDeviceCollectionGetParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the tape device collection get params
func (o *TapeDeviceCollectionGetParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *TapeDeviceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AliasMapping != nil {

		// query param alias.mapping
		var qrAliasMapping string

		if o.AliasMapping != nil {
			qrAliasMapping = *o.AliasMapping
		}
		qAliasMapping := qrAliasMapping
		if qAliasMapping != "" {

			if err := r.SetQueryParam("alias.mapping", qAliasMapping); err != nil {
				return err
			}
		}
	}

	if o.AliasName != nil {

		// query param alias.name
		var qrAliasName string

		if o.AliasName != nil {
			qrAliasName = *o.AliasName
		}
		qAliasName := qrAliasName
		if qAliasName != "" {

			if err := r.SetQueryParam("alias.name", qAliasName); err != nil {
				return err
			}
		}
	}

	if o.AliasesMapping != nil {

		// query param aliases.mapping
		var qrAliasesMapping string

		if o.AliasesMapping != nil {
			qrAliasesMapping = *o.AliasesMapping
		}
		qAliasesMapping := qrAliasesMapping
		if qAliasesMapping != "" {

			if err := r.SetQueryParam("aliases.mapping", qAliasesMapping); err != nil {
				return err
			}
		}
	}

	if o.AliasesName != nil {

		// query param aliases.name
		var qrAliasesName string

		if o.AliasesName != nil {
			qrAliasesName = *o.AliasesName
		}
		qAliasesName := qrAliasesName
		if qAliasesName != "" {

			if err := r.SetQueryParam("aliases.name", qAliasesName); err != nil {
				return err
			}
		}
	}

	if o.BlockNumber != nil {

		// query param block_number
		var qrBlockNumber int64

		if o.BlockNumber != nil {
			qrBlockNumber = *o.BlockNumber
		}
		qBlockNumber := swag.FormatInt64(qrBlockNumber)
		if qBlockNumber != "" {

			if err := r.SetQueryParam("block_number", qBlockNumber); err != nil {
				return err
			}
		}
	}

	if o.Density != nil {

		// query param density
		var qrDensity string

		if o.Density != nil {
			qrDensity = *o.Density
		}
		qDensity := qrDensity
		if qDensity != "" {

			if err := r.SetQueryParam("density", qDensity); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.DeviceID != nil {

		// query param device_id
		var qrDeviceID string

		if o.DeviceID != nil {
			qrDeviceID = *o.DeviceID
		}
		qDeviceID := qrDeviceID
		if qDeviceID != "" {

			if err := r.SetQueryParam("device_id", qDeviceID); err != nil {
				return err
			}
		}
	}

	if o.DeviceNamesNoRewindDevice != nil {

		// query param device_names.no_rewind_device
		var qrDeviceNamesNoRewindDevice string

		if o.DeviceNamesNoRewindDevice != nil {
			qrDeviceNamesNoRewindDevice = *o.DeviceNamesNoRewindDevice
		}
		qDeviceNamesNoRewindDevice := qrDeviceNamesNoRewindDevice
		if qDeviceNamesNoRewindDevice != "" {

			if err := r.SetQueryParam("device_names.no_rewind_device", qDeviceNamesNoRewindDevice); err != nil {
				return err
			}
		}
	}

	if o.DeviceNamesRewindDevice != nil {

		// query param device_names.rewind_device
		var qrDeviceNamesRewindDevice string

		if o.DeviceNamesRewindDevice != nil {
			qrDeviceNamesRewindDevice = *o.DeviceNamesRewindDevice
		}
		qDeviceNamesRewindDevice := qrDeviceNamesRewindDevice
		if qDeviceNamesRewindDevice != "" {

			if err := r.SetQueryParam("device_names.rewind_device", qDeviceNamesRewindDevice); err != nil {
				return err
			}
		}
	}

	if o.DeviceNamesUnloadReloadDevice != nil {

		// query param device_names.unload_reload_device
		var qrDeviceNamesUnloadReloadDevice string

		if o.DeviceNamesUnloadReloadDevice != nil {
			qrDeviceNamesUnloadReloadDevice = *o.DeviceNamesUnloadReloadDevice
		}
		qDeviceNamesUnloadReloadDevice := qrDeviceNamesUnloadReloadDevice
		if qDeviceNamesUnloadReloadDevice != "" {

			if err := r.SetQueryParam("device_names.unload_reload_device", qDeviceNamesUnloadReloadDevice); err != nil {
				return err
			}
		}
	}

	if o.DeviceState != nil {

		// query param device_state
		var qrDeviceState string

		if o.DeviceState != nil {
			qrDeviceState = *o.DeviceState
		}
		qDeviceState := qrDeviceState
		if qDeviceState != "" {

			if err := r.SetQueryParam("device_state", qDeviceState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FileNumber != nil {

		// query param file_number
		var qrFileNumber int64

		if o.FileNumber != nil {
			qrFileNumber = *o.FileNumber
		}
		qFileNumber := swag.FormatInt64(qrFileNumber)
		if qFileNumber != "" {

			if err := r.SetQueryParam("file_number", qFileNumber); err != nil {
				return err
			}
		}
	}

	if o.Formats != nil {

		// query param formats
		var qrFormats string

		if o.Formats != nil {
			qrFormats = *o.Formats
		}
		qFormats := qrFormats
		if qFormats != "" {

			if err := r.SetQueryParam("formats", qFormats); err != nil {
				return err
			}
		}
	}

	if o.Interface != nil {

		// query param interface
		var qrInterface string

		if o.Interface != nil {
			qrInterface = *o.Interface
		}
		qInterface := qrInterface
		if qInterface != "" {

			if err := r.SetQueryParam("interface", qInterface); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.Online != nil {

		// query param online
		var qrOnline bool

		if o.Online != nil {
			qrOnline = *o.Online
		}
		qOnline := swag.FormatBool(qrOnline)
		if qOnline != "" {

			if err := r.SetQueryParam("online", qOnline); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReservationType != nil {

		// query param reservation_type
		var qrReservationType string

		if o.ReservationType != nil {
			qrReservationType = *o.ReservationType
		}
		qReservationType := qrReservationType
		if qReservationType != "" {

			if err := r.SetQueryParam("reservation_type", qReservationType); err != nil {
				return err
			}
		}
	}

	if o.ResidualCount != nil {

		// query param residual_count
		var qrResidualCount int64

		if o.ResidualCount != nil {
			qrResidualCount = *o.ResidualCount
		}
		qResidualCount := swag.FormatInt64(qrResidualCount)
		if qResidualCount != "" {

			if err := r.SetQueryParam("residual_count", qResidualCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.StoragePortName != nil {

		// query param storage_port.name
		var qrStoragePortName string

		if o.StoragePortName != nil {
			qrStoragePortName = *o.StoragePortName
		}
		qStoragePortName := qrStoragePortName
		if qStoragePortName != "" {

			if err := r.SetQueryParam("storage_port.name", qStoragePortName); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.Wwnn != nil {

		// query param wwnn
		var qrWwnn string

		if o.Wwnn != nil {
			qrWwnn = *o.Wwnn
		}
		qWwnn := qrWwnn
		if qWwnn != "" {

			if err := r.SetQueryParam("wwnn", qWwnn); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTapeDeviceCollectionGet binds the parameter fields
func (o *TapeDeviceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamTapeDeviceCollectionGet binds the parameter order_by
func (o *TapeDeviceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
