// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTapeDeviceGetParams creates a new TapeDeviceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTapeDeviceGetParams() *TapeDeviceGetParams {
	return &TapeDeviceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTapeDeviceGetParamsWithTimeout creates a new TapeDeviceGetParams object
// with the ability to set a timeout on a request.
func NewTapeDeviceGetParamsWithTimeout(timeout time.Duration) *TapeDeviceGetParams {
	return &TapeDeviceGetParams{
		timeout: timeout,
	}
}

// NewTapeDeviceGetParamsWithContext creates a new TapeDeviceGetParams object
// with the ability to set a context for a request.
func NewTapeDeviceGetParamsWithContext(ctx context.Context) *TapeDeviceGetParams {
	return &TapeDeviceGetParams{
		Context: ctx,
	}
}

// NewTapeDeviceGetParamsWithHTTPClient creates a new TapeDeviceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTapeDeviceGetParamsWithHTTPClient(client *http.Client) *TapeDeviceGetParams {
	return &TapeDeviceGetParams{
		HTTPClient: client,
	}
}

/*
TapeDeviceGetParams contains all the parameters to send to the API endpoint

	for the tape device get operation.

	Typically these are written to a http.Request.
*/
type TapeDeviceGetParams struct {

	/* DeviceID.

	   Device ID
	*/
	DeviceID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tape device get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceGetParams) WithDefaults() *TapeDeviceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tape device get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the tape device get params
func (o *TapeDeviceGetParams) WithTimeout(timeout time.Duration) *TapeDeviceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tape device get params
func (o *TapeDeviceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tape device get params
func (o *TapeDeviceGetParams) WithContext(ctx context.Context) *TapeDeviceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tape device get params
func (o *TapeDeviceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tape device get params
func (o *TapeDeviceGetParams) WithHTTPClient(client *http.Client) *TapeDeviceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tape device get params
func (o *TapeDeviceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeviceID adds the deviceID to the tape device get params
func (o *TapeDeviceGetParams) WithDeviceID(deviceID string) *TapeDeviceGetParams {
	o.SetDeviceID(deviceID)
	return o
}

// SetDeviceID adds the deviceId to the tape device get params
func (o *TapeDeviceGetParams) SetDeviceID(deviceID string) {
	o.DeviceID = deviceID
}

// WithFields adds the fields to the tape device get params
func (o *TapeDeviceGetParams) WithFields(fields []string) *TapeDeviceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the tape device get params
func (o *TapeDeviceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithNodeUUID adds the nodeUUID to the tape device get params
func (o *TapeDeviceGetParams) WithNodeUUID(nodeUUID string) *TapeDeviceGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the tape device get params
func (o *TapeDeviceGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *TapeDeviceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param device_id
	if err := r.SetPathParam("device_id", o.DeviceID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTapeDeviceGet binds the parameter fields
func (o *TapeDeviceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
