// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TapeDeviceModifyCollectionReader is a Reader for the TapeDeviceModifyCollection structure.
type TapeDeviceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TapeDeviceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTapeDeviceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewTapeDeviceModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTapeDeviceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTapeDeviceModifyCollectionOK creates a TapeDeviceModifyCollectionOK with default headers values
func NewTapeDeviceModifyCollectionOK() *TapeDeviceModifyCollectionOK {
	return &TapeDeviceModifyCollectionOK{}
}

/*
TapeDeviceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type TapeDeviceModifyCollectionOK struct {
}

// IsSuccess returns true when this tape device modify collection o k response has a 2xx status code
func (o *TapeDeviceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tape device modify collection o k response has a 3xx status code
func (o *TapeDeviceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tape device modify collection o k response has a 4xx status code
func (o *TapeDeviceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tape device modify collection o k response has a 5xx status code
func (o *TapeDeviceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tape device modify collection o k response a status code equal to that given
func (o *TapeDeviceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tape device modify collection o k response
func (o *TapeDeviceModifyCollectionOK) Code() int {
	return 200
}

func (o *TapeDeviceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tapeDeviceModifyCollectionOK", 200)
}

func (o *TapeDeviceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tapeDeviceModifyCollectionOK", 200)
}

func (o *TapeDeviceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTapeDeviceModifyCollectionAccepted creates a TapeDeviceModifyCollectionAccepted with default headers values
func NewTapeDeviceModifyCollectionAccepted() *TapeDeviceModifyCollectionAccepted {
	return &TapeDeviceModifyCollectionAccepted{}
}

/*
TapeDeviceModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type TapeDeviceModifyCollectionAccepted struct {
	Payload *models.TapeDeviceJobLinkResponse
}

// IsSuccess returns true when this tape device modify collection accepted response has a 2xx status code
func (o *TapeDeviceModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tape device modify collection accepted response has a 3xx status code
func (o *TapeDeviceModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tape device modify collection accepted response has a 4xx status code
func (o *TapeDeviceModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this tape device modify collection accepted response has a 5xx status code
func (o *TapeDeviceModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this tape device modify collection accepted response a status code equal to that given
func (o *TapeDeviceModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the tape device modify collection accepted response
func (o *TapeDeviceModifyCollectionAccepted) Code() int {
	return 202
}

func (o *TapeDeviceModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tapeDeviceModifyCollectionAccepted %s", 202, payload)
}

func (o *TapeDeviceModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tapeDeviceModifyCollectionAccepted %s", 202, payload)
}

func (o *TapeDeviceModifyCollectionAccepted) GetPayload() *models.TapeDeviceJobLinkResponse {
	return o.Payload
}

func (o *TapeDeviceModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.TapeDeviceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTapeDeviceModifyCollectionDefault creates a TapeDeviceModifyCollectionDefault with default headers values
func NewTapeDeviceModifyCollectionDefault(code int) *TapeDeviceModifyCollectionDefault {
	return &TapeDeviceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	TapeDeviceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 11403264 | Tape operation \"<operation>\" failed on tape device \"<device_id>\". This may indicate tape reached end of data, a hardware error, an illegal request, an invalid name format, or an aborted command. |
| 11403265 | Tape operation  \"<operation>\" failed because it encountered an unexpected file mark on tape device \"<device_id>\". |
| 11403266 | Internal error. Unknown tape parameter for tape device \"<device_id>\". |
| 11403267 | Tape device \"<device_id>\" is busy. |
| 11403268 | No tape loaded for \"<operation>\" operation on tape drive \"<device_id>\". |
| 11403269 | Tape device \"<device_id>\" unknown. |
| 11403270 | Tape alias name \"<alias>\" already exists. |
| 11403271 | The format of the tape alias name \"<alias>\" is invalid. Use \"st\" or \"mc\" followed by one or more digits. |
| 11403273 | Internal error. Tape alias name \"<alias>\" not saved. |
| 11403274 | Internal error. Tape alias operation \"<operation>\" for alias name \"<alias>\" failed. |
| 11403275 | Tape alias name \"<alias>\" not found. |
| 11403277 | Tape device \"<device_id>\" is reserved by another host. |
| 11403278 | Invalid count value specified with operation \"<operation>\". Valid values are from 0 to {1}. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TapeDeviceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tape device modify collection default response has a 2xx status code
func (o *TapeDeviceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this tape device modify collection default response has a 3xx status code
func (o *TapeDeviceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this tape device modify collection default response has a 4xx status code
func (o *TapeDeviceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this tape device modify collection default response has a 5xx status code
func (o *TapeDeviceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this tape device modify collection default response a status code equal to that given
func (o *TapeDeviceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the tape device modify collection default response
func (o *TapeDeviceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *TapeDeviceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tape_device_modify_collection default %s", o._statusCode, payload)
}

func (o *TapeDeviceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices][%d] tape_device_modify_collection default %s", o._statusCode, payload)
}

func (o *TapeDeviceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TapeDeviceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
TapeDeviceModifyCollectionBody tape device modify collection body
swagger:model TapeDeviceModifyCollectionBody
*/
type TapeDeviceModifyCollectionBody struct {

	// alias
	Alias *models.TapeDeviceInlineAlias `json:"alias,omitempty"`

	// Block number.
	// Example: 0
	// Read Only: true
	BlockNumber *int64 `json:"block_number,omitempty"`

	// Density.
	// Example: low
	// Read Only: true
	// Enum: ["low","medium","high","extended"]
	Density *string `json:"density,omitempty"`

	// description
	// Example: QUANTUM LTO-8 ULTRIUM
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// device id
	// Example: 1a.0
	// Read Only: true
	DeviceID *string `json:"device_id,omitempty"`

	// Operational state of the device.
	// Example: read_write_enabled
	// Read Only: true
	// Enum: ["unknown","available","ready_write_enabled","ready_write_protected","offline","in_use","error","reserved_by_another_host","normal","rewinding","erasing"]
	DeviceState *string `json:"device_state,omitempty"`

	// File number.
	// Example: 0
	// Read Only: true
	FileNumber *int64 `json:"file_number,omitempty"`

	// Device interface type.
	// Example: sas
	// Read Only: true
	// Enum: ["unknown","fibre_channel","sas","pscsi"]
	Interface *string `json:"interface,omitempty"`

	// node
	Node *models.TapeDeviceInlineNode `json:"node,omitempty"`

	// online
	Online *bool `json:"online,omitempty"`

	// position
	Position *models.TapeDeviceInlinePosition `json:"position,omitempty"`

	// reservation type
	// Example: off
	// Read Only: true
	// Enum: ["off","persistent","scsi"]
	ReservationType *string `json:"reservation_type,omitempty"`

	// Residual count of the last I/O operation.
	// Example: 0
	// Read Only: true
	ResidualCount *int64 `json:"residual_count,omitempty"`

	// serial number
	// Example: 10WT00093
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// storage port
	StoragePort *models.TapeDeviceInlineStoragePort `json:"storage_port,omitempty"`

	// tape device inline aliases
	TapeDeviceInlineAliases []*models.TapeDeviceInlineAliasesInlineArrayItem `json:"aliases,omitempty"`

	// tape device inline device names
	// Read Only: true
	TapeDeviceInlineDeviceNames []*models.TapeDeviceInlineDeviceNamesInlineArrayItem `json:"device_names,omitempty"`

	// Tape cartridge format.
	// Example: ["LTO-7 6TB","LTO-7 15TB Compressed","LTO-8 12TB","LTO-8 30TB Compressed"]
	// Read Only: true
	TapeDeviceInlineFormats []*string `json:"formats,omitempty"`

	// tape device response inline records
	TapeDeviceResponseInlineRecords []*models.TapeDevice `json:"records,omitempty"`

	// Device type.
	// Example: tape
	// Read Only: true
	// Enum: ["unknown","tape","media_changer"]
	Type *string `json:"type,omitempty"`

	// World Wide Node Name.
	// Example: 500507631295741c
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// World Wide Port Name.
	// Example: 500507631295741c
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this tape device modify collection body
func (o *TapeDeviceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAlias(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDensity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDeviceState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePosition(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReservationType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTapeDeviceInlineAliases(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTapeDeviceInlineDeviceNames(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTapeDeviceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateAlias(formats strfmt.Registry) error {
	if swag.IsZero(o.Alias) { // not required
		return nil
	}

	if o.Alias != nil {
		if err := o.Alias.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "alias")
			}
			return err
		}
	}

	return nil
}

var tapeDeviceModifyCollectionBodyTypeDensityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["low","medium","high","extended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceModifyCollectionBodyTypeDensityPropEnum = append(tapeDeviceModifyCollectionBodyTypeDensityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// density
	// Density
	// low
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDensityLow captures enum value "low"
	TapeDeviceModifyCollectionBodyDensityLow string = "low"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// density
	// Density
	// medium
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDensityMedium captures enum value "medium"
	TapeDeviceModifyCollectionBodyDensityMedium string = "medium"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// density
	// Density
	// high
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDensityHigh captures enum value "high"
	TapeDeviceModifyCollectionBodyDensityHigh string = "high"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// density
	// Density
	// extended
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDensityExtended captures enum value "extended"
	TapeDeviceModifyCollectionBodyDensityExtended string = "extended"
)

// prop value enum
func (o *TapeDeviceModifyCollectionBody) validateDensityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceModifyCollectionBodyTypeDensityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateDensity(formats strfmt.Registry) error {
	if swag.IsZero(o.Density) { // not required
		return nil
	}

	// value enum
	if err := o.validateDensityEnum("info"+"."+"density", "body", *o.Density); err != nil {
		return err
	}

	return nil
}

var tapeDeviceModifyCollectionBodyTypeDeviceStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","available","ready_write_enabled","ready_write_protected","offline","in_use","error","reserved_by_another_host","normal","rewinding","erasing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceModifyCollectionBodyTypeDeviceStatePropEnum = append(tapeDeviceModifyCollectionBodyTypeDeviceStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// unknown
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateUnknown captures enum value "unknown"
	TapeDeviceModifyCollectionBodyDeviceStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// available
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateAvailable captures enum value "available"
	TapeDeviceModifyCollectionBodyDeviceStateAvailable string = "available"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// ready_write_enabled
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateReadyWriteEnabled captures enum value "ready_write_enabled"
	TapeDeviceModifyCollectionBodyDeviceStateReadyWriteEnabled string = "ready_write_enabled"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// ready_write_protected
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateReadyWriteProtected captures enum value "ready_write_protected"
	TapeDeviceModifyCollectionBodyDeviceStateReadyWriteProtected string = "ready_write_protected"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// offline
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateOffline captures enum value "offline"
	TapeDeviceModifyCollectionBodyDeviceStateOffline string = "offline"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// in_use
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateInUse captures enum value "in_use"
	TapeDeviceModifyCollectionBodyDeviceStateInUse string = "in_use"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// error
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateError captures enum value "error"
	TapeDeviceModifyCollectionBodyDeviceStateError string = "error"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// reserved_by_another_host
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateReservedByAnotherHost captures enum value "reserved_by_another_host"
	TapeDeviceModifyCollectionBodyDeviceStateReservedByAnotherHost string = "reserved_by_another_host"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// normal
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateNormal captures enum value "normal"
	TapeDeviceModifyCollectionBodyDeviceStateNormal string = "normal"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// rewinding
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateRewinding captures enum value "rewinding"
	TapeDeviceModifyCollectionBodyDeviceStateRewinding string = "rewinding"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// device_state
	// DeviceState
	// erasing
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyDeviceStateErasing captures enum value "erasing"
	TapeDeviceModifyCollectionBodyDeviceStateErasing string = "erasing"
)

// prop value enum
func (o *TapeDeviceModifyCollectionBody) validateDeviceStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceModifyCollectionBodyTypeDeviceStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateDeviceState(formats strfmt.Registry) error {
	if swag.IsZero(o.DeviceState) { // not required
		return nil
	}

	// value enum
	if err := o.validateDeviceStateEnum("info"+"."+"device_state", "body", *o.DeviceState); err != nil {
		return err
	}

	return nil
}

var tapeDeviceModifyCollectionBodyTypeInterfacePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","fibre_channel","sas","pscsi"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceModifyCollectionBodyTypeInterfacePropEnum = append(tapeDeviceModifyCollectionBodyTypeInterfacePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// interface
	// Interface
	// unknown
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyInterfaceUnknown captures enum value "unknown"
	TapeDeviceModifyCollectionBodyInterfaceUnknown string = "unknown"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// interface
	// Interface
	// fibre_channel
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyInterfaceFibreChannel captures enum value "fibre_channel"
	TapeDeviceModifyCollectionBodyInterfaceFibreChannel string = "fibre_channel"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// interface
	// Interface
	// sas
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyInterfaceSas captures enum value "sas"
	TapeDeviceModifyCollectionBodyInterfaceSas string = "sas"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// interface
	// Interface
	// pscsi
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyInterfacePscsi captures enum value "pscsi"
	TapeDeviceModifyCollectionBodyInterfacePscsi string = "pscsi"
)

// prop value enum
func (o *TapeDeviceModifyCollectionBody) validateInterfaceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceModifyCollectionBodyTypeInterfacePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.Interface) { // not required
		return nil
	}

	// value enum
	if err := o.validateInterfaceEnum("info"+"."+"interface", "body", *o.Interface); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validatePosition(formats strfmt.Registry) error {
	if swag.IsZero(o.Position) { // not required
		return nil
	}

	if o.Position != nil {
		if err := o.Position.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "position")
			}
			return err
		}
	}

	return nil
}

var tapeDeviceModifyCollectionBodyTypeReservationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","persistent","scsi"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceModifyCollectionBodyTypeReservationTypePropEnum = append(tapeDeviceModifyCollectionBodyTypeReservationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// reservation_type
	// ReservationType
	// off
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyReservationTypeOff captures enum value "off"
	TapeDeviceModifyCollectionBodyReservationTypeOff string = "off"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// reservation_type
	// ReservationType
	// persistent
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyReservationTypePersistent captures enum value "persistent"
	TapeDeviceModifyCollectionBodyReservationTypePersistent string = "persistent"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// reservation_type
	// ReservationType
	// scsi
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyReservationTypeScsi captures enum value "scsi"
	TapeDeviceModifyCollectionBodyReservationTypeScsi string = "scsi"
)

// prop value enum
func (o *TapeDeviceModifyCollectionBody) validateReservationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceModifyCollectionBodyTypeReservationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateReservationType(formats strfmt.Registry) error {
	if swag.IsZero(o.ReservationType) { // not required
		return nil
	}

	// value enum
	if err := o.validateReservationTypeEnum("info"+"."+"reservation_type", "body", *o.ReservationType); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateStoragePort(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePort) { // not required
		return nil
	}

	if o.StoragePort != nil {
		if err := o.StoragePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_port")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateTapeDeviceInlineAliases(formats strfmt.Registry) error {
	if swag.IsZero(o.TapeDeviceInlineAliases) { // not required
		return nil
	}

	for i := 0; i < len(o.TapeDeviceInlineAliases); i++ {
		if swag.IsZero(o.TapeDeviceInlineAliases[i]) { // not required
			continue
		}

		if o.TapeDeviceInlineAliases[i] != nil {
			if err := o.TapeDeviceInlineAliases[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aliases" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateTapeDeviceInlineDeviceNames(formats strfmt.Registry) error {
	if swag.IsZero(o.TapeDeviceInlineDeviceNames) { // not required
		return nil
	}

	for i := 0; i < len(o.TapeDeviceInlineDeviceNames); i++ {
		if swag.IsZero(o.TapeDeviceInlineDeviceNames[i]) { // not required
			continue
		}

		if o.TapeDeviceInlineDeviceNames[i] != nil {
			if err := o.TapeDeviceInlineDeviceNames[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "device_names" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateTapeDeviceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.TapeDeviceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.TapeDeviceResponseInlineRecords); i++ {
		if swag.IsZero(o.TapeDeviceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.TapeDeviceResponseInlineRecords[i] != nil {
			if err := o.TapeDeviceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var tapeDeviceModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","tape","media_changer"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceModifyCollectionBodyTypeTypePropEnum = append(tapeDeviceModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// type
	// Type
	// unknown
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyTypeUnknown captures enum value "unknown"
	TapeDeviceModifyCollectionBodyTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// type
	// Type
	// tape
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyTypeTape captures enum value "tape"
	TapeDeviceModifyCollectionBodyTypeTape string = "tape"

	// BEGIN DEBUGGING
	// TapeDeviceModifyCollectionBody
	// TapeDeviceModifyCollectionBody
	// type
	// Type
	// media_changer
	// END DEBUGGING
	// TapeDeviceModifyCollectionBodyTypeMediaChanger captures enum value "media_changer"
	TapeDeviceModifyCollectionBodyTypeMediaChanger string = "media_changer"
)

// prop value enum
func (o *TapeDeviceModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this tape device modify collection body based on the context it is used
func (o *TapeDeviceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAlias(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDensity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDeviceState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePosition(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReservationType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResidualCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTapeDeviceInlineAliases(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTapeDeviceInlineDeviceNames(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTapeDeviceInlineFormats(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTapeDeviceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateAlias(ctx context.Context, formats strfmt.Registry) error {

	if o.Alias != nil {
		if err := o.Alias.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "alias")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateBlockNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_number", "body", o.BlockNumber); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateDensity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"density", "body", o.Density); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"device_id", "body", o.DeviceID); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateDeviceState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"device_state", "body", o.DeviceState); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateFileNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"file_number", "body", o.FileNumber); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"interface", "body", o.Interface); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidatePosition(ctx context.Context, formats strfmt.Registry) error {

	if o.Position != nil {
		if err := o.Position.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "position")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateReservationType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reservation_type", "body", o.ReservationType); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateResidualCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"residual_count", "body", o.ResidualCount); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateStoragePort(ctx context.Context, formats strfmt.Registry) error {

	if o.StoragePort != nil {
		if err := o.StoragePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_port")
			}
			return err
		}
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateTapeDeviceInlineAliases(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.TapeDeviceInlineAliases); i++ {

		if o.TapeDeviceInlineAliases[i] != nil {
			if err := o.TapeDeviceInlineAliases[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aliases" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateTapeDeviceInlineDeviceNames(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"device_names", "body", []*models.TapeDeviceInlineDeviceNamesInlineArrayItem(o.TapeDeviceInlineDeviceNames)); err != nil {
		return err
	}

	for i := 0; i < len(o.TapeDeviceInlineDeviceNames); i++ {

		if o.TapeDeviceInlineDeviceNames[i] != nil {
			if err := o.TapeDeviceInlineDeviceNames[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "device_names" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateTapeDeviceInlineFormats(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"formats", "body", []*string(o.TapeDeviceInlineFormats)); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateTapeDeviceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.TapeDeviceResponseInlineRecords); i++ {

		if o.TapeDeviceResponseInlineRecords[i] != nil {
			if err := o.TapeDeviceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwnn", "body", o.Wwnn); err != nil {
		return err
	}

	return nil
}

func (o *TapeDeviceModifyCollectionBody) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwpn", "body", o.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res TapeDeviceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineAlias tape device inline alias
swagger:model tape_device_inline_alias
*/
type TapeDeviceInlineAlias struct {

	// This field will no longer be supported in a future release. Use aliases.mapping instead.
	// Example: SN[10WT000933]
	Mapping *string `json:"mapping,omitempty"`

	// This field will no longer be supported in a future release. Use aliases.name instead.
	// Example: st6
	Name *string `json:"name,omitempty"`
}

// Validate validates this tape device inline alias
func (o *TapeDeviceInlineAlias) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this tape device inline alias based on the context it is used
func (o *TapeDeviceInlineAlias) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineAlias) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineAlias) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineAlias
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineAliasesInlineArrayItem tape device inline aliases inline array item
swagger:model tape_device_inline_aliases_inline_array_item
*/
type TapeDeviceInlineAliasesInlineArrayItem struct {

	// Alias mapping.
	// Example: SN[10WT000933]
	// Read Only: true
	Mapping *string `json:"mapping,omitempty"`

	// Alias name.
	// Example: st6
	Name *string `json:"name,omitempty"`
}

// Validate validates this tape device inline aliases inline array item
func (o *TapeDeviceInlineAliasesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this tape device inline aliases inline array item based on the context it is used
func (o *TapeDeviceInlineAliasesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMapping(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceInlineAliasesInlineArrayItem) contextValidateMapping(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mapping", "body", o.Mapping); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineAliasesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineAliasesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineAliasesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineDeviceNamesInlineArrayItem tape device inline device names inline array item
swagger:model tape_device_inline_device_names_inline_array_item
*/
type TapeDeviceInlineDeviceNamesInlineArrayItem struct {

	// Device name for no rewind.
	// Example: nrst6l
	NoRewindDevice *string `json:"no_rewind_device,omitempty"`

	// Device name for rewind.
	// Example: rst6l
	RewindDevice *string `json:"rewind_device,omitempty"`

	// Device name for unload or reload operations.
	// Example: urst6l
	UnloadReloadDevice *string `json:"unload_reload_device,omitempty"`
}

// Validate validates this tape device inline device names inline array item
func (o *TapeDeviceInlineDeviceNamesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this tape device inline device names inline array item based on context it is used
func (o *TapeDeviceInlineDeviceNamesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineDeviceNamesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineDeviceNamesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineDeviceNamesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineNode tape device inline node
swagger:model tape_device_inline_node
*/
type TapeDeviceInlineNode struct {

	// links
	Links *models.TapeDeviceInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this tape device inline node
func (o *TapeDeviceInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this tape device inline node based on the context it is used
func (o *TapeDeviceInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineNode) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineNodeInlineLinks tape device inline node inline links
swagger:model tape_device_inline_node_inline__links
*/
type TapeDeviceInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this tape device inline node inline links
func (o *TapeDeviceInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this tape device inline node inline links based on the context it is used
func (o *TapeDeviceInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TapeDeviceInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlinePosition tape device inline position
swagger:model tape_device_inline_position
*/
type TapeDeviceInlinePosition struct {

	// Number of times to run position operation.
	// Example: 5
	Count *int64 `json:"count,omitempty"`

	// Position operation.
	// Example: rewind
	// Enum: ["weof","fsf","bsf","fsr","bsr","rewind","erase","eom"]
	Operation *string `json:"operation,omitempty"`
}

// Validate validates this tape device inline position
func (o *TapeDeviceInlinePosition) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateOperation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tapeDeviceInlinePositionTypeOperationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["weof","fsf","bsf","fsr","bsr","rewind","erase","eom"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tapeDeviceInlinePositionTypeOperationPropEnum = append(tapeDeviceInlinePositionTypeOperationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// weof
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationWeof captures enum value "weof"
	TapeDeviceInlinePositionOperationWeof string = "weof"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// fsf
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationFsf captures enum value "fsf"
	TapeDeviceInlinePositionOperationFsf string = "fsf"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// bsf
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationBsf captures enum value "bsf"
	TapeDeviceInlinePositionOperationBsf string = "bsf"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// fsr
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationFsr captures enum value "fsr"
	TapeDeviceInlinePositionOperationFsr string = "fsr"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// bsr
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationBsr captures enum value "bsr"
	TapeDeviceInlinePositionOperationBsr string = "bsr"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// rewind
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationRewind captures enum value "rewind"
	TapeDeviceInlinePositionOperationRewind string = "rewind"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// erase
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationErase captures enum value "erase"
	TapeDeviceInlinePositionOperationErase string = "erase"

	// BEGIN DEBUGGING
	// tape_device_inline_position
	// TapeDeviceInlinePosition
	// operation
	// Operation
	// eom
	// END DEBUGGING
	// TapeDeviceInlinePositionOperationEom captures enum value "eom"
	TapeDeviceInlinePositionOperationEom string = "eom"
)

// prop value enum
func (o *TapeDeviceInlinePosition) validateOperationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tapeDeviceInlinePositionTypeOperationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *TapeDeviceInlinePosition) validateOperation(formats strfmt.Registry) error {
	if swag.IsZero(o.Operation) { // not required
		return nil
	}

	// value enum
	if err := o.validateOperationEnum("info"+"."+"position"+"."+"operation", "body", *o.Operation); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tape device inline position based on context it is used
func (o *TapeDeviceInlinePosition) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlinePosition) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlinePosition) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlinePosition
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TapeDeviceInlineStoragePort tape device inline storage port
swagger:model tape_device_inline_storage_port
*/
type TapeDeviceInlineStoragePort struct {

	// Initiator port.
	// Example: 2b
	Name *string `json:"name,omitempty"`
}

// Validate validates this tape device inline storage port
func (o *TapeDeviceInlineStoragePort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this tape device inline storage port based on the context it is used
func (o *TapeDeviceInlineStoragePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *TapeDeviceInlineStoragePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TapeDeviceInlineStoragePort) UnmarshalBinary(b []byte) error {
	var res TapeDeviceInlineStoragePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
