// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewTapeDeviceModifyParams creates a new TapeDeviceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTapeDeviceModifyParams() *TapeDeviceModifyParams {
	return &TapeDeviceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTapeDeviceModifyParamsWithTimeout creates a new TapeDeviceModifyParams object
// with the ability to set a timeout on a request.
func NewTapeDeviceModifyParamsWithTimeout(timeout time.Duration) *TapeDeviceModifyParams {
	return &TapeDeviceModifyParams{
		timeout: timeout,
	}
}

// NewTapeDeviceModifyParamsWithContext creates a new TapeDeviceModifyParams object
// with the ability to set a context for a request.
func NewTapeDeviceModifyParamsWithContext(ctx context.Context) *TapeDeviceModifyParams {
	return &TapeDeviceModifyParams{
		Context: ctx,
	}
}

// NewTapeDeviceModifyParamsWithHTTPClient creates a new TapeDeviceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewTapeDeviceModifyParamsWithHTTPClient(client *http.Client) *TapeDeviceModifyParams {
	return &TapeDeviceModifyParams{
		HTTPClient: client,
	}
}

/*
TapeDeviceModifyParams contains all the parameters to send to the API endpoint

	for the tape device modify operation.

	Typically these are written to a http.Request.
*/
type TapeDeviceModifyParams struct {

	/* DeviceID.

	   Device ID
	*/
	DeviceID string

	/* Info.

	   The new property values for the tape device.
	*/
	Info *models.TapeDevice

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tape device modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceModifyParams) WithDefaults() *TapeDeviceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tape device modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TapeDeviceModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := TapeDeviceModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the tape device modify params
func (o *TapeDeviceModifyParams) WithTimeout(timeout time.Duration) *TapeDeviceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tape device modify params
func (o *TapeDeviceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tape device modify params
func (o *TapeDeviceModifyParams) WithContext(ctx context.Context) *TapeDeviceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tape device modify params
func (o *TapeDeviceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tape device modify params
func (o *TapeDeviceModifyParams) WithHTTPClient(client *http.Client) *TapeDeviceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tape device modify params
func (o *TapeDeviceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeviceID adds the deviceID to the tape device modify params
func (o *TapeDeviceModifyParams) WithDeviceID(deviceID string) *TapeDeviceModifyParams {
	o.SetDeviceID(deviceID)
	return o
}

// SetDeviceID adds the deviceId to the tape device modify params
func (o *TapeDeviceModifyParams) SetDeviceID(deviceID string) {
	o.DeviceID = deviceID
}

// WithInfo adds the info to the tape device modify params
func (o *TapeDeviceModifyParams) WithInfo(info *models.TapeDevice) *TapeDeviceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the tape device modify params
func (o *TapeDeviceModifyParams) SetInfo(info *models.TapeDevice) {
	o.Info = info
}

// WithNodeUUID adds the nodeUUID to the tape device modify params
func (o *TapeDeviceModifyParams) WithNodeUUID(nodeUUID string) *TapeDeviceModifyParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the tape device modify params
func (o *TapeDeviceModifyParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithReturnTimeout adds the returnTimeout to the tape device modify params
func (o *TapeDeviceModifyParams) WithReturnTimeout(returnTimeout *int64) *TapeDeviceModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the tape device modify params
func (o *TapeDeviceModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *TapeDeviceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param device_id
	if err := r.SetPathParam("device_id", o.DeviceID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
