// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TapeDeviceModifyReader is a Reader for the TapeDeviceModify structure.
type TapeDeviceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TapeDeviceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTapeDeviceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewTapeDeviceModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTapeDeviceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTapeDeviceModifyOK creates a TapeDeviceModifyOK with default headers values
func NewTapeDeviceModifyOK() *TapeDeviceModifyOK {
	return &TapeDeviceModifyOK{}
}

/*
TapeDeviceModifyOK describes a response with status code 200, with default header values.

OK
*/
type TapeDeviceModifyOK struct {
}

// IsSuccess returns true when this tape device modify o k response has a 2xx status code
func (o *TapeDeviceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tape device modify o k response has a 3xx status code
func (o *TapeDeviceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tape device modify o k response has a 4xx status code
func (o *TapeDeviceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tape device modify o k response has a 5xx status code
func (o *TapeDeviceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tape device modify o k response a status code equal to that given
func (o *TapeDeviceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tape device modify o k response
func (o *TapeDeviceModifyOK) Code() int {
	return 200
}

func (o *TapeDeviceModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tapeDeviceModifyOK", 200)
}

func (o *TapeDeviceModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tapeDeviceModifyOK", 200)
}

func (o *TapeDeviceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTapeDeviceModifyAccepted creates a TapeDeviceModifyAccepted with default headers values
func NewTapeDeviceModifyAccepted() *TapeDeviceModifyAccepted {
	return &TapeDeviceModifyAccepted{}
}

/*
TapeDeviceModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type TapeDeviceModifyAccepted struct {
	Payload *models.TapeDeviceJobLinkResponse
}

// IsSuccess returns true when this tape device modify accepted response has a 2xx status code
func (o *TapeDeviceModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tape device modify accepted response has a 3xx status code
func (o *TapeDeviceModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tape device modify accepted response has a 4xx status code
func (o *TapeDeviceModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this tape device modify accepted response has a 5xx status code
func (o *TapeDeviceModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this tape device modify accepted response a status code equal to that given
func (o *TapeDeviceModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the tape device modify accepted response
func (o *TapeDeviceModifyAccepted) Code() int {
	return 202
}

func (o *TapeDeviceModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tapeDeviceModifyAccepted %s", 202, payload)
}

func (o *TapeDeviceModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tapeDeviceModifyAccepted %s", 202, payload)
}

func (o *TapeDeviceModifyAccepted) GetPayload() *models.TapeDeviceJobLinkResponse {
	return o.Payload
}

func (o *TapeDeviceModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.TapeDeviceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTapeDeviceModifyDefault creates a TapeDeviceModifyDefault with default headers values
func NewTapeDeviceModifyDefault(code int) *TapeDeviceModifyDefault {
	return &TapeDeviceModifyDefault{
		_statusCode: code,
	}
}

/*
	TapeDeviceModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 11403264 | Tape operation \"<operation>\" failed on tape device \"<device_id>\". This may indicate tape reached end of data, a hardware error, an illegal request, an invalid name format, or an aborted command. |
| 11403265 | Tape operation  \"<operation>\" failed because it encountered an unexpected file mark on tape device \"<device_id>\". |
| 11403266 | Internal error. Unknown tape parameter for tape device \"<device_id>\". |
| 11403267 | Tape device \"<device_id>\" is busy. |
| 11403268 | No tape loaded for \"<operation>\" operation on tape drive \"<device_id>\". |
| 11403269 | Tape device \"<device_id>\" unknown. |
| 11403270 | Tape alias name \"<alias>\" already exists. |
| 11403271 | The format of the tape alias name \"<alias>\" is invalid. Use \"st\" or \"mc\" followed by one or more digits. |
| 11403273 | Internal error. Tape alias name \"<alias>\" not saved. |
| 11403274 | Internal error. Tape alias operation \"<operation>\" for alias name \"<alias>\" failed. |
| 11403275 | Tape alias name \"<alias>\" not found. |
| 11403277 | Tape device \"<device_id>\" is reserved by another host. |
| 11403278 | Invalid count value specified with operation \"<operation>\". Valid values are from 0 to {1}. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TapeDeviceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tape device modify default response has a 2xx status code
func (o *TapeDeviceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this tape device modify default response has a 3xx status code
func (o *TapeDeviceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this tape device modify default response has a 4xx status code
func (o *TapeDeviceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this tape device modify default response has a 5xx status code
func (o *TapeDeviceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this tape device modify default response a status code equal to that given
func (o *TapeDeviceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the tape device modify default response
func (o *TapeDeviceModifyDefault) Code() int {
	return o._statusCode
}

func (o *TapeDeviceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tape_device_modify default %s", o._statusCode, payload)
}

func (o *TapeDeviceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/tape-devices/{node.uuid}/{device_id}][%d] tape_device_modify default %s", o._statusCode, payload)
}

func (o *TapeDeviceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TapeDeviceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
