// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTokenCollectionGetParams creates a new TokenCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokenCollectionGetParams() *TokenCollectionGetParams {
	return &TokenCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokenCollectionGetParamsWithTimeout creates a new TokenCollectionGetParams object
// with the ability to set a timeout on a request.
func NewTokenCollectionGetParamsWithTimeout(timeout time.Duration) *TokenCollectionGetParams {
	return &TokenCollectionGetParams{
		timeout: timeout,
	}
}

// NewTokenCollectionGetParamsWithContext creates a new TokenCollectionGetParams object
// with the ability to set a context for a request.
func NewTokenCollectionGetParamsWithContext(ctx context.Context) *TokenCollectionGetParams {
	return &TokenCollectionGetParams{
		Context: ctx,
	}
}

// NewTokenCollectionGetParamsWithHTTPClient creates a new TokenCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokenCollectionGetParamsWithHTTPClient(client *http.Client) *TokenCollectionGetParams {
	return &TokenCollectionGetParams{
		HTTPClient: client,
	}
}

/*
TokenCollectionGetParams contains all the parameters to send to the API endpoint

	for the token collection get operation.

	Typically these are written to a http.Request.
*/
type TokenCollectionGetParams struct {

	/* ExpiryTimeLeft.

	   Filter by expiry_time.left
	*/
	ExpiryTimeLeft *string

	/* ExpiryTimeLimit.

	   Filter by expiry_time.limit
	*/
	ExpiryTimeLimit *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReserveSize.

	   Filter by reserve_size
	*/
	ReserveSize *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the token collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenCollectionGetParams) WithDefaults() *TokenCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the token collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := TokenCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the token collection get params
func (o *TokenCollectionGetParams) WithTimeout(timeout time.Duration) *TokenCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the token collection get params
func (o *TokenCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the token collection get params
func (o *TokenCollectionGetParams) WithContext(ctx context.Context) *TokenCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the token collection get params
func (o *TokenCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the token collection get params
func (o *TokenCollectionGetParams) WithHTTPClient(client *http.Client) *TokenCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the token collection get params
func (o *TokenCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithExpiryTimeLeft adds the expiryTimeLeft to the token collection get params
func (o *TokenCollectionGetParams) WithExpiryTimeLeft(expiryTimeLeft *string) *TokenCollectionGetParams {
	o.SetExpiryTimeLeft(expiryTimeLeft)
	return o
}

// SetExpiryTimeLeft adds the expiryTimeLeft to the token collection get params
func (o *TokenCollectionGetParams) SetExpiryTimeLeft(expiryTimeLeft *string) {
	o.ExpiryTimeLeft = expiryTimeLeft
}

// WithExpiryTimeLimit adds the expiryTimeLimit to the token collection get params
func (o *TokenCollectionGetParams) WithExpiryTimeLimit(expiryTimeLimit *string) *TokenCollectionGetParams {
	o.SetExpiryTimeLimit(expiryTimeLimit)
	return o
}

// SetExpiryTimeLimit adds the expiryTimeLimit to the token collection get params
func (o *TokenCollectionGetParams) SetExpiryTimeLimit(expiryTimeLimit *string) {
	o.ExpiryTimeLimit = expiryTimeLimit
}

// WithFields adds the fields to the token collection get params
func (o *TokenCollectionGetParams) WithFields(fields []string) *TokenCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the token collection get params
func (o *TokenCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the token collection get params
func (o *TokenCollectionGetParams) WithMaxRecords(maxRecords *int64) *TokenCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the token collection get params
func (o *TokenCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the token collection get params
func (o *TokenCollectionGetParams) WithNodeName(nodeName *string) *TokenCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the token collection get params
func (o *TokenCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the token collection get params
func (o *TokenCollectionGetParams) WithNodeUUID(nodeUUID *string) *TokenCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the token collection get params
func (o *TokenCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the token collection get params
func (o *TokenCollectionGetParams) WithOrderBy(orderBy []string) *TokenCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the token collection get params
func (o *TokenCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReserveSize adds the reserveSize to the token collection get params
func (o *TokenCollectionGetParams) WithReserveSize(reserveSize *int64) *TokenCollectionGetParams {
	o.SetReserveSize(reserveSize)
	return o
}

// SetReserveSize adds the reserveSize to the token collection get params
func (o *TokenCollectionGetParams) SetReserveSize(reserveSize *int64) {
	o.ReserveSize = reserveSize
}

// WithReturnRecords adds the returnRecords to the token collection get params
func (o *TokenCollectionGetParams) WithReturnRecords(returnRecords *bool) *TokenCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the token collection get params
func (o *TokenCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the token collection get params
func (o *TokenCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *TokenCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the token collection get params
func (o *TokenCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the token collection get params
func (o *TokenCollectionGetParams) WithUUID(uuid *string) *TokenCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the token collection get params
func (o *TokenCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *TokenCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ExpiryTimeLeft != nil {

		// query param expiry_time.left
		var qrExpiryTimeLeft string

		if o.ExpiryTimeLeft != nil {
			qrExpiryTimeLeft = *o.ExpiryTimeLeft
		}
		qExpiryTimeLeft := qrExpiryTimeLeft
		if qExpiryTimeLeft != "" {

			if err := r.SetQueryParam("expiry_time.left", qExpiryTimeLeft); err != nil {
				return err
			}
		}
	}

	if o.ExpiryTimeLimit != nil {

		// query param expiry_time.limit
		var qrExpiryTimeLimit string

		if o.ExpiryTimeLimit != nil {
			qrExpiryTimeLimit = *o.ExpiryTimeLimit
		}
		qExpiryTimeLimit := qrExpiryTimeLimit
		if qExpiryTimeLimit != "" {

			if err := r.SetQueryParam("expiry_time.limit", qExpiryTimeLimit); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReserveSize != nil {

		// query param reserve_size
		var qrReserveSize int64

		if o.ReserveSize != nil {
			qrReserveSize = *o.ReserveSize
		}
		qReserveSize := swag.FormatInt64(qrReserveSize)
		if qReserveSize != "" {

			if err := r.SetQueryParam("reserve_size", qReserveSize); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTokenCollectionGet binds the parameter fields
func (o *TokenCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamTokenCollectionGet binds the parameter order_by
func (o *TokenCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
