// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TokenCollectionGetReader is a Reader for the TokenCollectionGet structure.
type TokenCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokenCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTokenCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTokenCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTokenCollectionGetOK creates a TokenCollectionGetOK with default headers values
func NewTokenCollectionGetOK() *TokenCollectionGetOK {
	return &TokenCollectionGetOK{}
}

/*
TokenCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type TokenCollectionGetOK struct {
	Payload *models.TokenResponse
}

// IsSuccess returns true when this token collection get o k response has a 2xx status code
func (o *TokenCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this token collection get o k response has a 3xx status code
func (o *TokenCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this token collection get o k response has a 4xx status code
func (o *TokenCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this token collection get o k response has a 5xx status code
func (o *TokenCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this token collection get o k response a status code equal to that given
func (o *TokenCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the token collection get o k response
func (o *TokenCollectionGetOK) Code() int {
	return 200
}

func (o *TokenCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens][%d] tokenCollectionGetOK %s", 200, payload)
}

func (o *TokenCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens][%d] tokenCollectionGetOK %s", 200, payload)
}

func (o *TokenCollectionGetOK) GetPayload() *models.TokenResponse {
	return o.Payload
}

func (o *TokenCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.TokenResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokenCollectionGetDefault creates a TokenCollectionGetDefault with default headers values
func NewTokenCollectionGetDefault(code int) *TokenCollectionGetDefault {
	return &TokenCollectionGetDefault{
		_statusCode: code,
	}
}

/*
TokenCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type TokenCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this token collection get default response has a 2xx status code
func (o *TokenCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this token collection get default response has a 3xx status code
func (o *TokenCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this token collection get default response has a 4xx status code
func (o *TokenCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this token collection get default response has a 5xx status code
func (o *TokenCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this token collection get default response a status code equal to that given
func (o *TokenCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the token collection get default response
func (o *TokenCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *TokenCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens][%d] token_collection_get default %s", o._statusCode, payload)
}

func (o *TokenCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens][%d] token_collection_get default %s", o._statusCode, payload)
}

func (o *TokenCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TokenCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
