// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewTokenCreateParams creates a new TokenCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokenCreateParams() *TokenCreateParams {
	return &TokenCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokenCreateParamsWithTimeout creates a new TokenCreateParams object
// with the ability to set a timeout on a request.
func NewTokenCreateParamsWithTimeout(timeout time.Duration) *TokenCreateParams {
	return &TokenCreateParams{
		timeout: timeout,
	}
}

// NewTokenCreateParamsWithContext creates a new TokenCreateParams object
// with the ability to set a context for a request.
func NewTokenCreateParamsWithContext(ctx context.Context) *TokenCreateParams {
	return &TokenCreateParams{
		Context: ctx,
	}
}

// NewTokenCreateParamsWithHTTPClient creates a new TokenCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokenCreateParamsWithHTTPClient(client *http.Client) *TokenCreateParams {
	return &TokenCreateParams{
		HTTPClient: client,
	}
}

/*
TokenCreateParams contains all the parameters to send to the API endpoint

	for the token create operation.

	Typically these are written to a http.Request.
*/
type TokenCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.Token

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the token create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenCreateParams) WithDefaults() *TokenCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the token create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := TokenCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the token create params
func (o *TokenCreateParams) WithTimeout(timeout time.Duration) *TokenCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the token create params
func (o *TokenCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the token create params
func (o *TokenCreateParams) WithContext(ctx context.Context) *TokenCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the token create params
func (o *TokenCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the token create params
func (o *TokenCreateParams) WithHTTPClient(client *http.Client) *TokenCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the token create params
func (o *TokenCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the token create params
func (o *TokenCreateParams) WithInfo(info *models.Token) *TokenCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the token create params
func (o *TokenCreateParams) SetInfo(info *models.Token) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the token create params
func (o *TokenCreateParams) WithReturnRecords(returnRecords *bool) *TokenCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the token create params
func (o *TokenCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *TokenCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
