// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TokenCreateReader is a Reader for the TokenCreate structure.
type TokenCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokenCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewTokenCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTokenCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTokenCreateCreated creates a TokenCreateCreated with default headers values
func NewTokenCreateCreated() *TokenCreateCreated {
	return &TokenCreateCreated{}
}

/*
TokenCreateCreated describes a response with status code 201, with default header values.

Created
*/
type TokenCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.TokenResponse
}

// IsSuccess returns true when this token create created response has a 2xx status code
func (o *TokenCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this token create created response has a 3xx status code
func (o *TokenCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this token create created response has a 4xx status code
func (o *TokenCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this token create created response has a 5xx status code
func (o *TokenCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this token create created response a status code equal to that given
func (o *TokenCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the token create created response
func (o *TokenCreateCreated) Code() int {
	return 201
}

func (o *TokenCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/file/clone/tokens][%d] tokenCreateCreated %s", 201, payload)
}

func (o *TokenCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/file/clone/tokens][%d] tokenCreateCreated %s", 201, payload)
}

func (o *TokenCreateCreated) GetPayload() *models.TokenResponse {
	return o.Payload
}

func (o *TokenCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.TokenResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokenCreateDefault creates a TokenCreateDefault with default headers values
func NewTokenCreateDefault(code int) *TokenCreateDefault {
	return &TokenCreateDefault{
		_statusCode: code,
	}
}

/*
	TokenCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13565959 | Failed to create token for node `node.name`. |
| 13565964 | Reserve size cannot be negative. |
| 13565997 | The node.uuid doesn't exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TokenCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this token create default response has a 2xx status code
func (o *TokenCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this token create default response has a 3xx status code
func (o *TokenCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this token create default response has a 4xx status code
func (o *TokenCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this token create default response has a 5xx status code
func (o *TokenCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this token create default response a status code equal to that given
func (o *TokenCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the token create default response
func (o *TokenCreateDefault) Code() int {
	return o._statusCode
}

func (o *TokenCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/file/clone/tokens][%d] token_create default %s", o._statusCode, payload)
}

func (o *TokenCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/file/clone/tokens][%d] token_create default %s", o._statusCode, payload)
}

func (o *TokenCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TokenCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
