// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTokenGetParams creates a new TokenGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokenGetParams() *TokenGetParams {
	return &TokenGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokenGetParamsWithTimeout creates a new TokenGetParams object
// with the ability to set a timeout on a request.
func NewTokenGetParamsWithTimeout(timeout time.Duration) *TokenGetParams {
	return &TokenGetParams{
		timeout: timeout,
	}
}

// NewTokenGetParamsWithContext creates a new TokenGetParams object
// with the ability to set a context for a request.
func NewTokenGetParamsWithContext(ctx context.Context) *TokenGetParams {
	return &TokenGetParams{
		Context: ctx,
	}
}

// NewTokenGetParamsWithHTTPClient creates a new TokenGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokenGetParamsWithHTTPClient(client *http.Client) *TokenGetParams {
	return &TokenGetParams{
		HTTPClient: client,
	}
}

/*
TokenGetParams contains all the parameters to send to the API endpoint

	for the token get operation.

	Typically these are written to a http.Request.
*/
type TokenGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	/* UUID.

	   Token UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the token get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenGetParams) WithDefaults() *TokenGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the token get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the token get params
func (o *TokenGetParams) WithTimeout(timeout time.Duration) *TokenGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the token get params
func (o *TokenGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the token get params
func (o *TokenGetParams) WithContext(ctx context.Context) *TokenGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the token get params
func (o *TokenGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the token get params
func (o *TokenGetParams) WithHTTPClient(client *http.Client) *TokenGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the token get params
func (o *TokenGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the token get params
func (o *TokenGetParams) WithFields(fields []string) *TokenGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the token get params
func (o *TokenGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithNodeUUID adds the nodeUUID to the token get params
func (o *TokenGetParams) WithNodeUUID(nodeUUID string) *TokenGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the token get params
func (o *TokenGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithUUID adds the uuid to the token get params
func (o *TokenGetParams) WithUUID(uuid string) *TokenGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the token get params
func (o *TokenGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *TokenGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTokenGet binds the parameter fields
func (o *TokenGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
