// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TokenGetReader is a Reader for the TokenGet structure.
type TokenGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokenGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTokenGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTokenGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTokenGetOK creates a TokenGetOK with default headers values
func NewTokenGetOK() *TokenGetOK {
	return &TokenGetOK{}
}

/*
TokenGetOK describes a response with status code 200, with default header values.

OK
*/
type TokenGetOK struct {
	Payload *models.Token
}

// IsSuccess returns true when this token get o k response has a 2xx status code
func (o *TokenGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this token get o k response has a 3xx status code
func (o *TokenGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this token get o k response has a 4xx status code
func (o *TokenGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this token get o k response has a 5xx status code
func (o *TokenGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this token get o k response a status code equal to that given
func (o *TokenGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the token get o k response
func (o *TokenGetOK) Code() int {
	return 200
}

func (o *TokenGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] tokenGetOK %s", 200, payload)
}

func (o *TokenGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] tokenGetOK %s", 200, payload)
}

func (o *TokenGetOK) GetPayload() *models.Token {
	return o.Payload
}

func (o *TokenGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Token)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokenGetDefault creates a TokenGetDefault with default headers values
func NewTokenGetDefault(code int) *TokenGetDefault {
	return &TokenGetDefault{
		_statusCode: code,
	}
}

/*
	TokenGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13565958 | Failed to get information about token `uuid` for node `node.name`. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TokenGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this token get default response has a 2xx status code
func (o *TokenGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this token get default response has a 3xx status code
func (o *TokenGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this token get default response has a 4xx status code
func (o *TokenGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this token get default response has a 5xx status code
func (o *TokenGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this token get default response a status code equal to that given
func (o *TokenGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the token get default response
func (o *TokenGetDefault) Code() int {
	return o._statusCode
}

func (o *TokenGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] token_get default %s", o._statusCode, payload)
}

func (o *TokenGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] token_get default %s", o._statusCode, payload)
}

func (o *TokenGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TokenGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
