// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TokenModifyCollectionReader is a Reader for the TokenModifyCollection structure.
type TokenModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokenModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTokenModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTokenModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTokenModifyCollectionOK creates a TokenModifyCollectionOK with default headers values
func NewTokenModifyCollectionOK() *TokenModifyCollectionOK {
	return &TokenModifyCollectionOK{}
}

/*
TokenModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type TokenModifyCollectionOK struct {
}

// IsSuccess returns true when this token modify collection o k response has a 2xx status code
func (o *TokenModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this token modify collection o k response has a 3xx status code
func (o *TokenModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this token modify collection o k response has a 4xx status code
func (o *TokenModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this token modify collection o k response has a 5xx status code
func (o *TokenModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this token modify collection o k response a status code equal to that given
func (o *TokenModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the token modify collection o k response
func (o *TokenModifyCollectionOK) Code() int {
	return 200
}

func (o *TokenModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens][%d] tokenModifyCollectionOK", 200)
}

func (o *TokenModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens][%d] tokenModifyCollectionOK", 200)
}

func (o *TokenModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTokenModifyCollectionDefault creates a TokenModifyCollectionDefault with default headers values
func NewTokenModifyCollectionDefault(code int) *TokenModifyCollectionDefault {
	return &TokenModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	TokenModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13565958 | Failed to get information about token `uuid` for node `node.name`. |
| 13565960 | Failed to modify token expiry limit for node `node.name`. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TokenModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this token modify collection default response has a 2xx status code
func (o *TokenModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this token modify collection default response has a 3xx status code
func (o *TokenModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this token modify collection default response has a 4xx status code
func (o *TokenModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this token modify collection default response has a 5xx status code
func (o *TokenModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this token modify collection default response a status code equal to that given
func (o *TokenModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the token modify collection default response
func (o *TokenModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *TokenModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens][%d] token_modify_collection default %s", o._statusCode, payload)
}

func (o *TokenModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens][%d] token_modify_collection default %s", o._statusCode, payload)
}

func (o *TokenModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TokenModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
TokenModifyCollectionBody token modify collection body
swagger:model TokenModifyCollectionBody
*/
type TokenModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// expiry time
	ExpiryTime *models.TokenInlineExpiryTime `json:"expiry_time,omitempty"`

	// node
	Node *models.TokenInlineNode `json:"node,omitempty"`

	// Specifies the available reserve in the file clone split load for the given token. Also note that the minimum value for reserve size is 4KB and any value specified below 4KB will be rounded off to 4KB.
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// token response inline records
	TokenResponseInlineRecords []*models.Token `json:"records,omitempty"`

	// Token UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this token modify collection body
func (o *TokenModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTokenResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TokenModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if o.ExpiryTime != nil {
		if err := o.ExpiryTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiry_time")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) validateTokenResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.TokenResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.TokenResponseInlineRecords); i++ {
		if swag.IsZero(o.TokenResponseInlineRecords[i]) { // not required
			continue
		}

		if o.TokenResponseInlineRecords[i] != nil {
			if err := o.TokenResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this token modify collection body based on the context it is used
func (o *TokenModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTokenResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TokenModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if o.ExpiryTime != nil {
		if err := o.ExpiryTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiry_time")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *TokenModifyCollectionBody) contextValidateTokenResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.TokenResponseInlineRecords); i++ {

		if o.TokenResponseInlineRecords[i] != nil {
			if err := o.TokenResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *TokenModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TokenModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TokenModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res TokenModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TokenInlineExpiryTime token inline expiry time
swagger:model token_inline_expiry_time
*/
type TokenInlineExpiryTime struct {

	// Specifies the time remaining before the given token expires in ISO-8601 format.
	// Read Only: true
	Left *string `json:"left,omitempty"`

	// Specifies when the given token expires in ISO-8601 format.
	Limit *string `json:"limit,omitempty"`
}

// Validate validates this token inline expiry time
func (o *TokenInlineExpiryTime) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this token inline expiry time based on the context it is used
func (o *TokenInlineExpiryTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLeft(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TokenInlineExpiryTime) contextValidateLeft(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"expiry_time"+"."+"left", "body", o.Left); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TokenInlineExpiryTime) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TokenInlineExpiryTime) UnmarshalBinary(b []byte) error {
	var res TokenInlineExpiryTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
TokenInlineNode token inline node
swagger:model token_inline_node
*/
type TokenInlineNode struct {

	// Node name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Node UUID
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this token inline node
func (o *TokenInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this token inline node based on the context it is used
func (o *TokenInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *TokenInlineNode) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"node"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *TokenInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *TokenInlineNode) UnmarshalBinary(b []byte) error {
	var res TokenInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
