// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewTokenModifyParams creates a new TokenModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokenModifyParams() *TokenModifyParams {
	return &TokenModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokenModifyParamsWithTimeout creates a new TokenModifyParams object
// with the ability to set a timeout on a request.
func NewTokenModifyParamsWithTimeout(timeout time.Duration) *TokenModifyParams {
	return &TokenModifyParams{
		timeout: timeout,
	}
}

// NewTokenModifyParamsWithContext creates a new TokenModifyParams object
// with the ability to set a context for a request.
func NewTokenModifyParamsWithContext(ctx context.Context) *TokenModifyParams {
	return &TokenModifyParams{
		Context: ctx,
	}
}

// NewTokenModifyParamsWithHTTPClient creates a new TokenModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokenModifyParamsWithHTTPClient(client *http.Client) *TokenModifyParams {
	return &TokenModifyParams{
		HTTPClient: client,
	}
}

/*
TokenModifyParams contains all the parameters to send to the API endpoint

	for the token modify operation.

	Typically these are written to a http.Request.
*/
type TokenModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.Token

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	/* UUID.

	   Token UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the token modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenModifyParams) WithDefaults() *TokenModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the token modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokenModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the token modify params
func (o *TokenModifyParams) WithTimeout(timeout time.Duration) *TokenModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the token modify params
func (o *TokenModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the token modify params
func (o *TokenModifyParams) WithContext(ctx context.Context) *TokenModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the token modify params
func (o *TokenModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the token modify params
func (o *TokenModifyParams) WithHTTPClient(client *http.Client) *TokenModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the token modify params
func (o *TokenModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the token modify params
func (o *TokenModifyParams) WithInfo(info *models.Token) *TokenModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the token modify params
func (o *TokenModifyParams) SetInfo(info *models.Token) {
	o.Info = info
}

// WithNodeUUID adds the nodeUUID to the token modify params
func (o *TokenModifyParams) WithNodeUUID(nodeUUID string) *TokenModifyParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the token modify params
func (o *TokenModifyParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithUUID adds the uuid to the token modify params
func (o *TokenModifyParams) WithUUID(uuid string) *TokenModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the token modify params
func (o *TokenModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *TokenModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
