// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TokenModifyReader is a Reader for the TokenModify structure.
type TokenModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokenModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTokenModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTokenModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTokenModifyOK creates a TokenModifyOK with default headers values
func NewTokenModifyOK() *TokenModifyOK {
	return &TokenModifyOK{}
}

/*
TokenModifyOK describes a response with status code 200, with default header values.

OK
*/
type TokenModifyOK struct {
}

// IsSuccess returns true when this token modify o k response has a 2xx status code
func (o *TokenModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this token modify o k response has a 3xx status code
func (o *TokenModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this token modify o k response has a 4xx status code
func (o *TokenModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this token modify o k response has a 5xx status code
func (o *TokenModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this token modify o k response a status code equal to that given
func (o *TokenModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the token modify o k response
func (o *TokenModifyOK) Code() int {
	return 200
}

func (o *TokenModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] tokenModifyOK", 200)
}

func (o *TokenModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] tokenModifyOK", 200)
}

func (o *TokenModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTokenModifyDefault creates a TokenModifyDefault with default headers values
func NewTokenModifyDefault(code int) *TokenModifyDefault {
	return &TokenModifyDefault{
		_statusCode: code,
	}
}

/*
	TokenModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13565958 | Failed to get information about token `uuid` for node `node.name`. |
| 13565960 | Failed to modify token expiry limit for node `node.name`. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TokenModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this token modify default response has a 2xx status code
func (o *TokenModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this token modify default response has a 3xx status code
func (o *TokenModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this token modify default response has a 4xx status code
func (o *TokenModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this token modify default response has a 5xx status code
func (o *TokenModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this token modify default response a status code equal to that given
func (o *TokenModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the token modify default response
func (o *TokenModifyDefault) Code() int {
	return o._statusCode
}

func (o *TokenModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] token_modify default %s", o._statusCode, payload)
}

func (o *TokenModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/tokens/{node.uuid}/{uuid}][%d] token_modify default %s", o._statusCode, payload)
}

func (o *TokenModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TokenModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
