// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TopMetricsFileCollectionGetReader is a Reader for the TopMetricsFileCollectionGet structure.
type TopMetricsFileCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TopMetricsFileCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTopMetricsFileCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTopMetricsFileCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTopMetricsFileCollectionGetOK creates a TopMetricsFileCollectionGetOK with default headers values
func NewTopMetricsFileCollectionGetOK() *TopMetricsFileCollectionGetOK {
	return &TopMetricsFileCollectionGetOK{}
}

/*
TopMetricsFileCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type TopMetricsFileCollectionGetOK struct {
	Payload *models.TopMetricsFileResponse
}

// IsSuccess returns true when this top metrics file collection get o k response has a 2xx status code
func (o *TopMetricsFileCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this top metrics file collection get o k response has a 3xx status code
func (o *TopMetricsFileCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this top metrics file collection get o k response has a 4xx status code
func (o *TopMetricsFileCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this top metrics file collection get o k response has a 5xx status code
func (o *TopMetricsFileCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this top metrics file collection get o k response a status code equal to that given
func (o *TopMetricsFileCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the top metrics file collection get o k response
func (o *TopMetricsFileCollectionGetOK) Code() int {
	return 200
}

func (o *TopMetricsFileCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/top-metrics/files][%d] topMetricsFileCollectionGetOK %s", 200, payload)
}

func (o *TopMetricsFileCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/top-metrics/files][%d] topMetricsFileCollectionGetOK %s", 200, payload)
}

func (o *TopMetricsFileCollectionGetOK) GetPayload() *models.TopMetricsFileResponse {
	return o.Payload
}

func (o *TopMetricsFileCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.TopMetricsFileResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTopMetricsFileCollectionGetDefault creates a TopMetricsFileCollectionGetDefault with default headers values
func NewTopMetricsFileCollectionGetDefault(code int) *TopMetricsFileCollectionGetDefault {
	return &TopMetricsFileCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	TopMetricsFileCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 124518405 | Volume activity tracking is not supported on volumes that contain LUNs. |
| 124518407 | Volume activity tracking is not supported on FlexCache volumes. |
| 124518408 | Volume activity tracking is not supported on audit staging volumes. |
| 124518409 | Volume activity tracking is not supported on object store server volumes. |
| 124518410 | Volume activity tracking is not supported on SnapMirror destination volumes. |
| 124518411 | Enabling or disabling volume activity tracking is not supported on individual FlexGroup constituents. |
| 124518412 | Volume activity tracking is not supported on SnapLock volumes. |
| 124518414 | Volume activity tracking is not supported on volumes that contain NVMe namespaces. |
| 124518415 | Failed to get the volume activity tracking report on volume volume.name in SVM svm.name. |
| 124518416 | Internal error. Volume activity tracking report timed out for volume volume.name in SVM svm.name. |
| 124518417 | Volume wildcard queries are not supported for activity tracking reports. |
| 124518418 | The activity tracking report for volume volume.name in SVM svm.name returned zero records. Check whether the volume has read/write traffic. Refer to the REST API documentation for more information. |
| 124518422 | Volume activity tracking is not supported on All SAN Array clusters. |
| 124518423 | Volume activity tracking is not supported on the volume. |
| 124519411 | Volume activity tracking is not enabled on the volume. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TopMetricsFileCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this top metrics file collection get default response has a 2xx status code
func (o *TopMetricsFileCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this top metrics file collection get default response has a 3xx status code
func (o *TopMetricsFileCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this top metrics file collection get default response has a 4xx status code
func (o *TopMetricsFileCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this top metrics file collection get default response has a 5xx status code
func (o *TopMetricsFileCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this top metrics file collection get default response a status code equal to that given
func (o *TopMetricsFileCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the top metrics file collection get default response
func (o *TopMetricsFileCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *TopMetricsFileCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/top-metrics/files][%d] top_metrics_file_collection_get default %s", o._statusCode, payload)
}

func (o *TopMetricsFileCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/top-metrics/files][%d] top_metrics_file_collection_get default %s", o._statusCode, payload)
}

func (o *TopMetricsFileCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TopMetricsFileCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
