// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVolumeCollectionGetParams creates a new VolumeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeCollectionGetParams() *VolumeCollectionGetParams {
	return &VolumeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeCollectionGetParamsWithTimeout creates a new VolumeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewVolumeCollectionGetParamsWithTimeout(timeout time.Duration) *VolumeCollectionGetParams {
	return &VolumeCollectionGetParams{
		timeout: timeout,
	}
}

// NewVolumeCollectionGetParamsWithContext creates a new VolumeCollectionGetParams object
// with the ability to set a context for a request.
func NewVolumeCollectionGetParamsWithContext(ctx context.Context) *VolumeCollectionGetParams {
	return &VolumeCollectionGetParams{
		Context: ctx,
	}
}

// NewVolumeCollectionGetParamsWithHTTPClient creates a new VolumeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeCollectionGetParamsWithHTTPClient(client *http.Client) *VolumeCollectionGetParams {
	return &VolumeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
VolumeCollectionGetParams contains all the parameters to send to the API endpoint

	for the volume collection get operation.

	Typically these are written to a http.Request.
*/
type VolumeCollectionGetParams struct {

	/* Tags.

	   Filter by _tags
	*/
	Tags *string

	/* AccessTimeEnabled.

	   Filter by access_time_enabled
	*/
	AccessTimeEnabled *bool

	/* ActivityTrackingNoticesCode.

	   Filter by activity_tracking.notices.code
	*/
	ActivityTrackingNoticesCode *string

	/* ActivityTrackingNoticesMessage.

	   Filter by activity_tracking.notices.message
	*/
	ActivityTrackingNoticesMessage *string

	/* ActivityTrackingState.

	   Filter by activity_tracking.state
	*/
	ActivityTrackingState *string

	/* ActivityTrackingSupported.

	   Filter by activity_tracking.supported
	*/
	ActivityTrackingSupported *bool

	/* ActivityTrackingUnsupportedReasonCode.

	   Filter by activity_tracking.unsupported_reason.code
	*/
	ActivityTrackingUnsupportedReasonCode *string

	/* ActivityTrackingUnsupportedReasonMessage.

	   Filter by activity_tracking.unsupported_reason.message
	*/
	ActivityTrackingUnsupportedReasonMessage *string

	/* AggregatesName.

	   Filter by aggregates.name
	*/
	AggregatesName *string

	/* AggregatesUUID.

	   Filter by aggregates.uuid
	*/
	AggregatesUUID *string

	/* AggressiveReadaheadMode.

	   Filter by aggressive_readahead_mode
	*/
	AggressiveReadaheadMode *string

	/* AnalyticsByAccessedTimeBytesUsedAgedDataMetric.

	   Filter by analytics.by_accessed_time.bytes_used.aged_data_metric
	*/
	AnalyticsByAccessedTimeBytesUsedAgedDataMetric *float64

	/* AnalyticsByAccessedTimeBytesUsedLabels.

	   Filter by analytics.by_accessed_time.bytes_used.labels
	*/
	AnalyticsByAccessedTimeBytesUsedLabels *string

	/* AnalyticsByAccessedTimeBytesUsedNewestLabel.

	   Filter by analytics.by_accessed_time.bytes_used.newest_label
	*/
	AnalyticsByAccessedTimeBytesUsedNewestLabel *string

	/* AnalyticsByAccessedTimeBytesUsedOldestLabel.

	   Filter by analytics.by_accessed_time.bytes_used.oldest_label
	*/
	AnalyticsByAccessedTimeBytesUsedOldestLabel *string

	/* AnalyticsByAccessedTimeBytesUsedPercentages.

	   Filter by analytics.by_accessed_time.bytes_used.percentages
	*/
	AnalyticsByAccessedTimeBytesUsedPercentages *float64

	/* AnalyticsByAccessedTimeBytesUsedValues.

	   Filter by analytics.by_accessed_time.bytes_used.values
	*/
	AnalyticsByAccessedTimeBytesUsedValues *int64

	/* AnalyticsByModifiedTimeBytesUsedAgedDataMetric.

	   Filter by analytics.by_modified_time.bytes_used.aged_data_metric
	*/
	AnalyticsByModifiedTimeBytesUsedAgedDataMetric *float64

	/* AnalyticsByModifiedTimeBytesUsedLabels.

	   Filter by analytics.by_modified_time.bytes_used.labels
	*/
	AnalyticsByModifiedTimeBytesUsedLabels *string

	/* AnalyticsByModifiedTimeBytesUsedNewestLabel.

	   Filter by analytics.by_modified_time.bytes_used.newest_label
	*/
	AnalyticsByModifiedTimeBytesUsedNewestLabel *string

	/* AnalyticsByModifiedTimeBytesUsedOldestLabel.

	   Filter by analytics.by_modified_time.bytes_used.oldest_label
	*/
	AnalyticsByModifiedTimeBytesUsedOldestLabel *string

	/* AnalyticsByModifiedTimeBytesUsedPercentages.

	   Filter by analytics.by_modified_time.bytes_used.percentages
	*/
	AnalyticsByModifiedTimeBytesUsedPercentages *float64

	/* AnalyticsByModifiedTimeBytesUsedValues.

	   Filter by analytics.by_modified_time.bytes_used.values
	*/
	AnalyticsByModifiedTimeBytesUsedValues *int64

	/* AnalyticsBytesUsed.

	   Filter by analytics.bytes_used
	*/
	AnalyticsBytesUsed *int64

	/* AnalyticsFileCount.

	   Filter by analytics.file_count
	*/
	AnalyticsFileCount *int64

	/* AnalyticsFilesScanned.

	   Filter by analytics.files_scanned
	*/
	AnalyticsFilesScanned *int64

	/* AnalyticsIncompleteData.

	   Filter by analytics.incomplete_data
	*/
	AnalyticsIncompleteData *bool

	/* AnalyticsInitializationState.

	   Filter by analytics.initialization.state
	*/
	AnalyticsInitializationState *string

	/* AnalyticsReportTime.

	   Filter by analytics.report_time
	*/
	AnalyticsReportTime *string

	/* AnalyticsScanProgress.

	   Filter by analytics.scan_progress
	*/
	AnalyticsScanProgress *int64

	/* AnalyticsScanThrottleReasonArguments.

	   Filter by analytics.scan_throttle_reason.arguments
	*/
	AnalyticsScanThrottleReasonArguments *string

	/* AnalyticsScanThrottleReasonCode.

	   Filter by analytics.scan_throttle_reason.code
	*/
	AnalyticsScanThrottleReasonCode *string

	/* AnalyticsScanThrottleReasonMessage.

	   Filter by analytics.scan_throttle_reason.message
	*/
	AnalyticsScanThrottleReasonMessage *string

	/* AnalyticsState.

	   Filter by analytics.state
	*/
	AnalyticsState *string

	/* AnalyticsSubdirCount.

	   Filter by analytics.subdir_count
	*/
	AnalyticsSubdirCount *int64

	/* AnalyticsSupported.

	   Filter by analytics.supported
	*/
	AnalyticsSupported *bool

	/* AnalyticsTotalFiles.

	   Filter by analytics.total_files
	*/
	AnalyticsTotalFiles *int64

	/* AnalyticsUnsupportedReasonCode.

	   Filter by analytics.unsupported_reason.code
	*/
	AnalyticsUnsupportedReasonCode *string

	/* AnalyticsUnsupportedReasonMessage.

	   Filter by analytics.unsupported_reason.message
	*/
	AnalyticsUnsupportedReasonMessage *string

	/* AntiRansomwareAttackDetectedBy.

	   Filter by anti_ransomware.attack_detected_by
	*/
	AntiRansomwareAttackDetectedBy *string

	/* AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate.

	   Filter by anti_ransomware.attack_detection_parameters.based_on_file_create_op_rate
	*/
	AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate *bool

	/* AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate.

	   Filter by anti_ransomware.attack_detection_parameters.based_on_file_delete_op_rate
	*/
	AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate *bool

	/* AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate.

	   Filter by anti_ransomware.attack_detection_parameters.based_on_file_rename_op_rate
	*/
	AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate *bool

	/* AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate.

	   Filter by anti_ransomware.attack_detection_parameters.based_on_high_entropy_data_rate
	*/
	AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate *bool

	/* AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension.

	   Filter by anti_ransomware.attack_detection_parameters.based_on_never_seen_before_file_extension
	*/
	AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension *bool

	/* AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold.

	   Filter by anti_ransomware.attack_detection_parameters.block_device_auto_learned_encryption_threshold
	*/
	AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold *int64

	/* AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent.

	   Filter by anti_ransomware.attack_detection_parameters.file_create_op_rate_surge_notify_percent
	*/
	AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent *int64

	/* AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent.

	   Filter by anti_ransomware.attack_detection_parameters.file_delete_op_rate_surge_notify_percent
	*/
	AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent *int64

	/* AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent.

	   Filter by anti_ransomware.attack_detection_parameters.file_rename_op_rate_surge_notify_percent
	*/
	AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent *int64

	/* AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent.

	   Filter by anti_ransomware.attack_detection_parameters.high_entropy_data_surge_notify_percent
	*/
	AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent *int64

	/* AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold.

	   Filter by anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_count_notify_threshold
	*/
	AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold *int64

	/* AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours.

	   Filter by anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_duration_in_hours
	*/
	AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours *int64

	/* AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions.

	   Filter by anti_ransomware.attack_detection_parameters.relaxing_popular_file_extensions
	*/
	AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions *bool

	/* AntiRansomwareAttackProbability.

	   Filter by anti_ransomware.attack_probability
	*/
	AntiRansomwareAttackProbability *string

	/* AntiRansomwareAttackReportsTime.

	   Filter by anti_ransomware.attack_reports.time
	*/
	AntiRansomwareAttackReportsTime *string

	/* AntiRansomwareBlockDeviceDetectionStartTime.

	   Filter by anti_ransomware.block_device_detection_start_time
	*/
	AntiRansomwareBlockDeviceDetectionStartTime *string

	/* AntiRansomwareBlockDeviceDetectionState.

	   Filter by anti_ransomware.block_device_detection_state
	*/
	AntiRansomwareBlockDeviceDetectionState *string

	/* AntiRansomwareClearSuspectPhase.

	   Filter by anti_ransomware.clear_suspect.phase
	*/
	AntiRansomwareClearSuspectPhase *string

	/* AntiRansomwareClearSuspectStartTime.

	   Filter by anti_ransomware.clear_suspect.start_time
	*/
	AntiRansomwareClearSuspectStartTime *string

	/* AntiRansomwareDryRunStartTime.

	   Filter by anti_ransomware.dry_run_start_time
	*/
	AntiRansomwareDryRunStartTime *string

	/* AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen.

	   Filter by anti_ransomware.event_log.is_enabled_on_new_file_extension_seen
	*/
	AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen *bool

	/* AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation.

	   Filter by anti_ransomware.event_log.is_enabled_on_snapshot_copy_creation
	*/
	AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation *bool

	/* AntiRansomwareSpaceSnapshotCount.

	   Filter by anti_ransomware.space.snapshot_count
	*/
	AntiRansomwareSpaceSnapshotCount *int64

	/* AntiRansomwareSpaceUsed.

	   Filter by anti_ransomware.space.used
	*/
	AntiRansomwareSpaceUsed *int64

	/* AntiRansomwareSpaceUsedByLogs.

	   Filter by anti_ransomware.space.used_by_logs
	*/
	AntiRansomwareSpaceUsedByLogs *int64

	/* AntiRansomwareSpaceUsedBySnapshots.

	   Filter by anti_ransomware.space.used_by_snapshots
	*/
	AntiRansomwareSpaceUsedBySnapshots *int64

	/* AntiRansomwareState.

	   Filter by anti_ransomware.state
	*/
	AntiRansomwareState *string

	/* AntiRansomwareSurgeAsNormal.

	   Filter by anti_ransomware.surge_as_normal
	*/
	AntiRansomwareSurgeAsNormal *bool

	/* AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.surge_usage.file_create_peak_rate_per_minute
	*/
	AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.surge_usage.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.surge_usage.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.surge_usage.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64

	/* AntiRansomwareSurgeUsageTime.

	   Filter by anti_ransomware.surge_usage.time
	*/
	AntiRansomwareSurgeUsageTime *string

	/* AntiRansomwareSuspectFilesCount.

	   Filter by anti_ransomware.suspect_files.count
	*/
	AntiRansomwareSuspectFilesCount *int64

	/* AntiRansomwareSuspectFilesEntropy.

	   Filter by anti_ransomware.suspect_files.entropy
	*/
	AntiRansomwareSuspectFilesEntropy *string

	/* AntiRansomwareSuspectFilesFormat.

	   Filter by anti_ransomware.suspect_files.format
	*/
	AntiRansomwareSuspectFilesFormat *string

	/* AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.typical_usage.file_create_peak_rate_per_minute
	*/
	AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.typical_usage.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.typical_usage.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.typical_usage.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64

	/* AntiRansomwareUpdateBaselineFromSurge.

	   Filter by anti_ransomware.update_baseline_from_surge
	*/
	AntiRansomwareUpdateBaselineFromSurge *bool

	/* AntiRansomwareWorkloadFileExtensionTypesCount.

	   Filter by anti_ransomware.workload.file_extension_types_count
	*/
	AntiRansomwareWorkloadFileExtensionTypesCount *int64

	/* AntiRansomwareWorkloadFileExtensionsObserved.

	   Filter by anti_ransomware.workload.file_extensions_observed
	*/
	AntiRansomwareWorkloadFileExtensionsObserved *string

	/* AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.workload.historical_statistics.file_create_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.workload.historical_statistics.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.workload.historical_statistics.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64

	/* AntiRansomwareWorkloadNewlyObservedFileExtensionsCount.

	   Filter by anti_ransomware.workload.newly_observed_file_extensions.count
	*/
	AntiRansomwareWorkloadNewlyObservedFileExtensionsCount *int64

	/* AntiRansomwareWorkloadNewlyObservedFileExtensionsName.

	   Filter by anti_ransomware.workload.newly_observed_file_extensions.name
	*/
	AntiRansomwareWorkloadNewlyObservedFileExtensionsName *string

	/* AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_statistics.file_create_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_statistics.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_statistics.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64

	/* AntiRansomwareWorkloadSurgeStatisticsTime.

	   Filter by anti_ransomware.workload.surge_statistics.time
	*/
	AntiRansomwareWorkloadSurgeStatisticsTime *string

	/* AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_usage.file_create_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_usage.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.workload.surge_usage.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64

	/* AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount.

	   Filter by anti_ransomware.workload.surge_usage.newly_observed_file_extensions.count
	*/
	AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount *int64

	/* AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName.

	   Filter by anti_ransomware.workload.surge_usage.newly_observed_file_extensions.name
	*/
	AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName *string

	/* AntiRansomwareWorkloadSurgeUsageTime.

	   Filter by anti_ransomware.workload.surge_usage.time
	*/
	AntiRansomwareWorkloadSurgeUsageTime *string

	/* AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute.

	   Filter by anti_ransomware.workload.typical_usage.file_create_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute.

	   Filter by anti_ransomware.workload.typical_usage.file_delete_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute.

	   Filter by anti_ransomware.workload.typical_usage.file_rename_peak_rate_per_minute
	*/
	AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute *int64

	/* AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent.

	   Filter by anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_percent
	*/
	AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent *int64

	/* AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute.

	   Filter by anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute
	*/
	AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64

	/* ApplicationName.

	   Filter by application.name
	*/
	ApplicationName *string

	/* ApplicationUUID.

	   Filter by application.uuid
	*/
	ApplicationUUID *string

	/* AsynchronousDirectoryDeleteEnabled.

	   Filter by asynchronous_directory_delete.enabled
	*/
	AsynchronousDirectoryDeleteEnabled *bool

	/* AsynchronousDirectoryDeleteTrashBin.

	   Filter by asynchronous_directory_delete.trash_bin
	*/
	AsynchronousDirectoryDeleteTrashBin *string

	/* AutosizeGrowThreshold.

	   Filter by autosize.grow_threshold
	*/
	AutosizeGrowThreshold *int64

	/* AutosizeMaximum.

	   Filter by autosize.maximum
	*/
	AutosizeMaximum *int64

	/* AutosizeMinimum.

	   Filter by autosize.minimum
	*/
	AutosizeMinimum *int64

	/* AutosizeMode.

	   Filter by autosize.mode
	*/
	AutosizeMode *string

	/* AutosizeShrinkThreshold.

	   Filter by autosize.shrink_threshold
	*/
	AutosizeShrinkThreshold *int64

	/* CloneHasFlexclone.

	   Filter by clone.has_flexclone
	*/
	CloneHasFlexclone *bool

	/* CloneInheritedPhysicalUsed.

	   Filter by clone.inherited_physical_used
	*/
	CloneInheritedPhysicalUsed *int64

	/* CloneInheritedSavings.

	   Filter by clone.inherited_savings
	*/
	CloneInheritedSavings *int64

	/* CloneIsFlexclone.

	   Filter by clone.is_flexclone
	*/
	CloneIsFlexclone *bool

	/* CloneLunName.

	   Filter by clone.lun_name
	*/
	CloneLunName *string

	/* CloneParentSnapshotName.

	   Filter by clone.parent_snapshot.name
	*/
	CloneParentSnapshotName *string

	/* CloneParentSnapshotUUID.

	   Filter by clone.parent_snapshot.uuid
	*/
	CloneParentSnapshotUUID *string

	/* CloneParentSvmName.

	   Filter by clone.parent_svm.name
	*/
	CloneParentSvmName *string

	/* CloneParentSvmUUID.

	   Filter by clone.parent_svm.uuid
	*/
	CloneParentSvmUUID *string

	/* CloneParentVolumeName.

	   Filter by clone.parent_volume.name
	*/
	CloneParentVolumeName *string

	/* CloneParentVolumeUUID.

	   Filter by clone.parent_volume.uuid
	*/
	CloneParentVolumeUUID *string

	/* CloneQtreeName.

	   Filter by clone.qtree_name
	*/
	CloneQtreeName *string

	/* CloneSplitCompletePercent.

	   Filter by clone.split_complete_percent
	*/
	CloneSplitCompletePercent *int64

	/* CloneSplitEstimate.

	   Filter by clone.split_estimate
	*/
	CloneSplitEstimate *int64

	/* CloneSplitInitiated.

	   Filter by clone.split_initiated
	*/
	CloneSplitInitiated *bool

	/* CloudRetrievalPolicy.

	   Filter by cloud_retrieval_policy
	*/
	CloudRetrievalPolicy *string

	/* CloudWriteEnabled.

	   Filter by cloud_write_enabled
	*/
	CloudWriteEnabled *bool

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConsistencyGroupName.

	   Filter by consistency_group.name
	*/
	ConsistencyGroupName *string

	/* ConsistencyGroupUUID.

	   Filter by consistency_group.uuid
	*/
	ConsistencyGroupUUID *string

	/* ConstituentCount.

	   Filter by constituent_count
	*/
	ConstituentCount *int64

	/* ConstituentsAggregatesName.

	   Filter by constituents.aggregates.name
	*/
	ConstituentsAggregatesName *string

	/* ConstituentsAggregatesUUID.

	   Filter by constituents.aggregates.uuid
	*/
	ConstituentsAggregatesUUID *string

	/* ConstituentsMovementCutoverWindow.

	   Filter by constituents.movement.cutover_window
	*/
	ConstituentsMovementCutoverWindow *int64

	/* ConstituentsMovementDestinationAggregateName.

	   Filter by constituents.movement.destination_aggregate.name
	*/
	ConstituentsMovementDestinationAggregateName *string

	/* ConstituentsMovementDestinationAggregateUUID.

	   Filter by constituents.movement.destination_aggregate.uuid
	*/
	ConstituentsMovementDestinationAggregateUUID *string

	/* ConstituentsMovementPercentComplete.

	   Filter by constituents.movement.percent_complete
	*/
	ConstituentsMovementPercentComplete *int64

	/* ConstituentsMovementState.

	   Filter by constituents.movement.state
	*/
	ConstituentsMovementState *string

	/* ConstituentsName.

	   Filter by constituents.name
	*/
	ConstituentsName *string

	/* ConstituentsNodeName.

	   Filter by constituents.node.name
	*/
	ConstituentsNodeName *string

	/* ConstituentsNodeUUID.

	   Filter by constituents.node.uuid
	*/
	ConstituentsNodeUUID *string

	/* ConstituentsSpaceAfsTotal.

	   Filter by constituents.space.afs_total
	*/
	ConstituentsSpaceAfsTotal *int64

	/* ConstituentsSpaceAvailable.

	   Filter by constituents.space.available
	*/
	ConstituentsSpaceAvailable *int64

	/* ConstituentsSpaceAvailablePercent.

	   Filter by constituents.space.available_percent
	*/
	ConstituentsSpaceAvailablePercent *int64

	/* ConstituentsSpaceBlockStorageInactiveUserData.

	   Filter by constituents.space.block_storage_inactive_user_data
	*/
	ConstituentsSpaceBlockStorageInactiveUserData *int64

	/* ConstituentsSpaceCapacityTierFootprint.

	   Filter by constituents.space.capacity_tier_footprint
	*/
	ConstituentsSpaceCapacityTierFootprint *int64

	/* ConstituentsSpaceFootprint.

	   Filter by constituents.space.footprint
	*/
	ConstituentsSpaceFootprint *int64

	/* ConstituentsSpaceLargeSizeEnabled.

	   Filter by constituents.space.large_size_enabled
	*/
	ConstituentsSpaceLargeSizeEnabled *bool

	/* ConstituentsSpaceLocalTierFootprint.

	   Filter by constituents.space.local_tier_footprint
	*/
	ConstituentsSpaceLocalTierFootprint *int64

	/* ConstituentsSpaceLogicalSpaceAvailable.

	   Filter by constituents.space.logical_space.available
	*/
	ConstituentsSpaceLogicalSpaceAvailable *int64

	/* ConstituentsSpaceLogicalSpaceEnforcement.

	   Filter by constituents.space.logical_space.enforcement
	*/
	ConstituentsSpaceLogicalSpaceEnforcement *bool

	/* ConstituentsSpaceLogicalSpaceReporting.

	   Filter by constituents.space.logical_space.reporting
	*/
	ConstituentsSpaceLogicalSpaceReporting *bool

	/* ConstituentsSpaceLogicalSpaceUsedByAfs.

	   Filter by constituents.space.logical_space.used_by_afs
	*/
	ConstituentsSpaceLogicalSpaceUsedByAfs *int64

	/* ConstituentsSpaceMaxSize.

	   Filter by constituents.space.max_size
	*/
	ConstituentsSpaceMaxSize *string

	/* ConstituentsSpaceMetadata.

	   Filter by constituents.space.metadata
	*/
	ConstituentsSpaceMetadata *int64

	/* ConstituentsSpaceOverProvisioned.

	   Filter by constituents.space.over_provisioned
	*/
	ConstituentsSpaceOverProvisioned *int64

	/* ConstituentsSpacePerformanceTierFootprint.

	   Filter by constituents.space.performance_tier_footprint
	*/
	ConstituentsSpacePerformanceTierFootprint *int64

	/* ConstituentsSpaceSize.

	   Filter by constituents.space.size
	*/
	ConstituentsSpaceSize *int64

	/* ConstituentsSpaceSnapshotReservePercent.

	   Filter by constituents.space.snapshot.reserve_percent
	*/
	ConstituentsSpaceSnapshotReservePercent *int64

	/* ConstituentsSpaceSnapshotUsed.

	   Filter by constituents.space.snapshot.used
	*/
	ConstituentsSpaceSnapshotUsed *int64

	/* ConstituentsSpaceTotalFootprint.

	   Filter by constituents.space.total_footprint
	*/
	ConstituentsSpaceTotalFootprint *int64

	/* ConstituentsSpaceTotalMetadata.

	   Filter by constituents.space.total_metadata
	*/
	ConstituentsSpaceTotalMetadata *int64

	/* ConstituentsSpaceTotalMetadataFootprint.

	   Filter by constituents.space.total_metadata_footprint
	*/
	ConstituentsSpaceTotalMetadataFootprint *int64

	/* ConstituentsSpaceUsed.

	   Filter by constituents.space.used
	*/
	ConstituentsSpaceUsed *int64

	/* ConstituentsSpaceUsedByAfs.

	   Filter by constituents.space.used_by_afs
	*/
	ConstituentsSpaceUsedByAfs *int64

	/* ConstituentsSpaceUsedPercent.

	   Filter by constituents.space.used_percent
	*/
	ConstituentsSpaceUsedPercent *int64

	/* ConvertUnicode.

	   Filter by convert_unicode
	*/
	ConvertUnicode *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* EfficiencyApplicationIoSize.

	   Filter by efficiency.application_io_size
	*/
	EfficiencyApplicationIoSize *string

	/* EfficiencyAutoState.

	   Filter by efficiency.auto_state
	*/
	EfficiencyAutoState *string

	/* EfficiencyCompaction.

	   Filter by efficiency.compaction
	*/
	EfficiencyCompaction *string

	/* EfficiencyCompression.

	   Filter by efficiency.compression
	*/
	EfficiencyCompression *string

	/* EfficiencyCompressionType.

	   Filter by efficiency.compression_type
	*/
	EfficiencyCompressionType *string

	/* EfficiencyCrossVolumeDedupe.

	   Filter by efficiency.cross_volume_dedupe
	*/
	EfficiencyCrossVolumeDedupe *string

	/* EfficiencyDedupe.

	   Filter by efficiency.dedupe
	*/
	EfficiencyDedupe *string

	/* EfficiencyHasSavings.

	   Filter by efficiency.has_savings
	*/
	EfficiencyHasSavings *bool

	/* EfficiencyIdcsScannerEnabled.

	   Filter by efficiency.idcs_scanner.enabled
	*/
	EfficiencyIdcsScannerEnabled *bool

	/* EfficiencyIdcsScannerMode.

	   Filter by efficiency.idcs_scanner.mode
	*/
	EfficiencyIdcsScannerMode *string

	/* EfficiencyIdcsScannerOperationState.

	   Filter by efficiency.idcs_scanner.operation_state
	*/
	EfficiencyIdcsScannerOperationState *string

	/* EfficiencyIdcsScannerStatus.

	   Filter by efficiency.idcs_scanner.status
	*/
	EfficiencyIdcsScannerStatus *string

	/* EfficiencyIdcsScannerThresholdInactiveTime.

	   Filter by efficiency.idcs_scanner.threshold_inactive_time
	*/
	EfficiencyIdcsScannerThresholdInactiveTime *string

	/* EfficiencyLastOpBegin.

	   Filter by efficiency.last_op_begin
	*/
	EfficiencyLastOpBegin *string

	/* EfficiencyLastOpEnd.

	   Filter by efficiency.last_op_end
	*/
	EfficiencyLastOpEnd *string

	/* EfficiencyLastOpErr.

	   Filter by efficiency.last_op_err
	*/
	EfficiencyLastOpErr *string

	/* EfficiencyLastOpSize.

	   Filter by efficiency.last_op_size
	*/
	EfficiencyLastOpSize *int64

	/* EfficiencyLastOpState.

	   Filter by efficiency.last_op_state
	*/
	EfficiencyLastOpState *string

	/* EfficiencyLoggingEnabled.

	   Filter by efficiency.logging_enabled
	*/
	EfficiencyLoggingEnabled *bool

	/* EfficiencyOpState.

	   Filter by efficiency.op_state
	*/
	EfficiencyOpState *string

	/* EfficiencyPolicyName.

	   Filter by efficiency.policy.name
	*/
	EfficiencyPolicyName *string

	/* EfficiencyProgress.

	   Filter by efficiency.progress
	*/
	EfficiencyProgress *string

	/* EfficiencyRatio.

	   Filter by efficiency.ratio
	*/
	EfficiencyRatio *float64

	/* EfficiencyScannerCompression.

	   Filter by efficiency.scanner.compression
	*/
	EfficiencyScannerCompression *bool

	/* EfficiencyScannerDedupe.

	   Filter by efficiency.scanner.dedupe
	*/
	EfficiencyScannerDedupe *bool

	/* EfficiencyScannerScanOldData.

	   Filter by efficiency.scanner.scan_old_data
	*/
	EfficiencyScannerScanOldData *bool

	/* EfficiencyScannerState.

	   Filter by efficiency.scanner.state
	*/
	EfficiencyScannerState *string

	/* EfficiencySchedule.

	   Filter by efficiency.schedule
	*/
	EfficiencySchedule *string

	/* EfficiencySpaceSavingsCompression.

	   Filter by efficiency.space_savings.compression
	*/
	EfficiencySpaceSavingsCompression *int64

	/* EfficiencySpaceSavingsCompressionPercent.

	   Filter by efficiency.space_savings.compression_percent
	*/
	EfficiencySpaceSavingsCompressionPercent *int64

	/* EfficiencySpaceSavingsDedupe.

	   Filter by efficiency.space_savings.dedupe
	*/
	EfficiencySpaceSavingsDedupe *int64

	/* EfficiencySpaceSavingsDedupePercent.

	   Filter by efficiency.space_savings.dedupe_percent
	*/
	EfficiencySpaceSavingsDedupePercent *int64

	/* EfficiencySpaceSavingsDedupeSharing.

	   Filter by efficiency.space_savings.dedupe_sharing
	*/
	EfficiencySpaceSavingsDedupeSharing *int64

	/* EfficiencySpaceSavingsTotal.

	   Filter by efficiency.space_savings.total
	*/
	EfficiencySpaceSavingsTotal *int64

	/* EfficiencySpaceSavingsTotalPercent.

	   Filter by efficiency.space_savings.total_percent
	*/
	EfficiencySpaceSavingsTotalPercent *int64

	/* EfficiencyState.

	   Filter by efficiency.state
	*/
	EfficiencyState *string

	/* EfficiencyStorageEfficiencyMode.

	   Filter by efficiency.storage_efficiency_mode
	*/
	EfficiencyStorageEfficiencyMode *string

	/* EfficiencyType.

	   Filter by efficiency.type
	*/
	EfficiencyType *string

	/* EfficiencyVolumePath.

	   Filter by efficiency.volume_path
	*/
	EfficiencyVolumePath *string

	/* EncryptionAction.

	   Filter by encryption.action
	*/
	EncryptionAction *string

	/* EncryptionEnabled.

	   Filter by encryption.enabled
	*/
	EncryptionEnabled *bool

	/* EncryptionKeyCreateTime.

	   Filter by encryption.key_create_time
	*/
	EncryptionKeyCreateTime *string

	/* EncryptionKeyID.

	   Filter by encryption.key_id
	*/
	EncryptionKeyID *string

	/* EncryptionRekey.

	   Filter by encryption.rekey
	*/
	EncryptionRekey *bool

	/* EncryptionState.

	   Filter by encryption.state
	*/
	EncryptionState *string

	/* EncryptionStatusCode.

	   Filter by encryption.status.code
	*/
	EncryptionStatusCode *string

	/* EncryptionStatusMessage.

	   Filter by encryption.status.message
	*/
	EncryptionStatusMessage *string

	/* EncryptionType.

	   Filter by encryption.type
	*/
	EncryptionType *string

	/* ErrorStateHasBadBlocks.

	   Filter by error_state.has_bad_blocks
	*/
	ErrorStateHasBadBlocks *bool

	/* ErrorStateIsInconsistent.

	   Filter by error_state.is_inconsistent
	*/
	ErrorStateIsInconsistent *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FilesInodefileCapacity.

	   Filter by files.inodefile_capacity
	*/
	FilesInodefileCapacity *int64

	/* FilesMaximum.

	   Filter by files.maximum
	*/
	FilesMaximum *int64

	/* FilesUsed.

	   Filter by files.used
	*/
	FilesUsed *int64

	/* FlashPoolCacheEligibility.

	   Filter by flash_pool.cache_eligibility
	*/
	FlashPoolCacheEligibility *string

	/* FlashPoolCacheRetentionPriority.

	   Filter by flash_pool.cache_retention_priority
	*/
	FlashPoolCacheRetentionPriority *string

	/* FlashPoolCachingPolicy.

	   Filter by flash_pool.caching_policy
	*/
	FlashPoolCachingPolicy *string

	/* FlexcacheEndpointType.

	   Filter by flexcache_endpoint_type
	*/
	FlexcacheEndpointType *string

	/* FlexgroupName.

	   Filter by flexgroup.name
	*/
	FlexgroupName *string

	/* FlexgroupUUID.

	   Filter by flexgroup.uuid
	*/
	FlexgroupUUID *string

	/* GranularData.

	   Filter by granular_data
	*/
	GranularData *bool

	/* GranularDataMode.

	   Filter by granular_data_mode
	*/
	GranularDataMode *string

	/* GuaranteeHonored.

	   Filter by guarantee.honored
	*/
	GuaranteeHonored *bool

	/* GuaranteeType.

	   Filter by guarantee.type
	*/
	GuaranteeType *string

	/* HasDirIndexPublic.

	   Filter by has_dir_index_public
	*/
	HasDirIndexPublic *bool

	/* HasLargeDir.

	   Filter by has_large_dir
	*/
	HasLargeDir *bool

	/* IsConstituent.

	   When set to false, only FlexVol and FlexGroup volumes are returned.  When set to true, only FlexGroup constituent volumes are returned. Default for GET calls is false.
	*/
	IsConstituent *bool

	/* IsDirIndexTransferEnabled.

	   Filter by is_dir_index_transfer_enabled
	*/
	IsDirIndexTransferEnabled *bool

	/* IsLargeDirEnabled.

	   Filter by is_large_dir_enabled
	*/
	IsLargeDirEnabled *bool

	/* IsObjectStore.

	   Filter by is_object_store
	*/
	IsObjectStore *bool

	/* IsS3ArbitraryPartSizeEnabled.

	   Filter by is_s3_arbitrary_part_size_enabled
	*/
	IsS3ArbitraryPartSizeEnabled *bool

	/* IsSvmRoot.

	   Filter by is_svm_root
	*/
	IsSvmRoot *bool

	/* Language.

	   Filter by language
	*/
	Language *string

	/* MaxDirSize.

	   Filter by max_dir_size
	*/
	MaxDirSize *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MetricCloudDuration.

	   Filter by metric.cloud.duration
	*/
	MetricCloudDuration *string

	/* MetricCloudIopsOther.

	   Filter by metric.cloud.iops.other
	*/
	MetricCloudIopsOther *int64

	/* MetricCloudIopsRead.

	   Filter by metric.cloud.iops.read
	*/
	MetricCloudIopsRead *int64

	/* MetricCloudIopsTotal.

	   Filter by metric.cloud.iops.total
	*/
	MetricCloudIopsTotal *int64

	/* MetricCloudIopsWrite.

	   Filter by metric.cloud.iops.write
	*/
	MetricCloudIopsWrite *int64

	/* MetricCloudLatencyOther.

	   Filter by metric.cloud.latency.other
	*/
	MetricCloudLatencyOther *int64

	/* MetricCloudLatencyRead.

	   Filter by metric.cloud.latency.read
	*/
	MetricCloudLatencyRead *int64

	/* MetricCloudLatencyTotal.

	   Filter by metric.cloud.latency.total
	*/
	MetricCloudLatencyTotal *int64

	/* MetricCloudLatencyWrite.

	   Filter by metric.cloud.latency.write
	*/
	MetricCloudLatencyWrite *int64

	/* MetricCloudStatus.

	   Filter by metric.cloud.status
	*/
	MetricCloudStatus *string

	/* MetricCloudTimestamp.

	   Filter by metric.cloud.timestamp
	*/
	MetricCloudTimestamp *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricFlexcacheBandwidthSavings.

	   Filter by metric.flexcache.bandwidth_savings
	*/
	MetricFlexcacheBandwidthSavings *int64

	/* MetricFlexcacheCacheMissPercent.

	   Filter by metric.flexcache.cache_miss_percent
	*/
	MetricFlexcacheCacheMissPercent *int64

	/* MetricFlexcacheDuration.

	   Filter by metric.flexcache.duration
	*/
	MetricFlexcacheDuration *string

	/* MetricFlexcacheStatus.

	   Filter by metric.flexcache.status
	*/
	MetricFlexcacheStatus *string

	/* MetricFlexcacheTimestamp.

	   Filter by metric.flexcache.timestamp
	*/
	MetricFlexcacheTimestamp *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputOther.

	   Filter by metric.throughput.other
	*/
	MetricThroughputOther *int64

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MovementCapacityTierOptimized.

	   Filter by movement.capacity_tier_optimized
	*/
	MovementCapacityTierOptimized *bool

	/* MovementCutoverWindow.

	   Filter by movement.cutover_window
	*/
	MovementCutoverWindow *int64

	/* MovementDestinationAggregateName.

	   Filter by movement.destination_aggregate.name
	*/
	MovementDestinationAggregateName *string

	/* MovementDestinationAggregateUUID.

	   Filter by movement.destination_aggregate.uuid
	*/
	MovementDestinationAggregateUUID *string

	/* MovementPercentComplete.

	   Filter by movement.percent_complete
	*/
	MovementPercentComplete *int64

	/* MovementStartTime.

	   Filter by movement.start_time
	*/
	MovementStartTime *string

	/* MovementState.

	   Filter by movement.state
	*/
	MovementState *string

	/* MovementTieringPolicy.

	   Filter by movement.tiering_policy
	*/
	MovementTieringPolicy *string

	/* Msid.

	   Filter by msid
	*/
	Msid *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NasExportPolicyID.

	   Filter by nas.export_policy.id
	*/
	NasExportPolicyID *int64

	/* NasExportPolicyName.

	   Filter by nas.export_policy.name
	*/
	NasExportPolicyName *string

	/* NasGid.

	   Filter by nas.gid
	*/
	NasGid *int64

	/* NasJunctionParentName.

	   Filter by nas.junction_parent.name
	*/
	NasJunctionParentName *string

	/* NasJunctionParentUUID.

	   Filter by nas.junction_parent.uuid
	*/
	NasJunctionParentUUID *string

	/* NasPath.

	   Filter by nas.path
	*/
	NasPath *string

	/* NasSecurityStyle.

	   Filter by nas.security_style
	*/
	NasSecurityStyle *string

	/* NasUID.

	   Filter by nas.uid
	*/
	NasUID *int64

	/* NasUnixPermissions.

	   Filter by nas.unix_permissions
	*/
	NasUnixPermissions *int64

	/* NodesName.

	   Filter by nodes.name
	*/
	NodesName *string

	/* NodesUUID.

	   Filter by nodes.uuid
	*/
	NodesUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* QosPolicyMaxThroughput.

	   Filter by qos.policy.max_throughput
	*/
	QosPolicyMaxThroughput *string

	/* QosPolicyMaxThroughputIops.

	   Filter by qos.policy.max_throughput_iops
	*/
	QosPolicyMaxThroughputIops *int64

	/* QosPolicyMaxThroughputMbps.

	   Filter by qos.policy.max_throughput_mbps
	*/
	QosPolicyMaxThroughputMbps *int64

	/* QosPolicyMinThroughput.

	   Filter by qos.policy.min_throughput
	*/
	QosPolicyMinThroughput *string

	/* QosPolicyMinThroughputIops.

	   Filter by qos.policy.min_throughput_iops
	*/
	QosPolicyMinThroughputIops *int64

	/* QosPolicyMinThroughputMbps.

	   Filter by qos.policy.min_throughput_mbps
	*/
	QosPolicyMinThroughputMbps *int64

	/* QosPolicyName.

	   Filter by qos.policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter by qos.policy.uuid
	*/
	QosPolicyUUID *string

	/* QueueForEncryption.

	   Filter by queue_for_encryption
	*/
	QueueForEncryption *bool

	/* QuotaState.

	   Filter by quota.state
	*/
	QuotaState *string

	/* RebalancingDataMoved.

	   Filter by rebalancing.data_moved
	*/
	RebalancingDataMoved *int64

	/* RebalancingEngineMovementFileMovesStarted.

	   Filter by rebalancing.engine.movement.file_moves_started
	*/
	RebalancingEngineMovementFileMovesStarted *int64

	/* RebalancingEngineMovementLastErrorCode.

	   Filter by rebalancing.engine.movement.last_error.code
	*/
	RebalancingEngineMovementLastErrorCode *int64

	/* RebalancingEngineMovementLastErrorDestination.

	   Filter by rebalancing.engine.movement.last_error.destination
	*/
	RebalancingEngineMovementLastErrorDestination *int64

	/* RebalancingEngineMovementLastErrorFileID.

	   Filter by rebalancing.engine.movement.last_error.file_id
	*/
	RebalancingEngineMovementLastErrorFileID *int64

	/* RebalancingEngineMovementLastErrorTime.

	   Filter by rebalancing.engine.movement.last_error.time
	*/
	RebalancingEngineMovementLastErrorTime *string

	/* RebalancingEngineMovementMostRecentStartTime.

	   Filter by rebalancing.engine.movement.most_recent_start_time
	*/
	RebalancingEngineMovementMostRecentStartTime *string

	/* RebalancingEngineScannerBlocksScanned.

	   Filter by rebalancing.engine.scanner.blocks_scanned
	*/
	RebalancingEngineScannerBlocksScanned *int64

	/* RebalancingEngineScannerBlocksSkippedEfficiencyBlocks.

	   Filter by rebalancing.engine.scanner.blocks_skipped.efficiency_blocks
	*/
	RebalancingEngineScannerBlocksSkippedEfficiencyBlocks *int64

	/* RebalancingEngineScannerBlocksSkippedEfficiencyPercent.

	   Filter by rebalancing.engine.scanner.blocks_skipped.efficiency_percent
	*/
	RebalancingEngineScannerBlocksSkippedEfficiencyPercent *int64

	/* RebalancingEngineScannerBlocksSkippedFastTruncate.

	   Filter by rebalancing.engine.scanner.blocks_skipped.fast_truncate
	*/
	RebalancingEngineScannerBlocksSkippedFastTruncate *int64

	/* RebalancingEngineScannerBlocksSkippedFootprintInvalid.

	   Filter by rebalancing.engine.scanner.blocks_skipped.footprint_invalid
	*/
	RebalancingEngineScannerBlocksSkippedFootprintInvalid *int64

	/* RebalancingEngineScannerBlocksSkippedInSnapshot.

	   Filter by rebalancing.engine.scanner.blocks_skipped.in_snapshot
	*/
	RebalancingEngineScannerBlocksSkippedInSnapshot *int64

	/* RebalancingEngineScannerBlocksSkippedIncompatible.

	   Filter by rebalancing.engine.scanner.blocks_skipped.incompatible
	*/
	RebalancingEngineScannerBlocksSkippedIncompatible *int64

	/* RebalancingEngineScannerBlocksSkippedMetadata.

	   Filter by rebalancing.engine.scanner.blocks_skipped.metadata
	*/
	RebalancingEngineScannerBlocksSkippedMetadata *int64

	/* RebalancingEngineScannerBlocksSkippedOnDemandDestination.

	   Filter by rebalancing.engine.scanner.blocks_skipped.on_demand_destination
	*/
	RebalancingEngineScannerBlocksSkippedOnDemandDestination *int64

	/* RebalancingEngineScannerBlocksSkippedOther.

	   Filter by rebalancing.engine.scanner.blocks_skipped.other
	*/
	RebalancingEngineScannerBlocksSkippedOther *int64

	/* RebalancingEngineScannerBlocksSkippedRemoteCache.

	   Filter by rebalancing.engine.scanner.blocks_skipped.remote_cache
	*/
	RebalancingEngineScannerBlocksSkippedRemoteCache *int64

	/* RebalancingEngineScannerBlocksSkippedTooLarge.

	   Filter by rebalancing.engine.scanner.blocks_skipped.too_large
	*/
	RebalancingEngineScannerBlocksSkippedTooLarge *int64

	/* RebalancingEngineScannerBlocksSkippedTooSmall.

	   Filter by rebalancing.engine.scanner.blocks_skipped.too_small
	*/
	RebalancingEngineScannerBlocksSkippedTooSmall *int64

	/* RebalancingEngineScannerBlocksSkippedWriteFenced.

	   Filter by rebalancing.engine.scanner.blocks_skipped.write_fenced
	*/
	RebalancingEngineScannerBlocksSkippedWriteFenced *int64

	/* RebalancingEngineScannerFilesScanned.

	   Filter by rebalancing.engine.scanner.files_scanned
	*/
	RebalancingEngineScannerFilesScanned *int64

	/* RebalancingEngineScannerFilesSkippedEfficiencyBlocks.

	   Filter by rebalancing.engine.scanner.files_skipped.efficiency_blocks
	*/
	RebalancingEngineScannerFilesSkippedEfficiencyBlocks *int64

	/* RebalancingEngineScannerFilesSkippedEfficiencyPercent.

	   Filter by rebalancing.engine.scanner.files_skipped.efficiency_percent
	*/
	RebalancingEngineScannerFilesSkippedEfficiencyPercent *int64

	/* RebalancingEngineScannerFilesSkippedFastTruncate.

	   Filter by rebalancing.engine.scanner.files_skipped.fast_truncate
	*/
	RebalancingEngineScannerFilesSkippedFastTruncate *int64

	/* RebalancingEngineScannerFilesSkippedFootprintInvalid.

	   Filter by rebalancing.engine.scanner.files_skipped.footprint_invalid
	*/
	RebalancingEngineScannerFilesSkippedFootprintInvalid *int64

	/* RebalancingEngineScannerFilesSkippedInSnapshot.

	   Filter by rebalancing.engine.scanner.files_skipped.in_snapshot
	*/
	RebalancingEngineScannerFilesSkippedInSnapshot *int64

	/* RebalancingEngineScannerFilesSkippedIncompatible.

	   Filter by rebalancing.engine.scanner.files_skipped.incompatible
	*/
	RebalancingEngineScannerFilesSkippedIncompatible *int64

	/* RebalancingEngineScannerFilesSkippedMetadata.

	   Filter by rebalancing.engine.scanner.files_skipped.metadata
	*/
	RebalancingEngineScannerFilesSkippedMetadata *int64

	/* RebalancingEngineScannerFilesSkippedOnDemandDestination.

	   Filter by rebalancing.engine.scanner.files_skipped.on_demand_destination
	*/
	RebalancingEngineScannerFilesSkippedOnDemandDestination *int64

	/* RebalancingEngineScannerFilesSkippedOther.

	   Filter by rebalancing.engine.scanner.files_skipped.other
	*/
	RebalancingEngineScannerFilesSkippedOther *int64

	/* RebalancingEngineScannerFilesSkippedRemoteCache.

	   Filter by rebalancing.engine.scanner.files_skipped.remote_cache
	*/
	RebalancingEngineScannerFilesSkippedRemoteCache *int64

	/* RebalancingEngineScannerFilesSkippedTooLarge.

	   Filter by rebalancing.engine.scanner.files_skipped.too_large
	*/
	RebalancingEngineScannerFilesSkippedTooLarge *int64

	/* RebalancingEngineScannerFilesSkippedTooSmall.

	   Filter by rebalancing.engine.scanner.files_skipped.too_small
	*/
	RebalancingEngineScannerFilesSkippedTooSmall *int64

	/* RebalancingEngineScannerFilesSkippedWriteFenced.

	   Filter by rebalancing.engine.scanner.files_skipped.write_fenced
	*/
	RebalancingEngineScannerFilesSkippedWriteFenced *int64

	/* RebalancingExcludeSnapshots.

	   Filter by rebalancing.exclude_snapshots
	*/
	RebalancingExcludeSnapshots *bool

	/* RebalancingImbalancePercent.

	   Filter by rebalancing.imbalance_percent
	*/
	RebalancingImbalancePercent *int64

	/* RebalancingImbalanceSize.

	   Filter by rebalancing.imbalance_size
	*/
	RebalancingImbalanceSize *int64

	/* RebalancingMaxConstituentImbalancePercent.

	   Filter by rebalancing.max_constituent_imbalance_percent
	*/
	RebalancingMaxConstituentImbalancePercent *int64

	/* RebalancingMaxFileMoves.

	   Filter by rebalancing.max_file_moves
	*/
	RebalancingMaxFileMoves *int64

	/* RebalancingMaxRuntime.

	   Filter by rebalancing.max_runtime
	*/
	RebalancingMaxRuntime *string

	/* RebalancingMaxThreshold.

	   Filter by rebalancing.max_threshold
	*/
	RebalancingMaxThreshold *int64

	/* RebalancingMinFileSize.

	   Filter by rebalancing.min_file_size
	*/
	RebalancingMinFileSize *int64

	/* RebalancingMinThreshold.

	   Filter by rebalancing.min_threshold
	*/
	RebalancingMinThreshold *int64

	/* RebalancingNoticesArgumentsCode.

	   Filter by rebalancing.notices.arguments.code
	*/
	RebalancingNoticesArgumentsCode *string

	/* RebalancingNoticesArgumentsMessage.

	   Filter by rebalancing.notices.arguments.message
	*/
	RebalancingNoticesArgumentsMessage *string

	/* RebalancingNoticesCode.

	   Filter by rebalancing.notices.code
	*/
	RebalancingNoticesCode *string

	/* RebalancingNoticesMessage.

	   Filter by rebalancing.notices.message
	*/
	RebalancingNoticesMessage *string

	/* RebalancingRuntime.

	   Filter by rebalancing.runtime
	*/
	RebalancingRuntime *string

	/* RebalancingStartTime.

	   Filter by rebalancing.start_time
	*/
	RebalancingStartTime *string

	/* RebalancingState.

	   Filter by rebalancing.state
	*/
	RebalancingState *string

	/* RebalancingStopTime.

	   Filter by rebalancing.stop_time
	*/
	RebalancingStopTime *string

	/* RebalancingTargetUsed.

	   Filter by rebalancing.target_used
	*/
	RebalancingTargetUsed *int64

	/* RebalancingUsedForImbalance.

	   Filter by rebalancing.used_for_imbalance
	*/
	RebalancingUsedForImbalance *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScheduledSnapshotNamingScheme.

	   Filter by scheduled_snapshot_naming_scheme
	*/
	ScheduledSnapshotNamingScheme *string

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* SnaplockAppendModeEnabled.

	   Filter by snaplock.append_mode_enabled
	*/
	SnaplockAppendModeEnabled *bool

	/* SnaplockAutocommitPeriod.

	   Filter by snaplock.autocommit_period
	*/
	SnaplockAutocommitPeriod *string

	/* SnaplockComplianceClockTime.

	   Filter by snaplock.compliance_clock_time
	*/
	SnaplockComplianceClockTime *string

	/* SnaplockExpiryTime.

	   Filter by snaplock.expiry_time
	*/
	SnaplockExpiryTime *string

	/* SnaplockIsAuditLog.

	   Filter by snaplock.is_audit_log
	*/
	SnaplockIsAuditLog *bool

	/* SnaplockLitigationCount.

	   Filter by snaplock.litigation_count
	*/
	SnaplockLitigationCount *int64

	/* SnaplockPrivilegedDelete.

	   Filter by snaplock.privileged_delete
	*/
	SnaplockPrivilegedDelete *string

	/* SnaplockRetentionDefault.

	   Filter by snaplock.retention.default
	*/
	SnaplockRetentionDefault *string

	/* SnaplockRetentionMaximum.

	   Filter by snaplock.retention.maximum
	*/
	SnaplockRetentionMaximum *string

	/* SnaplockRetentionMinimum.

	   Filter by snaplock.retention.minimum
	*/
	SnaplockRetentionMinimum *string

	/* SnaplockType.

	   Filter by snaplock.type
	*/
	SnaplockType *string

	/* SnaplockUnspecifiedRetentionFileCount.

	   Filter by snaplock.unspecified_retention_file_count
	*/
	SnaplockUnspecifiedRetentionFileCount *int64

	/* SnapmirrorDestinationsIsCloud.

	   Filter by snapmirror.destinations.is_cloud
	*/
	SnapmirrorDestinationsIsCloud *bool

	/* SnapmirrorDestinationsIsOntap.

	   Filter by snapmirror.destinations.is_ontap
	*/
	SnapmirrorDestinationsIsOntap *bool

	/* SnapmirrorIsProtected.

	   Filter by snapmirror.is_protected
	*/
	SnapmirrorIsProtected *bool

	/* SnapshotCount.

	   Filter by snapshot_count
	*/
	SnapshotCount *int64

	/* SnapshotDirectoryAccessEnabled.

	   Filter by snapshot_directory_access_enabled
	*/
	SnapshotDirectoryAccessEnabled *bool

	/* SnapshotLockingEnabled.

	   Filter by snapshot_locking_enabled
	*/
	SnapshotLockingEnabled *bool

	/* SnapshotPolicyName.

	   Filter by snapshot_policy.name
	*/
	SnapshotPolicyName *string

	/* SnapshotPolicyUUID.

	   Filter by snapshot_policy.uuid
	*/
	SnapshotPolicyUUID *string

	/* SpaceAfsTotal.

	   Filter by space.afs_total
	*/
	SpaceAfsTotal *int64

	/* SpaceAutoAdaptiveCompressionFootprintDataReduction.

	   Filter by space.auto_adaptive_compression_footprint_data_reduction
	*/
	SpaceAutoAdaptiveCompressionFootprintDataReduction *int64

	/* SpaceAvailable.

	   Filter by space.available
	*/
	SpaceAvailable *int64

	/* SpaceAvailablePercent.

	   Filter by space.available_percent
	*/
	SpaceAvailablePercent *int64

	/* SpaceBlockStorageInactiveUserData.

	   Filter by space.block_storage_inactive_user_data
	*/
	SpaceBlockStorageInactiveUserData *int64

	/* SpaceBlockStorageInactiveUserDataPercent.

	   Filter by space.block_storage_inactive_user_data_percent
	*/
	SpaceBlockStorageInactiveUserDataPercent *int64

	/* SpaceCapacityTierFootprint.

	   Filter by space.capacity_tier_footprint
	*/
	SpaceCapacityTierFootprint *int64

	/* SpaceCapacityTierFootprintDataReduction.

	   Filter by space.capacity_tier_footprint_data_reduction
	*/
	SpaceCapacityTierFootprintDataReduction *int64

	/* SpaceCompactionFootprintDataReduction.

	   Filter by space.compaction_footprint_data_reduction
	*/
	SpaceCompactionFootprintDataReduction *int64

	/* SpaceCrossVolumeDedupeMetafilesFootprint.

	   Filter by space.cross_volume_dedupe_metafiles_footprint
	*/
	SpaceCrossVolumeDedupeMetafilesFootprint *int64

	/* SpaceCrossVolumeDedupeMetafilesTemporaryFootprint.

	   Filter by space.cross_volume_dedupe_metafiles_temporary_footprint
	*/
	SpaceCrossVolumeDedupeMetafilesTemporaryFootprint *int64

	/* SpaceDedupeMetafilesFootprint.

	   Filter by space.dedupe_metafiles_footprint
	*/
	SpaceDedupeMetafilesFootprint *int64

	/* SpaceDedupeMetafilesTemporaryFootprint.

	   Filter by space.dedupe_metafiles_temporary_footprint
	*/
	SpaceDedupeMetafilesTemporaryFootprint *int64

	/* SpaceDelayedFreeFootprint.

	   Filter by space.delayed_free_footprint
	*/
	SpaceDelayedFreeFootprint *int64

	/* SpaceEffectiveTotalFootprint.

	   Filter by space.effective_total_footprint
	*/
	SpaceEffectiveTotalFootprint *int64

	/* SpaceExpectedAvailable.

	   Filter by space.expected_available
	*/
	SpaceExpectedAvailable *int64

	/* SpaceFileOperationMetadata.

	   Filter by space.file_operation_metadata
	*/
	SpaceFileOperationMetadata *int64

	/* SpaceFilesystemSize.

	   Filter by space.filesystem_size
	*/
	SpaceFilesystemSize *int64

	/* SpaceFilesystemSizeFixed.

	   Filter by space.filesystem_size_fixed
	*/
	SpaceFilesystemSizeFixed *bool

	/* SpaceFootprint.

	   Filter by space.footprint
	*/
	SpaceFootprint *int64

	/* SpaceFractionalReserve.

	   Filter by space.fractional_reserve
	*/
	SpaceFractionalReserve *int64

	/* SpaceFullThresholdPercent.

	   Filter by space.full_threshold_percent
	*/
	SpaceFullThresholdPercent *int64

	/* SpaceIsUsedStale.

	   Filter by space.is_used_stale
	*/
	SpaceIsUsedStale *bool

	/* SpaceLargeSizeEnabled.

	   Filter by space.large_size_enabled
	*/
	SpaceLargeSizeEnabled *bool

	/* SpaceLocalTierFootprint.

	   Filter by space.local_tier_footprint
	*/
	SpaceLocalTierFootprint *int64

	/* SpaceLogicalSpaceAvailable.

	   Filter by space.logical_space.available
	*/
	SpaceLogicalSpaceAvailable *int64

	/* SpaceLogicalSpaceEnforcement.

	   Filter by space.logical_space.enforcement
	*/
	SpaceLogicalSpaceEnforcement *bool

	/* SpaceLogicalSpaceReporting.

	   Filter by space.logical_space.reporting
	*/
	SpaceLogicalSpaceReporting *bool

	/* SpaceLogicalSpaceUsed.

	   Filter by space.logical_space.used
	*/
	SpaceLogicalSpaceUsed *int64

	/* SpaceLogicalSpaceUsedByAfs.

	   Filter by space.logical_space.used_by_afs
	*/
	SpaceLogicalSpaceUsedByAfs *int64

	/* SpaceLogicalSpaceUsedBySnapshots.

	   Filter by space.logical_space.used_by_snapshots
	*/
	SpaceLogicalSpaceUsedBySnapshots *int64

	/* SpaceLogicalSpaceUsedPercent.

	   Filter by space.logical_space.used_percent
	*/
	SpaceLogicalSpaceUsedPercent *int64

	/* SpaceMaxSize.

	   Filter by space.max_size
	*/
	SpaceMaxSize *string

	/* SpaceMetadata.

	   Filter by space.metadata
	*/
	SpaceMetadata *int64

	/* SpaceNearlyFullThresholdPercent.

	   Filter by space.nearly_full_threshold_percent
	*/
	SpaceNearlyFullThresholdPercent *int64

	/* SpaceOverProvisioned.

	   Filter by space.over_provisioned
	*/
	SpaceOverProvisioned *int64

	/* SpaceOverwriteReserve.

	   Filter by space.overwrite_reserve
	*/
	SpaceOverwriteReserve *int64

	/* SpaceOverwriteReserveUsed.

	   Filter by space.overwrite_reserve_used
	*/
	SpaceOverwriteReserveUsed *int64

	/* SpacePercentUsed.

	   Filter by space.percent_used
	*/
	SpacePercentUsed *int64

	/* SpacePerformanceTierFootprint.

	   Filter by space.performance_tier_footprint
	*/
	SpacePerformanceTierFootprint *int64

	/* SpacePhysicalUsed.

	   Filter by space.physical_used
	*/
	SpacePhysicalUsed *int64

	/* SpacePhysicalUsedPercent.

	   Filter by space.physical_used_percent
	*/
	SpacePhysicalUsedPercent *int64

	/* SpaceSize.

	   Filter by space.size
	*/
	SpaceSize *int64

	/* SpaceSizeAvailableForSnapshots.

	   Filter by space.size_available_for_snapshots
	*/
	SpaceSizeAvailableForSnapshots *int64

	/* SpaceSnapmirrorDestinationFootprint.

	   Filter by space.snapmirror_destination_footprint
	*/
	SpaceSnapmirrorDestinationFootprint *int64

	/* SpaceSnapshotAutodeleteCommitment.

	   Filter by space.snapshot.autodelete.commitment
	*/
	SpaceSnapshotAutodeleteCommitment *string

	/* SpaceSnapshotAutodeleteDeferDelete.

	   Filter by space.snapshot.autodelete.defer_delete
	*/
	SpaceSnapshotAutodeleteDeferDelete *string

	/* SpaceSnapshotAutodeleteDeleteOrder.

	   Filter by space.snapshot.autodelete.delete_order
	*/
	SpaceSnapshotAutodeleteDeleteOrder *string

	/* SpaceSnapshotAutodeletePrefix.

	   Filter by space.snapshot.autodelete.prefix
	*/
	SpaceSnapshotAutodeletePrefix *string

	/* SpaceSnapshotAutodeleteTargetFreeSpace.

	   Filter by space.snapshot.autodelete.target_free_space
	*/
	SpaceSnapshotAutodeleteTargetFreeSpace *int64

	/* SpaceSnapshotAutodeleteTrigger.

	   Filter by space.snapshot.autodelete_trigger
	*/
	SpaceSnapshotAutodeleteTrigger *string

	/* SpaceSnapshotReserveAvailable.

	   Filter by space.snapshot.reserve_available
	*/
	SpaceSnapshotReserveAvailable *int64

	/* SpaceSnapshotReservePercent.

	   Filter by space.snapshot.reserve_percent
	*/
	SpaceSnapshotReservePercent *int64

	/* SpaceSnapshotReserveSize.

	   Filter by space.snapshot.reserve_size
	*/
	SpaceSnapshotReserveSize *int64

	/* SpaceSnapshotSpaceUsedPercent.

	   Filter by space.snapshot.space_used_percent
	*/
	SpaceSnapshotSpaceUsedPercent *int64

	/* SpaceSnapshotUsed.

	   Filter by space.snapshot.used
	*/
	SpaceSnapshotUsed *int64

	/* SpaceSnapshotReserveUnusable.

	   Filter by space.snapshot_reserve_unusable
	*/
	SpaceSnapshotReserveUnusable *int64

	/* SpaceSnapshotSpill.

	   Filter by space.snapshot_spill
	*/
	SpaceSnapshotSpill *int64

	/* SpaceTotalFootprint.

	   Filter by space.total_footprint
	*/
	SpaceTotalFootprint *int64

	/* SpaceTotalMetadata.

	   Filter by space.total_metadata
	*/
	SpaceTotalMetadata *int64

	/* SpaceTotalMetadataFootprint.

	   Filter by space.total_metadata_footprint
	*/
	SpaceTotalMetadataFootprint *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* SpaceUsedByAfs.

	   Filter by space.used_by_afs
	*/
	SpaceUsedByAfs *int64

	/* SpaceUserData.

	   Filter by space.user_data
	*/
	SpaceUserData *int64

	/* SpaceVolumeGuaranteeFootprint.

	   Filter by space.volume_guarantee_footprint
	*/
	SpaceVolumeGuaranteeFootprint *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsCifsOpsRawAccessCount.

	   Filter by statistics.cifs_ops_raw.access.count
	*/
	StatisticsCifsOpsRawAccessCount *int64

	/* StatisticsCifsOpsRawAccessTotalTime.

	   Filter by statistics.cifs_ops_raw.access.total_time
	*/
	StatisticsCifsOpsRawAccessTotalTime *int64

	/* StatisticsCifsOpsRawAuditCount.

	   Filter by statistics.cifs_ops_raw.audit.count
	*/
	StatisticsCifsOpsRawAuditCount *int64

	/* StatisticsCifsOpsRawAuditTotalTime.

	   Filter by statistics.cifs_ops_raw.audit.total_time
	*/
	StatisticsCifsOpsRawAuditTotalTime *int64

	/* StatisticsCifsOpsRawCreateDirCount.

	   Filter by statistics.cifs_ops_raw.create.dir.count
	*/
	StatisticsCifsOpsRawCreateDirCount *int64

	/* StatisticsCifsOpsRawCreateDirTotalTime.

	   Filter by statistics.cifs_ops_raw.create.dir.total_time
	*/
	StatisticsCifsOpsRawCreateDirTotalTime *int64

	/* StatisticsCifsOpsRawCreateFileCount.

	   Filter by statistics.cifs_ops_raw.create.file.count
	*/
	StatisticsCifsOpsRawCreateFileCount *int64

	/* StatisticsCifsOpsRawCreateFileTotalTime.

	   Filter by statistics.cifs_ops_raw.create.file.total_time
	*/
	StatisticsCifsOpsRawCreateFileTotalTime *int64

	/* StatisticsCifsOpsRawCreateOtherCount.

	   Filter by statistics.cifs_ops_raw.create.other.count
	*/
	StatisticsCifsOpsRawCreateOtherCount *int64

	/* StatisticsCifsOpsRawCreateOtherTotalTime.

	   Filter by statistics.cifs_ops_raw.create.other.total_time
	*/
	StatisticsCifsOpsRawCreateOtherTotalTime *int64

	/* StatisticsCifsOpsRawCreateSymlinkCount.

	   Filter by statistics.cifs_ops_raw.create.symlink.count
	*/
	StatisticsCifsOpsRawCreateSymlinkCount *int64

	/* StatisticsCifsOpsRawCreateSymlinkTotalTime.

	   Filter by statistics.cifs_ops_raw.create.symlink.total_time
	*/
	StatisticsCifsOpsRawCreateSymlinkTotalTime *int64

	/* StatisticsCifsOpsRawGetattrCount.

	   Filter by statistics.cifs_ops_raw.getattr.count
	*/
	StatisticsCifsOpsRawGetattrCount *int64

	/* StatisticsCifsOpsRawGetattrTotalTime.

	   Filter by statistics.cifs_ops_raw.getattr.total_time
	*/
	StatisticsCifsOpsRawGetattrTotalTime *int64

	/* StatisticsCifsOpsRawLinkCount.

	   Filter by statistics.cifs_ops_raw.link.count
	*/
	StatisticsCifsOpsRawLinkCount *int64

	/* StatisticsCifsOpsRawLinkTotalTime.

	   Filter by statistics.cifs_ops_raw.link.total_time
	*/
	StatisticsCifsOpsRawLinkTotalTime *int64

	/* StatisticsCifsOpsRawLockCount.

	   Filter by statistics.cifs_ops_raw.lock.count
	*/
	StatisticsCifsOpsRawLockCount *int64

	/* StatisticsCifsOpsRawLockTotalTime.

	   Filter by statistics.cifs_ops_raw.lock.total_time
	*/
	StatisticsCifsOpsRawLockTotalTime *int64

	/* StatisticsCifsOpsRawLookupCount.

	   Filter by statistics.cifs_ops_raw.lookup.count
	*/
	StatisticsCifsOpsRawLookupCount *int64

	/* StatisticsCifsOpsRawLookupTotalTime.

	   Filter by statistics.cifs_ops_raw.lookup.total_time
	*/
	StatisticsCifsOpsRawLookupTotalTime *int64

	/* StatisticsCifsOpsRawOpenCount.

	   Filter by statistics.cifs_ops_raw.open.count
	*/
	StatisticsCifsOpsRawOpenCount *int64

	/* StatisticsCifsOpsRawOpenTotalTime.

	   Filter by statistics.cifs_ops_raw.open.total_time
	*/
	StatisticsCifsOpsRawOpenTotalTime *int64

	/* StatisticsCifsOpsRawReadCount.

	   Filter by statistics.cifs_ops_raw.read.count
	*/
	StatisticsCifsOpsRawReadCount *int64

	/* StatisticsCifsOpsRawReadTotalTime.

	   Filter by statistics.cifs_ops_raw.read.total_time
	*/
	StatisticsCifsOpsRawReadTotalTime *int64

	/* StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts.

	   Filter by statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_counts
	*/
	StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64

	/* StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels.

	   Filter by statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_labels
	*/
	StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels *string

	/* StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts.

	   Filter by statistics.cifs_ops_raw.read.volume_protocol_size_histogram_counts
	*/
	StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts *int64

	/* StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels.

	   Filter by statistics.cifs_ops_raw.read.volume_protocol_size_histogram_labels
	*/
	StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels *string

	/* StatisticsCifsOpsRawReaddirCount.

	   Filter by statistics.cifs_ops_raw.readdir.count
	*/
	StatisticsCifsOpsRawReaddirCount *int64

	/* StatisticsCifsOpsRawReaddirTotalTime.

	   Filter by statistics.cifs_ops_raw.readdir.total_time
	*/
	StatisticsCifsOpsRawReaddirTotalTime *int64

	/* StatisticsCifsOpsRawReadlinkCount.

	   Filter by statistics.cifs_ops_raw.readlink.count
	*/
	StatisticsCifsOpsRawReadlinkCount *int64

	/* StatisticsCifsOpsRawReadlinkTotalTime.

	   Filter by statistics.cifs_ops_raw.readlink.total_time
	*/
	StatisticsCifsOpsRawReadlinkTotalTime *int64

	/* StatisticsCifsOpsRawRenameCount.

	   Filter by statistics.cifs_ops_raw.rename.count
	*/
	StatisticsCifsOpsRawRenameCount *int64

	/* StatisticsCifsOpsRawRenameTotalTime.

	   Filter by statistics.cifs_ops_raw.rename.total_time
	*/
	StatisticsCifsOpsRawRenameTotalTime *int64

	/* StatisticsCifsOpsRawSetattrCount.

	   Filter by statistics.cifs_ops_raw.setattr.count
	*/
	StatisticsCifsOpsRawSetattrCount *int64

	/* StatisticsCifsOpsRawSetattrTotalTime.

	   Filter by statistics.cifs_ops_raw.setattr.total_time
	*/
	StatisticsCifsOpsRawSetattrTotalTime *int64

	/* StatisticsCifsOpsRawUnlinkCount.

	   Filter by statistics.cifs_ops_raw.unlink.count
	*/
	StatisticsCifsOpsRawUnlinkCount *int64

	/* StatisticsCifsOpsRawUnlinkTotalTime.

	   Filter by statistics.cifs_ops_raw.unlink.total_time
	*/
	StatisticsCifsOpsRawUnlinkTotalTime *int64

	/* StatisticsCifsOpsRawWatchCount.

	   Filter by statistics.cifs_ops_raw.watch.count
	*/
	StatisticsCifsOpsRawWatchCount *int64

	/* StatisticsCifsOpsRawWatchTotalTime.

	   Filter by statistics.cifs_ops_raw.watch.total_time
	*/
	StatisticsCifsOpsRawWatchTotalTime *int64

	/* StatisticsCifsOpsRawWriteCount.

	   Filter by statistics.cifs_ops_raw.write.count
	*/
	StatisticsCifsOpsRawWriteCount *int64

	/* StatisticsCifsOpsRawWriteTotalTime.

	   Filter by statistics.cifs_ops_raw.write.total_time
	*/
	StatisticsCifsOpsRawWriteTotalTime *int64

	/* StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts.

	   Filter by statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_counts
	*/
	StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64

	/* StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels.

	   Filter by statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_labels
	*/
	StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string

	/* StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts.

	   Filter by statistics.cifs_ops_raw.write.volume_protocol_size_histogram_counts
	*/
	StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64

	/* StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels.

	   Filter by statistics.cifs_ops_raw.write.volume_protocol_size_histogram_labels
	*/
	StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels *string

	/* StatisticsCloudIopsRawOther.

	   Filter by statistics.cloud.iops_raw.other
	*/
	StatisticsCloudIopsRawOther *int64

	/* StatisticsCloudIopsRawRead.

	   Filter by statistics.cloud.iops_raw.read
	*/
	StatisticsCloudIopsRawRead *int64

	/* StatisticsCloudIopsRawTotal.

	   Filter by statistics.cloud.iops_raw.total
	*/
	StatisticsCloudIopsRawTotal *int64

	/* StatisticsCloudIopsRawWrite.

	   Filter by statistics.cloud.iops_raw.write
	*/
	StatisticsCloudIopsRawWrite *int64

	/* StatisticsCloudLatencyRawOther.

	   Filter by statistics.cloud.latency_raw.other
	*/
	StatisticsCloudLatencyRawOther *int64

	/* StatisticsCloudLatencyRawRead.

	   Filter by statistics.cloud.latency_raw.read
	*/
	StatisticsCloudLatencyRawRead *int64

	/* StatisticsCloudLatencyRawTotal.

	   Filter by statistics.cloud.latency_raw.total
	*/
	StatisticsCloudLatencyRawTotal *int64

	/* StatisticsCloudLatencyRawWrite.

	   Filter by statistics.cloud.latency_raw.write
	*/
	StatisticsCloudLatencyRawWrite *int64

	/* StatisticsCloudStatus.

	   Filter by statistics.cloud.status
	*/
	StatisticsCloudStatus *string

	/* StatisticsCloudTimestamp.

	   Filter by statistics.cloud.timestamp
	*/
	StatisticsCloudTimestamp *string

	/* StatisticsFlexcacheRawCacheMissBlocks.

	   Filter by statistics.flexcache_raw.cache_miss_blocks
	*/
	StatisticsFlexcacheRawCacheMissBlocks *int64

	/* StatisticsFlexcacheRawClientRequestedBlocks.

	   Filter by statistics.flexcache_raw.client_requested_blocks
	*/
	StatisticsFlexcacheRawClientRequestedBlocks *int64

	/* StatisticsFlexcacheRawStatus.

	   Filter by statistics.flexcache_raw.status
	*/
	StatisticsFlexcacheRawStatus *string

	/* StatisticsFlexcacheRawTimestamp.

	   Filter by statistics.flexcache_raw.timestamp
	*/
	StatisticsFlexcacheRawTimestamp *string

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsNfsOpsRawAccessCount.

	   Filter by statistics.nfs_ops_raw.access.count
	*/
	StatisticsNfsOpsRawAccessCount *int64

	/* StatisticsNfsOpsRawAccessTotalTime.

	   Filter by statistics.nfs_ops_raw.access.total_time
	*/
	StatisticsNfsOpsRawAccessTotalTime *int64

	/* StatisticsNfsOpsRawAuditCount.

	   Filter by statistics.nfs_ops_raw.audit.count
	*/
	StatisticsNfsOpsRawAuditCount *int64

	/* StatisticsNfsOpsRawAuditTotalTime.

	   Filter by statistics.nfs_ops_raw.audit.total_time
	*/
	StatisticsNfsOpsRawAuditTotalTime *int64

	/* StatisticsNfsOpsRawCreateDirCount.

	   Filter by statistics.nfs_ops_raw.create.dir.count
	*/
	StatisticsNfsOpsRawCreateDirCount *int64

	/* StatisticsNfsOpsRawCreateDirTotalTime.

	   Filter by statistics.nfs_ops_raw.create.dir.total_time
	*/
	StatisticsNfsOpsRawCreateDirTotalTime *int64

	/* StatisticsNfsOpsRawCreateFileCount.

	   Filter by statistics.nfs_ops_raw.create.file.count
	*/
	StatisticsNfsOpsRawCreateFileCount *int64

	/* StatisticsNfsOpsRawCreateFileTotalTime.

	   Filter by statistics.nfs_ops_raw.create.file.total_time
	*/
	StatisticsNfsOpsRawCreateFileTotalTime *int64

	/* StatisticsNfsOpsRawCreateOtherCount.

	   Filter by statistics.nfs_ops_raw.create.other.count
	*/
	StatisticsNfsOpsRawCreateOtherCount *int64

	/* StatisticsNfsOpsRawCreateOtherTotalTime.

	   Filter by statistics.nfs_ops_raw.create.other.total_time
	*/
	StatisticsNfsOpsRawCreateOtherTotalTime *int64

	/* StatisticsNfsOpsRawCreateSymlinkCount.

	   Filter by statistics.nfs_ops_raw.create.symlink.count
	*/
	StatisticsNfsOpsRawCreateSymlinkCount *int64

	/* StatisticsNfsOpsRawCreateSymlinkTotalTime.

	   Filter by statistics.nfs_ops_raw.create.symlink.total_time
	*/
	StatisticsNfsOpsRawCreateSymlinkTotalTime *int64

	/* StatisticsNfsOpsRawGetattrCount.

	   Filter by statistics.nfs_ops_raw.getattr.count
	*/
	StatisticsNfsOpsRawGetattrCount *int64

	/* StatisticsNfsOpsRawGetattrTotalTime.

	   Filter by statistics.nfs_ops_raw.getattr.total_time
	*/
	StatisticsNfsOpsRawGetattrTotalTime *int64

	/* StatisticsNfsOpsRawLinkCount.

	   Filter by statistics.nfs_ops_raw.link.count
	*/
	StatisticsNfsOpsRawLinkCount *int64

	/* StatisticsNfsOpsRawLinkTotalTime.

	   Filter by statistics.nfs_ops_raw.link.total_time
	*/
	StatisticsNfsOpsRawLinkTotalTime *int64

	/* StatisticsNfsOpsRawLockCount.

	   Filter by statistics.nfs_ops_raw.lock.count
	*/
	StatisticsNfsOpsRawLockCount *int64

	/* StatisticsNfsOpsRawLockTotalTime.

	   Filter by statistics.nfs_ops_raw.lock.total_time
	*/
	StatisticsNfsOpsRawLockTotalTime *int64

	/* StatisticsNfsOpsRawLookupCount.

	   Filter by statistics.nfs_ops_raw.lookup.count
	*/
	StatisticsNfsOpsRawLookupCount *int64

	/* StatisticsNfsOpsRawLookupTotalTime.

	   Filter by statistics.nfs_ops_raw.lookup.total_time
	*/
	StatisticsNfsOpsRawLookupTotalTime *int64

	/* StatisticsNfsOpsRawOpenCount.

	   Filter by statistics.nfs_ops_raw.open.count
	*/
	StatisticsNfsOpsRawOpenCount *int64

	/* StatisticsNfsOpsRawOpenTotalTime.

	   Filter by statistics.nfs_ops_raw.open.total_time
	*/
	StatisticsNfsOpsRawOpenTotalTime *int64

	/* StatisticsNfsOpsRawReadCount.

	   Filter by statistics.nfs_ops_raw.read.count
	*/
	StatisticsNfsOpsRawReadCount *int64

	/* StatisticsNfsOpsRawReadTotalTime.

	   Filter by statistics.nfs_ops_raw.read.total_time
	*/
	StatisticsNfsOpsRawReadTotalTime *int64

	/* StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts.

	   Filter by statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_counts
	*/
	StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64

	/* StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels.

	   Filter by statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_labels
	*/
	StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels *string

	/* StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts.

	   Filter by statistics.nfs_ops_raw.read.volume_protocol_size_histogram_counts
	*/
	StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts *int64

	/* StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels.

	   Filter by statistics.nfs_ops_raw.read.volume_protocol_size_histogram_labels
	*/
	StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels *string

	/* StatisticsNfsOpsRawReaddirCount.

	   Filter by statistics.nfs_ops_raw.readdir.count
	*/
	StatisticsNfsOpsRawReaddirCount *int64

	/* StatisticsNfsOpsRawReaddirTotalTime.

	   Filter by statistics.nfs_ops_raw.readdir.total_time
	*/
	StatisticsNfsOpsRawReaddirTotalTime *int64

	/* StatisticsNfsOpsRawReadlinkCount.

	   Filter by statistics.nfs_ops_raw.readlink.count
	*/
	StatisticsNfsOpsRawReadlinkCount *int64

	/* StatisticsNfsOpsRawReadlinkTotalTime.

	   Filter by statistics.nfs_ops_raw.readlink.total_time
	*/
	StatisticsNfsOpsRawReadlinkTotalTime *int64

	/* StatisticsNfsOpsRawRenameCount.

	   Filter by statistics.nfs_ops_raw.rename.count
	*/
	StatisticsNfsOpsRawRenameCount *int64

	/* StatisticsNfsOpsRawRenameTotalTime.

	   Filter by statistics.nfs_ops_raw.rename.total_time
	*/
	StatisticsNfsOpsRawRenameTotalTime *int64

	/* StatisticsNfsOpsRawSetattrCount.

	   Filter by statistics.nfs_ops_raw.setattr.count
	*/
	StatisticsNfsOpsRawSetattrCount *int64

	/* StatisticsNfsOpsRawSetattrTotalTime.

	   Filter by statistics.nfs_ops_raw.setattr.total_time
	*/
	StatisticsNfsOpsRawSetattrTotalTime *int64

	/* StatisticsNfsOpsRawUnlinkCount.

	   Filter by statistics.nfs_ops_raw.unlink.count
	*/
	StatisticsNfsOpsRawUnlinkCount *int64

	/* StatisticsNfsOpsRawUnlinkTotalTime.

	   Filter by statistics.nfs_ops_raw.unlink.total_time
	*/
	StatisticsNfsOpsRawUnlinkTotalTime *int64

	/* StatisticsNfsOpsRawWatchCount.

	   Filter by statistics.nfs_ops_raw.watch.count
	*/
	StatisticsNfsOpsRawWatchCount *int64

	/* StatisticsNfsOpsRawWatchTotalTime.

	   Filter by statistics.nfs_ops_raw.watch.total_time
	*/
	StatisticsNfsOpsRawWatchTotalTime *int64

	/* StatisticsNfsOpsRawWriteCount.

	   Filter by statistics.nfs_ops_raw.write.count
	*/
	StatisticsNfsOpsRawWriteCount *int64

	/* StatisticsNfsOpsRawWriteTotalTime.

	   Filter by statistics.nfs_ops_raw.write.total_time
	*/
	StatisticsNfsOpsRawWriteTotalTime *int64

	/* StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts.

	   Filter by statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_counts
	*/
	StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64

	/* StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels.

	   Filter by statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_labels
	*/
	StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string

	/* StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts.

	   Filter by statistics.nfs_ops_raw.write.volume_protocol_size_histogram_counts
	*/
	StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64

	/* StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels.

	   Filter by statistics.nfs_ops_raw.write.volume_protocol_size_histogram_labels
	*/
	StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels *string

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawOther.

	   Filter by statistics.throughput_raw.other
	*/
	StatisticsThroughputRawOther *int64

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* Status.

	   Filter by status
	*/
	Status *string

	/* Style.

	   Filter by style
	*/
	Style *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TieringMinCoolingDays.

	   Filter by tiering.min_cooling_days
	*/
	TieringMinCoolingDays *int64

	/* TieringObjectTags.

	   Filter by tiering.object_tags
	*/
	TieringObjectTags *string

	/* TieringPolicy.

	   Filter by tiering.policy
	*/
	TieringPolicy *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* ValidateOnly.

	   Filter by validate_only
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeCollectionGetParams) WithDefaults() *VolumeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeCollectionGetParams) SetDefaults() {
	var (
		isConstituentDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := VolumeCollectionGetParams{
		IsConstituent: &isConstituentDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume collection get params
func (o *VolumeCollectionGetParams) WithTimeout(timeout time.Duration) *VolumeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume collection get params
func (o *VolumeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume collection get params
func (o *VolumeCollectionGetParams) WithContext(ctx context.Context) *VolumeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume collection get params
func (o *VolumeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume collection get params
func (o *VolumeCollectionGetParams) WithHTTPClient(client *http.Client) *VolumeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume collection get params
func (o *VolumeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTags adds the tags to the volume collection get params
func (o *VolumeCollectionGetParams) WithTags(tags *string) *VolumeCollectionGetParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the volume collection get params
func (o *VolumeCollectionGetParams) SetTags(tags *string) {
	o.Tags = tags
}

// WithAccessTimeEnabled adds the accessTimeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithAccessTimeEnabled(accessTimeEnabled *bool) *VolumeCollectionGetParams {
	o.SetAccessTimeEnabled(accessTimeEnabled)
	return o
}

// SetAccessTimeEnabled adds the accessTimeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetAccessTimeEnabled(accessTimeEnabled *bool) {
	o.AccessTimeEnabled = accessTimeEnabled
}

// WithActivityTrackingNoticesCode adds the activityTrackingNoticesCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingNoticesCode(activityTrackingNoticesCode *string) *VolumeCollectionGetParams {
	o.SetActivityTrackingNoticesCode(activityTrackingNoticesCode)
	return o
}

// SetActivityTrackingNoticesCode adds the activityTrackingNoticesCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingNoticesCode(activityTrackingNoticesCode *string) {
	o.ActivityTrackingNoticesCode = activityTrackingNoticesCode
}

// WithActivityTrackingNoticesMessage adds the activityTrackingNoticesMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingNoticesMessage(activityTrackingNoticesMessage *string) *VolumeCollectionGetParams {
	o.SetActivityTrackingNoticesMessage(activityTrackingNoticesMessage)
	return o
}

// SetActivityTrackingNoticesMessage adds the activityTrackingNoticesMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingNoticesMessage(activityTrackingNoticesMessage *string) {
	o.ActivityTrackingNoticesMessage = activityTrackingNoticesMessage
}

// WithActivityTrackingState adds the activityTrackingState to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingState(activityTrackingState *string) *VolumeCollectionGetParams {
	o.SetActivityTrackingState(activityTrackingState)
	return o
}

// SetActivityTrackingState adds the activityTrackingState to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingState(activityTrackingState *string) {
	o.ActivityTrackingState = activityTrackingState
}

// WithActivityTrackingSupported adds the activityTrackingSupported to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingSupported(activityTrackingSupported *bool) *VolumeCollectionGetParams {
	o.SetActivityTrackingSupported(activityTrackingSupported)
	return o
}

// SetActivityTrackingSupported adds the activityTrackingSupported to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingSupported(activityTrackingSupported *bool) {
	o.ActivityTrackingSupported = activityTrackingSupported
}

// WithActivityTrackingUnsupportedReasonCode adds the activityTrackingUnsupportedReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingUnsupportedReasonCode(activityTrackingUnsupportedReasonCode *string) *VolumeCollectionGetParams {
	o.SetActivityTrackingUnsupportedReasonCode(activityTrackingUnsupportedReasonCode)
	return o
}

// SetActivityTrackingUnsupportedReasonCode adds the activityTrackingUnsupportedReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingUnsupportedReasonCode(activityTrackingUnsupportedReasonCode *string) {
	o.ActivityTrackingUnsupportedReasonCode = activityTrackingUnsupportedReasonCode
}

// WithActivityTrackingUnsupportedReasonMessage adds the activityTrackingUnsupportedReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithActivityTrackingUnsupportedReasonMessage(activityTrackingUnsupportedReasonMessage *string) *VolumeCollectionGetParams {
	o.SetActivityTrackingUnsupportedReasonMessage(activityTrackingUnsupportedReasonMessage)
	return o
}

// SetActivityTrackingUnsupportedReasonMessage adds the activityTrackingUnsupportedReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetActivityTrackingUnsupportedReasonMessage(activityTrackingUnsupportedReasonMessage *string) {
	o.ActivityTrackingUnsupportedReasonMessage = activityTrackingUnsupportedReasonMessage
}

// WithAggregatesName adds the aggregatesName to the volume collection get params
func (o *VolumeCollectionGetParams) WithAggregatesName(aggregatesName *string) *VolumeCollectionGetParams {
	o.SetAggregatesName(aggregatesName)
	return o
}

// SetAggregatesName adds the aggregatesName to the volume collection get params
func (o *VolumeCollectionGetParams) SetAggregatesName(aggregatesName *string) {
	o.AggregatesName = aggregatesName
}

// WithAggregatesUUID adds the aggregatesUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithAggregatesUUID(aggregatesUUID *string) *VolumeCollectionGetParams {
	o.SetAggregatesUUID(aggregatesUUID)
	return o
}

// SetAggregatesUUID adds the aggregatesUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetAggregatesUUID(aggregatesUUID *string) {
	o.AggregatesUUID = aggregatesUUID
}

// WithAggressiveReadaheadMode adds the aggressiveReadaheadMode to the volume collection get params
func (o *VolumeCollectionGetParams) WithAggressiveReadaheadMode(aggressiveReadaheadMode *string) *VolumeCollectionGetParams {
	o.SetAggressiveReadaheadMode(aggressiveReadaheadMode)
	return o
}

// SetAggressiveReadaheadMode adds the aggressiveReadaheadMode to the volume collection get params
func (o *VolumeCollectionGetParams) SetAggressiveReadaheadMode(aggressiveReadaheadMode *string) {
	o.AggressiveReadaheadMode = aggressiveReadaheadMode
}

// WithAnalyticsByAccessedTimeBytesUsedAgedDataMetric adds the analyticsByAccessedTimeBytesUsedAgedDataMetric to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric *float64) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric adds the analyticsByAccessedTimeBytesUsedAgedDataMetric to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric *float64) {
	o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric = analyticsByAccessedTimeBytesUsedAgedDataMetric
}

// WithAnalyticsByAccessedTimeBytesUsedLabels adds the analyticsByAccessedTimeBytesUsedLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedLabels adds the analyticsByAccessedTimeBytesUsedLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels *string) {
	o.AnalyticsByAccessedTimeBytesUsedLabels = analyticsByAccessedTimeBytesUsedLabels
}

// WithAnalyticsByAccessedTimeBytesUsedNewestLabel adds the analyticsByAccessedTimeBytesUsedNewestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedNewestLabel adds the analyticsByAccessedTimeBytesUsedNewestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel *string) {
	o.AnalyticsByAccessedTimeBytesUsedNewestLabel = analyticsByAccessedTimeBytesUsedNewestLabel
}

// WithAnalyticsByAccessedTimeBytesUsedOldestLabel adds the analyticsByAccessedTimeBytesUsedOldestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedOldestLabel adds the analyticsByAccessedTimeBytesUsedOldestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel *string) {
	o.AnalyticsByAccessedTimeBytesUsedOldestLabel = analyticsByAccessedTimeBytesUsedOldestLabel
}

// WithAnalyticsByAccessedTimeBytesUsedPercentages adds the analyticsByAccessedTimeBytesUsedPercentages to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages *float64) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedPercentages adds the analyticsByAccessedTimeBytesUsedPercentages to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages *float64) {
	o.AnalyticsByAccessedTimeBytesUsedPercentages = analyticsByAccessedTimeBytesUsedPercentages
}

// WithAnalyticsByAccessedTimeBytesUsedValues adds the analyticsByAccessedTimeBytesUsedValues to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedValues adds the analyticsByAccessedTimeBytesUsedValues to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues *int64) {
	o.AnalyticsByAccessedTimeBytesUsedValues = analyticsByAccessedTimeBytesUsedValues
}

// WithAnalyticsByModifiedTimeBytesUsedAgedDataMetric adds the analyticsByModifiedTimeBytesUsedAgedDataMetric to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric *float64) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric adds the analyticsByModifiedTimeBytesUsedAgedDataMetric to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric *float64) {
	o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric = analyticsByModifiedTimeBytesUsedAgedDataMetric
}

// WithAnalyticsByModifiedTimeBytesUsedLabels adds the analyticsByModifiedTimeBytesUsedLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedLabels adds the analyticsByModifiedTimeBytesUsedLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels *string) {
	o.AnalyticsByModifiedTimeBytesUsedLabels = analyticsByModifiedTimeBytesUsedLabels
}

// WithAnalyticsByModifiedTimeBytesUsedNewestLabel adds the analyticsByModifiedTimeBytesUsedNewestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedNewestLabel adds the analyticsByModifiedTimeBytesUsedNewestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel *string) {
	o.AnalyticsByModifiedTimeBytesUsedNewestLabel = analyticsByModifiedTimeBytesUsedNewestLabel
}

// WithAnalyticsByModifiedTimeBytesUsedOldestLabel adds the analyticsByModifiedTimeBytesUsedOldestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel *string) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedOldestLabel adds the analyticsByModifiedTimeBytesUsedOldestLabel to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel *string) {
	o.AnalyticsByModifiedTimeBytesUsedOldestLabel = analyticsByModifiedTimeBytesUsedOldestLabel
}

// WithAnalyticsByModifiedTimeBytesUsedPercentages adds the analyticsByModifiedTimeBytesUsedPercentages to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages *float64) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedPercentages adds the analyticsByModifiedTimeBytesUsedPercentages to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages *float64) {
	o.AnalyticsByModifiedTimeBytesUsedPercentages = analyticsByModifiedTimeBytesUsedPercentages
}

// WithAnalyticsByModifiedTimeBytesUsedValues adds the analyticsByModifiedTimeBytesUsedValues to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedValues adds the analyticsByModifiedTimeBytesUsedValues to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues *int64) {
	o.AnalyticsByModifiedTimeBytesUsedValues = analyticsByModifiedTimeBytesUsedValues
}

// WithAnalyticsBytesUsed adds the analyticsBytesUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsBytesUsed(analyticsBytesUsed *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsBytesUsed(analyticsBytesUsed)
	return o
}

// SetAnalyticsBytesUsed adds the analyticsBytesUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsBytesUsed(analyticsBytesUsed *int64) {
	o.AnalyticsBytesUsed = analyticsBytesUsed
}

// WithAnalyticsFileCount adds the analyticsFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsFileCount(analyticsFileCount *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsFileCount(analyticsFileCount)
	return o
}

// SetAnalyticsFileCount adds the analyticsFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsFileCount(analyticsFileCount *int64) {
	o.AnalyticsFileCount = analyticsFileCount
}

// WithAnalyticsFilesScanned adds the analyticsFilesScanned to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsFilesScanned(analyticsFilesScanned *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsFilesScanned(analyticsFilesScanned)
	return o
}

// SetAnalyticsFilesScanned adds the analyticsFilesScanned to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsFilesScanned(analyticsFilesScanned *int64) {
	o.AnalyticsFilesScanned = analyticsFilesScanned
}

// WithAnalyticsIncompleteData adds the analyticsIncompleteData to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsIncompleteData(analyticsIncompleteData *bool) *VolumeCollectionGetParams {
	o.SetAnalyticsIncompleteData(analyticsIncompleteData)
	return o
}

// SetAnalyticsIncompleteData adds the analyticsIncompleteData to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsIncompleteData(analyticsIncompleteData *bool) {
	o.AnalyticsIncompleteData = analyticsIncompleteData
}

// WithAnalyticsInitializationState adds the analyticsInitializationState to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsInitializationState(analyticsInitializationState *string) *VolumeCollectionGetParams {
	o.SetAnalyticsInitializationState(analyticsInitializationState)
	return o
}

// SetAnalyticsInitializationState adds the analyticsInitializationState to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsInitializationState(analyticsInitializationState *string) {
	o.AnalyticsInitializationState = analyticsInitializationState
}

// WithAnalyticsReportTime adds the analyticsReportTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsReportTime(analyticsReportTime *string) *VolumeCollectionGetParams {
	o.SetAnalyticsReportTime(analyticsReportTime)
	return o
}

// SetAnalyticsReportTime adds the analyticsReportTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsReportTime(analyticsReportTime *string) {
	o.AnalyticsReportTime = analyticsReportTime
}

// WithAnalyticsScanProgress adds the analyticsScanProgress to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsScanProgress(analyticsScanProgress *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsScanProgress(analyticsScanProgress)
	return o
}

// SetAnalyticsScanProgress adds the analyticsScanProgress to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsScanProgress(analyticsScanProgress *int64) {
	o.AnalyticsScanProgress = analyticsScanProgress
}

// WithAnalyticsScanThrottleReasonArguments adds the analyticsScanThrottleReasonArguments to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsScanThrottleReasonArguments(analyticsScanThrottleReasonArguments *string) *VolumeCollectionGetParams {
	o.SetAnalyticsScanThrottleReasonArguments(analyticsScanThrottleReasonArguments)
	return o
}

// SetAnalyticsScanThrottleReasonArguments adds the analyticsScanThrottleReasonArguments to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsScanThrottleReasonArguments(analyticsScanThrottleReasonArguments *string) {
	o.AnalyticsScanThrottleReasonArguments = analyticsScanThrottleReasonArguments
}

// WithAnalyticsScanThrottleReasonCode adds the analyticsScanThrottleReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsScanThrottleReasonCode(analyticsScanThrottleReasonCode *string) *VolumeCollectionGetParams {
	o.SetAnalyticsScanThrottleReasonCode(analyticsScanThrottleReasonCode)
	return o
}

// SetAnalyticsScanThrottleReasonCode adds the analyticsScanThrottleReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsScanThrottleReasonCode(analyticsScanThrottleReasonCode *string) {
	o.AnalyticsScanThrottleReasonCode = analyticsScanThrottleReasonCode
}

// WithAnalyticsScanThrottleReasonMessage adds the analyticsScanThrottleReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsScanThrottleReasonMessage(analyticsScanThrottleReasonMessage *string) *VolumeCollectionGetParams {
	o.SetAnalyticsScanThrottleReasonMessage(analyticsScanThrottleReasonMessage)
	return o
}

// SetAnalyticsScanThrottleReasonMessage adds the analyticsScanThrottleReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsScanThrottleReasonMessage(analyticsScanThrottleReasonMessage *string) {
	o.AnalyticsScanThrottleReasonMessage = analyticsScanThrottleReasonMessage
}

// WithAnalyticsState adds the analyticsState to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsState(analyticsState *string) *VolumeCollectionGetParams {
	o.SetAnalyticsState(analyticsState)
	return o
}

// SetAnalyticsState adds the analyticsState to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsState(analyticsState *string) {
	o.AnalyticsState = analyticsState
}

// WithAnalyticsSubdirCount adds the analyticsSubdirCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsSubdirCount(analyticsSubdirCount *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsSubdirCount(analyticsSubdirCount)
	return o
}

// SetAnalyticsSubdirCount adds the analyticsSubdirCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsSubdirCount(analyticsSubdirCount *int64) {
	o.AnalyticsSubdirCount = analyticsSubdirCount
}

// WithAnalyticsSupported adds the analyticsSupported to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsSupported(analyticsSupported *bool) *VolumeCollectionGetParams {
	o.SetAnalyticsSupported(analyticsSupported)
	return o
}

// SetAnalyticsSupported adds the analyticsSupported to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsSupported(analyticsSupported *bool) {
	o.AnalyticsSupported = analyticsSupported
}

// WithAnalyticsTotalFiles adds the analyticsTotalFiles to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsTotalFiles(analyticsTotalFiles *int64) *VolumeCollectionGetParams {
	o.SetAnalyticsTotalFiles(analyticsTotalFiles)
	return o
}

// SetAnalyticsTotalFiles adds the analyticsTotalFiles to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsTotalFiles(analyticsTotalFiles *int64) {
	o.AnalyticsTotalFiles = analyticsTotalFiles
}

// WithAnalyticsUnsupportedReasonCode adds the analyticsUnsupportedReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsUnsupportedReasonCode(analyticsUnsupportedReasonCode *string) *VolumeCollectionGetParams {
	o.SetAnalyticsUnsupportedReasonCode(analyticsUnsupportedReasonCode)
	return o
}

// SetAnalyticsUnsupportedReasonCode adds the analyticsUnsupportedReasonCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsUnsupportedReasonCode(analyticsUnsupportedReasonCode *string) {
	o.AnalyticsUnsupportedReasonCode = analyticsUnsupportedReasonCode
}

// WithAnalyticsUnsupportedReasonMessage adds the analyticsUnsupportedReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithAnalyticsUnsupportedReasonMessage(analyticsUnsupportedReasonMessage *string) *VolumeCollectionGetParams {
	o.SetAnalyticsUnsupportedReasonMessage(analyticsUnsupportedReasonMessage)
	return o
}

// SetAnalyticsUnsupportedReasonMessage adds the analyticsUnsupportedReasonMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetAnalyticsUnsupportedReasonMessage(analyticsUnsupportedReasonMessage *string) {
	o.AnalyticsUnsupportedReasonMessage = analyticsUnsupportedReasonMessage
}

// WithAntiRansomwareAttackDetectedBy adds the antiRansomwareAttackDetectedBy to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectedBy(antiRansomwareAttackDetectedBy *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectedBy(antiRansomwareAttackDetectedBy)
	return o
}

// SetAntiRansomwareAttackDetectedBy adds the antiRansomwareAttackDetectedBy to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectedBy(antiRansomwareAttackDetectedBy *string) {
	o.AntiRansomwareAttackDetectedBy = antiRansomwareAttackDetectedBy
}

// WithAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate(antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate(antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate(antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate *bool) {
	o.AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate = antiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate
}

// WithAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate(antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate(antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate(antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate *bool) {
	o.AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate = antiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate
}

// WithAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate(antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate(antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate adds the antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate(antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate *bool) {
	o.AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate = antiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate
}

// WithAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate adds the antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate(antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate(antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate adds the antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate(antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate *bool) {
	o.AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate = antiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate
}

// WithAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension adds the antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension(antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension(antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension adds the antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension(antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension *bool) {
	o.AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension = antiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension
}

// WithAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold adds the antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold(antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold(antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold)
	return o
}

// SetAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold adds the antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold(antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold *int64) {
	o.AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold = antiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold
}

// WithAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent)
	return o
}

// SetAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent *int64) {
	o.AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent = antiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent
}

// WithAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent)
	return o
}

// SetAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent *int64) {
	o.AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent = antiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent
}

// WithAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent)
	return o
}

// SetAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent(antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent *int64) {
	o.AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent = antiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent
}

// WithAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent(antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent(antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent)
	return o
}

// SetAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent adds the antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent(antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent *int64) {
	o.AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent = antiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent
}

// WithAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold adds the antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold)
	return o
}

// SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold adds the antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold *int64) {
	o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold = antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold
}

// WithAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours adds the antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours)
	return o
}

// SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours adds the antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours(antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours *int64) {
	o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours = antiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours
}

// WithAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions adds the antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions(antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions(antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions)
	return o
}

// SetAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions adds the antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions(antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions *bool) {
	o.AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions = antiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions
}

// WithAntiRansomwareAttackProbability adds the antiRansomwareAttackProbability to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackProbability(antiRansomwareAttackProbability *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackProbability(antiRansomwareAttackProbability)
	return o
}

// SetAntiRansomwareAttackProbability adds the antiRansomwareAttackProbability to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackProbability(antiRansomwareAttackProbability *string) {
	o.AntiRansomwareAttackProbability = antiRansomwareAttackProbability
}

// WithAntiRansomwareAttackReportsTime adds the antiRansomwareAttackReportsTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareAttackReportsTime(antiRansomwareAttackReportsTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareAttackReportsTime(antiRansomwareAttackReportsTime)
	return o
}

// SetAntiRansomwareAttackReportsTime adds the antiRansomwareAttackReportsTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareAttackReportsTime(antiRansomwareAttackReportsTime *string) {
	o.AntiRansomwareAttackReportsTime = antiRansomwareAttackReportsTime
}

// WithAntiRansomwareBlockDeviceDetectionStartTime adds the antiRansomwareBlockDeviceDetectionStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareBlockDeviceDetectionStartTime(antiRansomwareBlockDeviceDetectionStartTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareBlockDeviceDetectionStartTime(antiRansomwareBlockDeviceDetectionStartTime)
	return o
}

// SetAntiRansomwareBlockDeviceDetectionStartTime adds the antiRansomwareBlockDeviceDetectionStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareBlockDeviceDetectionStartTime(antiRansomwareBlockDeviceDetectionStartTime *string) {
	o.AntiRansomwareBlockDeviceDetectionStartTime = antiRansomwareBlockDeviceDetectionStartTime
}

// WithAntiRansomwareBlockDeviceDetectionState adds the antiRansomwareBlockDeviceDetectionState to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareBlockDeviceDetectionState(antiRansomwareBlockDeviceDetectionState *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareBlockDeviceDetectionState(antiRansomwareBlockDeviceDetectionState)
	return o
}

// SetAntiRansomwareBlockDeviceDetectionState adds the antiRansomwareBlockDeviceDetectionState to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareBlockDeviceDetectionState(antiRansomwareBlockDeviceDetectionState *string) {
	o.AntiRansomwareBlockDeviceDetectionState = antiRansomwareBlockDeviceDetectionState
}

// WithAntiRansomwareClearSuspectPhase adds the antiRansomwareClearSuspectPhase to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareClearSuspectPhase(antiRansomwareClearSuspectPhase *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareClearSuspectPhase(antiRansomwareClearSuspectPhase)
	return o
}

// SetAntiRansomwareClearSuspectPhase adds the antiRansomwareClearSuspectPhase to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareClearSuspectPhase(antiRansomwareClearSuspectPhase *string) {
	o.AntiRansomwareClearSuspectPhase = antiRansomwareClearSuspectPhase
}

// WithAntiRansomwareClearSuspectStartTime adds the antiRansomwareClearSuspectStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareClearSuspectStartTime(antiRansomwareClearSuspectStartTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareClearSuspectStartTime(antiRansomwareClearSuspectStartTime)
	return o
}

// SetAntiRansomwareClearSuspectStartTime adds the antiRansomwareClearSuspectStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareClearSuspectStartTime(antiRansomwareClearSuspectStartTime *string) {
	o.AntiRansomwareClearSuspectStartTime = antiRansomwareClearSuspectStartTime
}

// WithAntiRansomwareDryRunStartTime adds the antiRansomwareDryRunStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareDryRunStartTime(antiRansomwareDryRunStartTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareDryRunStartTime(antiRansomwareDryRunStartTime)
	return o
}

// SetAntiRansomwareDryRunStartTime adds the antiRansomwareDryRunStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareDryRunStartTime(antiRansomwareDryRunStartTime *string) {
	o.AntiRansomwareDryRunStartTime = antiRansomwareDryRunStartTime
}

// WithAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen adds the antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen(antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen(antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen)
	return o
}

// SetAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen adds the antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen(antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen *bool) {
	o.AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen = antiRansomwareEventLogIsEnabledOnNewFileExtensionSeen
}

// WithAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation adds the antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation(antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation(antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation)
	return o
}

// SetAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation adds the antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation(antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation *bool) {
	o.AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation = antiRansomwareEventLogIsEnabledOnSnapshotCopyCreation
}

// WithAntiRansomwareSpaceSnapshotCount adds the antiRansomwareSpaceSnapshotCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSpaceSnapshotCount(antiRansomwareSpaceSnapshotCount *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSpaceSnapshotCount(antiRansomwareSpaceSnapshotCount)
	return o
}

// SetAntiRansomwareSpaceSnapshotCount adds the antiRansomwareSpaceSnapshotCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSpaceSnapshotCount(antiRansomwareSpaceSnapshotCount *int64) {
	o.AntiRansomwareSpaceSnapshotCount = antiRansomwareSpaceSnapshotCount
}

// WithAntiRansomwareSpaceUsed adds the antiRansomwareSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSpaceUsed(antiRansomwareSpaceUsed *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSpaceUsed(antiRansomwareSpaceUsed)
	return o
}

// SetAntiRansomwareSpaceUsed adds the antiRansomwareSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSpaceUsed(antiRansomwareSpaceUsed *int64) {
	o.AntiRansomwareSpaceUsed = antiRansomwareSpaceUsed
}

// WithAntiRansomwareSpaceUsedByLogs adds the antiRansomwareSpaceUsedByLogs to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSpaceUsedByLogs(antiRansomwareSpaceUsedByLogs *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSpaceUsedByLogs(antiRansomwareSpaceUsedByLogs)
	return o
}

// SetAntiRansomwareSpaceUsedByLogs adds the antiRansomwareSpaceUsedByLogs to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSpaceUsedByLogs(antiRansomwareSpaceUsedByLogs *int64) {
	o.AntiRansomwareSpaceUsedByLogs = antiRansomwareSpaceUsedByLogs
}

// WithAntiRansomwareSpaceUsedBySnapshots adds the antiRansomwareSpaceUsedBySnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSpaceUsedBySnapshots(antiRansomwareSpaceUsedBySnapshots *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSpaceUsedBySnapshots(antiRansomwareSpaceUsedBySnapshots)
	return o
}

// SetAntiRansomwareSpaceUsedBySnapshots adds the antiRansomwareSpaceUsedBySnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSpaceUsedBySnapshots(antiRansomwareSpaceUsedBySnapshots *int64) {
	o.AntiRansomwareSpaceUsedBySnapshots = antiRansomwareSpaceUsedBySnapshots
}

// WithAntiRansomwareState adds the antiRansomwareState to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareState(antiRansomwareState *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareState(antiRansomwareState)
	return o
}

// SetAntiRansomwareState adds the antiRansomwareState to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareState(antiRansomwareState *string) {
	o.AntiRansomwareState = antiRansomwareState
}

// WithAntiRansomwareSurgeAsNormal adds the antiRansomwareSurgeAsNormal to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeAsNormal(antiRansomwareSurgeAsNormal *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeAsNormal(antiRansomwareSurgeAsNormal)
	return o
}

// SetAntiRansomwareSurgeAsNormal adds the antiRansomwareSurgeAsNormal to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeAsNormal(antiRansomwareSurgeAsNormal *bool) {
	o.AntiRansomwareSurgeAsNormal = antiRansomwareSurgeAsNormal
}

// WithAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute adds the antiRansomwareSurgeUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareSurgeUsageFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareSurgeUsageFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute adds the antiRansomwareSurgeUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareSurgeUsageFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute = antiRansomwareSurgeUsageFileCreatePeakRatePerMinute
}

// WithAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute adds the antiRansomwareSurgeUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareSurgeUsageFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareSurgeUsageFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute adds the antiRansomwareSurgeUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareSurgeUsageFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute = antiRansomwareSurgeUsageFileDeletePeakRatePerMinute
}

// WithAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute adds the antiRansomwareSurgeUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareSurgeUsageFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareSurgeUsageFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute adds the antiRansomwareSurgeUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareSurgeUsageFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute = antiRansomwareSurgeUsageFileRenamePeakRatePerMinute
}

// WithAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent adds the antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent adds the antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent = antiRansomwareSurgeUsageHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute
}

// WithAntiRansomwareSurgeUsageTime adds the antiRansomwareSurgeUsageTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSurgeUsageTime(antiRansomwareSurgeUsageTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSurgeUsageTime(antiRansomwareSurgeUsageTime)
	return o
}

// SetAntiRansomwareSurgeUsageTime adds the antiRansomwareSurgeUsageTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSurgeUsageTime(antiRansomwareSurgeUsageTime *string) {
	o.AntiRansomwareSurgeUsageTime = antiRansomwareSurgeUsageTime
}

// WithAntiRansomwareSuspectFilesCount adds the antiRansomwareSuspectFilesCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSuspectFilesCount(antiRansomwareSuspectFilesCount *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSuspectFilesCount(antiRansomwareSuspectFilesCount)
	return o
}

// SetAntiRansomwareSuspectFilesCount adds the antiRansomwareSuspectFilesCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSuspectFilesCount(antiRansomwareSuspectFilesCount *int64) {
	o.AntiRansomwareSuspectFilesCount = antiRansomwareSuspectFilesCount
}

// WithAntiRansomwareSuspectFilesEntropy adds the antiRansomwareSuspectFilesEntropy to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSuspectFilesEntropy(antiRansomwareSuspectFilesEntropy *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSuspectFilesEntropy(antiRansomwareSuspectFilesEntropy)
	return o
}

// SetAntiRansomwareSuspectFilesEntropy adds the antiRansomwareSuspectFilesEntropy to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSuspectFilesEntropy(antiRansomwareSuspectFilesEntropy *string) {
	o.AntiRansomwareSuspectFilesEntropy = antiRansomwareSuspectFilesEntropy
}

// WithAntiRansomwareSuspectFilesFormat adds the antiRansomwareSuspectFilesFormat to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareSuspectFilesFormat(antiRansomwareSuspectFilesFormat *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareSuspectFilesFormat(antiRansomwareSuspectFilesFormat)
	return o
}

// SetAntiRansomwareSuspectFilesFormat adds the antiRansomwareSuspectFilesFormat to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareSuspectFilesFormat(antiRansomwareSuspectFilesFormat *string) {
	o.AntiRansomwareSuspectFilesFormat = antiRansomwareSuspectFilesFormat
}

// WithAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute adds the antiRansomwareTypicalUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareTypicalUsageFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareTypicalUsageFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute adds the antiRansomwareTypicalUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareTypicalUsageFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute = antiRansomwareTypicalUsageFileCreatePeakRatePerMinute
}

// WithAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute adds the antiRansomwareTypicalUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareTypicalUsageFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareTypicalUsageFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute adds the antiRansomwareTypicalUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareTypicalUsageFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute = antiRansomwareTypicalUsageFileDeletePeakRatePerMinute
}

// WithAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute adds the antiRansomwareTypicalUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareTypicalUsageFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareTypicalUsageFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute adds the antiRansomwareTypicalUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareTypicalUsageFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute = antiRansomwareTypicalUsageFileRenamePeakRatePerMinute
}

// WithAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent adds the antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent adds the antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent = antiRansomwareTypicalUsageHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute
}

// WithAntiRansomwareUpdateBaselineFromSurge adds the antiRansomwareUpdateBaselineFromSurge to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareUpdateBaselineFromSurge(antiRansomwareUpdateBaselineFromSurge *bool) *VolumeCollectionGetParams {
	o.SetAntiRansomwareUpdateBaselineFromSurge(antiRansomwareUpdateBaselineFromSurge)
	return o
}

// SetAntiRansomwareUpdateBaselineFromSurge adds the antiRansomwareUpdateBaselineFromSurge to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareUpdateBaselineFromSurge(antiRansomwareUpdateBaselineFromSurge *bool) {
	o.AntiRansomwareUpdateBaselineFromSurge = antiRansomwareUpdateBaselineFromSurge
}

// WithAntiRansomwareWorkloadFileExtensionTypesCount adds the antiRansomwareWorkloadFileExtensionTypesCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadFileExtensionTypesCount(antiRansomwareWorkloadFileExtensionTypesCount *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadFileExtensionTypesCount(antiRansomwareWorkloadFileExtensionTypesCount)
	return o
}

// SetAntiRansomwareWorkloadFileExtensionTypesCount adds the antiRansomwareWorkloadFileExtensionTypesCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadFileExtensionTypesCount(antiRansomwareWorkloadFileExtensionTypesCount *int64) {
	o.AntiRansomwareWorkloadFileExtensionTypesCount = antiRansomwareWorkloadFileExtensionTypesCount
}

// WithAntiRansomwareWorkloadFileExtensionsObserved adds the antiRansomwareWorkloadFileExtensionsObserved to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadFileExtensionsObserved(antiRansomwareWorkloadFileExtensionsObserved *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadFileExtensionsObserved(antiRansomwareWorkloadFileExtensionsObserved)
	return o
}

// SetAntiRansomwareWorkloadFileExtensionsObserved adds the antiRansomwareWorkloadFileExtensionsObserved to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadFileExtensionsObserved(antiRansomwareWorkloadFileExtensionsObserved *string) {
	o.AntiRansomwareWorkloadFileExtensionsObserved = antiRansomwareWorkloadFileExtensionsObserved
}

// WithAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute = antiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute
}

// WithAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute = antiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute
}

// WithAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute = antiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute
}

// WithAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent = antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute
}

// WithAntiRansomwareWorkloadNewlyObservedFileExtensionsCount adds the antiRansomwareWorkloadNewlyObservedFileExtensionsCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadNewlyObservedFileExtensionsCount(antiRansomwareWorkloadNewlyObservedFileExtensionsCount *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadNewlyObservedFileExtensionsCount(antiRansomwareWorkloadNewlyObservedFileExtensionsCount)
	return o
}

// SetAntiRansomwareWorkloadNewlyObservedFileExtensionsCount adds the antiRansomwareWorkloadNewlyObservedFileExtensionsCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadNewlyObservedFileExtensionsCount(antiRansomwareWorkloadNewlyObservedFileExtensionsCount *int64) {
	o.AntiRansomwareWorkloadNewlyObservedFileExtensionsCount = antiRansomwareWorkloadNewlyObservedFileExtensionsCount
}

// WithAntiRansomwareWorkloadNewlyObservedFileExtensionsName adds the antiRansomwareWorkloadNewlyObservedFileExtensionsName to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadNewlyObservedFileExtensionsName(antiRansomwareWorkloadNewlyObservedFileExtensionsName *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadNewlyObservedFileExtensionsName(antiRansomwareWorkloadNewlyObservedFileExtensionsName)
	return o
}

// SetAntiRansomwareWorkloadNewlyObservedFileExtensionsName adds the antiRansomwareWorkloadNewlyObservedFileExtensionsName to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadNewlyObservedFileExtensionsName(antiRansomwareWorkloadNewlyObservedFileExtensionsName *string) {
	o.AntiRansomwareWorkloadNewlyObservedFileExtensionsName = antiRansomwareWorkloadNewlyObservedFileExtensionsName
}

// WithAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute = antiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute = antiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute = antiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent = antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute
}

// WithAntiRansomwareWorkloadSurgeStatisticsTime adds the antiRansomwareWorkloadSurgeStatisticsTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeStatisticsTime(antiRansomwareWorkloadSurgeStatisticsTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeStatisticsTime(antiRansomwareWorkloadSurgeStatisticsTime)
	return o
}

// SetAntiRansomwareWorkloadSurgeStatisticsTime adds the antiRansomwareWorkloadSurgeStatisticsTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeStatisticsTime(antiRansomwareWorkloadSurgeStatisticsTime *string) {
	o.AntiRansomwareWorkloadSurgeStatisticsTime = antiRansomwareWorkloadSurgeStatisticsTime
}

// WithAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute = antiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute = antiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute = antiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute
}

// WithAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent = antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute
}

// WithAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount adds the antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount adds the antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount *int64) {
	o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount = antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount
}

// WithAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName adds the antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName adds the antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName(antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName *string) {
	o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName = antiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName
}

// WithAntiRansomwareWorkloadSurgeUsageTime adds the antiRansomwareWorkloadSurgeUsageTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadSurgeUsageTime(antiRansomwareWorkloadSurgeUsageTime *string) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadSurgeUsageTime(antiRansomwareWorkloadSurgeUsageTime)
	return o
}

// SetAntiRansomwareWorkloadSurgeUsageTime adds the antiRansomwareWorkloadSurgeUsageTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadSurgeUsageTime(antiRansomwareWorkloadSurgeUsageTime *string) {
	o.AntiRansomwareWorkloadSurgeUsageTime = antiRansomwareWorkloadSurgeUsageTime
}

// WithAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute = antiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute
}

// WithAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute = antiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute
}

// WithAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute)
	return o
}

// SetAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute adds the antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute(antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute *int64) {
	o.AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute = antiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute
}

// WithAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent)
	return o
}

// SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent adds the antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent *int64) {
	o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent = antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent
}

// WithAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) WithAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64) *VolumeCollectionGetParams {
	o.SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute)
	return o
}

// SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute adds the antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute to the volume collection get params
func (o *VolumeCollectionGetParams) SetAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute(antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute *int64) {
	o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute = antiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute
}

// WithApplicationName adds the applicationName to the volume collection get params
func (o *VolumeCollectionGetParams) WithApplicationName(applicationName *string) *VolumeCollectionGetParams {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the volume collection get params
func (o *VolumeCollectionGetParams) SetApplicationName(applicationName *string) {
	o.ApplicationName = applicationName
}

// WithApplicationUUID adds the applicationUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithApplicationUUID(applicationUUID *string) *VolumeCollectionGetParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetApplicationUUID(applicationUUID *string) {
	o.ApplicationUUID = applicationUUID
}

// WithAsynchronousDirectoryDeleteEnabled adds the asynchronousDirectoryDeleteEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithAsynchronousDirectoryDeleteEnabled(asynchronousDirectoryDeleteEnabled *bool) *VolumeCollectionGetParams {
	o.SetAsynchronousDirectoryDeleteEnabled(asynchronousDirectoryDeleteEnabled)
	return o
}

// SetAsynchronousDirectoryDeleteEnabled adds the asynchronousDirectoryDeleteEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetAsynchronousDirectoryDeleteEnabled(asynchronousDirectoryDeleteEnabled *bool) {
	o.AsynchronousDirectoryDeleteEnabled = asynchronousDirectoryDeleteEnabled
}

// WithAsynchronousDirectoryDeleteTrashBin adds the asynchronousDirectoryDeleteTrashBin to the volume collection get params
func (o *VolumeCollectionGetParams) WithAsynchronousDirectoryDeleteTrashBin(asynchronousDirectoryDeleteTrashBin *string) *VolumeCollectionGetParams {
	o.SetAsynchronousDirectoryDeleteTrashBin(asynchronousDirectoryDeleteTrashBin)
	return o
}

// SetAsynchronousDirectoryDeleteTrashBin adds the asynchronousDirectoryDeleteTrashBin to the volume collection get params
func (o *VolumeCollectionGetParams) SetAsynchronousDirectoryDeleteTrashBin(asynchronousDirectoryDeleteTrashBin *string) {
	o.AsynchronousDirectoryDeleteTrashBin = asynchronousDirectoryDeleteTrashBin
}

// WithAutosizeGrowThreshold adds the autosizeGrowThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithAutosizeGrowThreshold(autosizeGrowThreshold *int64) *VolumeCollectionGetParams {
	o.SetAutosizeGrowThreshold(autosizeGrowThreshold)
	return o
}

// SetAutosizeGrowThreshold adds the autosizeGrowThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetAutosizeGrowThreshold(autosizeGrowThreshold *int64) {
	o.AutosizeGrowThreshold = autosizeGrowThreshold
}

// WithAutosizeMaximum adds the autosizeMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) WithAutosizeMaximum(autosizeMaximum *int64) *VolumeCollectionGetParams {
	o.SetAutosizeMaximum(autosizeMaximum)
	return o
}

// SetAutosizeMaximum adds the autosizeMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) SetAutosizeMaximum(autosizeMaximum *int64) {
	o.AutosizeMaximum = autosizeMaximum
}

// WithAutosizeMinimum adds the autosizeMinimum to the volume collection get params
func (o *VolumeCollectionGetParams) WithAutosizeMinimum(autosizeMinimum *int64) *VolumeCollectionGetParams {
	o.SetAutosizeMinimum(autosizeMinimum)
	return o
}

// SetAutosizeMinimum adds the autosizeMinimum to the volume collection get params
func (o *VolumeCollectionGetParams) SetAutosizeMinimum(autosizeMinimum *int64) {
	o.AutosizeMinimum = autosizeMinimum
}

// WithAutosizeMode adds the autosizeMode to the volume collection get params
func (o *VolumeCollectionGetParams) WithAutosizeMode(autosizeMode *string) *VolumeCollectionGetParams {
	o.SetAutosizeMode(autosizeMode)
	return o
}

// SetAutosizeMode adds the autosizeMode to the volume collection get params
func (o *VolumeCollectionGetParams) SetAutosizeMode(autosizeMode *string) {
	o.AutosizeMode = autosizeMode
}

// WithAutosizeShrinkThreshold adds the autosizeShrinkThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithAutosizeShrinkThreshold(autosizeShrinkThreshold *int64) *VolumeCollectionGetParams {
	o.SetAutosizeShrinkThreshold(autosizeShrinkThreshold)
	return o
}

// SetAutosizeShrinkThreshold adds the autosizeShrinkThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetAutosizeShrinkThreshold(autosizeShrinkThreshold *int64) {
	o.AutosizeShrinkThreshold = autosizeShrinkThreshold
}

// WithCloneHasFlexclone adds the cloneHasFlexclone to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneHasFlexclone(cloneHasFlexclone *bool) *VolumeCollectionGetParams {
	o.SetCloneHasFlexclone(cloneHasFlexclone)
	return o
}

// SetCloneHasFlexclone adds the cloneHasFlexclone to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneHasFlexclone(cloneHasFlexclone *bool) {
	o.CloneHasFlexclone = cloneHasFlexclone
}

// WithCloneInheritedPhysicalUsed adds the cloneInheritedPhysicalUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneInheritedPhysicalUsed(cloneInheritedPhysicalUsed *int64) *VolumeCollectionGetParams {
	o.SetCloneInheritedPhysicalUsed(cloneInheritedPhysicalUsed)
	return o
}

// SetCloneInheritedPhysicalUsed adds the cloneInheritedPhysicalUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneInheritedPhysicalUsed(cloneInheritedPhysicalUsed *int64) {
	o.CloneInheritedPhysicalUsed = cloneInheritedPhysicalUsed
}

// WithCloneInheritedSavings adds the cloneInheritedSavings to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneInheritedSavings(cloneInheritedSavings *int64) *VolumeCollectionGetParams {
	o.SetCloneInheritedSavings(cloneInheritedSavings)
	return o
}

// SetCloneInheritedSavings adds the cloneInheritedSavings to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneInheritedSavings(cloneInheritedSavings *int64) {
	o.CloneInheritedSavings = cloneInheritedSavings
}

// WithCloneIsFlexclone adds the cloneIsFlexclone to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneIsFlexclone(cloneIsFlexclone *bool) *VolumeCollectionGetParams {
	o.SetCloneIsFlexclone(cloneIsFlexclone)
	return o
}

// SetCloneIsFlexclone adds the cloneIsFlexclone to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneIsFlexclone(cloneIsFlexclone *bool) {
	o.CloneIsFlexclone = cloneIsFlexclone
}

// WithCloneLunName adds the cloneLunName to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneLunName(cloneLunName *string) *VolumeCollectionGetParams {
	o.SetCloneLunName(cloneLunName)
	return o
}

// SetCloneLunName adds the cloneLunName to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneLunName(cloneLunName *string) {
	o.CloneLunName = cloneLunName
}

// WithCloneParentSnapshotName adds the cloneParentSnapshotName to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentSnapshotName(cloneParentSnapshotName *string) *VolumeCollectionGetParams {
	o.SetCloneParentSnapshotName(cloneParentSnapshotName)
	return o
}

// SetCloneParentSnapshotName adds the cloneParentSnapshotName to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentSnapshotName(cloneParentSnapshotName *string) {
	o.CloneParentSnapshotName = cloneParentSnapshotName
}

// WithCloneParentSnapshotUUID adds the cloneParentSnapshotUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentSnapshotUUID(cloneParentSnapshotUUID *string) *VolumeCollectionGetParams {
	o.SetCloneParentSnapshotUUID(cloneParentSnapshotUUID)
	return o
}

// SetCloneParentSnapshotUUID adds the cloneParentSnapshotUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentSnapshotUUID(cloneParentSnapshotUUID *string) {
	o.CloneParentSnapshotUUID = cloneParentSnapshotUUID
}

// WithCloneParentSvmName adds the cloneParentSvmName to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentSvmName(cloneParentSvmName *string) *VolumeCollectionGetParams {
	o.SetCloneParentSvmName(cloneParentSvmName)
	return o
}

// SetCloneParentSvmName adds the cloneParentSvmName to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentSvmName(cloneParentSvmName *string) {
	o.CloneParentSvmName = cloneParentSvmName
}

// WithCloneParentSvmUUID adds the cloneParentSvmUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentSvmUUID(cloneParentSvmUUID *string) *VolumeCollectionGetParams {
	o.SetCloneParentSvmUUID(cloneParentSvmUUID)
	return o
}

// SetCloneParentSvmUUID adds the cloneParentSvmUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentSvmUUID(cloneParentSvmUUID *string) {
	o.CloneParentSvmUUID = cloneParentSvmUUID
}

// WithCloneParentVolumeName adds the cloneParentVolumeName to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentVolumeName(cloneParentVolumeName *string) *VolumeCollectionGetParams {
	o.SetCloneParentVolumeName(cloneParentVolumeName)
	return o
}

// SetCloneParentVolumeName adds the cloneParentVolumeName to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentVolumeName(cloneParentVolumeName *string) {
	o.CloneParentVolumeName = cloneParentVolumeName
}

// WithCloneParentVolumeUUID adds the cloneParentVolumeUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneParentVolumeUUID(cloneParentVolumeUUID *string) *VolumeCollectionGetParams {
	o.SetCloneParentVolumeUUID(cloneParentVolumeUUID)
	return o
}

// SetCloneParentVolumeUUID adds the cloneParentVolumeUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneParentVolumeUUID(cloneParentVolumeUUID *string) {
	o.CloneParentVolumeUUID = cloneParentVolumeUUID
}

// WithCloneQtreeName adds the cloneQtreeName to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneQtreeName(cloneQtreeName *string) *VolumeCollectionGetParams {
	o.SetCloneQtreeName(cloneQtreeName)
	return o
}

// SetCloneQtreeName adds the cloneQtreeName to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneQtreeName(cloneQtreeName *string) {
	o.CloneQtreeName = cloneQtreeName
}

// WithCloneSplitCompletePercent adds the cloneSplitCompletePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneSplitCompletePercent(cloneSplitCompletePercent *int64) *VolumeCollectionGetParams {
	o.SetCloneSplitCompletePercent(cloneSplitCompletePercent)
	return o
}

// SetCloneSplitCompletePercent adds the cloneSplitCompletePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneSplitCompletePercent(cloneSplitCompletePercent *int64) {
	o.CloneSplitCompletePercent = cloneSplitCompletePercent
}

// WithCloneSplitEstimate adds the cloneSplitEstimate to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneSplitEstimate(cloneSplitEstimate *int64) *VolumeCollectionGetParams {
	o.SetCloneSplitEstimate(cloneSplitEstimate)
	return o
}

// SetCloneSplitEstimate adds the cloneSplitEstimate to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneSplitEstimate(cloneSplitEstimate *int64) {
	o.CloneSplitEstimate = cloneSplitEstimate
}

// WithCloneSplitInitiated adds the cloneSplitInitiated to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloneSplitInitiated(cloneSplitInitiated *bool) *VolumeCollectionGetParams {
	o.SetCloneSplitInitiated(cloneSplitInitiated)
	return o
}

// SetCloneSplitInitiated adds the cloneSplitInitiated to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloneSplitInitiated(cloneSplitInitiated *bool) {
	o.CloneSplitInitiated = cloneSplitInitiated
}

// WithCloudRetrievalPolicy adds the cloudRetrievalPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloudRetrievalPolicy(cloudRetrievalPolicy *string) *VolumeCollectionGetParams {
	o.SetCloudRetrievalPolicy(cloudRetrievalPolicy)
	return o
}

// SetCloudRetrievalPolicy adds the cloudRetrievalPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloudRetrievalPolicy(cloudRetrievalPolicy *string) {
	o.CloudRetrievalPolicy = cloudRetrievalPolicy
}

// WithCloudWriteEnabled adds the cloudWriteEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithCloudWriteEnabled(cloudWriteEnabled *bool) *VolumeCollectionGetParams {
	o.SetCloudWriteEnabled(cloudWriteEnabled)
	return o
}

// SetCloudWriteEnabled adds the cloudWriteEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetCloudWriteEnabled(cloudWriteEnabled *bool) {
	o.CloudWriteEnabled = cloudWriteEnabled
}

// WithComment adds the comment to the volume collection get params
func (o *VolumeCollectionGetParams) WithComment(comment *string) *VolumeCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the volume collection get params
func (o *VolumeCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConsistencyGroupName adds the consistencyGroupName to the volume collection get params
func (o *VolumeCollectionGetParams) WithConsistencyGroupName(consistencyGroupName *string) *VolumeCollectionGetParams {
	o.SetConsistencyGroupName(consistencyGroupName)
	return o
}

// SetConsistencyGroupName adds the consistencyGroupName to the volume collection get params
func (o *VolumeCollectionGetParams) SetConsistencyGroupName(consistencyGroupName *string) {
	o.ConsistencyGroupName = consistencyGroupName
}

// WithConsistencyGroupUUID adds the consistencyGroupUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithConsistencyGroupUUID(consistencyGroupUUID *string) *VolumeCollectionGetParams {
	o.SetConsistencyGroupUUID(consistencyGroupUUID)
	return o
}

// SetConsistencyGroupUUID adds the consistencyGroupUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetConsistencyGroupUUID(consistencyGroupUUID *string) {
	o.ConsistencyGroupUUID = consistencyGroupUUID
}

// WithConstituentCount adds the constituentCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentCount(constituentCount *int64) *VolumeCollectionGetParams {
	o.SetConstituentCount(constituentCount)
	return o
}

// SetConstituentCount adds the constituentCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentCount(constituentCount *int64) {
	o.ConstituentCount = constituentCount
}

// WithConstituentsAggregatesName adds the constituentsAggregatesName to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsAggregatesName(constituentsAggregatesName *string) *VolumeCollectionGetParams {
	o.SetConstituentsAggregatesName(constituentsAggregatesName)
	return o
}

// SetConstituentsAggregatesName adds the constituentsAggregatesName to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsAggregatesName(constituentsAggregatesName *string) {
	o.ConstituentsAggregatesName = constituentsAggregatesName
}

// WithConstituentsAggregatesUUID adds the constituentsAggregatesUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsAggregatesUUID(constituentsAggregatesUUID *string) *VolumeCollectionGetParams {
	o.SetConstituentsAggregatesUUID(constituentsAggregatesUUID)
	return o
}

// SetConstituentsAggregatesUUID adds the constituentsAggregatesUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsAggregatesUUID(constituentsAggregatesUUID *string) {
	o.ConstituentsAggregatesUUID = constituentsAggregatesUUID
}

// WithConstituentsMovementCutoverWindow adds the constituentsMovementCutoverWindow to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsMovementCutoverWindow(constituentsMovementCutoverWindow *int64) *VolumeCollectionGetParams {
	o.SetConstituentsMovementCutoverWindow(constituentsMovementCutoverWindow)
	return o
}

// SetConstituentsMovementCutoverWindow adds the constituentsMovementCutoverWindow to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsMovementCutoverWindow(constituentsMovementCutoverWindow *int64) {
	o.ConstituentsMovementCutoverWindow = constituentsMovementCutoverWindow
}

// WithConstituentsMovementDestinationAggregateName adds the constituentsMovementDestinationAggregateName to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsMovementDestinationAggregateName(constituentsMovementDestinationAggregateName *string) *VolumeCollectionGetParams {
	o.SetConstituentsMovementDestinationAggregateName(constituentsMovementDestinationAggregateName)
	return o
}

// SetConstituentsMovementDestinationAggregateName adds the constituentsMovementDestinationAggregateName to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsMovementDestinationAggregateName(constituentsMovementDestinationAggregateName *string) {
	o.ConstituentsMovementDestinationAggregateName = constituentsMovementDestinationAggregateName
}

// WithConstituentsMovementDestinationAggregateUUID adds the constituentsMovementDestinationAggregateUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsMovementDestinationAggregateUUID(constituentsMovementDestinationAggregateUUID *string) *VolumeCollectionGetParams {
	o.SetConstituentsMovementDestinationAggregateUUID(constituentsMovementDestinationAggregateUUID)
	return o
}

// SetConstituentsMovementDestinationAggregateUUID adds the constituentsMovementDestinationAggregateUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsMovementDestinationAggregateUUID(constituentsMovementDestinationAggregateUUID *string) {
	o.ConstituentsMovementDestinationAggregateUUID = constituentsMovementDestinationAggregateUUID
}

// WithConstituentsMovementPercentComplete adds the constituentsMovementPercentComplete to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsMovementPercentComplete(constituentsMovementPercentComplete *int64) *VolumeCollectionGetParams {
	o.SetConstituentsMovementPercentComplete(constituentsMovementPercentComplete)
	return o
}

// SetConstituentsMovementPercentComplete adds the constituentsMovementPercentComplete to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsMovementPercentComplete(constituentsMovementPercentComplete *int64) {
	o.ConstituentsMovementPercentComplete = constituentsMovementPercentComplete
}

// WithConstituentsMovementState adds the constituentsMovementState to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsMovementState(constituentsMovementState *string) *VolumeCollectionGetParams {
	o.SetConstituentsMovementState(constituentsMovementState)
	return o
}

// SetConstituentsMovementState adds the constituentsMovementState to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsMovementState(constituentsMovementState *string) {
	o.ConstituentsMovementState = constituentsMovementState
}

// WithConstituentsName adds the constituentsName to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsName(constituentsName *string) *VolumeCollectionGetParams {
	o.SetConstituentsName(constituentsName)
	return o
}

// SetConstituentsName adds the constituentsName to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsName(constituentsName *string) {
	o.ConstituentsName = constituentsName
}

// WithConstituentsNodeName adds the constituentsNodeName to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsNodeName(constituentsNodeName *string) *VolumeCollectionGetParams {
	o.SetConstituentsNodeName(constituentsNodeName)
	return o
}

// SetConstituentsNodeName adds the constituentsNodeName to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsNodeName(constituentsNodeName *string) {
	o.ConstituentsNodeName = constituentsNodeName
}

// WithConstituentsNodeUUID adds the constituentsNodeUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsNodeUUID(constituentsNodeUUID *string) *VolumeCollectionGetParams {
	o.SetConstituentsNodeUUID(constituentsNodeUUID)
	return o
}

// SetConstituentsNodeUUID adds the constituentsNodeUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsNodeUUID(constituentsNodeUUID *string) {
	o.ConstituentsNodeUUID = constituentsNodeUUID
}

// WithConstituentsSpaceAfsTotal adds the constituentsSpaceAfsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceAfsTotal(constituentsSpaceAfsTotal *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceAfsTotal(constituentsSpaceAfsTotal)
	return o
}

// SetConstituentsSpaceAfsTotal adds the constituentsSpaceAfsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceAfsTotal(constituentsSpaceAfsTotal *int64) {
	o.ConstituentsSpaceAfsTotal = constituentsSpaceAfsTotal
}

// WithConstituentsSpaceAvailable adds the constituentsSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceAvailable(constituentsSpaceAvailable *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceAvailable(constituentsSpaceAvailable)
	return o
}

// SetConstituentsSpaceAvailable adds the constituentsSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceAvailable(constituentsSpaceAvailable *int64) {
	o.ConstituentsSpaceAvailable = constituentsSpaceAvailable
}

// WithConstituentsSpaceAvailablePercent adds the constituentsSpaceAvailablePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceAvailablePercent(constituentsSpaceAvailablePercent *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceAvailablePercent(constituentsSpaceAvailablePercent)
	return o
}

// SetConstituentsSpaceAvailablePercent adds the constituentsSpaceAvailablePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceAvailablePercent(constituentsSpaceAvailablePercent *int64) {
	o.ConstituentsSpaceAvailablePercent = constituentsSpaceAvailablePercent
}

// WithConstituentsSpaceBlockStorageInactiveUserData adds the constituentsSpaceBlockStorageInactiveUserData to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceBlockStorageInactiveUserData(constituentsSpaceBlockStorageInactiveUserData *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceBlockStorageInactiveUserData(constituentsSpaceBlockStorageInactiveUserData)
	return o
}

// SetConstituentsSpaceBlockStorageInactiveUserData adds the constituentsSpaceBlockStorageInactiveUserData to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceBlockStorageInactiveUserData(constituentsSpaceBlockStorageInactiveUserData *int64) {
	o.ConstituentsSpaceBlockStorageInactiveUserData = constituentsSpaceBlockStorageInactiveUserData
}

// WithConstituentsSpaceCapacityTierFootprint adds the constituentsSpaceCapacityTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceCapacityTierFootprint(constituentsSpaceCapacityTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceCapacityTierFootprint(constituentsSpaceCapacityTierFootprint)
	return o
}

// SetConstituentsSpaceCapacityTierFootprint adds the constituentsSpaceCapacityTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceCapacityTierFootprint(constituentsSpaceCapacityTierFootprint *int64) {
	o.ConstituentsSpaceCapacityTierFootprint = constituentsSpaceCapacityTierFootprint
}

// WithConstituentsSpaceFootprint adds the constituentsSpaceFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceFootprint(constituentsSpaceFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceFootprint(constituentsSpaceFootprint)
	return o
}

// SetConstituentsSpaceFootprint adds the constituentsSpaceFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceFootprint(constituentsSpaceFootprint *int64) {
	o.ConstituentsSpaceFootprint = constituentsSpaceFootprint
}

// WithConstituentsSpaceLargeSizeEnabled adds the constituentsSpaceLargeSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLargeSizeEnabled(constituentsSpaceLargeSizeEnabled *bool) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLargeSizeEnabled(constituentsSpaceLargeSizeEnabled)
	return o
}

// SetConstituentsSpaceLargeSizeEnabled adds the constituentsSpaceLargeSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLargeSizeEnabled(constituentsSpaceLargeSizeEnabled *bool) {
	o.ConstituentsSpaceLargeSizeEnabled = constituentsSpaceLargeSizeEnabled
}

// WithConstituentsSpaceLocalTierFootprint adds the constituentsSpaceLocalTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLocalTierFootprint(constituentsSpaceLocalTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLocalTierFootprint(constituentsSpaceLocalTierFootprint)
	return o
}

// SetConstituentsSpaceLocalTierFootprint adds the constituentsSpaceLocalTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLocalTierFootprint(constituentsSpaceLocalTierFootprint *int64) {
	o.ConstituentsSpaceLocalTierFootprint = constituentsSpaceLocalTierFootprint
}

// WithConstituentsSpaceLogicalSpaceAvailable adds the constituentsSpaceLogicalSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLogicalSpaceAvailable(constituentsSpaceLogicalSpaceAvailable *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLogicalSpaceAvailable(constituentsSpaceLogicalSpaceAvailable)
	return o
}

// SetConstituentsSpaceLogicalSpaceAvailable adds the constituentsSpaceLogicalSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLogicalSpaceAvailable(constituentsSpaceLogicalSpaceAvailable *int64) {
	o.ConstituentsSpaceLogicalSpaceAvailable = constituentsSpaceLogicalSpaceAvailable
}

// WithConstituentsSpaceLogicalSpaceEnforcement adds the constituentsSpaceLogicalSpaceEnforcement to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLogicalSpaceEnforcement(constituentsSpaceLogicalSpaceEnforcement *bool) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLogicalSpaceEnforcement(constituentsSpaceLogicalSpaceEnforcement)
	return o
}

// SetConstituentsSpaceLogicalSpaceEnforcement adds the constituentsSpaceLogicalSpaceEnforcement to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLogicalSpaceEnforcement(constituentsSpaceLogicalSpaceEnforcement *bool) {
	o.ConstituentsSpaceLogicalSpaceEnforcement = constituentsSpaceLogicalSpaceEnforcement
}

// WithConstituentsSpaceLogicalSpaceReporting adds the constituentsSpaceLogicalSpaceReporting to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLogicalSpaceReporting(constituentsSpaceLogicalSpaceReporting *bool) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLogicalSpaceReporting(constituentsSpaceLogicalSpaceReporting)
	return o
}

// SetConstituentsSpaceLogicalSpaceReporting adds the constituentsSpaceLogicalSpaceReporting to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLogicalSpaceReporting(constituentsSpaceLogicalSpaceReporting *bool) {
	o.ConstituentsSpaceLogicalSpaceReporting = constituentsSpaceLogicalSpaceReporting
}

// WithConstituentsSpaceLogicalSpaceUsedByAfs adds the constituentsSpaceLogicalSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceLogicalSpaceUsedByAfs(constituentsSpaceLogicalSpaceUsedByAfs *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceLogicalSpaceUsedByAfs(constituentsSpaceLogicalSpaceUsedByAfs)
	return o
}

// SetConstituentsSpaceLogicalSpaceUsedByAfs adds the constituentsSpaceLogicalSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceLogicalSpaceUsedByAfs(constituentsSpaceLogicalSpaceUsedByAfs *int64) {
	o.ConstituentsSpaceLogicalSpaceUsedByAfs = constituentsSpaceLogicalSpaceUsedByAfs
}

// WithConstituentsSpaceMaxSize adds the constituentsSpaceMaxSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceMaxSize(constituentsSpaceMaxSize *string) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceMaxSize(constituentsSpaceMaxSize)
	return o
}

// SetConstituentsSpaceMaxSize adds the constituentsSpaceMaxSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceMaxSize(constituentsSpaceMaxSize *string) {
	o.ConstituentsSpaceMaxSize = constituentsSpaceMaxSize
}

// WithConstituentsSpaceMetadata adds the constituentsSpaceMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceMetadata(constituentsSpaceMetadata *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceMetadata(constituentsSpaceMetadata)
	return o
}

// SetConstituentsSpaceMetadata adds the constituentsSpaceMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceMetadata(constituentsSpaceMetadata *int64) {
	o.ConstituentsSpaceMetadata = constituentsSpaceMetadata
}

// WithConstituentsSpaceOverProvisioned adds the constituentsSpaceOverProvisioned to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceOverProvisioned(constituentsSpaceOverProvisioned *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceOverProvisioned(constituentsSpaceOverProvisioned)
	return o
}

// SetConstituentsSpaceOverProvisioned adds the constituentsSpaceOverProvisioned to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceOverProvisioned(constituentsSpaceOverProvisioned *int64) {
	o.ConstituentsSpaceOverProvisioned = constituentsSpaceOverProvisioned
}

// WithConstituentsSpacePerformanceTierFootprint adds the constituentsSpacePerformanceTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpacePerformanceTierFootprint(constituentsSpacePerformanceTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpacePerformanceTierFootprint(constituentsSpacePerformanceTierFootprint)
	return o
}

// SetConstituentsSpacePerformanceTierFootprint adds the constituentsSpacePerformanceTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpacePerformanceTierFootprint(constituentsSpacePerformanceTierFootprint *int64) {
	o.ConstituentsSpacePerformanceTierFootprint = constituentsSpacePerformanceTierFootprint
}

// WithConstituentsSpaceSize adds the constituentsSpaceSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceSize(constituentsSpaceSize *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceSize(constituentsSpaceSize)
	return o
}

// SetConstituentsSpaceSize adds the constituentsSpaceSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceSize(constituentsSpaceSize *int64) {
	o.ConstituentsSpaceSize = constituentsSpaceSize
}

// WithConstituentsSpaceSnapshotReservePercent adds the constituentsSpaceSnapshotReservePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceSnapshotReservePercent(constituentsSpaceSnapshotReservePercent *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceSnapshotReservePercent(constituentsSpaceSnapshotReservePercent)
	return o
}

// SetConstituentsSpaceSnapshotReservePercent adds the constituentsSpaceSnapshotReservePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceSnapshotReservePercent(constituentsSpaceSnapshotReservePercent *int64) {
	o.ConstituentsSpaceSnapshotReservePercent = constituentsSpaceSnapshotReservePercent
}

// WithConstituentsSpaceSnapshotUsed adds the constituentsSpaceSnapshotUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceSnapshotUsed(constituentsSpaceSnapshotUsed *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceSnapshotUsed(constituentsSpaceSnapshotUsed)
	return o
}

// SetConstituentsSpaceSnapshotUsed adds the constituentsSpaceSnapshotUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceSnapshotUsed(constituentsSpaceSnapshotUsed *int64) {
	o.ConstituentsSpaceSnapshotUsed = constituentsSpaceSnapshotUsed
}

// WithConstituentsSpaceTotalFootprint adds the constituentsSpaceTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceTotalFootprint(constituentsSpaceTotalFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceTotalFootprint(constituentsSpaceTotalFootprint)
	return o
}

// SetConstituentsSpaceTotalFootprint adds the constituentsSpaceTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceTotalFootprint(constituentsSpaceTotalFootprint *int64) {
	o.ConstituentsSpaceTotalFootprint = constituentsSpaceTotalFootprint
}

// WithConstituentsSpaceTotalMetadata adds the constituentsSpaceTotalMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceTotalMetadata(constituentsSpaceTotalMetadata *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceTotalMetadata(constituentsSpaceTotalMetadata)
	return o
}

// SetConstituentsSpaceTotalMetadata adds the constituentsSpaceTotalMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceTotalMetadata(constituentsSpaceTotalMetadata *int64) {
	o.ConstituentsSpaceTotalMetadata = constituentsSpaceTotalMetadata
}

// WithConstituentsSpaceTotalMetadataFootprint adds the constituentsSpaceTotalMetadataFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceTotalMetadataFootprint(constituentsSpaceTotalMetadataFootprint *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceTotalMetadataFootprint(constituentsSpaceTotalMetadataFootprint)
	return o
}

// SetConstituentsSpaceTotalMetadataFootprint adds the constituentsSpaceTotalMetadataFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceTotalMetadataFootprint(constituentsSpaceTotalMetadataFootprint *int64) {
	o.ConstituentsSpaceTotalMetadataFootprint = constituentsSpaceTotalMetadataFootprint
}

// WithConstituentsSpaceUsed adds the constituentsSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceUsed(constituentsSpaceUsed *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceUsed(constituentsSpaceUsed)
	return o
}

// SetConstituentsSpaceUsed adds the constituentsSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceUsed(constituentsSpaceUsed *int64) {
	o.ConstituentsSpaceUsed = constituentsSpaceUsed
}

// WithConstituentsSpaceUsedByAfs adds the constituentsSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceUsedByAfs(constituentsSpaceUsedByAfs *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceUsedByAfs(constituentsSpaceUsedByAfs)
	return o
}

// SetConstituentsSpaceUsedByAfs adds the constituentsSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceUsedByAfs(constituentsSpaceUsedByAfs *int64) {
	o.ConstituentsSpaceUsedByAfs = constituentsSpaceUsedByAfs
}

// WithConstituentsSpaceUsedPercent adds the constituentsSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithConstituentsSpaceUsedPercent(constituentsSpaceUsedPercent *int64) *VolumeCollectionGetParams {
	o.SetConstituentsSpaceUsedPercent(constituentsSpaceUsedPercent)
	return o
}

// SetConstituentsSpaceUsedPercent adds the constituentsSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetConstituentsSpaceUsedPercent(constituentsSpaceUsedPercent *int64) {
	o.ConstituentsSpaceUsedPercent = constituentsSpaceUsedPercent
}

// WithConvertUnicode adds the convertUnicode to the volume collection get params
func (o *VolumeCollectionGetParams) WithConvertUnicode(convertUnicode *bool) *VolumeCollectionGetParams {
	o.SetConvertUnicode(convertUnicode)
	return o
}

// SetConvertUnicode adds the convertUnicode to the volume collection get params
func (o *VolumeCollectionGetParams) SetConvertUnicode(convertUnicode *bool) {
	o.ConvertUnicode = convertUnicode
}

// WithCreateTime adds the createTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithCreateTime(createTime *string) *VolumeCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithEfficiencyApplicationIoSize adds the efficiencyApplicationIoSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyApplicationIoSize(efficiencyApplicationIoSize *string) *VolumeCollectionGetParams {
	o.SetEfficiencyApplicationIoSize(efficiencyApplicationIoSize)
	return o
}

// SetEfficiencyApplicationIoSize adds the efficiencyApplicationIoSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyApplicationIoSize(efficiencyApplicationIoSize *string) {
	o.EfficiencyApplicationIoSize = efficiencyApplicationIoSize
}

// WithEfficiencyAutoState adds the efficiencyAutoState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyAutoState(efficiencyAutoState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyAutoState(efficiencyAutoState)
	return o
}

// SetEfficiencyAutoState adds the efficiencyAutoState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyAutoState(efficiencyAutoState *string) {
	o.EfficiencyAutoState = efficiencyAutoState
}

// WithEfficiencyCompaction adds the efficiencyCompaction to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyCompaction(efficiencyCompaction *string) *VolumeCollectionGetParams {
	o.SetEfficiencyCompaction(efficiencyCompaction)
	return o
}

// SetEfficiencyCompaction adds the efficiencyCompaction to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyCompaction(efficiencyCompaction *string) {
	o.EfficiencyCompaction = efficiencyCompaction
}

// WithEfficiencyCompression adds the efficiencyCompression to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyCompression(efficiencyCompression *string) *VolumeCollectionGetParams {
	o.SetEfficiencyCompression(efficiencyCompression)
	return o
}

// SetEfficiencyCompression adds the efficiencyCompression to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyCompression(efficiencyCompression *string) {
	o.EfficiencyCompression = efficiencyCompression
}

// WithEfficiencyCompressionType adds the efficiencyCompressionType to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyCompressionType(efficiencyCompressionType *string) *VolumeCollectionGetParams {
	o.SetEfficiencyCompressionType(efficiencyCompressionType)
	return o
}

// SetEfficiencyCompressionType adds the efficiencyCompressionType to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyCompressionType(efficiencyCompressionType *string) {
	o.EfficiencyCompressionType = efficiencyCompressionType
}

// WithEfficiencyCrossVolumeDedupe adds the efficiencyCrossVolumeDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyCrossVolumeDedupe(efficiencyCrossVolumeDedupe *string) *VolumeCollectionGetParams {
	o.SetEfficiencyCrossVolumeDedupe(efficiencyCrossVolumeDedupe)
	return o
}

// SetEfficiencyCrossVolumeDedupe adds the efficiencyCrossVolumeDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyCrossVolumeDedupe(efficiencyCrossVolumeDedupe *string) {
	o.EfficiencyCrossVolumeDedupe = efficiencyCrossVolumeDedupe
}

// WithEfficiencyDedupe adds the efficiencyDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyDedupe(efficiencyDedupe *string) *VolumeCollectionGetParams {
	o.SetEfficiencyDedupe(efficiencyDedupe)
	return o
}

// SetEfficiencyDedupe adds the efficiencyDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyDedupe(efficiencyDedupe *string) {
	o.EfficiencyDedupe = efficiencyDedupe
}

// WithEfficiencyHasSavings adds the efficiencyHasSavings to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyHasSavings(efficiencyHasSavings *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyHasSavings(efficiencyHasSavings)
	return o
}

// SetEfficiencyHasSavings adds the efficiencyHasSavings to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyHasSavings(efficiencyHasSavings *bool) {
	o.EfficiencyHasSavings = efficiencyHasSavings
}

// WithEfficiencyIdcsScannerEnabled adds the efficiencyIdcsScannerEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyIdcsScannerEnabled(efficiencyIdcsScannerEnabled *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyIdcsScannerEnabled(efficiencyIdcsScannerEnabled)
	return o
}

// SetEfficiencyIdcsScannerEnabled adds the efficiencyIdcsScannerEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyIdcsScannerEnabled(efficiencyIdcsScannerEnabled *bool) {
	o.EfficiencyIdcsScannerEnabled = efficiencyIdcsScannerEnabled
}

// WithEfficiencyIdcsScannerMode adds the efficiencyIdcsScannerMode to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyIdcsScannerMode(efficiencyIdcsScannerMode *string) *VolumeCollectionGetParams {
	o.SetEfficiencyIdcsScannerMode(efficiencyIdcsScannerMode)
	return o
}

// SetEfficiencyIdcsScannerMode adds the efficiencyIdcsScannerMode to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyIdcsScannerMode(efficiencyIdcsScannerMode *string) {
	o.EfficiencyIdcsScannerMode = efficiencyIdcsScannerMode
}

// WithEfficiencyIdcsScannerOperationState adds the efficiencyIdcsScannerOperationState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyIdcsScannerOperationState(efficiencyIdcsScannerOperationState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyIdcsScannerOperationState(efficiencyIdcsScannerOperationState)
	return o
}

// SetEfficiencyIdcsScannerOperationState adds the efficiencyIdcsScannerOperationState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyIdcsScannerOperationState(efficiencyIdcsScannerOperationState *string) {
	o.EfficiencyIdcsScannerOperationState = efficiencyIdcsScannerOperationState
}

// WithEfficiencyIdcsScannerStatus adds the efficiencyIdcsScannerStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyIdcsScannerStatus(efficiencyIdcsScannerStatus *string) *VolumeCollectionGetParams {
	o.SetEfficiencyIdcsScannerStatus(efficiencyIdcsScannerStatus)
	return o
}

// SetEfficiencyIdcsScannerStatus adds the efficiencyIdcsScannerStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyIdcsScannerStatus(efficiencyIdcsScannerStatus *string) {
	o.EfficiencyIdcsScannerStatus = efficiencyIdcsScannerStatus
}

// WithEfficiencyIdcsScannerThresholdInactiveTime adds the efficiencyIdcsScannerThresholdInactiveTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyIdcsScannerThresholdInactiveTime(efficiencyIdcsScannerThresholdInactiveTime *string) *VolumeCollectionGetParams {
	o.SetEfficiencyIdcsScannerThresholdInactiveTime(efficiencyIdcsScannerThresholdInactiveTime)
	return o
}

// SetEfficiencyIdcsScannerThresholdInactiveTime adds the efficiencyIdcsScannerThresholdInactiveTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyIdcsScannerThresholdInactiveTime(efficiencyIdcsScannerThresholdInactiveTime *string) {
	o.EfficiencyIdcsScannerThresholdInactiveTime = efficiencyIdcsScannerThresholdInactiveTime
}

// WithEfficiencyLastOpBegin adds the efficiencyLastOpBegin to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLastOpBegin(efficiencyLastOpBegin *string) *VolumeCollectionGetParams {
	o.SetEfficiencyLastOpBegin(efficiencyLastOpBegin)
	return o
}

// SetEfficiencyLastOpBegin adds the efficiencyLastOpBegin to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLastOpBegin(efficiencyLastOpBegin *string) {
	o.EfficiencyLastOpBegin = efficiencyLastOpBegin
}

// WithEfficiencyLastOpEnd adds the efficiencyLastOpEnd to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLastOpEnd(efficiencyLastOpEnd *string) *VolumeCollectionGetParams {
	o.SetEfficiencyLastOpEnd(efficiencyLastOpEnd)
	return o
}

// SetEfficiencyLastOpEnd adds the efficiencyLastOpEnd to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLastOpEnd(efficiencyLastOpEnd *string) {
	o.EfficiencyLastOpEnd = efficiencyLastOpEnd
}

// WithEfficiencyLastOpErr adds the efficiencyLastOpErr to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLastOpErr(efficiencyLastOpErr *string) *VolumeCollectionGetParams {
	o.SetEfficiencyLastOpErr(efficiencyLastOpErr)
	return o
}

// SetEfficiencyLastOpErr adds the efficiencyLastOpErr to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLastOpErr(efficiencyLastOpErr *string) {
	o.EfficiencyLastOpErr = efficiencyLastOpErr
}

// WithEfficiencyLastOpSize adds the efficiencyLastOpSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLastOpSize(efficiencyLastOpSize *int64) *VolumeCollectionGetParams {
	o.SetEfficiencyLastOpSize(efficiencyLastOpSize)
	return o
}

// SetEfficiencyLastOpSize adds the efficiencyLastOpSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLastOpSize(efficiencyLastOpSize *int64) {
	o.EfficiencyLastOpSize = efficiencyLastOpSize
}

// WithEfficiencyLastOpState adds the efficiencyLastOpState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLastOpState(efficiencyLastOpState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyLastOpState(efficiencyLastOpState)
	return o
}

// SetEfficiencyLastOpState adds the efficiencyLastOpState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLastOpState(efficiencyLastOpState *string) {
	o.EfficiencyLastOpState = efficiencyLastOpState
}

// WithEfficiencyLoggingEnabled adds the efficiencyLoggingEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyLoggingEnabled(efficiencyLoggingEnabled *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyLoggingEnabled(efficiencyLoggingEnabled)
	return o
}

// SetEfficiencyLoggingEnabled adds the efficiencyLoggingEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyLoggingEnabled(efficiencyLoggingEnabled *bool) {
	o.EfficiencyLoggingEnabled = efficiencyLoggingEnabled
}

// WithEfficiencyOpState adds the efficiencyOpState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyOpState(efficiencyOpState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyOpState(efficiencyOpState)
	return o
}

// SetEfficiencyOpState adds the efficiencyOpState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyOpState(efficiencyOpState *string) {
	o.EfficiencyOpState = efficiencyOpState
}

// WithEfficiencyPolicyName adds the efficiencyPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyPolicyName(efficiencyPolicyName *string) *VolumeCollectionGetParams {
	o.SetEfficiencyPolicyName(efficiencyPolicyName)
	return o
}

// SetEfficiencyPolicyName adds the efficiencyPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyPolicyName(efficiencyPolicyName *string) {
	o.EfficiencyPolicyName = efficiencyPolicyName
}

// WithEfficiencyProgress adds the efficiencyProgress to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyProgress(efficiencyProgress *string) *VolumeCollectionGetParams {
	o.SetEfficiencyProgress(efficiencyProgress)
	return o
}

// SetEfficiencyProgress adds the efficiencyProgress to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyProgress(efficiencyProgress *string) {
	o.EfficiencyProgress = efficiencyProgress
}

// WithEfficiencyRatio adds the efficiencyRatio to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyRatio(efficiencyRatio *float64) *VolumeCollectionGetParams {
	o.SetEfficiencyRatio(efficiencyRatio)
	return o
}

// SetEfficiencyRatio adds the efficiencyRatio to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyRatio(efficiencyRatio *float64) {
	o.EfficiencyRatio = efficiencyRatio
}

// WithEfficiencyScannerCompression adds the efficiencyScannerCompression to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyScannerCompression(efficiencyScannerCompression *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyScannerCompression(efficiencyScannerCompression)
	return o
}

// SetEfficiencyScannerCompression adds the efficiencyScannerCompression to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyScannerCompression(efficiencyScannerCompression *bool) {
	o.EfficiencyScannerCompression = efficiencyScannerCompression
}

// WithEfficiencyScannerDedupe adds the efficiencyScannerDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyScannerDedupe(efficiencyScannerDedupe *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyScannerDedupe(efficiencyScannerDedupe)
	return o
}

// SetEfficiencyScannerDedupe adds the efficiencyScannerDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyScannerDedupe(efficiencyScannerDedupe *bool) {
	o.EfficiencyScannerDedupe = efficiencyScannerDedupe
}

// WithEfficiencyScannerScanOldData adds the efficiencyScannerScanOldData to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyScannerScanOldData(efficiencyScannerScanOldData *bool) *VolumeCollectionGetParams {
	o.SetEfficiencyScannerScanOldData(efficiencyScannerScanOldData)
	return o
}

// SetEfficiencyScannerScanOldData adds the efficiencyScannerScanOldData to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyScannerScanOldData(efficiencyScannerScanOldData *bool) {
	o.EfficiencyScannerScanOldData = efficiencyScannerScanOldData
}

// WithEfficiencyScannerState adds the efficiencyScannerState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyScannerState(efficiencyScannerState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyScannerState(efficiencyScannerState)
	return o
}

// SetEfficiencyScannerState adds the efficiencyScannerState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyScannerState(efficiencyScannerState *string) {
	o.EfficiencyScannerState = efficiencyScannerState
}

// WithEfficiencySchedule adds the efficiencySchedule to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySchedule(efficiencySchedule *string) *VolumeCollectionGetParams {
	o.SetEfficiencySchedule(efficiencySchedule)
	return o
}

// SetEfficiencySchedule adds the efficiencySchedule to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySchedule(efficiencySchedule *string) {
	o.EfficiencySchedule = efficiencySchedule
}

// WithEfficiencySpaceSavingsCompression adds the efficiencySpaceSavingsCompression to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsCompression(efficiencySpaceSavingsCompression *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsCompression(efficiencySpaceSavingsCompression)
	return o
}

// SetEfficiencySpaceSavingsCompression adds the efficiencySpaceSavingsCompression to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsCompression(efficiencySpaceSavingsCompression *int64) {
	o.EfficiencySpaceSavingsCompression = efficiencySpaceSavingsCompression
}

// WithEfficiencySpaceSavingsCompressionPercent adds the efficiencySpaceSavingsCompressionPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsCompressionPercent(efficiencySpaceSavingsCompressionPercent *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsCompressionPercent(efficiencySpaceSavingsCompressionPercent)
	return o
}

// SetEfficiencySpaceSavingsCompressionPercent adds the efficiencySpaceSavingsCompressionPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsCompressionPercent(efficiencySpaceSavingsCompressionPercent *int64) {
	o.EfficiencySpaceSavingsCompressionPercent = efficiencySpaceSavingsCompressionPercent
}

// WithEfficiencySpaceSavingsDedupe adds the efficiencySpaceSavingsDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsDedupe(efficiencySpaceSavingsDedupe *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsDedupe(efficiencySpaceSavingsDedupe)
	return o
}

// SetEfficiencySpaceSavingsDedupe adds the efficiencySpaceSavingsDedupe to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsDedupe(efficiencySpaceSavingsDedupe *int64) {
	o.EfficiencySpaceSavingsDedupe = efficiencySpaceSavingsDedupe
}

// WithEfficiencySpaceSavingsDedupePercent adds the efficiencySpaceSavingsDedupePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsDedupePercent(efficiencySpaceSavingsDedupePercent *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsDedupePercent(efficiencySpaceSavingsDedupePercent)
	return o
}

// SetEfficiencySpaceSavingsDedupePercent adds the efficiencySpaceSavingsDedupePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsDedupePercent(efficiencySpaceSavingsDedupePercent *int64) {
	o.EfficiencySpaceSavingsDedupePercent = efficiencySpaceSavingsDedupePercent
}

// WithEfficiencySpaceSavingsDedupeSharing adds the efficiencySpaceSavingsDedupeSharing to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsDedupeSharing(efficiencySpaceSavingsDedupeSharing *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsDedupeSharing(efficiencySpaceSavingsDedupeSharing)
	return o
}

// SetEfficiencySpaceSavingsDedupeSharing adds the efficiencySpaceSavingsDedupeSharing to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsDedupeSharing(efficiencySpaceSavingsDedupeSharing *int64) {
	o.EfficiencySpaceSavingsDedupeSharing = efficiencySpaceSavingsDedupeSharing
}

// WithEfficiencySpaceSavingsTotal adds the efficiencySpaceSavingsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsTotal(efficiencySpaceSavingsTotal *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsTotal(efficiencySpaceSavingsTotal)
	return o
}

// SetEfficiencySpaceSavingsTotal adds the efficiencySpaceSavingsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsTotal(efficiencySpaceSavingsTotal *int64) {
	o.EfficiencySpaceSavingsTotal = efficiencySpaceSavingsTotal
}

// WithEfficiencySpaceSavingsTotalPercent adds the efficiencySpaceSavingsTotalPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencySpaceSavingsTotalPercent(efficiencySpaceSavingsTotalPercent *int64) *VolumeCollectionGetParams {
	o.SetEfficiencySpaceSavingsTotalPercent(efficiencySpaceSavingsTotalPercent)
	return o
}

// SetEfficiencySpaceSavingsTotalPercent adds the efficiencySpaceSavingsTotalPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencySpaceSavingsTotalPercent(efficiencySpaceSavingsTotalPercent *int64) {
	o.EfficiencySpaceSavingsTotalPercent = efficiencySpaceSavingsTotalPercent
}

// WithEfficiencyState adds the efficiencyState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyState(efficiencyState *string) *VolumeCollectionGetParams {
	o.SetEfficiencyState(efficiencyState)
	return o
}

// SetEfficiencyState adds the efficiencyState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyState(efficiencyState *string) {
	o.EfficiencyState = efficiencyState
}

// WithEfficiencyStorageEfficiencyMode adds the efficiencyStorageEfficiencyMode to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyStorageEfficiencyMode(efficiencyStorageEfficiencyMode *string) *VolumeCollectionGetParams {
	o.SetEfficiencyStorageEfficiencyMode(efficiencyStorageEfficiencyMode)
	return o
}

// SetEfficiencyStorageEfficiencyMode adds the efficiencyStorageEfficiencyMode to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyStorageEfficiencyMode(efficiencyStorageEfficiencyMode *string) {
	o.EfficiencyStorageEfficiencyMode = efficiencyStorageEfficiencyMode
}

// WithEfficiencyType adds the efficiencyType to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyType(efficiencyType *string) *VolumeCollectionGetParams {
	o.SetEfficiencyType(efficiencyType)
	return o
}

// SetEfficiencyType adds the efficiencyType to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyType(efficiencyType *string) {
	o.EfficiencyType = efficiencyType
}

// WithEfficiencyVolumePath adds the efficiencyVolumePath to the volume collection get params
func (o *VolumeCollectionGetParams) WithEfficiencyVolumePath(efficiencyVolumePath *string) *VolumeCollectionGetParams {
	o.SetEfficiencyVolumePath(efficiencyVolumePath)
	return o
}

// SetEfficiencyVolumePath adds the efficiencyVolumePath to the volume collection get params
func (o *VolumeCollectionGetParams) SetEfficiencyVolumePath(efficiencyVolumePath *string) {
	o.EfficiencyVolumePath = efficiencyVolumePath
}

// WithEncryptionAction adds the encryptionAction to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionAction(encryptionAction *string) *VolumeCollectionGetParams {
	o.SetEncryptionAction(encryptionAction)
	return o
}

// SetEncryptionAction adds the encryptionAction to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionAction(encryptionAction *string) {
	o.EncryptionAction = encryptionAction
}

// WithEncryptionEnabled adds the encryptionEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionEnabled(encryptionEnabled *bool) *VolumeCollectionGetParams {
	o.SetEncryptionEnabled(encryptionEnabled)
	return o
}

// SetEncryptionEnabled adds the encryptionEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionEnabled(encryptionEnabled *bool) {
	o.EncryptionEnabled = encryptionEnabled
}

// WithEncryptionKeyCreateTime adds the encryptionKeyCreateTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionKeyCreateTime(encryptionKeyCreateTime *string) *VolumeCollectionGetParams {
	o.SetEncryptionKeyCreateTime(encryptionKeyCreateTime)
	return o
}

// SetEncryptionKeyCreateTime adds the encryptionKeyCreateTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionKeyCreateTime(encryptionKeyCreateTime *string) {
	o.EncryptionKeyCreateTime = encryptionKeyCreateTime
}

// WithEncryptionKeyID adds the encryptionKeyID to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionKeyID(encryptionKeyID *string) *VolumeCollectionGetParams {
	o.SetEncryptionKeyID(encryptionKeyID)
	return o
}

// SetEncryptionKeyID adds the encryptionKeyId to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionKeyID(encryptionKeyID *string) {
	o.EncryptionKeyID = encryptionKeyID
}

// WithEncryptionRekey adds the encryptionRekey to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionRekey(encryptionRekey *bool) *VolumeCollectionGetParams {
	o.SetEncryptionRekey(encryptionRekey)
	return o
}

// SetEncryptionRekey adds the encryptionRekey to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionRekey(encryptionRekey *bool) {
	o.EncryptionRekey = encryptionRekey
}

// WithEncryptionState adds the encryptionState to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionState(encryptionState *string) *VolumeCollectionGetParams {
	o.SetEncryptionState(encryptionState)
	return o
}

// SetEncryptionState adds the encryptionState to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionState(encryptionState *string) {
	o.EncryptionState = encryptionState
}

// WithEncryptionStatusCode adds the encryptionStatusCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionStatusCode(encryptionStatusCode *string) *VolumeCollectionGetParams {
	o.SetEncryptionStatusCode(encryptionStatusCode)
	return o
}

// SetEncryptionStatusCode adds the encryptionStatusCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionStatusCode(encryptionStatusCode *string) {
	o.EncryptionStatusCode = encryptionStatusCode
}

// WithEncryptionStatusMessage adds the encryptionStatusMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionStatusMessage(encryptionStatusMessage *string) *VolumeCollectionGetParams {
	o.SetEncryptionStatusMessage(encryptionStatusMessage)
	return o
}

// SetEncryptionStatusMessage adds the encryptionStatusMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionStatusMessage(encryptionStatusMessage *string) {
	o.EncryptionStatusMessage = encryptionStatusMessage
}

// WithEncryptionType adds the encryptionType to the volume collection get params
func (o *VolumeCollectionGetParams) WithEncryptionType(encryptionType *string) *VolumeCollectionGetParams {
	o.SetEncryptionType(encryptionType)
	return o
}

// SetEncryptionType adds the encryptionType to the volume collection get params
func (o *VolumeCollectionGetParams) SetEncryptionType(encryptionType *string) {
	o.EncryptionType = encryptionType
}

// WithErrorStateHasBadBlocks adds the errorStateHasBadBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) WithErrorStateHasBadBlocks(errorStateHasBadBlocks *bool) *VolumeCollectionGetParams {
	o.SetErrorStateHasBadBlocks(errorStateHasBadBlocks)
	return o
}

// SetErrorStateHasBadBlocks adds the errorStateHasBadBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) SetErrorStateHasBadBlocks(errorStateHasBadBlocks *bool) {
	o.ErrorStateHasBadBlocks = errorStateHasBadBlocks
}

// WithErrorStateIsInconsistent adds the errorStateIsInconsistent to the volume collection get params
func (o *VolumeCollectionGetParams) WithErrorStateIsInconsistent(errorStateIsInconsistent *bool) *VolumeCollectionGetParams {
	o.SetErrorStateIsInconsistent(errorStateIsInconsistent)
	return o
}

// SetErrorStateIsInconsistent adds the errorStateIsInconsistent to the volume collection get params
func (o *VolumeCollectionGetParams) SetErrorStateIsInconsistent(errorStateIsInconsistent *bool) {
	o.ErrorStateIsInconsistent = errorStateIsInconsistent
}

// WithFields adds the fields to the volume collection get params
func (o *VolumeCollectionGetParams) WithFields(fields []string) *VolumeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the volume collection get params
func (o *VolumeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFilesInodefileCapacity adds the filesInodefileCapacity to the volume collection get params
func (o *VolumeCollectionGetParams) WithFilesInodefileCapacity(filesInodefileCapacity *int64) *VolumeCollectionGetParams {
	o.SetFilesInodefileCapacity(filesInodefileCapacity)
	return o
}

// SetFilesInodefileCapacity adds the filesInodefileCapacity to the volume collection get params
func (o *VolumeCollectionGetParams) SetFilesInodefileCapacity(filesInodefileCapacity *int64) {
	o.FilesInodefileCapacity = filesInodefileCapacity
}

// WithFilesMaximum adds the filesMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) WithFilesMaximum(filesMaximum *int64) *VolumeCollectionGetParams {
	o.SetFilesMaximum(filesMaximum)
	return o
}

// SetFilesMaximum adds the filesMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) SetFilesMaximum(filesMaximum *int64) {
	o.FilesMaximum = filesMaximum
}

// WithFilesUsed adds the filesUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithFilesUsed(filesUsed *int64) *VolumeCollectionGetParams {
	o.SetFilesUsed(filesUsed)
	return o
}

// SetFilesUsed adds the filesUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetFilesUsed(filesUsed *int64) {
	o.FilesUsed = filesUsed
}

// WithFlashPoolCacheEligibility adds the flashPoolCacheEligibility to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlashPoolCacheEligibility(flashPoolCacheEligibility *string) *VolumeCollectionGetParams {
	o.SetFlashPoolCacheEligibility(flashPoolCacheEligibility)
	return o
}

// SetFlashPoolCacheEligibility adds the flashPoolCacheEligibility to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlashPoolCacheEligibility(flashPoolCacheEligibility *string) {
	o.FlashPoolCacheEligibility = flashPoolCacheEligibility
}

// WithFlashPoolCacheRetentionPriority adds the flashPoolCacheRetentionPriority to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlashPoolCacheRetentionPriority(flashPoolCacheRetentionPriority *string) *VolumeCollectionGetParams {
	o.SetFlashPoolCacheRetentionPriority(flashPoolCacheRetentionPriority)
	return o
}

// SetFlashPoolCacheRetentionPriority adds the flashPoolCacheRetentionPriority to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlashPoolCacheRetentionPriority(flashPoolCacheRetentionPriority *string) {
	o.FlashPoolCacheRetentionPriority = flashPoolCacheRetentionPriority
}

// WithFlashPoolCachingPolicy adds the flashPoolCachingPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlashPoolCachingPolicy(flashPoolCachingPolicy *string) *VolumeCollectionGetParams {
	o.SetFlashPoolCachingPolicy(flashPoolCachingPolicy)
	return o
}

// SetFlashPoolCachingPolicy adds the flashPoolCachingPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlashPoolCachingPolicy(flashPoolCachingPolicy *string) {
	o.FlashPoolCachingPolicy = flashPoolCachingPolicy
}

// WithFlexcacheEndpointType adds the flexcacheEndpointType to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlexcacheEndpointType(flexcacheEndpointType *string) *VolumeCollectionGetParams {
	o.SetFlexcacheEndpointType(flexcacheEndpointType)
	return o
}

// SetFlexcacheEndpointType adds the flexcacheEndpointType to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlexcacheEndpointType(flexcacheEndpointType *string) {
	o.FlexcacheEndpointType = flexcacheEndpointType
}

// WithFlexgroupName adds the flexgroupName to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlexgroupName(flexgroupName *string) *VolumeCollectionGetParams {
	o.SetFlexgroupName(flexgroupName)
	return o
}

// SetFlexgroupName adds the flexgroupName to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlexgroupName(flexgroupName *string) {
	o.FlexgroupName = flexgroupName
}

// WithFlexgroupUUID adds the flexgroupUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithFlexgroupUUID(flexgroupUUID *string) *VolumeCollectionGetParams {
	o.SetFlexgroupUUID(flexgroupUUID)
	return o
}

// SetFlexgroupUUID adds the flexgroupUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetFlexgroupUUID(flexgroupUUID *string) {
	o.FlexgroupUUID = flexgroupUUID
}

// WithGranularData adds the granularData to the volume collection get params
func (o *VolumeCollectionGetParams) WithGranularData(granularData *bool) *VolumeCollectionGetParams {
	o.SetGranularData(granularData)
	return o
}

// SetGranularData adds the granularData to the volume collection get params
func (o *VolumeCollectionGetParams) SetGranularData(granularData *bool) {
	o.GranularData = granularData
}

// WithGranularDataMode adds the granularDataMode to the volume collection get params
func (o *VolumeCollectionGetParams) WithGranularDataMode(granularDataMode *string) *VolumeCollectionGetParams {
	o.SetGranularDataMode(granularDataMode)
	return o
}

// SetGranularDataMode adds the granularDataMode to the volume collection get params
func (o *VolumeCollectionGetParams) SetGranularDataMode(granularDataMode *string) {
	o.GranularDataMode = granularDataMode
}

// WithGuaranteeHonored adds the guaranteeHonored to the volume collection get params
func (o *VolumeCollectionGetParams) WithGuaranteeHonored(guaranteeHonored *bool) *VolumeCollectionGetParams {
	o.SetGuaranteeHonored(guaranteeHonored)
	return o
}

// SetGuaranteeHonored adds the guaranteeHonored to the volume collection get params
func (o *VolumeCollectionGetParams) SetGuaranteeHonored(guaranteeHonored *bool) {
	o.GuaranteeHonored = guaranteeHonored
}

// WithGuaranteeType adds the guaranteeType to the volume collection get params
func (o *VolumeCollectionGetParams) WithGuaranteeType(guaranteeType *string) *VolumeCollectionGetParams {
	o.SetGuaranteeType(guaranteeType)
	return o
}

// SetGuaranteeType adds the guaranteeType to the volume collection get params
func (o *VolumeCollectionGetParams) SetGuaranteeType(guaranteeType *string) {
	o.GuaranteeType = guaranteeType
}

// WithHasDirIndexPublic adds the hasDirIndexPublic to the volume collection get params
func (o *VolumeCollectionGetParams) WithHasDirIndexPublic(hasDirIndexPublic *bool) *VolumeCollectionGetParams {
	o.SetHasDirIndexPublic(hasDirIndexPublic)
	return o
}

// SetHasDirIndexPublic adds the hasDirIndexPublic to the volume collection get params
func (o *VolumeCollectionGetParams) SetHasDirIndexPublic(hasDirIndexPublic *bool) {
	o.HasDirIndexPublic = hasDirIndexPublic
}

// WithHasLargeDir adds the hasLargeDir to the volume collection get params
func (o *VolumeCollectionGetParams) WithHasLargeDir(hasLargeDir *bool) *VolumeCollectionGetParams {
	o.SetHasLargeDir(hasLargeDir)
	return o
}

// SetHasLargeDir adds the hasLargeDir to the volume collection get params
func (o *VolumeCollectionGetParams) SetHasLargeDir(hasLargeDir *bool) {
	o.HasLargeDir = hasLargeDir
}

// WithIsConstituent adds the isConstituent to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsConstituent(isConstituent *bool) *VolumeCollectionGetParams {
	o.SetIsConstituent(isConstituent)
	return o
}

// SetIsConstituent adds the isConstituent to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsConstituent(isConstituent *bool) {
	o.IsConstituent = isConstituent
}

// WithIsDirIndexTransferEnabled adds the isDirIndexTransferEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsDirIndexTransferEnabled(isDirIndexTransferEnabled *bool) *VolumeCollectionGetParams {
	o.SetIsDirIndexTransferEnabled(isDirIndexTransferEnabled)
	return o
}

// SetIsDirIndexTransferEnabled adds the isDirIndexTransferEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsDirIndexTransferEnabled(isDirIndexTransferEnabled *bool) {
	o.IsDirIndexTransferEnabled = isDirIndexTransferEnabled
}

// WithIsLargeDirEnabled adds the isLargeDirEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsLargeDirEnabled(isLargeDirEnabled *bool) *VolumeCollectionGetParams {
	o.SetIsLargeDirEnabled(isLargeDirEnabled)
	return o
}

// SetIsLargeDirEnabled adds the isLargeDirEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsLargeDirEnabled(isLargeDirEnabled *bool) {
	o.IsLargeDirEnabled = isLargeDirEnabled
}

// WithIsObjectStore adds the isObjectStore to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsObjectStore(isObjectStore *bool) *VolumeCollectionGetParams {
	o.SetIsObjectStore(isObjectStore)
	return o
}

// SetIsObjectStore adds the isObjectStore to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsObjectStore(isObjectStore *bool) {
	o.IsObjectStore = isObjectStore
}

// WithIsS3ArbitraryPartSizeEnabled adds the isS3ArbitraryPartSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsS3ArbitraryPartSizeEnabled(isS3ArbitraryPartSizeEnabled *bool) *VolumeCollectionGetParams {
	o.SetIsS3ArbitraryPartSizeEnabled(isS3ArbitraryPartSizeEnabled)
	return o
}

// SetIsS3ArbitraryPartSizeEnabled adds the isS3ArbitraryPartSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsS3ArbitraryPartSizeEnabled(isS3ArbitraryPartSizeEnabled *bool) {
	o.IsS3ArbitraryPartSizeEnabled = isS3ArbitraryPartSizeEnabled
}

// WithIsSvmRoot adds the isSvmRoot to the volume collection get params
func (o *VolumeCollectionGetParams) WithIsSvmRoot(isSvmRoot *bool) *VolumeCollectionGetParams {
	o.SetIsSvmRoot(isSvmRoot)
	return o
}

// SetIsSvmRoot adds the isSvmRoot to the volume collection get params
func (o *VolumeCollectionGetParams) SetIsSvmRoot(isSvmRoot *bool) {
	o.IsSvmRoot = isSvmRoot
}

// WithLanguage adds the language to the volume collection get params
func (o *VolumeCollectionGetParams) WithLanguage(language *string) *VolumeCollectionGetParams {
	o.SetLanguage(language)
	return o
}

// SetLanguage adds the language to the volume collection get params
func (o *VolumeCollectionGetParams) SetLanguage(language *string) {
	o.Language = language
}

// WithMaxDirSize adds the maxDirSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithMaxDirSize(maxDirSize *int64) *VolumeCollectionGetParams {
	o.SetMaxDirSize(maxDirSize)
	return o
}

// SetMaxDirSize adds the maxDirSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetMaxDirSize(maxDirSize *int64) {
	o.MaxDirSize = maxDirSize
}

// WithMaxRecords adds the maxRecords to the volume collection get params
func (o *VolumeCollectionGetParams) WithMaxRecords(maxRecords *int64) *VolumeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the volume collection get params
func (o *VolumeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetricCloudDuration adds the metricCloudDuration to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudDuration(metricCloudDuration *string) *VolumeCollectionGetParams {
	o.SetMetricCloudDuration(metricCloudDuration)
	return o
}

// SetMetricCloudDuration adds the metricCloudDuration to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudDuration(metricCloudDuration *string) {
	o.MetricCloudDuration = metricCloudDuration
}

// WithMetricCloudIopsOther adds the metricCloudIopsOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudIopsOther(metricCloudIopsOther *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudIopsOther(metricCloudIopsOther)
	return o
}

// SetMetricCloudIopsOther adds the metricCloudIopsOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudIopsOther(metricCloudIopsOther *int64) {
	o.MetricCloudIopsOther = metricCloudIopsOther
}

// WithMetricCloudIopsRead adds the metricCloudIopsRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudIopsRead(metricCloudIopsRead *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudIopsRead(metricCloudIopsRead)
	return o
}

// SetMetricCloudIopsRead adds the metricCloudIopsRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudIopsRead(metricCloudIopsRead *int64) {
	o.MetricCloudIopsRead = metricCloudIopsRead
}

// WithMetricCloudIopsTotal adds the metricCloudIopsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudIopsTotal(metricCloudIopsTotal *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudIopsTotal(metricCloudIopsTotal)
	return o
}

// SetMetricCloudIopsTotal adds the metricCloudIopsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudIopsTotal(metricCloudIopsTotal *int64) {
	o.MetricCloudIopsTotal = metricCloudIopsTotal
}

// WithMetricCloudIopsWrite adds the metricCloudIopsWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudIopsWrite(metricCloudIopsWrite *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudIopsWrite(metricCloudIopsWrite)
	return o
}

// SetMetricCloudIopsWrite adds the metricCloudIopsWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudIopsWrite(metricCloudIopsWrite *int64) {
	o.MetricCloudIopsWrite = metricCloudIopsWrite
}

// WithMetricCloudLatencyOther adds the metricCloudLatencyOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudLatencyOther(metricCloudLatencyOther *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudLatencyOther(metricCloudLatencyOther)
	return o
}

// SetMetricCloudLatencyOther adds the metricCloudLatencyOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudLatencyOther(metricCloudLatencyOther *int64) {
	o.MetricCloudLatencyOther = metricCloudLatencyOther
}

// WithMetricCloudLatencyRead adds the metricCloudLatencyRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudLatencyRead(metricCloudLatencyRead *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudLatencyRead(metricCloudLatencyRead)
	return o
}

// SetMetricCloudLatencyRead adds the metricCloudLatencyRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudLatencyRead(metricCloudLatencyRead *int64) {
	o.MetricCloudLatencyRead = metricCloudLatencyRead
}

// WithMetricCloudLatencyTotal adds the metricCloudLatencyTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudLatencyTotal(metricCloudLatencyTotal *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudLatencyTotal(metricCloudLatencyTotal)
	return o
}

// SetMetricCloudLatencyTotal adds the metricCloudLatencyTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudLatencyTotal(metricCloudLatencyTotal *int64) {
	o.MetricCloudLatencyTotal = metricCloudLatencyTotal
}

// WithMetricCloudLatencyWrite adds the metricCloudLatencyWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudLatencyWrite(metricCloudLatencyWrite *int64) *VolumeCollectionGetParams {
	o.SetMetricCloudLatencyWrite(metricCloudLatencyWrite)
	return o
}

// SetMetricCloudLatencyWrite adds the metricCloudLatencyWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudLatencyWrite(metricCloudLatencyWrite *int64) {
	o.MetricCloudLatencyWrite = metricCloudLatencyWrite
}

// WithMetricCloudStatus adds the metricCloudStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudStatus(metricCloudStatus *string) *VolumeCollectionGetParams {
	o.SetMetricCloudStatus(metricCloudStatus)
	return o
}

// SetMetricCloudStatus adds the metricCloudStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudStatus(metricCloudStatus *string) {
	o.MetricCloudStatus = metricCloudStatus
}

// WithMetricCloudTimestamp adds the metricCloudTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricCloudTimestamp(metricCloudTimestamp *string) *VolumeCollectionGetParams {
	o.SetMetricCloudTimestamp(metricCloudTimestamp)
	return o
}

// SetMetricCloudTimestamp adds the metricCloudTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricCloudTimestamp(metricCloudTimestamp *string) {
	o.MetricCloudTimestamp = metricCloudTimestamp
}

// WithMetricDuration adds the metricDuration to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricDuration(metricDuration *string) *VolumeCollectionGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricFlexcacheBandwidthSavings adds the metricFlexcacheBandwidthSavings to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricFlexcacheBandwidthSavings(metricFlexcacheBandwidthSavings *int64) *VolumeCollectionGetParams {
	o.SetMetricFlexcacheBandwidthSavings(metricFlexcacheBandwidthSavings)
	return o
}

// SetMetricFlexcacheBandwidthSavings adds the metricFlexcacheBandwidthSavings to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricFlexcacheBandwidthSavings(metricFlexcacheBandwidthSavings *int64) {
	o.MetricFlexcacheBandwidthSavings = metricFlexcacheBandwidthSavings
}

// WithMetricFlexcacheCacheMissPercent adds the metricFlexcacheCacheMissPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricFlexcacheCacheMissPercent(metricFlexcacheCacheMissPercent *int64) *VolumeCollectionGetParams {
	o.SetMetricFlexcacheCacheMissPercent(metricFlexcacheCacheMissPercent)
	return o
}

// SetMetricFlexcacheCacheMissPercent adds the metricFlexcacheCacheMissPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricFlexcacheCacheMissPercent(metricFlexcacheCacheMissPercent *int64) {
	o.MetricFlexcacheCacheMissPercent = metricFlexcacheCacheMissPercent
}

// WithMetricFlexcacheDuration adds the metricFlexcacheDuration to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricFlexcacheDuration(metricFlexcacheDuration *string) *VolumeCollectionGetParams {
	o.SetMetricFlexcacheDuration(metricFlexcacheDuration)
	return o
}

// SetMetricFlexcacheDuration adds the metricFlexcacheDuration to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricFlexcacheDuration(metricFlexcacheDuration *string) {
	o.MetricFlexcacheDuration = metricFlexcacheDuration
}

// WithMetricFlexcacheStatus adds the metricFlexcacheStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricFlexcacheStatus(metricFlexcacheStatus *string) *VolumeCollectionGetParams {
	o.SetMetricFlexcacheStatus(metricFlexcacheStatus)
	return o
}

// SetMetricFlexcacheStatus adds the metricFlexcacheStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricFlexcacheStatus(metricFlexcacheStatus *string) {
	o.MetricFlexcacheStatus = metricFlexcacheStatus
}

// WithMetricFlexcacheTimestamp adds the metricFlexcacheTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricFlexcacheTimestamp(metricFlexcacheTimestamp *string) *VolumeCollectionGetParams {
	o.SetMetricFlexcacheTimestamp(metricFlexcacheTimestamp)
	return o
}

// SetMetricFlexcacheTimestamp adds the metricFlexcacheTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricFlexcacheTimestamp(metricFlexcacheTimestamp *string) {
	o.MetricFlexcacheTimestamp = metricFlexcacheTimestamp
}

// WithMetricIopsOther adds the metricIopsOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricIopsOther(metricIopsOther *int64) *VolumeCollectionGetParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricIopsRead(metricIopsRead *int64) *VolumeCollectionGetParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricIopsTotal(metricIopsTotal *int64) *VolumeCollectionGetParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricIopsWrite(metricIopsWrite *int64) *VolumeCollectionGetParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricLatencyOther(metricLatencyOther *int64) *VolumeCollectionGetParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricLatencyRead(metricLatencyRead *int64) *VolumeCollectionGetParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *VolumeCollectionGetParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *VolumeCollectionGetParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricStatus(metricStatus *string) *VolumeCollectionGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputOther adds the metricThroughputOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricThroughputOther(metricThroughputOther *int64) *VolumeCollectionGetParams {
	o.SetMetricThroughputOther(metricThroughputOther)
	return o
}

// SetMetricThroughputOther adds the metricThroughputOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricThroughputOther(metricThroughputOther *int64) {
	o.MetricThroughputOther = metricThroughputOther
}

// WithMetricThroughputRead adds the metricThroughputRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricThroughputRead(metricThroughputRead *int64) *VolumeCollectionGetParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *VolumeCollectionGetParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *VolumeCollectionGetParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithMetricTimestamp(metricTimestamp *string) *VolumeCollectionGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMovementCapacityTierOptimized adds the movementCapacityTierOptimized to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementCapacityTierOptimized(movementCapacityTierOptimized *bool) *VolumeCollectionGetParams {
	o.SetMovementCapacityTierOptimized(movementCapacityTierOptimized)
	return o
}

// SetMovementCapacityTierOptimized adds the movementCapacityTierOptimized to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementCapacityTierOptimized(movementCapacityTierOptimized *bool) {
	o.MovementCapacityTierOptimized = movementCapacityTierOptimized
}

// WithMovementCutoverWindow adds the movementCutoverWindow to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementCutoverWindow(movementCutoverWindow *int64) *VolumeCollectionGetParams {
	o.SetMovementCutoverWindow(movementCutoverWindow)
	return o
}

// SetMovementCutoverWindow adds the movementCutoverWindow to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementCutoverWindow(movementCutoverWindow *int64) {
	o.MovementCutoverWindow = movementCutoverWindow
}

// WithMovementDestinationAggregateName adds the movementDestinationAggregateName to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementDestinationAggregateName(movementDestinationAggregateName *string) *VolumeCollectionGetParams {
	o.SetMovementDestinationAggregateName(movementDestinationAggregateName)
	return o
}

// SetMovementDestinationAggregateName adds the movementDestinationAggregateName to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementDestinationAggregateName(movementDestinationAggregateName *string) {
	o.MovementDestinationAggregateName = movementDestinationAggregateName
}

// WithMovementDestinationAggregateUUID adds the movementDestinationAggregateUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementDestinationAggregateUUID(movementDestinationAggregateUUID *string) *VolumeCollectionGetParams {
	o.SetMovementDestinationAggregateUUID(movementDestinationAggregateUUID)
	return o
}

// SetMovementDestinationAggregateUUID adds the movementDestinationAggregateUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementDestinationAggregateUUID(movementDestinationAggregateUUID *string) {
	o.MovementDestinationAggregateUUID = movementDestinationAggregateUUID
}

// WithMovementPercentComplete adds the movementPercentComplete to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementPercentComplete(movementPercentComplete *int64) *VolumeCollectionGetParams {
	o.SetMovementPercentComplete(movementPercentComplete)
	return o
}

// SetMovementPercentComplete adds the movementPercentComplete to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementPercentComplete(movementPercentComplete *int64) {
	o.MovementPercentComplete = movementPercentComplete
}

// WithMovementStartTime adds the movementStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementStartTime(movementStartTime *string) *VolumeCollectionGetParams {
	o.SetMovementStartTime(movementStartTime)
	return o
}

// SetMovementStartTime adds the movementStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementStartTime(movementStartTime *string) {
	o.MovementStartTime = movementStartTime
}

// WithMovementState adds the movementState to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementState(movementState *string) *VolumeCollectionGetParams {
	o.SetMovementState(movementState)
	return o
}

// SetMovementState adds the movementState to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementState(movementState *string) {
	o.MovementState = movementState
}

// WithMovementTieringPolicy adds the movementTieringPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) WithMovementTieringPolicy(movementTieringPolicy *string) *VolumeCollectionGetParams {
	o.SetMovementTieringPolicy(movementTieringPolicy)
	return o
}

// SetMovementTieringPolicy adds the movementTieringPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) SetMovementTieringPolicy(movementTieringPolicy *string) {
	o.MovementTieringPolicy = movementTieringPolicy
}

// WithMsid adds the msid to the volume collection get params
func (o *VolumeCollectionGetParams) WithMsid(msid *int64) *VolumeCollectionGetParams {
	o.SetMsid(msid)
	return o
}

// SetMsid adds the msid to the volume collection get params
func (o *VolumeCollectionGetParams) SetMsid(msid *int64) {
	o.Msid = msid
}

// WithName adds the name to the volume collection get params
func (o *VolumeCollectionGetParams) WithName(name *string) *VolumeCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the volume collection get params
func (o *VolumeCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNasExportPolicyID adds the nasExportPolicyID to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasExportPolicyID(nasExportPolicyID *int64) *VolumeCollectionGetParams {
	o.SetNasExportPolicyID(nasExportPolicyID)
	return o
}

// SetNasExportPolicyID adds the nasExportPolicyId to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasExportPolicyID(nasExportPolicyID *int64) {
	o.NasExportPolicyID = nasExportPolicyID
}

// WithNasExportPolicyName adds the nasExportPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasExportPolicyName(nasExportPolicyName *string) *VolumeCollectionGetParams {
	o.SetNasExportPolicyName(nasExportPolicyName)
	return o
}

// SetNasExportPolicyName adds the nasExportPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasExportPolicyName(nasExportPolicyName *string) {
	o.NasExportPolicyName = nasExportPolicyName
}

// WithNasGid adds the nasGid to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasGid(nasGid *int64) *VolumeCollectionGetParams {
	o.SetNasGid(nasGid)
	return o
}

// SetNasGid adds the nasGid to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasGid(nasGid *int64) {
	o.NasGid = nasGid
}

// WithNasJunctionParentName adds the nasJunctionParentName to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasJunctionParentName(nasJunctionParentName *string) *VolumeCollectionGetParams {
	o.SetNasJunctionParentName(nasJunctionParentName)
	return o
}

// SetNasJunctionParentName adds the nasJunctionParentName to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasJunctionParentName(nasJunctionParentName *string) {
	o.NasJunctionParentName = nasJunctionParentName
}

// WithNasJunctionParentUUID adds the nasJunctionParentUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasJunctionParentUUID(nasJunctionParentUUID *string) *VolumeCollectionGetParams {
	o.SetNasJunctionParentUUID(nasJunctionParentUUID)
	return o
}

// SetNasJunctionParentUUID adds the nasJunctionParentUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasJunctionParentUUID(nasJunctionParentUUID *string) {
	o.NasJunctionParentUUID = nasJunctionParentUUID
}

// WithNasPath adds the nasPath to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasPath(nasPath *string) *VolumeCollectionGetParams {
	o.SetNasPath(nasPath)
	return o
}

// SetNasPath adds the nasPath to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasPath(nasPath *string) {
	o.NasPath = nasPath
}

// WithNasSecurityStyle adds the nasSecurityStyle to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasSecurityStyle(nasSecurityStyle *string) *VolumeCollectionGetParams {
	o.SetNasSecurityStyle(nasSecurityStyle)
	return o
}

// SetNasSecurityStyle adds the nasSecurityStyle to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasSecurityStyle(nasSecurityStyle *string) {
	o.NasSecurityStyle = nasSecurityStyle
}

// WithNasUID adds the nasUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasUID(nasUID *int64) *VolumeCollectionGetParams {
	o.SetNasUID(nasUID)
	return o
}

// SetNasUID adds the nasUid to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasUID(nasUID *int64) {
	o.NasUID = nasUID
}

// WithNasUnixPermissions adds the nasUnixPermissions to the volume collection get params
func (o *VolumeCollectionGetParams) WithNasUnixPermissions(nasUnixPermissions *int64) *VolumeCollectionGetParams {
	o.SetNasUnixPermissions(nasUnixPermissions)
	return o
}

// SetNasUnixPermissions adds the nasUnixPermissions to the volume collection get params
func (o *VolumeCollectionGetParams) SetNasUnixPermissions(nasUnixPermissions *int64) {
	o.NasUnixPermissions = nasUnixPermissions
}

// WithNodesName adds the nodesName to the volume collection get params
func (o *VolumeCollectionGetParams) WithNodesName(nodesName *string) *VolumeCollectionGetParams {
	o.SetNodesName(nodesName)
	return o
}

// SetNodesName adds the nodesName to the volume collection get params
func (o *VolumeCollectionGetParams) SetNodesName(nodesName *string) {
	o.NodesName = nodesName
}

// WithNodesUUID adds the nodesUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithNodesUUID(nodesUUID *string) *VolumeCollectionGetParams {
	o.SetNodesUUID(nodesUUID)
	return o
}

// SetNodesUUID adds the nodesUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetNodesUUID(nodesUUID *string) {
	o.NodesUUID = nodesUUID
}

// WithOrderBy adds the orderBy to the volume collection get params
func (o *VolumeCollectionGetParams) WithOrderBy(orderBy []string) *VolumeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the volume collection get params
func (o *VolumeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) *VolumeCollectionGetParams {
	o.SetQosPolicyMaxThroughput(qosPolicyMaxThroughput)
	return o
}

// SetQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) {
	o.QosPolicyMaxThroughput = qosPolicyMaxThroughput
}

// WithQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) *VolumeCollectionGetParams {
	o.SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops)
	return o
}

// SetQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) {
	o.QosPolicyMaxThroughputIops = qosPolicyMaxThroughputIops
}

// WithQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) *VolumeCollectionGetParams {
	o.SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps)
	return o
}

// SetQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) {
	o.QosPolicyMaxThroughputMbps = qosPolicyMaxThroughputMbps
}

// WithQosPolicyMinThroughput adds the qosPolicyMinThroughput to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMinThroughput(qosPolicyMinThroughput *string) *VolumeCollectionGetParams {
	o.SetQosPolicyMinThroughput(qosPolicyMinThroughput)
	return o
}

// SetQosPolicyMinThroughput adds the qosPolicyMinThroughput to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMinThroughput(qosPolicyMinThroughput *string) {
	o.QosPolicyMinThroughput = qosPolicyMinThroughput
}

// WithQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) *VolumeCollectionGetParams {
	o.SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops)
	return o
}

// SetQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) {
	o.QosPolicyMinThroughputIops = qosPolicyMinThroughputIops
}

// WithQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) *VolumeCollectionGetParams {
	o.SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps)
	return o
}

// SetQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) {
	o.QosPolicyMinThroughputMbps = qosPolicyMinThroughputMbps
}

// WithQosPolicyName adds the qosPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyName(qosPolicyName *string) *VolumeCollectionGetParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithQosPolicyUUID(qosPolicyUUID *string) *VolumeCollectionGetParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithQueueForEncryption adds the queueForEncryption to the volume collection get params
func (o *VolumeCollectionGetParams) WithQueueForEncryption(queueForEncryption *bool) *VolumeCollectionGetParams {
	o.SetQueueForEncryption(queueForEncryption)
	return o
}

// SetQueueForEncryption adds the queueForEncryption to the volume collection get params
func (o *VolumeCollectionGetParams) SetQueueForEncryption(queueForEncryption *bool) {
	o.QueueForEncryption = queueForEncryption
}

// WithQuotaState adds the quotaState to the volume collection get params
func (o *VolumeCollectionGetParams) WithQuotaState(quotaState *string) *VolumeCollectionGetParams {
	o.SetQuotaState(quotaState)
	return o
}

// SetQuotaState adds the quotaState to the volume collection get params
func (o *VolumeCollectionGetParams) SetQuotaState(quotaState *string) {
	o.QuotaState = quotaState
}

// WithRebalancingDataMoved adds the rebalancingDataMoved to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingDataMoved(rebalancingDataMoved *int64) *VolumeCollectionGetParams {
	o.SetRebalancingDataMoved(rebalancingDataMoved)
	return o
}

// SetRebalancingDataMoved adds the rebalancingDataMoved to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingDataMoved(rebalancingDataMoved *int64) {
	o.RebalancingDataMoved = rebalancingDataMoved
}

// WithRebalancingEngineMovementFileMovesStarted adds the rebalancingEngineMovementFileMovesStarted to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementFileMovesStarted(rebalancingEngineMovementFileMovesStarted *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementFileMovesStarted(rebalancingEngineMovementFileMovesStarted)
	return o
}

// SetRebalancingEngineMovementFileMovesStarted adds the rebalancingEngineMovementFileMovesStarted to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementFileMovesStarted(rebalancingEngineMovementFileMovesStarted *int64) {
	o.RebalancingEngineMovementFileMovesStarted = rebalancingEngineMovementFileMovesStarted
}

// WithRebalancingEngineMovementLastErrorCode adds the rebalancingEngineMovementLastErrorCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementLastErrorCode(rebalancingEngineMovementLastErrorCode *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementLastErrorCode(rebalancingEngineMovementLastErrorCode)
	return o
}

// SetRebalancingEngineMovementLastErrorCode adds the rebalancingEngineMovementLastErrorCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementLastErrorCode(rebalancingEngineMovementLastErrorCode *int64) {
	o.RebalancingEngineMovementLastErrorCode = rebalancingEngineMovementLastErrorCode
}

// WithRebalancingEngineMovementLastErrorDestination adds the rebalancingEngineMovementLastErrorDestination to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementLastErrorDestination(rebalancingEngineMovementLastErrorDestination *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementLastErrorDestination(rebalancingEngineMovementLastErrorDestination)
	return o
}

// SetRebalancingEngineMovementLastErrorDestination adds the rebalancingEngineMovementLastErrorDestination to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementLastErrorDestination(rebalancingEngineMovementLastErrorDestination *int64) {
	o.RebalancingEngineMovementLastErrorDestination = rebalancingEngineMovementLastErrorDestination
}

// WithRebalancingEngineMovementLastErrorFileID adds the rebalancingEngineMovementLastErrorFileID to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementLastErrorFileID(rebalancingEngineMovementLastErrorFileID *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementLastErrorFileID(rebalancingEngineMovementLastErrorFileID)
	return o
}

// SetRebalancingEngineMovementLastErrorFileID adds the rebalancingEngineMovementLastErrorFileId to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementLastErrorFileID(rebalancingEngineMovementLastErrorFileID *int64) {
	o.RebalancingEngineMovementLastErrorFileID = rebalancingEngineMovementLastErrorFileID
}

// WithRebalancingEngineMovementLastErrorTime adds the rebalancingEngineMovementLastErrorTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementLastErrorTime(rebalancingEngineMovementLastErrorTime *string) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementLastErrorTime(rebalancingEngineMovementLastErrorTime)
	return o
}

// SetRebalancingEngineMovementLastErrorTime adds the rebalancingEngineMovementLastErrorTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementLastErrorTime(rebalancingEngineMovementLastErrorTime *string) {
	o.RebalancingEngineMovementLastErrorTime = rebalancingEngineMovementLastErrorTime
}

// WithRebalancingEngineMovementMostRecentStartTime adds the rebalancingEngineMovementMostRecentStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineMovementMostRecentStartTime(rebalancingEngineMovementMostRecentStartTime *string) *VolumeCollectionGetParams {
	o.SetRebalancingEngineMovementMostRecentStartTime(rebalancingEngineMovementMostRecentStartTime)
	return o
}

// SetRebalancingEngineMovementMostRecentStartTime adds the rebalancingEngineMovementMostRecentStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineMovementMostRecentStartTime(rebalancingEngineMovementMostRecentStartTime *string) {
	o.RebalancingEngineMovementMostRecentStartTime = rebalancingEngineMovementMostRecentStartTime
}

// WithRebalancingEngineScannerBlocksScanned adds the rebalancingEngineScannerBlocksScanned to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksScanned(rebalancingEngineScannerBlocksScanned *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksScanned(rebalancingEngineScannerBlocksScanned)
	return o
}

// SetRebalancingEngineScannerBlocksScanned adds the rebalancingEngineScannerBlocksScanned to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksScanned(rebalancingEngineScannerBlocksScanned *int64) {
	o.RebalancingEngineScannerBlocksScanned = rebalancingEngineScannerBlocksScanned
}

// WithRebalancingEngineScannerBlocksSkippedEfficiencyBlocks adds the rebalancingEngineScannerBlocksSkippedEfficiencyBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedEfficiencyBlocks(rebalancingEngineScannerBlocksSkippedEfficiencyBlocks *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedEfficiencyBlocks(rebalancingEngineScannerBlocksSkippedEfficiencyBlocks)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedEfficiencyBlocks adds the rebalancingEngineScannerBlocksSkippedEfficiencyBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedEfficiencyBlocks(rebalancingEngineScannerBlocksSkippedEfficiencyBlocks *int64) {
	o.RebalancingEngineScannerBlocksSkippedEfficiencyBlocks = rebalancingEngineScannerBlocksSkippedEfficiencyBlocks
}

// WithRebalancingEngineScannerBlocksSkippedEfficiencyPercent adds the rebalancingEngineScannerBlocksSkippedEfficiencyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedEfficiencyPercent(rebalancingEngineScannerBlocksSkippedEfficiencyPercent *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedEfficiencyPercent(rebalancingEngineScannerBlocksSkippedEfficiencyPercent)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedEfficiencyPercent adds the rebalancingEngineScannerBlocksSkippedEfficiencyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedEfficiencyPercent(rebalancingEngineScannerBlocksSkippedEfficiencyPercent *int64) {
	o.RebalancingEngineScannerBlocksSkippedEfficiencyPercent = rebalancingEngineScannerBlocksSkippedEfficiencyPercent
}

// WithRebalancingEngineScannerBlocksSkippedFastTruncate adds the rebalancingEngineScannerBlocksSkippedFastTruncate to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedFastTruncate(rebalancingEngineScannerBlocksSkippedFastTruncate *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedFastTruncate(rebalancingEngineScannerBlocksSkippedFastTruncate)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedFastTruncate adds the rebalancingEngineScannerBlocksSkippedFastTruncate to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedFastTruncate(rebalancingEngineScannerBlocksSkippedFastTruncate *int64) {
	o.RebalancingEngineScannerBlocksSkippedFastTruncate = rebalancingEngineScannerBlocksSkippedFastTruncate
}

// WithRebalancingEngineScannerBlocksSkippedFootprintInvalid adds the rebalancingEngineScannerBlocksSkippedFootprintInvalid to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedFootprintInvalid(rebalancingEngineScannerBlocksSkippedFootprintInvalid *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedFootprintInvalid(rebalancingEngineScannerBlocksSkippedFootprintInvalid)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedFootprintInvalid adds the rebalancingEngineScannerBlocksSkippedFootprintInvalid to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedFootprintInvalid(rebalancingEngineScannerBlocksSkippedFootprintInvalid *int64) {
	o.RebalancingEngineScannerBlocksSkippedFootprintInvalid = rebalancingEngineScannerBlocksSkippedFootprintInvalid
}

// WithRebalancingEngineScannerBlocksSkippedInSnapshot adds the rebalancingEngineScannerBlocksSkippedInSnapshot to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedInSnapshot(rebalancingEngineScannerBlocksSkippedInSnapshot *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedInSnapshot(rebalancingEngineScannerBlocksSkippedInSnapshot)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedInSnapshot adds the rebalancingEngineScannerBlocksSkippedInSnapshot to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedInSnapshot(rebalancingEngineScannerBlocksSkippedInSnapshot *int64) {
	o.RebalancingEngineScannerBlocksSkippedInSnapshot = rebalancingEngineScannerBlocksSkippedInSnapshot
}

// WithRebalancingEngineScannerBlocksSkippedIncompatible adds the rebalancingEngineScannerBlocksSkippedIncompatible to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedIncompatible(rebalancingEngineScannerBlocksSkippedIncompatible *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedIncompatible(rebalancingEngineScannerBlocksSkippedIncompatible)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedIncompatible adds the rebalancingEngineScannerBlocksSkippedIncompatible to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedIncompatible(rebalancingEngineScannerBlocksSkippedIncompatible *int64) {
	o.RebalancingEngineScannerBlocksSkippedIncompatible = rebalancingEngineScannerBlocksSkippedIncompatible
}

// WithRebalancingEngineScannerBlocksSkippedMetadata adds the rebalancingEngineScannerBlocksSkippedMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedMetadata(rebalancingEngineScannerBlocksSkippedMetadata *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedMetadata(rebalancingEngineScannerBlocksSkippedMetadata)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedMetadata adds the rebalancingEngineScannerBlocksSkippedMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedMetadata(rebalancingEngineScannerBlocksSkippedMetadata *int64) {
	o.RebalancingEngineScannerBlocksSkippedMetadata = rebalancingEngineScannerBlocksSkippedMetadata
}

// WithRebalancingEngineScannerBlocksSkippedOnDemandDestination adds the rebalancingEngineScannerBlocksSkippedOnDemandDestination to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedOnDemandDestination(rebalancingEngineScannerBlocksSkippedOnDemandDestination *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedOnDemandDestination(rebalancingEngineScannerBlocksSkippedOnDemandDestination)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedOnDemandDestination adds the rebalancingEngineScannerBlocksSkippedOnDemandDestination to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedOnDemandDestination(rebalancingEngineScannerBlocksSkippedOnDemandDestination *int64) {
	o.RebalancingEngineScannerBlocksSkippedOnDemandDestination = rebalancingEngineScannerBlocksSkippedOnDemandDestination
}

// WithRebalancingEngineScannerBlocksSkippedOther adds the rebalancingEngineScannerBlocksSkippedOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedOther(rebalancingEngineScannerBlocksSkippedOther *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedOther(rebalancingEngineScannerBlocksSkippedOther)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedOther adds the rebalancingEngineScannerBlocksSkippedOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedOther(rebalancingEngineScannerBlocksSkippedOther *int64) {
	o.RebalancingEngineScannerBlocksSkippedOther = rebalancingEngineScannerBlocksSkippedOther
}

// WithRebalancingEngineScannerBlocksSkippedRemoteCache adds the rebalancingEngineScannerBlocksSkippedRemoteCache to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedRemoteCache(rebalancingEngineScannerBlocksSkippedRemoteCache *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedRemoteCache(rebalancingEngineScannerBlocksSkippedRemoteCache)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedRemoteCache adds the rebalancingEngineScannerBlocksSkippedRemoteCache to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedRemoteCache(rebalancingEngineScannerBlocksSkippedRemoteCache *int64) {
	o.RebalancingEngineScannerBlocksSkippedRemoteCache = rebalancingEngineScannerBlocksSkippedRemoteCache
}

// WithRebalancingEngineScannerBlocksSkippedTooLarge adds the rebalancingEngineScannerBlocksSkippedTooLarge to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedTooLarge(rebalancingEngineScannerBlocksSkippedTooLarge *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedTooLarge(rebalancingEngineScannerBlocksSkippedTooLarge)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedTooLarge adds the rebalancingEngineScannerBlocksSkippedTooLarge to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedTooLarge(rebalancingEngineScannerBlocksSkippedTooLarge *int64) {
	o.RebalancingEngineScannerBlocksSkippedTooLarge = rebalancingEngineScannerBlocksSkippedTooLarge
}

// WithRebalancingEngineScannerBlocksSkippedTooSmall adds the rebalancingEngineScannerBlocksSkippedTooSmall to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedTooSmall(rebalancingEngineScannerBlocksSkippedTooSmall *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedTooSmall(rebalancingEngineScannerBlocksSkippedTooSmall)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedTooSmall adds the rebalancingEngineScannerBlocksSkippedTooSmall to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedTooSmall(rebalancingEngineScannerBlocksSkippedTooSmall *int64) {
	o.RebalancingEngineScannerBlocksSkippedTooSmall = rebalancingEngineScannerBlocksSkippedTooSmall
}

// WithRebalancingEngineScannerBlocksSkippedWriteFenced adds the rebalancingEngineScannerBlocksSkippedWriteFenced to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerBlocksSkippedWriteFenced(rebalancingEngineScannerBlocksSkippedWriteFenced *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerBlocksSkippedWriteFenced(rebalancingEngineScannerBlocksSkippedWriteFenced)
	return o
}

// SetRebalancingEngineScannerBlocksSkippedWriteFenced adds the rebalancingEngineScannerBlocksSkippedWriteFenced to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerBlocksSkippedWriteFenced(rebalancingEngineScannerBlocksSkippedWriteFenced *int64) {
	o.RebalancingEngineScannerBlocksSkippedWriteFenced = rebalancingEngineScannerBlocksSkippedWriteFenced
}

// WithRebalancingEngineScannerFilesScanned adds the rebalancingEngineScannerFilesScanned to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesScanned(rebalancingEngineScannerFilesScanned *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesScanned(rebalancingEngineScannerFilesScanned)
	return o
}

// SetRebalancingEngineScannerFilesScanned adds the rebalancingEngineScannerFilesScanned to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesScanned(rebalancingEngineScannerFilesScanned *int64) {
	o.RebalancingEngineScannerFilesScanned = rebalancingEngineScannerFilesScanned
}

// WithRebalancingEngineScannerFilesSkippedEfficiencyBlocks adds the rebalancingEngineScannerFilesSkippedEfficiencyBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedEfficiencyBlocks(rebalancingEngineScannerFilesSkippedEfficiencyBlocks *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedEfficiencyBlocks(rebalancingEngineScannerFilesSkippedEfficiencyBlocks)
	return o
}

// SetRebalancingEngineScannerFilesSkippedEfficiencyBlocks adds the rebalancingEngineScannerFilesSkippedEfficiencyBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedEfficiencyBlocks(rebalancingEngineScannerFilesSkippedEfficiencyBlocks *int64) {
	o.RebalancingEngineScannerFilesSkippedEfficiencyBlocks = rebalancingEngineScannerFilesSkippedEfficiencyBlocks
}

// WithRebalancingEngineScannerFilesSkippedEfficiencyPercent adds the rebalancingEngineScannerFilesSkippedEfficiencyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedEfficiencyPercent(rebalancingEngineScannerFilesSkippedEfficiencyPercent *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedEfficiencyPercent(rebalancingEngineScannerFilesSkippedEfficiencyPercent)
	return o
}

// SetRebalancingEngineScannerFilesSkippedEfficiencyPercent adds the rebalancingEngineScannerFilesSkippedEfficiencyPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedEfficiencyPercent(rebalancingEngineScannerFilesSkippedEfficiencyPercent *int64) {
	o.RebalancingEngineScannerFilesSkippedEfficiencyPercent = rebalancingEngineScannerFilesSkippedEfficiencyPercent
}

// WithRebalancingEngineScannerFilesSkippedFastTruncate adds the rebalancingEngineScannerFilesSkippedFastTruncate to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedFastTruncate(rebalancingEngineScannerFilesSkippedFastTruncate *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedFastTruncate(rebalancingEngineScannerFilesSkippedFastTruncate)
	return o
}

// SetRebalancingEngineScannerFilesSkippedFastTruncate adds the rebalancingEngineScannerFilesSkippedFastTruncate to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedFastTruncate(rebalancingEngineScannerFilesSkippedFastTruncate *int64) {
	o.RebalancingEngineScannerFilesSkippedFastTruncate = rebalancingEngineScannerFilesSkippedFastTruncate
}

// WithRebalancingEngineScannerFilesSkippedFootprintInvalid adds the rebalancingEngineScannerFilesSkippedFootprintInvalid to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedFootprintInvalid(rebalancingEngineScannerFilesSkippedFootprintInvalid *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedFootprintInvalid(rebalancingEngineScannerFilesSkippedFootprintInvalid)
	return o
}

// SetRebalancingEngineScannerFilesSkippedFootprintInvalid adds the rebalancingEngineScannerFilesSkippedFootprintInvalid to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedFootprintInvalid(rebalancingEngineScannerFilesSkippedFootprintInvalid *int64) {
	o.RebalancingEngineScannerFilesSkippedFootprintInvalid = rebalancingEngineScannerFilesSkippedFootprintInvalid
}

// WithRebalancingEngineScannerFilesSkippedInSnapshot adds the rebalancingEngineScannerFilesSkippedInSnapshot to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedInSnapshot(rebalancingEngineScannerFilesSkippedInSnapshot *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedInSnapshot(rebalancingEngineScannerFilesSkippedInSnapshot)
	return o
}

// SetRebalancingEngineScannerFilesSkippedInSnapshot adds the rebalancingEngineScannerFilesSkippedInSnapshot to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedInSnapshot(rebalancingEngineScannerFilesSkippedInSnapshot *int64) {
	o.RebalancingEngineScannerFilesSkippedInSnapshot = rebalancingEngineScannerFilesSkippedInSnapshot
}

// WithRebalancingEngineScannerFilesSkippedIncompatible adds the rebalancingEngineScannerFilesSkippedIncompatible to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedIncompatible(rebalancingEngineScannerFilesSkippedIncompatible *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedIncompatible(rebalancingEngineScannerFilesSkippedIncompatible)
	return o
}

// SetRebalancingEngineScannerFilesSkippedIncompatible adds the rebalancingEngineScannerFilesSkippedIncompatible to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedIncompatible(rebalancingEngineScannerFilesSkippedIncompatible *int64) {
	o.RebalancingEngineScannerFilesSkippedIncompatible = rebalancingEngineScannerFilesSkippedIncompatible
}

// WithRebalancingEngineScannerFilesSkippedMetadata adds the rebalancingEngineScannerFilesSkippedMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedMetadata(rebalancingEngineScannerFilesSkippedMetadata *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedMetadata(rebalancingEngineScannerFilesSkippedMetadata)
	return o
}

// SetRebalancingEngineScannerFilesSkippedMetadata adds the rebalancingEngineScannerFilesSkippedMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedMetadata(rebalancingEngineScannerFilesSkippedMetadata *int64) {
	o.RebalancingEngineScannerFilesSkippedMetadata = rebalancingEngineScannerFilesSkippedMetadata
}

// WithRebalancingEngineScannerFilesSkippedOnDemandDestination adds the rebalancingEngineScannerFilesSkippedOnDemandDestination to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedOnDemandDestination(rebalancingEngineScannerFilesSkippedOnDemandDestination *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedOnDemandDestination(rebalancingEngineScannerFilesSkippedOnDemandDestination)
	return o
}

// SetRebalancingEngineScannerFilesSkippedOnDemandDestination adds the rebalancingEngineScannerFilesSkippedOnDemandDestination to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedOnDemandDestination(rebalancingEngineScannerFilesSkippedOnDemandDestination *int64) {
	o.RebalancingEngineScannerFilesSkippedOnDemandDestination = rebalancingEngineScannerFilesSkippedOnDemandDestination
}

// WithRebalancingEngineScannerFilesSkippedOther adds the rebalancingEngineScannerFilesSkippedOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedOther(rebalancingEngineScannerFilesSkippedOther *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedOther(rebalancingEngineScannerFilesSkippedOther)
	return o
}

// SetRebalancingEngineScannerFilesSkippedOther adds the rebalancingEngineScannerFilesSkippedOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedOther(rebalancingEngineScannerFilesSkippedOther *int64) {
	o.RebalancingEngineScannerFilesSkippedOther = rebalancingEngineScannerFilesSkippedOther
}

// WithRebalancingEngineScannerFilesSkippedRemoteCache adds the rebalancingEngineScannerFilesSkippedRemoteCache to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedRemoteCache(rebalancingEngineScannerFilesSkippedRemoteCache *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedRemoteCache(rebalancingEngineScannerFilesSkippedRemoteCache)
	return o
}

// SetRebalancingEngineScannerFilesSkippedRemoteCache adds the rebalancingEngineScannerFilesSkippedRemoteCache to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedRemoteCache(rebalancingEngineScannerFilesSkippedRemoteCache *int64) {
	o.RebalancingEngineScannerFilesSkippedRemoteCache = rebalancingEngineScannerFilesSkippedRemoteCache
}

// WithRebalancingEngineScannerFilesSkippedTooLarge adds the rebalancingEngineScannerFilesSkippedTooLarge to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedTooLarge(rebalancingEngineScannerFilesSkippedTooLarge *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedTooLarge(rebalancingEngineScannerFilesSkippedTooLarge)
	return o
}

// SetRebalancingEngineScannerFilesSkippedTooLarge adds the rebalancingEngineScannerFilesSkippedTooLarge to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedTooLarge(rebalancingEngineScannerFilesSkippedTooLarge *int64) {
	o.RebalancingEngineScannerFilesSkippedTooLarge = rebalancingEngineScannerFilesSkippedTooLarge
}

// WithRebalancingEngineScannerFilesSkippedTooSmall adds the rebalancingEngineScannerFilesSkippedTooSmall to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedTooSmall(rebalancingEngineScannerFilesSkippedTooSmall *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedTooSmall(rebalancingEngineScannerFilesSkippedTooSmall)
	return o
}

// SetRebalancingEngineScannerFilesSkippedTooSmall adds the rebalancingEngineScannerFilesSkippedTooSmall to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedTooSmall(rebalancingEngineScannerFilesSkippedTooSmall *int64) {
	o.RebalancingEngineScannerFilesSkippedTooSmall = rebalancingEngineScannerFilesSkippedTooSmall
}

// WithRebalancingEngineScannerFilesSkippedWriteFenced adds the rebalancingEngineScannerFilesSkippedWriteFenced to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingEngineScannerFilesSkippedWriteFenced(rebalancingEngineScannerFilesSkippedWriteFenced *int64) *VolumeCollectionGetParams {
	o.SetRebalancingEngineScannerFilesSkippedWriteFenced(rebalancingEngineScannerFilesSkippedWriteFenced)
	return o
}

// SetRebalancingEngineScannerFilesSkippedWriteFenced adds the rebalancingEngineScannerFilesSkippedWriteFenced to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingEngineScannerFilesSkippedWriteFenced(rebalancingEngineScannerFilesSkippedWriteFenced *int64) {
	o.RebalancingEngineScannerFilesSkippedWriteFenced = rebalancingEngineScannerFilesSkippedWriteFenced
}

// WithRebalancingExcludeSnapshots adds the rebalancingExcludeSnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingExcludeSnapshots(rebalancingExcludeSnapshots *bool) *VolumeCollectionGetParams {
	o.SetRebalancingExcludeSnapshots(rebalancingExcludeSnapshots)
	return o
}

// SetRebalancingExcludeSnapshots adds the rebalancingExcludeSnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingExcludeSnapshots(rebalancingExcludeSnapshots *bool) {
	o.RebalancingExcludeSnapshots = rebalancingExcludeSnapshots
}

// WithRebalancingImbalancePercent adds the rebalancingImbalancePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingImbalancePercent(rebalancingImbalancePercent *int64) *VolumeCollectionGetParams {
	o.SetRebalancingImbalancePercent(rebalancingImbalancePercent)
	return o
}

// SetRebalancingImbalancePercent adds the rebalancingImbalancePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingImbalancePercent(rebalancingImbalancePercent *int64) {
	o.RebalancingImbalancePercent = rebalancingImbalancePercent
}

// WithRebalancingImbalanceSize adds the rebalancingImbalanceSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingImbalanceSize(rebalancingImbalanceSize *int64) *VolumeCollectionGetParams {
	o.SetRebalancingImbalanceSize(rebalancingImbalanceSize)
	return o
}

// SetRebalancingImbalanceSize adds the rebalancingImbalanceSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingImbalanceSize(rebalancingImbalanceSize *int64) {
	o.RebalancingImbalanceSize = rebalancingImbalanceSize
}

// WithRebalancingMaxConstituentImbalancePercent adds the rebalancingMaxConstituentImbalancePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMaxConstituentImbalancePercent(rebalancingMaxConstituentImbalancePercent *int64) *VolumeCollectionGetParams {
	o.SetRebalancingMaxConstituentImbalancePercent(rebalancingMaxConstituentImbalancePercent)
	return o
}

// SetRebalancingMaxConstituentImbalancePercent adds the rebalancingMaxConstituentImbalancePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMaxConstituentImbalancePercent(rebalancingMaxConstituentImbalancePercent *int64) {
	o.RebalancingMaxConstituentImbalancePercent = rebalancingMaxConstituentImbalancePercent
}

// WithRebalancingMaxFileMoves adds the rebalancingMaxFileMoves to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMaxFileMoves(rebalancingMaxFileMoves *int64) *VolumeCollectionGetParams {
	o.SetRebalancingMaxFileMoves(rebalancingMaxFileMoves)
	return o
}

// SetRebalancingMaxFileMoves adds the rebalancingMaxFileMoves to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMaxFileMoves(rebalancingMaxFileMoves *int64) {
	o.RebalancingMaxFileMoves = rebalancingMaxFileMoves
}

// WithRebalancingMaxRuntime adds the rebalancingMaxRuntime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMaxRuntime(rebalancingMaxRuntime *string) *VolumeCollectionGetParams {
	o.SetRebalancingMaxRuntime(rebalancingMaxRuntime)
	return o
}

// SetRebalancingMaxRuntime adds the rebalancingMaxRuntime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMaxRuntime(rebalancingMaxRuntime *string) {
	o.RebalancingMaxRuntime = rebalancingMaxRuntime
}

// WithRebalancingMaxThreshold adds the rebalancingMaxThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMaxThreshold(rebalancingMaxThreshold *int64) *VolumeCollectionGetParams {
	o.SetRebalancingMaxThreshold(rebalancingMaxThreshold)
	return o
}

// SetRebalancingMaxThreshold adds the rebalancingMaxThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMaxThreshold(rebalancingMaxThreshold *int64) {
	o.RebalancingMaxThreshold = rebalancingMaxThreshold
}

// WithRebalancingMinFileSize adds the rebalancingMinFileSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMinFileSize(rebalancingMinFileSize *int64) *VolumeCollectionGetParams {
	o.SetRebalancingMinFileSize(rebalancingMinFileSize)
	return o
}

// SetRebalancingMinFileSize adds the rebalancingMinFileSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMinFileSize(rebalancingMinFileSize *int64) {
	o.RebalancingMinFileSize = rebalancingMinFileSize
}

// WithRebalancingMinThreshold adds the rebalancingMinThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingMinThreshold(rebalancingMinThreshold *int64) *VolumeCollectionGetParams {
	o.SetRebalancingMinThreshold(rebalancingMinThreshold)
	return o
}

// SetRebalancingMinThreshold adds the rebalancingMinThreshold to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingMinThreshold(rebalancingMinThreshold *int64) {
	o.RebalancingMinThreshold = rebalancingMinThreshold
}

// WithRebalancingNoticesArgumentsCode adds the rebalancingNoticesArgumentsCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingNoticesArgumentsCode(rebalancingNoticesArgumentsCode *string) *VolumeCollectionGetParams {
	o.SetRebalancingNoticesArgumentsCode(rebalancingNoticesArgumentsCode)
	return o
}

// SetRebalancingNoticesArgumentsCode adds the rebalancingNoticesArgumentsCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingNoticesArgumentsCode(rebalancingNoticesArgumentsCode *string) {
	o.RebalancingNoticesArgumentsCode = rebalancingNoticesArgumentsCode
}

// WithRebalancingNoticesArgumentsMessage adds the rebalancingNoticesArgumentsMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingNoticesArgumentsMessage(rebalancingNoticesArgumentsMessage *string) *VolumeCollectionGetParams {
	o.SetRebalancingNoticesArgumentsMessage(rebalancingNoticesArgumentsMessage)
	return o
}

// SetRebalancingNoticesArgumentsMessage adds the rebalancingNoticesArgumentsMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingNoticesArgumentsMessage(rebalancingNoticesArgumentsMessage *string) {
	o.RebalancingNoticesArgumentsMessage = rebalancingNoticesArgumentsMessage
}

// WithRebalancingNoticesCode adds the rebalancingNoticesCode to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingNoticesCode(rebalancingNoticesCode *string) *VolumeCollectionGetParams {
	o.SetRebalancingNoticesCode(rebalancingNoticesCode)
	return o
}

// SetRebalancingNoticesCode adds the rebalancingNoticesCode to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingNoticesCode(rebalancingNoticesCode *string) {
	o.RebalancingNoticesCode = rebalancingNoticesCode
}

// WithRebalancingNoticesMessage adds the rebalancingNoticesMessage to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingNoticesMessage(rebalancingNoticesMessage *string) *VolumeCollectionGetParams {
	o.SetRebalancingNoticesMessage(rebalancingNoticesMessage)
	return o
}

// SetRebalancingNoticesMessage adds the rebalancingNoticesMessage to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingNoticesMessage(rebalancingNoticesMessage *string) {
	o.RebalancingNoticesMessage = rebalancingNoticesMessage
}

// WithRebalancingRuntime adds the rebalancingRuntime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingRuntime(rebalancingRuntime *string) *VolumeCollectionGetParams {
	o.SetRebalancingRuntime(rebalancingRuntime)
	return o
}

// SetRebalancingRuntime adds the rebalancingRuntime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingRuntime(rebalancingRuntime *string) {
	o.RebalancingRuntime = rebalancingRuntime
}

// WithRebalancingStartTime adds the rebalancingStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingStartTime(rebalancingStartTime *string) *VolumeCollectionGetParams {
	o.SetRebalancingStartTime(rebalancingStartTime)
	return o
}

// SetRebalancingStartTime adds the rebalancingStartTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingStartTime(rebalancingStartTime *string) {
	o.RebalancingStartTime = rebalancingStartTime
}

// WithRebalancingState adds the rebalancingState to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingState(rebalancingState *string) *VolumeCollectionGetParams {
	o.SetRebalancingState(rebalancingState)
	return o
}

// SetRebalancingState adds the rebalancingState to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingState(rebalancingState *string) {
	o.RebalancingState = rebalancingState
}

// WithRebalancingStopTime adds the rebalancingStopTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingStopTime(rebalancingStopTime *string) *VolumeCollectionGetParams {
	o.SetRebalancingStopTime(rebalancingStopTime)
	return o
}

// SetRebalancingStopTime adds the rebalancingStopTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingStopTime(rebalancingStopTime *string) {
	o.RebalancingStopTime = rebalancingStopTime
}

// WithRebalancingTargetUsed adds the rebalancingTargetUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingTargetUsed(rebalancingTargetUsed *int64) *VolumeCollectionGetParams {
	o.SetRebalancingTargetUsed(rebalancingTargetUsed)
	return o
}

// SetRebalancingTargetUsed adds the rebalancingTargetUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingTargetUsed(rebalancingTargetUsed *int64) {
	o.RebalancingTargetUsed = rebalancingTargetUsed
}

// WithRebalancingUsedForImbalance adds the rebalancingUsedForImbalance to the volume collection get params
func (o *VolumeCollectionGetParams) WithRebalancingUsedForImbalance(rebalancingUsedForImbalance *int64) *VolumeCollectionGetParams {
	o.SetRebalancingUsedForImbalance(rebalancingUsedForImbalance)
	return o
}

// SetRebalancingUsedForImbalance adds the rebalancingUsedForImbalance to the volume collection get params
func (o *VolumeCollectionGetParams) SetRebalancingUsedForImbalance(rebalancingUsedForImbalance *int64) {
	o.RebalancingUsedForImbalance = rebalancingUsedForImbalance
}

// WithReturnRecords adds the returnRecords to the volume collection get params
func (o *VolumeCollectionGetParams) WithReturnRecords(returnRecords *bool) *VolumeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the volume collection get params
func (o *VolumeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the volume collection get params
func (o *VolumeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *VolumeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the volume collection get params
func (o *VolumeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScheduledSnapshotNamingScheme adds the scheduledSnapshotNamingScheme to the volume collection get params
func (o *VolumeCollectionGetParams) WithScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme *string) *VolumeCollectionGetParams {
	o.SetScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme)
	return o
}

// SetScheduledSnapshotNamingScheme adds the scheduledSnapshotNamingScheme to the volume collection get params
func (o *VolumeCollectionGetParams) SetScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme *string) {
	o.ScheduledSnapshotNamingScheme = scheduledSnapshotNamingScheme
}

// WithSize adds the size to the volume collection get params
func (o *VolumeCollectionGetParams) WithSize(size *int64) *VolumeCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the volume collection get params
func (o *VolumeCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithSnaplockAppendModeEnabled adds the snaplockAppendModeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockAppendModeEnabled(snaplockAppendModeEnabled *bool) *VolumeCollectionGetParams {
	o.SetSnaplockAppendModeEnabled(snaplockAppendModeEnabled)
	return o
}

// SetSnaplockAppendModeEnabled adds the snaplockAppendModeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockAppendModeEnabled(snaplockAppendModeEnabled *bool) {
	o.SnaplockAppendModeEnabled = snaplockAppendModeEnabled
}

// WithSnaplockAutocommitPeriod adds the snaplockAutocommitPeriod to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockAutocommitPeriod(snaplockAutocommitPeriod *string) *VolumeCollectionGetParams {
	o.SetSnaplockAutocommitPeriod(snaplockAutocommitPeriod)
	return o
}

// SetSnaplockAutocommitPeriod adds the snaplockAutocommitPeriod to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockAutocommitPeriod(snaplockAutocommitPeriod *string) {
	o.SnaplockAutocommitPeriod = snaplockAutocommitPeriod
}

// WithSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockComplianceClockTime(snaplockComplianceClockTime *string) *VolumeCollectionGetParams {
	o.SetSnaplockComplianceClockTime(snaplockComplianceClockTime)
	return o
}

// SetSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockComplianceClockTime(snaplockComplianceClockTime *string) {
	o.SnaplockComplianceClockTime = snaplockComplianceClockTime
}

// WithSnaplockExpiryTime adds the snaplockExpiryTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockExpiryTime(snaplockExpiryTime *string) *VolumeCollectionGetParams {
	o.SetSnaplockExpiryTime(snaplockExpiryTime)
	return o
}

// SetSnaplockExpiryTime adds the snaplockExpiryTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockExpiryTime(snaplockExpiryTime *string) {
	o.SnaplockExpiryTime = snaplockExpiryTime
}

// WithSnaplockIsAuditLog adds the snaplockIsAuditLog to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockIsAuditLog(snaplockIsAuditLog *bool) *VolumeCollectionGetParams {
	o.SetSnaplockIsAuditLog(snaplockIsAuditLog)
	return o
}

// SetSnaplockIsAuditLog adds the snaplockIsAuditLog to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockIsAuditLog(snaplockIsAuditLog *bool) {
	o.SnaplockIsAuditLog = snaplockIsAuditLog
}

// WithSnaplockLitigationCount adds the snaplockLitigationCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockLitigationCount(snaplockLitigationCount *int64) *VolumeCollectionGetParams {
	o.SetSnaplockLitigationCount(snaplockLitigationCount)
	return o
}

// SetSnaplockLitigationCount adds the snaplockLitigationCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockLitigationCount(snaplockLitigationCount *int64) {
	o.SnaplockLitigationCount = snaplockLitigationCount
}

// WithSnaplockPrivilegedDelete adds the snaplockPrivilegedDelete to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockPrivilegedDelete(snaplockPrivilegedDelete *string) *VolumeCollectionGetParams {
	o.SetSnaplockPrivilegedDelete(snaplockPrivilegedDelete)
	return o
}

// SetSnaplockPrivilegedDelete adds the snaplockPrivilegedDelete to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockPrivilegedDelete(snaplockPrivilegedDelete *string) {
	o.SnaplockPrivilegedDelete = snaplockPrivilegedDelete
}

// WithSnaplockRetentionDefault adds the snaplockRetentionDefault to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockRetentionDefault(snaplockRetentionDefault *string) *VolumeCollectionGetParams {
	o.SetSnaplockRetentionDefault(snaplockRetentionDefault)
	return o
}

// SetSnaplockRetentionDefault adds the snaplockRetentionDefault to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockRetentionDefault(snaplockRetentionDefault *string) {
	o.SnaplockRetentionDefault = snaplockRetentionDefault
}

// WithSnaplockRetentionMaximum adds the snaplockRetentionMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockRetentionMaximum(snaplockRetentionMaximum *string) *VolumeCollectionGetParams {
	o.SetSnaplockRetentionMaximum(snaplockRetentionMaximum)
	return o
}

// SetSnaplockRetentionMaximum adds the snaplockRetentionMaximum to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockRetentionMaximum(snaplockRetentionMaximum *string) {
	o.SnaplockRetentionMaximum = snaplockRetentionMaximum
}

// WithSnaplockRetentionMinimum adds the snaplockRetentionMinimum to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockRetentionMinimum(snaplockRetentionMinimum *string) *VolumeCollectionGetParams {
	o.SetSnaplockRetentionMinimum(snaplockRetentionMinimum)
	return o
}

// SetSnaplockRetentionMinimum adds the snaplockRetentionMinimum to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockRetentionMinimum(snaplockRetentionMinimum *string) {
	o.SnaplockRetentionMinimum = snaplockRetentionMinimum
}

// WithSnaplockType adds the snaplockType to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockType(snaplockType *string) *VolumeCollectionGetParams {
	o.SetSnaplockType(snaplockType)
	return o
}

// SetSnaplockType adds the snaplockType to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockType(snaplockType *string) {
	o.SnaplockType = snaplockType
}

// WithSnaplockUnspecifiedRetentionFileCount adds the snaplockUnspecifiedRetentionFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnaplockUnspecifiedRetentionFileCount(snaplockUnspecifiedRetentionFileCount *int64) *VolumeCollectionGetParams {
	o.SetSnaplockUnspecifiedRetentionFileCount(snaplockUnspecifiedRetentionFileCount)
	return o
}

// SetSnaplockUnspecifiedRetentionFileCount adds the snaplockUnspecifiedRetentionFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnaplockUnspecifiedRetentionFileCount(snaplockUnspecifiedRetentionFileCount *int64) {
	o.SnaplockUnspecifiedRetentionFileCount = snaplockUnspecifiedRetentionFileCount
}

// WithSnapmirrorDestinationsIsCloud adds the snapmirrorDestinationsIsCloud to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapmirrorDestinationsIsCloud(snapmirrorDestinationsIsCloud *bool) *VolumeCollectionGetParams {
	o.SetSnapmirrorDestinationsIsCloud(snapmirrorDestinationsIsCloud)
	return o
}

// SetSnapmirrorDestinationsIsCloud adds the snapmirrorDestinationsIsCloud to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapmirrorDestinationsIsCloud(snapmirrorDestinationsIsCloud *bool) {
	o.SnapmirrorDestinationsIsCloud = snapmirrorDestinationsIsCloud
}

// WithSnapmirrorDestinationsIsOntap adds the snapmirrorDestinationsIsOntap to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapmirrorDestinationsIsOntap(snapmirrorDestinationsIsOntap *bool) *VolumeCollectionGetParams {
	o.SetSnapmirrorDestinationsIsOntap(snapmirrorDestinationsIsOntap)
	return o
}

// SetSnapmirrorDestinationsIsOntap adds the snapmirrorDestinationsIsOntap to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapmirrorDestinationsIsOntap(snapmirrorDestinationsIsOntap *bool) {
	o.SnapmirrorDestinationsIsOntap = snapmirrorDestinationsIsOntap
}

// WithSnapmirrorIsProtected adds the snapmirrorIsProtected to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapmirrorIsProtected(snapmirrorIsProtected *bool) *VolumeCollectionGetParams {
	o.SetSnapmirrorIsProtected(snapmirrorIsProtected)
	return o
}

// SetSnapmirrorIsProtected adds the snapmirrorIsProtected to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapmirrorIsProtected(snapmirrorIsProtected *bool) {
	o.SnapmirrorIsProtected = snapmirrorIsProtected
}

// WithSnapshotCount adds the snapshotCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapshotCount(snapshotCount *int64) *VolumeCollectionGetParams {
	o.SetSnapshotCount(snapshotCount)
	return o
}

// SetSnapshotCount adds the snapshotCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapshotCount(snapshotCount *int64) {
	o.SnapshotCount = snapshotCount
}

// WithSnapshotDirectoryAccessEnabled adds the snapshotDirectoryAccessEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled *bool) *VolumeCollectionGetParams {
	o.SetSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled)
	return o
}

// SetSnapshotDirectoryAccessEnabled adds the snapshotDirectoryAccessEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled *bool) {
	o.SnapshotDirectoryAccessEnabled = snapshotDirectoryAccessEnabled
}

// WithSnapshotLockingEnabled adds the snapshotLockingEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapshotLockingEnabled(snapshotLockingEnabled *bool) *VolumeCollectionGetParams {
	o.SetSnapshotLockingEnabled(snapshotLockingEnabled)
	return o
}

// SetSnapshotLockingEnabled adds the snapshotLockingEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapshotLockingEnabled(snapshotLockingEnabled *bool) {
	o.SnapshotLockingEnabled = snapshotLockingEnabled
}

// WithSnapshotPolicyName adds the snapshotPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapshotPolicyName(snapshotPolicyName *string) *VolumeCollectionGetParams {
	o.SetSnapshotPolicyName(snapshotPolicyName)
	return o
}

// SetSnapshotPolicyName adds the snapshotPolicyName to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapshotPolicyName(snapshotPolicyName *string) {
	o.SnapshotPolicyName = snapshotPolicyName
}

// WithSnapshotPolicyUUID adds the snapshotPolicyUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithSnapshotPolicyUUID(snapshotPolicyUUID *string) *VolumeCollectionGetParams {
	o.SetSnapshotPolicyUUID(snapshotPolicyUUID)
	return o
}

// SetSnapshotPolicyUUID adds the snapshotPolicyUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetSnapshotPolicyUUID(snapshotPolicyUUID *string) {
	o.SnapshotPolicyUUID = snapshotPolicyUUID
}

// WithSpaceAfsTotal adds the spaceAfsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceAfsTotal(spaceAfsTotal *int64) *VolumeCollectionGetParams {
	o.SetSpaceAfsTotal(spaceAfsTotal)
	return o
}

// SetSpaceAfsTotal adds the spaceAfsTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceAfsTotal(spaceAfsTotal *int64) {
	o.SpaceAfsTotal = spaceAfsTotal
}

// WithSpaceAutoAdaptiveCompressionFootprintDataReduction adds the spaceAutoAdaptiveCompressionFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceAutoAdaptiveCompressionFootprintDataReduction(spaceAutoAdaptiveCompressionFootprintDataReduction *int64) *VolumeCollectionGetParams {
	o.SetSpaceAutoAdaptiveCompressionFootprintDataReduction(spaceAutoAdaptiveCompressionFootprintDataReduction)
	return o
}

// SetSpaceAutoAdaptiveCompressionFootprintDataReduction adds the spaceAutoAdaptiveCompressionFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceAutoAdaptiveCompressionFootprintDataReduction(spaceAutoAdaptiveCompressionFootprintDataReduction *int64) {
	o.SpaceAutoAdaptiveCompressionFootprintDataReduction = spaceAutoAdaptiveCompressionFootprintDataReduction
}

// WithSpaceAvailable adds the spaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceAvailable(spaceAvailable *int64) *VolumeCollectionGetParams {
	o.SetSpaceAvailable(spaceAvailable)
	return o
}

// SetSpaceAvailable adds the spaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceAvailable(spaceAvailable *int64) {
	o.SpaceAvailable = spaceAvailable
}

// WithSpaceAvailablePercent adds the spaceAvailablePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceAvailablePercent(spaceAvailablePercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceAvailablePercent(spaceAvailablePercent)
	return o
}

// SetSpaceAvailablePercent adds the spaceAvailablePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceAvailablePercent(spaceAvailablePercent *int64) {
	o.SpaceAvailablePercent = spaceAvailablePercent
}

// WithSpaceBlockStorageInactiveUserData adds the spaceBlockStorageInactiveUserData to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceBlockStorageInactiveUserData(spaceBlockStorageInactiveUserData *int64) *VolumeCollectionGetParams {
	o.SetSpaceBlockStorageInactiveUserData(spaceBlockStorageInactiveUserData)
	return o
}

// SetSpaceBlockStorageInactiveUserData adds the spaceBlockStorageInactiveUserData to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceBlockStorageInactiveUserData(spaceBlockStorageInactiveUserData *int64) {
	o.SpaceBlockStorageInactiveUserData = spaceBlockStorageInactiveUserData
}

// WithSpaceBlockStorageInactiveUserDataPercent adds the spaceBlockStorageInactiveUserDataPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceBlockStorageInactiveUserDataPercent(spaceBlockStorageInactiveUserDataPercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceBlockStorageInactiveUserDataPercent(spaceBlockStorageInactiveUserDataPercent)
	return o
}

// SetSpaceBlockStorageInactiveUserDataPercent adds the spaceBlockStorageInactiveUserDataPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceBlockStorageInactiveUserDataPercent(spaceBlockStorageInactiveUserDataPercent *int64) {
	o.SpaceBlockStorageInactiveUserDataPercent = spaceBlockStorageInactiveUserDataPercent
}

// WithSpaceCapacityTierFootprint adds the spaceCapacityTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceCapacityTierFootprint(spaceCapacityTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceCapacityTierFootprint(spaceCapacityTierFootprint)
	return o
}

// SetSpaceCapacityTierFootprint adds the spaceCapacityTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceCapacityTierFootprint(spaceCapacityTierFootprint *int64) {
	o.SpaceCapacityTierFootprint = spaceCapacityTierFootprint
}

// WithSpaceCapacityTierFootprintDataReduction adds the spaceCapacityTierFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceCapacityTierFootprintDataReduction(spaceCapacityTierFootprintDataReduction *int64) *VolumeCollectionGetParams {
	o.SetSpaceCapacityTierFootprintDataReduction(spaceCapacityTierFootprintDataReduction)
	return o
}

// SetSpaceCapacityTierFootprintDataReduction adds the spaceCapacityTierFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceCapacityTierFootprintDataReduction(spaceCapacityTierFootprintDataReduction *int64) {
	o.SpaceCapacityTierFootprintDataReduction = spaceCapacityTierFootprintDataReduction
}

// WithSpaceCompactionFootprintDataReduction adds the spaceCompactionFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceCompactionFootprintDataReduction(spaceCompactionFootprintDataReduction *int64) *VolumeCollectionGetParams {
	o.SetSpaceCompactionFootprintDataReduction(spaceCompactionFootprintDataReduction)
	return o
}

// SetSpaceCompactionFootprintDataReduction adds the spaceCompactionFootprintDataReduction to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceCompactionFootprintDataReduction(spaceCompactionFootprintDataReduction *int64) {
	o.SpaceCompactionFootprintDataReduction = spaceCompactionFootprintDataReduction
}

// WithSpaceCrossVolumeDedupeMetafilesFootprint adds the spaceCrossVolumeDedupeMetafilesFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceCrossVolumeDedupeMetafilesFootprint(spaceCrossVolumeDedupeMetafilesFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceCrossVolumeDedupeMetafilesFootprint(spaceCrossVolumeDedupeMetafilesFootprint)
	return o
}

// SetSpaceCrossVolumeDedupeMetafilesFootprint adds the spaceCrossVolumeDedupeMetafilesFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceCrossVolumeDedupeMetafilesFootprint(spaceCrossVolumeDedupeMetafilesFootprint *int64) {
	o.SpaceCrossVolumeDedupeMetafilesFootprint = spaceCrossVolumeDedupeMetafilesFootprint
}

// WithSpaceCrossVolumeDedupeMetafilesTemporaryFootprint adds the spaceCrossVolumeDedupeMetafilesTemporaryFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceCrossVolumeDedupeMetafilesTemporaryFootprint(spaceCrossVolumeDedupeMetafilesTemporaryFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceCrossVolumeDedupeMetafilesTemporaryFootprint(spaceCrossVolumeDedupeMetafilesTemporaryFootprint)
	return o
}

// SetSpaceCrossVolumeDedupeMetafilesTemporaryFootprint adds the spaceCrossVolumeDedupeMetafilesTemporaryFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceCrossVolumeDedupeMetafilesTemporaryFootprint(spaceCrossVolumeDedupeMetafilesTemporaryFootprint *int64) {
	o.SpaceCrossVolumeDedupeMetafilesTemporaryFootprint = spaceCrossVolumeDedupeMetafilesTemporaryFootprint
}

// WithSpaceDedupeMetafilesFootprint adds the spaceDedupeMetafilesFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceDedupeMetafilesFootprint(spaceDedupeMetafilesFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceDedupeMetafilesFootprint(spaceDedupeMetafilesFootprint)
	return o
}

// SetSpaceDedupeMetafilesFootprint adds the spaceDedupeMetafilesFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceDedupeMetafilesFootprint(spaceDedupeMetafilesFootprint *int64) {
	o.SpaceDedupeMetafilesFootprint = spaceDedupeMetafilesFootprint
}

// WithSpaceDedupeMetafilesTemporaryFootprint adds the spaceDedupeMetafilesTemporaryFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceDedupeMetafilesTemporaryFootprint(spaceDedupeMetafilesTemporaryFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceDedupeMetafilesTemporaryFootprint(spaceDedupeMetafilesTemporaryFootprint)
	return o
}

// SetSpaceDedupeMetafilesTemporaryFootprint adds the spaceDedupeMetafilesTemporaryFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceDedupeMetafilesTemporaryFootprint(spaceDedupeMetafilesTemporaryFootprint *int64) {
	o.SpaceDedupeMetafilesTemporaryFootprint = spaceDedupeMetafilesTemporaryFootprint
}

// WithSpaceDelayedFreeFootprint adds the spaceDelayedFreeFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceDelayedFreeFootprint(spaceDelayedFreeFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceDelayedFreeFootprint(spaceDelayedFreeFootprint)
	return o
}

// SetSpaceDelayedFreeFootprint adds the spaceDelayedFreeFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceDelayedFreeFootprint(spaceDelayedFreeFootprint *int64) {
	o.SpaceDelayedFreeFootprint = spaceDelayedFreeFootprint
}

// WithSpaceEffectiveTotalFootprint adds the spaceEffectiveTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceEffectiveTotalFootprint(spaceEffectiveTotalFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceEffectiveTotalFootprint(spaceEffectiveTotalFootprint)
	return o
}

// SetSpaceEffectiveTotalFootprint adds the spaceEffectiveTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceEffectiveTotalFootprint(spaceEffectiveTotalFootprint *int64) {
	o.SpaceEffectiveTotalFootprint = spaceEffectiveTotalFootprint
}

// WithSpaceExpectedAvailable adds the spaceExpectedAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceExpectedAvailable(spaceExpectedAvailable *int64) *VolumeCollectionGetParams {
	o.SetSpaceExpectedAvailable(spaceExpectedAvailable)
	return o
}

// SetSpaceExpectedAvailable adds the spaceExpectedAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceExpectedAvailable(spaceExpectedAvailable *int64) {
	o.SpaceExpectedAvailable = spaceExpectedAvailable
}

// WithSpaceFileOperationMetadata adds the spaceFileOperationMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFileOperationMetadata(spaceFileOperationMetadata *int64) *VolumeCollectionGetParams {
	o.SetSpaceFileOperationMetadata(spaceFileOperationMetadata)
	return o
}

// SetSpaceFileOperationMetadata adds the spaceFileOperationMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFileOperationMetadata(spaceFileOperationMetadata *int64) {
	o.SpaceFileOperationMetadata = spaceFileOperationMetadata
}

// WithSpaceFilesystemSize adds the spaceFilesystemSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFilesystemSize(spaceFilesystemSize *int64) *VolumeCollectionGetParams {
	o.SetSpaceFilesystemSize(spaceFilesystemSize)
	return o
}

// SetSpaceFilesystemSize adds the spaceFilesystemSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFilesystemSize(spaceFilesystemSize *int64) {
	o.SpaceFilesystemSize = spaceFilesystemSize
}

// WithSpaceFilesystemSizeFixed adds the spaceFilesystemSizeFixed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFilesystemSizeFixed(spaceFilesystemSizeFixed *bool) *VolumeCollectionGetParams {
	o.SetSpaceFilesystemSizeFixed(spaceFilesystemSizeFixed)
	return o
}

// SetSpaceFilesystemSizeFixed adds the spaceFilesystemSizeFixed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFilesystemSizeFixed(spaceFilesystemSizeFixed *bool) {
	o.SpaceFilesystemSizeFixed = spaceFilesystemSizeFixed
}

// WithSpaceFootprint adds the spaceFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFootprint(spaceFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceFootprint(spaceFootprint)
	return o
}

// SetSpaceFootprint adds the spaceFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFootprint(spaceFootprint *int64) {
	o.SpaceFootprint = spaceFootprint
}

// WithSpaceFractionalReserve adds the spaceFractionalReserve to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFractionalReserve(spaceFractionalReserve *int64) *VolumeCollectionGetParams {
	o.SetSpaceFractionalReserve(spaceFractionalReserve)
	return o
}

// SetSpaceFractionalReserve adds the spaceFractionalReserve to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFractionalReserve(spaceFractionalReserve *int64) {
	o.SpaceFractionalReserve = spaceFractionalReserve
}

// WithSpaceFullThresholdPercent adds the spaceFullThresholdPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceFullThresholdPercent(spaceFullThresholdPercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceFullThresholdPercent(spaceFullThresholdPercent)
	return o
}

// SetSpaceFullThresholdPercent adds the spaceFullThresholdPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceFullThresholdPercent(spaceFullThresholdPercent *int64) {
	o.SpaceFullThresholdPercent = spaceFullThresholdPercent
}

// WithSpaceIsUsedStale adds the spaceIsUsedStale to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceIsUsedStale(spaceIsUsedStale *bool) *VolumeCollectionGetParams {
	o.SetSpaceIsUsedStale(spaceIsUsedStale)
	return o
}

// SetSpaceIsUsedStale adds the spaceIsUsedStale to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceIsUsedStale(spaceIsUsedStale *bool) {
	o.SpaceIsUsedStale = spaceIsUsedStale
}

// WithSpaceLargeSizeEnabled adds the spaceLargeSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLargeSizeEnabled(spaceLargeSizeEnabled *bool) *VolumeCollectionGetParams {
	o.SetSpaceLargeSizeEnabled(spaceLargeSizeEnabled)
	return o
}

// SetSpaceLargeSizeEnabled adds the spaceLargeSizeEnabled to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLargeSizeEnabled(spaceLargeSizeEnabled *bool) {
	o.SpaceLargeSizeEnabled = spaceLargeSizeEnabled
}

// WithSpaceLocalTierFootprint adds the spaceLocalTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLocalTierFootprint(spaceLocalTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceLocalTierFootprint(spaceLocalTierFootprint)
	return o
}

// SetSpaceLocalTierFootprint adds the spaceLocalTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLocalTierFootprint(spaceLocalTierFootprint *int64) {
	o.SpaceLocalTierFootprint = spaceLocalTierFootprint
}

// WithSpaceLogicalSpaceAvailable adds the spaceLogicalSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceAvailable(spaceLogicalSpaceAvailable *int64) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceAvailable(spaceLogicalSpaceAvailable)
	return o
}

// SetSpaceLogicalSpaceAvailable adds the spaceLogicalSpaceAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceAvailable(spaceLogicalSpaceAvailable *int64) {
	o.SpaceLogicalSpaceAvailable = spaceLogicalSpaceAvailable
}

// WithSpaceLogicalSpaceEnforcement adds the spaceLogicalSpaceEnforcement to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceEnforcement(spaceLogicalSpaceEnforcement *bool) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceEnforcement(spaceLogicalSpaceEnforcement)
	return o
}

// SetSpaceLogicalSpaceEnforcement adds the spaceLogicalSpaceEnforcement to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceEnforcement(spaceLogicalSpaceEnforcement *bool) {
	o.SpaceLogicalSpaceEnforcement = spaceLogicalSpaceEnforcement
}

// WithSpaceLogicalSpaceReporting adds the spaceLogicalSpaceReporting to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceReporting(spaceLogicalSpaceReporting *bool) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceReporting(spaceLogicalSpaceReporting)
	return o
}

// SetSpaceLogicalSpaceReporting adds the spaceLogicalSpaceReporting to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceReporting(spaceLogicalSpaceReporting *bool) {
	o.SpaceLogicalSpaceReporting = spaceLogicalSpaceReporting
}

// WithSpaceLogicalSpaceUsed adds the spaceLogicalSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceUsed(spaceLogicalSpaceUsed *int64) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceUsed(spaceLogicalSpaceUsed)
	return o
}

// SetSpaceLogicalSpaceUsed adds the spaceLogicalSpaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceUsed(spaceLogicalSpaceUsed *int64) {
	o.SpaceLogicalSpaceUsed = spaceLogicalSpaceUsed
}

// WithSpaceLogicalSpaceUsedByAfs adds the spaceLogicalSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceUsedByAfs(spaceLogicalSpaceUsedByAfs *int64) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceUsedByAfs(spaceLogicalSpaceUsedByAfs)
	return o
}

// SetSpaceLogicalSpaceUsedByAfs adds the spaceLogicalSpaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceUsedByAfs(spaceLogicalSpaceUsedByAfs *int64) {
	o.SpaceLogicalSpaceUsedByAfs = spaceLogicalSpaceUsedByAfs
}

// WithSpaceLogicalSpaceUsedBySnapshots adds the spaceLogicalSpaceUsedBySnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceUsedBySnapshots(spaceLogicalSpaceUsedBySnapshots *int64) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceUsedBySnapshots(spaceLogicalSpaceUsedBySnapshots)
	return o
}

// SetSpaceLogicalSpaceUsedBySnapshots adds the spaceLogicalSpaceUsedBySnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceUsedBySnapshots(spaceLogicalSpaceUsedBySnapshots *int64) {
	o.SpaceLogicalSpaceUsedBySnapshots = spaceLogicalSpaceUsedBySnapshots
}

// WithSpaceLogicalSpaceUsedPercent adds the spaceLogicalSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceLogicalSpaceUsedPercent(spaceLogicalSpaceUsedPercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceLogicalSpaceUsedPercent(spaceLogicalSpaceUsedPercent)
	return o
}

// SetSpaceLogicalSpaceUsedPercent adds the spaceLogicalSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceLogicalSpaceUsedPercent(spaceLogicalSpaceUsedPercent *int64) {
	o.SpaceLogicalSpaceUsedPercent = spaceLogicalSpaceUsedPercent
}

// WithSpaceMaxSize adds the spaceMaxSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceMaxSize(spaceMaxSize *string) *VolumeCollectionGetParams {
	o.SetSpaceMaxSize(spaceMaxSize)
	return o
}

// SetSpaceMaxSize adds the spaceMaxSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceMaxSize(spaceMaxSize *string) {
	o.SpaceMaxSize = spaceMaxSize
}

// WithSpaceMetadata adds the spaceMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceMetadata(spaceMetadata *int64) *VolumeCollectionGetParams {
	o.SetSpaceMetadata(spaceMetadata)
	return o
}

// SetSpaceMetadata adds the spaceMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceMetadata(spaceMetadata *int64) {
	o.SpaceMetadata = spaceMetadata
}

// WithSpaceNearlyFullThresholdPercent adds the spaceNearlyFullThresholdPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceNearlyFullThresholdPercent(spaceNearlyFullThresholdPercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceNearlyFullThresholdPercent(spaceNearlyFullThresholdPercent)
	return o
}

// SetSpaceNearlyFullThresholdPercent adds the spaceNearlyFullThresholdPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceNearlyFullThresholdPercent(spaceNearlyFullThresholdPercent *int64) {
	o.SpaceNearlyFullThresholdPercent = spaceNearlyFullThresholdPercent
}

// WithSpaceOverProvisioned adds the spaceOverProvisioned to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceOverProvisioned(spaceOverProvisioned *int64) *VolumeCollectionGetParams {
	o.SetSpaceOverProvisioned(spaceOverProvisioned)
	return o
}

// SetSpaceOverProvisioned adds the spaceOverProvisioned to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceOverProvisioned(spaceOverProvisioned *int64) {
	o.SpaceOverProvisioned = spaceOverProvisioned
}

// WithSpaceOverwriteReserve adds the spaceOverwriteReserve to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceOverwriteReserve(spaceOverwriteReserve *int64) *VolumeCollectionGetParams {
	o.SetSpaceOverwriteReserve(spaceOverwriteReserve)
	return o
}

// SetSpaceOverwriteReserve adds the spaceOverwriteReserve to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceOverwriteReserve(spaceOverwriteReserve *int64) {
	o.SpaceOverwriteReserve = spaceOverwriteReserve
}

// WithSpaceOverwriteReserveUsed adds the spaceOverwriteReserveUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceOverwriteReserveUsed(spaceOverwriteReserveUsed *int64) *VolumeCollectionGetParams {
	o.SetSpaceOverwriteReserveUsed(spaceOverwriteReserveUsed)
	return o
}

// SetSpaceOverwriteReserveUsed adds the spaceOverwriteReserveUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceOverwriteReserveUsed(spaceOverwriteReserveUsed *int64) {
	o.SpaceOverwriteReserveUsed = spaceOverwriteReserveUsed
}

// WithSpacePercentUsed adds the spacePercentUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpacePercentUsed(spacePercentUsed *int64) *VolumeCollectionGetParams {
	o.SetSpacePercentUsed(spacePercentUsed)
	return o
}

// SetSpacePercentUsed adds the spacePercentUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpacePercentUsed(spacePercentUsed *int64) {
	o.SpacePercentUsed = spacePercentUsed
}

// WithSpacePerformanceTierFootprint adds the spacePerformanceTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpacePerformanceTierFootprint(spacePerformanceTierFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpacePerformanceTierFootprint(spacePerformanceTierFootprint)
	return o
}

// SetSpacePerformanceTierFootprint adds the spacePerformanceTierFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpacePerformanceTierFootprint(spacePerformanceTierFootprint *int64) {
	o.SpacePerformanceTierFootprint = spacePerformanceTierFootprint
}

// WithSpacePhysicalUsed adds the spacePhysicalUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpacePhysicalUsed(spacePhysicalUsed *int64) *VolumeCollectionGetParams {
	o.SetSpacePhysicalUsed(spacePhysicalUsed)
	return o
}

// SetSpacePhysicalUsed adds the spacePhysicalUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpacePhysicalUsed(spacePhysicalUsed *int64) {
	o.SpacePhysicalUsed = spacePhysicalUsed
}

// WithSpacePhysicalUsedPercent adds the spacePhysicalUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpacePhysicalUsedPercent(spacePhysicalUsedPercent *int64) *VolumeCollectionGetParams {
	o.SetSpacePhysicalUsedPercent(spacePhysicalUsedPercent)
	return o
}

// SetSpacePhysicalUsedPercent adds the spacePhysicalUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpacePhysicalUsedPercent(spacePhysicalUsedPercent *int64) {
	o.SpacePhysicalUsedPercent = spacePhysicalUsedPercent
}

// WithSpaceSize adds the spaceSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSize(spaceSize *int64) *VolumeCollectionGetParams {
	o.SetSpaceSize(spaceSize)
	return o
}

// SetSpaceSize adds the spaceSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSize(spaceSize *int64) {
	o.SpaceSize = spaceSize
}

// WithSpaceSizeAvailableForSnapshots adds the spaceSizeAvailableForSnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSizeAvailableForSnapshots(spaceSizeAvailableForSnapshots *int64) *VolumeCollectionGetParams {
	o.SetSpaceSizeAvailableForSnapshots(spaceSizeAvailableForSnapshots)
	return o
}

// SetSpaceSizeAvailableForSnapshots adds the spaceSizeAvailableForSnapshots to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSizeAvailableForSnapshots(spaceSizeAvailableForSnapshots *int64) {
	o.SpaceSizeAvailableForSnapshots = spaceSizeAvailableForSnapshots
}

// WithSpaceSnapmirrorDestinationFootprint adds the spaceSnapmirrorDestinationFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapmirrorDestinationFootprint(spaceSnapmirrorDestinationFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapmirrorDestinationFootprint(spaceSnapmirrorDestinationFootprint)
	return o
}

// SetSpaceSnapmirrorDestinationFootprint adds the spaceSnapmirrorDestinationFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapmirrorDestinationFootprint(spaceSnapmirrorDestinationFootprint *int64) {
	o.SpaceSnapmirrorDestinationFootprint = spaceSnapmirrorDestinationFootprint
}

// WithSpaceSnapshotAutodeleteCommitment adds the spaceSnapshotAutodeleteCommitment to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeleteCommitment(spaceSnapshotAutodeleteCommitment *string) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteCommitment(spaceSnapshotAutodeleteCommitment)
	return o
}

// SetSpaceSnapshotAutodeleteCommitment adds the spaceSnapshotAutodeleteCommitment to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeleteCommitment(spaceSnapshotAutodeleteCommitment *string) {
	o.SpaceSnapshotAutodeleteCommitment = spaceSnapshotAutodeleteCommitment
}

// WithSpaceSnapshotAutodeleteDeferDelete adds the spaceSnapshotAutodeleteDeferDelete to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeleteDeferDelete(spaceSnapshotAutodeleteDeferDelete *string) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteDeferDelete(spaceSnapshotAutodeleteDeferDelete)
	return o
}

// SetSpaceSnapshotAutodeleteDeferDelete adds the spaceSnapshotAutodeleteDeferDelete to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeleteDeferDelete(spaceSnapshotAutodeleteDeferDelete *string) {
	o.SpaceSnapshotAutodeleteDeferDelete = spaceSnapshotAutodeleteDeferDelete
}

// WithSpaceSnapshotAutodeleteDeleteOrder adds the spaceSnapshotAutodeleteDeleteOrder to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeleteDeleteOrder(spaceSnapshotAutodeleteDeleteOrder *string) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteDeleteOrder(spaceSnapshotAutodeleteDeleteOrder)
	return o
}

// SetSpaceSnapshotAutodeleteDeleteOrder adds the spaceSnapshotAutodeleteDeleteOrder to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeleteDeleteOrder(spaceSnapshotAutodeleteDeleteOrder *string) {
	o.SpaceSnapshotAutodeleteDeleteOrder = spaceSnapshotAutodeleteDeleteOrder
}

// WithSpaceSnapshotAutodeletePrefix adds the spaceSnapshotAutodeletePrefix to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeletePrefix(spaceSnapshotAutodeletePrefix *string) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeletePrefix(spaceSnapshotAutodeletePrefix)
	return o
}

// SetSpaceSnapshotAutodeletePrefix adds the spaceSnapshotAutodeletePrefix to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeletePrefix(spaceSnapshotAutodeletePrefix *string) {
	o.SpaceSnapshotAutodeletePrefix = spaceSnapshotAutodeletePrefix
}

// WithSpaceSnapshotAutodeleteTargetFreeSpace adds the spaceSnapshotAutodeleteTargetFreeSpace to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeleteTargetFreeSpace(spaceSnapshotAutodeleteTargetFreeSpace *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteTargetFreeSpace(spaceSnapshotAutodeleteTargetFreeSpace)
	return o
}

// SetSpaceSnapshotAutodeleteTargetFreeSpace adds the spaceSnapshotAutodeleteTargetFreeSpace to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeleteTargetFreeSpace(spaceSnapshotAutodeleteTargetFreeSpace *int64) {
	o.SpaceSnapshotAutodeleteTargetFreeSpace = spaceSnapshotAutodeleteTargetFreeSpace
}

// WithSpaceSnapshotAutodeleteTrigger adds the spaceSnapshotAutodeleteTrigger to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotAutodeleteTrigger(spaceSnapshotAutodeleteTrigger *string) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteTrigger(spaceSnapshotAutodeleteTrigger)
	return o
}

// SetSpaceSnapshotAutodeleteTrigger adds the spaceSnapshotAutodeleteTrigger to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotAutodeleteTrigger(spaceSnapshotAutodeleteTrigger *string) {
	o.SpaceSnapshotAutodeleteTrigger = spaceSnapshotAutodeleteTrigger
}

// WithSpaceSnapshotReserveAvailable adds the spaceSnapshotReserveAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable)
	return o
}

// SetSpaceSnapshotReserveAvailable adds the spaceSnapshotReserveAvailable to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable *int64) {
	o.SpaceSnapshotReserveAvailable = spaceSnapshotReserveAvailable
}

// WithSpaceSnapshotReservePercent adds the spaceSnapshotReservePercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotReservePercent(spaceSnapshotReservePercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotReservePercent(spaceSnapshotReservePercent)
	return o
}

// SetSpaceSnapshotReservePercent adds the spaceSnapshotReservePercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotReservePercent(spaceSnapshotReservePercent *int64) {
	o.SpaceSnapshotReservePercent = spaceSnapshotReservePercent
}

// WithSpaceSnapshotReserveSize adds the spaceSnapshotReserveSize to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotReserveSize(spaceSnapshotReserveSize *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotReserveSize(spaceSnapshotReserveSize)
	return o
}

// SetSpaceSnapshotReserveSize adds the spaceSnapshotReserveSize to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotReserveSize(spaceSnapshotReserveSize *int64) {
	o.SpaceSnapshotReserveSize = spaceSnapshotReserveSize
}

// WithSpaceSnapshotSpaceUsedPercent adds the spaceSnapshotSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent)
	return o
}

// SetSpaceSnapshotSpaceUsedPercent adds the spaceSnapshotSpaceUsedPercent to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent *int64) {
	o.SpaceSnapshotSpaceUsedPercent = spaceSnapshotSpaceUsedPercent
}

// WithSpaceSnapshotUsed adds the spaceSnapshotUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotUsed(spaceSnapshotUsed *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotUsed(spaceSnapshotUsed)
	return o
}

// SetSpaceSnapshotUsed adds the spaceSnapshotUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotUsed(spaceSnapshotUsed *int64) {
	o.SpaceSnapshotUsed = spaceSnapshotUsed
}

// WithSpaceSnapshotReserveUnusable adds the spaceSnapshotReserveUnusable to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotReserveUnusable(spaceSnapshotReserveUnusable *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotReserveUnusable(spaceSnapshotReserveUnusable)
	return o
}

// SetSpaceSnapshotReserveUnusable adds the spaceSnapshotReserveUnusable to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotReserveUnusable(spaceSnapshotReserveUnusable *int64) {
	o.SpaceSnapshotReserveUnusable = spaceSnapshotReserveUnusable
}

// WithSpaceSnapshotSpill adds the spaceSnapshotSpill to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceSnapshotSpill(spaceSnapshotSpill *int64) *VolumeCollectionGetParams {
	o.SetSpaceSnapshotSpill(spaceSnapshotSpill)
	return o
}

// SetSpaceSnapshotSpill adds the spaceSnapshotSpill to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceSnapshotSpill(spaceSnapshotSpill *int64) {
	o.SpaceSnapshotSpill = spaceSnapshotSpill
}

// WithSpaceTotalFootprint adds the spaceTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceTotalFootprint(spaceTotalFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceTotalFootprint(spaceTotalFootprint)
	return o
}

// SetSpaceTotalFootprint adds the spaceTotalFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceTotalFootprint(spaceTotalFootprint *int64) {
	o.SpaceTotalFootprint = spaceTotalFootprint
}

// WithSpaceTotalMetadata adds the spaceTotalMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceTotalMetadata(spaceTotalMetadata *int64) *VolumeCollectionGetParams {
	o.SetSpaceTotalMetadata(spaceTotalMetadata)
	return o
}

// SetSpaceTotalMetadata adds the spaceTotalMetadata to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceTotalMetadata(spaceTotalMetadata *int64) {
	o.SpaceTotalMetadata = spaceTotalMetadata
}

// WithSpaceTotalMetadataFootprint adds the spaceTotalMetadataFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceTotalMetadataFootprint(spaceTotalMetadataFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceTotalMetadataFootprint(spaceTotalMetadataFootprint)
	return o
}

// SetSpaceTotalMetadataFootprint adds the spaceTotalMetadataFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceTotalMetadataFootprint(spaceTotalMetadataFootprint *int64) {
	o.SpaceTotalMetadataFootprint = spaceTotalMetadataFootprint
}

// WithSpaceUsed adds the spaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceUsed(spaceUsed *int64) *VolumeCollectionGetParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithSpaceUsedByAfs adds the spaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceUsedByAfs(spaceUsedByAfs *int64) *VolumeCollectionGetParams {
	o.SetSpaceUsedByAfs(spaceUsedByAfs)
	return o
}

// SetSpaceUsedByAfs adds the spaceUsedByAfs to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceUsedByAfs(spaceUsedByAfs *int64) {
	o.SpaceUsedByAfs = spaceUsedByAfs
}

// WithSpaceUserData adds the spaceUserData to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceUserData(spaceUserData *int64) *VolumeCollectionGetParams {
	o.SetSpaceUserData(spaceUserData)
	return o
}

// SetSpaceUserData adds the spaceUserData to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceUserData(spaceUserData *int64) {
	o.SpaceUserData = spaceUserData
}

// WithSpaceVolumeGuaranteeFootprint adds the spaceVolumeGuaranteeFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) WithSpaceVolumeGuaranteeFootprint(spaceVolumeGuaranteeFootprint *int64) *VolumeCollectionGetParams {
	o.SetSpaceVolumeGuaranteeFootprint(spaceVolumeGuaranteeFootprint)
	return o
}

// SetSpaceVolumeGuaranteeFootprint adds the spaceVolumeGuaranteeFootprint to the volume collection get params
func (o *VolumeCollectionGetParams) SetSpaceVolumeGuaranteeFootprint(spaceVolumeGuaranteeFootprint *int64) {
	o.SpaceVolumeGuaranteeFootprint = spaceVolumeGuaranteeFootprint
}

// WithState adds the state to the volume collection get params
func (o *VolumeCollectionGetParams) WithState(state *string) *VolumeCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the volume collection get params
func (o *VolumeCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsCifsOpsRawAccessCount adds the statisticsCifsOpsRawAccessCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawAccessCount(statisticsCifsOpsRawAccessCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawAccessCount(statisticsCifsOpsRawAccessCount)
	return o
}

// SetStatisticsCifsOpsRawAccessCount adds the statisticsCifsOpsRawAccessCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawAccessCount(statisticsCifsOpsRawAccessCount *int64) {
	o.StatisticsCifsOpsRawAccessCount = statisticsCifsOpsRawAccessCount
}

// WithStatisticsCifsOpsRawAccessTotalTime adds the statisticsCifsOpsRawAccessTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawAccessTotalTime(statisticsCifsOpsRawAccessTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawAccessTotalTime(statisticsCifsOpsRawAccessTotalTime)
	return o
}

// SetStatisticsCifsOpsRawAccessTotalTime adds the statisticsCifsOpsRawAccessTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawAccessTotalTime(statisticsCifsOpsRawAccessTotalTime *int64) {
	o.StatisticsCifsOpsRawAccessTotalTime = statisticsCifsOpsRawAccessTotalTime
}

// WithStatisticsCifsOpsRawAuditCount adds the statisticsCifsOpsRawAuditCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawAuditCount(statisticsCifsOpsRawAuditCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawAuditCount(statisticsCifsOpsRawAuditCount)
	return o
}

// SetStatisticsCifsOpsRawAuditCount adds the statisticsCifsOpsRawAuditCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawAuditCount(statisticsCifsOpsRawAuditCount *int64) {
	o.StatisticsCifsOpsRawAuditCount = statisticsCifsOpsRawAuditCount
}

// WithStatisticsCifsOpsRawAuditTotalTime adds the statisticsCifsOpsRawAuditTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawAuditTotalTime(statisticsCifsOpsRawAuditTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawAuditTotalTime(statisticsCifsOpsRawAuditTotalTime)
	return o
}

// SetStatisticsCifsOpsRawAuditTotalTime adds the statisticsCifsOpsRawAuditTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawAuditTotalTime(statisticsCifsOpsRawAuditTotalTime *int64) {
	o.StatisticsCifsOpsRawAuditTotalTime = statisticsCifsOpsRawAuditTotalTime
}

// WithStatisticsCifsOpsRawCreateDirCount adds the statisticsCifsOpsRawCreateDirCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateDirCount(statisticsCifsOpsRawCreateDirCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateDirCount(statisticsCifsOpsRawCreateDirCount)
	return o
}

// SetStatisticsCifsOpsRawCreateDirCount adds the statisticsCifsOpsRawCreateDirCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateDirCount(statisticsCifsOpsRawCreateDirCount *int64) {
	o.StatisticsCifsOpsRawCreateDirCount = statisticsCifsOpsRawCreateDirCount
}

// WithStatisticsCifsOpsRawCreateDirTotalTime adds the statisticsCifsOpsRawCreateDirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateDirTotalTime(statisticsCifsOpsRawCreateDirTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateDirTotalTime(statisticsCifsOpsRawCreateDirTotalTime)
	return o
}

// SetStatisticsCifsOpsRawCreateDirTotalTime adds the statisticsCifsOpsRawCreateDirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateDirTotalTime(statisticsCifsOpsRawCreateDirTotalTime *int64) {
	o.StatisticsCifsOpsRawCreateDirTotalTime = statisticsCifsOpsRawCreateDirTotalTime
}

// WithStatisticsCifsOpsRawCreateFileCount adds the statisticsCifsOpsRawCreateFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateFileCount(statisticsCifsOpsRawCreateFileCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateFileCount(statisticsCifsOpsRawCreateFileCount)
	return o
}

// SetStatisticsCifsOpsRawCreateFileCount adds the statisticsCifsOpsRawCreateFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateFileCount(statisticsCifsOpsRawCreateFileCount *int64) {
	o.StatisticsCifsOpsRawCreateFileCount = statisticsCifsOpsRawCreateFileCount
}

// WithStatisticsCifsOpsRawCreateFileTotalTime adds the statisticsCifsOpsRawCreateFileTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateFileTotalTime(statisticsCifsOpsRawCreateFileTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateFileTotalTime(statisticsCifsOpsRawCreateFileTotalTime)
	return o
}

// SetStatisticsCifsOpsRawCreateFileTotalTime adds the statisticsCifsOpsRawCreateFileTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateFileTotalTime(statisticsCifsOpsRawCreateFileTotalTime *int64) {
	o.StatisticsCifsOpsRawCreateFileTotalTime = statisticsCifsOpsRawCreateFileTotalTime
}

// WithStatisticsCifsOpsRawCreateOtherCount adds the statisticsCifsOpsRawCreateOtherCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateOtherCount(statisticsCifsOpsRawCreateOtherCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateOtherCount(statisticsCifsOpsRawCreateOtherCount)
	return o
}

// SetStatisticsCifsOpsRawCreateOtherCount adds the statisticsCifsOpsRawCreateOtherCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateOtherCount(statisticsCifsOpsRawCreateOtherCount *int64) {
	o.StatisticsCifsOpsRawCreateOtherCount = statisticsCifsOpsRawCreateOtherCount
}

// WithStatisticsCifsOpsRawCreateOtherTotalTime adds the statisticsCifsOpsRawCreateOtherTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateOtherTotalTime(statisticsCifsOpsRawCreateOtherTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateOtherTotalTime(statisticsCifsOpsRawCreateOtherTotalTime)
	return o
}

// SetStatisticsCifsOpsRawCreateOtherTotalTime adds the statisticsCifsOpsRawCreateOtherTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateOtherTotalTime(statisticsCifsOpsRawCreateOtherTotalTime *int64) {
	o.StatisticsCifsOpsRawCreateOtherTotalTime = statisticsCifsOpsRawCreateOtherTotalTime
}

// WithStatisticsCifsOpsRawCreateSymlinkCount adds the statisticsCifsOpsRawCreateSymlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateSymlinkCount(statisticsCifsOpsRawCreateSymlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateSymlinkCount(statisticsCifsOpsRawCreateSymlinkCount)
	return o
}

// SetStatisticsCifsOpsRawCreateSymlinkCount adds the statisticsCifsOpsRawCreateSymlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateSymlinkCount(statisticsCifsOpsRawCreateSymlinkCount *int64) {
	o.StatisticsCifsOpsRawCreateSymlinkCount = statisticsCifsOpsRawCreateSymlinkCount
}

// WithStatisticsCifsOpsRawCreateSymlinkTotalTime adds the statisticsCifsOpsRawCreateSymlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawCreateSymlinkTotalTime(statisticsCifsOpsRawCreateSymlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawCreateSymlinkTotalTime(statisticsCifsOpsRawCreateSymlinkTotalTime)
	return o
}

// SetStatisticsCifsOpsRawCreateSymlinkTotalTime adds the statisticsCifsOpsRawCreateSymlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawCreateSymlinkTotalTime(statisticsCifsOpsRawCreateSymlinkTotalTime *int64) {
	o.StatisticsCifsOpsRawCreateSymlinkTotalTime = statisticsCifsOpsRawCreateSymlinkTotalTime
}

// WithStatisticsCifsOpsRawGetattrCount adds the statisticsCifsOpsRawGetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawGetattrCount(statisticsCifsOpsRawGetattrCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawGetattrCount(statisticsCifsOpsRawGetattrCount)
	return o
}

// SetStatisticsCifsOpsRawGetattrCount adds the statisticsCifsOpsRawGetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawGetattrCount(statisticsCifsOpsRawGetattrCount *int64) {
	o.StatisticsCifsOpsRawGetattrCount = statisticsCifsOpsRawGetattrCount
}

// WithStatisticsCifsOpsRawGetattrTotalTime adds the statisticsCifsOpsRawGetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawGetattrTotalTime(statisticsCifsOpsRawGetattrTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawGetattrTotalTime(statisticsCifsOpsRawGetattrTotalTime)
	return o
}

// SetStatisticsCifsOpsRawGetattrTotalTime adds the statisticsCifsOpsRawGetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawGetattrTotalTime(statisticsCifsOpsRawGetattrTotalTime *int64) {
	o.StatisticsCifsOpsRawGetattrTotalTime = statisticsCifsOpsRawGetattrTotalTime
}

// WithStatisticsCifsOpsRawLinkCount adds the statisticsCifsOpsRawLinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLinkCount(statisticsCifsOpsRawLinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLinkCount(statisticsCifsOpsRawLinkCount)
	return o
}

// SetStatisticsCifsOpsRawLinkCount adds the statisticsCifsOpsRawLinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLinkCount(statisticsCifsOpsRawLinkCount *int64) {
	o.StatisticsCifsOpsRawLinkCount = statisticsCifsOpsRawLinkCount
}

// WithStatisticsCifsOpsRawLinkTotalTime adds the statisticsCifsOpsRawLinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLinkTotalTime(statisticsCifsOpsRawLinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLinkTotalTime(statisticsCifsOpsRawLinkTotalTime)
	return o
}

// SetStatisticsCifsOpsRawLinkTotalTime adds the statisticsCifsOpsRawLinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLinkTotalTime(statisticsCifsOpsRawLinkTotalTime *int64) {
	o.StatisticsCifsOpsRawLinkTotalTime = statisticsCifsOpsRawLinkTotalTime
}

// WithStatisticsCifsOpsRawLockCount adds the statisticsCifsOpsRawLockCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLockCount(statisticsCifsOpsRawLockCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLockCount(statisticsCifsOpsRawLockCount)
	return o
}

// SetStatisticsCifsOpsRawLockCount adds the statisticsCifsOpsRawLockCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLockCount(statisticsCifsOpsRawLockCount *int64) {
	o.StatisticsCifsOpsRawLockCount = statisticsCifsOpsRawLockCount
}

// WithStatisticsCifsOpsRawLockTotalTime adds the statisticsCifsOpsRawLockTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLockTotalTime(statisticsCifsOpsRawLockTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLockTotalTime(statisticsCifsOpsRawLockTotalTime)
	return o
}

// SetStatisticsCifsOpsRawLockTotalTime adds the statisticsCifsOpsRawLockTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLockTotalTime(statisticsCifsOpsRawLockTotalTime *int64) {
	o.StatisticsCifsOpsRawLockTotalTime = statisticsCifsOpsRawLockTotalTime
}

// WithStatisticsCifsOpsRawLookupCount adds the statisticsCifsOpsRawLookupCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLookupCount(statisticsCifsOpsRawLookupCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLookupCount(statisticsCifsOpsRawLookupCount)
	return o
}

// SetStatisticsCifsOpsRawLookupCount adds the statisticsCifsOpsRawLookupCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLookupCount(statisticsCifsOpsRawLookupCount *int64) {
	o.StatisticsCifsOpsRawLookupCount = statisticsCifsOpsRawLookupCount
}

// WithStatisticsCifsOpsRawLookupTotalTime adds the statisticsCifsOpsRawLookupTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawLookupTotalTime(statisticsCifsOpsRawLookupTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawLookupTotalTime(statisticsCifsOpsRawLookupTotalTime)
	return o
}

// SetStatisticsCifsOpsRawLookupTotalTime adds the statisticsCifsOpsRawLookupTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawLookupTotalTime(statisticsCifsOpsRawLookupTotalTime *int64) {
	o.StatisticsCifsOpsRawLookupTotalTime = statisticsCifsOpsRawLookupTotalTime
}

// WithStatisticsCifsOpsRawOpenCount adds the statisticsCifsOpsRawOpenCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawOpenCount(statisticsCifsOpsRawOpenCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawOpenCount(statisticsCifsOpsRawOpenCount)
	return o
}

// SetStatisticsCifsOpsRawOpenCount adds the statisticsCifsOpsRawOpenCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawOpenCount(statisticsCifsOpsRawOpenCount *int64) {
	o.StatisticsCifsOpsRawOpenCount = statisticsCifsOpsRawOpenCount
}

// WithStatisticsCifsOpsRawOpenTotalTime adds the statisticsCifsOpsRawOpenTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawOpenTotalTime(statisticsCifsOpsRawOpenTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawOpenTotalTime(statisticsCifsOpsRawOpenTotalTime)
	return o
}

// SetStatisticsCifsOpsRawOpenTotalTime adds the statisticsCifsOpsRawOpenTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawOpenTotalTime(statisticsCifsOpsRawOpenTotalTime *int64) {
	o.StatisticsCifsOpsRawOpenTotalTime = statisticsCifsOpsRawOpenTotalTime
}

// WithStatisticsCifsOpsRawReadCount adds the statisticsCifsOpsRawReadCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadCount(statisticsCifsOpsRawReadCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadCount(statisticsCifsOpsRawReadCount)
	return o
}

// SetStatisticsCifsOpsRawReadCount adds the statisticsCifsOpsRawReadCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadCount(statisticsCifsOpsRawReadCount *int64) {
	o.StatisticsCifsOpsRawReadCount = statisticsCifsOpsRawReadCount
}

// WithStatisticsCifsOpsRawReadTotalTime adds the statisticsCifsOpsRawReadTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadTotalTime(statisticsCifsOpsRawReadTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadTotalTime(statisticsCifsOpsRawReadTotalTime)
	return o
}

// SetStatisticsCifsOpsRawReadTotalTime adds the statisticsCifsOpsRawReadTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadTotalTime(statisticsCifsOpsRawReadTotalTime *int64) {
	o.StatisticsCifsOpsRawReadTotalTime = statisticsCifsOpsRawReadTotalTime
}

// WithStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts adds the statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts)
	return o
}

// SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts adds the statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64) {
	o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts = statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts
}

// WithStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels adds the statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels)
	return o
}

// SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels adds the statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels *string) {
	o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels = statisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels
}

// WithStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts adds the statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts)
	return o
}

// SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts adds the statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts *int64) {
	o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts = statisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts
}

// WithStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels adds the statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels)
	return o
}

// SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels adds the statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels *string) {
	o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels = statisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels
}

// WithStatisticsCifsOpsRawReaddirCount adds the statisticsCifsOpsRawReaddirCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReaddirCount(statisticsCifsOpsRawReaddirCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReaddirCount(statisticsCifsOpsRawReaddirCount)
	return o
}

// SetStatisticsCifsOpsRawReaddirCount adds the statisticsCifsOpsRawReaddirCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReaddirCount(statisticsCifsOpsRawReaddirCount *int64) {
	o.StatisticsCifsOpsRawReaddirCount = statisticsCifsOpsRawReaddirCount
}

// WithStatisticsCifsOpsRawReaddirTotalTime adds the statisticsCifsOpsRawReaddirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReaddirTotalTime(statisticsCifsOpsRawReaddirTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReaddirTotalTime(statisticsCifsOpsRawReaddirTotalTime)
	return o
}

// SetStatisticsCifsOpsRawReaddirTotalTime adds the statisticsCifsOpsRawReaddirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReaddirTotalTime(statisticsCifsOpsRawReaddirTotalTime *int64) {
	o.StatisticsCifsOpsRawReaddirTotalTime = statisticsCifsOpsRawReaddirTotalTime
}

// WithStatisticsCifsOpsRawReadlinkCount adds the statisticsCifsOpsRawReadlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadlinkCount(statisticsCifsOpsRawReadlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadlinkCount(statisticsCifsOpsRawReadlinkCount)
	return o
}

// SetStatisticsCifsOpsRawReadlinkCount adds the statisticsCifsOpsRawReadlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadlinkCount(statisticsCifsOpsRawReadlinkCount *int64) {
	o.StatisticsCifsOpsRawReadlinkCount = statisticsCifsOpsRawReadlinkCount
}

// WithStatisticsCifsOpsRawReadlinkTotalTime adds the statisticsCifsOpsRawReadlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawReadlinkTotalTime(statisticsCifsOpsRawReadlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawReadlinkTotalTime(statisticsCifsOpsRawReadlinkTotalTime)
	return o
}

// SetStatisticsCifsOpsRawReadlinkTotalTime adds the statisticsCifsOpsRawReadlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawReadlinkTotalTime(statisticsCifsOpsRawReadlinkTotalTime *int64) {
	o.StatisticsCifsOpsRawReadlinkTotalTime = statisticsCifsOpsRawReadlinkTotalTime
}

// WithStatisticsCifsOpsRawRenameCount adds the statisticsCifsOpsRawRenameCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawRenameCount(statisticsCifsOpsRawRenameCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawRenameCount(statisticsCifsOpsRawRenameCount)
	return o
}

// SetStatisticsCifsOpsRawRenameCount adds the statisticsCifsOpsRawRenameCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawRenameCount(statisticsCifsOpsRawRenameCount *int64) {
	o.StatisticsCifsOpsRawRenameCount = statisticsCifsOpsRawRenameCount
}

// WithStatisticsCifsOpsRawRenameTotalTime adds the statisticsCifsOpsRawRenameTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawRenameTotalTime(statisticsCifsOpsRawRenameTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawRenameTotalTime(statisticsCifsOpsRawRenameTotalTime)
	return o
}

// SetStatisticsCifsOpsRawRenameTotalTime adds the statisticsCifsOpsRawRenameTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawRenameTotalTime(statisticsCifsOpsRawRenameTotalTime *int64) {
	o.StatisticsCifsOpsRawRenameTotalTime = statisticsCifsOpsRawRenameTotalTime
}

// WithStatisticsCifsOpsRawSetattrCount adds the statisticsCifsOpsRawSetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawSetattrCount(statisticsCifsOpsRawSetattrCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawSetattrCount(statisticsCifsOpsRawSetattrCount)
	return o
}

// SetStatisticsCifsOpsRawSetattrCount adds the statisticsCifsOpsRawSetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawSetattrCount(statisticsCifsOpsRawSetattrCount *int64) {
	o.StatisticsCifsOpsRawSetattrCount = statisticsCifsOpsRawSetattrCount
}

// WithStatisticsCifsOpsRawSetattrTotalTime adds the statisticsCifsOpsRawSetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawSetattrTotalTime(statisticsCifsOpsRawSetattrTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawSetattrTotalTime(statisticsCifsOpsRawSetattrTotalTime)
	return o
}

// SetStatisticsCifsOpsRawSetattrTotalTime adds the statisticsCifsOpsRawSetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawSetattrTotalTime(statisticsCifsOpsRawSetattrTotalTime *int64) {
	o.StatisticsCifsOpsRawSetattrTotalTime = statisticsCifsOpsRawSetattrTotalTime
}

// WithStatisticsCifsOpsRawUnlinkCount adds the statisticsCifsOpsRawUnlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawUnlinkCount(statisticsCifsOpsRawUnlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawUnlinkCount(statisticsCifsOpsRawUnlinkCount)
	return o
}

// SetStatisticsCifsOpsRawUnlinkCount adds the statisticsCifsOpsRawUnlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawUnlinkCount(statisticsCifsOpsRawUnlinkCount *int64) {
	o.StatisticsCifsOpsRawUnlinkCount = statisticsCifsOpsRawUnlinkCount
}

// WithStatisticsCifsOpsRawUnlinkTotalTime adds the statisticsCifsOpsRawUnlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawUnlinkTotalTime(statisticsCifsOpsRawUnlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawUnlinkTotalTime(statisticsCifsOpsRawUnlinkTotalTime)
	return o
}

// SetStatisticsCifsOpsRawUnlinkTotalTime adds the statisticsCifsOpsRawUnlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawUnlinkTotalTime(statisticsCifsOpsRawUnlinkTotalTime *int64) {
	o.StatisticsCifsOpsRawUnlinkTotalTime = statisticsCifsOpsRawUnlinkTotalTime
}

// WithStatisticsCifsOpsRawWatchCount adds the statisticsCifsOpsRawWatchCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWatchCount(statisticsCifsOpsRawWatchCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWatchCount(statisticsCifsOpsRawWatchCount)
	return o
}

// SetStatisticsCifsOpsRawWatchCount adds the statisticsCifsOpsRawWatchCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWatchCount(statisticsCifsOpsRawWatchCount *int64) {
	o.StatisticsCifsOpsRawWatchCount = statisticsCifsOpsRawWatchCount
}

// WithStatisticsCifsOpsRawWatchTotalTime adds the statisticsCifsOpsRawWatchTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWatchTotalTime(statisticsCifsOpsRawWatchTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWatchTotalTime(statisticsCifsOpsRawWatchTotalTime)
	return o
}

// SetStatisticsCifsOpsRawWatchTotalTime adds the statisticsCifsOpsRawWatchTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWatchTotalTime(statisticsCifsOpsRawWatchTotalTime *int64) {
	o.StatisticsCifsOpsRawWatchTotalTime = statisticsCifsOpsRawWatchTotalTime
}

// WithStatisticsCifsOpsRawWriteCount adds the statisticsCifsOpsRawWriteCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteCount(statisticsCifsOpsRawWriteCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteCount(statisticsCifsOpsRawWriteCount)
	return o
}

// SetStatisticsCifsOpsRawWriteCount adds the statisticsCifsOpsRawWriteCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteCount(statisticsCifsOpsRawWriteCount *int64) {
	o.StatisticsCifsOpsRawWriteCount = statisticsCifsOpsRawWriteCount
}

// WithStatisticsCifsOpsRawWriteTotalTime adds the statisticsCifsOpsRawWriteTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteTotalTime(statisticsCifsOpsRawWriteTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteTotalTime(statisticsCifsOpsRawWriteTotalTime)
	return o
}

// SetStatisticsCifsOpsRawWriteTotalTime adds the statisticsCifsOpsRawWriteTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteTotalTime(statisticsCifsOpsRawWriteTotalTime *int64) {
	o.StatisticsCifsOpsRawWriteTotalTime = statisticsCifsOpsRawWriteTotalTime
}

// WithStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts adds the statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts)
	return o
}

// SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts adds the statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64) {
	o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts = statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts
}

// WithStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels adds the statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels)
	return o
}

// SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels adds the statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string) {
	o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels = statisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels
}

// WithStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts adds the statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts)
	return o
}

// SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts adds the statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64) {
	o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts = statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts
}

// WithStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels adds the statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels)
	return o
}

// SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels adds the statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels *string) {
	o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels = statisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels
}

// WithStatisticsCloudIopsRawOther adds the statisticsCloudIopsRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudIopsRawOther(statisticsCloudIopsRawOther *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudIopsRawOther(statisticsCloudIopsRawOther)
	return o
}

// SetStatisticsCloudIopsRawOther adds the statisticsCloudIopsRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudIopsRawOther(statisticsCloudIopsRawOther *int64) {
	o.StatisticsCloudIopsRawOther = statisticsCloudIopsRawOther
}

// WithStatisticsCloudIopsRawRead adds the statisticsCloudIopsRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudIopsRawRead(statisticsCloudIopsRawRead *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudIopsRawRead(statisticsCloudIopsRawRead)
	return o
}

// SetStatisticsCloudIopsRawRead adds the statisticsCloudIopsRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudIopsRawRead(statisticsCloudIopsRawRead *int64) {
	o.StatisticsCloudIopsRawRead = statisticsCloudIopsRawRead
}

// WithStatisticsCloudIopsRawTotal adds the statisticsCloudIopsRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudIopsRawTotal(statisticsCloudIopsRawTotal *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudIopsRawTotal(statisticsCloudIopsRawTotal)
	return o
}

// SetStatisticsCloudIopsRawTotal adds the statisticsCloudIopsRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudIopsRawTotal(statisticsCloudIopsRawTotal *int64) {
	o.StatisticsCloudIopsRawTotal = statisticsCloudIopsRawTotal
}

// WithStatisticsCloudIopsRawWrite adds the statisticsCloudIopsRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudIopsRawWrite(statisticsCloudIopsRawWrite *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudIopsRawWrite(statisticsCloudIopsRawWrite)
	return o
}

// SetStatisticsCloudIopsRawWrite adds the statisticsCloudIopsRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudIopsRawWrite(statisticsCloudIopsRawWrite *int64) {
	o.StatisticsCloudIopsRawWrite = statisticsCloudIopsRawWrite
}

// WithStatisticsCloudLatencyRawOther adds the statisticsCloudLatencyRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudLatencyRawOther(statisticsCloudLatencyRawOther *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudLatencyRawOther(statisticsCloudLatencyRawOther)
	return o
}

// SetStatisticsCloudLatencyRawOther adds the statisticsCloudLatencyRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudLatencyRawOther(statisticsCloudLatencyRawOther *int64) {
	o.StatisticsCloudLatencyRawOther = statisticsCloudLatencyRawOther
}

// WithStatisticsCloudLatencyRawRead adds the statisticsCloudLatencyRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudLatencyRawRead(statisticsCloudLatencyRawRead *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudLatencyRawRead(statisticsCloudLatencyRawRead)
	return o
}

// SetStatisticsCloudLatencyRawRead adds the statisticsCloudLatencyRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudLatencyRawRead(statisticsCloudLatencyRawRead *int64) {
	o.StatisticsCloudLatencyRawRead = statisticsCloudLatencyRawRead
}

// WithStatisticsCloudLatencyRawTotal adds the statisticsCloudLatencyRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudLatencyRawTotal(statisticsCloudLatencyRawTotal *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudLatencyRawTotal(statisticsCloudLatencyRawTotal)
	return o
}

// SetStatisticsCloudLatencyRawTotal adds the statisticsCloudLatencyRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudLatencyRawTotal(statisticsCloudLatencyRawTotal *int64) {
	o.StatisticsCloudLatencyRawTotal = statisticsCloudLatencyRawTotal
}

// WithStatisticsCloudLatencyRawWrite adds the statisticsCloudLatencyRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudLatencyRawWrite(statisticsCloudLatencyRawWrite *int64) *VolumeCollectionGetParams {
	o.SetStatisticsCloudLatencyRawWrite(statisticsCloudLatencyRawWrite)
	return o
}

// SetStatisticsCloudLatencyRawWrite adds the statisticsCloudLatencyRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudLatencyRawWrite(statisticsCloudLatencyRawWrite *int64) {
	o.StatisticsCloudLatencyRawWrite = statisticsCloudLatencyRawWrite
}

// WithStatisticsCloudStatus adds the statisticsCloudStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudStatus(statisticsCloudStatus *string) *VolumeCollectionGetParams {
	o.SetStatisticsCloudStatus(statisticsCloudStatus)
	return o
}

// SetStatisticsCloudStatus adds the statisticsCloudStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudStatus(statisticsCloudStatus *string) {
	o.StatisticsCloudStatus = statisticsCloudStatus
}

// WithStatisticsCloudTimestamp adds the statisticsCloudTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsCloudTimestamp(statisticsCloudTimestamp *string) *VolumeCollectionGetParams {
	o.SetStatisticsCloudTimestamp(statisticsCloudTimestamp)
	return o
}

// SetStatisticsCloudTimestamp adds the statisticsCloudTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsCloudTimestamp(statisticsCloudTimestamp *string) {
	o.StatisticsCloudTimestamp = statisticsCloudTimestamp
}

// WithStatisticsFlexcacheRawCacheMissBlocks adds the statisticsFlexcacheRawCacheMissBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsFlexcacheRawCacheMissBlocks(statisticsFlexcacheRawCacheMissBlocks *int64) *VolumeCollectionGetParams {
	o.SetStatisticsFlexcacheRawCacheMissBlocks(statisticsFlexcacheRawCacheMissBlocks)
	return o
}

// SetStatisticsFlexcacheRawCacheMissBlocks adds the statisticsFlexcacheRawCacheMissBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsFlexcacheRawCacheMissBlocks(statisticsFlexcacheRawCacheMissBlocks *int64) {
	o.StatisticsFlexcacheRawCacheMissBlocks = statisticsFlexcacheRawCacheMissBlocks
}

// WithStatisticsFlexcacheRawClientRequestedBlocks adds the statisticsFlexcacheRawClientRequestedBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsFlexcacheRawClientRequestedBlocks(statisticsFlexcacheRawClientRequestedBlocks *int64) *VolumeCollectionGetParams {
	o.SetStatisticsFlexcacheRawClientRequestedBlocks(statisticsFlexcacheRawClientRequestedBlocks)
	return o
}

// SetStatisticsFlexcacheRawClientRequestedBlocks adds the statisticsFlexcacheRawClientRequestedBlocks to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsFlexcacheRawClientRequestedBlocks(statisticsFlexcacheRawClientRequestedBlocks *int64) {
	o.StatisticsFlexcacheRawClientRequestedBlocks = statisticsFlexcacheRawClientRequestedBlocks
}

// WithStatisticsFlexcacheRawStatus adds the statisticsFlexcacheRawStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsFlexcacheRawStatus(statisticsFlexcacheRawStatus *string) *VolumeCollectionGetParams {
	o.SetStatisticsFlexcacheRawStatus(statisticsFlexcacheRawStatus)
	return o
}

// SetStatisticsFlexcacheRawStatus adds the statisticsFlexcacheRawStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsFlexcacheRawStatus(statisticsFlexcacheRawStatus *string) {
	o.StatisticsFlexcacheRawStatus = statisticsFlexcacheRawStatus
}

// WithStatisticsFlexcacheRawTimestamp adds the statisticsFlexcacheRawTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsFlexcacheRawTimestamp(statisticsFlexcacheRawTimestamp *string) *VolumeCollectionGetParams {
	o.SetStatisticsFlexcacheRawTimestamp(statisticsFlexcacheRawTimestamp)
	return o
}

// SetStatisticsFlexcacheRawTimestamp adds the statisticsFlexcacheRawTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsFlexcacheRawTimestamp(statisticsFlexcacheRawTimestamp *string) {
	o.StatisticsFlexcacheRawTimestamp = statisticsFlexcacheRawTimestamp
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *VolumeCollectionGetParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *VolumeCollectionGetParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *VolumeCollectionGetParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *VolumeCollectionGetParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *VolumeCollectionGetParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *VolumeCollectionGetParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *VolumeCollectionGetParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *VolumeCollectionGetParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsNfsOpsRawAccessCount adds the statisticsNfsOpsRawAccessCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawAccessCount(statisticsNfsOpsRawAccessCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawAccessCount(statisticsNfsOpsRawAccessCount)
	return o
}

// SetStatisticsNfsOpsRawAccessCount adds the statisticsNfsOpsRawAccessCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawAccessCount(statisticsNfsOpsRawAccessCount *int64) {
	o.StatisticsNfsOpsRawAccessCount = statisticsNfsOpsRawAccessCount
}

// WithStatisticsNfsOpsRawAccessTotalTime adds the statisticsNfsOpsRawAccessTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawAccessTotalTime(statisticsNfsOpsRawAccessTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawAccessTotalTime(statisticsNfsOpsRawAccessTotalTime)
	return o
}

// SetStatisticsNfsOpsRawAccessTotalTime adds the statisticsNfsOpsRawAccessTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawAccessTotalTime(statisticsNfsOpsRawAccessTotalTime *int64) {
	o.StatisticsNfsOpsRawAccessTotalTime = statisticsNfsOpsRawAccessTotalTime
}

// WithStatisticsNfsOpsRawAuditCount adds the statisticsNfsOpsRawAuditCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawAuditCount(statisticsNfsOpsRawAuditCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawAuditCount(statisticsNfsOpsRawAuditCount)
	return o
}

// SetStatisticsNfsOpsRawAuditCount adds the statisticsNfsOpsRawAuditCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawAuditCount(statisticsNfsOpsRawAuditCount *int64) {
	o.StatisticsNfsOpsRawAuditCount = statisticsNfsOpsRawAuditCount
}

// WithStatisticsNfsOpsRawAuditTotalTime adds the statisticsNfsOpsRawAuditTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawAuditTotalTime(statisticsNfsOpsRawAuditTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawAuditTotalTime(statisticsNfsOpsRawAuditTotalTime)
	return o
}

// SetStatisticsNfsOpsRawAuditTotalTime adds the statisticsNfsOpsRawAuditTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawAuditTotalTime(statisticsNfsOpsRawAuditTotalTime *int64) {
	o.StatisticsNfsOpsRawAuditTotalTime = statisticsNfsOpsRawAuditTotalTime
}

// WithStatisticsNfsOpsRawCreateDirCount adds the statisticsNfsOpsRawCreateDirCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateDirCount(statisticsNfsOpsRawCreateDirCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateDirCount(statisticsNfsOpsRawCreateDirCount)
	return o
}

// SetStatisticsNfsOpsRawCreateDirCount adds the statisticsNfsOpsRawCreateDirCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateDirCount(statisticsNfsOpsRawCreateDirCount *int64) {
	o.StatisticsNfsOpsRawCreateDirCount = statisticsNfsOpsRawCreateDirCount
}

// WithStatisticsNfsOpsRawCreateDirTotalTime adds the statisticsNfsOpsRawCreateDirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateDirTotalTime(statisticsNfsOpsRawCreateDirTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateDirTotalTime(statisticsNfsOpsRawCreateDirTotalTime)
	return o
}

// SetStatisticsNfsOpsRawCreateDirTotalTime adds the statisticsNfsOpsRawCreateDirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateDirTotalTime(statisticsNfsOpsRawCreateDirTotalTime *int64) {
	o.StatisticsNfsOpsRawCreateDirTotalTime = statisticsNfsOpsRawCreateDirTotalTime
}

// WithStatisticsNfsOpsRawCreateFileCount adds the statisticsNfsOpsRawCreateFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateFileCount(statisticsNfsOpsRawCreateFileCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateFileCount(statisticsNfsOpsRawCreateFileCount)
	return o
}

// SetStatisticsNfsOpsRawCreateFileCount adds the statisticsNfsOpsRawCreateFileCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateFileCount(statisticsNfsOpsRawCreateFileCount *int64) {
	o.StatisticsNfsOpsRawCreateFileCount = statisticsNfsOpsRawCreateFileCount
}

// WithStatisticsNfsOpsRawCreateFileTotalTime adds the statisticsNfsOpsRawCreateFileTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateFileTotalTime(statisticsNfsOpsRawCreateFileTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateFileTotalTime(statisticsNfsOpsRawCreateFileTotalTime)
	return o
}

// SetStatisticsNfsOpsRawCreateFileTotalTime adds the statisticsNfsOpsRawCreateFileTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateFileTotalTime(statisticsNfsOpsRawCreateFileTotalTime *int64) {
	o.StatisticsNfsOpsRawCreateFileTotalTime = statisticsNfsOpsRawCreateFileTotalTime
}

// WithStatisticsNfsOpsRawCreateOtherCount adds the statisticsNfsOpsRawCreateOtherCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateOtherCount(statisticsNfsOpsRawCreateOtherCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateOtherCount(statisticsNfsOpsRawCreateOtherCount)
	return o
}

// SetStatisticsNfsOpsRawCreateOtherCount adds the statisticsNfsOpsRawCreateOtherCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateOtherCount(statisticsNfsOpsRawCreateOtherCount *int64) {
	o.StatisticsNfsOpsRawCreateOtherCount = statisticsNfsOpsRawCreateOtherCount
}

// WithStatisticsNfsOpsRawCreateOtherTotalTime adds the statisticsNfsOpsRawCreateOtherTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateOtherTotalTime(statisticsNfsOpsRawCreateOtherTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateOtherTotalTime(statisticsNfsOpsRawCreateOtherTotalTime)
	return o
}

// SetStatisticsNfsOpsRawCreateOtherTotalTime adds the statisticsNfsOpsRawCreateOtherTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateOtherTotalTime(statisticsNfsOpsRawCreateOtherTotalTime *int64) {
	o.StatisticsNfsOpsRawCreateOtherTotalTime = statisticsNfsOpsRawCreateOtherTotalTime
}

// WithStatisticsNfsOpsRawCreateSymlinkCount adds the statisticsNfsOpsRawCreateSymlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateSymlinkCount(statisticsNfsOpsRawCreateSymlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateSymlinkCount(statisticsNfsOpsRawCreateSymlinkCount)
	return o
}

// SetStatisticsNfsOpsRawCreateSymlinkCount adds the statisticsNfsOpsRawCreateSymlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateSymlinkCount(statisticsNfsOpsRawCreateSymlinkCount *int64) {
	o.StatisticsNfsOpsRawCreateSymlinkCount = statisticsNfsOpsRawCreateSymlinkCount
}

// WithStatisticsNfsOpsRawCreateSymlinkTotalTime adds the statisticsNfsOpsRawCreateSymlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawCreateSymlinkTotalTime(statisticsNfsOpsRawCreateSymlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawCreateSymlinkTotalTime(statisticsNfsOpsRawCreateSymlinkTotalTime)
	return o
}

// SetStatisticsNfsOpsRawCreateSymlinkTotalTime adds the statisticsNfsOpsRawCreateSymlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawCreateSymlinkTotalTime(statisticsNfsOpsRawCreateSymlinkTotalTime *int64) {
	o.StatisticsNfsOpsRawCreateSymlinkTotalTime = statisticsNfsOpsRawCreateSymlinkTotalTime
}

// WithStatisticsNfsOpsRawGetattrCount adds the statisticsNfsOpsRawGetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawGetattrCount(statisticsNfsOpsRawGetattrCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawGetattrCount(statisticsNfsOpsRawGetattrCount)
	return o
}

// SetStatisticsNfsOpsRawGetattrCount adds the statisticsNfsOpsRawGetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawGetattrCount(statisticsNfsOpsRawGetattrCount *int64) {
	o.StatisticsNfsOpsRawGetattrCount = statisticsNfsOpsRawGetattrCount
}

// WithStatisticsNfsOpsRawGetattrTotalTime adds the statisticsNfsOpsRawGetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawGetattrTotalTime(statisticsNfsOpsRawGetattrTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawGetattrTotalTime(statisticsNfsOpsRawGetattrTotalTime)
	return o
}

// SetStatisticsNfsOpsRawGetattrTotalTime adds the statisticsNfsOpsRawGetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawGetattrTotalTime(statisticsNfsOpsRawGetattrTotalTime *int64) {
	o.StatisticsNfsOpsRawGetattrTotalTime = statisticsNfsOpsRawGetattrTotalTime
}

// WithStatisticsNfsOpsRawLinkCount adds the statisticsNfsOpsRawLinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLinkCount(statisticsNfsOpsRawLinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLinkCount(statisticsNfsOpsRawLinkCount)
	return o
}

// SetStatisticsNfsOpsRawLinkCount adds the statisticsNfsOpsRawLinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLinkCount(statisticsNfsOpsRawLinkCount *int64) {
	o.StatisticsNfsOpsRawLinkCount = statisticsNfsOpsRawLinkCount
}

// WithStatisticsNfsOpsRawLinkTotalTime adds the statisticsNfsOpsRawLinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLinkTotalTime(statisticsNfsOpsRawLinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLinkTotalTime(statisticsNfsOpsRawLinkTotalTime)
	return o
}

// SetStatisticsNfsOpsRawLinkTotalTime adds the statisticsNfsOpsRawLinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLinkTotalTime(statisticsNfsOpsRawLinkTotalTime *int64) {
	o.StatisticsNfsOpsRawLinkTotalTime = statisticsNfsOpsRawLinkTotalTime
}

// WithStatisticsNfsOpsRawLockCount adds the statisticsNfsOpsRawLockCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLockCount(statisticsNfsOpsRawLockCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLockCount(statisticsNfsOpsRawLockCount)
	return o
}

// SetStatisticsNfsOpsRawLockCount adds the statisticsNfsOpsRawLockCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLockCount(statisticsNfsOpsRawLockCount *int64) {
	o.StatisticsNfsOpsRawLockCount = statisticsNfsOpsRawLockCount
}

// WithStatisticsNfsOpsRawLockTotalTime adds the statisticsNfsOpsRawLockTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLockTotalTime(statisticsNfsOpsRawLockTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLockTotalTime(statisticsNfsOpsRawLockTotalTime)
	return o
}

// SetStatisticsNfsOpsRawLockTotalTime adds the statisticsNfsOpsRawLockTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLockTotalTime(statisticsNfsOpsRawLockTotalTime *int64) {
	o.StatisticsNfsOpsRawLockTotalTime = statisticsNfsOpsRawLockTotalTime
}

// WithStatisticsNfsOpsRawLookupCount adds the statisticsNfsOpsRawLookupCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLookupCount(statisticsNfsOpsRawLookupCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLookupCount(statisticsNfsOpsRawLookupCount)
	return o
}

// SetStatisticsNfsOpsRawLookupCount adds the statisticsNfsOpsRawLookupCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLookupCount(statisticsNfsOpsRawLookupCount *int64) {
	o.StatisticsNfsOpsRawLookupCount = statisticsNfsOpsRawLookupCount
}

// WithStatisticsNfsOpsRawLookupTotalTime adds the statisticsNfsOpsRawLookupTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawLookupTotalTime(statisticsNfsOpsRawLookupTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawLookupTotalTime(statisticsNfsOpsRawLookupTotalTime)
	return o
}

// SetStatisticsNfsOpsRawLookupTotalTime adds the statisticsNfsOpsRawLookupTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawLookupTotalTime(statisticsNfsOpsRawLookupTotalTime *int64) {
	o.StatisticsNfsOpsRawLookupTotalTime = statisticsNfsOpsRawLookupTotalTime
}

// WithStatisticsNfsOpsRawOpenCount adds the statisticsNfsOpsRawOpenCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawOpenCount(statisticsNfsOpsRawOpenCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawOpenCount(statisticsNfsOpsRawOpenCount)
	return o
}

// SetStatisticsNfsOpsRawOpenCount adds the statisticsNfsOpsRawOpenCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawOpenCount(statisticsNfsOpsRawOpenCount *int64) {
	o.StatisticsNfsOpsRawOpenCount = statisticsNfsOpsRawOpenCount
}

// WithStatisticsNfsOpsRawOpenTotalTime adds the statisticsNfsOpsRawOpenTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawOpenTotalTime(statisticsNfsOpsRawOpenTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawOpenTotalTime(statisticsNfsOpsRawOpenTotalTime)
	return o
}

// SetStatisticsNfsOpsRawOpenTotalTime adds the statisticsNfsOpsRawOpenTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawOpenTotalTime(statisticsNfsOpsRawOpenTotalTime *int64) {
	o.StatisticsNfsOpsRawOpenTotalTime = statisticsNfsOpsRawOpenTotalTime
}

// WithStatisticsNfsOpsRawReadCount adds the statisticsNfsOpsRawReadCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadCount(statisticsNfsOpsRawReadCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadCount(statisticsNfsOpsRawReadCount)
	return o
}

// SetStatisticsNfsOpsRawReadCount adds the statisticsNfsOpsRawReadCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadCount(statisticsNfsOpsRawReadCount *int64) {
	o.StatisticsNfsOpsRawReadCount = statisticsNfsOpsRawReadCount
}

// WithStatisticsNfsOpsRawReadTotalTime adds the statisticsNfsOpsRawReadTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadTotalTime(statisticsNfsOpsRawReadTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadTotalTime(statisticsNfsOpsRawReadTotalTime)
	return o
}

// SetStatisticsNfsOpsRawReadTotalTime adds the statisticsNfsOpsRawReadTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadTotalTime(statisticsNfsOpsRawReadTotalTime *int64) {
	o.StatisticsNfsOpsRawReadTotalTime = statisticsNfsOpsRawReadTotalTime
}

// WithStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts adds the statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts)
	return o
}

// SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts adds the statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts *int64) {
	o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts = statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts
}

// WithStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels adds the statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels)
	return o
}

// SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels adds the statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels *string) {
	o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels = statisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels
}

// WithStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts adds the statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts)
	return o
}

// SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts adds the statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts *int64) {
	o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts = statisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts
}

// WithStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels adds the statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels)
	return o
}

// SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels adds the statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels *string) {
	o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels = statisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels
}

// WithStatisticsNfsOpsRawReaddirCount adds the statisticsNfsOpsRawReaddirCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReaddirCount(statisticsNfsOpsRawReaddirCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReaddirCount(statisticsNfsOpsRawReaddirCount)
	return o
}

// SetStatisticsNfsOpsRawReaddirCount adds the statisticsNfsOpsRawReaddirCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReaddirCount(statisticsNfsOpsRawReaddirCount *int64) {
	o.StatisticsNfsOpsRawReaddirCount = statisticsNfsOpsRawReaddirCount
}

// WithStatisticsNfsOpsRawReaddirTotalTime adds the statisticsNfsOpsRawReaddirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReaddirTotalTime(statisticsNfsOpsRawReaddirTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReaddirTotalTime(statisticsNfsOpsRawReaddirTotalTime)
	return o
}

// SetStatisticsNfsOpsRawReaddirTotalTime adds the statisticsNfsOpsRawReaddirTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReaddirTotalTime(statisticsNfsOpsRawReaddirTotalTime *int64) {
	o.StatisticsNfsOpsRawReaddirTotalTime = statisticsNfsOpsRawReaddirTotalTime
}

// WithStatisticsNfsOpsRawReadlinkCount adds the statisticsNfsOpsRawReadlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadlinkCount(statisticsNfsOpsRawReadlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadlinkCount(statisticsNfsOpsRawReadlinkCount)
	return o
}

// SetStatisticsNfsOpsRawReadlinkCount adds the statisticsNfsOpsRawReadlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadlinkCount(statisticsNfsOpsRawReadlinkCount *int64) {
	o.StatisticsNfsOpsRawReadlinkCount = statisticsNfsOpsRawReadlinkCount
}

// WithStatisticsNfsOpsRawReadlinkTotalTime adds the statisticsNfsOpsRawReadlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawReadlinkTotalTime(statisticsNfsOpsRawReadlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawReadlinkTotalTime(statisticsNfsOpsRawReadlinkTotalTime)
	return o
}

// SetStatisticsNfsOpsRawReadlinkTotalTime adds the statisticsNfsOpsRawReadlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawReadlinkTotalTime(statisticsNfsOpsRawReadlinkTotalTime *int64) {
	o.StatisticsNfsOpsRawReadlinkTotalTime = statisticsNfsOpsRawReadlinkTotalTime
}

// WithStatisticsNfsOpsRawRenameCount adds the statisticsNfsOpsRawRenameCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawRenameCount(statisticsNfsOpsRawRenameCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawRenameCount(statisticsNfsOpsRawRenameCount)
	return o
}

// SetStatisticsNfsOpsRawRenameCount adds the statisticsNfsOpsRawRenameCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawRenameCount(statisticsNfsOpsRawRenameCount *int64) {
	o.StatisticsNfsOpsRawRenameCount = statisticsNfsOpsRawRenameCount
}

// WithStatisticsNfsOpsRawRenameTotalTime adds the statisticsNfsOpsRawRenameTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawRenameTotalTime(statisticsNfsOpsRawRenameTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawRenameTotalTime(statisticsNfsOpsRawRenameTotalTime)
	return o
}

// SetStatisticsNfsOpsRawRenameTotalTime adds the statisticsNfsOpsRawRenameTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawRenameTotalTime(statisticsNfsOpsRawRenameTotalTime *int64) {
	o.StatisticsNfsOpsRawRenameTotalTime = statisticsNfsOpsRawRenameTotalTime
}

// WithStatisticsNfsOpsRawSetattrCount adds the statisticsNfsOpsRawSetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawSetattrCount(statisticsNfsOpsRawSetattrCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawSetattrCount(statisticsNfsOpsRawSetattrCount)
	return o
}

// SetStatisticsNfsOpsRawSetattrCount adds the statisticsNfsOpsRawSetattrCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawSetattrCount(statisticsNfsOpsRawSetattrCount *int64) {
	o.StatisticsNfsOpsRawSetattrCount = statisticsNfsOpsRawSetattrCount
}

// WithStatisticsNfsOpsRawSetattrTotalTime adds the statisticsNfsOpsRawSetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawSetattrTotalTime(statisticsNfsOpsRawSetattrTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawSetattrTotalTime(statisticsNfsOpsRawSetattrTotalTime)
	return o
}

// SetStatisticsNfsOpsRawSetattrTotalTime adds the statisticsNfsOpsRawSetattrTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawSetattrTotalTime(statisticsNfsOpsRawSetattrTotalTime *int64) {
	o.StatisticsNfsOpsRawSetattrTotalTime = statisticsNfsOpsRawSetattrTotalTime
}

// WithStatisticsNfsOpsRawUnlinkCount adds the statisticsNfsOpsRawUnlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawUnlinkCount(statisticsNfsOpsRawUnlinkCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawUnlinkCount(statisticsNfsOpsRawUnlinkCount)
	return o
}

// SetStatisticsNfsOpsRawUnlinkCount adds the statisticsNfsOpsRawUnlinkCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawUnlinkCount(statisticsNfsOpsRawUnlinkCount *int64) {
	o.StatisticsNfsOpsRawUnlinkCount = statisticsNfsOpsRawUnlinkCount
}

// WithStatisticsNfsOpsRawUnlinkTotalTime adds the statisticsNfsOpsRawUnlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawUnlinkTotalTime(statisticsNfsOpsRawUnlinkTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawUnlinkTotalTime(statisticsNfsOpsRawUnlinkTotalTime)
	return o
}

// SetStatisticsNfsOpsRawUnlinkTotalTime adds the statisticsNfsOpsRawUnlinkTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawUnlinkTotalTime(statisticsNfsOpsRawUnlinkTotalTime *int64) {
	o.StatisticsNfsOpsRawUnlinkTotalTime = statisticsNfsOpsRawUnlinkTotalTime
}

// WithStatisticsNfsOpsRawWatchCount adds the statisticsNfsOpsRawWatchCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWatchCount(statisticsNfsOpsRawWatchCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWatchCount(statisticsNfsOpsRawWatchCount)
	return o
}

// SetStatisticsNfsOpsRawWatchCount adds the statisticsNfsOpsRawWatchCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWatchCount(statisticsNfsOpsRawWatchCount *int64) {
	o.StatisticsNfsOpsRawWatchCount = statisticsNfsOpsRawWatchCount
}

// WithStatisticsNfsOpsRawWatchTotalTime adds the statisticsNfsOpsRawWatchTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWatchTotalTime(statisticsNfsOpsRawWatchTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWatchTotalTime(statisticsNfsOpsRawWatchTotalTime)
	return o
}

// SetStatisticsNfsOpsRawWatchTotalTime adds the statisticsNfsOpsRawWatchTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWatchTotalTime(statisticsNfsOpsRawWatchTotalTime *int64) {
	o.StatisticsNfsOpsRawWatchTotalTime = statisticsNfsOpsRawWatchTotalTime
}

// WithStatisticsNfsOpsRawWriteCount adds the statisticsNfsOpsRawWriteCount to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteCount(statisticsNfsOpsRawWriteCount *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteCount(statisticsNfsOpsRawWriteCount)
	return o
}

// SetStatisticsNfsOpsRawWriteCount adds the statisticsNfsOpsRawWriteCount to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteCount(statisticsNfsOpsRawWriteCount *int64) {
	o.StatisticsNfsOpsRawWriteCount = statisticsNfsOpsRawWriteCount
}

// WithStatisticsNfsOpsRawWriteTotalTime adds the statisticsNfsOpsRawWriteTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteTotalTime(statisticsNfsOpsRawWriteTotalTime *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteTotalTime(statisticsNfsOpsRawWriteTotalTime)
	return o
}

// SetStatisticsNfsOpsRawWriteTotalTime adds the statisticsNfsOpsRawWriteTotalTime to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteTotalTime(statisticsNfsOpsRawWriteTotalTime *int64) {
	o.StatisticsNfsOpsRawWriteTotalTime = statisticsNfsOpsRawWriteTotalTime
}

// WithStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts adds the statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts)
	return o
}

// SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts adds the statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts *int64) {
	o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts = statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts
}

// WithStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels adds the statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels)
	return o
}

// SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels adds the statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels *string) {
	o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels = statisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels
}

// WithStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts adds the statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts)
	return o
}

// SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts adds the statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts *int64) {
	o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts = statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts
}

// WithStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels adds the statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels *string) *VolumeCollectionGetParams {
	o.SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels)
	return o
}

// SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels adds the statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels(statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels *string) {
	o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels = statisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels
}

// WithStatisticsStatus adds the statisticsStatus to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsStatus(statisticsStatus *string) *VolumeCollectionGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) *VolumeCollectionGetParams {
	o.SetStatisticsThroughputRawOther(statisticsThroughputRawOther)
	return o
}

// SetStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) {
	o.StatisticsThroughputRawOther = statisticsThroughputRawOther
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *VolumeCollectionGetParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *VolumeCollectionGetParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *VolumeCollectionGetParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *VolumeCollectionGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithStatus adds the status to the volume collection get params
func (o *VolumeCollectionGetParams) WithStatus(status *string) *VolumeCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the volume collection get params
func (o *VolumeCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithStyle adds the style to the volume collection get params
func (o *VolumeCollectionGetParams) WithStyle(style *string) *VolumeCollectionGetParams {
	o.SetStyle(style)
	return o
}

// SetStyle adds the style to the volume collection get params
func (o *VolumeCollectionGetParams) SetStyle(style *string) {
	o.Style = style
}

// WithSvmName adds the svmName to the volume collection get params
func (o *VolumeCollectionGetParams) WithSvmName(svmName *string) *VolumeCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the volume collection get params
func (o *VolumeCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the volume collection get params
func (o *VolumeCollectionGetParams) WithSvmUUID(svmUUID *string) *VolumeCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTieringMinCoolingDays adds the tieringMinCoolingDays to the volume collection get params
func (o *VolumeCollectionGetParams) WithTieringMinCoolingDays(tieringMinCoolingDays *int64) *VolumeCollectionGetParams {
	o.SetTieringMinCoolingDays(tieringMinCoolingDays)
	return o
}

// SetTieringMinCoolingDays adds the tieringMinCoolingDays to the volume collection get params
func (o *VolumeCollectionGetParams) SetTieringMinCoolingDays(tieringMinCoolingDays *int64) {
	o.TieringMinCoolingDays = tieringMinCoolingDays
}

// WithTieringObjectTags adds the tieringObjectTags to the volume collection get params
func (o *VolumeCollectionGetParams) WithTieringObjectTags(tieringObjectTags *string) *VolumeCollectionGetParams {
	o.SetTieringObjectTags(tieringObjectTags)
	return o
}

// SetTieringObjectTags adds the tieringObjectTags to the volume collection get params
func (o *VolumeCollectionGetParams) SetTieringObjectTags(tieringObjectTags *string) {
	o.TieringObjectTags = tieringObjectTags
}

// WithTieringPolicy adds the tieringPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) WithTieringPolicy(tieringPolicy *string) *VolumeCollectionGetParams {
	o.SetTieringPolicy(tieringPolicy)
	return o
}

// SetTieringPolicy adds the tieringPolicy to the volume collection get params
func (o *VolumeCollectionGetParams) SetTieringPolicy(tieringPolicy *string) {
	o.TieringPolicy = tieringPolicy
}

// WithType adds the typeVar to the volume collection get params
func (o *VolumeCollectionGetParams) WithType(typeVar *string) *VolumeCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the volume collection get params
func (o *VolumeCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the volume collection get params
func (o *VolumeCollectionGetParams) WithUUID(uuid *string) *VolumeCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the volume collection get params
func (o *VolumeCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the volume collection get params
func (o *VolumeCollectionGetParams) WithValidateOnly(validateOnly *bool) *VolumeCollectionGetParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the volume collection get params
func (o *VolumeCollectionGetParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Tags != nil {

		// query param _tags
		var qrTags string

		if o.Tags != nil {
			qrTags = *o.Tags
		}
		qTags := qrTags
		if qTags != "" {

			if err := r.SetQueryParam("_tags", qTags); err != nil {
				return err
			}
		}
	}

	if o.AccessTimeEnabled != nil {

		// query param access_time_enabled
		var qrAccessTimeEnabled bool

		if o.AccessTimeEnabled != nil {
			qrAccessTimeEnabled = *o.AccessTimeEnabled
		}
		qAccessTimeEnabled := swag.FormatBool(qrAccessTimeEnabled)
		if qAccessTimeEnabled != "" {

			if err := r.SetQueryParam("access_time_enabled", qAccessTimeEnabled); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingNoticesCode != nil {

		// query param activity_tracking.notices.code
		var qrActivityTrackingNoticesCode string

		if o.ActivityTrackingNoticesCode != nil {
			qrActivityTrackingNoticesCode = *o.ActivityTrackingNoticesCode
		}
		qActivityTrackingNoticesCode := qrActivityTrackingNoticesCode
		if qActivityTrackingNoticesCode != "" {

			if err := r.SetQueryParam("activity_tracking.notices.code", qActivityTrackingNoticesCode); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingNoticesMessage != nil {

		// query param activity_tracking.notices.message
		var qrActivityTrackingNoticesMessage string

		if o.ActivityTrackingNoticesMessage != nil {
			qrActivityTrackingNoticesMessage = *o.ActivityTrackingNoticesMessage
		}
		qActivityTrackingNoticesMessage := qrActivityTrackingNoticesMessage
		if qActivityTrackingNoticesMessage != "" {

			if err := r.SetQueryParam("activity_tracking.notices.message", qActivityTrackingNoticesMessage); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingState != nil {

		// query param activity_tracking.state
		var qrActivityTrackingState string

		if o.ActivityTrackingState != nil {
			qrActivityTrackingState = *o.ActivityTrackingState
		}
		qActivityTrackingState := qrActivityTrackingState
		if qActivityTrackingState != "" {

			if err := r.SetQueryParam("activity_tracking.state", qActivityTrackingState); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingSupported != nil {

		// query param activity_tracking.supported
		var qrActivityTrackingSupported bool

		if o.ActivityTrackingSupported != nil {
			qrActivityTrackingSupported = *o.ActivityTrackingSupported
		}
		qActivityTrackingSupported := swag.FormatBool(qrActivityTrackingSupported)
		if qActivityTrackingSupported != "" {

			if err := r.SetQueryParam("activity_tracking.supported", qActivityTrackingSupported); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingUnsupportedReasonCode != nil {

		// query param activity_tracking.unsupported_reason.code
		var qrActivityTrackingUnsupportedReasonCode string

		if o.ActivityTrackingUnsupportedReasonCode != nil {
			qrActivityTrackingUnsupportedReasonCode = *o.ActivityTrackingUnsupportedReasonCode
		}
		qActivityTrackingUnsupportedReasonCode := qrActivityTrackingUnsupportedReasonCode
		if qActivityTrackingUnsupportedReasonCode != "" {

			if err := r.SetQueryParam("activity_tracking.unsupported_reason.code", qActivityTrackingUnsupportedReasonCode); err != nil {
				return err
			}
		}
	}

	if o.ActivityTrackingUnsupportedReasonMessage != nil {

		// query param activity_tracking.unsupported_reason.message
		var qrActivityTrackingUnsupportedReasonMessage string

		if o.ActivityTrackingUnsupportedReasonMessage != nil {
			qrActivityTrackingUnsupportedReasonMessage = *o.ActivityTrackingUnsupportedReasonMessage
		}
		qActivityTrackingUnsupportedReasonMessage := qrActivityTrackingUnsupportedReasonMessage
		if qActivityTrackingUnsupportedReasonMessage != "" {

			if err := r.SetQueryParam("activity_tracking.unsupported_reason.message", qActivityTrackingUnsupportedReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.AggregatesName != nil {

		// query param aggregates.name
		var qrAggregatesName string

		if o.AggregatesName != nil {
			qrAggregatesName = *o.AggregatesName
		}
		qAggregatesName := qrAggregatesName
		if qAggregatesName != "" {

			if err := r.SetQueryParam("aggregates.name", qAggregatesName); err != nil {
				return err
			}
		}
	}

	if o.AggregatesUUID != nil {

		// query param aggregates.uuid
		var qrAggregatesUUID string

		if o.AggregatesUUID != nil {
			qrAggregatesUUID = *o.AggregatesUUID
		}
		qAggregatesUUID := qrAggregatesUUID
		if qAggregatesUUID != "" {

			if err := r.SetQueryParam("aggregates.uuid", qAggregatesUUID); err != nil {
				return err
			}
		}
	}

	if o.AggressiveReadaheadMode != nil {

		// query param aggressive_readahead_mode
		var qrAggressiveReadaheadMode string

		if o.AggressiveReadaheadMode != nil {
			qrAggressiveReadaheadMode = *o.AggressiveReadaheadMode
		}
		qAggressiveReadaheadMode := qrAggressiveReadaheadMode
		if qAggressiveReadaheadMode != "" {

			if err := r.SetQueryParam("aggressive_readahead_mode", qAggressiveReadaheadMode); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric != nil {

		// query param analytics.by_accessed_time.bytes_used.aged_data_metric
		var qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric float64

		if o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric != nil {
			qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric = *o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric
		}
		qAnalyticsByAccessedTimeBytesUsedAgedDataMetric := swag.FormatFloat64(qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric)
		if qAnalyticsByAccessedTimeBytesUsedAgedDataMetric != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.aged_data_metric", qAnalyticsByAccessedTimeBytesUsedAgedDataMetric); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedLabels != nil {

		// query param analytics.by_accessed_time.bytes_used.labels
		var qrAnalyticsByAccessedTimeBytesUsedLabels string

		if o.AnalyticsByAccessedTimeBytesUsedLabels != nil {
			qrAnalyticsByAccessedTimeBytesUsedLabels = *o.AnalyticsByAccessedTimeBytesUsedLabels
		}
		qAnalyticsByAccessedTimeBytesUsedLabels := qrAnalyticsByAccessedTimeBytesUsedLabels
		if qAnalyticsByAccessedTimeBytesUsedLabels != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.labels", qAnalyticsByAccessedTimeBytesUsedLabels); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedNewestLabel != nil {

		// query param analytics.by_accessed_time.bytes_used.newest_label
		var qrAnalyticsByAccessedTimeBytesUsedNewestLabel string

		if o.AnalyticsByAccessedTimeBytesUsedNewestLabel != nil {
			qrAnalyticsByAccessedTimeBytesUsedNewestLabel = *o.AnalyticsByAccessedTimeBytesUsedNewestLabel
		}
		qAnalyticsByAccessedTimeBytesUsedNewestLabel := qrAnalyticsByAccessedTimeBytesUsedNewestLabel
		if qAnalyticsByAccessedTimeBytesUsedNewestLabel != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.newest_label", qAnalyticsByAccessedTimeBytesUsedNewestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedOldestLabel != nil {

		// query param analytics.by_accessed_time.bytes_used.oldest_label
		var qrAnalyticsByAccessedTimeBytesUsedOldestLabel string

		if o.AnalyticsByAccessedTimeBytesUsedOldestLabel != nil {
			qrAnalyticsByAccessedTimeBytesUsedOldestLabel = *o.AnalyticsByAccessedTimeBytesUsedOldestLabel
		}
		qAnalyticsByAccessedTimeBytesUsedOldestLabel := qrAnalyticsByAccessedTimeBytesUsedOldestLabel
		if qAnalyticsByAccessedTimeBytesUsedOldestLabel != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.oldest_label", qAnalyticsByAccessedTimeBytesUsedOldestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedPercentages != nil {

		// query param analytics.by_accessed_time.bytes_used.percentages
		var qrAnalyticsByAccessedTimeBytesUsedPercentages float64

		if o.AnalyticsByAccessedTimeBytesUsedPercentages != nil {
			qrAnalyticsByAccessedTimeBytesUsedPercentages = *o.AnalyticsByAccessedTimeBytesUsedPercentages
		}
		qAnalyticsByAccessedTimeBytesUsedPercentages := swag.FormatFloat64(qrAnalyticsByAccessedTimeBytesUsedPercentages)
		if qAnalyticsByAccessedTimeBytesUsedPercentages != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.percentages", qAnalyticsByAccessedTimeBytesUsedPercentages); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedValues != nil {

		// query param analytics.by_accessed_time.bytes_used.values
		var qrAnalyticsByAccessedTimeBytesUsedValues int64

		if o.AnalyticsByAccessedTimeBytesUsedValues != nil {
			qrAnalyticsByAccessedTimeBytesUsedValues = *o.AnalyticsByAccessedTimeBytesUsedValues
		}
		qAnalyticsByAccessedTimeBytesUsedValues := swag.FormatInt64(qrAnalyticsByAccessedTimeBytesUsedValues)
		if qAnalyticsByAccessedTimeBytesUsedValues != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.values", qAnalyticsByAccessedTimeBytesUsedValues); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric != nil {

		// query param analytics.by_modified_time.bytes_used.aged_data_metric
		var qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric float64

		if o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric != nil {
			qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric = *o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric
		}
		qAnalyticsByModifiedTimeBytesUsedAgedDataMetric := swag.FormatFloat64(qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric)
		if qAnalyticsByModifiedTimeBytesUsedAgedDataMetric != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.aged_data_metric", qAnalyticsByModifiedTimeBytesUsedAgedDataMetric); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedLabels != nil {

		// query param analytics.by_modified_time.bytes_used.labels
		var qrAnalyticsByModifiedTimeBytesUsedLabels string

		if o.AnalyticsByModifiedTimeBytesUsedLabels != nil {
			qrAnalyticsByModifiedTimeBytesUsedLabels = *o.AnalyticsByModifiedTimeBytesUsedLabels
		}
		qAnalyticsByModifiedTimeBytesUsedLabels := qrAnalyticsByModifiedTimeBytesUsedLabels
		if qAnalyticsByModifiedTimeBytesUsedLabels != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.labels", qAnalyticsByModifiedTimeBytesUsedLabels); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedNewestLabel != nil {

		// query param analytics.by_modified_time.bytes_used.newest_label
		var qrAnalyticsByModifiedTimeBytesUsedNewestLabel string

		if o.AnalyticsByModifiedTimeBytesUsedNewestLabel != nil {
			qrAnalyticsByModifiedTimeBytesUsedNewestLabel = *o.AnalyticsByModifiedTimeBytesUsedNewestLabel
		}
		qAnalyticsByModifiedTimeBytesUsedNewestLabel := qrAnalyticsByModifiedTimeBytesUsedNewestLabel
		if qAnalyticsByModifiedTimeBytesUsedNewestLabel != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.newest_label", qAnalyticsByModifiedTimeBytesUsedNewestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedOldestLabel != nil {

		// query param analytics.by_modified_time.bytes_used.oldest_label
		var qrAnalyticsByModifiedTimeBytesUsedOldestLabel string

		if o.AnalyticsByModifiedTimeBytesUsedOldestLabel != nil {
			qrAnalyticsByModifiedTimeBytesUsedOldestLabel = *o.AnalyticsByModifiedTimeBytesUsedOldestLabel
		}
		qAnalyticsByModifiedTimeBytesUsedOldestLabel := qrAnalyticsByModifiedTimeBytesUsedOldestLabel
		if qAnalyticsByModifiedTimeBytesUsedOldestLabel != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.oldest_label", qAnalyticsByModifiedTimeBytesUsedOldestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedPercentages != nil {

		// query param analytics.by_modified_time.bytes_used.percentages
		var qrAnalyticsByModifiedTimeBytesUsedPercentages float64

		if o.AnalyticsByModifiedTimeBytesUsedPercentages != nil {
			qrAnalyticsByModifiedTimeBytesUsedPercentages = *o.AnalyticsByModifiedTimeBytesUsedPercentages
		}
		qAnalyticsByModifiedTimeBytesUsedPercentages := swag.FormatFloat64(qrAnalyticsByModifiedTimeBytesUsedPercentages)
		if qAnalyticsByModifiedTimeBytesUsedPercentages != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.percentages", qAnalyticsByModifiedTimeBytesUsedPercentages); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedValues != nil {

		// query param analytics.by_modified_time.bytes_used.values
		var qrAnalyticsByModifiedTimeBytesUsedValues int64

		if o.AnalyticsByModifiedTimeBytesUsedValues != nil {
			qrAnalyticsByModifiedTimeBytesUsedValues = *o.AnalyticsByModifiedTimeBytesUsedValues
		}
		qAnalyticsByModifiedTimeBytesUsedValues := swag.FormatInt64(qrAnalyticsByModifiedTimeBytesUsedValues)
		if qAnalyticsByModifiedTimeBytesUsedValues != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.values", qAnalyticsByModifiedTimeBytesUsedValues); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsBytesUsed != nil {

		// query param analytics.bytes_used
		var qrAnalyticsBytesUsed int64

		if o.AnalyticsBytesUsed != nil {
			qrAnalyticsBytesUsed = *o.AnalyticsBytesUsed
		}
		qAnalyticsBytesUsed := swag.FormatInt64(qrAnalyticsBytesUsed)
		if qAnalyticsBytesUsed != "" {

			if err := r.SetQueryParam("analytics.bytes_used", qAnalyticsBytesUsed); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsFileCount != nil {

		// query param analytics.file_count
		var qrAnalyticsFileCount int64

		if o.AnalyticsFileCount != nil {
			qrAnalyticsFileCount = *o.AnalyticsFileCount
		}
		qAnalyticsFileCount := swag.FormatInt64(qrAnalyticsFileCount)
		if qAnalyticsFileCount != "" {

			if err := r.SetQueryParam("analytics.file_count", qAnalyticsFileCount); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsFilesScanned != nil {

		// query param analytics.files_scanned
		var qrAnalyticsFilesScanned int64

		if o.AnalyticsFilesScanned != nil {
			qrAnalyticsFilesScanned = *o.AnalyticsFilesScanned
		}
		qAnalyticsFilesScanned := swag.FormatInt64(qrAnalyticsFilesScanned)
		if qAnalyticsFilesScanned != "" {

			if err := r.SetQueryParam("analytics.files_scanned", qAnalyticsFilesScanned); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsIncompleteData != nil {

		// query param analytics.incomplete_data
		var qrAnalyticsIncompleteData bool

		if o.AnalyticsIncompleteData != nil {
			qrAnalyticsIncompleteData = *o.AnalyticsIncompleteData
		}
		qAnalyticsIncompleteData := swag.FormatBool(qrAnalyticsIncompleteData)
		if qAnalyticsIncompleteData != "" {

			if err := r.SetQueryParam("analytics.incomplete_data", qAnalyticsIncompleteData); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsInitializationState != nil {

		// query param analytics.initialization.state
		var qrAnalyticsInitializationState string

		if o.AnalyticsInitializationState != nil {
			qrAnalyticsInitializationState = *o.AnalyticsInitializationState
		}
		qAnalyticsInitializationState := qrAnalyticsInitializationState
		if qAnalyticsInitializationState != "" {

			if err := r.SetQueryParam("analytics.initialization.state", qAnalyticsInitializationState); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsReportTime != nil {

		// query param analytics.report_time
		var qrAnalyticsReportTime string

		if o.AnalyticsReportTime != nil {
			qrAnalyticsReportTime = *o.AnalyticsReportTime
		}
		qAnalyticsReportTime := qrAnalyticsReportTime
		if qAnalyticsReportTime != "" {

			if err := r.SetQueryParam("analytics.report_time", qAnalyticsReportTime); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsScanProgress != nil {

		// query param analytics.scan_progress
		var qrAnalyticsScanProgress int64

		if o.AnalyticsScanProgress != nil {
			qrAnalyticsScanProgress = *o.AnalyticsScanProgress
		}
		qAnalyticsScanProgress := swag.FormatInt64(qrAnalyticsScanProgress)
		if qAnalyticsScanProgress != "" {

			if err := r.SetQueryParam("analytics.scan_progress", qAnalyticsScanProgress); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsScanThrottleReasonArguments != nil {

		// query param analytics.scan_throttle_reason.arguments
		var qrAnalyticsScanThrottleReasonArguments string

		if o.AnalyticsScanThrottleReasonArguments != nil {
			qrAnalyticsScanThrottleReasonArguments = *o.AnalyticsScanThrottleReasonArguments
		}
		qAnalyticsScanThrottleReasonArguments := qrAnalyticsScanThrottleReasonArguments
		if qAnalyticsScanThrottleReasonArguments != "" {

			if err := r.SetQueryParam("analytics.scan_throttle_reason.arguments", qAnalyticsScanThrottleReasonArguments); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsScanThrottleReasonCode != nil {

		// query param analytics.scan_throttle_reason.code
		var qrAnalyticsScanThrottleReasonCode string

		if o.AnalyticsScanThrottleReasonCode != nil {
			qrAnalyticsScanThrottleReasonCode = *o.AnalyticsScanThrottleReasonCode
		}
		qAnalyticsScanThrottleReasonCode := qrAnalyticsScanThrottleReasonCode
		if qAnalyticsScanThrottleReasonCode != "" {

			if err := r.SetQueryParam("analytics.scan_throttle_reason.code", qAnalyticsScanThrottleReasonCode); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsScanThrottleReasonMessage != nil {

		// query param analytics.scan_throttle_reason.message
		var qrAnalyticsScanThrottleReasonMessage string

		if o.AnalyticsScanThrottleReasonMessage != nil {
			qrAnalyticsScanThrottleReasonMessage = *o.AnalyticsScanThrottleReasonMessage
		}
		qAnalyticsScanThrottleReasonMessage := qrAnalyticsScanThrottleReasonMessage
		if qAnalyticsScanThrottleReasonMessage != "" {

			if err := r.SetQueryParam("analytics.scan_throttle_reason.message", qAnalyticsScanThrottleReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsState != nil {

		// query param analytics.state
		var qrAnalyticsState string

		if o.AnalyticsState != nil {
			qrAnalyticsState = *o.AnalyticsState
		}
		qAnalyticsState := qrAnalyticsState
		if qAnalyticsState != "" {

			if err := r.SetQueryParam("analytics.state", qAnalyticsState); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsSubdirCount != nil {

		// query param analytics.subdir_count
		var qrAnalyticsSubdirCount int64

		if o.AnalyticsSubdirCount != nil {
			qrAnalyticsSubdirCount = *o.AnalyticsSubdirCount
		}
		qAnalyticsSubdirCount := swag.FormatInt64(qrAnalyticsSubdirCount)
		if qAnalyticsSubdirCount != "" {

			if err := r.SetQueryParam("analytics.subdir_count", qAnalyticsSubdirCount); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsSupported != nil {

		// query param analytics.supported
		var qrAnalyticsSupported bool

		if o.AnalyticsSupported != nil {
			qrAnalyticsSupported = *o.AnalyticsSupported
		}
		qAnalyticsSupported := swag.FormatBool(qrAnalyticsSupported)
		if qAnalyticsSupported != "" {

			if err := r.SetQueryParam("analytics.supported", qAnalyticsSupported); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsTotalFiles != nil {

		// query param analytics.total_files
		var qrAnalyticsTotalFiles int64

		if o.AnalyticsTotalFiles != nil {
			qrAnalyticsTotalFiles = *o.AnalyticsTotalFiles
		}
		qAnalyticsTotalFiles := swag.FormatInt64(qrAnalyticsTotalFiles)
		if qAnalyticsTotalFiles != "" {

			if err := r.SetQueryParam("analytics.total_files", qAnalyticsTotalFiles); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsUnsupportedReasonCode != nil {

		// query param analytics.unsupported_reason.code
		var qrAnalyticsUnsupportedReasonCode string

		if o.AnalyticsUnsupportedReasonCode != nil {
			qrAnalyticsUnsupportedReasonCode = *o.AnalyticsUnsupportedReasonCode
		}
		qAnalyticsUnsupportedReasonCode := qrAnalyticsUnsupportedReasonCode
		if qAnalyticsUnsupportedReasonCode != "" {

			if err := r.SetQueryParam("analytics.unsupported_reason.code", qAnalyticsUnsupportedReasonCode); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsUnsupportedReasonMessage != nil {

		// query param analytics.unsupported_reason.message
		var qrAnalyticsUnsupportedReasonMessage string

		if o.AnalyticsUnsupportedReasonMessage != nil {
			qrAnalyticsUnsupportedReasonMessage = *o.AnalyticsUnsupportedReasonMessage
		}
		qAnalyticsUnsupportedReasonMessage := qrAnalyticsUnsupportedReasonMessage
		if qAnalyticsUnsupportedReasonMessage != "" {

			if err := r.SetQueryParam("analytics.unsupported_reason.message", qAnalyticsUnsupportedReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectedBy != nil {

		// query param anti_ransomware.attack_detected_by
		var qrAntiRansomwareAttackDetectedBy string

		if o.AntiRansomwareAttackDetectedBy != nil {
			qrAntiRansomwareAttackDetectedBy = *o.AntiRansomwareAttackDetectedBy
		}
		qAntiRansomwareAttackDetectedBy := qrAntiRansomwareAttackDetectedBy
		if qAntiRansomwareAttackDetectedBy != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detected_by", qAntiRansomwareAttackDetectedBy); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate != nil {

		// query param anti_ransomware.attack_detection_parameters.based_on_file_create_op_rate
		var qrAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate bool

		if o.AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate != nil {
			qrAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate = *o.AntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate
		}
		qAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate)
		if qAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.based_on_file_create_op_rate", qAntiRansomwareAttackDetectionParametersBasedOnFileCreateOpRate); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate != nil {

		// query param anti_ransomware.attack_detection_parameters.based_on_file_delete_op_rate
		var qrAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate bool

		if o.AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate != nil {
			qrAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate = *o.AntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate
		}
		qAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate)
		if qAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.based_on_file_delete_op_rate", qAntiRansomwareAttackDetectionParametersBasedOnFileDeleteOpRate); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate != nil {

		// query param anti_ransomware.attack_detection_parameters.based_on_file_rename_op_rate
		var qrAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate bool

		if o.AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate != nil {
			qrAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate = *o.AntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate
		}
		qAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate)
		if qAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.based_on_file_rename_op_rate", qAntiRansomwareAttackDetectionParametersBasedOnFileRenameOpRate); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate != nil {

		// query param anti_ransomware.attack_detection_parameters.based_on_high_entropy_data_rate
		var qrAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate bool

		if o.AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate != nil {
			qrAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate = *o.AntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate
		}
		qAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate)
		if qAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.based_on_high_entropy_data_rate", qAntiRansomwareAttackDetectionParametersBasedOnHighEntropyDataRate); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension != nil {

		// query param anti_ransomware.attack_detection_parameters.based_on_never_seen_before_file_extension
		var qrAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension bool

		if o.AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension != nil {
			qrAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension = *o.AntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension
		}
		qAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension)
		if qAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.based_on_never_seen_before_file_extension", qAntiRansomwareAttackDetectionParametersBasedOnNeverSeenBeforeFileExtension); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold != nil {

		// query param anti_ransomware.attack_detection_parameters.block_device_auto_learned_encryption_threshold
		var qrAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold int64

		if o.AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold != nil {
			qrAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold = *o.AntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold
		}
		qAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold)
		if qAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.block_device_auto_learned_encryption_threshold", qAntiRansomwareAttackDetectionParametersBlockDeviceAutoLearnedEncryptionThreshold); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent != nil {

		// query param anti_ransomware.attack_detection_parameters.file_create_op_rate_surge_notify_percent
		var qrAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent int64

		if o.AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent != nil {
			qrAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent = *o.AntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent
		}
		qAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent)
		if qAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.file_create_op_rate_surge_notify_percent", qAntiRansomwareAttackDetectionParametersFileCreateOpRateSurgeNotifyPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent != nil {

		// query param anti_ransomware.attack_detection_parameters.file_delete_op_rate_surge_notify_percent
		var qrAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent int64

		if o.AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent != nil {
			qrAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent = *o.AntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent
		}
		qAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent)
		if qAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.file_delete_op_rate_surge_notify_percent", qAntiRansomwareAttackDetectionParametersFileDeleteOpRateSurgeNotifyPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent != nil {

		// query param anti_ransomware.attack_detection_parameters.file_rename_op_rate_surge_notify_percent
		var qrAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent int64

		if o.AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent != nil {
			qrAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent = *o.AntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent
		}
		qAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent)
		if qAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.file_rename_op_rate_surge_notify_percent", qAntiRansomwareAttackDetectionParametersFileRenameOpRateSurgeNotifyPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent != nil {

		// query param anti_ransomware.attack_detection_parameters.high_entropy_data_surge_notify_percent
		var qrAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent int64

		if o.AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent != nil {
			qrAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent = *o.AntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent
		}
		qAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent)
		if qAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.high_entropy_data_surge_notify_percent", qAntiRansomwareAttackDetectionParametersHighEntropyDataSurgeNotifyPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold != nil {

		// query param anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_count_notify_threshold
		var qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold int64

		if o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold != nil {
			qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold = *o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold
		}
		qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold)
		if qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_count_notify_threshold", qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionCountNotifyThreshold); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours != nil {

		// query param anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_duration_in_hours
		var qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours int64

		if o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours != nil {
			qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours = *o.AntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours
		}
		qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours := swag.FormatInt64(qrAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours)
		if qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.never_seen_before_file_extension_duration_in_hours", qAntiRansomwareAttackDetectionParametersNeverSeenBeforeFileExtensionDurationInHours); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions != nil {

		// query param anti_ransomware.attack_detection_parameters.relaxing_popular_file_extensions
		var qrAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions bool

		if o.AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions != nil {
			qrAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions = *o.AntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions
		}
		qAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions := swag.FormatBool(qrAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions)
		if qAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_detection_parameters.relaxing_popular_file_extensions", qAntiRansomwareAttackDetectionParametersRelaxingPopularFileExtensions); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackProbability != nil {

		// query param anti_ransomware.attack_probability
		var qrAntiRansomwareAttackProbability string

		if o.AntiRansomwareAttackProbability != nil {
			qrAntiRansomwareAttackProbability = *o.AntiRansomwareAttackProbability
		}
		qAntiRansomwareAttackProbability := qrAntiRansomwareAttackProbability
		if qAntiRansomwareAttackProbability != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_probability", qAntiRansomwareAttackProbability); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAttackReportsTime != nil {

		// query param anti_ransomware.attack_reports.time
		var qrAntiRansomwareAttackReportsTime string

		if o.AntiRansomwareAttackReportsTime != nil {
			qrAntiRansomwareAttackReportsTime = *o.AntiRansomwareAttackReportsTime
		}
		qAntiRansomwareAttackReportsTime := qrAntiRansomwareAttackReportsTime
		if qAntiRansomwareAttackReportsTime != "" {

			if err := r.SetQueryParam("anti_ransomware.attack_reports.time", qAntiRansomwareAttackReportsTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareBlockDeviceDetectionStartTime != nil {

		// query param anti_ransomware.block_device_detection_start_time
		var qrAntiRansomwareBlockDeviceDetectionStartTime string

		if o.AntiRansomwareBlockDeviceDetectionStartTime != nil {
			qrAntiRansomwareBlockDeviceDetectionStartTime = *o.AntiRansomwareBlockDeviceDetectionStartTime
		}
		qAntiRansomwareBlockDeviceDetectionStartTime := qrAntiRansomwareBlockDeviceDetectionStartTime
		if qAntiRansomwareBlockDeviceDetectionStartTime != "" {

			if err := r.SetQueryParam("anti_ransomware.block_device_detection_start_time", qAntiRansomwareBlockDeviceDetectionStartTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareBlockDeviceDetectionState != nil {

		// query param anti_ransomware.block_device_detection_state
		var qrAntiRansomwareBlockDeviceDetectionState string

		if o.AntiRansomwareBlockDeviceDetectionState != nil {
			qrAntiRansomwareBlockDeviceDetectionState = *o.AntiRansomwareBlockDeviceDetectionState
		}
		qAntiRansomwareBlockDeviceDetectionState := qrAntiRansomwareBlockDeviceDetectionState
		if qAntiRansomwareBlockDeviceDetectionState != "" {

			if err := r.SetQueryParam("anti_ransomware.block_device_detection_state", qAntiRansomwareBlockDeviceDetectionState); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareClearSuspectPhase != nil {

		// query param anti_ransomware.clear_suspect.phase
		var qrAntiRansomwareClearSuspectPhase string

		if o.AntiRansomwareClearSuspectPhase != nil {
			qrAntiRansomwareClearSuspectPhase = *o.AntiRansomwareClearSuspectPhase
		}
		qAntiRansomwareClearSuspectPhase := qrAntiRansomwareClearSuspectPhase
		if qAntiRansomwareClearSuspectPhase != "" {

			if err := r.SetQueryParam("anti_ransomware.clear_suspect.phase", qAntiRansomwareClearSuspectPhase); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareClearSuspectStartTime != nil {

		// query param anti_ransomware.clear_suspect.start_time
		var qrAntiRansomwareClearSuspectStartTime string

		if o.AntiRansomwareClearSuspectStartTime != nil {
			qrAntiRansomwareClearSuspectStartTime = *o.AntiRansomwareClearSuspectStartTime
		}
		qAntiRansomwareClearSuspectStartTime := qrAntiRansomwareClearSuspectStartTime
		if qAntiRansomwareClearSuspectStartTime != "" {

			if err := r.SetQueryParam("anti_ransomware.clear_suspect.start_time", qAntiRansomwareClearSuspectStartTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareDryRunStartTime != nil {

		// query param anti_ransomware.dry_run_start_time
		var qrAntiRansomwareDryRunStartTime string

		if o.AntiRansomwareDryRunStartTime != nil {
			qrAntiRansomwareDryRunStartTime = *o.AntiRansomwareDryRunStartTime
		}
		qAntiRansomwareDryRunStartTime := qrAntiRansomwareDryRunStartTime
		if qAntiRansomwareDryRunStartTime != "" {

			if err := r.SetQueryParam("anti_ransomware.dry_run_start_time", qAntiRansomwareDryRunStartTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen != nil {

		// query param anti_ransomware.event_log.is_enabled_on_new_file_extension_seen
		var qrAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen bool

		if o.AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen != nil {
			qrAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen = *o.AntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen
		}
		qAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen := swag.FormatBool(qrAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen)
		if qAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen != "" {

			if err := r.SetQueryParam("anti_ransomware.event_log.is_enabled_on_new_file_extension_seen", qAntiRansomwareEventLogIsEnabledOnNewFileExtensionSeen); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation != nil {

		// query param anti_ransomware.event_log.is_enabled_on_snapshot_copy_creation
		var qrAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation bool

		if o.AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation != nil {
			qrAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation = *o.AntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation
		}
		qAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation := swag.FormatBool(qrAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation)
		if qAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation != "" {

			if err := r.SetQueryParam("anti_ransomware.event_log.is_enabled_on_snapshot_copy_creation", qAntiRansomwareEventLogIsEnabledOnSnapshotCopyCreation); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSpaceSnapshotCount != nil {

		// query param anti_ransomware.space.snapshot_count
		var qrAntiRansomwareSpaceSnapshotCount int64

		if o.AntiRansomwareSpaceSnapshotCount != nil {
			qrAntiRansomwareSpaceSnapshotCount = *o.AntiRansomwareSpaceSnapshotCount
		}
		qAntiRansomwareSpaceSnapshotCount := swag.FormatInt64(qrAntiRansomwareSpaceSnapshotCount)
		if qAntiRansomwareSpaceSnapshotCount != "" {

			if err := r.SetQueryParam("anti_ransomware.space.snapshot_count", qAntiRansomwareSpaceSnapshotCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSpaceUsed != nil {

		// query param anti_ransomware.space.used
		var qrAntiRansomwareSpaceUsed int64

		if o.AntiRansomwareSpaceUsed != nil {
			qrAntiRansomwareSpaceUsed = *o.AntiRansomwareSpaceUsed
		}
		qAntiRansomwareSpaceUsed := swag.FormatInt64(qrAntiRansomwareSpaceUsed)
		if qAntiRansomwareSpaceUsed != "" {

			if err := r.SetQueryParam("anti_ransomware.space.used", qAntiRansomwareSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSpaceUsedByLogs != nil {

		// query param anti_ransomware.space.used_by_logs
		var qrAntiRansomwareSpaceUsedByLogs int64

		if o.AntiRansomwareSpaceUsedByLogs != nil {
			qrAntiRansomwareSpaceUsedByLogs = *o.AntiRansomwareSpaceUsedByLogs
		}
		qAntiRansomwareSpaceUsedByLogs := swag.FormatInt64(qrAntiRansomwareSpaceUsedByLogs)
		if qAntiRansomwareSpaceUsedByLogs != "" {

			if err := r.SetQueryParam("anti_ransomware.space.used_by_logs", qAntiRansomwareSpaceUsedByLogs); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSpaceUsedBySnapshots != nil {

		// query param anti_ransomware.space.used_by_snapshots
		var qrAntiRansomwareSpaceUsedBySnapshots int64

		if o.AntiRansomwareSpaceUsedBySnapshots != nil {
			qrAntiRansomwareSpaceUsedBySnapshots = *o.AntiRansomwareSpaceUsedBySnapshots
		}
		qAntiRansomwareSpaceUsedBySnapshots := swag.FormatInt64(qrAntiRansomwareSpaceUsedBySnapshots)
		if qAntiRansomwareSpaceUsedBySnapshots != "" {

			if err := r.SetQueryParam("anti_ransomware.space.used_by_snapshots", qAntiRansomwareSpaceUsedBySnapshots); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareState != nil {

		// query param anti_ransomware.state
		var qrAntiRansomwareState string

		if o.AntiRansomwareState != nil {
			qrAntiRansomwareState = *o.AntiRansomwareState
		}
		qAntiRansomwareState := qrAntiRansomwareState
		if qAntiRansomwareState != "" {

			if err := r.SetQueryParam("anti_ransomware.state", qAntiRansomwareState); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeAsNormal != nil {

		// query param anti_ransomware.surge_as_normal
		var qrAntiRansomwareSurgeAsNormal bool

		if o.AntiRansomwareSurgeAsNormal != nil {
			qrAntiRansomwareSurgeAsNormal = *o.AntiRansomwareSurgeAsNormal
		}
		qAntiRansomwareSurgeAsNormal := swag.FormatBool(qrAntiRansomwareSurgeAsNormal)
		if qAntiRansomwareSurgeAsNormal != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_as_normal", qAntiRansomwareSurgeAsNormal); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.surge_usage.file_create_peak_rate_per_minute
		var qrAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute = *o.AntiRansomwareSurgeUsageFileCreatePeakRatePerMinute
		}
		qAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute)
		if qAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.file_create_peak_rate_per_minute", qAntiRansomwareSurgeUsageFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.surge_usage.file_delete_peak_rate_per_minute
		var qrAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute = *o.AntiRansomwareSurgeUsageFileDeletePeakRatePerMinute
		}
		qAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute)
		if qAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.file_delete_peak_rate_per_minute", qAntiRansomwareSurgeUsageFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.surge_usage.file_rename_peak_rate_per_minute
		var qrAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute = *o.AntiRansomwareSurgeUsageFileRenamePeakRatePerMinute
		}
		qAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute)
		if qAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.file_rename_peak_rate_per_minute", qAntiRansomwareSurgeUsageFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.surge_usage.high_entropy_data_write_peak_percent
		var qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent = *o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent)
		if qAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.high_entropy_data_write_peak_percent", qAntiRansomwareSurgeUsageHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareSurgeUsageHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSurgeUsageTime != nil {

		// query param anti_ransomware.surge_usage.time
		var qrAntiRansomwareSurgeUsageTime string

		if o.AntiRansomwareSurgeUsageTime != nil {
			qrAntiRansomwareSurgeUsageTime = *o.AntiRansomwareSurgeUsageTime
		}
		qAntiRansomwareSurgeUsageTime := qrAntiRansomwareSurgeUsageTime
		if qAntiRansomwareSurgeUsageTime != "" {

			if err := r.SetQueryParam("anti_ransomware.surge_usage.time", qAntiRansomwareSurgeUsageTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSuspectFilesCount != nil {

		// query param anti_ransomware.suspect_files.count
		var qrAntiRansomwareSuspectFilesCount int64

		if o.AntiRansomwareSuspectFilesCount != nil {
			qrAntiRansomwareSuspectFilesCount = *o.AntiRansomwareSuspectFilesCount
		}
		qAntiRansomwareSuspectFilesCount := swag.FormatInt64(qrAntiRansomwareSuspectFilesCount)
		if qAntiRansomwareSuspectFilesCount != "" {

			if err := r.SetQueryParam("anti_ransomware.suspect_files.count", qAntiRansomwareSuspectFilesCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSuspectFilesEntropy != nil {

		// query param anti_ransomware.suspect_files.entropy
		var qrAntiRansomwareSuspectFilesEntropy string

		if o.AntiRansomwareSuspectFilesEntropy != nil {
			qrAntiRansomwareSuspectFilesEntropy = *o.AntiRansomwareSuspectFilesEntropy
		}
		qAntiRansomwareSuspectFilesEntropy := qrAntiRansomwareSuspectFilesEntropy
		if qAntiRansomwareSuspectFilesEntropy != "" {

			if err := r.SetQueryParam("anti_ransomware.suspect_files.entropy", qAntiRansomwareSuspectFilesEntropy); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareSuspectFilesFormat != nil {

		// query param anti_ransomware.suspect_files.format
		var qrAntiRansomwareSuspectFilesFormat string

		if o.AntiRansomwareSuspectFilesFormat != nil {
			qrAntiRansomwareSuspectFilesFormat = *o.AntiRansomwareSuspectFilesFormat
		}
		qAntiRansomwareSuspectFilesFormat := qrAntiRansomwareSuspectFilesFormat
		if qAntiRansomwareSuspectFilesFormat != "" {

			if err := r.SetQueryParam("anti_ransomware.suspect_files.format", qAntiRansomwareSuspectFilesFormat); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.typical_usage.file_create_peak_rate_per_minute
		var qrAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute = *o.AntiRansomwareTypicalUsageFileCreatePeakRatePerMinute
		}
		qAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute)
		if qAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.typical_usage.file_create_peak_rate_per_minute", qAntiRansomwareTypicalUsageFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.typical_usage.file_delete_peak_rate_per_minute
		var qrAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute = *o.AntiRansomwareTypicalUsageFileDeletePeakRatePerMinute
		}
		qAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute)
		if qAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.typical_usage.file_delete_peak_rate_per_minute", qAntiRansomwareTypicalUsageFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.typical_usage.file_rename_peak_rate_per_minute
		var qrAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute = *o.AntiRansomwareTypicalUsageFileRenamePeakRatePerMinute
		}
		qAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute)
		if qAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.typical_usage.file_rename_peak_rate_per_minute", qAntiRansomwareTypicalUsageFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.typical_usage.high_entropy_data_write_peak_percent
		var qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent = *o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent)
		if qAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.typical_usage.high_entropy_data_write_peak_percent", qAntiRansomwareTypicalUsageHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareTypicalUsageHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareUpdateBaselineFromSurge != nil {

		// query param anti_ransomware.update_baseline_from_surge
		var qrAntiRansomwareUpdateBaselineFromSurge bool

		if o.AntiRansomwareUpdateBaselineFromSurge != nil {
			qrAntiRansomwareUpdateBaselineFromSurge = *o.AntiRansomwareUpdateBaselineFromSurge
		}
		qAntiRansomwareUpdateBaselineFromSurge := swag.FormatBool(qrAntiRansomwareUpdateBaselineFromSurge)
		if qAntiRansomwareUpdateBaselineFromSurge != "" {

			if err := r.SetQueryParam("anti_ransomware.update_baseline_from_surge", qAntiRansomwareUpdateBaselineFromSurge); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadFileExtensionTypesCount != nil {

		// query param anti_ransomware.workload.file_extension_types_count
		var qrAntiRansomwareWorkloadFileExtensionTypesCount int64

		if o.AntiRansomwareWorkloadFileExtensionTypesCount != nil {
			qrAntiRansomwareWorkloadFileExtensionTypesCount = *o.AntiRansomwareWorkloadFileExtensionTypesCount
		}
		qAntiRansomwareWorkloadFileExtensionTypesCount := swag.FormatInt64(qrAntiRansomwareWorkloadFileExtensionTypesCount)
		if qAntiRansomwareWorkloadFileExtensionTypesCount != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.file_extension_types_count", qAntiRansomwareWorkloadFileExtensionTypesCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadFileExtensionsObserved != nil {

		// query param anti_ransomware.workload.file_extensions_observed
		var qrAntiRansomwareWorkloadFileExtensionsObserved string

		if o.AntiRansomwareWorkloadFileExtensionsObserved != nil {
			qrAntiRansomwareWorkloadFileExtensionsObserved = *o.AntiRansomwareWorkloadFileExtensionsObserved
		}
		qAntiRansomwareWorkloadFileExtensionsObserved := qrAntiRansomwareWorkloadFileExtensionsObserved
		if qAntiRansomwareWorkloadFileExtensionsObserved != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.file_extensions_observed", qAntiRansomwareWorkloadFileExtensionsObserved); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.historical_statistics.file_create_peak_rate_per_minute
		var qrAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute = *o.AntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute
		}
		qAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute)
		if qAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.historical_statistics.file_create_peak_rate_per_minute", qAntiRansomwareWorkloadHistoricalStatisticsFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.historical_statistics.file_delete_peak_rate_per_minute
		var qrAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute = *o.AntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute
		}
		qAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute)
		if qAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.historical_statistics.file_delete_peak_rate_per_minute", qAntiRansomwareWorkloadHistoricalStatisticsFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.historical_statistics.file_rename_peak_rate_per_minute
		var qrAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute = *o.AntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute
		}
		qAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute)
		if qAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.historical_statistics.file_rename_peak_rate_per_minute", qAntiRansomwareWorkloadHistoricalStatisticsFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_percent
		var qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent = *o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent)
		if qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_percent", qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.historical_statistics.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareWorkloadHistoricalStatisticsHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadNewlyObservedFileExtensionsCount != nil {

		// query param anti_ransomware.workload.newly_observed_file_extensions.count
		var qrAntiRansomwareWorkloadNewlyObservedFileExtensionsCount int64

		if o.AntiRansomwareWorkloadNewlyObservedFileExtensionsCount != nil {
			qrAntiRansomwareWorkloadNewlyObservedFileExtensionsCount = *o.AntiRansomwareWorkloadNewlyObservedFileExtensionsCount
		}
		qAntiRansomwareWorkloadNewlyObservedFileExtensionsCount := swag.FormatInt64(qrAntiRansomwareWorkloadNewlyObservedFileExtensionsCount)
		if qAntiRansomwareWorkloadNewlyObservedFileExtensionsCount != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.newly_observed_file_extensions.count", qAntiRansomwareWorkloadNewlyObservedFileExtensionsCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadNewlyObservedFileExtensionsName != nil {

		// query param anti_ransomware.workload.newly_observed_file_extensions.name
		var qrAntiRansomwareWorkloadNewlyObservedFileExtensionsName string

		if o.AntiRansomwareWorkloadNewlyObservedFileExtensionsName != nil {
			qrAntiRansomwareWorkloadNewlyObservedFileExtensionsName = *o.AntiRansomwareWorkloadNewlyObservedFileExtensionsName
		}
		qAntiRansomwareWorkloadNewlyObservedFileExtensionsName := qrAntiRansomwareWorkloadNewlyObservedFileExtensionsName
		if qAntiRansomwareWorkloadNewlyObservedFileExtensionsName != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.newly_observed_file_extensions.name", qAntiRansomwareWorkloadNewlyObservedFileExtensionsName); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_statistics.file_create_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.file_create_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeStatisticsFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_statistics.file_delete_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.file_delete_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeStatisticsFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_statistics.file_rename_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.file_rename_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeStatisticsFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_percent
		var qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent = *o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent)
		if qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_percent", qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareWorkloadSurgeStatisticsHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeStatisticsTime != nil {

		// query param anti_ransomware.workload.surge_statistics.time
		var qrAntiRansomwareWorkloadSurgeStatisticsTime string

		if o.AntiRansomwareWorkloadSurgeStatisticsTime != nil {
			qrAntiRansomwareWorkloadSurgeStatisticsTime = *o.AntiRansomwareWorkloadSurgeStatisticsTime
		}
		qAntiRansomwareWorkloadSurgeStatisticsTime := qrAntiRansomwareWorkloadSurgeStatisticsTime
		if qAntiRansomwareWorkloadSurgeStatisticsTime != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_statistics.time", qAntiRansomwareWorkloadSurgeStatisticsTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_usage.file_create_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.file_create_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeUsageFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_usage.file_delete_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.file_delete_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeUsageFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.surge_usage.file_rename_peak_rate_per_minute
		var qrAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute = *o.AntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute
		}
		qAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute)
		if qAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.file_rename_peak_rate_per_minute", qAntiRansomwareWorkloadSurgeUsageFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_percent
		var qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent = *o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent)
		if qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_percent", qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareWorkloadSurgeUsageHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount != nil {

		// query param anti_ransomware.workload.surge_usage.newly_observed_file_extensions.count
		var qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount int64

		if o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount != nil {
			qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount = *o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount
		}
		qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount := swag.FormatInt64(qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount)
		if qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.newly_observed_file_extensions.count", qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName != nil {

		// query param anti_ransomware.workload.surge_usage.newly_observed_file_extensions.name
		var qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName string

		if o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName != nil {
			qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName = *o.AntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName
		}
		qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName := qrAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName
		if qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.newly_observed_file_extensions.name", qAntiRansomwareWorkloadSurgeUsageNewlyObservedFileExtensionsName); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadSurgeUsageTime != nil {

		// query param anti_ransomware.workload.surge_usage.time
		var qrAntiRansomwareWorkloadSurgeUsageTime string

		if o.AntiRansomwareWorkloadSurgeUsageTime != nil {
			qrAntiRansomwareWorkloadSurgeUsageTime = *o.AntiRansomwareWorkloadSurgeUsageTime
		}
		qAntiRansomwareWorkloadSurgeUsageTime := qrAntiRansomwareWorkloadSurgeUsageTime
		if qAntiRansomwareWorkloadSurgeUsageTime != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.surge_usage.time", qAntiRansomwareWorkloadSurgeUsageTime); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.typical_usage.file_create_peak_rate_per_minute
		var qrAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute = *o.AntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute
		}
		qAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute)
		if qAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.typical_usage.file_create_peak_rate_per_minute", qAntiRansomwareWorkloadTypicalUsageFileCreatePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.typical_usage.file_delete_peak_rate_per_minute
		var qrAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute = *o.AntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute
		}
		qAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute)
		if qAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.typical_usage.file_delete_peak_rate_per_minute", qAntiRansomwareWorkloadTypicalUsageFileDeletePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute != nil {

		// query param anti_ransomware.workload.typical_usage.file_rename_peak_rate_per_minute
		var qrAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute int64

		if o.AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute != nil {
			qrAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute = *o.AntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute
		}
		qAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute)
		if qAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.typical_usage.file_rename_peak_rate_per_minute", qAntiRansomwareWorkloadTypicalUsageFileRenamePeakRatePerMinute); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent != nil {

		// query param anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_percent
		var qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent int64

		if o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent != nil {
			qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent = *o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent
		}
		qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent := swag.FormatInt64(qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent)
		if qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_percent", qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != nil {

		// query param anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute
		var qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute int64

		if o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != nil {
			qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute = *o.AntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute
		}
		qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute := swag.FormatInt64(qrAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute)
		if qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute != "" {

			if err := r.SetQueryParam("anti_ransomware.workload.typical_usage.high_entropy_data_write_peak_rate_kb_per_minute", qAntiRansomwareWorkloadTypicalUsageHighEntropyDataWritePeakRateKbPerMinute); err != nil {
				return err
			}
		}
	}

	if o.ApplicationName != nil {

		// query param application.name
		var qrApplicationName string

		if o.ApplicationName != nil {
			qrApplicationName = *o.ApplicationName
		}
		qApplicationName := qrApplicationName
		if qApplicationName != "" {

			if err := r.SetQueryParam("application.name", qApplicationName); err != nil {
				return err
			}
		}
	}

	if o.ApplicationUUID != nil {

		// query param application.uuid
		var qrApplicationUUID string

		if o.ApplicationUUID != nil {
			qrApplicationUUID = *o.ApplicationUUID
		}
		qApplicationUUID := qrApplicationUUID
		if qApplicationUUID != "" {

			if err := r.SetQueryParam("application.uuid", qApplicationUUID); err != nil {
				return err
			}
		}
	}

	if o.AsynchronousDirectoryDeleteEnabled != nil {

		// query param asynchronous_directory_delete.enabled
		var qrAsynchronousDirectoryDeleteEnabled bool

		if o.AsynchronousDirectoryDeleteEnabled != nil {
			qrAsynchronousDirectoryDeleteEnabled = *o.AsynchronousDirectoryDeleteEnabled
		}
		qAsynchronousDirectoryDeleteEnabled := swag.FormatBool(qrAsynchronousDirectoryDeleteEnabled)
		if qAsynchronousDirectoryDeleteEnabled != "" {

			if err := r.SetQueryParam("asynchronous_directory_delete.enabled", qAsynchronousDirectoryDeleteEnabled); err != nil {
				return err
			}
		}
	}

	if o.AsynchronousDirectoryDeleteTrashBin != nil {

		// query param asynchronous_directory_delete.trash_bin
		var qrAsynchronousDirectoryDeleteTrashBin string

		if o.AsynchronousDirectoryDeleteTrashBin != nil {
			qrAsynchronousDirectoryDeleteTrashBin = *o.AsynchronousDirectoryDeleteTrashBin
		}
		qAsynchronousDirectoryDeleteTrashBin := qrAsynchronousDirectoryDeleteTrashBin
		if qAsynchronousDirectoryDeleteTrashBin != "" {

			if err := r.SetQueryParam("asynchronous_directory_delete.trash_bin", qAsynchronousDirectoryDeleteTrashBin); err != nil {
				return err
			}
		}
	}

	if o.AutosizeGrowThreshold != nil {

		// query param autosize.grow_threshold
		var qrAutosizeGrowThreshold int64

		if o.AutosizeGrowThreshold != nil {
			qrAutosizeGrowThreshold = *o.AutosizeGrowThreshold
		}
		qAutosizeGrowThreshold := swag.FormatInt64(qrAutosizeGrowThreshold)
		if qAutosizeGrowThreshold != "" {

			if err := r.SetQueryParam("autosize.grow_threshold", qAutosizeGrowThreshold); err != nil {
				return err
			}
		}
	}

	if o.AutosizeMaximum != nil {

		// query param autosize.maximum
		var qrAutosizeMaximum int64

		if o.AutosizeMaximum != nil {
			qrAutosizeMaximum = *o.AutosizeMaximum
		}
		qAutosizeMaximum := swag.FormatInt64(qrAutosizeMaximum)
		if qAutosizeMaximum != "" {

			if err := r.SetQueryParam("autosize.maximum", qAutosizeMaximum); err != nil {
				return err
			}
		}
	}

	if o.AutosizeMinimum != nil {

		// query param autosize.minimum
		var qrAutosizeMinimum int64

		if o.AutosizeMinimum != nil {
			qrAutosizeMinimum = *o.AutosizeMinimum
		}
		qAutosizeMinimum := swag.FormatInt64(qrAutosizeMinimum)
		if qAutosizeMinimum != "" {

			if err := r.SetQueryParam("autosize.minimum", qAutosizeMinimum); err != nil {
				return err
			}
		}
	}

	if o.AutosizeMode != nil {

		// query param autosize.mode
		var qrAutosizeMode string

		if o.AutosizeMode != nil {
			qrAutosizeMode = *o.AutosizeMode
		}
		qAutosizeMode := qrAutosizeMode
		if qAutosizeMode != "" {

			if err := r.SetQueryParam("autosize.mode", qAutosizeMode); err != nil {
				return err
			}
		}
	}

	if o.AutosizeShrinkThreshold != nil {

		// query param autosize.shrink_threshold
		var qrAutosizeShrinkThreshold int64

		if o.AutosizeShrinkThreshold != nil {
			qrAutosizeShrinkThreshold = *o.AutosizeShrinkThreshold
		}
		qAutosizeShrinkThreshold := swag.FormatInt64(qrAutosizeShrinkThreshold)
		if qAutosizeShrinkThreshold != "" {

			if err := r.SetQueryParam("autosize.shrink_threshold", qAutosizeShrinkThreshold); err != nil {
				return err
			}
		}
	}

	if o.CloneHasFlexclone != nil {

		// query param clone.has_flexclone
		var qrCloneHasFlexclone bool

		if o.CloneHasFlexclone != nil {
			qrCloneHasFlexclone = *o.CloneHasFlexclone
		}
		qCloneHasFlexclone := swag.FormatBool(qrCloneHasFlexclone)
		if qCloneHasFlexclone != "" {

			if err := r.SetQueryParam("clone.has_flexclone", qCloneHasFlexclone); err != nil {
				return err
			}
		}
	}

	if o.CloneInheritedPhysicalUsed != nil {

		// query param clone.inherited_physical_used
		var qrCloneInheritedPhysicalUsed int64

		if o.CloneInheritedPhysicalUsed != nil {
			qrCloneInheritedPhysicalUsed = *o.CloneInheritedPhysicalUsed
		}
		qCloneInheritedPhysicalUsed := swag.FormatInt64(qrCloneInheritedPhysicalUsed)
		if qCloneInheritedPhysicalUsed != "" {

			if err := r.SetQueryParam("clone.inherited_physical_used", qCloneInheritedPhysicalUsed); err != nil {
				return err
			}
		}
	}

	if o.CloneInheritedSavings != nil {

		// query param clone.inherited_savings
		var qrCloneInheritedSavings int64

		if o.CloneInheritedSavings != nil {
			qrCloneInheritedSavings = *o.CloneInheritedSavings
		}
		qCloneInheritedSavings := swag.FormatInt64(qrCloneInheritedSavings)
		if qCloneInheritedSavings != "" {

			if err := r.SetQueryParam("clone.inherited_savings", qCloneInheritedSavings); err != nil {
				return err
			}
		}
	}

	if o.CloneIsFlexclone != nil {

		// query param clone.is_flexclone
		var qrCloneIsFlexclone bool

		if o.CloneIsFlexclone != nil {
			qrCloneIsFlexclone = *o.CloneIsFlexclone
		}
		qCloneIsFlexclone := swag.FormatBool(qrCloneIsFlexclone)
		if qCloneIsFlexclone != "" {

			if err := r.SetQueryParam("clone.is_flexclone", qCloneIsFlexclone); err != nil {
				return err
			}
		}
	}

	if o.CloneLunName != nil {

		// query param clone.lun_name
		var qrCloneLunName string

		if o.CloneLunName != nil {
			qrCloneLunName = *o.CloneLunName
		}
		qCloneLunName := qrCloneLunName
		if qCloneLunName != "" {

			if err := r.SetQueryParam("clone.lun_name", qCloneLunName); err != nil {
				return err
			}
		}
	}

	if o.CloneParentSnapshotName != nil {

		// query param clone.parent_snapshot.name
		var qrCloneParentSnapshotName string

		if o.CloneParentSnapshotName != nil {
			qrCloneParentSnapshotName = *o.CloneParentSnapshotName
		}
		qCloneParentSnapshotName := qrCloneParentSnapshotName
		if qCloneParentSnapshotName != "" {

			if err := r.SetQueryParam("clone.parent_snapshot.name", qCloneParentSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.CloneParentSnapshotUUID != nil {

		// query param clone.parent_snapshot.uuid
		var qrCloneParentSnapshotUUID string

		if o.CloneParentSnapshotUUID != nil {
			qrCloneParentSnapshotUUID = *o.CloneParentSnapshotUUID
		}
		qCloneParentSnapshotUUID := qrCloneParentSnapshotUUID
		if qCloneParentSnapshotUUID != "" {

			if err := r.SetQueryParam("clone.parent_snapshot.uuid", qCloneParentSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.CloneParentSvmName != nil {

		// query param clone.parent_svm.name
		var qrCloneParentSvmName string

		if o.CloneParentSvmName != nil {
			qrCloneParentSvmName = *o.CloneParentSvmName
		}
		qCloneParentSvmName := qrCloneParentSvmName
		if qCloneParentSvmName != "" {

			if err := r.SetQueryParam("clone.parent_svm.name", qCloneParentSvmName); err != nil {
				return err
			}
		}
	}

	if o.CloneParentSvmUUID != nil {

		// query param clone.parent_svm.uuid
		var qrCloneParentSvmUUID string

		if o.CloneParentSvmUUID != nil {
			qrCloneParentSvmUUID = *o.CloneParentSvmUUID
		}
		qCloneParentSvmUUID := qrCloneParentSvmUUID
		if qCloneParentSvmUUID != "" {

			if err := r.SetQueryParam("clone.parent_svm.uuid", qCloneParentSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.CloneParentVolumeName != nil {

		// query param clone.parent_volume.name
		var qrCloneParentVolumeName string

		if o.CloneParentVolumeName != nil {
			qrCloneParentVolumeName = *o.CloneParentVolumeName
		}
		qCloneParentVolumeName := qrCloneParentVolumeName
		if qCloneParentVolumeName != "" {

			if err := r.SetQueryParam("clone.parent_volume.name", qCloneParentVolumeName); err != nil {
				return err
			}
		}
	}

	if o.CloneParentVolumeUUID != nil {

		// query param clone.parent_volume.uuid
		var qrCloneParentVolumeUUID string

		if o.CloneParentVolumeUUID != nil {
			qrCloneParentVolumeUUID = *o.CloneParentVolumeUUID
		}
		qCloneParentVolumeUUID := qrCloneParentVolumeUUID
		if qCloneParentVolumeUUID != "" {

			if err := r.SetQueryParam("clone.parent_volume.uuid", qCloneParentVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.CloneQtreeName != nil {

		// query param clone.qtree_name
		var qrCloneQtreeName string

		if o.CloneQtreeName != nil {
			qrCloneQtreeName = *o.CloneQtreeName
		}
		qCloneQtreeName := qrCloneQtreeName
		if qCloneQtreeName != "" {

			if err := r.SetQueryParam("clone.qtree_name", qCloneQtreeName); err != nil {
				return err
			}
		}
	}

	if o.CloneSplitCompletePercent != nil {

		// query param clone.split_complete_percent
		var qrCloneSplitCompletePercent int64

		if o.CloneSplitCompletePercent != nil {
			qrCloneSplitCompletePercent = *o.CloneSplitCompletePercent
		}
		qCloneSplitCompletePercent := swag.FormatInt64(qrCloneSplitCompletePercent)
		if qCloneSplitCompletePercent != "" {

			if err := r.SetQueryParam("clone.split_complete_percent", qCloneSplitCompletePercent); err != nil {
				return err
			}
		}
	}

	if o.CloneSplitEstimate != nil {

		// query param clone.split_estimate
		var qrCloneSplitEstimate int64

		if o.CloneSplitEstimate != nil {
			qrCloneSplitEstimate = *o.CloneSplitEstimate
		}
		qCloneSplitEstimate := swag.FormatInt64(qrCloneSplitEstimate)
		if qCloneSplitEstimate != "" {

			if err := r.SetQueryParam("clone.split_estimate", qCloneSplitEstimate); err != nil {
				return err
			}
		}
	}

	if o.CloneSplitInitiated != nil {

		// query param clone.split_initiated
		var qrCloneSplitInitiated bool

		if o.CloneSplitInitiated != nil {
			qrCloneSplitInitiated = *o.CloneSplitInitiated
		}
		qCloneSplitInitiated := swag.FormatBool(qrCloneSplitInitiated)
		if qCloneSplitInitiated != "" {

			if err := r.SetQueryParam("clone.split_initiated", qCloneSplitInitiated); err != nil {
				return err
			}
		}
	}

	if o.CloudRetrievalPolicy != nil {

		// query param cloud_retrieval_policy
		var qrCloudRetrievalPolicy string

		if o.CloudRetrievalPolicy != nil {
			qrCloudRetrievalPolicy = *o.CloudRetrievalPolicy
		}
		qCloudRetrievalPolicy := qrCloudRetrievalPolicy
		if qCloudRetrievalPolicy != "" {

			if err := r.SetQueryParam("cloud_retrieval_policy", qCloudRetrievalPolicy); err != nil {
				return err
			}
		}
	}

	if o.CloudWriteEnabled != nil {

		// query param cloud_write_enabled
		var qrCloudWriteEnabled bool

		if o.CloudWriteEnabled != nil {
			qrCloudWriteEnabled = *o.CloudWriteEnabled
		}
		qCloudWriteEnabled := swag.FormatBool(qrCloudWriteEnabled)
		if qCloudWriteEnabled != "" {

			if err := r.SetQueryParam("cloud_write_enabled", qCloudWriteEnabled); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupName != nil {

		// query param consistency_group.name
		var qrConsistencyGroupName string

		if o.ConsistencyGroupName != nil {
			qrConsistencyGroupName = *o.ConsistencyGroupName
		}
		qConsistencyGroupName := qrConsistencyGroupName
		if qConsistencyGroupName != "" {

			if err := r.SetQueryParam("consistency_group.name", qConsistencyGroupName); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupUUID != nil {

		// query param consistency_group.uuid
		var qrConsistencyGroupUUID string

		if o.ConsistencyGroupUUID != nil {
			qrConsistencyGroupUUID = *o.ConsistencyGroupUUID
		}
		qConsistencyGroupUUID := qrConsistencyGroupUUID
		if qConsistencyGroupUUID != "" {

			if err := r.SetQueryParam("consistency_group.uuid", qConsistencyGroupUUID); err != nil {
				return err
			}
		}
	}

	if o.ConstituentCount != nil {

		// query param constituent_count
		var qrConstituentCount int64

		if o.ConstituentCount != nil {
			qrConstituentCount = *o.ConstituentCount
		}
		qConstituentCount := swag.FormatInt64(qrConstituentCount)
		if qConstituentCount != "" {

			if err := r.SetQueryParam("constituent_count", qConstituentCount); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsAggregatesName != nil {

		// query param constituents.aggregates.name
		var qrConstituentsAggregatesName string

		if o.ConstituentsAggregatesName != nil {
			qrConstituentsAggregatesName = *o.ConstituentsAggregatesName
		}
		qConstituentsAggregatesName := qrConstituentsAggregatesName
		if qConstituentsAggregatesName != "" {

			if err := r.SetQueryParam("constituents.aggregates.name", qConstituentsAggregatesName); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsAggregatesUUID != nil {

		// query param constituents.aggregates.uuid
		var qrConstituentsAggregatesUUID string

		if o.ConstituentsAggregatesUUID != nil {
			qrConstituentsAggregatesUUID = *o.ConstituentsAggregatesUUID
		}
		qConstituentsAggregatesUUID := qrConstituentsAggregatesUUID
		if qConstituentsAggregatesUUID != "" {

			if err := r.SetQueryParam("constituents.aggregates.uuid", qConstituentsAggregatesUUID); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsMovementCutoverWindow != nil {

		// query param constituents.movement.cutover_window
		var qrConstituentsMovementCutoverWindow int64

		if o.ConstituentsMovementCutoverWindow != nil {
			qrConstituentsMovementCutoverWindow = *o.ConstituentsMovementCutoverWindow
		}
		qConstituentsMovementCutoverWindow := swag.FormatInt64(qrConstituentsMovementCutoverWindow)
		if qConstituentsMovementCutoverWindow != "" {

			if err := r.SetQueryParam("constituents.movement.cutover_window", qConstituentsMovementCutoverWindow); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsMovementDestinationAggregateName != nil {

		// query param constituents.movement.destination_aggregate.name
		var qrConstituentsMovementDestinationAggregateName string

		if o.ConstituentsMovementDestinationAggregateName != nil {
			qrConstituentsMovementDestinationAggregateName = *o.ConstituentsMovementDestinationAggregateName
		}
		qConstituentsMovementDestinationAggregateName := qrConstituentsMovementDestinationAggregateName
		if qConstituentsMovementDestinationAggregateName != "" {

			if err := r.SetQueryParam("constituents.movement.destination_aggregate.name", qConstituentsMovementDestinationAggregateName); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsMovementDestinationAggregateUUID != nil {

		// query param constituents.movement.destination_aggregate.uuid
		var qrConstituentsMovementDestinationAggregateUUID string

		if o.ConstituentsMovementDestinationAggregateUUID != nil {
			qrConstituentsMovementDestinationAggregateUUID = *o.ConstituentsMovementDestinationAggregateUUID
		}
		qConstituentsMovementDestinationAggregateUUID := qrConstituentsMovementDestinationAggregateUUID
		if qConstituentsMovementDestinationAggregateUUID != "" {

			if err := r.SetQueryParam("constituents.movement.destination_aggregate.uuid", qConstituentsMovementDestinationAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsMovementPercentComplete != nil {

		// query param constituents.movement.percent_complete
		var qrConstituentsMovementPercentComplete int64

		if o.ConstituentsMovementPercentComplete != nil {
			qrConstituentsMovementPercentComplete = *o.ConstituentsMovementPercentComplete
		}
		qConstituentsMovementPercentComplete := swag.FormatInt64(qrConstituentsMovementPercentComplete)
		if qConstituentsMovementPercentComplete != "" {

			if err := r.SetQueryParam("constituents.movement.percent_complete", qConstituentsMovementPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsMovementState != nil {

		// query param constituents.movement.state
		var qrConstituentsMovementState string

		if o.ConstituentsMovementState != nil {
			qrConstituentsMovementState = *o.ConstituentsMovementState
		}
		qConstituentsMovementState := qrConstituentsMovementState
		if qConstituentsMovementState != "" {

			if err := r.SetQueryParam("constituents.movement.state", qConstituentsMovementState); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsName != nil {

		// query param constituents.name
		var qrConstituentsName string

		if o.ConstituentsName != nil {
			qrConstituentsName = *o.ConstituentsName
		}
		qConstituentsName := qrConstituentsName
		if qConstituentsName != "" {

			if err := r.SetQueryParam("constituents.name", qConstituentsName); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsNodeName != nil {

		// query param constituents.node.name
		var qrConstituentsNodeName string

		if o.ConstituentsNodeName != nil {
			qrConstituentsNodeName = *o.ConstituentsNodeName
		}
		qConstituentsNodeName := qrConstituentsNodeName
		if qConstituentsNodeName != "" {

			if err := r.SetQueryParam("constituents.node.name", qConstituentsNodeName); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsNodeUUID != nil {

		// query param constituents.node.uuid
		var qrConstituentsNodeUUID string

		if o.ConstituentsNodeUUID != nil {
			qrConstituentsNodeUUID = *o.ConstituentsNodeUUID
		}
		qConstituentsNodeUUID := qrConstituentsNodeUUID
		if qConstituentsNodeUUID != "" {

			if err := r.SetQueryParam("constituents.node.uuid", qConstituentsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceAfsTotal != nil {

		// query param constituents.space.afs_total
		var qrConstituentsSpaceAfsTotal int64

		if o.ConstituentsSpaceAfsTotal != nil {
			qrConstituentsSpaceAfsTotal = *o.ConstituentsSpaceAfsTotal
		}
		qConstituentsSpaceAfsTotal := swag.FormatInt64(qrConstituentsSpaceAfsTotal)
		if qConstituentsSpaceAfsTotal != "" {

			if err := r.SetQueryParam("constituents.space.afs_total", qConstituentsSpaceAfsTotal); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceAvailable != nil {

		// query param constituents.space.available
		var qrConstituentsSpaceAvailable int64

		if o.ConstituentsSpaceAvailable != nil {
			qrConstituentsSpaceAvailable = *o.ConstituentsSpaceAvailable
		}
		qConstituentsSpaceAvailable := swag.FormatInt64(qrConstituentsSpaceAvailable)
		if qConstituentsSpaceAvailable != "" {

			if err := r.SetQueryParam("constituents.space.available", qConstituentsSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceAvailablePercent != nil {

		// query param constituents.space.available_percent
		var qrConstituentsSpaceAvailablePercent int64

		if o.ConstituentsSpaceAvailablePercent != nil {
			qrConstituentsSpaceAvailablePercent = *o.ConstituentsSpaceAvailablePercent
		}
		qConstituentsSpaceAvailablePercent := swag.FormatInt64(qrConstituentsSpaceAvailablePercent)
		if qConstituentsSpaceAvailablePercent != "" {

			if err := r.SetQueryParam("constituents.space.available_percent", qConstituentsSpaceAvailablePercent); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceBlockStorageInactiveUserData != nil {

		// query param constituents.space.block_storage_inactive_user_data
		var qrConstituentsSpaceBlockStorageInactiveUserData int64

		if o.ConstituentsSpaceBlockStorageInactiveUserData != nil {
			qrConstituentsSpaceBlockStorageInactiveUserData = *o.ConstituentsSpaceBlockStorageInactiveUserData
		}
		qConstituentsSpaceBlockStorageInactiveUserData := swag.FormatInt64(qrConstituentsSpaceBlockStorageInactiveUserData)
		if qConstituentsSpaceBlockStorageInactiveUserData != "" {

			if err := r.SetQueryParam("constituents.space.block_storage_inactive_user_data", qConstituentsSpaceBlockStorageInactiveUserData); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceCapacityTierFootprint != nil {

		// query param constituents.space.capacity_tier_footprint
		var qrConstituentsSpaceCapacityTierFootprint int64

		if o.ConstituentsSpaceCapacityTierFootprint != nil {
			qrConstituentsSpaceCapacityTierFootprint = *o.ConstituentsSpaceCapacityTierFootprint
		}
		qConstituentsSpaceCapacityTierFootprint := swag.FormatInt64(qrConstituentsSpaceCapacityTierFootprint)
		if qConstituentsSpaceCapacityTierFootprint != "" {

			if err := r.SetQueryParam("constituents.space.capacity_tier_footprint", qConstituentsSpaceCapacityTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceFootprint != nil {

		// query param constituents.space.footprint
		var qrConstituentsSpaceFootprint int64

		if o.ConstituentsSpaceFootprint != nil {
			qrConstituentsSpaceFootprint = *o.ConstituentsSpaceFootprint
		}
		qConstituentsSpaceFootprint := swag.FormatInt64(qrConstituentsSpaceFootprint)
		if qConstituentsSpaceFootprint != "" {

			if err := r.SetQueryParam("constituents.space.footprint", qConstituentsSpaceFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLargeSizeEnabled != nil {

		// query param constituents.space.large_size_enabled
		var qrConstituentsSpaceLargeSizeEnabled bool

		if o.ConstituentsSpaceLargeSizeEnabled != nil {
			qrConstituentsSpaceLargeSizeEnabled = *o.ConstituentsSpaceLargeSizeEnabled
		}
		qConstituentsSpaceLargeSizeEnabled := swag.FormatBool(qrConstituentsSpaceLargeSizeEnabled)
		if qConstituentsSpaceLargeSizeEnabled != "" {

			if err := r.SetQueryParam("constituents.space.large_size_enabled", qConstituentsSpaceLargeSizeEnabled); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLocalTierFootprint != nil {

		// query param constituents.space.local_tier_footprint
		var qrConstituentsSpaceLocalTierFootprint int64

		if o.ConstituentsSpaceLocalTierFootprint != nil {
			qrConstituentsSpaceLocalTierFootprint = *o.ConstituentsSpaceLocalTierFootprint
		}
		qConstituentsSpaceLocalTierFootprint := swag.FormatInt64(qrConstituentsSpaceLocalTierFootprint)
		if qConstituentsSpaceLocalTierFootprint != "" {

			if err := r.SetQueryParam("constituents.space.local_tier_footprint", qConstituentsSpaceLocalTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLogicalSpaceAvailable != nil {

		// query param constituents.space.logical_space.available
		var qrConstituentsSpaceLogicalSpaceAvailable int64

		if o.ConstituentsSpaceLogicalSpaceAvailable != nil {
			qrConstituentsSpaceLogicalSpaceAvailable = *o.ConstituentsSpaceLogicalSpaceAvailable
		}
		qConstituentsSpaceLogicalSpaceAvailable := swag.FormatInt64(qrConstituentsSpaceLogicalSpaceAvailable)
		if qConstituentsSpaceLogicalSpaceAvailable != "" {

			if err := r.SetQueryParam("constituents.space.logical_space.available", qConstituentsSpaceLogicalSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLogicalSpaceEnforcement != nil {

		// query param constituents.space.logical_space.enforcement
		var qrConstituentsSpaceLogicalSpaceEnforcement bool

		if o.ConstituentsSpaceLogicalSpaceEnforcement != nil {
			qrConstituentsSpaceLogicalSpaceEnforcement = *o.ConstituentsSpaceLogicalSpaceEnforcement
		}
		qConstituentsSpaceLogicalSpaceEnforcement := swag.FormatBool(qrConstituentsSpaceLogicalSpaceEnforcement)
		if qConstituentsSpaceLogicalSpaceEnforcement != "" {

			if err := r.SetQueryParam("constituents.space.logical_space.enforcement", qConstituentsSpaceLogicalSpaceEnforcement); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLogicalSpaceReporting != nil {

		// query param constituents.space.logical_space.reporting
		var qrConstituentsSpaceLogicalSpaceReporting bool

		if o.ConstituentsSpaceLogicalSpaceReporting != nil {
			qrConstituentsSpaceLogicalSpaceReporting = *o.ConstituentsSpaceLogicalSpaceReporting
		}
		qConstituentsSpaceLogicalSpaceReporting := swag.FormatBool(qrConstituentsSpaceLogicalSpaceReporting)
		if qConstituentsSpaceLogicalSpaceReporting != "" {

			if err := r.SetQueryParam("constituents.space.logical_space.reporting", qConstituentsSpaceLogicalSpaceReporting); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceLogicalSpaceUsedByAfs != nil {

		// query param constituents.space.logical_space.used_by_afs
		var qrConstituentsSpaceLogicalSpaceUsedByAfs int64

		if o.ConstituentsSpaceLogicalSpaceUsedByAfs != nil {
			qrConstituentsSpaceLogicalSpaceUsedByAfs = *o.ConstituentsSpaceLogicalSpaceUsedByAfs
		}
		qConstituentsSpaceLogicalSpaceUsedByAfs := swag.FormatInt64(qrConstituentsSpaceLogicalSpaceUsedByAfs)
		if qConstituentsSpaceLogicalSpaceUsedByAfs != "" {

			if err := r.SetQueryParam("constituents.space.logical_space.used_by_afs", qConstituentsSpaceLogicalSpaceUsedByAfs); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceMaxSize != nil {

		// query param constituents.space.max_size
		var qrConstituentsSpaceMaxSize string

		if o.ConstituentsSpaceMaxSize != nil {
			qrConstituentsSpaceMaxSize = *o.ConstituentsSpaceMaxSize
		}
		qConstituentsSpaceMaxSize := qrConstituentsSpaceMaxSize
		if qConstituentsSpaceMaxSize != "" {

			if err := r.SetQueryParam("constituents.space.max_size", qConstituentsSpaceMaxSize); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceMetadata != nil {

		// query param constituents.space.metadata
		var qrConstituentsSpaceMetadata int64

		if o.ConstituentsSpaceMetadata != nil {
			qrConstituentsSpaceMetadata = *o.ConstituentsSpaceMetadata
		}
		qConstituentsSpaceMetadata := swag.FormatInt64(qrConstituentsSpaceMetadata)
		if qConstituentsSpaceMetadata != "" {

			if err := r.SetQueryParam("constituents.space.metadata", qConstituentsSpaceMetadata); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceOverProvisioned != nil {

		// query param constituents.space.over_provisioned
		var qrConstituentsSpaceOverProvisioned int64

		if o.ConstituentsSpaceOverProvisioned != nil {
			qrConstituentsSpaceOverProvisioned = *o.ConstituentsSpaceOverProvisioned
		}
		qConstituentsSpaceOverProvisioned := swag.FormatInt64(qrConstituentsSpaceOverProvisioned)
		if qConstituentsSpaceOverProvisioned != "" {

			if err := r.SetQueryParam("constituents.space.over_provisioned", qConstituentsSpaceOverProvisioned); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpacePerformanceTierFootprint != nil {

		// query param constituents.space.performance_tier_footprint
		var qrConstituentsSpacePerformanceTierFootprint int64

		if o.ConstituentsSpacePerformanceTierFootprint != nil {
			qrConstituentsSpacePerformanceTierFootprint = *o.ConstituentsSpacePerformanceTierFootprint
		}
		qConstituentsSpacePerformanceTierFootprint := swag.FormatInt64(qrConstituentsSpacePerformanceTierFootprint)
		if qConstituentsSpacePerformanceTierFootprint != "" {

			if err := r.SetQueryParam("constituents.space.performance_tier_footprint", qConstituentsSpacePerformanceTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceSize != nil {

		// query param constituents.space.size
		var qrConstituentsSpaceSize int64

		if o.ConstituentsSpaceSize != nil {
			qrConstituentsSpaceSize = *o.ConstituentsSpaceSize
		}
		qConstituentsSpaceSize := swag.FormatInt64(qrConstituentsSpaceSize)
		if qConstituentsSpaceSize != "" {

			if err := r.SetQueryParam("constituents.space.size", qConstituentsSpaceSize); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceSnapshotReservePercent != nil {

		// query param constituents.space.snapshot.reserve_percent
		var qrConstituentsSpaceSnapshotReservePercent int64

		if o.ConstituentsSpaceSnapshotReservePercent != nil {
			qrConstituentsSpaceSnapshotReservePercent = *o.ConstituentsSpaceSnapshotReservePercent
		}
		qConstituentsSpaceSnapshotReservePercent := swag.FormatInt64(qrConstituentsSpaceSnapshotReservePercent)
		if qConstituentsSpaceSnapshotReservePercent != "" {

			if err := r.SetQueryParam("constituents.space.snapshot.reserve_percent", qConstituentsSpaceSnapshotReservePercent); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceSnapshotUsed != nil {

		// query param constituents.space.snapshot.used
		var qrConstituentsSpaceSnapshotUsed int64

		if o.ConstituentsSpaceSnapshotUsed != nil {
			qrConstituentsSpaceSnapshotUsed = *o.ConstituentsSpaceSnapshotUsed
		}
		qConstituentsSpaceSnapshotUsed := swag.FormatInt64(qrConstituentsSpaceSnapshotUsed)
		if qConstituentsSpaceSnapshotUsed != "" {

			if err := r.SetQueryParam("constituents.space.snapshot.used", qConstituentsSpaceSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceTotalFootprint != nil {

		// query param constituents.space.total_footprint
		var qrConstituentsSpaceTotalFootprint int64

		if o.ConstituentsSpaceTotalFootprint != nil {
			qrConstituentsSpaceTotalFootprint = *o.ConstituentsSpaceTotalFootprint
		}
		qConstituentsSpaceTotalFootprint := swag.FormatInt64(qrConstituentsSpaceTotalFootprint)
		if qConstituentsSpaceTotalFootprint != "" {

			if err := r.SetQueryParam("constituents.space.total_footprint", qConstituentsSpaceTotalFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceTotalMetadata != nil {

		// query param constituents.space.total_metadata
		var qrConstituentsSpaceTotalMetadata int64

		if o.ConstituentsSpaceTotalMetadata != nil {
			qrConstituentsSpaceTotalMetadata = *o.ConstituentsSpaceTotalMetadata
		}
		qConstituentsSpaceTotalMetadata := swag.FormatInt64(qrConstituentsSpaceTotalMetadata)
		if qConstituentsSpaceTotalMetadata != "" {

			if err := r.SetQueryParam("constituents.space.total_metadata", qConstituentsSpaceTotalMetadata); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceTotalMetadataFootprint != nil {

		// query param constituents.space.total_metadata_footprint
		var qrConstituentsSpaceTotalMetadataFootprint int64

		if o.ConstituentsSpaceTotalMetadataFootprint != nil {
			qrConstituentsSpaceTotalMetadataFootprint = *o.ConstituentsSpaceTotalMetadataFootprint
		}
		qConstituentsSpaceTotalMetadataFootprint := swag.FormatInt64(qrConstituentsSpaceTotalMetadataFootprint)
		if qConstituentsSpaceTotalMetadataFootprint != "" {

			if err := r.SetQueryParam("constituents.space.total_metadata_footprint", qConstituentsSpaceTotalMetadataFootprint); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceUsed != nil {

		// query param constituents.space.used
		var qrConstituentsSpaceUsed int64

		if o.ConstituentsSpaceUsed != nil {
			qrConstituentsSpaceUsed = *o.ConstituentsSpaceUsed
		}
		qConstituentsSpaceUsed := swag.FormatInt64(qrConstituentsSpaceUsed)
		if qConstituentsSpaceUsed != "" {

			if err := r.SetQueryParam("constituents.space.used", qConstituentsSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceUsedByAfs != nil {

		// query param constituents.space.used_by_afs
		var qrConstituentsSpaceUsedByAfs int64

		if o.ConstituentsSpaceUsedByAfs != nil {
			qrConstituentsSpaceUsedByAfs = *o.ConstituentsSpaceUsedByAfs
		}
		qConstituentsSpaceUsedByAfs := swag.FormatInt64(qrConstituentsSpaceUsedByAfs)
		if qConstituentsSpaceUsedByAfs != "" {

			if err := r.SetQueryParam("constituents.space.used_by_afs", qConstituentsSpaceUsedByAfs); err != nil {
				return err
			}
		}
	}

	if o.ConstituentsSpaceUsedPercent != nil {

		// query param constituents.space.used_percent
		var qrConstituentsSpaceUsedPercent int64

		if o.ConstituentsSpaceUsedPercent != nil {
			qrConstituentsSpaceUsedPercent = *o.ConstituentsSpaceUsedPercent
		}
		qConstituentsSpaceUsedPercent := swag.FormatInt64(qrConstituentsSpaceUsedPercent)
		if qConstituentsSpaceUsedPercent != "" {

			if err := r.SetQueryParam("constituents.space.used_percent", qConstituentsSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.ConvertUnicode != nil {

		// query param convert_unicode
		var qrConvertUnicode bool

		if o.ConvertUnicode != nil {
			qrConvertUnicode = *o.ConvertUnicode
		}
		qConvertUnicode := swag.FormatBool(qrConvertUnicode)
		if qConvertUnicode != "" {

			if err := r.SetQueryParam("convert_unicode", qConvertUnicode); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyApplicationIoSize != nil {

		// query param efficiency.application_io_size
		var qrEfficiencyApplicationIoSize string

		if o.EfficiencyApplicationIoSize != nil {
			qrEfficiencyApplicationIoSize = *o.EfficiencyApplicationIoSize
		}
		qEfficiencyApplicationIoSize := qrEfficiencyApplicationIoSize
		if qEfficiencyApplicationIoSize != "" {

			if err := r.SetQueryParam("efficiency.application_io_size", qEfficiencyApplicationIoSize); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyAutoState != nil {

		// query param efficiency.auto_state
		var qrEfficiencyAutoState string

		if o.EfficiencyAutoState != nil {
			qrEfficiencyAutoState = *o.EfficiencyAutoState
		}
		qEfficiencyAutoState := qrEfficiencyAutoState
		if qEfficiencyAutoState != "" {

			if err := r.SetQueryParam("efficiency.auto_state", qEfficiencyAutoState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyCompaction != nil {

		// query param efficiency.compaction
		var qrEfficiencyCompaction string

		if o.EfficiencyCompaction != nil {
			qrEfficiencyCompaction = *o.EfficiencyCompaction
		}
		qEfficiencyCompaction := qrEfficiencyCompaction
		if qEfficiencyCompaction != "" {

			if err := r.SetQueryParam("efficiency.compaction", qEfficiencyCompaction); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyCompression != nil {

		// query param efficiency.compression
		var qrEfficiencyCompression string

		if o.EfficiencyCompression != nil {
			qrEfficiencyCompression = *o.EfficiencyCompression
		}
		qEfficiencyCompression := qrEfficiencyCompression
		if qEfficiencyCompression != "" {

			if err := r.SetQueryParam("efficiency.compression", qEfficiencyCompression); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyCompressionType != nil {

		// query param efficiency.compression_type
		var qrEfficiencyCompressionType string

		if o.EfficiencyCompressionType != nil {
			qrEfficiencyCompressionType = *o.EfficiencyCompressionType
		}
		qEfficiencyCompressionType := qrEfficiencyCompressionType
		if qEfficiencyCompressionType != "" {

			if err := r.SetQueryParam("efficiency.compression_type", qEfficiencyCompressionType); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyCrossVolumeDedupe != nil {

		// query param efficiency.cross_volume_dedupe
		var qrEfficiencyCrossVolumeDedupe string

		if o.EfficiencyCrossVolumeDedupe != nil {
			qrEfficiencyCrossVolumeDedupe = *o.EfficiencyCrossVolumeDedupe
		}
		qEfficiencyCrossVolumeDedupe := qrEfficiencyCrossVolumeDedupe
		if qEfficiencyCrossVolumeDedupe != "" {

			if err := r.SetQueryParam("efficiency.cross_volume_dedupe", qEfficiencyCrossVolumeDedupe); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyDedupe != nil {

		// query param efficiency.dedupe
		var qrEfficiencyDedupe string

		if o.EfficiencyDedupe != nil {
			qrEfficiencyDedupe = *o.EfficiencyDedupe
		}
		qEfficiencyDedupe := qrEfficiencyDedupe
		if qEfficiencyDedupe != "" {

			if err := r.SetQueryParam("efficiency.dedupe", qEfficiencyDedupe); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyHasSavings != nil {

		// query param efficiency.has_savings
		var qrEfficiencyHasSavings bool

		if o.EfficiencyHasSavings != nil {
			qrEfficiencyHasSavings = *o.EfficiencyHasSavings
		}
		qEfficiencyHasSavings := swag.FormatBool(qrEfficiencyHasSavings)
		if qEfficiencyHasSavings != "" {

			if err := r.SetQueryParam("efficiency.has_savings", qEfficiencyHasSavings); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyIdcsScannerEnabled != nil {

		// query param efficiency.idcs_scanner.enabled
		var qrEfficiencyIdcsScannerEnabled bool

		if o.EfficiencyIdcsScannerEnabled != nil {
			qrEfficiencyIdcsScannerEnabled = *o.EfficiencyIdcsScannerEnabled
		}
		qEfficiencyIdcsScannerEnabled := swag.FormatBool(qrEfficiencyIdcsScannerEnabled)
		if qEfficiencyIdcsScannerEnabled != "" {

			if err := r.SetQueryParam("efficiency.idcs_scanner.enabled", qEfficiencyIdcsScannerEnabled); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyIdcsScannerMode != nil {

		// query param efficiency.idcs_scanner.mode
		var qrEfficiencyIdcsScannerMode string

		if o.EfficiencyIdcsScannerMode != nil {
			qrEfficiencyIdcsScannerMode = *o.EfficiencyIdcsScannerMode
		}
		qEfficiencyIdcsScannerMode := qrEfficiencyIdcsScannerMode
		if qEfficiencyIdcsScannerMode != "" {

			if err := r.SetQueryParam("efficiency.idcs_scanner.mode", qEfficiencyIdcsScannerMode); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyIdcsScannerOperationState != nil {

		// query param efficiency.idcs_scanner.operation_state
		var qrEfficiencyIdcsScannerOperationState string

		if o.EfficiencyIdcsScannerOperationState != nil {
			qrEfficiencyIdcsScannerOperationState = *o.EfficiencyIdcsScannerOperationState
		}
		qEfficiencyIdcsScannerOperationState := qrEfficiencyIdcsScannerOperationState
		if qEfficiencyIdcsScannerOperationState != "" {

			if err := r.SetQueryParam("efficiency.idcs_scanner.operation_state", qEfficiencyIdcsScannerOperationState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyIdcsScannerStatus != nil {

		// query param efficiency.idcs_scanner.status
		var qrEfficiencyIdcsScannerStatus string

		if o.EfficiencyIdcsScannerStatus != nil {
			qrEfficiencyIdcsScannerStatus = *o.EfficiencyIdcsScannerStatus
		}
		qEfficiencyIdcsScannerStatus := qrEfficiencyIdcsScannerStatus
		if qEfficiencyIdcsScannerStatus != "" {

			if err := r.SetQueryParam("efficiency.idcs_scanner.status", qEfficiencyIdcsScannerStatus); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyIdcsScannerThresholdInactiveTime != nil {

		// query param efficiency.idcs_scanner.threshold_inactive_time
		var qrEfficiencyIdcsScannerThresholdInactiveTime string

		if o.EfficiencyIdcsScannerThresholdInactiveTime != nil {
			qrEfficiencyIdcsScannerThresholdInactiveTime = *o.EfficiencyIdcsScannerThresholdInactiveTime
		}
		qEfficiencyIdcsScannerThresholdInactiveTime := qrEfficiencyIdcsScannerThresholdInactiveTime
		if qEfficiencyIdcsScannerThresholdInactiveTime != "" {

			if err := r.SetQueryParam("efficiency.idcs_scanner.threshold_inactive_time", qEfficiencyIdcsScannerThresholdInactiveTime); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLastOpBegin != nil {

		// query param efficiency.last_op_begin
		var qrEfficiencyLastOpBegin string

		if o.EfficiencyLastOpBegin != nil {
			qrEfficiencyLastOpBegin = *o.EfficiencyLastOpBegin
		}
		qEfficiencyLastOpBegin := qrEfficiencyLastOpBegin
		if qEfficiencyLastOpBegin != "" {

			if err := r.SetQueryParam("efficiency.last_op_begin", qEfficiencyLastOpBegin); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLastOpEnd != nil {

		// query param efficiency.last_op_end
		var qrEfficiencyLastOpEnd string

		if o.EfficiencyLastOpEnd != nil {
			qrEfficiencyLastOpEnd = *o.EfficiencyLastOpEnd
		}
		qEfficiencyLastOpEnd := qrEfficiencyLastOpEnd
		if qEfficiencyLastOpEnd != "" {

			if err := r.SetQueryParam("efficiency.last_op_end", qEfficiencyLastOpEnd); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLastOpErr != nil {

		// query param efficiency.last_op_err
		var qrEfficiencyLastOpErr string

		if o.EfficiencyLastOpErr != nil {
			qrEfficiencyLastOpErr = *o.EfficiencyLastOpErr
		}
		qEfficiencyLastOpErr := qrEfficiencyLastOpErr
		if qEfficiencyLastOpErr != "" {

			if err := r.SetQueryParam("efficiency.last_op_err", qEfficiencyLastOpErr); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLastOpSize != nil {

		// query param efficiency.last_op_size
		var qrEfficiencyLastOpSize int64

		if o.EfficiencyLastOpSize != nil {
			qrEfficiencyLastOpSize = *o.EfficiencyLastOpSize
		}
		qEfficiencyLastOpSize := swag.FormatInt64(qrEfficiencyLastOpSize)
		if qEfficiencyLastOpSize != "" {

			if err := r.SetQueryParam("efficiency.last_op_size", qEfficiencyLastOpSize); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLastOpState != nil {

		// query param efficiency.last_op_state
		var qrEfficiencyLastOpState string

		if o.EfficiencyLastOpState != nil {
			qrEfficiencyLastOpState = *o.EfficiencyLastOpState
		}
		qEfficiencyLastOpState := qrEfficiencyLastOpState
		if qEfficiencyLastOpState != "" {

			if err := r.SetQueryParam("efficiency.last_op_state", qEfficiencyLastOpState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyLoggingEnabled != nil {

		// query param efficiency.logging_enabled
		var qrEfficiencyLoggingEnabled bool

		if o.EfficiencyLoggingEnabled != nil {
			qrEfficiencyLoggingEnabled = *o.EfficiencyLoggingEnabled
		}
		qEfficiencyLoggingEnabled := swag.FormatBool(qrEfficiencyLoggingEnabled)
		if qEfficiencyLoggingEnabled != "" {

			if err := r.SetQueryParam("efficiency.logging_enabled", qEfficiencyLoggingEnabled); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyOpState != nil {

		// query param efficiency.op_state
		var qrEfficiencyOpState string

		if o.EfficiencyOpState != nil {
			qrEfficiencyOpState = *o.EfficiencyOpState
		}
		qEfficiencyOpState := qrEfficiencyOpState
		if qEfficiencyOpState != "" {

			if err := r.SetQueryParam("efficiency.op_state", qEfficiencyOpState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyPolicyName != nil {

		// query param efficiency.policy.name
		var qrEfficiencyPolicyName string

		if o.EfficiencyPolicyName != nil {
			qrEfficiencyPolicyName = *o.EfficiencyPolicyName
		}
		qEfficiencyPolicyName := qrEfficiencyPolicyName
		if qEfficiencyPolicyName != "" {

			if err := r.SetQueryParam("efficiency.policy.name", qEfficiencyPolicyName); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyProgress != nil {

		// query param efficiency.progress
		var qrEfficiencyProgress string

		if o.EfficiencyProgress != nil {
			qrEfficiencyProgress = *o.EfficiencyProgress
		}
		qEfficiencyProgress := qrEfficiencyProgress
		if qEfficiencyProgress != "" {

			if err := r.SetQueryParam("efficiency.progress", qEfficiencyProgress); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyRatio != nil {

		// query param efficiency.ratio
		var qrEfficiencyRatio float64

		if o.EfficiencyRatio != nil {
			qrEfficiencyRatio = *o.EfficiencyRatio
		}
		qEfficiencyRatio := swag.FormatFloat64(qrEfficiencyRatio)
		if qEfficiencyRatio != "" {

			if err := r.SetQueryParam("efficiency.ratio", qEfficiencyRatio); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyScannerCompression != nil {

		// query param efficiency.scanner.compression
		var qrEfficiencyScannerCompression bool

		if o.EfficiencyScannerCompression != nil {
			qrEfficiencyScannerCompression = *o.EfficiencyScannerCompression
		}
		qEfficiencyScannerCompression := swag.FormatBool(qrEfficiencyScannerCompression)
		if qEfficiencyScannerCompression != "" {

			if err := r.SetQueryParam("efficiency.scanner.compression", qEfficiencyScannerCompression); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyScannerDedupe != nil {

		// query param efficiency.scanner.dedupe
		var qrEfficiencyScannerDedupe bool

		if o.EfficiencyScannerDedupe != nil {
			qrEfficiencyScannerDedupe = *o.EfficiencyScannerDedupe
		}
		qEfficiencyScannerDedupe := swag.FormatBool(qrEfficiencyScannerDedupe)
		if qEfficiencyScannerDedupe != "" {

			if err := r.SetQueryParam("efficiency.scanner.dedupe", qEfficiencyScannerDedupe); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyScannerScanOldData != nil {

		// query param efficiency.scanner.scan_old_data
		var qrEfficiencyScannerScanOldData bool

		if o.EfficiencyScannerScanOldData != nil {
			qrEfficiencyScannerScanOldData = *o.EfficiencyScannerScanOldData
		}
		qEfficiencyScannerScanOldData := swag.FormatBool(qrEfficiencyScannerScanOldData)
		if qEfficiencyScannerScanOldData != "" {

			if err := r.SetQueryParam("efficiency.scanner.scan_old_data", qEfficiencyScannerScanOldData); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyScannerState != nil {

		// query param efficiency.scanner.state
		var qrEfficiencyScannerState string

		if o.EfficiencyScannerState != nil {
			qrEfficiencyScannerState = *o.EfficiencyScannerState
		}
		qEfficiencyScannerState := qrEfficiencyScannerState
		if qEfficiencyScannerState != "" {

			if err := r.SetQueryParam("efficiency.scanner.state", qEfficiencyScannerState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySchedule != nil {

		// query param efficiency.schedule
		var qrEfficiencySchedule string

		if o.EfficiencySchedule != nil {
			qrEfficiencySchedule = *o.EfficiencySchedule
		}
		qEfficiencySchedule := qrEfficiencySchedule
		if qEfficiencySchedule != "" {

			if err := r.SetQueryParam("efficiency.schedule", qEfficiencySchedule); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsCompression != nil {

		// query param efficiency.space_savings.compression
		var qrEfficiencySpaceSavingsCompression int64

		if o.EfficiencySpaceSavingsCompression != nil {
			qrEfficiencySpaceSavingsCompression = *o.EfficiencySpaceSavingsCompression
		}
		qEfficiencySpaceSavingsCompression := swag.FormatInt64(qrEfficiencySpaceSavingsCompression)
		if qEfficiencySpaceSavingsCompression != "" {

			if err := r.SetQueryParam("efficiency.space_savings.compression", qEfficiencySpaceSavingsCompression); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsCompressionPercent != nil {

		// query param efficiency.space_savings.compression_percent
		var qrEfficiencySpaceSavingsCompressionPercent int64

		if o.EfficiencySpaceSavingsCompressionPercent != nil {
			qrEfficiencySpaceSavingsCompressionPercent = *o.EfficiencySpaceSavingsCompressionPercent
		}
		qEfficiencySpaceSavingsCompressionPercent := swag.FormatInt64(qrEfficiencySpaceSavingsCompressionPercent)
		if qEfficiencySpaceSavingsCompressionPercent != "" {

			if err := r.SetQueryParam("efficiency.space_savings.compression_percent", qEfficiencySpaceSavingsCompressionPercent); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsDedupe != nil {

		// query param efficiency.space_savings.dedupe
		var qrEfficiencySpaceSavingsDedupe int64

		if o.EfficiencySpaceSavingsDedupe != nil {
			qrEfficiencySpaceSavingsDedupe = *o.EfficiencySpaceSavingsDedupe
		}
		qEfficiencySpaceSavingsDedupe := swag.FormatInt64(qrEfficiencySpaceSavingsDedupe)
		if qEfficiencySpaceSavingsDedupe != "" {

			if err := r.SetQueryParam("efficiency.space_savings.dedupe", qEfficiencySpaceSavingsDedupe); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsDedupePercent != nil {

		// query param efficiency.space_savings.dedupe_percent
		var qrEfficiencySpaceSavingsDedupePercent int64

		if o.EfficiencySpaceSavingsDedupePercent != nil {
			qrEfficiencySpaceSavingsDedupePercent = *o.EfficiencySpaceSavingsDedupePercent
		}
		qEfficiencySpaceSavingsDedupePercent := swag.FormatInt64(qrEfficiencySpaceSavingsDedupePercent)
		if qEfficiencySpaceSavingsDedupePercent != "" {

			if err := r.SetQueryParam("efficiency.space_savings.dedupe_percent", qEfficiencySpaceSavingsDedupePercent); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsDedupeSharing != nil {

		// query param efficiency.space_savings.dedupe_sharing
		var qrEfficiencySpaceSavingsDedupeSharing int64

		if o.EfficiencySpaceSavingsDedupeSharing != nil {
			qrEfficiencySpaceSavingsDedupeSharing = *o.EfficiencySpaceSavingsDedupeSharing
		}
		qEfficiencySpaceSavingsDedupeSharing := swag.FormatInt64(qrEfficiencySpaceSavingsDedupeSharing)
		if qEfficiencySpaceSavingsDedupeSharing != "" {

			if err := r.SetQueryParam("efficiency.space_savings.dedupe_sharing", qEfficiencySpaceSavingsDedupeSharing); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsTotal != nil {

		// query param efficiency.space_savings.total
		var qrEfficiencySpaceSavingsTotal int64

		if o.EfficiencySpaceSavingsTotal != nil {
			qrEfficiencySpaceSavingsTotal = *o.EfficiencySpaceSavingsTotal
		}
		qEfficiencySpaceSavingsTotal := swag.FormatInt64(qrEfficiencySpaceSavingsTotal)
		if qEfficiencySpaceSavingsTotal != "" {

			if err := r.SetQueryParam("efficiency.space_savings.total", qEfficiencySpaceSavingsTotal); err != nil {
				return err
			}
		}
	}

	if o.EfficiencySpaceSavingsTotalPercent != nil {

		// query param efficiency.space_savings.total_percent
		var qrEfficiencySpaceSavingsTotalPercent int64

		if o.EfficiencySpaceSavingsTotalPercent != nil {
			qrEfficiencySpaceSavingsTotalPercent = *o.EfficiencySpaceSavingsTotalPercent
		}
		qEfficiencySpaceSavingsTotalPercent := swag.FormatInt64(qrEfficiencySpaceSavingsTotalPercent)
		if qEfficiencySpaceSavingsTotalPercent != "" {

			if err := r.SetQueryParam("efficiency.space_savings.total_percent", qEfficiencySpaceSavingsTotalPercent); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyState != nil {

		// query param efficiency.state
		var qrEfficiencyState string

		if o.EfficiencyState != nil {
			qrEfficiencyState = *o.EfficiencyState
		}
		qEfficiencyState := qrEfficiencyState
		if qEfficiencyState != "" {

			if err := r.SetQueryParam("efficiency.state", qEfficiencyState); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyStorageEfficiencyMode != nil {

		// query param efficiency.storage_efficiency_mode
		var qrEfficiencyStorageEfficiencyMode string

		if o.EfficiencyStorageEfficiencyMode != nil {
			qrEfficiencyStorageEfficiencyMode = *o.EfficiencyStorageEfficiencyMode
		}
		qEfficiencyStorageEfficiencyMode := qrEfficiencyStorageEfficiencyMode
		if qEfficiencyStorageEfficiencyMode != "" {

			if err := r.SetQueryParam("efficiency.storage_efficiency_mode", qEfficiencyStorageEfficiencyMode); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyType != nil {

		// query param efficiency.type
		var qrEfficiencyType string

		if o.EfficiencyType != nil {
			qrEfficiencyType = *o.EfficiencyType
		}
		qEfficiencyType := qrEfficiencyType
		if qEfficiencyType != "" {

			if err := r.SetQueryParam("efficiency.type", qEfficiencyType); err != nil {
				return err
			}
		}
	}

	if o.EfficiencyVolumePath != nil {

		// query param efficiency.volume_path
		var qrEfficiencyVolumePath string

		if o.EfficiencyVolumePath != nil {
			qrEfficiencyVolumePath = *o.EfficiencyVolumePath
		}
		qEfficiencyVolumePath := qrEfficiencyVolumePath
		if qEfficiencyVolumePath != "" {

			if err := r.SetQueryParam("efficiency.volume_path", qEfficiencyVolumePath); err != nil {
				return err
			}
		}
	}

	if o.EncryptionAction != nil {

		// query param encryption.action
		var qrEncryptionAction string

		if o.EncryptionAction != nil {
			qrEncryptionAction = *o.EncryptionAction
		}
		qEncryptionAction := qrEncryptionAction
		if qEncryptionAction != "" {

			if err := r.SetQueryParam("encryption.action", qEncryptionAction); err != nil {
				return err
			}
		}
	}

	if o.EncryptionEnabled != nil {

		// query param encryption.enabled
		var qrEncryptionEnabled bool

		if o.EncryptionEnabled != nil {
			qrEncryptionEnabled = *o.EncryptionEnabled
		}
		qEncryptionEnabled := swag.FormatBool(qrEncryptionEnabled)
		if qEncryptionEnabled != "" {

			if err := r.SetQueryParam("encryption.enabled", qEncryptionEnabled); err != nil {
				return err
			}
		}
	}

	if o.EncryptionKeyCreateTime != nil {

		// query param encryption.key_create_time
		var qrEncryptionKeyCreateTime string

		if o.EncryptionKeyCreateTime != nil {
			qrEncryptionKeyCreateTime = *o.EncryptionKeyCreateTime
		}
		qEncryptionKeyCreateTime := qrEncryptionKeyCreateTime
		if qEncryptionKeyCreateTime != "" {

			if err := r.SetQueryParam("encryption.key_create_time", qEncryptionKeyCreateTime); err != nil {
				return err
			}
		}
	}

	if o.EncryptionKeyID != nil {

		// query param encryption.key_id
		var qrEncryptionKeyID string

		if o.EncryptionKeyID != nil {
			qrEncryptionKeyID = *o.EncryptionKeyID
		}
		qEncryptionKeyID := qrEncryptionKeyID
		if qEncryptionKeyID != "" {

			if err := r.SetQueryParam("encryption.key_id", qEncryptionKeyID); err != nil {
				return err
			}
		}
	}

	if o.EncryptionRekey != nil {

		// query param encryption.rekey
		var qrEncryptionRekey bool

		if o.EncryptionRekey != nil {
			qrEncryptionRekey = *o.EncryptionRekey
		}
		qEncryptionRekey := swag.FormatBool(qrEncryptionRekey)
		if qEncryptionRekey != "" {

			if err := r.SetQueryParam("encryption.rekey", qEncryptionRekey); err != nil {
				return err
			}
		}
	}

	if o.EncryptionState != nil {

		// query param encryption.state
		var qrEncryptionState string

		if o.EncryptionState != nil {
			qrEncryptionState = *o.EncryptionState
		}
		qEncryptionState := qrEncryptionState
		if qEncryptionState != "" {

			if err := r.SetQueryParam("encryption.state", qEncryptionState); err != nil {
				return err
			}
		}
	}

	if o.EncryptionStatusCode != nil {

		// query param encryption.status.code
		var qrEncryptionStatusCode string

		if o.EncryptionStatusCode != nil {
			qrEncryptionStatusCode = *o.EncryptionStatusCode
		}
		qEncryptionStatusCode := qrEncryptionStatusCode
		if qEncryptionStatusCode != "" {

			if err := r.SetQueryParam("encryption.status.code", qEncryptionStatusCode); err != nil {
				return err
			}
		}
	}

	if o.EncryptionStatusMessage != nil {

		// query param encryption.status.message
		var qrEncryptionStatusMessage string

		if o.EncryptionStatusMessage != nil {
			qrEncryptionStatusMessage = *o.EncryptionStatusMessage
		}
		qEncryptionStatusMessage := qrEncryptionStatusMessage
		if qEncryptionStatusMessage != "" {

			if err := r.SetQueryParam("encryption.status.message", qEncryptionStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.EncryptionType != nil {

		// query param encryption.type
		var qrEncryptionType string

		if o.EncryptionType != nil {
			qrEncryptionType = *o.EncryptionType
		}
		qEncryptionType := qrEncryptionType
		if qEncryptionType != "" {

			if err := r.SetQueryParam("encryption.type", qEncryptionType); err != nil {
				return err
			}
		}
	}

	if o.ErrorStateHasBadBlocks != nil {

		// query param error_state.has_bad_blocks
		var qrErrorStateHasBadBlocks bool

		if o.ErrorStateHasBadBlocks != nil {
			qrErrorStateHasBadBlocks = *o.ErrorStateHasBadBlocks
		}
		qErrorStateHasBadBlocks := swag.FormatBool(qrErrorStateHasBadBlocks)
		if qErrorStateHasBadBlocks != "" {

			if err := r.SetQueryParam("error_state.has_bad_blocks", qErrorStateHasBadBlocks); err != nil {
				return err
			}
		}
	}

	if o.ErrorStateIsInconsistent != nil {

		// query param error_state.is_inconsistent
		var qrErrorStateIsInconsistent bool

		if o.ErrorStateIsInconsistent != nil {
			qrErrorStateIsInconsistent = *o.ErrorStateIsInconsistent
		}
		qErrorStateIsInconsistent := swag.FormatBool(qrErrorStateIsInconsistent)
		if qErrorStateIsInconsistent != "" {

			if err := r.SetQueryParam("error_state.is_inconsistent", qErrorStateIsInconsistent); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FilesInodefileCapacity != nil {

		// query param files.inodefile_capacity
		var qrFilesInodefileCapacity int64

		if o.FilesInodefileCapacity != nil {
			qrFilesInodefileCapacity = *o.FilesInodefileCapacity
		}
		qFilesInodefileCapacity := swag.FormatInt64(qrFilesInodefileCapacity)
		if qFilesInodefileCapacity != "" {

			if err := r.SetQueryParam("files.inodefile_capacity", qFilesInodefileCapacity); err != nil {
				return err
			}
		}
	}

	if o.FilesMaximum != nil {

		// query param files.maximum
		var qrFilesMaximum int64

		if o.FilesMaximum != nil {
			qrFilesMaximum = *o.FilesMaximum
		}
		qFilesMaximum := swag.FormatInt64(qrFilesMaximum)
		if qFilesMaximum != "" {

			if err := r.SetQueryParam("files.maximum", qFilesMaximum); err != nil {
				return err
			}
		}
	}

	if o.FilesUsed != nil {

		// query param files.used
		var qrFilesUsed int64

		if o.FilesUsed != nil {
			qrFilesUsed = *o.FilesUsed
		}
		qFilesUsed := swag.FormatInt64(qrFilesUsed)
		if qFilesUsed != "" {

			if err := r.SetQueryParam("files.used", qFilesUsed); err != nil {
				return err
			}
		}
	}

	if o.FlashPoolCacheEligibility != nil {

		// query param flash_pool.cache_eligibility
		var qrFlashPoolCacheEligibility string

		if o.FlashPoolCacheEligibility != nil {
			qrFlashPoolCacheEligibility = *o.FlashPoolCacheEligibility
		}
		qFlashPoolCacheEligibility := qrFlashPoolCacheEligibility
		if qFlashPoolCacheEligibility != "" {

			if err := r.SetQueryParam("flash_pool.cache_eligibility", qFlashPoolCacheEligibility); err != nil {
				return err
			}
		}
	}

	if o.FlashPoolCacheRetentionPriority != nil {

		// query param flash_pool.cache_retention_priority
		var qrFlashPoolCacheRetentionPriority string

		if o.FlashPoolCacheRetentionPriority != nil {
			qrFlashPoolCacheRetentionPriority = *o.FlashPoolCacheRetentionPriority
		}
		qFlashPoolCacheRetentionPriority := qrFlashPoolCacheRetentionPriority
		if qFlashPoolCacheRetentionPriority != "" {

			if err := r.SetQueryParam("flash_pool.cache_retention_priority", qFlashPoolCacheRetentionPriority); err != nil {
				return err
			}
		}
	}

	if o.FlashPoolCachingPolicy != nil {

		// query param flash_pool.caching_policy
		var qrFlashPoolCachingPolicy string

		if o.FlashPoolCachingPolicy != nil {
			qrFlashPoolCachingPolicy = *o.FlashPoolCachingPolicy
		}
		qFlashPoolCachingPolicy := qrFlashPoolCachingPolicy
		if qFlashPoolCachingPolicy != "" {

			if err := r.SetQueryParam("flash_pool.caching_policy", qFlashPoolCachingPolicy); err != nil {
				return err
			}
		}
	}

	if o.FlexcacheEndpointType != nil {

		// query param flexcache_endpoint_type
		var qrFlexcacheEndpointType string

		if o.FlexcacheEndpointType != nil {
			qrFlexcacheEndpointType = *o.FlexcacheEndpointType
		}
		qFlexcacheEndpointType := qrFlexcacheEndpointType
		if qFlexcacheEndpointType != "" {

			if err := r.SetQueryParam("flexcache_endpoint_type", qFlexcacheEndpointType); err != nil {
				return err
			}
		}
	}

	if o.FlexgroupName != nil {

		// query param flexgroup.name
		var qrFlexgroupName string

		if o.FlexgroupName != nil {
			qrFlexgroupName = *o.FlexgroupName
		}
		qFlexgroupName := qrFlexgroupName
		if qFlexgroupName != "" {

			if err := r.SetQueryParam("flexgroup.name", qFlexgroupName); err != nil {
				return err
			}
		}
	}

	if o.FlexgroupUUID != nil {

		// query param flexgroup.uuid
		var qrFlexgroupUUID string

		if o.FlexgroupUUID != nil {
			qrFlexgroupUUID = *o.FlexgroupUUID
		}
		qFlexgroupUUID := qrFlexgroupUUID
		if qFlexgroupUUID != "" {

			if err := r.SetQueryParam("flexgroup.uuid", qFlexgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.GranularData != nil {

		// query param granular_data
		var qrGranularData bool

		if o.GranularData != nil {
			qrGranularData = *o.GranularData
		}
		qGranularData := swag.FormatBool(qrGranularData)
		if qGranularData != "" {

			if err := r.SetQueryParam("granular_data", qGranularData); err != nil {
				return err
			}
		}
	}

	if o.GranularDataMode != nil {

		// query param granular_data_mode
		var qrGranularDataMode string

		if o.GranularDataMode != nil {
			qrGranularDataMode = *o.GranularDataMode
		}
		qGranularDataMode := qrGranularDataMode
		if qGranularDataMode != "" {

			if err := r.SetQueryParam("granular_data_mode", qGranularDataMode); err != nil {
				return err
			}
		}
	}

	if o.GuaranteeHonored != nil {

		// query param guarantee.honored
		var qrGuaranteeHonored bool

		if o.GuaranteeHonored != nil {
			qrGuaranteeHonored = *o.GuaranteeHonored
		}
		qGuaranteeHonored := swag.FormatBool(qrGuaranteeHonored)
		if qGuaranteeHonored != "" {

			if err := r.SetQueryParam("guarantee.honored", qGuaranteeHonored); err != nil {
				return err
			}
		}
	}

	if o.GuaranteeType != nil {

		// query param guarantee.type
		var qrGuaranteeType string

		if o.GuaranteeType != nil {
			qrGuaranteeType = *o.GuaranteeType
		}
		qGuaranteeType := qrGuaranteeType
		if qGuaranteeType != "" {

			if err := r.SetQueryParam("guarantee.type", qGuaranteeType); err != nil {
				return err
			}
		}
	}

	if o.HasDirIndexPublic != nil {

		// query param has_dir_index_public
		var qrHasDirIndexPublic bool

		if o.HasDirIndexPublic != nil {
			qrHasDirIndexPublic = *o.HasDirIndexPublic
		}
		qHasDirIndexPublic := swag.FormatBool(qrHasDirIndexPublic)
		if qHasDirIndexPublic != "" {

			if err := r.SetQueryParam("has_dir_index_public", qHasDirIndexPublic); err != nil {
				return err
			}
		}
	}

	if o.HasLargeDir != nil {

		// query param has_large_dir
		var qrHasLargeDir bool

		if o.HasLargeDir != nil {
			qrHasLargeDir = *o.HasLargeDir
		}
		qHasLargeDir := swag.FormatBool(qrHasLargeDir)
		if qHasLargeDir != "" {

			if err := r.SetQueryParam("has_large_dir", qHasLargeDir); err != nil {
				return err
			}
		}
	}

	if o.IsConstituent != nil {

		// query param is_constituent
		var qrIsConstituent bool

		if o.IsConstituent != nil {
			qrIsConstituent = *o.IsConstituent
		}
		qIsConstituent := swag.FormatBool(qrIsConstituent)
		if qIsConstituent != "" {

			if err := r.SetQueryParam("is_constituent", qIsConstituent); err != nil {
				return err
			}
		}
	}

	if o.IsDirIndexTransferEnabled != nil {

		// query param is_dir_index_transfer_enabled
		var qrIsDirIndexTransferEnabled bool

		if o.IsDirIndexTransferEnabled != nil {
			qrIsDirIndexTransferEnabled = *o.IsDirIndexTransferEnabled
		}
		qIsDirIndexTransferEnabled := swag.FormatBool(qrIsDirIndexTransferEnabled)
		if qIsDirIndexTransferEnabled != "" {

			if err := r.SetQueryParam("is_dir_index_transfer_enabled", qIsDirIndexTransferEnabled); err != nil {
				return err
			}
		}
	}

	if o.IsLargeDirEnabled != nil {

		// query param is_large_dir_enabled
		var qrIsLargeDirEnabled bool

		if o.IsLargeDirEnabled != nil {
			qrIsLargeDirEnabled = *o.IsLargeDirEnabled
		}
		qIsLargeDirEnabled := swag.FormatBool(qrIsLargeDirEnabled)
		if qIsLargeDirEnabled != "" {

			if err := r.SetQueryParam("is_large_dir_enabled", qIsLargeDirEnabled); err != nil {
				return err
			}
		}
	}

	if o.IsObjectStore != nil {

		// query param is_object_store
		var qrIsObjectStore bool

		if o.IsObjectStore != nil {
			qrIsObjectStore = *o.IsObjectStore
		}
		qIsObjectStore := swag.FormatBool(qrIsObjectStore)
		if qIsObjectStore != "" {

			if err := r.SetQueryParam("is_object_store", qIsObjectStore); err != nil {
				return err
			}
		}
	}

	if o.IsS3ArbitraryPartSizeEnabled != nil {

		// query param is_s3_arbitrary_part_size_enabled
		var qrIsS3ArbitraryPartSizeEnabled bool

		if o.IsS3ArbitraryPartSizeEnabled != nil {
			qrIsS3ArbitraryPartSizeEnabled = *o.IsS3ArbitraryPartSizeEnabled
		}
		qIsS3ArbitraryPartSizeEnabled := swag.FormatBool(qrIsS3ArbitraryPartSizeEnabled)
		if qIsS3ArbitraryPartSizeEnabled != "" {

			if err := r.SetQueryParam("is_s3_arbitrary_part_size_enabled", qIsS3ArbitraryPartSizeEnabled); err != nil {
				return err
			}
		}
	}

	if o.IsSvmRoot != nil {

		// query param is_svm_root
		var qrIsSvmRoot bool

		if o.IsSvmRoot != nil {
			qrIsSvmRoot = *o.IsSvmRoot
		}
		qIsSvmRoot := swag.FormatBool(qrIsSvmRoot)
		if qIsSvmRoot != "" {

			if err := r.SetQueryParam("is_svm_root", qIsSvmRoot); err != nil {
				return err
			}
		}
	}

	if o.Language != nil {

		// query param language
		var qrLanguage string

		if o.Language != nil {
			qrLanguage = *o.Language
		}
		qLanguage := qrLanguage
		if qLanguage != "" {

			if err := r.SetQueryParam("language", qLanguage); err != nil {
				return err
			}
		}
	}

	if o.MaxDirSize != nil {

		// query param max_dir_size
		var qrMaxDirSize int64

		if o.MaxDirSize != nil {
			qrMaxDirSize = *o.MaxDirSize
		}
		qMaxDirSize := swag.FormatInt64(qrMaxDirSize)
		if qMaxDirSize != "" {

			if err := r.SetQueryParam("max_dir_size", qMaxDirSize); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudDuration != nil {

		// query param metric.cloud.duration
		var qrMetricCloudDuration string

		if o.MetricCloudDuration != nil {
			qrMetricCloudDuration = *o.MetricCloudDuration
		}
		qMetricCloudDuration := qrMetricCloudDuration
		if qMetricCloudDuration != "" {

			if err := r.SetQueryParam("metric.cloud.duration", qMetricCloudDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudIopsOther != nil {

		// query param metric.cloud.iops.other
		var qrMetricCloudIopsOther int64

		if o.MetricCloudIopsOther != nil {
			qrMetricCloudIopsOther = *o.MetricCloudIopsOther
		}
		qMetricCloudIopsOther := swag.FormatInt64(qrMetricCloudIopsOther)
		if qMetricCloudIopsOther != "" {

			if err := r.SetQueryParam("metric.cloud.iops.other", qMetricCloudIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudIopsRead != nil {

		// query param metric.cloud.iops.read
		var qrMetricCloudIopsRead int64

		if o.MetricCloudIopsRead != nil {
			qrMetricCloudIopsRead = *o.MetricCloudIopsRead
		}
		qMetricCloudIopsRead := swag.FormatInt64(qrMetricCloudIopsRead)
		if qMetricCloudIopsRead != "" {

			if err := r.SetQueryParam("metric.cloud.iops.read", qMetricCloudIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudIopsTotal != nil {

		// query param metric.cloud.iops.total
		var qrMetricCloudIopsTotal int64

		if o.MetricCloudIopsTotal != nil {
			qrMetricCloudIopsTotal = *o.MetricCloudIopsTotal
		}
		qMetricCloudIopsTotal := swag.FormatInt64(qrMetricCloudIopsTotal)
		if qMetricCloudIopsTotal != "" {

			if err := r.SetQueryParam("metric.cloud.iops.total", qMetricCloudIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudIopsWrite != nil {

		// query param metric.cloud.iops.write
		var qrMetricCloudIopsWrite int64

		if o.MetricCloudIopsWrite != nil {
			qrMetricCloudIopsWrite = *o.MetricCloudIopsWrite
		}
		qMetricCloudIopsWrite := swag.FormatInt64(qrMetricCloudIopsWrite)
		if qMetricCloudIopsWrite != "" {

			if err := r.SetQueryParam("metric.cloud.iops.write", qMetricCloudIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudLatencyOther != nil {

		// query param metric.cloud.latency.other
		var qrMetricCloudLatencyOther int64

		if o.MetricCloudLatencyOther != nil {
			qrMetricCloudLatencyOther = *o.MetricCloudLatencyOther
		}
		qMetricCloudLatencyOther := swag.FormatInt64(qrMetricCloudLatencyOther)
		if qMetricCloudLatencyOther != "" {

			if err := r.SetQueryParam("metric.cloud.latency.other", qMetricCloudLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudLatencyRead != nil {

		// query param metric.cloud.latency.read
		var qrMetricCloudLatencyRead int64

		if o.MetricCloudLatencyRead != nil {
			qrMetricCloudLatencyRead = *o.MetricCloudLatencyRead
		}
		qMetricCloudLatencyRead := swag.FormatInt64(qrMetricCloudLatencyRead)
		if qMetricCloudLatencyRead != "" {

			if err := r.SetQueryParam("metric.cloud.latency.read", qMetricCloudLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudLatencyTotal != nil {

		// query param metric.cloud.latency.total
		var qrMetricCloudLatencyTotal int64

		if o.MetricCloudLatencyTotal != nil {
			qrMetricCloudLatencyTotal = *o.MetricCloudLatencyTotal
		}
		qMetricCloudLatencyTotal := swag.FormatInt64(qrMetricCloudLatencyTotal)
		if qMetricCloudLatencyTotal != "" {

			if err := r.SetQueryParam("metric.cloud.latency.total", qMetricCloudLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudLatencyWrite != nil {

		// query param metric.cloud.latency.write
		var qrMetricCloudLatencyWrite int64

		if o.MetricCloudLatencyWrite != nil {
			qrMetricCloudLatencyWrite = *o.MetricCloudLatencyWrite
		}
		qMetricCloudLatencyWrite := swag.FormatInt64(qrMetricCloudLatencyWrite)
		if qMetricCloudLatencyWrite != "" {

			if err := r.SetQueryParam("metric.cloud.latency.write", qMetricCloudLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudStatus != nil {

		// query param metric.cloud.status
		var qrMetricCloudStatus string

		if o.MetricCloudStatus != nil {
			qrMetricCloudStatus = *o.MetricCloudStatus
		}
		qMetricCloudStatus := qrMetricCloudStatus
		if qMetricCloudStatus != "" {

			if err := r.SetQueryParam("metric.cloud.status", qMetricCloudStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricCloudTimestamp != nil {

		// query param metric.cloud.timestamp
		var qrMetricCloudTimestamp string

		if o.MetricCloudTimestamp != nil {
			qrMetricCloudTimestamp = *o.MetricCloudTimestamp
		}
		qMetricCloudTimestamp := qrMetricCloudTimestamp
		if qMetricCloudTimestamp != "" {

			if err := r.SetQueryParam("metric.cloud.timestamp", qMetricCloudTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricFlexcacheBandwidthSavings != nil {

		// query param metric.flexcache.bandwidth_savings
		var qrMetricFlexcacheBandwidthSavings int64

		if o.MetricFlexcacheBandwidthSavings != nil {
			qrMetricFlexcacheBandwidthSavings = *o.MetricFlexcacheBandwidthSavings
		}
		qMetricFlexcacheBandwidthSavings := swag.FormatInt64(qrMetricFlexcacheBandwidthSavings)
		if qMetricFlexcacheBandwidthSavings != "" {

			if err := r.SetQueryParam("metric.flexcache.bandwidth_savings", qMetricFlexcacheBandwidthSavings); err != nil {
				return err
			}
		}
	}

	if o.MetricFlexcacheCacheMissPercent != nil {

		// query param metric.flexcache.cache_miss_percent
		var qrMetricFlexcacheCacheMissPercent int64

		if o.MetricFlexcacheCacheMissPercent != nil {
			qrMetricFlexcacheCacheMissPercent = *o.MetricFlexcacheCacheMissPercent
		}
		qMetricFlexcacheCacheMissPercent := swag.FormatInt64(qrMetricFlexcacheCacheMissPercent)
		if qMetricFlexcacheCacheMissPercent != "" {

			if err := r.SetQueryParam("metric.flexcache.cache_miss_percent", qMetricFlexcacheCacheMissPercent); err != nil {
				return err
			}
		}
	}

	if o.MetricFlexcacheDuration != nil {

		// query param metric.flexcache.duration
		var qrMetricFlexcacheDuration string

		if o.MetricFlexcacheDuration != nil {
			qrMetricFlexcacheDuration = *o.MetricFlexcacheDuration
		}
		qMetricFlexcacheDuration := qrMetricFlexcacheDuration
		if qMetricFlexcacheDuration != "" {

			if err := r.SetQueryParam("metric.flexcache.duration", qMetricFlexcacheDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricFlexcacheStatus != nil {

		// query param metric.flexcache.status
		var qrMetricFlexcacheStatus string

		if o.MetricFlexcacheStatus != nil {
			qrMetricFlexcacheStatus = *o.MetricFlexcacheStatus
		}
		qMetricFlexcacheStatus := qrMetricFlexcacheStatus
		if qMetricFlexcacheStatus != "" {

			if err := r.SetQueryParam("metric.flexcache.status", qMetricFlexcacheStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricFlexcacheTimestamp != nil {

		// query param metric.flexcache.timestamp
		var qrMetricFlexcacheTimestamp string

		if o.MetricFlexcacheTimestamp != nil {
			qrMetricFlexcacheTimestamp = *o.MetricFlexcacheTimestamp
		}
		qMetricFlexcacheTimestamp := qrMetricFlexcacheTimestamp
		if qMetricFlexcacheTimestamp != "" {

			if err := r.SetQueryParam("metric.flexcache.timestamp", qMetricFlexcacheTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputOther != nil {

		// query param metric.throughput.other
		var qrMetricThroughputOther int64

		if o.MetricThroughputOther != nil {
			qrMetricThroughputOther = *o.MetricThroughputOther
		}
		qMetricThroughputOther := swag.FormatInt64(qrMetricThroughputOther)
		if qMetricThroughputOther != "" {

			if err := r.SetQueryParam("metric.throughput.other", qMetricThroughputOther); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MovementCapacityTierOptimized != nil {

		// query param movement.capacity_tier_optimized
		var qrMovementCapacityTierOptimized bool

		if o.MovementCapacityTierOptimized != nil {
			qrMovementCapacityTierOptimized = *o.MovementCapacityTierOptimized
		}
		qMovementCapacityTierOptimized := swag.FormatBool(qrMovementCapacityTierOptimized)
		if qMovementCapacityTierOptimized != "" {

			if err := r.SetQueryParam("movement.capacity_tier_optimized", qMovementCapacityTierOptimized); err != nil {
				return err
			}
		}
	}

	if o.MovementCutoverWindow != nil {

		// query param movement.cutover_window
		var qrMovementCutoverWindow int64

		if o.MovementCutoverWindow != nil {
			qrMovementCutoverWindow = *o.MovementCutoverWindow
		}
		qMovementCutoverWindow := swag.FormatInt64(qrMovementCutoverWindow)
		if qMovementCutoverWindow != "" {

			if err := r.SetQueryParam("movement.cutover_window", qMovementCutoverWindow); err != nil {
				return err
			}
		}
	}

	if o.MovementDestinationAggregateName != nil {

		// query param movement.destination_aggregate.name
		var qrMovementDestinationAggregateName string

		if o.MovementDestinationAggregateName != nil {
			qrMovementDestinationAggregateName = *o.MovementDestinationAggregateName
		}
		qMovementDestinationAggregateName := qrMovementDestinationAggregateName
		if qMovementDestinationAggregateName != "" {

			if err := r.SetQueryParam("movement.destination_aggregate.name", qMovementDestinationAggregateName); err != nil {
				return err
			}
		}
	}

	if o.MovementDestinationAggregateUUID != nil {

		// query param movement.destination_aggregate.uuid
		var qrMovementDestinationAggregateUUID string

		if o.MovementDestinationAggregateUUID != nil {
			qrMovementDestinationAggregateUUID = *o.MovementDestinationAggregateUUID
		}
		qMovementDestinationAggregateUUID := qrMovementDestinationAggregateUUID
		if qMovementDestinationAggregateUUID != "" {

			if err := r.SetQueryParam("movement.destination_aggregate.uuid", qMovementDestinationAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.MovementPercentComplete != nil {

		// query param movement.percent_complete
		var qrMovementPercentComplete int64

		if o.MovementPercentComplete != nil {
			qrMovementPercentComplete = *o.MovementPercentComplete
		}
		qMovementPercentComplete := swag.FormatInt64(qrMovementPercentComplete)
		if qMovementPercentComplete != "" {

			if err := r.SetQueryParam("movement.percent_complete", qMovementPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.MovementStartTime != nil {

		// query param movement.start_time
		var qrMovementStartTime string

		if o.MovementStartTime != nil {
			qrMovementStartTime = *o.MovementStartTime
		}
		qMovementStartTime := qrMovementStartTime
		if qMovementStartTime != "" {

			if err := r.SetQueryParam("movement.start_time", qMovementStartTime); err != nil {
				return err
			}
		}
	}

	if o.MovementState != nil {

		// query param movement.state
		var qrMovementState string

		if o.MovementState != nil {
			qrMovementState = *o.MovementState
		}
		qMovementState := qrMovementState
		if qMovementState != "" {

			if err := r.SetQueryParam("movement.state", qMovementState); err != nil {
				return err
			}
		}
	}

	if o.MovementTieringPolicy != nil {

		// query param movement.tiering_policy
		var qrMovementTieringPolicy string

		if o.MovementTieringPolicy != nil {
			qrMovementTieringPolicy = *o.MovementTieringPolicy
		}
		qMovementTieringPolicy := qrMovementTieringPolicy
		if qMovementTieringPolicy != "" {

			if err := r.SetQueryParam("movement.tiering_policy", qMovementTieringPolicy); err != nil {
				return err
			}
		}
	}

	if o.Msid != nil {

		// query param msid
		var qrMsid int64

		if o.Msid != nil {
			qrMsid = *o.Msid
		}
		qMsid := swag.FormatInt64(qrMsid)
		if qMsid != "" {

			if err := r.SetQueryParam("msid", qMsid); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NasExportPolicyID != nil {

		// query param nas.export_policy.id
		var qrNasExportPolicyID int64

		if o.NasExportPolicyID != nil {
			qrNasExportPolicyID = *o.NasExportPolicyID
		}
		qNasExportPolicyID := swag.FormatInt64(qrNasExportPolicyID)
		if qNasExportPolicyID != "" {

			if err := r.SetQueryParam("nas.export_policy.id", qNasExportPolicyID); err != nil {
				return err
			}
		}
	}

	if o.NasExportPolicyName != nil {

		// query param nas.export_policy.name
		var qrNasExportPolicyName string

		if o.NasExportPolicyName != nil {
			qrNasExportPolicyName = *o.NasExportPolicyName
		}
		qNasExportPolicyName := qrNasExportPolicyName
		if qNasExportPolicyName != "" {

			if err := r.SetQueryParam("nas.export_policy.name", qNasExportPolicyName); err != nil {
				return err
			}
		}
	}

	if o.NasGid != nil {

		// query param nas.gid
		var qrNasGid int64

		if o.NasGid != nil {
			qrNasGid = *o.NasGid
		}
		qNasGid := swag.FormatInt64(qrNasGid)
		if qNasGid != "" {

			if err := r.SetQueryParam("nas.gid", qNasGid); err != nil {
				return err
			}
		}
	}

	if o.NasJunctionParentName != nil {

		// query param nas.junction_parent.name
		var qrNasJunctionParentName string

		if o.NasJunctionParentName != nil {
			qrNasJunctionParentName = *o.NasJunctionParentName
		}
		qNasJunctionParentName := qrNasJunctionParentName
		if qNasJunctionParentName != "" {

			if err := r.SetQueryParam("nas.junction_parent.name", qNasJunctionParentName); err != nil {
				return err
			}
		}
	}

	if o.NasJunctionParentUUID != nil {

		// query param nas.junction_parent.uuid
		var qrNasJunctionParentUUID string

		if o.NasJunctionParentUUID != nil {
			qrNasJunctionParentUUID = *o.NasJunctionParentUUID
		}
		qNasJunctionParentUUID := qrNasJunctionParentUUID
		if qNasJunctionParentUUID != "" {

			if err := r.SetQueryParam("nas.junction_parent.uuid", qNasJunctionParentUUID); err != nil {
				return err
			}
		}
	}

	if o.NasPath != nil {

		// query param nas.path
		var qrNasPath string

		if o.NasPath != nil {
			qrNasPath = *o.NasPath
		}
		qNasPath := qrNasPath
		if qNasPath != "" {

			if err := r.SetQueryParam("nas.path", qNasPath); err != nil {
				return err
			}
		}
	}

	if o.NasSecurityStyle != nil {

		// query param nas.security_style
		var qrNasSecurityStyle string

		if o.NasSecurityStyle != nil {
			qrNasSecurityStyle = *o.NasSecurityStyle
		}
		qNasSecurityStyle := qrNasSecurityStyle
		if qNasSecurityStyle != "" {

			if err := r.SetQueryParam("nas.security_style", qNasSecurityStyle); err != nil {
				return err
			}
		}
	}

	if o.NasUID != nil {

		// query param nas.uid
		var qrNasUID int64

		if o.NasUID != nil {
			qrNasUID = *o.NasUID
		}
		qNasUID := swag.FormatInt64(qrNasUID)
		if qNasUID != "" {

			if err := r.SetQueryParam("nas.uid", qNasUID); err != nil {
				return err
			}
		}
	}

	if o.NasUnixPermissions != nil {

		// query param nas.unix_permissions
		var qrNasUnixPermissions int64

		if o.NasUnixPermissions != nil {
			qrNasUnixPermissions = *o.NasUnixPermissions
		}
		qNasUnixPermissions := swag.FormatInt64(qrNasUnixPermissions)
		if qNasUnixPermissions != "" {

			if err := r.SetQueryParam("nas.unix_permissions", qNasUnixPermissions); err != nil {
				return err
			}
		}
	}

	if o.NodesName != nil {

		// query param nodes.name
		var qrNodesName string

		if o.NodesName != nil {
			qrNodesName = *o.NodesName
		}
		qNodesName := qrNodesName
		if qNodesName != "" {

			if err := r.SetQueryParam("nodes.name", qNodesName); err != nil {
				return err
			}
		}
	}

	if o.NodesUUID != nil {

		// query param nodes.uuid
		var qrNodesUUID string

		if o.NodesUUID != nil {
			qrNodesUUID = *o.NodesUUID
		}
		qNodesUUID := qrNodesUUID
		if qNodesUUID != "" {

			if err := r.SetQueryParam("nodes.uuid", qNodesUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.QosPolicyMaxThroughput != nil {

		// query param qos.policy.max_throughput
		var qrQosPolicyMaxThroughput string

		if o.QosPolicyMaxThroughput != nil {
			qrQosPolicyMaxThroughput = *o.QosPolicyMaxThroughput
		}
		qQosPolicyMaxThroughput := qrQosPolicyMaxThroughput
		if qQosPolicyMaxThroughput != "" {

			if err := r.SetQueryParam("qos.policy.max_throughput", qQosPolicyMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputIops != nil {

		// query param qos.policy.max_throughput_iops
		var qrQosPolicyMaxThroughputIops int64

		if o.QosPolicyMaxThroughputIops != nil {
			qrQosPolicyMaxThroughputIops = *o.QosPolicyMaxThroughputIops
		}
		qQosPolicyMaxThroughputIops := swag.FormatInt64(qrQosPolicyMaxThroughputIops)
		if qQosPolicyMaxThroughputIops != "" {

			if err := r.SetQueryParam("qos.policy.max_throughput_iops", qQosPolicyMaxThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputMbps != nil {

		// query param qos.policy.max_throughput_mbps
		var qrQosPolicyMaxThroughputMbps int64

		if o.QosPolicyMaxThroughputMbps != nil {
			qrQosPolicyMaxThroughputMbps = *o.QosPolicyMaxThroughputMbps
		}
		qQosPolicyMaxThroughputMbps := swag.FormatInt64(qrQosPolicyMaxThroughputMbps)
		if qQosPolicyMaxThroughputMbps != "" {

			if err := r.SetQueryParam("qos.policy.max_throughput_mbps", qQosPolicyMaxThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughput != nil {

		// query param qos.policy.min_throughput
		var qrQosPolicyMinThroughput string

		if o.QosPolicyMinThroughput != nil {
			qrQosPolicyMinThroughput = *o.QosPolicyMinThroughput
		}
		qQosPolicyMinThroughput := qrQosPolicyMinThroughput
		if qQosPolicyMinThroughput != "" {

			if err := r.SetQueryParam("qos.policy.min_throughput", qQosPolicyMinThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputIops != nil {

		// query param qos.policy.min_throughput_iops
		var qrQosPolicyMinThroughputIops int64

		if o.QosPolicyMinThroughputIops != nil {
			qrQosPolicyMinThroughputIops = *o.QosPolicyMinThroughputIops
		}
		qQosPolicyMinThroughputIops := swag.FormatInt64(qrQosPolicyMinThroughputIops)
		if qQosPolicyMinThroughputIops != "" {

			if err := r.SetQueryParam("qos.policy.min_throughput_iops", qQosPolicyMinThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputMbps != nil {

		// query param qos.policy.min_throughput_mbps
		var qrQosPolicyMinThroughputMbps int64

		if o.QosPolicyMinThroughputMbps != nil {
			qrQosPolicyMinThroughputMbps = *o.QosPolicyMinThroughputMbps
		}
		qQosPolicyMinThroughputMbps := swag.FormatInt64(qrQosPolicyMinThroughputMbps)
		if qQosPolicyMinThroughputMbps != "" {

			if err := r.SetQueryParam("qos.policy.min_throughput_mbps", qQosPolicyMinThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyName != nil {

		// query param qos.policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos.policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos.policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos.policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.QueueForEncryption != nil {

		// query param queue_for_encryption
		var qrQueueForEncryption bool

		if o.QueueForEncryption != nil {
			qrQueueForEncryption = *o.QueueForEncryption
		}
		qQueueForEncryption := swag.FormatBool(qrQueueForEncryption)
		if qQueueForEncryption != "" {

			if err := r.SetQueryParam("queue_for_encryption", qQueueForEncryption); err != nil {
				return err
			}
		}
	}

	if o.QuotaState != nil {

		// query param quota.state
		var qrQuotaState string

		if o.QuotaState != nil {
			qrQuotaState = *o.QuotaState
		}
		qQuotaState := qrQuotaState
		if qQuotaState != "" {

			if err := r.SetQueryParam("quota.state", qQuotaState); err != nil {
				return err
			}
		}
	}

	if o.RebalancingDataMoved != nil {

		// query param rebalancing.data_moved
		var qrRebalancingDataMoved int64

		if o.RebalancingDataMoved != nil {
			qrRebalancingDataMoved = *o.RebalancingDataMoved
		}
		qRebalancingDataMoved := swag.FormatInt64(qrRebalancingDataMoved)
		if qRebalancingDataMoved != "" {

			if err := r.SetQueryParam("rebalancing.data_moved", qRebalancingDataMoved); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementFileMovesStarted != nil {

		// query param rebalancing.engine.movement.file_moves_started
		var qrRebalancingEngineMovementFileMovesStarted int64

		if o.RebalancingEngineMovementFileMovesStarted != nil {
			qrRebalancingEngineMovementFileMovesStarted = *o.RebalancingEngineMovementFileMovesStarted
		}
		qRebalancingEngineMovementFileMovesStarted := swag.FormatInt64(qrRebalancingEngineMovementFileMovesStarted)
		if qRebalancingEngineMovementFileMovesStarted != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.file_moves_started", qRebalancingEngineMovementFileMovesStarted); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementLastErrorCode != nil {

		// query param rebalancing.engine.movement.last_error.code
		var qrRebalancingEngineMovementLastErrorCode int64

		if o.RebalancingEngineMovementLastErrorCode != nil {
			qrRebalancingEngineMovementLastErrorCode = *o.RebalancingEngineMovementLastErrorCode
		}
		qRebalancingEngineMovementLastErrorCode := swag.FormatInt64(qrRebalancingEngineMovementLastErrorCode)
		if qRebalancingEngineMovementLastErrorCode != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.last_error.code", qRebalancingEngineMovementLastErrorCode); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementLastErrorDestination != nil {

		// query param rebalancing.engine.movement.last_error.destination
		var qrRebalancingEngineMovementLastErrorDestination int64

		if o.RebalancingEngineMovementLastErrorDestination != nil {
			qrRebalancingEngineMovementLastErrorDestination = *o.RebalancingEngineMovementLastErrorDestination
		}
		qRebalancingEngineMovementLastErrorDestination := swag.FormatInt64(qrRebalancingEngineMovementLastErrorDestination)
		if qRebalancingEngineMovementLastErrorDestination != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.last_error.destination", qRebalancingEngineMovementLastErrorDestination); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementLastErrorFileID != nil {

		// query param rebalancing.engine.movement.last_error.file_id
		var qrRebalancingEngineMovementLastErrorFileID int64

		if o.RebalancingEngineMovementLastErrorFileID != nil {
			qrRebalancingEngineMovementLastErrorFileID = *o.RebalancingEngineMovementLastErrorFileID
		}
		qRebalancingEngineMovementLastErrorFileID := swag.FormatInt64(qrRebalancingEngineMovementLastErrorFileID)
		if qRebalancingEngineMovementLastErrorFileID != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.last_error.file_id", qRebalancingEngineMovementLastErrorFileID); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementLastErrorTime != nil {

		// query param rebalancing.engine.movement.last_error.time
		var qrRebalancingEngineMovementLastErrorTime string

		if o.RebalancingEngineMovementLastErrorTime != nil {
			qrRebalancingEngineMovementLastErrorTime = *o.RebalancingEngineMovementLastErrorTime
		}
		qRebalancingEngineMovementLastErrorTime := qrRebalancingEngineMovementLastErrorTime
		if qRebalancingEngineMovementLastErrorTime != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.last_error.time", qRebalancingEngineMovementLastErrorTime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineMovementMostRecentStartTime != nil {

		// query param rebalancing.engine.movement.most_recent_start_time
		var qrRebalancingEngineMovementMostRecentStartTime string

		if o.RebalancingEngineMovementMostRecentStartTime != nil {
			qrRebalancingEngineMovementMostRecentStartTime = *o.RebalancingEngineMovementMostRecentStartTime
		}
		qRebalancingEngineMovementMostRecentStartTime := qrRebalancingEngineMovementMostRecentStartTime
		if qRebalancingEngineMovementMostRecentStartTime != "" {

			if err := r.SetQueryParam("rebalancing.engine.movement.most_recent_start_time", qRebalancingEngineMovementMostRecentStartTime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksScanned != nil {

		// query param rebalancing.engine.scanner.blocks_scanned
		var qrRebalancingEngineScannerBlocksScanned int64

		if o.RebalancingEngineScannerBlocksScanned != nil {
			qrRebalancingEngineScannerBlocksScanned = *o.RebalancingEngineScannerBlocksScanned
		}
		qRebalancingEngineScannerBlocksScanned := swag.FormatInt64(qrRebalancingEngineScannerBlocksScanned)
		if qRebalancingEngineScannerBlocksScanned != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_scanned", qRebalancingEngineScannerBlocksScanned); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedEfficiencyBlocks != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.efficiency_blocks
		var qrRebalancingEngineScannerBlocksSkippedEfficiencyBlocks int64

		if o.RebalancingEngineScannerBlocksSkippedEfficiencyBlocks != nil {
			qrRebalancingEngineScannerBlocksSkippedEfficiencyBlocks = *o.RebalancingEngineScannerBlocksSkippedEfficiencyBlocks
		}
		qRebalancingEngineScannerBlocksSkippedEfficiencyBlocks := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedEfficiencyBlocks)
		if qRebalancingEngineScannerBlocksSkippedEfficiencyBlocks != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.efficiency_blocks", qRebalancingEngineScannerBlocksSkippedEfficiencyBlocks); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedEfficiencyPercent != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.efficiency_percent
		var qrRebalancingEngineScannerBlocksSkippedEfficiencyPercent int64

		if o.RebalancingEngineScannerBlocksSkippedEfficiencyPercent != nil {
			qrRebalancingEngineScannerBlocksSkippedEfficiencyPercent = *o.RebalancingEngineScannerBlocksSkippedEfficiencyPercent
		}
		qRebalancingEngineScannerBlocksSkippedEfficiencyPercent := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedEfficiencyPercent)
		if qRebalancingEngineScannerBlocksSkippedEfficiencyPercent != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.efficiency_percent", qRebalancingEngineScannerBlocksSkippedEfficiencyPercent); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedFastTruncate != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.fast_truncate
		var qrRebalancingEngineScannerBlocksSkippedFastTruncate int64

		if o.RebalancingEngineScannerBlocksSkippedFastTruncate != nil {
			qrRebalancingEngineScannerBlocksSkippedFastTruncate = *o.RebalancingEngineScannerBlocksSkippedFastTruncate
		}
		qRebalancingEngineScannerBlocksSkippedFastTruncate := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedFastTruncate)
		if qRebalancingEngineScannerBlocksSkippedFastTruncate != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.fast_truncate", qRebalancingEngineScannerBlocksSkippedFastTruncate); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedFootprintInvalid != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.footprint_invalid
		var qrRebalancingEngineScannerBlocksSkippedFootprintInvalid int64

		if o.RebalancingEngineScannerBlocksSkippedFootprintInvalid != nil {
			qrRebalancingEngineScannerBlocksSkippedFootprintInvalid = *o.RebalancingEngineScannerBlocksSkippedFootprintInvalid
		}
		qRebalancingEngineScannerBlocksSkippedFootprintInvalid := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedFootprintInvalid)
		if qRebalancingEngineScannerBlocksSkippedFootprintInvalid != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.footprint_invalid", qRebalancingEngineScannerBlocksSkippedFootprintInvalid); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedInSnapshot != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.in_snapshot
		var qrRebalancingEngineScannerBlocksSkippedInSnapshot int64

		if o.RebalancingEngineScannerBlocksSkippedInSnapshot != nil {
			qrRebalancingEngineScannerBlocksSkippedInSnapshot = *o.RebalancingEngineScannerBlocksSkippedInSnapshot
		}
		qRebalancingEngineScannerBlocksSkippedInSnapshot := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedInSnapshot)
		if qRebalancingEngineScannerBlocksSkippedInSnapshot != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.in_snapshot", qRebalancingEngineScannerBlocksSkippedInSnapshot); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedIncompatible != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.incompatible
		var qrRebalancingEngineScannerBlocksSkippedIncompatible int64

		if o.RebalancingEngineScannerBlocksSkippedIncompatible != nil {
			qrRebalancingEngineScannerBlocksSkippedIncompatible = *o.RebalancingEngineScannerBlocksSkippedIncompatible
		}
		qRebalancingEngineScannerBlocksSkippedIncompatible := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedIncompatible)
		if qRebalancingEngineScannerBlocksSkippedIncompatible != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.incompatible", qRebalancingEngineScannerBlocksSkippedIncompatible); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedMetadata != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.metadata
		var qrRebalancingEngineScannerBlocksSkippedMetadata int64

		if o.RebalancingEngineScannerBlocksSkippedMetadata != nil {
			qrRebalancingEngineScannerBlocksSkippedMetadata = *o.RebalancingEngineScannerBlocksSkippedMetadata
		}
		qRebalancingEngineScannerBlocksSkippedMetadata := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedMetadata)
		if qRebalancingEngineScannerBlocksSkippedMetadata != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.metadata", qRebalancingEngineScannerBlocksSkippedMetadata); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedOnDemandDestination != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.on_demand_destination
		var qrRebalancingEngineScannerBlocksSkippedOnDemandDestination int64

		if o.RebalancingEngineScannerBlocksSkippedOnDemandDestination != nil {
			qrRebalancingEngineScannerBlocksSkippedOnDemandDestination = *o.RebalancingEngineScannerBlocksSkippedOnDemandDestination
		}
		qRebalancingEngineScannerBlocksSkippedOnDemandDestination := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedOnDemandDestination)
		if qRebalancingEngineScannerBlocksSkippedOnDemandDestination != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.on_demand_destination", qRebalancingEngineScannerBlocksSkippedOnDemandDestination); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedOther != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.other
		var qrRebalancingEngineScannerBlocksSkippedOther int64

		if o.RebalancingEngineScannerBlocksSkippedOther != nil {
			qrRebalancingEngineScannerBlocksSkippedOther = *o.RebalancingEngineScannerBlocksSkippedOther
		}
		qRebalancingEngineScannerBlocksSkippedOther := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedOther)
		if qRebalancingEngineScannerBlocksSkippedOther != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.other", qRebalancingEngineScannerBlocksSkippedOther); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedRemoteCache != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.remote_cache
		var qrRebalancingEngineScannerBlocksSkippedRemoteCache int64

		if o.RebalancingEngineScannerBlocksSkippedRemoteCache != nil {
			qrRebalancingEngineScannerBlocksSkippedRemoteCache = *o.RebalancingEngineScannerBlocksSkippedRemoteCache
		}
		qRebalancingEngineScannerBlocksSkippedRemoteCache := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedRemoteCache)
		if qRebalancingEngineScannerBlocksSkippedRemoteCache != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.remote_cache", qRebalancingEngineScannerBlocksSkippedRemoteCache); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedTooLarge != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.too_large
		var qrRebalancingEngineScannerBlocksSkippedTooLarge int64

		if o.RebalancingEngineScannerBlocksSkippedTooLarge != nil {
			qrRebalancingEngineScannerBlocksSkippedTooLarge = *o.RebalancingEngineScannerBlocksSkippedTooLarge
		}
		qRebalancingEngineScannerBlocksSkippedTooLarge := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedTooLarge)
		if qRebalancingEngineScannerBlocksSkippedTooLarge != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.too_large", qRebalancingEngineScannerBlocksSkippedTooLarge); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedTooSmall != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.too_small
		var qrRebalancingEngineScannerBlocksSkippedTooSmall int64

		if o.RebalancingEngineScannerBlocksSkippedTooSmall != nil {
			qrRebalancingEngineScannerBlocksSkippedTooSmall = *o.RebalancingEngineScannerBlocksSkippedTooSmall
		}
		qRebalancingEngineScannerBlocksSkippedTooSmall := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedTooSmall)
		if qRebalancingEngineScannerBlocksSkippedTooSmall != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.too_small", qRebalancingEngineScannerBlocksSkippedTooSmall); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerBlocksSkippedWriteFenced != nil {

		// query param rebalancing.engine.scanner.blocks_skipped.write_fenced
		var qrRebalancingEngineScannerBlocksSkippedWriteFenced int64

		if o.RebalancingEngineScannerBlocksSkippedWriteFenced != nil {
			qrRebalancingEngineScannerBlocksSkippedWriteFenced = *o.RebalancingEngineScannerBlocksSkippedWriteFenced
		}
		qRebalancingEngineScannerBlocksSkippedWriteFenced := swag.FormatInt64(qrRebalancingEngineScannerBlocksSkippedWriteFenced)
		if qRebalancingEngineScannerBlocksSkippedWriteFenced != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.blocks_skipped.write_fenced", qRebalancingEngineScannerBlocksSkippedWriteFenced); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesScanned != nil {

		// query param rebalancing.engine.scanner.files_scanned
		var qrRebalancingEngineScannerFilesScanned int64

		if o.RebalancingEngineScannerFilesScanned != nil {
			qrRebalancingEngineScannerFilesScanned = *o.RebalancingEngineScannerFilesScanned
		}
		qRebalancingEngineScannerFilesScanned := swag.FormatInt64(qrRebalancingEngineScannerFilesScanned)
		if qRebalancingEngineScannerFilesScanned != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_scanned", qRebalancingEngineScannerFilesScanned); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedEfficiencyBlocks != nil {

		// query param rebalancing.engine.scanner.files_skipped.efficiency_blocks
		var qrRebalancingEngineScannerFilesSkippedEfficiencyBlocks int64

		if o.RebalancingEngineScannerFilesSkippedEfficiencyBlocks != nil {
			qrRebalancingEngineScannerFilesSkippedEfficiencyBlocks = *o.RebalancingEngineScannerFilesSkippedEfficiencyBlocks
		}
		qRebalancingEngineScannerFilesSkippedEfficiencyBlocks := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedEfficiencyBlocks)
		if qRebalancingEngineScannerFilesSkippedEfficiencyBlocks != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.efficiency_blocks", qRebalancingEngineScannerFilesSkippedEfficiencyBlocks); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedEfficiencyPercent != nil {

		// query param rebalancing.engine.scanner.files_skipped.efficiency_percent
		var qrRebalancingEngineScannerFilesSkippedEfficiencyPercent int64

		if o.RebalancingEngineScannerFilesSkippedEfficiencyPercent != nil {
			qrRebalancingEngineScannerFilesSkippedEfficiencyPercent = *o.RebalancingEngineScannerFilesSkippedEfficiencyPercent
		}
		qRebalancingEngineScannerFilesSkippedEfficiencyPercent := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedEfficiencyPercent)
		if qRebalancingEngineScannerFilesSkippedEfficiencyPercent != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.efficiency_percent", qRebalancingEngineScannerFilesSkippedEfficiencyPercent); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedFastTruncate != nil {

		// query param rebalancing.engine.scanner.files_skipped.fast_truncate
		var qrRebalancingEngineScannerFilesSkippedFastTruncate int64

		if o.RebalancingEngineScannerFilesSkippedFastTruncate != nil {
			qrRebalancingEngineScannerFilesSkippedFastTruncate = *o.RebalancingEngineScannerFilesSkippedFastTruncate
		}
		qRebalancingEngineScannerFilesSkippedFastTruncate := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedFastTruncate)
		if qRebalancingEngineScannerFilesSkippedFastTruncate != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.fast_truncate", qRebalancingEngineScannerFilesSkippedFastTruncate); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedFootprintInvalid != nil {

		// query param rebalancing.engine.scanner.files_skipped.footprint_invalid
		var qrRebalancingEngineScannerFilesSkippedFootprintInvalid int64

		if o.RebalancingEngineScannerFilesSkippedFootprintInvalid != nil {
			qrRebalancingEngineScannerFilesSkippedFootprintInvalid = *o.RebalancingEngineScannerFilesSkippedFootprintInvalid
		}
		qRebalancingEngineScannerFilesSkippedFootprintInvalid := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedFootprintInvalid)
		if qRebalancingEngineScannerFilesSkippedFootprintInvalid != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.footprint_invalid", qRebalancingEngineScannerFilesSkippedFootprintInvalid); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedInSnapshot != nil {

		// query param rebalancing.engine.scanner.files_skipped.in_snapshot
		var qrRebalancingEngineScannerFilesSkippedInSnapshot int64

		if o.RebalancingEngineScannerFilesSkippedInSnapshot != nil {
			qrRebalancingEngineScannerFilesSkippedInSnapshot = *o.RebalancingEngineScannerFilesSkippedInSnapshot
		}
		qRebalancingEngineScannerFilesSkippedInSnapshot := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedInSnapshot)
		if qRebalancingEngineScannerFilesSkippedInSnapshot != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.in_snapshot", qRebalancingEngineScannerFilesSkippedInSnapshot); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedIncompatible != nil {

		// query param rebalancing.engine.scanner.files_skipped.incompatible
		var qrRebalancingEngineScannerFilesSkippedIncompatible int64

		if o.RebalancingEngineScannerFilesSkippedIncompatible != nil {
			qrRebalancingEngineScannerFilesSkippedIncompatible = *o.RebalancingEngineScannerFilesSkippedIncompatible
		}
		qRebalancingEngineScannerFilesSkippedIncompatible := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedIncompatible)
		if qRebalancingEngineScannerFilesSkippedIncompatible != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.incompatible", qRebalancingEngineScannerFilesSkippedIncompatible); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedMetadata != nil {

		// query param rebalancing.engine.scanner.files_skipped.metadata
		var qrRebalancingEngineScannerFilesSkippedMetadata int64

		if o.RebalancingEngineScannerFilesSkippedMetadata != nil {
			qrRebalancingEngineScannerFilesSkippedMetadata = *o.RebalancingEngineScannerFilesSkippedMetadata
		}
		qRebalancingEngineScannerFilesSkippedMetadata := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedMetadata)
		if qRebalancingEngineScannerFilesSkippedMetadata != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.metadata", qRebalancingEngineScannerFilesSkippedMetadata); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedOnDemandDestination != nil {

		// query param rebalancing.engine.scanner.files_skipped.on_demand_destination
		var qrRebalancingEngineScannerFilesSkippedOnDemandDestination int64

		if o.RebalancingEngineScannerFilesSkippedOnDemandDestination != nil {
			qrRebalancingEngineScannerFilesSkippedOnDemandDestination = *o.RebalancingEngineScannerFilesSkippedOnDemandDestination
		}
		qRebalancingEngineScannerFilesSkippedOnDemandDestination := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedOnDemandDestination)
		if qRebalancingEngineScannerFilesSkippedOnDemandDestination != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.on_demand_destination", qRebalancingEngineScannerFilesSkippedOnDemandDestination); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedOther != nil {

		// query param rebalancing.engine.scanner.files_skipped.other
		var qrRebalancingEngineScannerFilesSkippedOther int64

		if o.RebalancingEngineScannerFilesSkippedOther != nil {
			qrRebalancingEngineScannerFilesSkippedOther = *o.RebalancingEngineScannerFilesSkippedOther
		}
		qRebalancingEngineScannerFilesSkippedOther := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedOther)
		if qRebalancingEngineScannerFilesSkippedOther != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.other", qRebalancingEngineScannerFilesSkippedOther); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedRemoteCache != nil {

		// query param rebalancing.engine.scanner.files_skipped.remote_cache
		var qrRebalancingEngineScannerFilesSkippedRemoteCache int64

		if o.RebalancingEngineScannerFilesSkippedRemoteCache != nil {
			qrRebalancingEngineScannerFilesSkippedRemoteCache = *o.RebalancingEngineScannerFilesSkippedRemoteCache
		}
		qRebalancingEngineScannerFilesSkippedRemoteCache := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedRemoteCache)
		if qRebalancingEngineScannerFilesSkippedRemoteCache != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.remote_cache", qRebalancingEngineScannerFilesSkippedRemoteCache); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedTooLarge != nil {

		// query param rebalancing.engine.scanner.files_skipped.too_large
		var qrRebalancingEngineScannerFilesSkippedTooLarge int64

		if o.RebalancingEngineScannerFilesSkippedTooLarge != nil {
			qrRebalancingEngineScannerFilesSkippedTooLarge = *o.RebalancingEngineScannerFilesSkippedTooLarge
		}
		qRebalancingEngineScannerFilesSkippedTooLarge := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedTooLarge)
		if qRebalancingEngineScannerFilesSkippedTooLarge != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.too_large", qRebalancingEngineScannerFilesSkippedTooLarge); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedTooSmall != nil {

		// query param rebalancing.engine.scanner.files_skipped.too_small
		var qrRebalancingEngineScannerFilesSkippedTooSmall int64

		if o.RebalancingEngineScannerFilesSkippedTooSmall != nil {
			qrRebalancingEngineScannerFilesSkippedTooSmall = *o.RebalancingEngineScannerFilesSkippedTooSmall
		}
		qRebalancingEngineScannerFilesSkippedTooSmall := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedTooSmall)
		if qRebalancingEngineScannerFilesSkippedTooSmall != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.too_small", qRebalancingEngineScannerFilesSkippedTooSmall); err != nil {
				return err
			}
		}
	}

	if o.RebalancingEngineScannerFilesSkippedWriteFenced != nil {

		// query param rebalancing.engine.scanner.files_skipped.write_fenced
		var qrRebalancingEngineScannerFilesSkippedWriteFenced int64

		if o.RebalancingEngineScannerFilesSkippedWriteFenced != nil {
			qrRebalancingEngineScannerFilesSkippedWriteFenced = *o.RebalancingEngineScannerFilesSkippedWriteFenced
		}
		qRebalancingEngineScannerFilesSkippedWriteFenced := swag.FormatInt64(qrRebalancingEngineScannerFilesSkippedWriteFenced)
		if qRebalancingEngineScannerFilesSkippedWriteFenced != "" {

			if err := r.SetQueryParam("rebalancing.engine.scanner.files_skipped.write_fenced", qRebalancingEngineScannerFilesSkippedWriteFenced); err != nil {
				return err
			}
		}
	}

	if o.RebalancingExcludeSnapshots != nil {

		// query param rebalancing.exclude_snapshots
		var qrRebalancingExcludeSnapshots bool

		if o.RebalancingExcludeSnapshots != nil {
			qrRebalancingExcludeSnapshots = *o.RebalancingExcludeSnapshots
		}
		qRebalancingExcludeSnapshots := swag.FormatBool(qrRebalancingExcludeSnapshots)
		if qRebalancingExcludeSnapshots != "" {

			if err := r.SetQueryParam("rebalancing.exclude_snapshots", qRebalancingExcludeSnapshots); err != nil {
				return err
			}
		}
	}

	if o.RebalancingImbalancePercent != nil {

		// query param rebalancing.imbalance_percent
		var qrRebalancingImbalancePercent int64

		if o.RebalancingImbalancePercent != nil {
			qrRebalancingImbalancePercent = *o.RebalancingImbalancePercent
		}
		qRebalancingImbalancePercent := swag.FormatInt64(qrRebalancingImbalancePercent)
		if qRebalancingImbalancePercent != "" {

			if err := r.SetQueryParam("rebalancing.imbalance_percent", qRebalancingImbalancePercent); err != nil {
				return err
			}
		}
	}

	if o.RebalancingImbalanceSize != nil {

		// query param rebalancing.imbalance_size
		var qrRebalancingImbalanceSize int64

		if o.RebalancingImbalanceSize != nil {
			qrRebalancingImbalanceSize = *o.RebalancingImbalanceSize
		}
		qRebalancingImbalanceSize := swag.FormatInt64(qrRebalancingImbalanceSize)
		if qRebalancingImbalanceSize != "" {

			if err := r.SetQueryParam("rebalancing.imbalance_size", qRebalancingImbalanceSize); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMaxConstituentImbalancePercent != nil {

		// query param rebalancing.max_constituent_imbalance_percent
		var qrRebalancingMaxConstituentImbalancePercent int64

		if o.RebalancingMaxConstituentImbalancePercent != nil {
			qrRebalancingMaxConstituentImbalancePercent = *o.RebalancingMaxConstituentImbalancePercent
		}
		qRebalancingMaxConstituentImbalancePercent := swag.FormatInt64(qrRebalancingMaxConstituentImbalancePercent)
		if qRebalancingMaxConstituentImbalancePercent != "" {

			if err := r.SetQueryParam("rebalancing.max_constituent_imbalance_percent", qRebalancingMaxConstituentImbalancePercent); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMaxFileMoves != nil {

		// query param rebalancing.max_file_moves
		var qrRebalancingMaxFileMoves int64

		if o.RebalancingMaxFileMoves != nil {
			qrRebalancingMaxFileMoves = *o.RebalancingMaxFileMoves
		}
		qRebalancingMaxFileMoves := swag.FormatInt64(qrRebalancingMaxFileMoves)
		if qRebalancingMaxFileMoves != "" {

			if err := r.SetQueryParam("rebalancing.max_file_moves", qRebalancingMaxFileMoves); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMaxRuntime != nil {

		// query param rebalancing.max_runtime
		var qrRebalancingMaxRuntime string

		if o.RebalancingMaxRuntime != nil {
			qrRebalancingMaxRuntime = *o.RebalancingMaxRuntime
		}
		qRebalancingMaxRuntime := qrRebalancingMaxRuntime
		if qRebalancingMaxRuntime != "" {

			if err := r.SetQueryParam("rebalancing.max_runtime", qRebalancingMaxRuntime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMaxThreshold != nil {

		// query param rebalancing.max_threshold
		var qrRebalancingMaxThreshold int64

		if o.RebalancingMaxThreshold != nil {
			qrRebalancingMaxThreshold = *o.RebalancingMaxThreshold
		}
		qRebalancingMaxThreshold := swag.FormatInt64(qrRebalancingMaxThreshold)
		if qRebalancingMaxThreshold != "" {

			if err := r.SetQueryParam("rebalancing.max_threshold", qRebalancingMaxThreshold); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMinFileSize != nil {

		// query param rebalancing.min_file_size
		var qrRebalancingMinFileSize int64

		if o.RebalancingMinFileSize != nil {
			qrRebalancingMinFileSize = *o.RebalancingMinFileSize
		}
		qRebalancingMinFileSize := swag.FormatInt64(qrRebalancingMinFileSize)
		if qRebalancingMinFileSize != "" {

			if err := r.SetQueryParam("rebalancing.min_file_size", qRebalancingMinFileSize); err != nil {
				return err
			}
		}
	}

	if o.RebalancingMinThreshold != nil {

		// query param rebalancing.min_threshold
		var qrRebalancingMinThreshold int64

		if o.RebalancingMinThreshold != nil {
			qrRebalancingMinThreshold = *o.RebalancingMinThreshold
		}
		qRebalancingMinThreshold := swag.FormatInt64(qrRebalancingMinThreshold)
		if qRebalancingMinThreshold != "" {

			if err := r.SetQueryParam("rebalancing.min_threshold", qRebalancingMinThreshold); err != nil {
				return err
			}
		}
	}

	if o.RebalancingNoticesArgumentsCode != nil {

		// query param rebalancing.notices.arguments.code
		var qrRebalancingNoticesArgumentsCode string

		if o.RebalancingNoticesArgumentsCode != nil {
			qrRebalancingNoticesArgumentsCode = *o.RebalancingNoticesArgumentsCode
		}
		qRebalancingNoticesArgumentsCode := qrRebalancingNoticesArgumentsCode
		if qRebalancingNoticesArgumentsCode != "" {

			if err := r.SetQueryParam("rebalancing.notices.arguments.code", qRebalancingNoticesArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.RebalancingNoticesArgumentsMessage != nil {

		// query param rebalancing.notices.arguments.message
		var qrRebalancingNoticesArgumentsMessage string

		if o.RebalancingNoticesArgumentsMessage != nil {
			qrRebalancingNoticesArgumentsMessage = *o.RebalancingNoticesArgumentsMessage
		}
		qRebalancingNoticesArgumentsMessage := qrRebalancingNoticesArgumentsMessage
		if qRebalancingNoticesArgumentsMessage != "" {

			if err := r.SetQueryParam("rebalancing.notices.arguments.message", qRebalancingNoticesArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.RebalancingNoticesCode != nil {

		// query param rebalancing.notices.code
		var qrRebalancingNoticesCode string

		if o.RebalancingNoticesCode != nil {
			qrRebalancingNoticesCode = *o.RebalancingNoticesCode
		}
		qRebalancingNoticesCode := qrRebalancingNoticesCode
		if qRebalancingNoticesCode != "" {

			if err := r.SetQueryParam("rebalancing.notices.code", qRebalancingNoticesCode); err != nil {
				return err
			}
		}
	}

	if o.RebalancingNoticesMessage != nil {

		// query param rebalancing.notices.message
		var qrRebalancingNoticesMessage string

		if o.RebalancingNoticesMessage != nil {
			qrRebalancingNoticesMessage = *o.RebalancingNoticesMessage
		}
		qRebalancingNoticesMessage := qrRebalancingNoticesMessage
		if qRebalancingNoticesMessage != "" {

			if err := r.SetQueryParam("rebalancing.notices.message", qRebalancingNoticesMessage); err != nil {
				return err
			}
		}
	}

	if o.RebalancingRuntime != nil {

		// query param rebalancing.runtime
		var qrRebalancingRuntime string

		if o.RebalancingRuntime != nil {
			qrRebalancingRuntime = *o.RebalancingRuntime
		}
		qRebalancingRuntime := qrRebalancingRuntime
		if qRebalancingRuntime != "" {

			if err := r.SetQueryParam("rebalancing.runtime", qRebalancingRuntime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingStartTime != nil {

		// query param rebalancing.start_time
		var qrRebalancingStartTime string

		if o.RebalancingStartTime != nil {
			qrRebalancingStartTime = *o.RebalancingStartTime
		}
		qRebalancingStartTime := qrRebalancingStartTime
		if qRebalancingStartTime != "" {

			if err := r.SetQueryParam("rebalancing.start_time", qRebalancingStartTime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingState != nil {

		// query param rebalancing.state
		var qrRebalancingState string

		if o.RebalancingState != nil {
			qrRebalancingState = *o.RebalancingState
		}
		qRebalancingState := qrRebalancingState
		if qRebalancingState != "" {

			if err := r.SetQueryParam("rebalancing.state", qRebalancingState); err != nil {
				return err
			}
		}
	}

	if o.RebalancingStopTime != nil {

		// query param rebalancing.stop_time
		var qrRebalancingStopTime string

		if o.RebalancingStopTime != nil {
			qrRebalancingStopTime = *o.RebalancingStopTime
		}
		qRebalancingStopTime := qrRebalancingStopTime
		if qRebalancingStopTime != "" {

			if err := r.SetQueryParam("rebalancing.stop_time", qRebalancingStopTime); err != nil {
				return err
			}
		}
	}

	if o.RebalancingTargetUsed != nil {

		// query param rebalancing.target_used
		var qrRebalancingTargetUsed int64

		if o.RebalancingTargetUsed != nil {
			qrRebalancingTargetUsed = *o.RebalancingTargetUsed
		}
		qRebalancingTargetUsed := swag.FormatInt64(qrRebalancingTargetUsed)
		if qRebalancingTargetUsed != "" {

			if err := r.SetQueryParam("rebalancing.target_used", qRebalancingTargetUsed); err != nil {
				return err
			}
		}
	}

	if o.RebalancingUsedForImbalance != nil {

		// query param rebalancing.used_for_imbalance
		var qrRebalancingUsedForImbalance int64

		if o.RebalancingUsedForImbalance != nil {
			qrRebalancingUsedForImbalance = *o.RebalancingUsedForImbalance
		}
		qRebalancingUsedForImbalance := swag.FormatInt64(qrRebalancingUsedForImbalance)
		if qRebalancingUsedForImbalance != "" {

			if err := r.SetQueryParam("rebalancing.used_for_imbalance", qRebalancingUsedForImbalance); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScheduledSnapshotNamingScheme != nil {

		// query param scheduled_snapshot_naming_scheme
		var qrScheduledSnapshotNamingScheme string

		if o.ScheduledSnapshotNamingScheme != nil {
			qrScheduledSnapshotNamingScheme = *o.ScheduledSnapshotNamingScheme
		}
		qScheduledSnapshotNamingScheme := qrScheduledSnapshotNamingScheme
		if qScheduledSnapshotNamingScheme != "" {

			if err := r.SetQueryParam("scheduled_snapshot_naming_scheme", qScheduledSnapshotNamingScheme); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.SnaplockAppendModeEnabled != nil {

		// query param snaplock.append_mode_enabled
		var qrSnaplockAppendModeEnabled bool

		if o.SnaplockAppendModeEnabled != nil {
			qrSnaplockAppendModeEnabled = *o.SnaplockAppendModeEnabled
		}
		qSnaplockAppendModeEnabled := swag.FormatBool(qrSnaplockAppendModeEnabled)
		if qSnaplockAppendModeEnabled != "" {

			if err := r.SetQueryParam("snaplock.append_mode_enabled", qSnaplockAppendModeEnabled); err != nil {
				return err
			}
		}
	}

	if o.SnaplockAutocommitPeriod != nil {

		// query param snaplock.autocommit_period
		var qrSnaplockAutocommitPeriod string

		if o.SnaplockAutocommitPeriod != nil {
			qrSnaplockAutocommitPeriod = *o.SnaplockAutocommitPeriod
		}
		qSnaplockAutocommitPeriod := qrSnaplockAutocommitPeriod
		if qSnaplockAutocommitPeriod != "" {

			if err := r.SetQueryParam("snaplock.autocommit_period", qSnaplockAutocommitPeriod); err != nil {
				return err
			}
		}
	}

	if o.SnaplockComplianceClockTime != nil {

		// query param snaplock.compliance_clock_time
		var qrSnaplockComplianceClockTime string

		if o.SnaplockComplianceClockTime != nil {
			qrSnaplockComplianceClockTime = *o.SnaplockComplianceClockTime
		}
		qSnaplockComplianceClockTime := qrSnaplockComplianceClockTime
		if qSnaplockComplianceClockTime != "" {

			if err := r.SetQueryParam("snaplock.compliance_clock_time", qSnaplockComplianceClockTime); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpiryTime != nil {

		// query param snaplock.expiry_time
		var qrSnaplockExpiryTime string

		if o.SnaplockExpiryTime != nil {
			qrSnaplockExpiryTime = *o.SnaplockExpiryTime
		}
		qSnaplockExpiryTime := qrSnaplockExpiryTime
		if qSnaplockExpiryTime != "" {

			if err := r.SetQueryParam("snaplock.expiry_time", qSnaplockExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.SnaplockIsAuditLog != nil {

		// query param snaplock.is_audit_log
		var qrSnaplockIsAuditLog bool

		if o.SnaplockIsAuditLog != nil {
			qrSnaplockIsAuditLog = *o.SnaplockIsAuditLog
		}
		qSnaplockIsAuditLog := swag.FormatBool(qrSnaplockIsAuditLog)
		if qSnaplockIsAuditLog != "" {

			if err := r.SetQueryParam("snaplock.is_audit_log", qSnaplockIsAuditLog); err != nil {
				return err
			}
		}
	}

	if o.SnaplockLitigationCount != nil {

		// query param snaplock.litigation_count
		var qrSnaplockLitigationCount int64

		if o.SnaplockLitigationCount != nil {
			qrSnaplockLitigationCount = *o.SnaplockLitigationCount
		}
		qSnaplockLitigationCount := swag.FormatInt64(qrSnaplockLitigationCount)
		if qSnaplockLitigationCount != "" {

			if err := r.SetQueryParam("snaplock.litigation_count", qSnaplockLitigationCount); err != nil {
				return err
			}
		}
	}

	if o.SnaplockPrivilegedDelete != nil {

		// query param snaplock.privileged_delete
		var qrSnaplockPrivilegedDelete string

		if o.SnaplockPrivilegedDelete != nil {
			qrSnaplockPrivilegedDelete = *o.SnaplockPrivilegedDelete
		}
		qSnaplockPrivilegedDelete := qrSnaplockPrivilegedDelete
		if qSnaplockPrivilegedDelete != "" {

			if err := r.SetQueryParam("snaplock.privileged_delete", qSnaplockPrivilegedDelete); err != nil {
				return err
			}
		}
	}

	if o.SnaplockRetentionDefault != nil {

		// query param snaplock.retention.default
		var qrSnaplockRetentionDefault string

		if o.SnaplockRetentionDefault != nil {
			qrSnaplockRetentionDefault = *o.SnaplockRetentionDefault
		}
		qSnaplockRetentionDefault := qrSnaplockRetentionDefault
		if qSnaplockRetentionDefault != "" {

			if err := r.SetQueryParam("snaplock.retention.default", qSnaplockRetentionDefault); err != nil {
				return err
			}
		}
	}

	if o.SnaplockRetentionMaximum != nil {

		// query param snaplock.retention.maximum
		var qrSnaplockRetentionMaximum string

		if o.SnaplockRetentionMaximum != nil {
			qrSnaplockRetentionMaximum = *o.SnaplockRetentionMaximum
		}
		qSnaplockRetentionMaximum := qrSnaplockRetentionMaximum
		if qSnaplockRetentionMaximum != "" {

			if err := r.SetQueryParam("snaplock.retention.maximum", qSnaplockRetentionMaximum); err != nil {
				return err
			}
		}
	}

	if o.SnaplockRetentionMinimum != nil {

		// query param snaplock.retention.minimum
		var qrSnaplockRetentionMinimum string

		if o.SnaplockRetentionMinimum != nil {
			qrSnaplockRetentionMinimum = *o.SnaplockRetentionMinimum
		}
		qSnaplockRetentionMinimum := qrSnaplockRetentionMinimum
		if qSnaplockRetentionMinimum != "" {

			if err := r.SetQueryParam("snaplock.retention.minimum", qSnaplockRetentionMinimum); err != nil {
				return err
			}
		}
	}

	if o.SnaplockType != nil {

		// query param snaplock.type
		var qrSnaplockType string

		if o.SnaplockType != nil {
			qrSnaplockType = *o.SnaplockType
		}
		qSnaplockType := qrSnaplockType
		if qSnaplockType != "" {

			if err := r.SetQueryParam("snaplock.type", qSnaplockType); err != nil {
				return err
			}
		}
	}

	if o.SnaplockUnspecifiedRetentionFileCount != nil {

		// query param snaplock.unspecified_retention_file_count
		var qrSnaplockUnspecifiedRetentionFileCount int64

		if o.SnaplockUnspecifiedRetentionFileCount != nil {
			qrSnaplockUnspecifiedRetentionFileCount = *o.SnaplockUnspecifiedRetentionFileCount
		}
		qSnaplockUnspecifiedRetentionFileCount := swag.FormatInt64(qrSnaplockUnspecifiedRetentionFileCount)
		if qSnaplockUnspecifiedRetentionFileCount != "" {

			if err := r.SetQueryParam("snaplock.unspecified_retention_file_count", qSnaplockUnspecifiedRetentionFileCount); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorDestinationsIsCloud != nil {

		// query param snapmirror.destinations.is_cloud
		var qrSnapmirrorDestinationsIsCloud bool

		if o.SnapmirrorDestinationsIsCloud != nil {
			qrSnapmirrorDestinationsIsCloud = *o.SnapmirrorDestinationsIsCloud
		}
		qSnapmirrorDestinationsIsCloud := swag.FormatBool(qrSnapmirrorDestinationsIsCloud)
		if qSnapmirrorDestinationsIsCloud != "" {

			if err := r.SetQueryParam("snapmirror.destinations.is_cloud", qSnapmirrorDestinationsIsCloud); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorDestinationsIsOntap != nil {

		// query param snapmirror.destinations.is_ontap
		var qrSnapmirrorDestinationsIsOntap bool

		if o.SnapmirrorDestinationsIsOntap != nil {
			qrSnapmirrorDestinationsIsOntap = *o.SnapmirrorDestinationsIsOntap
		}
		qSnapmirrorDestinationsIsOntap := swag.FormatBool(qrSnapmirrorDestinationsIsOntap)
		if qSnapmirrorDestinationsIsOntap != "" {

			if err := r.SetQueryParam("snapmirror.destinations.is_ontap", qSnapmirrorDestinationsIsOntap); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorIsProtected != nil {

		// query param snapmirror.is_protected
		var qrSnapmirrorIsProtected bool

		if o.SnapmirrorIsProtected != nil {
			qrSnapmirrorIsProtected = *o.SnapmirrorIsProtected
		}
		qSnapmirrorIsProtected := swag.FormatBool(qrSnapmirrorIsProtected)
		if qSnapmirrorIsProtected != "" {

			if err := r.SetQueryParam("snapmirror.is_protected", qSnapmirrorIsProtected); err != nil {
				return err
			}
		}
	}

	if o.SnapshotCount != nil {

		// query param snapshot_count
		var qrSnapshotCount int64

		if o.SnapshotCount != nil {
			qrSnapshotCount = *o.SnapshotCount
		}
		qSnapshotCount := swag.FormatInt64(qrSnapshotCount)
		if qSnapshotCount != "" {

			if err := r.SetQueryParam("snapshot_count", qSnapshotCount); err != nil {
				return err
			}
		}
	}

	if o.SnapshotDirectoryAccessEnabled != nil {

		// query param snapshot_directory_access_enabled
		var qrSnapshotDirectoryAccessEnabled bool

		if o.SnapshotDirectoryAccessEnabled != nil {
			qrSnapshotDirectoryAccessEnabled = *o.SnapshotDirectoryAccessEnabled
		}
		qSnapshotDirectoryAccessEnabled := swag.FormatBool(qrSnapshotDirectoryAccessEnabled)
		if qSnapshotDirectoryAccessEnabled != "" {

			if err := r.SetQueryParam("snapshot_directory_access_enabled", qSnapshotDirectoryAccessEnabled); err != nil {
				return err
			}
		}
	}

	if o.SnapshotLockingEnabled != nil {

		// query param snapshot_locking_enabled
		var qrSnapshotLockingEnabled bool

		if o.SnapshotLockingEnabled != nil {
			qrSnapshotLockingEnabled = *o.SnapshotLockingEnabled
		}
		qSnapshotLockingEnabled := swag.FormatBool(qrSnapshotLockingEnabled)
		if qSnapshotLockingEnabled != "" {

			if err := r.SetQueryParam("snapshot_locking_enabled", qSnapshotLockingEnabled); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyName != nil {

		// query param snapshot_policy.name
		var qrSnapshotPolicyName string

		if o.SnapshotPolicyName != nil {
			qrSnapshotPolicyName = *o.SnapshotPolicyName
		}
		qSnapshotPolicyName := qrSnapshotPolicyName
		if qSnapshotPolicyName != "" {

			if err := r.SetQueryParam("snapshot_policy.name", qSnapshotPolicyName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyUUID != nil {

		// query param snapshot_policy.uuid
		var qrSnapshotPolicyUUID string

		if o.SnapshotPolicyUUID != nil {
			qrSnapshotPolicyUUID = *o.SnapshotPolicyUUID
		}
		qSnapshotPolicyUUID := qrSnapshotPolicyUUID
		if qSnapshotPolicyUUID != "" {

			if err := r.SetQueryParam("snapshot_policy.uuid", qSnapshotPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.SpaceAfsTotal != nil {

		// query param space.afs_total
		var qrSpaceAfsTotal int64

		if o.SpaceAfsTotal != nil {
			qrSpaceAfsTotal = *o.SpaceAfsTotal
		}
		qSpaceAfsTotal := swag.FormatInt64(qrSpaceAfsTotal)
		if qSpaceAfsTotal != "" {

			if err := r.SetQueryParam("space.afs_total", qSpaceAfsTotal); err != nil {
				return err
			}
		}
	}

	if o.SpaceAutoAdaptiveCompressionFootprintDataReduction != nil {

		// query param space.auto_adaptive_compression_footprint_data_reduction
		var qrSpaceAutoAdaptiveCompressionFootprintDataReduction int64

		if o.SpaceAutoAdaptiveCompressionFootprintDataReduction != nil {
			qrSpaceAutoAdaptiveCompressionFootprintDataReduction = *o.SpaceAutoAdaptiveCompressionFootprintDataReduction
		}
		qSpaceAutoAdaptiveCompressionFootprintDataReduction := swag.FormatInt64(qrSpaceAutoAdaptiveCompressionFootprintDataReduction)
		if qSpaceAutoAdaptiveCompressionFootprintDataReduction != "" {

			if err := r.SetQueryParam("space.auto_adaptive_compression_footprint_data_reduction", qSpaceAutoAdaptiveCompressionFootprintDataReduction); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailable != nil {

		// query param space.available
		var qrSpaceAvailable int64

		if o.SpaceAvailable != nil {
			qrSpaceAvailable = *o.SpaceAvailable
		}
		qSpaceAvailable := swag.FormatInt64(qrSpaceAvailable)
		if qSpaceAvailable != "" {

			if err := r.SetQueryParam("space.available", qSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailablePercent != nil {

		// query param space.available_percent
		var qrSpaceAvailablePercent int64

		if o.SpaceAvailablePercent != nil {
			qrSpaceAvailablePercent = *o.SpaceAvailablePercent
		}
		qSpaceAvailablePercent := swag.FormatInt64(qrSpaceAvailablePercent)
		if qSpaceAvailablePercent != "" {

			if err := r.SetQueryParam("space.available_percent", qSpaceAvailablePercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceBlockStorageInactiveUserData != nil {

		// query param space.block_storage_inactive_user_data
		var qrSpaceBlockStorageInactiveUserData int64

		if o.SpaceBlockStorageInactiveUserData != nil {
			qrSpaceBlockStorageInactiveUserData = *o.SpaceBlockStorageInactiveUserData
		}
		qSpaceBlockStorageInactiveUserData := swag.FormatInt64(qrSpaceBlockStorageInactiveUserData)
		if qSpaceBlockStorageInactiveUserData != "" {

			if err := r.SetQueryParam("space.block_storage_inactive_user_data", qSpaceBlockStorageInactiveUserData); err != nil {
				return err
			}
		}
	}

	if o.SpaceBlockStorageInactiveUserDataPercent != nil {

		// query param space.block_storage_inactive_user_data_percent
		var qrSpaceBlockStorageInactiveUserDataPercent int64

		if o.SpaceBlockStorageInactiveUserDataPercent != nil {
			qrSpaceBlockStorageInactiveUserDataPercent = *o.SpaceBlockStorageInactiveUserDataPercent
		}
		qSpaceBlockStorageInactiveUserDataPercent := swag.FormatInt64(qrSpaceBlockStorageInactiveUserDataPercent)
		if qSpaceBlockStorageInactiveUserDataPercent != "" {

			if err := r.SetQueryParam("space.block_storage_inactive_user_data_percent", qSpaceBlockStorageInactiveUserDataPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceCapacityTierFootprint != nil {

		// query param space.capacity_tier_footprint
		var qrSpaceCapacityTierFootprint int64

		if o.SpaceCapacityTierFootprint != nil {
			qrSpaceCapacityTierFootprint = *o.SpaceCapacityTierFootprint
		}
		qSpaceCapacityTierFootprint := swag.FormatInt64(qrSpaceCapacityTierFootprint)
		if qSpaceCapacityTierFootprint != "" {

			if err := r.SetQueryParam("space.capacity_tier_footprint", qSpaceCapacityTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceCapacityTierFootprintDataReduction != nil {

		// query param space.capacity_tier_footprint_data_reduction
		var qrSpaceCapacityTierFootprintDataReduction int64

		if o.SpaceCapacityTierFootprintDataReduction != nil {
			qrSpaceCapacityTierFootprintDataReduction = *o.SpaceCapacityTierFootprintDataReduction
		}
		qSpaceCapacityTierFootprintDataReduction := swag.FormatInt64(qrSpaceCapacityTierFootprintDataReduction)
		if qSpaceCapacityTierFootprintDataReduction != "" {

			if err := r.SetQueryParam("space.capacity_tier_footprint_data_reduction", qSpaceCapacityTierFootprintDataReduction); err != nil {
				return err
			}
		}
	}

	if o.SpaceCompactionFootprintDataReduction != nil {

		// query param space.compaction_footprint_data_reduction
		var qrSpaceCompactionFootprintDataReduction int64

		if o.SpaceCompactionFootprintDataReduction != nil {
			qrSpaceCompactionFootprintDataReduction = *o.SpaceCompactionFootprintDataReduction
		}
		qSpaceCompactionFootprintDataReduction := swag.FormatInt64(qrSpaceCompactionFootprintDataReduction)
		if qSpaceCompactionFootprintDataReduction != "" {

			if err := r.SetQueryParam("space.compaction_footprint_data_reduction", qSpaceCompactionFootprintDataReduction); err != nil {
				return err
			}
		}
	}

	if o.SpaceCrossVolumeDedupeMetafilesFootprint != nil {

		// query param space.cross_volume_dedupe_metafiles_footprint
		var qrSpaceCrossVolumeDedupeMetafilesFootprint int64

		if o.SpaceCrossVolumeDedupeMetafilesFootprint != nil {
			qrSpaceCrossVolumeDedupeMetafilesFootprint = *o.SpaceCrossVolumeDedupeMetafilesFootprint
		}
		qSpaceCrossVolumeDedupeMetafilesFootprint := swag.FormatInt64(qrSpaceCrossVolumeDedupeMetafilesFootprint)
		if qSpaceCrossVolumeDedupeMetafilesFootprint != "" {

			if err := r.SetQueryParam("space.cross_volume_dedupe_metafiles_footprint", qSpaceCrossVolumeDedupeMetafilesFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceCrossVolumeDedupeMetafilesTemporaryFootprint != nil {

		// query param space.cross_volume_dedupe_metafiles_temporary_footprint
		var qrSpaceCrossVolumeDedupeMetafilesTemporaryFootprint int64

		if o.SpaceCrossVolumeDedupeMetafilesTemporaryFootprint != nil {
			qrSpaceCrossVolumeDedupeMetafilesTemporaryFootprint = *o.SpaceCrossVolumeDedupeMetafilesTemporaryFootprint
		}
		qSpaceCrossVolumeDedupeMetafilesTemporaryFootprint := swag.FormatInt64(qrSpaceCrossVolumeDedupeMetafilesTemporaryFootprint)
		if qSpaceCrossVolumeDedupeMetafilesTemporaryFootprint != "" {

			if err := r.SetQueryParam("space.cross_volume_dedupe_metafiles_temporary_footprint", qSpaceCrossVolumeDedupeMetafilesTemporaryFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceDedupeMetafilesFootprint != nil {

		// query param space.dedupe_metafiles_footprint
		var qrSpaceDedupeMetafilesFootprint int64

		if o.SpaceDedupeMetafilesFootprint != nil {
			qrSpaceDedupeMetafilesFootprint = *o.SpaceDedupeMetafilesFootprint
		}
		qSpaceDedupeMetafilesFootprint := swag.FormatInt64(qrSpaceDedupeMetafilesFootprint)
		if qSpaceDedupeMetafilesFootprint != "" {

			if err := r.SetQueryParam("space.dedupe_metafiles_footprint", qSpaceDedupeMetafilesFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceDedupeMetafilesTemporaryFootprint != nil {

		// query param space.dedupe_metafiles_temporary_footprint
		var qrSpaceDedupeMetafilesTemporaryFootprint int64

		if o.SpaceDedupeMetafilesTemporaryFootprint != nil {
			qrSpaceDedupeMetafilesTemporaryFootprint = *o.SpaceDedupeMetafilesTemporaryFootprint
		}
		qSpaceDedupeMetafilesTemporaryFootprint := swag.FormatInt64(qrSpaceDedupeMetafilesTemporaryFootprint)
		if qSpaceDedupeMetafilesTemporaryFootprint != "" {

			if err := r.SetQueryParam("space.dedupe_metafiles_temporary_footprint", qSpaceDedupeMetafilesTemporaryFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceDelayedFreeFootprint != nil {

		// query param space.delayed_free_footprint
		var qrSpaceDelayedFreeFootprint int64

		if o.SpaceDelayedFreeFootprint != nil {
			qrSpaceDelayedFreeFootprint = *o.SpaceDelayedFreeFootprint
		}
		qSpaceDelayedFreeFootprint := swag.FormatInt64(qrSpaceDelayedFreeFootprint)
		if qSpaceDelayedFreeFootprint != "" {

			if err := r.SetQueryParam("space.delayed_free_footprint", qSpaceDelayedFreeFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceEffectiveTotalFootprint != nil {

		// query param space.effective_total_footprint
		var qrSpaceEffectiveTotalFootprint int64

		if o.SpaceEffectiveTotalFootprint != nil {
			qrSpaceEffectiveTotalFootprint = *o.SpaceEffectiveTotalFootprint
		}
		qSpaceEffectiveTotalFootprint := swag.FormatInt64(qrSpaceEffectiveTotalFootprint)
		if qSpaceEffectiveTotalFootprint != "" {

			if err := r.SetQueryParam("space.effective_total_footprint", qSpaceEffectiveTotalFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceExpectedAvailable != nil {

		// query param space.expected_available
		var qrSpaceExpectedAvailable int64

		if o.SpaceExpectedAvailable != nil {
			qrSpaceExpectedAvailable = *o.SpaceExpectedAvailable
		}
		qSpaceExpectedAvailable := swag.FormatInt64(qrSpaceExpectedAvailable)
		if qSpaceExpectedAvailable != "" {

			if err := r.SetQueryParam("space.expected_available", qSpaceExpectedAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceFileOperationMetadata != nil {

		// query param space.file_operation_metadata
		var qrSpaceFileOperationMetadata int64

		if o.SpaceFileOperationMetadata != nil {
			qrSpaceFileOperationMetadata = *o.SpaceFileOperationMetadata
		}
		qSpaceFileOperationMetadata := swag.FormatInt64(qrSpaceFileOperationMetadata)
		if qSpaceFileOperationMetadata != "" {

			if err := r.SetQueryParam("space.file_operation_metadata", qSpaceFileOperationMetadata); err != nil {
				return err
			}
		}
	}

	if o.SpaceFilesystemSize != nil {

		// query param space.filesystem_size
		var qrSpaceFilesystemSize int64

		if o.SpaceFilesystemSize != nil {
			qrSpaceFilesystemSize = *o.SpaceFilesystemSize
		}
		qSpaceFilesystemSize := swag.FormatInt64(qrSpaceFilesystemSize)
		if qSpaceFilesystemSize != "" {

			if err := r.SetQueryParam("space.filesystem_size", qSpaceFilesystemSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceFilesystemSizeFixed != nil {

		// query param space.filesystem_size_fixed
		var qrSpaceFilesystemSizeFixed bool

		if o.SpaceFilesystemSizeFixed != nil {
			qrSpaceFilesystemSizeFixed = *o.SpaceFilesystemSizeFixed
		}
		qSpaceFilesystemSizeFixed := swag.FormatBool(qrSpaceFilesystemSizeFixed)
		if qSpaceFilesystemSizeFixed != "" {

			if err := r.SetQueryParam("space.filesystem_size_fixed", qSpaceFilesystemSizeFixed); err != nil {
				return err
			}
		}
	}

	if o.SpaceFootprint != nil {

		// query param space.footprint
		var qrSpaceFootprint int64

		if o.SpaceFootprint != nil {
			qrSpaceFootprint = *o.SpaceFootprint
		}
		qSpaceFootprint := swag.FormatInt64(qrSpaceFootprint)
		if qSpaceFootprint != "" {

			if err := r.SetQueryParam("space.footprint", qSpaceFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceFractionalReserve != nil {

		// query param space.fractional_reserve
		var qrSpaceFractionalReserve int64

		if o.SpaceFractionalReserve != nil {
			qrSpaceFractionalReserve = *o.SpaceFractionalReserve
		}
		qSpaceFractionalReserve := swag.FormatInt64(qrSpaceFractionalReserve)
		if qSpaceFractionalReserve != "" {

			if err := r.SetQueryParam("space.fractional_reserve", qSpaceFractionalReserve); err != nil {
				return err
			}
		}
	}

	if o.SpaceFullThresholdPercent != nil {

		// query param space.full_threshold_percent
		var qrSpaceFullThresholdPercent int64

		if o.SpaceFullThresholdPercent != nil {
			qrSpaceFullThresholdPercent = *o.SpaceFullThresholdPercent
		}
		qSpaceFullThresholdPercent := swag.FormatInt64(qrSpaceFullThresholdPercent)
		if qSpaceFullThresholdPercent != "" {

			if err := r.SetQueryParam("space.full_threshold_percent", qSpaceFullThresholdPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceIsUsedStale != nil {

		// query param space.is_used_stale
		var qrSpaceIsUsedStale bool

		if o.SpaceIsUsedStale != nil {
			qrSpaceIsUsedStale = *o.SpaceIsUsedStale
		}
		qSpaceIsUsedStale := swag.FormatBool(qrSpaceIsUsedStale)
		if qSpaceIsUsedStale != "" {

			if err := r.SetQueryParam("space.is_used_stale", qSpaceIsUsedStale); err != nil {
				return err
			}
		}
	}

	if o.SpaceLargeSizeEnabled != nil {

		// query param space.large_size_enabled
		var qrSpaceLargeSizeEnabled bool

		if o.SpaceLargeSizeEnabled != nil {
			qrSpaceLargeSizeEnabled = *o.SpaceLargeSizeEnabled
		}
		qSpaceLargeSizeEnabled := swag.FormatBool(qrSpaceLargeSizeEnabled)
		if qSpaceLargeSizeEnabled != "" {

			if err := r.SetQueryParam("space.large_size_enabled", qSpaceLargeSizeEnabled); err != nil {
				return err
			}
		}
	}

	if o.SpaceLocalTierFootprint != nil {

		// query param space.local_tier_footprint
		var qrSpaceLocalTierFootprint int64

		if o.SpaceLocalTierFootprint != nil {
			qrSpaceLocalTierFootprint = *o.SpaceLocalTierFootprint
		}
		qSpaceLocalTierFootprint := swag.FormatInt64(qrSpaceLocalTierFootprint)
		if qSpaceLocalTierFootprint != "" {

			if err := r.SetQueryParam("space.local_tier_footprint", qSpaceLocalTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceAvailable != nil {

		// query param space.logical_space.available
		var qrSpaceLogicalSpaceAvailable int64

		if o.SpaceLogicalSpaceAvailable != nil {
			qrSpaceLogicalSpaceAvailable = *o.SpaceLogicalSpaceAvailable
		}
		qSpaceLogicalSpaceAvailable := swag.FormatInt64(qrSpaceLogicalSpaceAvailable)
		if qSpaceLogicalSpaceAvailable != "" {

			if err := r.SetQueryParam("space.logical_space.available", qSpaceLogicalSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceEnforcement != nil {

		// query param space.logical_space.enforcement
		var qrSpaceLogicalSpaceEnforcement bool

		if o.SpaceLogicalSpaceEnforcement != nil {
			qrSpaceLogicalSpaceEnforcement = *o.SpaceLogicalSpaceEnforcement
		}
		qSpaceLogicalSpaceEnforcement := swag.FormatBool(qrSpaceLogicalSpaceEnforcement)
		if qSpaceLogicalSpaceEnforcement != "" {

			if err := r.SetQueryParam("space.logical_space.enforcement", qSpaceLogicalSpaceEnforcement); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceReporting != nil {

		// query param space.logical_space.reporting
		var qrSpaceLogicalSpaceReporting bool

		if o.SpaceLogicalSpaceReporting != nil {
			qrSpaceLogicalSpaceReporting = *o.SpaceLogicalSpaceReporting
		}
		qSpaceLogicalSpaceReporting := swag.FormatBool(qrSpaceLogicalSpaceReporting)
		if qSpaceLogicalSpaceReporting != "" {

			if err := r.SetQueryParam("space.logical_space.reporting", qSpaceLogicalSpaceReporting); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceUsed != nil {

		// query param space.logical_space.used
		var qrSpaceLogicalSpaceUsed int64

		if o.SpaceLogicalSpaceUsed != nil {
			qrSpaceLogicalSpaceUsed = *o.SpaceLogicalSpaceUsed
		}
		qSpaceLogicalSpaceUsed := swag.FormatInt64(qrSpaceLogicalSpaceUsed)
		if qSpaceLogicalSpaceUsed != "" {

			if err := r.SetQueryParam("space.logical_space.used", qSpaceLogicalSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceUsedByAfs != nil {

		// query param space.logical_space.used_by_afs
		var qrSpaceLogicalSpaceUsedByAfs int64

		if o.SpaceLogicalSpaceUsedByAfs != nil {
			qrSpaceLogicalSpaceUsedByAfs = *o.SpaceLogicalSpaceUsedByAfs
		}
		qSpaceLogicalSpaceUsedByAfs := swag.FormatInt64(qrSpaceLogicalSpaceUsedByAfs)
		if qSpaceLogicalSpaceUsedByAfs != "" {

			if err := r.SetQueryParam("space.logical_space.used_by_afs", qSpaceLogicalSpaceUsedByAfs); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceUsedBySnapshots != nil {

		// query param space.logical_space.used_by_snapshots
		var qrSpaceLogicalSpaceUsedBySnapshots int64

		if o.SpaceLogicalSpaceUsedBySnapshots != nil {
			qrSpaceLogicalSpaceUsedBySnapshots = *o.SpaceLogicalSpaceUsedBySnapshots
		}
		qSpaceLogicalSpaceUsedBySnapshots := swag.FormatInt64(qrSpaceLogicalSpaceUsedBySnapshots)
		if qSpaceLogicalSpaceUsedBySnapshots != "" {

			if err := r.SetQueryParam("space.logical_space.used_by_snapshots", qSpaceLogicalSpaceUsedBySnapshots); err != nil {
				return err
			}
		}
	}

	if o.SpaceLogicalSpaceUsedPercent != nil {

		// query param space.logical_space.used_percent
		var qrSpaceLogicalSpaceUsedPercent int64

		if o.SpaceLogicalSpaceUsedPercent != nil {
			qrSpaceLogicalSpaceUsedPercent = *o.SpaceLogicalSpaceUsedPercent
		}
		qSpaceLogicalSpaceUsedPercent := swag.FormatInt64(qrSpaceLogicalSpaceUsedPercent)
		if qSpaceLogicalSpaceUsedPercent != "" {

			if err := r.SetQueryParam("space.logical_space.used_percent", qSpaceLogicalSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceMaxSize != nil {

		// query param space.max_size
		var qrSpaceMaxSize string

		if o.SpaceMaxSize != nil {
			qrSpaceMaxSize = *o.SpaceMaxSize
		}
		qSpaceMaxSize := qrSpaceMaxSize
		if qSpaceMaxSize != "" {

			if err := r.SetQueryParam("space.max_size", qSpaceMaxSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceMetadata != nil {

		// query param space.metadata
		var qrSpaceMetadata int64

		if o.SpaceMetadata != nil {
			qrSpaceMetadata = *o.SpaceMetadata
		}
		qSpaceMetadata := swag.FormatInt64(qrSpaceMetadata)
		if qSpaceMetadata != "" {

			if err := r.SetQueryParam("space.metadata", qSpaceMetadata); err != nil {
				return err
			}
		}
	}

	if o.SpaceNearlyFullThresholdPercent != nil {

		// query param space.nearly_full_threshold_percent
		var qrSpaceNearlyFullThresholdPercent int64

		if o.SpaceNearlyFullThresholdPercent != nil {
			qrSpaceNearlyFullThresholdPercent = *o.SpaceNearlyFullThresholdPercent
		}
		qSpaceNearlyFullThresholdPercent := swag.FormatInt64(qrSpaceNearlyFullThresholdPercent)
		if qSpaceNearlyFullThresholdPercent != "" {

			if err := r.SetQueryParam("space.nearly_full_threshold_percent", qSpaceNearlyFullThresholdPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceOverProvisioned != nil {

		// query param space.over_provisioned
		var qrSpaceOverProvisioned int64

		if o.SpaceOverProvisioned != nil {
			qrSpaceOverProvisioned = *o.SpaceOverProvisioned
		}
		qSpaceOverProvisioned := swag.FormatInt64(qrSpaceOverProvisioned)
		if qSpaceOverProvisioned != "" {

			if err := r.SetQueryParam("space.over_provisioned", qSpaceOverProvisioned); err != nil {
				return err
			}
		}
	}

	if o.SpaceOverwriteReserve != nil {

		// query param space.overwrite_reserve
		var qrSpaceOverwriteReserve int64

		if o.SpaceOverwriteReserve != nil {
			qrSpaceOverwriteReserve = *o.SpaceOverwriteReserve
		}
		qSpaceOverwriteReserve := swag.FormatInt64(qrSpaceOverwriteReserve)
		if qSpaceOverwriteReserve != "" {

			if err := r.SetQueryParam("space.overwrite_reserve", qSpaceOverwriteReserve); err != nil {
				return err
			}
		}
	}

	if o.SpaceOverwriteReserveUsed != nil {

		// query param space.overwrite_reserve_used
		var qrSpaceOverwriteReserveUsed int64

		if o.SpaceOverwriteReserveUsed != nil {
			qrSpaceOverwriteReserveUsed = *o.SpaceOverwriteReserveUsed
		}
		qSpaceOverwriteReserveUsed := swag.FormatInt64(qrSpaceOverwriteReserveUsed)
		if qSpaceOverwriteReserveUsed != "" {

			if err := r.SetQueryParam("space.overwrite_reserve_used", qSpaceOverwriteReserveUsed); err != nil {
				return err
			}
		}
	}

	if o.SpacePercentUsed != nil {

		// query param space.percent_used
		var qrSpacePercentUsed int64

		if o.SpacePercentUsed != nil {
			qrSpacePercentUsed = *o.SpacePercentUsed
		}
		qSpacePercentUsed := swag.FormatInt64(qrSpacePercentUsed)
		if qSpacePercentUsed != "" {

			if err := r.SetQueryParam("space.percent_used", qSpacePercentUsed); err != nil {
				return err
			}
		}
	}

	if o.SpacePerformanceTierFootprint != nil {

		// query param space.performance_tier_footprint
		var qrSpacePerformanceTierFootprint int64

		if o.SpacePerformanceTierFootprint != nil {
			qrSpacePerformanceTierFootprint = *o.SpacePerformanceTierFootprint
		}
		qSpacePerformanceTierFootprint := swag.FormatInt64(qrSpacePerformanceTierFootprint)
		if qSpacePerformanceTierFootprint != "" {

			if err := r.SetQueryParam("space.performance_tier_footprint", qSpacePerformanceTierFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpacePhysicalUsed != nil {

		// query param space.physical_used
		var qrSpacePhysicalUsed int64

		if o.SpacePhysicalUsed != nil {
			qrSpacePhysicalUsed = *o.SpacePhysicalUsed
		}
		qSpacePhysicalUsed := swag.FormatInt64(qrSpacePhysicalUsed)
		if qSpacePhysicalUsed != "" {

			if err := r.SetQueryParam("space.physical_used", qSpacePhysicalUsed); err != nil {
				return err
			}
		}
	}

	if o.SpacePhysicalUsedPercent != nil {

		// query param space.physical_used_percent
		var qrSpacePhysicalUsedPercent int64

		if o.SpacePhysicalUsedPercent != nil {
			qrSpacePhysicalUsedPercent = *o.SpacePhysicalUsedPercent
		}
		qSpacePhysicalUsedPercent := swag.FormatInt64(qrSpacePhysicalUsedPercent)
		if qSpacePhysicalUsedPercent != "" {

			if err := r.SetQueryParam("space.physical_used_percent", qSpacePhysicalUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceSize != nil {

		// query param space.size
		var qrSpaceSize int64

		if o.SpaceSize != nil {
			qrSpaceSize = *o.SpaceSize
		}
		qSpaceSize := swag.FormatInt64(qrSpaceSize)
		if qSpaceSize != "" {

			if err := r.SetQueryParam("space.size", qSpaceSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceSizeAvailableForSnapshots != nil {

		// query param space.size_available_for_snapshots
		var qrSpaceSizeAvailableForSnapshots int64

		if o.SpaceSizeAvailableForSnapshots != nil {
			qrSpaceSizeAvailableForSnapshots = *o.SpaceSizeAvailableForSnapshots
		}
		qSpaceSizeAvailableForSnapshots := swag.FormatInt64(qrSpaceSizeAvailableForSnapshots)
		if qSpaceSizeAvailableForSnapshots != "" {

			if err := r.SetQueryParam("space.size_available_for_snapshots", qSpaceSizeAvailableForSnapshots); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapmirrorDestinationFootprint != nil {

		// query param space.snapmirror_destination_footprint
		var qrSpaceSnapmirrorDestinationFootprint int64

		if o.SpaceSnapmirrorDestinationFootprint != nil {
			qrSpaceSnapmirrorDestinationFootprint = *o.SpaceSnapmirrorDestinationFootprint
		}
		qSpaceSnapmirrorDestinationFootprint := swag.FormatInt64(qrSpaceSnapmirrorDestinationFootprint)
		if qSpaceSnapmirrorDestinationFootprint != "" {

			if err := r.SetQueryParam("space.snapmirror_destination_footprint", qSpaceSnapmirrorDestinationFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteCommitment != nil {

		// query param space.snapshot.autodelete.commitment
		var qrSpaceSnapshotAutodeleteCommitment string

		if o.SpaceSnapshotAutodeleteCommitment != nil {
			qrSpaceSnapshotAutodeleteCommitment = *o.SpaceSnapshotAutodeleteCommitment
		}
		qSpaceSnapshotAutodeleteCommitment := qrSpaceSnapshotAutodeleteCommitment
		if qSpaceSnapshotAutodeleteCommitment != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.commitment", qSpaceSnapshotAutodeleteCommitment); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteDeferDelete != nil {

		// query param space.snapshot.autodelete.defer_delete
		var qrSpaceSnapshotAutodeleteDeferDelete string

		if o.SpaceSnapshotAutodeleteDeferDelete != nil {
			qrSpaceSnapshotAutodeleteDeferDelete = *o.SpaceSnapshotAutodeleteDeferDelete
		}
		qSpaceSnapshotAutodeleteDeferDelete := qrSpaceSnapshotAutodeleteDeferDelete
		if qSpaceSnapshotAutodeleteDeferDelete != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.defer_delete", qSpaceSnapshotAutodeleteDeferDelete); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteDeleteOrder != nil {

		// query param space.snapshot.autodelete.delete_order
		var qrSpaceSnapshotAutodeleteDeleteOrder string

		if o.SpaceSnapshotAutodeleteDeleteOrder != nil {
			qrSpaceSnapshotAutodeleteDeleteOrder = *o.SpaceSnapshotAutodeleteDeleteOrder
		}
		qSpaceSnapshotAutodeleteDeleteOrder := qrSpaceSnapshotAutodeleteDeleteOrder
		if qSpaceSnapshotAutodeleteDeleteOrder != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.delete_order", qSpaceSnapshotAutodeleteDeleteOrder); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeletePrefix != nil {

		// query param space.snapshot.autodelete.prefix
		var qrSpaceSnapshotAutodeletePrefix string

		if o.SpaceSnapshotAutodeletePrefix != nil {
			qrSpaceSnapshotAutodeletePrefix = *o.SpaceSnapshotAutodeletePrefix
		}
		qSpaceSnapshotAutodeletePrefix := qrSpaceSnapshotAutodeletePrefix
		if qSpaceSnapshotAutodeletePrefix != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.prefix", qSpaceSnapshotAutodeletePrefix); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteTargetFreeSpace != nil {

		// query param space.snapshot.autodelete.target_free_space
		var qrSpaceSnapshotAutodeleteTargetFreeSpace int64

		if o.SpaceSnapshotAutodeleteTargetFreeSpace != nil {
			qrSpaceSnapshotAutodeleteTargetFreeSpace = *o.SpaceSnapshotAutodeleteTargetFreeSpace
		}
		qSpaceSnapshotAutodeleteTargetFreeSpace := swag.FormatInt64(qrSpaceSnapshotAutodeleteTargetFreeSpace)
		if qSpaceSnapshotAutodeleteTargetFreeSpace != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.target_free_space", qSpaceSnapshotAutodeleteTargetFreeSpace); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteTrigger != nil {

		// query param space.snapshot.autodelete_trigger
		var qrSpaceSnapshotAutodeleteTrigger string

		if o.SpaceSnapshotAutodeleteTrigger != nil {
			qrSpaceSnapshotAutodeleteTrigger = *o.SpaceSnapshotAutodeleteTrigger
		}
		qSpaceSnapshotAutodeleteTrigger := qrSpaceSnapshotAutodeleteTrigger
		if qSpaceSnapshotAutodeleteTrigger != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete_trigger", qSpaceSnapshotAutodeleteTrigger); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReserveAvailable != nil {

		// query param space.snapshot.reserve_available
		var qrSpaceSnapshotReserveAvailable int64

		if o.SpaceSnapshotReserveAvailable != nil {
			qrSpaceSnapshotReserveAvailable = *o.SpaceSnapshotReserveAvailable
		}
		qSpaceSnapshotReserveAvailable := swag.FormatInt64(qrSpaceSnapshotReserveAvailable)
		if qSpaceSnapshotReserveAvailable != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_available", qSpaceSnapshotReserveAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReservePercent != nil {

		// query param space.snapshot.reserve_percent
		var qrSpaceSnapshotReservePercent int64

		if o.SpaceSnapshotReservePercent != nil {
			qrSpaceSnapshotReservePercent = *o.SpaceSnapshotReservePercent
		}
		qSpaceSnapshotReservePercent := swag.FormatInt64(qrSpaceSnapshotReservePercent)
		if qSpaceSnapshotReservePercent != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_percent", qSpaceSnapshotReservePercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReserveSize != nil {

		// query param space.snapshot.reserve_size
		var qrSpaceSnapshotReserveSize int64

		if o.SpaceSnapshotReserveSize != nil {
			qrSpaceSnapshotReserveSize = *o.SpaceSnapshotReserveSize
		}
		qSpaceSnapshotReserveSize := swag.FormatInt64(qrSpaceSnapshotReserveSize)
		if qSpaceSnapshotReserveSize != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_size", qSpaceSnapshotReserveSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotSpaceUsedPercent != nil {

		// query param space.snapshot.space_used_percent
		var qrSpaceSnapshotSpaceUsedPercent int64

		if o.SpaceSnapshotSpaceUsedPercent != nil {
			qrSpaceSnapshotSpaceUsedPercent = *o.SpaceSnapshotSpaceUsedPercent
		}
		qSpaceSnapshotSpaceUsedPercent := swag.FormatInt64(qrSpaceSnapshotSpaceUsedPercent)
		if qSpaceSnapshotSpaceUsedPercent != "" {

			if err := r.SetQueryParam("space.snapshot.space_used_percent", qSpaceSnapshotSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotUsed != nil {

		// query param space.snapshot.used
		var qrSpaceSnapshotUsed int64

		if o.SpaceSnapshotUsed != nil {
			qrSpaceSnapshotUsed = *o.SpaceSnapshotUsed
		}
		qSpaceSnapshotUsed := swag.FormatInt64(qrSpaceSnapshotUsed)
		if qSpaceSnapshotUsed != "" {

			if err := r.SetQueryParam("space.snapshot.used", qSpaceSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReserveUnusable != nil {

		// query param space.snapshot_reserve_unusable
		var qrSpaceSnapshotReserveUnusable int64

		if o.SpaceSnapshotReserveUnusable != nil {
			qrSpaceSnapshotReserveUnusable = *o.SpaceSnapshotReserveUnusable
		}
		qSpaceSnapshotReserveUnusable := swag.FormatInt64(qrSpaceSnapshotReserveUnusable)
		if qSpaceSnapshotReserveUnusable != "" {

			if err := r.SetQueryParam("space.snapshot_reserve_unusable", qSpaceSnapshotReserveUnusable); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotSpill != nil {

		// query param space.snapshot_spill
		var qrSpaceSnapshotSpill int64

		if o.SpaceSnapshotSpill != nil {
			qrSpaceSnapshotSpill = *o.SpaceSnapshotSpill
		}
		qSpaceSnapshotSpill := swag.FormatInt64(qrSpaceSnapshotSpill)
		if qSpaceSnapshotSpill != "" {

			if err := r.SetQueryParam("space.snapshot_spill", qSpaceSnapshotSpill); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotalFootprint != nil {

		// query param space.total_footprint
		var qrSpaceTotalFootprint int64

		if o.SpaceTotalFootprint != nil {
			qrSpaceTotalFootprint = *o.SpaceTotalFootprint
		}
		qSpaceTotalFootprint := swag.FormatInt64(qrSpaceTotalFootprint)
		if qSpaceTotalFootprint != "" {

			if err := r.SetQueryParam("space.total_footprint", qSpaceTotalFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotalMetadata != nil {

		// query param space.total_metadata
		var qrSpaceTotalMetadata int64

		if o.SpaceTotalMetadata != nil {
			qrSpaceTotalMetadata = *o.SpaceTotalMetadata
		}
		qSpaceTotalMetadata := swag.FormatInt64(qrSpaceTotalMetadata)
		if qSpaceTotalMetadata != "" {

			if err := r.SetQueryParam("space.total_metadata", qSpaceTotalMetadata); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotalMetadataFootprint != nil {

		// query param space.total_metadata_footprint
		var qrSpaceTotalMetadataFootprint int64

		if o.SpaceTotalMetadataFootprint != nil {
			qrSpaceTotalMetadataFootprint = *o.SpaceTotalMetadataFootprint
		}
		qSpaceTotalMetadataFootprint := swag.FormatInt64(qrSpaceTotalMetadataFootprint)
		if qSpaceTotalMetadataFootprint != "" {

			if err := r.SetQueryParam("space.total_metadata_footprint", qSpaceTotalMetadataFootprint); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsedByAfs != nil {

		// query param space.used_by_afs
		var qrSpaceUsedByAfs int64

		if o.SpaceUsedByAfs != nil {
			qrSpaceUsedByAfs = *o.SpaceUsedByAfs
		}
		qSpaceUsedByAfs := swag.FormatInt64(qrSpaceUsedByAfs)
		if qSpaceUsedByAfs != "" {

			if err := r.SetQueryParam("space.used_by_afs", qSpaceUsedByAfs); err != nil {
				return err
			}
		}
	}

	if o.SpaceUserData != nil {

		// query param space.user_data
		var qrSpaceUserData int64

		if o.SpaceUserData != nil {
			qrSpaceUserData = *o.SpaceUserData
		}
		qSpaceUserData := swag.FormatInt64(qrSpaceUserData)
		if qSpaceUserData != "" {

			if err := r.SetQueryParam("space.user_data", qSpaceUserData); err != nil {
				return err
			}
		}
	}

	if o.SpaceVolumeGuaranteeFootprint != nil {

		// query param space.volume_guarantee_footprint
		var qrSpaceVolumeGuaranteeFootprint int64

		if o.SpaceVolumeGuaranteeFootprint != nil {
			qrSpaceVolumeGuaranteeFootprint = *o.SpaceVolumeGuaranteeFootprint
		}
		qSpaceVolumeGuaranteeFootprint := swag.FormatInt64(qrSpaceVolumeGuaranteeFootprint)
		if qSpaceVolumeGuaranteeFootprint != "" {

			if err := r.SetQueryParam("space.volume_guarantee_footprint", qSpaceVolumeGuaranteeFootprint); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawAccessCount != nil {

		// query param statistics.cifs_ops_raw.access.count
		var qrStatisticsCifsOpsRawAccessCount int64

		if o.StatisticsCifsOpsRawAccessCount != nil {
			qrStatisticsCifsOpsRawAccessCount = *o.StatisticsCifsOpsRawAccessCount
		}
		qStatisticsCifsOpsRawAccessCount := swag.FormatInt64(qrStatisticsCifsOpsRawAccessCount)
		if qStatisticsCifsOpsRawAccessCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.access.count", qStatisticsCifsOpsRawAccessCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawAccessTotalTime != nil {

		// query param statistics.cifs_ops_raw.access.total_time
		var qrStatisticsCifsOpsRawAccessTotalTime int64

		if o.StatisticsCifsOpsRawAccessTotalTime != nil {
			qrStatisticsCifsOpsRawAccessTotalTime = *o.StatisticsCifsOpsRawAccessTotalTime
		}
		qStatisticsCifsOpsRawAccessTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawAccessTotalTime)
		if qStatisticsCifsOpsRawAccessTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.access.total_time", qStatisticsCifsOpsRawAccessTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawAuditCount != nil {

		// query param statistics.cifs_ops_raw.audit.count
		var qrStatisticsCifsOpsRawAuditCount int64

		if o.StatisticsCifsOpsRawAuditCount != nil {
			qrStatisticsCifsOpsRawAuditCount = *o.StatisticsCifsOpsRawAuditCount
		}
		qStatisticsCifsOpsRawAuditCount := swag.FormatInt64(qrStatisticsCifsOpsRawAuditCount)
		if qStatisticsCifsOpsRawAuditCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.audit.count", qStatisticsCifsOpsRawAuditCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawAuditTotalTime != nil {

		// query param statistics.cifs_ops_raw.audit.total_time
		var qrStatisticsCifsOpsRawAuditTotalTime int64

		if o.StatisticsCifsOpsRawAuditTotalTime != nil {
			qrStatisticsCifsOpsRawAuditTotalTime = *o.StatisticsCifsOpsRawAuditTotalTime
		}
		qStatisticsCifsOpsRawAuditTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawAuditTotalTime)
		if qStatisticsCifsOpsRawAuditTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.audit.total_time", qStatisticsCifsOpsRawAuditTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateDirCount != nil {

		// query param statistics.cifs_ops_raw.create.dir.count
		var qrStatisticsCifsOpsRawCreateDirCount int64

		if o.StatisticsCifsOpsRawCreateDirCount != nil {
			qrStatisticsCifsOpsRawCreateDirCount = *o.StatisticsCifsOpsRawCreateDirCount
		}
		qStatisticsCifsOpsRawCreateDirCount := swag.FormatInt64(qrStatisticsCifsOpsRawCreateDirCount)
		if qStatisticsCifsOpsRawCreateDirCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.dir.count", qStatisticsCifsOpsRawCreateDirCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateDirTotalTime != nil {

		// query param statistics.cifs_ops_raw.create.dir.total_time
		var qrStatisticsCifsOpsRawCreateDirTotalTime int64

		if o.StatisticsCifsOpsRawCreateDirTotalTime != nil {
			qrStatisticsCifsOpsRawCreateDirTotalTime = *o.StatisticsCifsOpsRawCreateDirTotalTime
		}
		qStatisticsCifsOpsRawCreateDirTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawCreateDirTotalTime)
		if qStatisticsCifsOpsRawCreateDirTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.dir.total_time", qStatisticsCifsOpsRawCreateDirTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateFileCount != nil {

		// query param statistics.cifs_ops_raw.create.file.count
		var qrStatisticsCifsOpsRawCreateFileCount int64

		if o.StatisticsCifsOpsRawCreateFileCount != nil {
			qrStatisticsCifsOpsRawCreateFileCount = *o.StatisticsCifsOpsRawCreateFileCount
		}
		qStatisticsCifsOpsRawCreateFileCount := swag.FormatInt64(qrStatisticsCifsOpsRawCreateFileCount)
		if qStatisticsCifsOpsRawCreateFileCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.file.count", qStatisticsCifsOpsRawCreateFileCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateFileTotalTime != nil {

		// query param statistics.cifs_ops_raw.create.file.total_time
		var qrStatisticsCifsOpsRawCreateFileTotalTime int64

		if o.StatisticsCifsOpsRawCreateFileTotalTime != nil {
			qrStatisticsCifsOpsRawCreateFileTotalTime = *o.StatisticsCifsOpsRawCreateFileTotalTime
		}
		qStatisticsCifsOpsRawCreateFileTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawCreateFileTotalTime)
		if qStatisticsCifsOpsRawCreateFileTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.file.total_time", qStatisticsCifsOpsRawCreateFileTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateOtherCount != nil {

		// query param statistics.cifs_ops_raw.create.other.count
		var qrStatisticsCifsOpsRawCreateOtherCount int64

		if o.StatisticsCifsOpsRawCreateOtherCount != nil {
			qrStatisticsCifsOpsRawCreateOtherCount = *o.StatisticsCifsOpsRawCreateOtherCount
		}
		qStatisticsCifsOpsRawCreateOtherCount := swag.FormatInt64(qrStatisticsCifsOpsRawCreateOtherCount)
		if qStatisticsCifsOpsRawCreateOtherCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.other.count", qStatisticsCifsOpsRawCreateOtherCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateOtherTotalTime != nil {

		// query param statistics.cifs_ops_raw.create.other.total_time
		var qrStatisticsCifsOpsRawCreateOtherTotalTime int64

		if o.StatisticsCifsOpsRawCreateOtherTotalTime != nil {
			qrStatisticsCifsOpsRawCreateOtherTotalTime = *o.StatisticsCifsOpsRawCreateOtherTotalTime
		}
		qStatisticsCifsOpsRawCreateOtherTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawCreateOtherTotalTime)
		if qStatisticsCifsOpsRawCreateOtherTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.other.total_time", qStatisticsCifsOpsRawCreateOtherTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateSymlinkCount != nil {

		// query param statistics.cifs_ops_raw.create.symlink.count
		var qrStatisticsCifsOpsRawCreateSymlinkCount int64

		if o.StatisticsCifsOpsRawCreateSymlinkCount != nil {
			qrStatisticsCifsOpsRawCreateSymlinkCount = *o.StatisticsCifsOpsRawCreateSymlinkCount
		}
		qStatisticsCifsOpsRawCreateSymlinkCount := swag.FormatInt64(qrStatisticsCifsOpsRawCreateSymlinkCount)
		if qStatisticsCifsOpsRawCreateSymlinkCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.symlink.count", qStatisticsCifsOpsRawCreateSymlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawCreateSymlinkTotalTime != nil {

		// query param statistics.cifs_ops_raw.create.symlink.total_time
		var qrStatisticsCifsOpsRawCreateSymlinkTotalTime int64

		if o.StatisticsCifsOpsRawCreateSymlinkTotalTime != nil {
			qrStatisticsCifsOpsRawCreateSymlinkTotalTime = *o.StatisticsCifsOpsRawCreateSymlinkTotalTime
		}
		qStatisticsCifsOpsRawCreateSymlinkTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawCreateSymlinkTotalTime)
		if qStatisticsCifsOpsRawCreateSymlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.create.symlink.total_time", qStatisticsCifsOpsRawCreateSymlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawGetattrCount != nil {

		// query param statistics.cifs_ops_raw.getattr.count
		var qrStatisticsCifsOpsRawGetattrCount int64

		if o.StatisticsCifsOpsRawGetattrCount != nil {
			qrStatisticsCifsOpsRawGetattrCount = *o.StatisticsCifsOpsRawGetattrCount
		}
		qStatisticsCifsOpsRawGetattrCount := swag.FormatInt64(qrStatisticsCifsOpsRawGetattrCount)
		if qStatisticsCifsOpsRawGetattrCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.getattr.count", qStatisticsCifsOpsRawGetattrCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawGetattrTotalTime != nil {

		// query param statistics.cifs_ops_raw.getattr.total_time
		var qrStatisticsCifsOpsRawGetattrTotalTime int64

		if o.StatisticsCifsOpsRawGetattrTotalTime != nil {
			qrStatisticsCifsOpsRawGetattrTotalTime = *o.StatisticsCifsOpsRawGetattrTotalTime
		}
		qStatisticsCifsOpsRawGetattrTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawGetattrTotalTime)
		if qStatisticsCifsOpsRawGetattrTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.getattr.total_time", qStatisticsCifsOpsRawGetattrTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLinkCount != nil {

		// query param statistics.cifs_ops_raw.link.count
		var qrStatisticsCifsOpsRawLinkCount int64

		if o.StatisticsCifsOpsRawLinkCount != nil {
			qrStatisticsCifsOpsRawLinkCount = *o.StatisticsCifsOpsRawLinkCount
		}
		qStatisticsCifsOpsRawLinkCount := swag.FormatInt64(qrStatisticsCifsOpsRawLinkCount)
		if qStatisticsCifsOpsRawLinkCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.link.count", qStatisticsCifsOpsRawLinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLinkTotalTime != nil {

		// query param statistics.cifs_ops_raw.link.total_time
		var qrStatisticsCifsOpsRawLinkTotalTime int64

		if o.StatisticsCifsOpsRawLinkTotalTime != nil {
			qrStatisticsCifsOpsRawLinkTotalTime = *o.StatisticsCifsOpsRawLinkTotalTime
		}
		qStatisticsCifsOpsRawLinkTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawLinkTotalTime)
		if qStatisticsCifsOpsRawLinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.link.total_time", qStatisticsCifsOpsRawLinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLockCount != nil {

		// query param statistics.cifs_ops_raw.lock.count
		var qrStatisticsCifsOpsRawLockCount int64

		if o.StatisticsCifsOpsRawLockCount != nil {
			qrStatisticsCifsOpsRawLockCount = *o.StatisticsCifsOpsRawLockCount
		}
		qStatisticsCifsOpsRawLockCount := swag.FormatInt64(qrStatisticsCifsOpsRawLockCount)
		if qStatisticsCifsOpsRawLockCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.lock.count", qStatisticsCifsOpsRawLockCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLockTotalTime != nil {

		// query param statistics.cifs_ops_raw.lock.total_time
		var qrStatisticsCifsOpsRawLockTotalTime int64

		if o.StatisticsCifsOpsRawLockTotalTime != nil {
			qrStatisticsCifsOpsRawLockTotalTime = *o.StatisticsCifsOpsRawLockTotalTime
		}
		qStatisticsCifsOpsRawLockTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawLockTotalTime)
		if qStatisticsCifsOpsRawLockTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.lock.total_time", qStatisticsCifsOpsRawLockTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLookupCount != nil {

		// query param statistics.cifs_ops_raw.lookup.count
		var qrStatisticsCifsOpsRawLookupCount int64

		if o.StatisticsCifsOpsRawLookupCount != nil {
			qrStatisticsCifsOpsRawLookupCount = *o.StatisticsCifsOpsRawLookupCount
		}
		qStatisticsCifsOpsRawLookupCount := swag.FormatInt64(qrStatisticsCifsOpsRawLookupCount)
		if qStatisticsCifsOpsRawLookupCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.lookup.count", qStatisticsCifsOpsRawLookupCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawLookupTotalTime != nil {

		// query param statistics.cifs_ops_raw.lookup.total_time
		var qrStatisticsCifsOpsRawLookupTotalTime int64

		if o.StatisticsCifsOpsRawLookupTotalTime != nil {
			qrStatisticsCifsOpsRawLookupTotalTime = *o.StatisticsCifsOpsRawLookupTotalTime
		}
		qStatisticsCifsOpsRawLookupTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawLookupTotalTime)
		if qStatisticsCifsOpsRawLookupTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.lookup.total_time", qStatisticsCifsOpsRawLookupTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawOpenCount != nil {

		// query param statistics.cifs_ops_raw.open.count
		var qrStatisticsCifsOpsRawOpenCount int64

		if o.StatisticsCifsOpsRawOpenCount != nil {
			qrStatisticsCifsOpsRawOpenCount = *o.StatisticsCifsOpsRawOpenCount
		}
		qStatisticsCifsOpsRawOpenCount := swag.FormatInt64(qrStatisticsCifsOpsRawOpenCount)
		if qStatisticsCifsOpsRawOpenCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.open.count", qStatisticsCifsOpsRawOpenCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawOpenTotalTime != nil {

		// query param statistics.cifs_ops_raw.open.total_time
		var qrStatisticsCifsOpsRawOpenTotalTime int64

		if o.StatisticsCifsOpsRawOpenTotalTime != nil {
			qrStatisticsCifsOpsRawOpenTotalTime = *o.StatisticsCifsOpsRawOpenTotalTime
		}
		qStatisticsCifsOpsRawOpenTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawOpenTotalTime)
		if qStatisticsCifsOpsRawOpenTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.open.total_time", qStatisticsCifsOpsRawOpenTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadCount != nil {

		// query param statistics.cifs_ops_raw.read.count
		var qrStatisticsCifsOpsRawReadCount int64

		if o.StatisticsCifsOpsRawReadCount != nil {
			qrStatisticsCifsOpsRawReadCount = *o.StatisticsCifsOpsRawReadCount
		}
		qStatisticsCifsOpsRawReadCount := swag.FormatInt64(qrStatisticsCifsOpsRawReadCount)
		if qStatisticsCifsOpsRawReadCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.count", qStatisticsCifsOpsRawReadCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadTotalTime != nil {

		// query param statistics.cifs_ops_raw.read.total_time
		var qrStatisticsCifsOpsRawReadTotalTime int64

		if o.StatisticsCifsOpsRawReadTotalTime != nil {
			qrStatisticsCifsOpsRawReadTotalTime = *o.StatisticsCifsOpsRawReadTotalTime
		}
		qStatisticsCifsOpsRawReadTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawReadTotalTime)
		if qStatisticsCifsOpsRawReadTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.total_time", qStatisticsCifsOpsRawReadTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts != nil {

		// query param statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_counts
		var qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts int64

		if o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts != nil {
			qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts = *o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts
		}
		qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts := swag.FormatInt64(qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts)
		if qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_counts", qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels != nil {

		// query param statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_labels
		var qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels string

		if o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels != nil {
			qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels = *o.StatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels
		}
		qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels := qrStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels
		if qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.volume_protocol_latency_histogram_labels", qStatisticsCifsOpsRawReadVolumeProtocolLatencyHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts != nil {

		// query param statistics.cifs_ops_raw.read.volume_protocol_size_histogram_counts
		var qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts int64

		if o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts != nil {
			qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts = *o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts
		}
		qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts := swag.FormatInt64(qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts)
		if qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.volume_protocol_size_histogram_counts", qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels != nil {

		// query param statistics.cifs_ops_raw.read.volume_protocol_size_histogram_labels
		var qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels string

		if o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels != nil {
			qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels = *o.StatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels
		}
		qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels := qrStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels
		if qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.read.volume_protocol_size_histogram_labels", qStatisticsCifsOpsRawReadVolumeProtocolSizeHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReaddirCount != nil {

		// query param statistics.cifs_ops_raw.readdir.count
		var qrStatisticsCifsOpsRawReaddirCount int64

		if o.StatisticsCifsOpsRawReaddirCount != nil {
			qrStatisticsCifsOpsRawReaddirCount = *o.StatisticsCifsOpsRawReaddirCount
		}
		qStatisticsCifsOpsRawReaddirCount := swag.FormatInt64(qrStatisticsCifsOpsRawReaddirCount)
		if qStatisticsCifsOpsRawReaddirCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.readdir.count", qStatisticsCifsOpsRawReaddirCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReaddirTotalTime != nil {

		// query param statistics.cifs_ops_raw.readdir.total_time
		var qrStatisticsCifsOpsRawReaddirTotalTime int64

		if o.StatisticsCifsOpsRawReaddirTotalTime != nil {
			qrStatisticsCifsOpsRawReaddirTotalTime = *o.StatisticsCifsOpsRawReaddirTotalTime
		}
		qStatisticsCifsOpsRawReaddirTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawReaddirTotalTime)
		if qStatisticsCifsOpsRawReaddirTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.readdir.total_time", qStatisticsCifsOpsRawReaddirTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadlinkCount != nil {

		// query param statistics.cifs_ops_raw.readlink.count
		var qrStatisticsCifsOpsRawReadlinkCount int64

		if o.StatisticsCifsOpsRawReadlinkCount != nil {
			qrStatisticsCifsOpsRawReadlinkCount = *o.StatisticsCifsOpsRawReadlinkCount
		}
		qStatisticsCifsOpsRawReadlinkCount := swag.FormatInt64(qrStatisticsCifsOpsRawReadlinkCount)
		if qStatisticsCifsOpsRawReadlinkCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.readlink.count", qStatisticsCifsOpsRawReadlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawReadlinkTotalTime != nil {

		// query param statistics.cifs_ops_raw.readlink.total_time
		var qrStatisticsCifsOpsRawReadlinkTotalTime int64

		if o.StatisticsCifsOpsRawReadlinkTotalTime != nil {
			qrStatisticsCifsOpsRawReadlinkTotalTime = *o.StatisticsCifsOpsRawReadlinkTotalTime
		}
		qStatisticsCifsOpsRawReadlinkTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawReadlinkTotalTime)
		if qStatisticsCifsOpsRawReadlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.readlink.total_time", qStatisticsCifsOpsRawReadlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawRenameCount != nil {

		// query param statistics.cifs_ops_raw.rename.count
		var qrStatisticsCifsOpsRawRenameCount int64

		if o.StatisticsCifsOpsRawRenameCount != nil {
			qrStatisticsCifsOpsRawRenameCount = *o.StatisticsCifsOpsRawRenameCount
		}
		qStatisticsCifsOpsRawRenameCount := swag.FormatInt64(qrStatisticsCifsOpsRawRenameCount)
		if qStatisticsCifsOpsRawRenameCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.rename.count", qStatisticsCifsOpsRawRenameCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawRenameTotalTime != nil {

		// query param statistics.cifs_ops_raw.rename.total_time
		var qrStatisticsCifsOpsRawRenameTotalTime int64

		if o.StatisticsCifsOpsRawRenameTotalTime != nil {
			qrStatisticsCifsOpsRawRenameTotalTime = *o.StatisticsCifsOpsRawRenameTotalTime
		}
		qStatisticsCifsOpsRawRenameTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawRenameTotalTime)
		if qStatisticsCifsOpsRawRenameTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.rename.total_time", qStatisticsCifsOpsRawRenameTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawSetattrCount != nil {

		// query param statistics.cifs_ops_raw.setattr.count
		var qrStatisticsCifsOpsRawSetattrCount int64

		if o.StatisticsCifsOpsRawSetattrCount != nil {
			qrStatisticsCifsOpsRawSetattrCount = *o.StatisticsCifsOpsRawSetattrCount
		}
		qStatisticsCifsOpsRawSetattrCount := swag.FormatInt64(qrStatisticsCifsOpsRawSetattrCount)
		if qStatisticsCifsOpsRawSetattrCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.setattr.count", qStatisticsCifsOpsRawSetattrCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawSetattrTotalTime != nil {

		// query param statistics.cifs_ops_raw.setattr.total_time
		var qrStatisticsCifsOpsRawSetattrTotalTime int64

		if o.StatisticsCifsOpsRawSetattrTotalTime != nil {
			qrStatisticsCifsOpsRawSetattrTotalTime = *o.StatisticsCifsOpsRawSetattrTotalTime
		}
		qStatisticsCifsOpsRawSetattrTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawSetattrTotalTime)
		if qStatisticsCifsOpsRawSetattrTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.setattr.total_time", qStatisticsCifsOpsRawSetattrTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawUnlinkCount != nil {

		// query param statistics.cifs_ops_raw.unlink.count
		var qrStatisticsCifsOpsRawUnlinkCount int64

		if o.StatisticsCifsOpsRawUnlinkCount != nil {
			qrStatisticsCifsOpsRawUnlinkCount = *o.StatisticsCifsOpsRawUnlinkCount
		}
		qStatisticsCifsOpsRawUnlinkCount := swag.FormatInt64(qrStatisticsCifsOpsRawUnlinkCount)
		if qStatisticsCifsOpsRawUnlinkCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.unlink.count", qStatisticsCifsOpsRawUnlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawUnlinkTotalTime != nil {

		// query param statistics.cifs_ops_raw.unlink.total_time
		var qrStatisticsCifsOpsRawUnlinkTotalTime int64

		if o.StatisticsCifsOpsRawUnlinkTotalTime != nil {
			qrStatisticsCifsOpsRawUnlinkTotalTime = *o.StatisticsCifsOpsRawUnlinkTotalTime
		}
		qStatisticsCifsOpsRawUnlinkTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawUnlinkTotalTime)
		if qStatisticsCifsOpsRawUnlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.unlink.total_time", qStatisticsCifsOpsRawUnlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWatchCount != nil {

		// query param statistics.cifs_ops_raw.watch.count
		var qrStatisticsCifsOpsRawWatchCount int64

		if o.StatisticsCifsOpsRawWatchCount != nil {
			qrStatisticsCifsOpsRawWatchCount = *o.StatisticsCifsOpsRawWatchCount
		}
		qStatisticsCifsOpsRawWatchCount := swag.FormatInt64(qrStatisticsCifsOpsRawWatchCount)
		if qStatisticsCifsOpsRawWatchCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.watch.count", qStatisticsCifsOpsRawWatchCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWatchTotalTime != nil {

		// query param statistics.cifs_ops_raw.watch.total_time
		var qrStatisticsCifsOpsRawWatchTotalTime int64

		if o.StatisticsCifsOpsRawWatchTotalTime != nil {
			qrStatisticsCifsOpsRawWatchTotalTime = *o.StatisticsCifsOpsRawWatchTotalTime
		}
		qStatisticsCifsOpsRawWatchTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawWatchTotalTime)
		if qStatisticsCifsOpsRawWatchTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.watch.total_time", qStatisticsCifsOpsRawWatchTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteCount != nil {

		// query param statistics.cifs_ops_raw.write.count
		var qrStatisticsCifsOpsRawWriteCount int64

		if o.StatisticsCifsOpsRawWriteCount != nil {
			qrStatisticsCifsOpsRawWriteCount = *o.StatisticsCifsOpsRawWriteCount
		}
		qStatisticsCifsOpsRawWriteCount := swag.FormatInt64(qrStatisticsCifsOpsRawWriteCount)
		if qStatisticsCifsOpsRawWriteCount != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.count", qStatisticsCifsOpsRawWriteCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteTotalTime != nil {

		// query param statistics.cifs_ops_raw.write.total_time
		var qrStatisticsCifsOpsRawWriteTotalTime int64

		if o.StatisticsCifsOpsRawWriteTotalTime != nil {
			qrStatisticsCifsOpsRawWriteTotalTime = *o.StatisticsCifsOpsRawWriteTotalTime
		}
		qStatisticsCifsOpsRawWriteTotalTime := swag.FormatInt64(qrStatisticsCifsOpsRawWriteTotalTime)
		if qStatisticsCifsOpsRawWriteTotalTime != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.total_time", qStatisticsCifsOpsRawWriteTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts != nil {

		// query param statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_counts
		var qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts int64

		if o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts != nil {
			qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts = *o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts
		}
		qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts := swag.FormatInt64(qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts)
		if qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_counts", qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels != nil {

		// query param statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_labels
		var qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels string

		if o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels != nil {
			qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels = *o.StatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels
		}
		qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels := qrStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels
		if qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.volume_protocol_latency_histogram_labels", qStatisticsCifsOpsRawWriteVolumeProtocolLatencyHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts != nil {

		// query param statistics.cifs_ops_raw.write.volume_protocol_size_histogram_counts
		var qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts int64

		if o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts != nil {
			qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts = *o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts
		}
		qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts := swag.FormatInt64(qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts)
		if qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.volume_protocol_size_histogram_counts", qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels != nil {

		// query param statistics.cifs_ops_raw.write.volume_protocol_size_histogram_labels
		var qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels string

		if o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels != nil {
			qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels = *o.StatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels
		}
		qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels := qrStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels
		if qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.cifs_ops_raw.write.volume_protocol_size_histogram_labels", qStatisticsCifsOpsRawWriteVolumeProtocolSizeHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudIopsRawOther != nil {

		// query param statistics.cloud.iops_raw.other
		var qrStatisticsCloudIopsRawOther int64

		if o.StatisticsCloudIopsRawOther != nil {
			qrStatisticsCloudIopsRawOther = *o.StatisticsCloudIopsRawOther
		}
		qStatisticsCloudIopsRawOther := swag.FormatInt64(qrStatisticsCloudIopsRawOther)
		if qStatisticsCloudIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.cloud.iops_raw.other", qStatisticsCloudIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudIopsRawRead != nil {

		// query param statistics.cloud.iops_raw.read
		var qrStatisticsCloudIopsRawRead int64

		if o.StatisticsCloudIopsRawRead != nil {
			qrStatisticsCloudIopsRawRead = *o.StatisticsCloudIopsRawRead
		}
		qStatisticsCloudIopsRawRead := swag.FormatInt64(qrStatisticsCloudIopsRawRead)
		if qStatisticsCloudIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.cloud.iops_raw.read", qStatisticsCloudIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudIopsRawTotal != nil {

		// query param statistics.cloud.iops_raw.total
		var qrStatisticsCloudIopsRawTotal int64

		if o.StatisticsCloudIopsRawTotal != nil {
			qrStatisticsCloudIopsRawTotal = *o.StatisticsCloudIopsRawTotal
		}
		qStatisticsCloudIopsRawTotal := swag.FormatInt64(qrStatisticsCloudIopsRawTotal)
		if qStatisticsCloudIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.cloud.iops_raw.total", qStatisticsCloudIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudIopsRawWrite != nil {

		// query param statistics.cloud.iops_raw.write
		var qrStatisticsCloudIopsRawWrite int64

		if o.StatisticsCloudIopsRawWrite != nil {
			qrStatisticsCloudIopsRawWrite = *o.StatisticsCloudIopsRawWrite
		}
		qStatisticsCloudIopsRawWrite := swag.FormatInt64(qrStatisticsCloudIopsRawWrite)
		if qStatisticsCloudIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.cloud.iops_raw.write", qStatisticsCloudIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudLatencyRawOther != nil {

		// query param statistics.cloud.latency_raw.other
		var qrStatisticsCloudLatencyRawOther int64

		if o.StatisticsCloudLatencyRawOther != nil {
			qrStatisticsCloudLatencyRawOther = *o.StatisticsCloudLatencyRawOther
		}
		qStatisticsCloudLatencyRawOther := swag.FormatInt64(qrStatisticsCloudLatencyRawOther)
		if qStatisticsCloudLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.cloud.latency_raw.other", qStatisticsCloudLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudLatencyRawRead != nil {

		// query param statistics.cloud.latency_raw.read
		var qrStatisticsCloudLatencyRawRead int64

		if o.StatisticsCloudLatencyRawRead != nil {
			qrStatisticsCloudLatencyRawRead = *o.StatisticsCloudLatencyRawRead
		}
		qStatisticsCloudLatencyRawRead := swag.FormatInt64(qrStatisticsCloudLatencyRawRead)
		if qStatisticsCloudLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.cloud.latency_raw.read", qStatisticsCloudLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudLatencyRawTotal != nil {

		// query param statistics.cloud.latency_raw.total
		var qrStatisticsCloudLatencyRawTotal int64

		if o.StatisticsCloudLatencyRawTotal != nil {
			qrStatisticsCloudLatencyRawTotal = *o.StatisticsCloudLatencyRawTotal
		}
		qStatisticsCloudLatencyRawTotal := swag.FormatInt64(qrStatisticsCloudLatencyRawTotal)
		if qStatisticsCloudLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.cloud.latency_raw.total", qStatisticsCloudLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudLatencyRawWrite != nil {

		// query param statistics.cloud.latency_raw.write
		var qrStatisticsCloudLatencyRawWrite int64

		if o.StatisticsCloudLatencyRawWrite != nil {
			qrStatisticsCloudLatencyRawWrite = *o.StatisticsCloudLatencyRawWrite
		}
		qStatisticsCloudLatencyRawWrite := swag.FormatInt64(qrStatisticsCloudLatencyRawWrite)
		if qStatisticsCloudLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.cloud.latency_raw.write", qStatisticsCloudLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudStatus != nil {

		// query param statistics.cloud.status
		var qrStatisticsCloudStatus string

		if o.StatisticsCloudStatus != nil {
			qrStatisticsCloudStatus = *o.StatisticsCloudStatus
		}
		qStatisticsCloudStatus := qrStatisticsCloudStatus
		if qStatisticsCloudStatus != "" {

			if err := r.SetQueryParam("statistics.cloud.status", qStatisticsCloudStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCloudTimestamp != nil {

		// query param statistics.cloud.timestamp
		var qrStatisticsCloudTimestamp string

		if o.StatisticsCloudTimestamp != nil {
			qrStatisticsCloudTimestamp = *o.StatisticsCloudTimestamp
		}
		qStatisticsCloudTimestamp := qrStatisticsCloudTimestamp
		if qStatisticsCloudTimestamp != "" {

			if err := r.SetQueryParam("statistics.cloud.timestamp", qStatisticsCloudTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StatisticsFlexcacheRawCacheMissBlocks != nil {

		// query param statistics.flexcache_raw.cache_miss_blocks
		var qrStatisticsFlexcacheRawCacheMissBlocks int64

		if o.StatisticsFlexcacheRawCacheMissBlocks != nil {
			qrStatisticsFlexcacheRawCacheMissBlocks = *o.StatisticsFlexcacheRawCacheMissBlocks
		}
		qStatisticsFlexcacheRawCacheMissBlocks := swag.FormatInt64(qrStatisticsFlexcacheRawCacheMissBlocks)
		if qStatisticsFlexcacheRawCacheMissBlocks != "" {

			if err := r.SetQueryParam("statistics.flexcache_raw.cache_miss_blocks", qStatisticsFlexcacheRawCacheMissBlocks); err != nil {
				return err
			}
		}
	}

	if o.StatisticsFlexcacheRawClientRequestedBlocks != nil {

		// query param statistics.flexcache_raw.client_requested_blocks
		var qrStatisticsFlexcacheRawClientRequestedBlocks int64

		if o.StatisticsFlexcacheRawClientRequestedBlocks != nil {
			qrStatisticsFlexcacheRawClientRequestedBlocks = *o.StatisticsFlexcacheRawClientRequestedBlocks
		}
		qStatisticsFlexcacheRawClientRequestedBlocks := swag.FormatInt64(qrStatisticsFlexcacheRawClientRequestedBlocks)
		if qStatisticsFlexcacheRawClientRequestedBlocks != "" {

			if err := r.SetQueryParam("statistics.flexcache_raw.client_requested_blocks", qStatisticsFlexcacheRawClientRequestedBlocks); err != nil {
				return err
			}
		}
	}

	if o.StatisticsFlexcacheRawStatus != nil {

		// query param statistics.flexcache_raw.status
		var qrStatisticsFlexcacheRawStatus string

		if o.StatisticsFlexcacheRawStatus != nil {
			qrStatisticsFlexcacheRawStatus = *o.StatisticsFlexcacheRawStatus
		}
		qStatisticsFlexcacheRawStatus := qrStatisticsFlexcacheRawStatus
		if qStatisticsFlexcacheRawStatus != "" {

			if err := r.SetQueryParam("statistics.flexcache_raw.status", qStatisticsFlexcacheRawStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsFlexcacheRawTimestamp != nil {

		// query param statistics.flexcache_raw.timestamp
		var qrStatisticsFlexcacheRawTimestamp string

		if o.StatisticsFlexcacheRawTimestamp != nil {
			qrStatisticsFlexcacheRawTimestamp = *o.StatisticsFlexcacheRawTimestamp
		}
		qStatisticsFlexcacheRawTimestamp := qrStatisticsFlexcacheRawTimestamp
		if qStatisticsFlexcacheRawTimestamp != "" {

			if err := r.SetQueryParam("statistics.flexcache_raw.timestamp", qStatisticsFlexcacheRawTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawAccessCount != nil {

		// query param statistics.nfs_ops_raw.access.count
		var qrStatisticsNfsOpsRawAccessCount int64

		if o.StatisticsNfsOpsRawAccessCount != nil {
			qrStatisticsNfsOpsRawAccessCount = *o.StatisticsNfsOpsRawAccessCount
		}
		qStatisticsNfsOpsRawAccessCount := swag.FormatInt64(qrStatisticsNfsOpsRawAccessCount)
		if qStatisticsNfsOpsRawAccessCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.access.count", qStatisticsNfsOpsRawAccessCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawAccessTotalTime != nil {

		// query param statistics.nfs_ops_raw.access.total_time
		var qrStatisticsNfsOpsRawAccessTotalTime int64

		if o.StatisticsNfsOpsRawAccessTotalTime != nil {
			qrStatisticsNfsOpsRawAccessTotalTime = *o.StatisticsNfsOpsRawAccessTotalTime
		}
		qStatisticsNfsOpsRawAccessTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawAccessTotalTime)
		if qStatisticsNfsOpsRawAccessTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.access.total_time", qStatisticsNfsOpsRawAccessTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawAuditCount != nil {

		// query param statistics.nfs_ops_raw.audit.count
		var qrStatisticsNfsOpsRawAuditCount int64

		if o.StatisticsNfsOpsRawAuditCount != nil {
			qrStatisticsNfsOpsRawAuditCount = *o.StatisticsNfsOpsRawAuditCount
		}
		qStatisticsNfsOpsRawAuditCount := swag.FormatInt64(qrStatisticsNfsOpsRawAuditCount)
		if qStatisticsNfsOpsRawAuditCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.audit.count", qStatisticsNfsOpsRawAuditCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawAuditTotalTime != nil {

		// query param statistics.nfs_ops_raw.audit.total_time
		var qrStatisticsNfsOpsRawAuditTotalTime int64

		if o.StatisticsNfsOpsRawAuditTotalTime != nil {
			qrStatisticsNfsOpsRawAuditTotalTime = *o.StatisticsNfsOpsRawAuditTotalTime
		}
		qStatisticsNfsOpsRawAuditTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawAuditTotalTime)
		if qStatisticsNfsOpsRawAuditTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.audit.total_time", qStatisticsNfsOpsRawAuditTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateDirCount != nil {

		// query param statistics.nfs_ops_raw.create.dir.count
		var qrStatisticsNfsOpsRawCreateDirCount int64

		if o.StatisticsNfsOpsRawCreateDirCount != nil {
			qrStatisticsNfsOpsRawCreateDirCount = *o.StatisticsNfsOpsRawCreateDirCount
		}
		qStatisticsNfsOpsRawCreateDirCount := swag.FormatInt64(qrStatisticsNfsOpsRawCreateDirCount)
		if qStatisticsNfsOpsRawCreateDirCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.dir.count", qStatisticsNfsOpsRawCreateDirCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateDirTotalTime != nil {

		// query param statistics.nfs_ops_raw.create.dir.total_time
		var qrStatisticsNfsOpsRawCreateDirTotalTime int64

		if o.StatisticsNfsOpsRawCreateDirTotalTime != nil {
			qrStatisticsNfsOpsRawCreateDirTotalTime = *o.StatisticsNfsOpsRawCreateDirTotalTime
		}
		qStatisticsNfsOpsRawCreateDirTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawCreateDirTotalTime)
		if qStatisticsNfsOpsRawCreateDirTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.dir.total_time", qStatisticsNfsOpsRawCreateDirTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateFileCount != nil {

		// query param statistics.nfs_ops_raw.create.file.count
		var qrStatisticsNfsOpsRawCreateFileCount int64

		if o.StatisticsNfsOpsRawCreateFileCount != nil {
			qrStatisticsNfsOpsRawCreateFileCount = *o.StatisticsNfsOpsRawCreateFileCount
		}
		qStatisticsNfsOpsRawCreateFileCount := swag.FormatInt64(qrStatisticsNfsOpsRawCreateFileCount)
		if qStatisticsNfsOpsRawCreateFileCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.file.count", qStatisticsNfsOpsRawCreateFileCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateFileTotalTime != nil {

		// query param statistics.nfs_ops_raw.create.file.total_time
		var qrStatisticsNfsOpsRawCreateFileTotalTime int64

		if o.StatisticsNfsOpsRawCreateFileTotalTime != nil {
			qrStatisticsNfsOpsRawCreateFileTotalTime = *o.StatisticsNfsOpsRawCreateFileTotalTime
		}
		qStatisticsNfsOpsRawCreateFileTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawCreateFileTotalTime)
		if qStatisticsNfsOpsRawCreateFileTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.file.total_time", qStatisticsNfsOpsRawCreateFileTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateOtherCount != nil {

		// query param statistics.nfs_ops_raw.create.other.count
		var qrStatisticsNfsOpsRawCreateOtherCount int64

		if o.StatisticsNfsOpsRawCreateOtherCount != nil {
			qrStatisticsNfsOpsRawCreateOtherCount = *o.StatisticsNfsOpsRawCreateOtherCount
		}
		qStatisticsNfsOpsRawCreateOtherCount := swag.FormatInt64(qrStatisticsNfsOpsRawCreateOtherCount)
		if qStatisticsNfsOpsRawCreateOtherCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.other.count", qStatisticsNfsOpsRawCreateOtherCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateOtherTotalTime != nil {

		// query param statistics.nfs_ops_raw.create.other.total_time
		var qrStatisticsNfsOpsRawCreateOtherTotalTime int64

		if o.StatisticsNfsOpsRawCreateOtherTotalTime != nil {
			qrStatisticsNfsOpsRawCreateOtherTotalTime = *o.StatisticsNfsOpsRawCreateOtherTotalTime
		}
		qStatisticsNfsOpsRawCreateOtherTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawCreateOtherTotalTime)
		if qStatisticsNfsOpsRawCreateOtherTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.other.total_time", qStatisticsNfsOpsRawCreateOtherTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateSymlinkCount != nil {

		// query param statistics.nfs_ops_raw.create.symlink.count
		var qrStatisticsNfsOpsRawCreateSymlinkCount int64

		if o.StatisticsNfsOpsRawCreateSymlinkCount != nil {
			qrStatisticsNfsOpsRawCreateSymlinkCount = *o.StatisticsNfsOpsRawCreateSymlinkCount
		}
		qStatisticsNfsOpsRawCreateSymlinkCount := swag.FormatInt64(qrStatisticsNfsOpsRawCreateSymlinkCount)
		if qStatisticsNfsOpsRawCreateSymlinkCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.symlink.count", qStatisticsNfsOpsRawCreateSymlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawCreateSymlinkTotalTime != nil {

		// query param statistics.nfs_ops_raw.create.symlink.total_time
		var qrStatisticsNfsOpsRawCreateSymlinkTotalTime int64

		if o.StatisticsNfsOpsRawCreateSymlinkTotalTime != nil {
			qrStatisticsNfsOpsRawCreateSymlinkTotalTime = *o.StatisticsNfsOpsRawCreateSymlinkTotalTime
		}
		qStatisticsNfsOpsRawCreateSymlinkTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawCreateSymlinkTotalTime)
		if qStatisticsNfsOpsRawCreateSymlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.create.symlink.total_time", qStatisticsNfsOpsRawCreateSymlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawGetattrCount != nil {

		// query param statistics.nfs_ops_raw.getattr.count
		var qrStatisticsNfsOpsRawGetattrCount int64

		if o.StatisticsNfsOpsRawGetattrCount != nil {
			qrStatisticsNfsOpsRawGetattrCount = *o.StatisticsNfsOpsRawGetattrCount
		}
		qStatisticsNfsOpsRawGetattrCount := swag.FormatInt64(qrStatisticsNfsOpsRawGetattrCount)
		if qStatisticsNfsOpsRawGetattrCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.getattr.count", qStatisticsNfsOpsRawGetattrCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawGetattrTotalTime != nil {

		// query param statistics.nfs_ops_raw.getattr.total_time
		var qrStatisticsNfsOpsRawGetattrTotalTime int64

		if o.StatisticsNfsOpsRawGetattrTotalTime != nil {
			qrStatisticsNfsOpsRawGetattrTotalTime = *o.StatisticsNfsOpsRawGetattrTotalTime
		}
		qStatisticsNfsOpsRawGetattrTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawGetattrTotalTime)
		if qStatisticsNfsOpsRawGetattrTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.getattr.total_time", qStatisticsNfsOpsRawGetattrTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLinkCount != nil {

		// query param statistics.nfs_ops_raw.link.count
		var qrStatisticsNfsOpsRawLinkCount int64

		if o.StatisticsNfsOpsRawLinkCount != nil {
			qrStatisticsNfsOpsRawLinkCount = *o.StatisticsNfsOpsRawLinkCount
		}
		qStatisticsNfsOpsRawLinkCount := swag.FormatInt64(qrStatisticsNfsOpsRawLinkCount)
		if qStatisticsNfsOpsRawLinkCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.link.count", qStatisticsNfsOpsRawLinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLinkTotalTime != nil {

		// query param statistics.nfs_ops_raw.link.total_time
		var qrStatisticsNfsOpsRawLinkTotalTime int64

		if o.StatisticsNfsOpsRawLinkTotalTime != nil {
			qrStatisticsNfsOpsRawLinkTotalTime = *o.StatisticsNfsOpsRawLinkTotalTime
		}
		qStatisticsNfsOpsRawLinkTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawLinkTotalTime)
		if qStatisticsNfsOpsRawLinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.link.total_time", qStatisticsNfsOpsRawLinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLockCount != nil {

		// query param statistics.nfs_ops_raw.lock.count
		var qrStatisticsNfsOpsRawLockCount int64

		if o.StatisticsNfsOpsRawLockCount != nil {
			qrStatisticsNfsOpsRawLockCount = *o.StatisticsNfsOpsRawLockCount
		}
		qStatisticsNfsOpsRawLockCount := swag.FormatInt64(qrStatisticsNfsOpsRawLockCount)
		if qStatisticsNfsOpsRawLockCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.lock.count", qStatisticsNfsOpsRawLockCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLockTotalTime != nil {

		// query param statistics.nfs_ops_raw.lock.total_time
		var qrStatisticsNfsOpsRawLockTotalTime int64

		if o.StatisticsNfsOpsRawLockTotalTime != nil {
			qrStatisticsNfsOpsRawLockTotalTime = *o.StatisticsNfsOpsRawLockTotalTime
		}
		qStatisticsNfsOpsRawLockTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawLockTotalTime)
		if qStatisticsNfsOpsRawLockTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.lock.total_time", qStatisticsNfsOpsRawLockTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLookupCount != nil {

		// query param statistics.nfs_ops_raw.lookup.count
		var qrStatisticsNfsOpsRawLookupCount int64

		if o.StatisticsNfsOpsRawLookupCount != nil {
			qrStatisticsNfsOpsRawLookupCount = *o.StatisticsNfsOpsRawLookupCount
		}
		qStatisticsNfsOpsRawLookupCount := swag.FormatInt64(qrStatisticsNfsOpsRawLookupCount)
		if qStatisticsNfsOpsRawLookupCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.lookup.count", qStatisticsNfsOpsRawLookupCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawLookupTotalTime != nil {

		// query param statistics.nfs_ops_raw.lookup.total_time
		var qrStatisticsNfsOpsRawLookupTotalTime int64

		if o.StatisticsNfsOpsRawLookupTotalTime != nil {
			qrStatisticsNfsOpsRawLookupTotalTime = *o.StatisticsNfsOpsRawLookupTotalTime
		}
		qStatisticsNfsOpsRawLookupTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawLookupTotalTime)
		if qStatisticsNfsOpsRawLookupTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.lookup.total_time", qStatisticsNfsOpsRawLookupTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawOpenCount != nil {

		// query param statistics.nfs_ops_raw.open.count
		var qrStatisticsNfsOpsRawOpenCount int64

		if o.StatisticsNfsOpsRawOpenCount != nil {
			qrStatisticsNfsOpsRawOpenCount = *o.StatisticsNfsOpsRawOpenCount
		}
		qStatisticsNfsOpsRawOpenCount := swag.FormatInt64(qrStatisticsNfsOpsRawOpenCount)
		if qStatisticsNfsOpsRawOpenCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.open.count", qStatisticsNfsOpsRawOpenCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawOpenTotalTime != nil {

		// query param statistics.nfs_ops_raw.open.total_time
		var qrStatisticsNfsOpsRawOpenTotalTime int64

		if o.StatisticsNfsOpsRawOpenTotalTime != nil {
			qrStatisticsNfsOpsRawOpenTotalTime = *o.StatisticsNfsOpsRawOpenTotalTime
		}
		qStatisticsNfsOpsRawOpenTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawOpenTotalTime)
		if qStatisticsNfsOpsRawOpenTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.open.total_time", qStatisticsNfsOpsRawOpenTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadCount != nil {

		// query param statistics.nfs_ops_raw.read.count
		var qrStatisticsNfsOpsRawReadCount int64

		if o.StatisticsNfsOpsRawReadCount != nil {
			qrStatisticsNfsOpsRawReadCount = *o.StatisticsNfsOpsRawReadCount
		}
		qStatisticsNfsOpsRawReadCount := swag.FormatInt64(qrStatisticsNfsOpsRawReadCount)
		if qStatisticsNfsOpsRawReadCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.count", qStatisticsNfsOpsRawReadCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadTotalTime != nil {

		// query param statistics.nfs_ops_raw.read.total_time
		var qrStatisticsNfsOpsRawReadTotalTime int64

		if o.StatisticsNfsOpsRawReadTotalTime != nil {
			qrStatisticsNfsOpsRawReadTotalTime = *o.StatisticsNfsOpsRawReadTotalTime
		}
		qStatisticsNfsOpsRawReadTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawReadTotalTime)
		if qStatisticsNfsOpsRawReadTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.total_time", qStatisticsNfsOpsRawReadTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts != nil {

		// query param statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_counts
		var qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts int64

		if o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts != nil {
			qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts = *o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts
		}
		qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts := swag.FormatInt64(qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts)
		if qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_counts", qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels != nil {

		// query param statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_labels
		var qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels string

		if o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels != nil {
			qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels = *o.StatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels
		}
		qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels := qrStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels
		if qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.volume_protocol_latency_histogram_labels", qStatisticsNfsOpsRawReadVolumeProtocolLatencyHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts != nil {

		// query param statistics.nfs_ops_raw.read.volume_protocol_size_histogram_counts
		var qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts int64

		if o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts != nil {
			qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts = *o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts
		}
		qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts := swag.FormatInt64(qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts)
		if qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.volume_protocol_size_histogram_counts", qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels != nil {

		// query param statistics.nfs_ops_raw.read.volume_protocol_size_histogram_labels
		var qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels string

		if o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels != nil {
			qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels = *o.StatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels
		}
		qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels := qrStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels
		if qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.read.volume_protocol_size_histogram_labels", qStatisticsNfsOpsRawReadVolumeProtocolSizeHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReaddirCount != nil {

		// query param statistics.nfs_ops_raw.readdir.count
		var qrStatisticsNfsOpsRawReaddirCount int64

		if o.StatisticsNfsOpsRawReaddirCount != nil {
			qrStatisticsNfsOpsRawReaddirCount = *o.StatisticsNfsOpsRawReaddirCount
		}
		qStatisticsNfsOpsRawReaddirCount := swag.FormatInt64(qrStatisticsNfsOpsRawReaddirCount)
		if qStatisticsNfsOpsRawReaddirCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.readdir.count", qStatisticsNfsOpsRawReaddirCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReaddirTotalTime != nil {

		// query param statistics.nfs_ops_raw.readdir.total_time
		var qrStatisticsNfsOpsRawReaddirTotalTime int64

		if o.StatisticsNfsOpsRawReaddirTotalTime != nil {
			qrStatisticsNfsOpsRawReaddirTotalTime = *o.StatisticsNfsOpsRawReaddirTotalTime
		}
		qStatisticsNfsOpsRawReaddirTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawReaddirTotalTime)
		if qStatisticsNfsOpsRawReaddirTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.readdir.total_time", qStatisticsNfsOpsRawReaddirTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadlinkCount != nil {

		// query param statistics.nfs_ops_raw.readlink.count
		var qrStatisticsNfsOpsRawReadlinkCount int64

		if o.StatisticsNfsOpsRawReadlinkCount != nil {
			qrStatisticsNfsOpsRawReadlinkCount = *o.StatisticsNfsOpsRawReadlinkCount
		}
		qStatisticsNfsOpsRawReadlinkCount := swag.FormatInt64(qrStatisticsNfsOpsRawReadlinkCount)
		if qStatisticsNfsOpsRawReadlinkCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.readlink.count", qStatisticsNfsOpsRawReadlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawReadlinkTotalTime != nil {

		// query param statistics.nfs_ops_raw.readlink.total_time
		var qrStatisticsNfsOpsRawReadlinkTotalTime int64

		if o.StatisticsNfsOpsRawReadlinkTotalTime != nil {
			qrStatisticsNfsOpsRawReadlinkTotalTime = *o.StatisticsNfsOpsRawReadlinkTotalTime
		}
		qStatisticsNfsOpsRawReadlinkTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawReadlinkTotalTime)
		if qStatisticsNfsOpsRawReadlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.readlink.total_time", qStatisticsNfsOpsRawReadlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawRenameCount != nil {

		// query param statistics.nfs_ops_raw.rename.count
		var qrStatisticsNfsOpsRawRenameCount int64

		if o.StatisticsNfsOpsRawRenameCount != nil {
			qrStatisticsNfsOpsRawRenameCount = *o.StatisticsNfsOpsRawRenameCount
		}
		qStatisticsNfsOpsRawRenameCount := swag.FormatInt64(qrStatisticsNfsOpsRawRenameCount)
		if qStatisticsNfsOpsRawRenameCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.rename.count", qStatisticsNfsOpsRawRenameCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawRenameTotalTime != nil {

		// query param statistics.nfs_ops_raw.rename.total_time
		var qrStatisticsNfsOpsRawRenameTotalTime int64

		if o.StatisticsNfsOpsRawRenameTotalTime != nil {
			qrStatisticsNfsOpsRawRenameTotalTime = *o.StatisticsNfsOpsRawRenameTotalTime
		}
		qStatisticsNfsOpsRawRenameTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawRenameTotalTime)
		if qStatisticsNfsOpsRawRenameTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.rename.total_time", qStatisticsNfsOpsRawRenameTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawSetattrCount != nil {

		// query param statistics.nfs_ops_raw.setattr.count
		var qrStatisticsNfsOpsRawSetattrCount int64

		if o.StatisticsNfsOpsRawSetattrCount != nil {
			qrStatisticsNfsOpsRawSetattrCount = *o.StatisticsNfsOpsRawSetattrCount
		}
		qStatisticsNfsOpsRawSetattrCount := swag.FormatInt64(qrStatisticsNfsOpsRawSetattrCount)
		if qStatisticsNfsOpsRawSetattrCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.setattr.count", qStatisticsNfsOpsRawSetattrCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawSetattrTotalTime != nil {

		// query param statistics.nfs_ops_raw.setattr.total_time
		var qrStatisticsNfsOpsRawSetattrTotalTime int64

		if o.StatisticsNfsOpsRawSetattrTotalTime != nil {
			qrStatisticsNfsOpsRawSetattrTotalTime = *o.StatisticsNfsOpsRawSetattrTotalTime
		}
		qStatisticsNfsOpsRawSetattrTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawSetattrTotalTime)
		if qStatisticsNfsOpsRawSetattrTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.setattr.total_time", qStatisticsNfsOpsRawSetattrTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawUnlinkCount != nil {

		// query param statistics.nfs_ops_raw.unlink.count
		var qrStatisticsNfsOpsRawUnlinkCount int64

		if o.StatisticsNfsOpsRawUnlinkCount != nil {
			qrStatisticsNfsOpsRawUnlinkCount = *o.StatisticsNfsOpsRawUnlinkCount
		}
		qStatisticsNfsOpsRawUnlinkCount := swag.FormatInt64(qrStatisticsNfsOpsRawUnlinkCount)
		if qStatisticsNfsOpsRawUnlinkCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.unlink.count", qStatisticsNfsOpsRawUnlinkCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawUnlinkTotalTime != nil {

		// query param statistics.nfs_ops_raw.unlink.total_time
		var qrStatisticsNfsOpsRawUnlinkTotalTime int64

		if o.StatisticsNfsOpsRawUnlinkTotalTime != nil {
			qrStatisticsNfsOpsRawUnlinkTotalTime = *o.StatisticsNfsOpsRawUnlinkTotalTime
		}
		qStatisticsNfsOpsRawUnlinkTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawUnlinkTotalTime)
		if qStatisticsNfsOpsRawUnlinkTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.unlink.total_time", qStatisticsNfsOpsRawUnlinkTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWatchCount != nil {

		// query param statistics.nfs_ops_raw.watch.count
		var qrStatisticsNfsOpsRawWatchCount int64

		if o.StatisticsNfsOpsRawWatchCount != nil {
			qrStatisticsNfsOpsRawWatchCount = *o.StatisticsNfsOpsRawWatchCount
		}
		qStatisticsNfsOpsRawWatchCount := swag.FormatInt64(qrStatisticsNfsOpsRawWatchCount)
		if qStatisticsNfsOpsRawWatchCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.watch.count", qStatisticsNfsOpsRawWatchCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWatchTotalTime != nil {

		// query param statistics.nfs_ops_raw.watch.total_time
		var qrStatisticsNfsOpsRawWatchTotalTime int64

		if o.StatisticsNfsOpsRawWatchTotalTime != nil {
			qrStatisticsNfsOpsRawWatchTotalTime = *o.StatisticsNfsOpsRawWatchTotalTime
		}
		qStatisticsNfsOpsRawWatchTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawWatchTotalTime)
		if qStatisticsNfsOpsRawWatchTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.watch.total_time", qStatisticsNfsOpsRawWatchTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteCount != nil {

		// query param statistics.nfs_ops_raw.write.count
		var qrStatisticsNfsOpsRawWriteCount int64

		if o.StatisticsNfsOpsRawWriteCount != nil {
			qrStatisticsNfsOpsRawWriteCount = *o.StatisticsNfsOpsRawWriteCount
		}
		qStatisticsNfsOpsRawWriteCount := swag.FormatInt64(qrStatisticsNfsOpsRawWriteCount)
		if qStatisticsNfsOpsRawWriteCount != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.count", qStatisticsNfsOpsRawWriteCount); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteTotalTime != nil {

		// query param statistics.nfs_ops_raw.write.total_time
		var qrStatisticsNfsOpsRawWriteTotalTime int64

		if o.StatisticsNfsOpsRawWriteTotalTime != nil {
			qrStatisticsNfsOpsRawWriteTotalTime = *o.StatisticsNfsOpsRawWriteTotalTime
		}
		qStatisticsNfsOpsRawWriteTotalTime := swag.FormatInt64(qrStatisticsNfsOpsRawWriteTotalTime)
		if qStatisticsNfsOpsRawWriteTotalTime != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.total_time", qStatisticsNfsOpsRawWriteTotalTime); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts != nil {

		// query param statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_counts
		var qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts int64

		if o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts != nil {
			qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts = *o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts
		}
		qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts := swag.FormatInt64(qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts)
		if qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_counts", qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels != nil {

		// query param statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_labels
		var qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels string

		if o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels != nil {
			qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels = *o.StatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels
		}
		qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels := qrStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels
		if qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.volume_protocol_latency_histogram_labels", qStatisticsNfsOpsRawWriteVolumeProtocolLatencyHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts != nil {

		// query param statistics.nfs_ops_raw.write.volume_protocol_size_histogram_counts
		var qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts int64

		if o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts != nil {
			qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts = *o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts
		}
		qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts := swag.FormatInt64(qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts)
		if qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.volume_protocol_size_histogram_counts", qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramCounts); err != nil {
				return err
			}
		}
	}

	if o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels != nil {

		// query param statistics.nfs_ops_raw.write.volume_protocol_size_histogram_labels
		var qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels string

		if o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels != nil {
			qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels = *o.StatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels
		}
		qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels := qrStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels
		if qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels != "" {

			if err := r.SetQueryParam("statistics.nfs_ops_raw.write.volume_protocol_size_histogram_labels", qStatisticsNfsOpsRawWriteVolumeProtocolSizeHistogramLabels); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawOther != nil {

		// query param statistics.throughput_raw.other
		var qrStatisticsThroughputRawOther int64

		if o.StatisticsThroughputRawOther != nil {
			qrStatisticsThroughputRawOther = *o.StatisticsThroughputRawOther
		}
		qStatisticsThroughputRawOther := swag.FormatInt64(qrStatisticsThroughputRawOther)
		if qStatisticsThroughputRawOther != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.other", qStatisticsThroughputRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.Style != nil {

		// query param style
		var qrStyle string

		if o.Style != nil {
			qrStyle = *o.Style
		}
		qStyle := qrStyle
		if qStyle != "" {

			if err := r.SetQueryParam("style", qStyle); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TieringMinCoolingDays != nil {

		// query param tiering.min_cooling_days
		var qrTieringMinCoolingDays int64

		if o.TieringMinCoolingDays != nil {
			qrTieringMinCoolingDays = *o.TieringMinCoolingDays
		}
		qTieringMinCoolingDays := swag.FormatInt64(qrTieringMinCoolingDays)
		if qTieringMinCoolingDays != "" {

			if err := r.SetQueryParam("tiering.min_cooling_days", qTieringMinCoolingDays); err != nil {
				return err
			}
		}
	}

	if o.TieringObjectTags != nil {

		// query param tiering.object_tags
		var qrTieringObjectTags string

		if o.TieringObjectTags != nil {
			qrTieringObjectTags = *o.TieringObjectTags
		}
		qTieringObjectTags := qrTieringObjectTags
		if qTieringObjectTags != "" {

			if err := r.SetQueryParam("tiering.object_tags", qTieringObjectTags); err != nil {
				return err
			}
		}
	}

	if o.TieringPolicy != nil {

		// query param tiering.policy
		var qrTieringPolicy string

		if o.TieringPolicy != nil {
			qrTieringPolicy = *o.TieringPolicy
		}
		qTieringPolicy := qrTieringPolicy
		if qTieringPolicy != "" {

			if err := r.SetQueryParam("tiering.policy", qTieringPolicy); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVolumeCollectionGet binds the parameter fields
func (o *VolumeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamVolumeCollectionGet binds the parameter order_by
func (o *VolumeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
