// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeDeleteCollectionReader is a Reader for the VolumeDeleteCollection structure.
type VolumeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewVolumeDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeDeleteCollectionOK creates a VolumeDeleteCollectionOK with default headers values
func NewVolumeDeleteCollectionOK() *VolumeDeleteCollectionOK {
	return &VolumeDeleteCollectionOK{}
}

/*
VolumeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VolumeDeleteCollectionOK struct {
	Payload *models.VolumeJobLinkResponse
}

// IsSuccess returns true when this volume delete collection o k response has a 2xx status code
func (o *VolumeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume delete collection o k response has a 3xx status code
func (o *VolumeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete collection o k response has a 4xx status code
func (o *VolumeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume delete collection o k response has a 5xx status code
func (o *VolumeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume delete collection o k response a status code equal to that given
func (o *VolumeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume delete collection o k response
func (o *VolumeDeleteCollectionOK) Code() int {
	return 200
}

func (o *VolumeDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volumeDeleteCollectionOK %s", 200, payload)
}

func (o *VolumeDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volumeDeleteCollectionOK %s", 200, payload)
}

func (o *VolumeDeleteCollectionOK) GetPayload() *models.VolumeJobLinkResponse {
	return o.Payload
}

func (o *VolumeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeDeleteCollectionAccepted creates a VolumeDeleteCollectionAccepted with default headers values
func NewVolumeDeleteCollectionAccepted() *VolumeDeleteCollectionAccepted {
	return &VolumeDeleteCollectionAccepted{}
}

/*
VolumeDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type VolumeDeleteCollectionAccepted struct {
	Payload *models.VolumeJobLinkResponse
}

// IsSuccess returns true when this volume delete collection accepted response has a 2xx status code
func (o *VolumeDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume delete collection accepted response has a 3xx status code
func (o *VolumeDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete collection accepted response has a 4xx status code
func (o *VolumeDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume delete collection accepted response has a 5xx status code
func (o *VolumeDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this volume delete collection accepted response a status code equal to that given
func (o *VolumeDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the volume delete collection accepted response
func (o *VolumeDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *VolumeDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volumeDeleteCollectionAccepted %s", 202, payload)
}

func (o *VolumeDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volumeDeleteCollectionAccepted %s", 202, payload)
}

func (o *VolumeDeleteCollectionAccepted) GetPayload() *models.VolumeJobLinkResponse {
	return o.Payload
}

func (o *VolumeDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeDeleteCollectionDefault creates a VolumeDeleteCollectionDefault with default headers values
func NewVolumeDeleteCollectionDefault(code int) *VolumeDeleteCollectionDefault {
	return &VolumeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	VolumeDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 460770 | \[Job \"jobid\"\] Job failed. |
| 524615 | Failed to delete volume because it has one or more clones. |
| 917531 | Cannot delete the root volume because the SVM contains other volumes. |
| 918667 | Volume \"name\" in SVM \"svm.name\" cannot be taken offline because it is configured to hold audit logs. |
| 918693 | Volume \"name\" in SVM \"svm.name\" cannot be taken offline because it is configured to hold audit logs. |
| 918701 | The specified operation on the volume endpoint is not supported on this platform. |
| 13107349 | Operation is only supported on flexible volumes and FlexGroup volumes. |
| 65537463 | Volume encryption keys (VEK) cannot be created or deleted for data Vserver \\\"{0}\\\". External key management has been configured for data Vserver \\\"{0}\\\" but ONTAP is not able to encrypt or decrypt with the key manager. Resolve the external key manager key issues at the key manager's portal before creating any new encrypted volumes. |
| 65537529 | Encrypted volumes cannot be created or deleted for Vserver \\\"{0}\\\" as a rekey operation for the vserver is in progress. Try creating the encrypted volume again after some time. If the problem persists, run the rekey operation again after some time. |
| 65537600 | Encrypted volumes cannot be created or deleted for Vserver \\\"{0}\\\" while the enabled keystore configuration is being switched. If a previous attempt to switch the keystore configuration failed, or was interrupted, the system will continue to prevent encrypted volume creation for Vserver \\\"{0}\\\". Use the \\\"security key-manager keystore enable\\\" command to re-run and complete the operation. |
| 65539430 | Cannot create or delete volumes on Vserver \\\"{0}\\\" while the keystore is being initialized. Wait until the keystore is in the active state, and rerun the volume operation. |
| 65539431 | Cannot create or delete volumes on Vserver \\\"{0}\\\" while the keystore is being disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VolumeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume delete collection default response has a 2xx status code
func (o *VolumeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume delete collection default response has a 3xx status code
func (o *VolumeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume delete collection default response has a 4xx status code
func (o *VolumeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume delete collection default response has a 5xx status code
func (o *VolumeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume delete collection default response a status code equal to that given
func (o *VolumeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume delete collection default response
func (o *VolumeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VolumeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volume_delete_collection default %s", o._statusCode, payload)
}

func (o *VolumeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes][%d] volume_delete_collection default %s", o._statusCode, payload)
}

func (o *VolumeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeDeleteCollectionBody volume delete collection body
swagger:model VolumeDeleteCollectionBody
*/
type VolumeDeleteCollectionBody struct {

	// analytics
	Analytics *models.VolumeResponseInlineAnalytics `json:"analytics,omitempty"`

	// volume response inline records
	VolumeResponseInlineRecords []*models.Volume `json:"records,omitempty"`
}

// Validate validates this volume delete collection body
func (o *VolumeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAnalytics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeDeleteCollectionBody) validateAnalytics(formats strfmt.Registry) error {
	if swag.IsZero(o.Analytics) { // not required
		return nil
	}

	if o.Analytics != nil {
		if err := o.Analytics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeDeleteCollectionBody) validateVolumeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeResponseInlineRecords); i++ {
		if swag.IsZero(o.VolumeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VolumeResponseInlineRecords[i] != nil {
			if err := o.VolumeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume delete collection body based on the context it is used
func (o *VolumeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAnalytics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeDeleteCollectionBody) contextValidateAnalytics(ctx context.Context, formats strfmt.Registry) error {

	if o.Analytics != nil {
		if err := o.Analytics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeDeleteCollectionBody) contextValidateVolumeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeResponseInlineRecords); i++ {

		if o.VolumeResponseInlineRecords[i] != nil {
			if err := o.VolumeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res VolumeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeResponseInlineAnalytics Additional file system analytics information that is non-modifiable amongst all elements in the collection. <br/>
// This property is only populated if file system analytics is enabled on the containing volume. <br/>
// This analytics object captures properties that are non-modifiable amongst all elements included in the `records` array. The non-modifiable properties are included here, rather than within the information for each element, to avoid returning an excessive amount of duplicated information when the collection is large.
swagger:model volume_response_inline_analytics
*/
type VolumeResponseInlineAnalytics struct {

	// by accessed time
	ByAccessedTime *models.VolumeResponseInlineAnalyticsInlineByAccessedTime `json:"by_accessed_time,omitempty"`

	// by modified time
	ByModifiedTime *models.VolumeResponseInlineAnalyticsInlineByModifiedTime `json:"by_modified_time,omitempty"`
}

// Validate validates this volume response inline analytics
func (o *VolumeResponseInlineAnalytics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateByAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateByModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalytics) validateByAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ByAccessedTime) { // not required
		return nil
	}

	if o.ByAccessedTime != nil {
		if err := o.ByAccessedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeResponseInlineAnalytics) validateByModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ByModifiedTime) { // not required
		return nil
	}

	if o.ByModifiedTime != nil {
		if err := o.ByModifiedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume response inline analytics based on the context it is used
func (o *VolumeResponseInlineAnalytics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateByAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateByModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalytics) contextValidateByAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if o.ByAccessedTime != nil {
		if err := o.ByAccessedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeResponseInlineAnalytics) contextValidateByModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if o.ByModifiedTime != nil {
		if err := o.ByModifiedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeResponseInlineAnalytics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeResponseInlineAnalytics) UnmarshalBinary(b []byte) error {
	var res VolumeResponseInlineAnalytics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeResponseInlineAnalyticsInlineByAccessedTime File system analytics information, broken down by date of last access.
swagger:model volume_response_inline_analytics_inline_by_accessed_time
*/
type VolumeResponseInlineAnalyticsInlineByAccessedTime struct {

	// bytes used
	BytesUsed *models.VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume response inline analytics inline by accessed time
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(o.BytesUsed) { // not required
		return nil
	}

	if o.BytesUsed != nil {
		if err := o.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume response inline analytics inline by accessed time based on the context it is used
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if o.BytesUsed != nil {
		if err := o.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTime) UnmarshalBinary(b []byte) error {
	var res VolumeResponseInlineAnalyticsInlineByAccessedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last access.
swagger:model volume_response_inline_analytics_inline_by_accessed_time_inline_bytes_used
*/
type VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed struct {

	// labels
	Labels models.AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`
}

// Validate validates this volume response inline analytics inline by accessed time inline bytes used
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(o.Labels) { // not required
		return nil
	}

	if err := o.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// ContextValidate validate this volume response inline analytics inline by accessed time inline bytes used based on the context it is used
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeResponseInlineAnalyticsInlineByAccessedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeResponseInlineAnalyticsInlineByModifiedTime File system analytics information, broken down by date of last modification.
swagger:model volume_response_inline_analytics_inline_by_modified_time
*/
type VolumeResponseInlineAnalyticsInlineByModifiedTime struct {

	// bytes used
	BytesUsed *models.VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume response inline analytics inline by modified time
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(o.BytesUsed) { // not required
		return nil
	}

	if o.BytesUsed != nil {
		if err := o.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume response inline analytics inline by modified time based on the context it is used
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if o.BytesUsed != nil {
		if err := o.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTime) UnmarshalBinary(b []byte) error {
	var res VolumeResponseInlineAnalyticsInlineByModifiedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last modification.
swagger:model volume_response_inline_analytics_inline_by_modified_time_inline_bytes_used
*/
type VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed struct {

	// labels
	Labels models.AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`
}

// Validate validates this volume response inline analytics inline by modified time inline bytes used
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(o.Labels) { // not required
		return nil
	}

	if err := o.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// ContextValidate validate this volume response inline analytics inline by modified time inline bytes used based on the context it is used
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeResponseInlineAnalyticsInlineByModifiedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
