// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVolumeEfficiencyPolicyCollectionGetParams creates a new VolumeEfficiencyPolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeEfficiencyPolicyCollectionGetParams() *VolumeEfficiencyPolicyCollectionGetParams {
	return &VolumeEfficiencyPolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeEfficiencyPolicyCollectionGetParamsWithTimeout creates a new VolumeEfficiencyPolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewVolumeEfficiencyPolicyCollectionGetParamsWithTimeout(timeout time.Duration) *VolumeEfficiencyPolicyCollectionGetParams {
	return &VolumeEfficiencyPolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewVolumeEfficiencyPolicyCollectionGetParamsWithContext creates a new VolumeEfficiencyPolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewVolumeEfficiencyPolicyCollectionGetParamsWithContext(ctx context.Context) *VolumeEfficiencyPolicyCollectionGetParams {
	return &VolumeEfficiencyPolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewVolumeEfficiencyPolicyCollectionGetParamsWithHTTPClient creates a new VolumeEfficiencyPolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeEfficiencyPolicyCollectionGetParamsWithHTTPClient(client *http.Client) *VolumeEfficiencyPolicyCollectionGetParams {
	return &VolumeEfficiencyPolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
VolumeEfficiencyPolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the volume efficiency policy collection get operation.

	Typically these are written to a http.Request.
*/
type VolumeEfficiencyPolicyCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Duration.

	   Filter by duration
	*/
	Duration *int64

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* QosPolicy.

	   Filter by qos_policy
	*/
	QosPolicy *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScheduleName.

	   Filter by schedule.name
	*/
	ScheduleName *string

	/* StartThresholdPercent.

	   Filter by start_threshold_percent
	*/
	StartThresholdPercent *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume efficiency policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithDefaults() *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume efficiency policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := VolumeEfficiencyPolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithTimeout(timeout time.Duration) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithContext(ctx context.Context) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithHTTPClient(client *http.Client) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithComment(comment *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithDuration adds the duration to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithDuration(duration *int64) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetDuration(duration *int64) {
	o.Duration = duration
}

// WithEnabled adds the enabled to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithEnabled(enabled *bool) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithFields(fields []string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithName(name *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithOrderBy(orderBy []string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithQosPolicy adds the qosPolicy to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithQosPolicy(qosPolicy *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetQosPolicy(qosPolicy)
	return o
}

// SetQosPolicy adds the qosPolicy to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetQosPolicy(qosPolicy *string) {
	o.QosPolicy = qosPolicy
}

// WithReturnRecords adds the returnRecords to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScheduleName adds the scheduleName to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithScheduleName(scheduleName *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetScheduleName(scheduleName)
	return o
}

// SetScheduleName adds the scheduleName to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetScheduleName(scheduleName *string) {
	o.ScheduleName = scheduleName
}

// WithStartThresholdPercent adds the startThresholdPercent to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithStartThresholdPercent(startThresholdPercent *int64) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetStartThresholdPercent(startThresholdPercent)
	return o
}

// SetStartThresholdPercent adds the startThresholdPercent to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetStartThresholdPercent(startThresholdPercent *int64) {
	o.StartThresholdPercent = startThresholdPercent
}

// WithSvmName adds the svmName to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithSvmName(svmName *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithSvmUUID(svmUUID *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithType(typeVar *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) WithUUID(uuid *string) *VolumeEfficiencyPolicyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the volume efficiency policy collection get params
func (o *VolumeEfficiencyPolicyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeEfficiencyPolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Duration != nil {

		// query param duration
		var qrDuration int64

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := swag.FormatInt64(qrDuration)
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.QosPolicy != nil {

		// query param qos_policy
		var qrQosPolicy string

		if o.QosPolicy != nil {
			qrQosPolicy = *o.QosPolicy
		}
		qQosPolicy := qrQosPolicy
		if qQosPolicy != "" {

			if err := r.SetQueryParam("qos_policy", qQosPolicy); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScheduleName != nil {

		// query param schedule.name
		var qrScheduleName string

		if o.ScheduleName != nil {
			qrScheduleName = *o.ScheduleName
		}
		qScheduleName := qrScheduleName
		if qScheduleName != "" {

			if err := r.SetQueryParam("schedule.name", qScheduleName); err != nil {
				return err
			}
		}
	}

	if o.StartThresholdPercent != nil {

		// query param start_threshold_percent
		var qrStartThresholdPercent int64

		if o.StartThresholdPercent != nil {
			qrStartThresholdPercent = *o.StartThresholdPercent
		}
		qStartThresholdPercent := swag.FormatInt64(qrStartThresholdPercent)
		if qStartThresholdPercent != "" {

			if err := r.SetQueryParam("start_threshold_percent", qStartThresholdPercent); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVolumeEfficiencyPolicyCollectionGet binds the parameter fields
func (o *VolumeEfficiencyPolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamVolumeEfficiencyPolicyCollectionGet binds the parameter order_by
func (o *VolumeEfficiencyPolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
