// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewVolumeEfficiencyPolicyCreateParams creates a new VolumeEfficiencyPolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeEfficiencyPolicyCreateParams() *VolumeEfficiencyPolicyCreateParams {
	return &VolumeEfficiencyPolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeEfficiencyPolicyCreateParamsWithTimeout creates a new VolumeEfficiencyPolicyCreateParams object
// with the ability to set a timeout on a request.
func NewVolumeEfficiencyPolicyCreateParamsWithTimeout(timeout time.Duration) *VolumeEfficiencyPolicyCreateParams {
	return &VolumeEfficiencyPolicyCreateParams{
		timeout: timeout,
	}
}

// NewVolumeEfficiencyPolicyCreateParamsWithContext creates a new VolumeEfficiencyPolicyCreateParams object
// with the ability to set a context for a request.
func NewVolumeEfficiencyPolicyCreateParamsWithContext(ctx context.Context) *VolumeEfficiencyPolicyCreateParams {
	return &VolumeEfficiencyPolicyCreateParams{
		Context: ctx,
	}
}

// NewVolumeEfficiencyPolicyCreateParamsWithHTTPClient creates a new VolumeEfficiencyPolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeEfficiencyPolicyCreateParamsWithHTTPClient(client *http.Client) *VolumeEfficiencyPolicyCreateParams {
	return &VolumeEfficiencyPolicyCreateParams{
		HTTPClient: client,
	}
}

/*
VolumeEfficiencyPolicyCreateParams contains all the parameters to send to the API endpoint

	for the volume efficiency policy create operation.

	Typically these are written to a http.Request.
*/
type VolumeEfficiencyPolicyCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.VolumeEfficiencyPolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume efficiency policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeEfficiencyPolicyCreateParams) WithDefaults() *VolumeEfficiencyPolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume efficiency policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeEfficiencyPolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := VolumeEfficiencyPolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) WithTimeout(timeout time.Duration) *VolumeEfficiencyPolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) WithContext(ctx context.Context) *VolumeEfficiencyPolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) WithHTTPClient(client *http.Client) *VolumeEfficiencyPolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) WithInfo(info *models.VolumeEfficiencyPolicy) *VolumeEfficiencyPolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) SetInfo(info *models.VolumeEfficiencyPolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) WithReturnRecords(returnRecords *bool) *VolumeEfficiencyPolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the volume efficiency policy create params
func (o *VolumeEfficiencyPolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeEfficiencyPolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
