// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeEfficiencyPolicyCreateReader is a Reader for the VolumeEfficiencyPolicyCreate structure.
type VolumeEfficiencyPolicyCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeEfficiencyPolicyCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewVolumeEfficiencyPolicyCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeEfficiencyPolicyCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeEfficiencyPolicyCreateCreated creates a VolumeEfficiencyPolicyCreateCreated with default headers values
func NewVolumeEfficiencyPolicyCreateCreated() *VolumeEfficiencyPolicyCreateCreated {
	return &VolumeEfficiencyPolicyCreateCreated{}
}

/*
VolumeEfficiencyPolicyCreateCreated describes a response with status code 201, with default header values.

Created
*/
type VolumeEfficiencyPolicyCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this volume efficiency policy create created response has a 2xx status code
func (o *VolumeEfficiencyPolicyCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume efficiency policy create created response has a 3xx status code
func (o *VolumeEfficiencyPolicyCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume efficiency policy create created response has a 4xx status code
func (o *VolumeEfficiencyPolicyCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume efficiency policy create created response has a 5xx status code
func (o *VolumeEfficiencyPolicyCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this volume efficiency policy create created response a status code equal to that given
func (o *VolumeEfficiencyPolicyCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the volume efficiency policy create created response
func (o *VolumeEfficiencyPolicyCreateCreated) Code() int {
	return 201
}

func (o *VolumeEfficiencyPolicyCreateCreated) Error() string {
	return fmt.Sprintf("[POST /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyCreateCreated", 201)
}

func (o *VolumeEfficiencyPolicyCreateCreated) String() string {
	return fmt.Sprintf("[POST /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyCreateCreated", 201)
}

func (o *VolumeEfficiencyPolicyCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewVolumeEfficiencyPolicyCreateDefault creates a VolumeEfficiencyPolicyCreateDefault with default headers values
func NewVolumeEfficiencyPolicyCreateDefault(code int) *VolumeEfficiencyPolicyCreateDefault {
	return &VolumeEfficiencyPolicyCreateDefault{
		_statusCode: code,
	}
}

/*
	VolumeEfficiencyPolicyCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 918702 | The specified operation on the volume efficiency policies endpoint is not supported on this platform. |
| 6881341 | Specified schedule not found. |
| 6881344 | Failed to queue specified job. |
| 6881345 | This operation is not permitted on a node SVM. |
| 6881349 | Policy name is not valid. |
| 6881351 | Policy name is too long. |
| 6881352 | Policy name is not valid. |
| 6881362 | Threshold percentage cannot be less than 1 percent. |
| 6881433 | For \"threshold\" type policy, \"schedule and duration\" is not supported. |
| 6881435 | Only a policy of type "threshold" can set the "start-threshold-percent" attribute. |
| 6881454 | An efficiency policy of type "threshold" requires an effective cluster version of ONTAP 8.3 or later. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VolumeEfficiencyPolicyCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume efficiency policy create default response has a 2xx status code
func (o *VolumeEfficiencyPolicyCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume efficiency policy create default response has a 3xx status code
func (o *VolumeEfficiencyPolicyCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume efficiency policy create default response has a 4xx status code
func (o *VolumeEfficiencyPolicyCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume efficiency policy create default response has a 5xx status code
func (o *VolumeEfficiencyPolicyCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume efficiency policy create default response a status code equal to that given
func (o *VolumeEfficiencyPolicyCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume efficiency policy create default response
func (o *VolumeEfficiencyPolicyCreateDefault) Code() int {
	return o._statusCode
}

func (o *VolumeEfficiencyPolicyCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/volume-efficiency-policies][%d] volume_efficiency_policy_create default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/volume-efficiency-policies][%d] volume_efficiency_policy_create default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
