// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeEfficiencyPolicyDeleteCollectionReader is a Reader for the VolumeEfficiencyPolicyDeleteCollection structure.
type VolumeEfficiencyPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeEfficiencyPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeEfficiencyPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeEfficiencyPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeEfficiencyPolicyDeleteCollectionOK creates a VolumeEfficiencyPolicyDeleteCollectionOK with default headers values
func NewVolumeEfficiencyPolicyDeleteCollectionOK() *VolumeEfficiencyPolicyDeleteCollectionOK {
	return &VolumeEfficiencyPolicyDeleteCollectionOK{}
}

/*
VolumeEfficiencyPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VolumeEfficiencyPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this volume efficiency policy delete collection o k response has a 2xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume efficiency policy delete collection o k response has a 3xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume efficiency policy delete collection o k response has a 4xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume efficiency policy delete collection o k response has a 5xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume efficiency policy delete collection o k response a status code equal to that given
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume efficiency policy delete collection o k response
func (o *VolumeEfficiencyPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *VolumeEfficiencyPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyDeleteCollectionOK", 200)
}

func (o *VolumeEfficiencyPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyDeleteCollectionOK", 200)
}

func (o *VolumeEfficiencyPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeEfficiencyPolicyDeleteCollectionDefault creates a VolumeEfficiencyPolicyDeleteCollectionDefault with default headers values
func NewVolumeEfficiencyPolicyDeleteCollectionDefault(code int) *VolumeEfficiencyPolicyDeleteCollectionDefault {
	return &VolumeEfficiencyPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	VolumeEfficiencyPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------  | ----------- |
|  918702    | The specified operation on the volume efficiency policies endpoint is not supported on this platform. |
|  6881346   | The policy was not deleted because the policy is in use by at least one volume. |
|  6881431   | The specified policy is a predefined policy and cannot be deleted. |
*/
type VolumeEfficiencyPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume efficiency policy delete collection default response has a 2xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume efficiency policy delete collection default response has a 3xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume efficiency policy delete collection default response has a 4xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume efficiency policy delete collection default response has a 5xx status code
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume efficiency policy delete collection default response a status code equal to that given
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume efficiency policy delete collection default response
func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volume-efficiency-policies][%d] volume_efficiency_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volume-efficiency-policies][%d] volume_efficiency_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeEfficiencyPolicyDeleteCollectionBody volume efficiency policy delete collection body
swagger:model VolumeEfficiencyPolicyDeleteCollectionBody
*/
type VolumeEfficiencyPolicyDeleteCollectionBody struct {

	// volume efficiency policy response inline records
	VolumeEfficiencyPolicyResponseInlineRecords []*models.VolumeEfficiencyPolicy `json:"records,omitempty"`
}

// Validate validates this volume efficiency policy delete collection body
func (o *VolumeEfficiencyPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateVolumeEfficiencyPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyDeleteCollectionBody) validateVolumeEfficiencyPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeEfficiencyPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeEfficiencyPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.VolumeEfficiencyPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VolumeEfficiencyPolicyResponseInlineRecords[i] != nil {
			if err := o.VolumeEfficiencyPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume efficiency policy delete collection body based on the context it is used
func (o *VolumeEfficiencyPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateVolumeEfficiencyPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyDeleteCollectionBody) contextValidateVolumeEfficiencyPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeEfficiencyPolicyResponseInlineRecords); i++ {

		if o.VolumeEfficiencyPolicyResponseInlineRecords[i] != nil {
			if err := o.VolumeEfficiencyPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
