// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeEfficiencyPolicyGetReader is a Reader for the VolumeEfficiencyPolicyGet structure.
type VolumeEfficiencyPolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeEfficiencyPolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeEfficiencyPolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeEfficiencyPolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeEfficiencyPolicyGetOK creates a VolumeEfficiencyPolicyGetOK with default headers values
func NewVolumeEfficiencyPolicyGetOK() *VolumeEfficiencyPolicyGetOK {
	return &VolumeEfficiencyPolicyGetOK{}
}

/*
VolumeEfficiencyPolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type VolumeEfficiencyPolicyGetOK struct {
	Payload *models.VolumeEfficiencyPolicy
}

// IsSuccess returns true when this volume efficiency policy get o k response has a 2xx status code
func (o *VolumeEfficiencyPolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume efficiency policy get o k response has a 3xx status code
func (o *VolumeEfficiencyPolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume efficiency policy get o k response has a 4xx status code
func (o *VolumeEfficiencyPolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume efficiency policy get o k response has a 5xx status code
func (o *VolumeEfficiencyPolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume efficiency policy get o k response a status code equal to that given
func (o *VolumeEfficiencyPolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume efficiency policy get o k response
func (o *VolumeEfficiencyPolicyGetOK) Code() int {
	return 200
}

func (o *VolumeEfficiencyPolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volume-efficiency-policies/{uuid}][%d] volumeEfficiencyPolicyGetOK %s", 200, payload)
}

func (o *VolumeEfficiencyPolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volume-efficiency-policies/{uuid}][%d] volumeEfficiencyPolicyGetOK %s", 200, payload)
}

func (o *VolumeEfficiencyPolicyGetOK) GetPayload() *models.VolumeEfficiencyPolicy {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeEfficiencyPolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeEfficiencyPolicyGetDefault creates a VolumeEfficiencyPolicyGetDefault with default headers values
func NewVolumeEfficiencyPolicyGetDefault(code int) *VolumeEfficiencyPolicyGetDefault {
	return &VolumeEfficiencyPolicyGetDefault{
		_statusCode: code,
	}
}

/*
VolumeEfficiencyPolicyGetDefault describes a response with status code -1, with default header values.

Error
*/
type VolumeEfficiencyPolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume efficiency policy get default response has a 2xx status code
func (o *VolumeEfficiencyPolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume efficiency policy get default response has a 3xx status code
func (o *VolumeEfficiencyPolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume efficiency policy get default response has a 4xx status code
func (o *VolumeEfficiencyPolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume efficiency policy get default response has a 5xx status code
func (o *VolumeEfficiencyPolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume efficiency policy get default response a status code equal to that given
func (o *VolumeEfficiencyPolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume efficiency policy get default response
func (o *VolumeEfficiencyPolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *VolumeEfficiencyPolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volume-efficiency-policies/{uuid}][%d] volume_efficiency_policy_get default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volume-efficiency-policies/{uuid}][%d] volume_efficiency_policy_get default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
