// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeEfficiencyPolicyModifyCollectionReader is a Reader for the VolumeEfficiencyPolicyModifyCollection structure.
type VolumeEfficiencyPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeEfficiencyPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeEfficiencyPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeEfficiencyPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeEfficiencyPolicyModifyCollectionOK creates a VolumeEfficiencyPolicyModifyCollectionOK with default headers values
func NewVolumeEfficiencyPolicyModifyCollectionOK() *VolumeEfficiencyPolicyModifyCollectionOK {
	return &VolumeEfficiencyPolicyModifyCollectionOK{}
}

/*
VolumeEfficiencyPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VolumeEfficiencyPolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this volume efficiency policy modify collection o k response has a 2xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume efficiency policy modify collection o k response has a 3xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume efficiency policy modify collection o k response has a 4xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume efficiency policy modify collection o k response has a 5xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume efficiency policy modify collection o k response a status code equal to that given
func (o *VolumeEfficiencyPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume efficiency policy modify collection o k response
func (o *VolumeEfficiencyPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *VolumeEfficiencyPolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyModifyCollectionOK", 200)
}

func (o *VolumeEfficiencyPolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies][%d] volumeEfficiencyPolicyModifyCollectionOK", 200)
}

func (o *VolumeEfficiencyPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeEfficiencyPolicyModifyCollectionDefault creates a VolumeEfficiencyPolicyModifyCollectionDefault with default headers values
func NewVolumeEfficiencyPolicyModifyCollectionDefault(code int) *VolumeEfficiencyPolicyModifyCollectionDefault {
	return &VolumeEfficiencyPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	VolumeEfficiencyPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 918702 | The specified operation on the volume efficiency policies endpoint is not supported on this platform. |
| 6881341 | Specified schedule not found. |
| 6881344 | Failed to queue specified job. |
| 6881351 | Policy name is too long. |
| 6881352 | Policy name is not valid. |
| 6881362 | Threshold percentage cannot be less than 1 percent. |
| 6881433 | For \"threshold\" type policy, \"schedule and duration\" is not supported. |
| 6881435 | Only a policy of type "threshold" can set the "start-threshold-percent" attribute. |
| 6881438 | For \"inline-only and auto\" policy, modification of attributes is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VolumeEfficiencyPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume efficiency policy modify collection default response has a 2xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume efficiency policy modify collection default response has a 3xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume efficiency policy modify collection default response has a 4xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume efficiency policy modify collection default response has a 5xx status code
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume efficiency policy modify collection default response a status code equal to that given
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume efficiency policy modify collection default response
func (o *VolumeEfficiencyPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VolumeEfficiencyPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies][%d] volume_efficiency_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies][%d] volume_efficiency_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeEfficiencyPolicyModifyCollectionBody volume efficiency policy modify collection body
swagger:model VolumeEfficiencyPolicyModifyCollectionBody
*/
type VolumeEfficiencyPolicyModifyCollectionBody struct {

	// links
	Links *models.VolumeEfficiencyPolicyInlineLinks `json:"_links,omitempty"`

	// A comment associated with the volume efficiency policy.
	Comment *string `json:"comment,omitempty"`

	// This field is used with the policy type "scheduled" to indicate the allowed duration for a session, in hours. Possible value is a number between 0 and 999 inclusive. Default is unlimited indicated by value 0.
	Duration *int64 `json:"duration,omitempty"`

	// Is the volume efficiency policy enabled?
	Enabled *bool `json:"enabled,omitempty"`

	// Name of the volume efficiency policy.
	Name *string `json:"name,omitempty"`

	// QoS policy for the sis operation. Possible values are background and best_effort. In background, sis operation will run in background with minimal or no impact on data serving client operations. In best_effort, sis operations may have some impact on data serving client operations.
	// Enum: ["background","best_effort"]
	QosPolicy *string `json:"qos_policy,omitempty"`

	// schedule
	Schedule *models.VolumeEfficiencyPolicyInlineSchedule `json:"schedule,omitempty"`

	// This field is used with the policy type "threshold" to indicate the threshold percentage for triggering the volume efficiency policy. It is mutually exclusive of the schedule.
	StartThresholdPercent *int64 `json:"start_threshold_percent,omitempty"`

	// svm
	Svm *models.VolumeEfficiencyPolicyInlineSvm `json:"svm,omitempty"`

	// Type of volume efficiency policy.
	// Enum: ["scheduled","threshold"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of volume efficiency policy.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume efficiency policy response inline records
	VolumeEfficiencyPolicyResponseInlineRecords []*models.VolumeEfficiencyPolicy `json:"records,omitempty"`
}

// Validate validates this volume efficiency policy modify collection body
func (o *VolumeEfficiencyPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeEfficiencyPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var volumeEfficiencyPolicyModifyCollectionBodyTypeQosPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["background","best_effort"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeEfficiencyPolicyModifyCollectionBodyTypeQosPolicyPropEnum = append(volumeEfficiencyPolicyModifyCollectionBodyTypeQosPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBody
	// VolumeEfficiencyPolicyModifyCollectionBody
	// qos_policy
	// QosPolicy
	// background
	// END DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBodyQosPolicyBackground captures enum value "background"
	VolumeEfficiencyPolicyModifyCollectionBodyQosPolicyBackground string = "background"

	// BEGIN DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBody
	// VolumeEfficiencyPolicyModifyCollectionBody
	// qos_policy
	// QosPolicy
	// best_effort
	// END DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBodyQosPolicyBestEffort captures enum value "best_effort"
	VolumeEfficiencyPolicyModifyCollectionBodyQosPolicyBestEffort string = "best_effort"
)

// prop value enum
func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateQosPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeEfficiencyPolicyModifyCollectionBodyTypeQosPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateQosPolicyEnum("info"+"."+"qos_policy", "body", *o.QosPolicy); err != nil {
		return err
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.Schedule) { // not required
		return nil
	}

	if o.Schedule != nil {
		if err := o.Schedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var volumeEfficiencyPolicyModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["scheduled","threshold"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeEfficiencyPolicyModifyCollectionBodyTypeTypePropEnum = append(volumeEfficiencyPolicyModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBody
	// VolumeEfficiencyPolicyModifyCollectionBody
	// type
	// Type
	// scheduled
	// END DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBodyTypeScheduled captures enum value "scheduled"
	VolumeEfficiencyPolicyModifyCollectionBodyTypeScheduled string = "scheduled"

	// BEGIN DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBody
	// VolumeEfficiencyPolicyModifyCollectionBody
	// type
	// Type
	// threshold
	// END DEBUGGING
	// VolumeEfficiencyPolicyModifyCollectionBodyTypeThreshold captures enum value "threshold"
	VolumeEfficiencyPolicyModifyCollectionBodyTypeThreshold string = "threshold"
)

// prop value enum
func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeEfficiencyPolicyModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) validateVolumeEfficiencyPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeEfficiencyPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeEfficiencyPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.VolumeEfficiencyPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VolumeEfficiencyPolicyResponseInlineRecords[i] != nil {
			if err := o.VolumeEfficiencyPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume efficiency policy modify collection body based on the context it is used
func (o *VolumeEfficiencyPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeEfficiencyPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.Schedule != nil {
		if err := o.Schedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *VolumeEfficiencyPolicyModifyCollectionBody) contextValidateVolumeEfficiencyPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeEfficiencyPolicyResponseInlineRecords); i++ {

		if o.VolumeEfficiencyPolicyResponseInlineRecords[i] != nil {
			if err := o.VolumeEfficiencyPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeEfficiencyPolicyInlineLinks volume efficiency policy inline links
swagger:model volume_efficiency_policy_inline__links
*/
type VolumeEfficiencyPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume efficiency policy inline links
func (o *VolumeEfficiencyPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume efficiency policy inline links based on the context it is used
func (o *VolumeEfficiencyPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeEfficiencyPolicyInlineSchedule volume efficiency policy inline schedule
swagger:model volume_efficiency_policy_inline_schedule
*/
type VolumeEfficiencyPolicyInlineSchedule struct {

	// Schedule at which volume efficiency policies are captured on the SVM. Some common schedules already defined in the system are hourly, daily, weekly, at 5 minute intervals, and at 8 hour intervals. Volume efficiency policies with custom schedules can be referenced.
	Name *string `json:"name,omitempty"`
}

// Validate validates this volume efficiency policy inline schedule
func (o *VolumeEfficiencyPolicyInlineSchedule) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume efficiency policy inline schedule based on context it is used
func (o *VolumeEfficiencyPolicyInlineSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSchedule) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyInlineSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeEfficiencyPolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model volume_efficiency_policy_inline_svm
*/
type VolumeEfficiencyPolicyInlineSvm struct {

	// links
	Links *models.VolumeEfficiencyPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume efficiency policy inline svm
func (o *VolumeEfficiencyPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume efficiency policy inline svm based on the context it is used
func (o *VolumeEfficiencyPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeEfficiencyPolicyInlineSvmInlineLinks volume efficiency policy inline svm inline links
swagger:model volume_efficiency_policy_inline_svm_inline__links
*/
type VolumeEfficiencyPolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume efficiency policy inline svm inline links
func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume efficiency policy inline svm inline links based on the context it is used
func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeEfficiencyPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeEfficiencyPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
