// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeEfficiencyPolicyModifyReader is a Reader for the VolumeEfficiencyPolicyModify structure.
type VolumeEfficiencyPolicyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeEfficiencyPolicyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeEfficiencyPolicyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeEfficiencyPolicyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeEfficiencyPolicyModifyOK creates a VolumeEfficiencyPolicyModifyOK with default headers values
func NewVolumeEfficiencyPolicyModifyOK() *VolumeEfficiencyPolicyModifyOK {
	return &VolumeEfficiencyPolicyModifyOK{}
}

/*
VolumeEfficiencyPolicyModifyOK describes a response with status code 200, with default header values.

OK
*/
type VolumeEfficiencyPolicyModifyOK struct {
}

// IsSuccess returns true when this volume efficiency policy modify o k response has a 2xx status code
func (o *VolumeEfficiencyPolicyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume efficiency policy modify o k response has a 3xx status code
func (o *VolumeEfficiencyPolicyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume efficiency policy modify o k response has a 4xx status code
func (o *VolumeEfficiencyPolicyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume efficiency policy modify o k response has a 5xx status code
func (o *VolumeEfficiencyPolicyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume efficiency policy modify o k response a status code equal to that given
func (o *VolumeEfficiencyPolicyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume efficiency policy modify o k response
func (o *VolumeEfficiencyPolicyModifyOK) Code() int {
	return 200
}

func (o *VolumeEfficiencyPolicyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies/{uuid}][%d] volumeEfficiencyPolicyModifyOK", 200)
}

func (o *VolumeEfficiencyPolicyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies/{uuid}][%d] volumeEfficiencyPolicyModifyOK", 200)
}

func (o *VolumeEfficiencyPolicyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeEfficiencyPolicyModifyDefault creates a VolumeEfficiencyPolicyModifyDefault with default headers values
func NewVolumeEfficiencyPolicyModifyDefault(code int) *VolumeEfficiencyPolicyModifyDefault {
	return &VolumeEfficiencyPolicyModifyDefault{
		_statusCode: code,
	}
}

/*
	VolumeEfficiencyPolicyModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 918702 | The specified operation on the volume efficiency policies endpoint is not supported on this platform. |
| 6881341 | Specified schedule not found. |
| 6881344 | Failed to queue specified job. |
| 6881351 | Policy name is too long. |
| 6881352 | Policy name is not valid. |
| 6881362 | Threshold percentage cannot be less than 1 percent. |
| 6881433 | For \"threshold\" type policy, \"schedule and duration\" is not supported. |
| 6881435 | Only a policy of type "threshold" can set the "start-threshold-percent" attribute. |
| 6881438 | For \"inline-only and auto\" policy, modification of attributes is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VolumeEfficiencyPolicyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume efficiency policy modify default response has a 2xx status code
func (o *VolumeEfficiencyPolicyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume efficiency policy modify default response has a 3xx status code
func (o *VolumeEfficiencyPolicyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume efficiency policy modify default response has a 4xx status code
func (o *VolumeEfficiencyPolicyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume efficiency policy modify default response has a 5xx status code
func (o *VolumeEfficiencyPolicyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume efficiency policy modify default response a status code equal to that given
func (o *VolumeEfficiencyPolicyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume efficiency policy modify default response
func (o *VolumeEfficiencyPolicyModifyDefault) Code() int {
	return o._statusCode
}

func (o *VolumeEfficiencyPolicyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies/{uuid}][%d] volume_efficiency_policy_modify default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volume-efficiency-policies/{uuid}][%d] volume_efficiency_policy_modify default %s", o._statusCode, payload)
}

func (o *VolumeEfficiencyPolicyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeEfficiencyPolicyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
