// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVolumeGetParams creates a new VolumeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeGetParams() *VolumeGetParams {
	return &VolumeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeGetParamsWithTimeout creates a new VolumeGetParams object
// with the ability to set a timeout on a request.
func NewVolumeGetParamsWithTimeout(timeout time.Duration) *VolumeGetParams {
	return &VolumeGetParams{
		timeout: timeout,
	}
}

// NewVolumeGetParamsWithContext creates a new VolumeGetParams object
// with the ability to set a context for a request.
func NewVolumeGetParamsWithContext(ctx context.Context) *VolumeGetParams {
	return &VolumeGetParams{
		Context: ctx,
	}
}

// NewVolumeGetParamsWithHTTPClient creates a new VolumeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeGetParamsWithHTTPClient(client *http.Client) *VolumeGetParams {
	return &VolumeGetParams{
		HTTPClient: client,
	}
}

/*
VolumeGetParams contains all the parameters to send to the API endpoint

	for the volume get operation.

	Typically these are written to a http.Request.
*/
type VolumeGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsConstituent.

	   When set to false, only FlexVol and FlexGroup volumes are returned.  When set to true, only FlexGroup constituent volumes are returned. Default for GET calls is false.
	*/
	IsConstituent *bool

	/* UUID.

	   Unique identifier of the volume.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeGetParams) WithDefaults() *VolumeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeGetParams) SetDefaults() {
	var (
		isConstituentDefault = bool(false)
	)

	val := VolumeGetParams{
		IsConstituent: &isConstituentDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume get params
func (o *VolumeGetParams) WithTimeout(timeout time.Duration) *VolumeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume get params
func (o *VolumeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume get params
func (o *VolumeGetParams) WithContext(ctx context.Context) *VolumeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume get params
func (o *VolumeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume get params
func (o *VolumeGetParams) WithHTTPClient(client *http.Client) *VolumeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume get params
func (o *VolumeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the volume get params
func (o *VolumeGetParams) WithFields(fields []string) *VolumeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the volume get params
func (o *VolumeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsConstituent adds the isConstituent to the volume get params
func (o *VolumeGetParams) WithIsConstituent(isConstituent *bool) *VolumeGetParams {
	o.SetIsConstituent(isConstituent)
	return o
}

// SetIsConstituent adds the isConstituent to the volume get params
func (o *VolumeGetParams) SetIsConstituent(isConstituent *bool) {
	o.IsConstituent = isConstituent
}

// WithUUID adds the uuid to the volume get params
func (o *VolumeGetParams) WithUUID(uuid string) *VolumeGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the volume get params
func (o *VolumeGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsConstituent != nil {

		// query param is_constituent
		var qrIsConstituent bool

		if o.IsConstituent != nil {
			qrIsConstituent = *o.IsConstituent
		}
		qIsConstituent := swag.FormatBool(qrIsConstituent)
		if qIsConstituent != "" {

			if err := r.SetQueryParam("is_constituent", qIsConstituent); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVolumeGet binds the parameter fields
func (o *VolumeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
