// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeGetReader is a Reader for the VolumeGet structure.
type VolumeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeGetOK creates a VolumeGetOK with default headers values
func NewVolumeGetOK() *VolumeGetOK {
	return &VolumeGetOK{}
}

/*
VolumeGetOK describes a response with status code 200, with default header values.

OK
*/
type VolumeGetOK struct {
	Payload *models.Volume
}

// IsSuccess returns true when this volume get o k response has a 2xx status code
func (o *VolumeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume get o k response has a 3xx status code
func (o *VolumeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume get o k response has a 4xx status code
func (o *VolumeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume get o k response has a 5xx status code
func (o *VolumeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume get o k response a status code equal to that given
func (o *VolumeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume get o k response
func (o *VolumeGetOK) Code() int {
	return 200
}

func (o *VolumeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{uuid}][%d] volumeGetOK %s", 200, payload)
}

func (o *VolumeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{uuid}][%d] volumeGetOK %s", 200, payload)
}

func (o *VolumeGetOK) GetPayload() *models.Volume {
	return o.Payload
}

func (o *VolumeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Volume)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeGetDefault creates a VolumeGetDefault with default headers values
func NewVolumeGetDefault(code int) *VolumeGetDefault {
	return &VolumeGetDefault{
		_statusCode: code,
	}
}

/*
VolumeGetDefault describes a response with status code -1, with default header values.

Error
*/
type VolumeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume get default response has a 2xx status code
func (o *VolumeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume get default response has a 3xx status code
func (o *VolumeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume get default response has a 4xx status code
func (o *VolumeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume get default response has a 5xx status code
func (o *VolumeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume get default response a status code equal to that given
func (o *VolumeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume get default response
func (o *VolumeGetDefault) Code() int {
	return o._statusCode
}

func (o *VolumeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{uuid}][%d] volume_get default %s", o._statusCode, payload)
}

func (o *VolumeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{uuid}][%d] volume_get default %s", o._statusCode, payload)
}

func (o *VolumeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
