// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVolumeMetricsCollectionGetParams creates a new VolumeMetricsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeMetricsCollectionGetParams() *VolumeMetricsCollectionGetParams {
	return &VolumeMetricsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeMetricsCollectionGetParamsWithTimeout creates a new VolumeMetricsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewVolumeMetricsCollectionGetParamsWithTimeout(timeout time.Duration) *VolumeMetricsCollectionGetParams {
	return &VolumeMetricsCollectionGetParams{
		timeout: timeout,
	}
}

// NewVolumeMetricsCollectionGetParamsWithContext creates a new VolumeMetricsCollectionGetParams object
// with the ability to set a context for a request.
func NewVolumeMetricsCollectionGetParamsWithContext(ctx context.Context) *VolumeMetricsCollectionGetParams {
	return &VolumeMetricsCollectionGetParams{
		Context: ctx,
	}
}

// NewVolumeMetricsCollectionGetParamsWithHTTPClient creates a new VolumeMetricsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeMetricsCollectionGetParamsWithHTTPClient(client *http.Client) *VolumeMetricsCollectionGetParams {
	return &VolumeMetricsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
VolumeMetricsCollectionGetParams contains all the parameters to send to the API endpoint

	for the volume metrics collection get operation.

	Typically these are written to a http.Request.
*/
type VolumeMetricsCollectionGetParams struct {

	/* CloudDuration.

	   Filter by cloud.duration
	*/
	CloudDuration *string

	/* CloudIopsOther.

	   Filter by cloud.iops.other
	*/
	CloudIopsOther *int64

	/* CloudIopsRead.

	   Filter by cloud.iops.read
	*/
	CloudIopsRead *int64

	/* CloudIopsTotal.

	   Filter by cloud.iops.total
	*/
	CloudIopsTotal *int64

	/* CloudIopsWrite.

	   Filter by cloud.iops.write
	*/
	CloudIopsWrite *int64

	/* CloudLatencyOther.

	   Filter by cloud.latency.other
	*/
	CloudLatencyOther *int64

	/* CloudLatencyRead.

	   Filter by cloud.latency.read
	*/
	CloudLatencyRead *int64

	/* CloudLatencyTotal.

	   Filter by cloud.latency.total
	*/
	CloudLatencyTotal *int64

	/* CloudLatencyWrite.

	   Filter by cloud.latency.write
	*/
	CloudLatencyWrite *int64

	/* CloudStatus.

	   Filter by cloud.status
	*/
	CloudStatus *string

	/* CloudTimestamp.

	   Filter by cloud.timestamp
	*/
	CloudTimestamp *string

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FlexcacheBandwidthSavings.

	   Filter by flexcache.bandwidth_savings
	*/
	FlexcacheBandwidthSavings *int64

	/* FlexcacheCacheMissPercent.

	   Filter by flexcache.cache_miss_percent
	*/
	FlexcacheCacheMissPercent *int64

	/* FlexcacheDuration.

	   Filter by flexcache.duration
	*/
	FlexcacheDuration *string

	/* FlexcacheStatus.

	   Filter by flexcache.status
	*/
	FlexcacheStatus *string

	/* FlexcacheTimestamp.

	   Filter by flexcache.timestamp
	*/
	FlexcacheTimestamp *string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* IopsOther.

	   Filter by iops.other
	*/
	IopsOther *int64

	/* IopsRead.

	   Filter by iops.read
	*/
	IopsRead *int64

	/* IopsTotal.

	   Filter by iops.total
	*/
	IopsTotal *int64

	/* IopsWrite.

	   Filter by iops.write
	*/
	IopsWrite *int64

	/* LatencyOther.

	   Filter by latency.other
	*/
	LatencyOther *int64

	/* LatencyRead.

	   Filter by latency.read
	*/
	LatencyRead *int64

	/* LatencyTotal.

	   Filter by latency.total
	*/
	LatencyTotal *int64

	/* LatencyWrite.

	   Filter by latency.write
	*/
	LatencyWrite *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* ThroughputOther.

	   Filter by throughput.other
	*/
	ThroughputOther *int64

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputTotal.

	   Filter by throughput.total
	*/
	ThroughputTotal *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* VolumeUUID.

	   Unique identifier of the volume.
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeMetricsCollectionGetParams) WithDefaults() *VolumeMetricsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeMetricsCollectionGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := VolumeMetricsCollectionGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithTimeout(timeout time.Duration) *VolumeMetricsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithContext(ctx context.Context) *VolumeMetricsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithHTTPClient(client *http.Client) *VolumeMetricsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCloudDuration adds the cloudDuration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudDuration(cloudDuration *string) *VolumeMetricsCollectionGetParams {
	o.SetCloudDuration(cloudDuration)
	return o
}

// SetCloudDuration adds the cloudDuration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudDuration(cloudDuration *string) {
	o.CloudDuration = cloudDuration
}

// WithCloudIopsOther adds the cloudIopsOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudIopsOther(cloudIopsOther *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudIopsOther(cloudIopsOther)
	return o
}

// SetCloudIopsOther adds the cloudIopsOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudIopsOther(cloudIopsOther *int64) {
	o.CloudIopsOther = cloudIopsOther
}

// WithCloudIopsRead adds the cloudIopsRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudIopsRead(cloudIopsRead *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudIopsRead(cloudIopsRead)
	return o
}

// SetCloudIopsRead adds the cloudIopsRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudIopsRead(cloudIopsRead *int64) {
	o.CloudIopsRead = cloudIopsRead
}

// WithCloudIopsTotal adds the cloudIopsTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudIopsTotal(cloudIopsTotal *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudIopsTotal(cloudIopsTotal)
	return o
}

// SetCloudIopsTotal adds the cloudIopsTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudIopsTotal(cloudIopsTotal *int64) {
	o.CloudIopsTotal = cloudIopsTotal
}

// WithCloudIopsWrite adds the cloudIopsWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudIopsWrite(cloudIopsWrite *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudIopsWrite(cloudIopsWrite)
	return o
}

// SetCloudIopsWrite adds the cloudIopsWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudIopsWrite(cloudIopsWrite *int64) {
	o.CloudIopsWrite = cloudIopsWrite
}

// WithCloudLatencyOther adds the cloudLatencyOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudLatencyOther(cloudLatencyOther *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudLatencyOther(cloudLatencyOther)
	return o
}

// SetCloudLatencyOther adds the cloudLatencyOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudLatencyOther(cloudLatencyOther *int64) {
	o.CloudLatencyOther = cloudLatencyOther
}

// WithCloudLatencyRead adds the cloudLatencyRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudLatencyRead(cloudLatencyRead *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudLatencyRead(cloudLatencyRead)
	return o
}

// SetCloudLatencyRead adds the cloudLatencyRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudLatencyRead(cloudLatencyRead *int64) {
	o.CloudLatencyRead = cloudLatencyRead
}

// WithCloudLatencyTotal adds the cloudLatencyTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudLatencyTotal(cloudLatencyTotal *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudLatencyTotal(cloudLatencyTotal)
	return o
}

// SetCloudLatencyTotal adds the cloudLatencyTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudLatencyTotal(cloudLatencyTotal *int64) {
	o.CloudLatencyTotal = cloudLatencyTotal
}

// WithCloudLatencyWrite adds the cloudLatencyWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudLatencyWrite(cloudLatencyWrite *int64) *VolumeMetricsCollectionGetParams {
	o.SetCloudLatencyWrite(cloudLatencyWrite)
	return o
}

// SetCloudLatencyWrite adds the cloudLatencyWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudLatencyWrite(cloudLatencyWrite *int64) {
	o.CloudLatencyWrite = cloudLatencyWrite
}

// WithCloudStatus adds the cloudStatus to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudStatus(cloudStatus *string) *VolumeMetricsCollectionGetParams {
	o.SetCloudStatus(cloudStatus)
	return o
}

// SetCloudStatus adds the cloudStatus to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudStatus(cloudStatus *string) {
	o.CloudStatus = cloudStatus
}

// WithCloudTimestamp adds the cloudTimestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithCloudTimestamp(cloudTimestamp *string) *VolumeMetricsCollectionGetParams {
	o.SetCloudTimestamp(cloudTimestamp)
	return o
}

// SetCloudTimestamp adds the cloudTimestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetCloudTimestamp(cloudTimestamp *string) {
	o.CloudTimestamp = cloudTimestamp
}

// WithDuration adds the duration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithDuration(duration *string) *VolumeMetricsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFields adds the fields to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFields(fields []string) *VolumeMetricsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFlexcacheBandwidthSavings adds the flexcacheBandwidthSavings to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFlexcacheBandwidthSavings(flexcacheBandwidthSavings *int64) *VolumeMetricsCollectionGetParams {
	o.SetFlexcacheBandwidthSavings(flexcacheBandwidthSavings)
	return o
}

// SetFlexcacheBandwidthSavings adds the flexcacheBandwidthSavings to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFlexcacheBandwidthSavings(flexcacheBandwidthSavings *int64) {
	o.FlexcacheBandwidthSavings = flexcacheBandwidthSavings
}

// WithFlexcacheCacheMissPercent adds the flexcacheCacheMissPercent to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFlexcacheCacheMissPercent(flexcacheCacheMissPercent *int64) *VolumeMetricsCollectionGetParams {
	o.SetFlexcacheCacheMissPercent(flexcacheCacheMissPercent)
	return o
}

// SetFlexcacheCacheMissPercent adds the flexcacheCacheMissPercent to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFlexcacheCacheMissPercent(flexcacheCacheMissPercent *int64) {
	o.FlexcacheCacheMissPercent = flexcacheCacheMissPercent
}

// WithFlexcacheDuration adds the flexcacheDuration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFlexcacheDuration(flexcacheDuration *string) *VolumeMetricsCollectionGetParams {
	o.SetFlexcacheDuration(flexcacheDuration)
	return o
}

// SetFlexcacheDuration adds the flexcacheDuration to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFlexcacheDuration(flexcacheDuration *string) {
	o.FlexcacheDuration = flexcacheDuration
}

// WithFlexcacheStatus adds the flexcacheStatus to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFlexcacheStatus(flexcacheStatus *string) *VolumeMetricsCollectionGetParams {
	o.SetFlexcacheStatus(flexcacheStatus)
	return o
}

// SetFlexcacheStatus adds the flexcacheStatus to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFlexcacheStatus(flexcacheStatus *string) {
	o.FlexcacheStatus = flexcacheStatus
}

// WithFlexcacheTimestamp adds the flexcacheTimestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithFlexcacheTimestamp(flexcacheTimestamp *string) *VolumeMetricsCollectionGetParams {
	o.SetFlexcacheTimestamp(flexcacheTimestamp)
	return o
}

// SetFlexcacheTimestamp adds the flexcacheTimestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetFlexcacheTimestamp(flexcacheTimestamp *string) {
	o.FlexcacheTimestamp = flexcacheTimestamp
}

// WithInterval adds the interval to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithInterval(interval *string) *VolumeMetricsCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithIopsOther adds the iopsOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithIopsOther(iopsOther *int64) *VolumeMetricsCollectionGetParams {
	o.SetIopsOther(iopsOther)
	return o
}

// SetIopsOther adds the iopsOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetIopsOther(iopsOther *int64) {
	o.IopsOther = iopsOther
}

// WithIopsRead adds the iopsRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithIopsRead(iopsRead *int64) *VolumeMetricsCollectionGetParams {
	o.SetIopsRead(iopsRead)
	return o
}

// SetIopsRead adds the iopsRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetIopsRead(iopsRead *int64) {
	o.IopsRead = iopsRead
}

// WithIopsTotal adds the iopsTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithIopsTotal(iopsTotal *int64) *VolumeMetricsCollectionGetParams {
	o.SetIopsTotal(iopsTotal)
	return o
}

// SetIopsTotal adds the iopsTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetIopsTotal(iopsTotal *int64) {
	o.IopsTotal = iopsTotal
}

// WithIopsWrite adds the iopsWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithIopsWrite(iopsWrite *int64) *VolumeMetricsCollectionGetParams {
	o.SetIopsWrite(iopsWrite)
	return o
}

// SetIopsWrite adds the iopsWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetIopsWrite(iopsWrite *int64) {
	o.IopsWrite = iopsWrite
}

// WithLatencyOther adds the latencyOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithLatencyOther(latencyOther *int64) *VolumeMetricsCollectionGetParams {
	o.SetLatencyOther(latencyOther)
	return o
}

// SetLatencyOther adds the latencyOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetLatencyOther(latencyOther *int64) {
	o.LatencyOther = latencyOther
}

// WithLatencyRead adds the latencyRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithLatencyRead(latencyRead *int64) *VolumeMetricsCollectionGetParams {
	o.SetLatencyRead(latencyRead)
	return o
}

// SetLatencyRead adds the latencyRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetLatencyRead(latencyRead *int64) {
	o.LatencyRead = latencyRead
}

// WithLatencyTotal adds the latencyTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithLatencyTotal(latencyTotal *int64) *VolumeMetricsCollectionGetParams {
	o.SetLatencyTotal(latencyTotal)
	return o
}

// SetLatencyTotal adds the latencyTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetLatencyTotal(latencyTotal *int64) {
	o.LatencyTotal = latencyTotal
}

// WithLatencyWrite adds the latencyWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithLatencyWrite(latencyWrite *int64) *VolumeMetricsCollectionGetParams {
	o.SetLatencyWrite(latencyWrite)
	return o
}

// SetLatencyWrite adds the latencyWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetLatencyWrite(latencyWrite *int64) {
	o.LatencyWrite = latencyWrite
}

// WithMaxRecords adds the maxRecords to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithMaxRecords(maxRecords *int64) *VolumeMetricsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithOrderBy(orderBy []string) *VolumeMetricsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithReturnRecords(returnRecords *bool) *VolumeMetricsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *VolumeMetricsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithStatus(status *string) *VolumeMetricsCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithThroughputOther adds the throughputOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithThroughputOther(throughputOther *int64) *VolumeMetricsCollectionGetParams {
	o.SetThroughputOther(throughputOther)
	return o
}

// SetThroughputOther adds the throughputOther to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetThroughputOther(throughputOther *int64) {
	o.ThroughputOther = throughputOther
}

// WithThroughputRead adds the throughputRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithThroughputRead(throughputRead *int64) *VolumeMetricsCollectionGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputTotal adds the throughputTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithThroughputTotal(throughputTotal *int64) *VolumeMetricsCollectionGetParams {
	o.SetThroughputTotal(throughputTotal)
	return o
}

// SetThroughputTotal adds the throughputTotal to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetThroughputTotal(throughputTotal *int64) {
	o.ThroughputTotal = throughputTotal
}

// WithThroughputWrite adds the throughputWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithThroughputWrite(throughputWrite *int64) *VolumeMetricsCollectionGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTimestamp adds the timestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithTimestamp(timestamp *string) *VolumeMetricsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithVolumeUUID adds the volumeUUID to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) WithVolumeUUID(volumeUUID string) *VolumeMetricsCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the volume metrics collection get params
func (o *VolumeMetricsCollectionGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeMetricsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CloudDuration != nil {

		// query param cloud.duration
		var qrCloudDuration string

		if o.CloudDuration != nil {
			qrCloudDuration = *o.CloudDuration
		}
		qCloudDuration := qrCloudDuration
		if qCloudDuration != "" {

			if err := r.SetQueryParam("cloud.duration", qCloudDuration); err != nil {
				return err
			}
		}
	}

	if o.CloudIopsOther != nil {

		// query param cloud.iops.other
		var qrCloudIopsOther int64

		if o.CloudIopsOther != nil {
			qrCloudIopsOther = *o.CloudIopsOther
		}
		qCloudIopsOther := swag.FormatInt64(qrCloudIopsOther)
		if qCloudIopsOther != "" {

			if err := r.SetQueryParam("cloud.iops.other", qCloudIopsOther); err != nil {
				return err
			}
		}
	}

	if o.CloudIopsRead != nil {

		// query param cloud.iops.read
		var qrCloudIopsRead int64

		if o.CloudIopsRead != nil {
			qrCloudIopsRead = *o.CloudIopsRead
		}
		qCloudIopsRead := swag.FormatInt64(qrCloudIopsRead)
		if qCloudIopsRead != "" {

			if err := r.SetQueryParam("cloud.iops.read", qCloudIopsRead); err != nil {
				return err
			}
		}
	}

	if o.CloudIopsTotal != nil {

		// query param cloud.iops.total
		var qrCloudIopsTotal int64

		if o.CloudIopsTotal != nil {
			qrCloudIopsTotal = *o.CloudIopsTotal
		}
		qCloudIopsTotal := swag.FormatInt64(qrCloudIopsTotal)
		if qCloudIopsTotal != "" {

			if err := r.SetQueryParam("cloud.iops.total", qCloudIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.CloudIopsWrite != nil {

		// query param cloud.iops.write
		var qrCloudIopsWrite int64

		if o.CloudIopsWrite != nil {
			qrCloudIopsWrite = *o.CloudIopsWrite
		}
		qCloudIopsWrite := swag.FormatInt64(qrCloudIopsWrite)
		if qCloudIopsWrite != "" {

			if err := r.SetQueryParam("cloud.iops.write", qCloudIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.CloudLatencyOther != nil {

		// query param cloud.latency.other
		var qrCloudLatencyOther int64

		if o.CloudLatencyOther != nil {
			qrCloudLatencyOther = *o.CloudLatencyOther
		}
		qCloudLatencyOther := swag.FormatInt64(qrCloudLatencyOther)
		if qCloudLatencyOther != "" {

			if err := r.SetQueryParam("cloud.latency.other", qCloudLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.CloudLatencyRead != nil {

		// query param cloud.latency.read
		var qrCloudLatencyRead int64

		if o.CloudLatencyRead != nil {
			qrCloudLatencyRead = *o.CloudLatencyRead
		}
		qCloudLatencyRead := swag.FormatInt64(qrCloudLatencyRead)
		if qCloudLatencyRead != "" {

			if err := r.SetQueryParam("cloud.latency.read", qCloudLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.CloudLatencyTotal != nil {

		// query param cloud.latency.total
		var qrCloudLatencyTotal int64

		if o.CloudLatencyTotal != nil {
			qrCloudLatencyTotal = *o.CloudLatencyTotal
		}
		qCloudLatencyTotal := swag.FormatInt64(qrCloudLatencyTotal)
		if qCloudLatencyTotal != "" {

			if err := r.SetQueryParam("cloud.latency.total", qCloudLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.CloudLatencyWrite != nil {

		// query param cloud.latency.write
		var qrCloudLatencyWrite int64

		if o.CloudLatencyWrite != nil {
			qrCloudLatencyWrite = *o.CloudLatencyWrite
		}
		qCloudLatencyWrite := swag.FormatInt64(qrCloudLatencyWrite)
		if qCloudLatencyWrite != "" {

			if err := r.SetQueryParam("cloud.latency.write", qCloudLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.CloudStatus != nil {

		// query param cloud.status
		var qrCloudStatus string

		if o.CloudStatus != nil {
			qrCloudStatus = *o.CloudStatus
		}
		qCloudStatus := qrCloudStatus
		if qCloudStatus != "" {

			if err := r.SetQueryParam("cloud.status", qCloudStatus); err != nil {
				return err
			}
		}
	}

	if o.CloudTimestamp != nil {

		// query param cloud.timestamp
		var qrCloudTimestamp string

		if o.CloudTimestamp != nil {
			qrCloudTimestamp = *o.CloudTimestamp
		}
		qCloudTimestamp := qrCloudTimestamp
		if qCloudTimestamp != "" {

			if err := r.SetQueryParam("cloud.timestamp", qCloudTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FlexcacheBandwidthSavings != nil {

		// query param flexcache.bandwidth_savings
		var qrFlexcacheBandwidthSavings int64

		if o.FlexcacheBandwidthSavings != nil {
			qrFlexcacheBandwidthSavings = *o.FlexcacheBandwidthSavings
		}
		qFlexcacheBandwidthSavings := swag.FormatInt64(qrFlexcacheBandwidthSavings)
		if qFlexcacheBandwidthSavings != "" {

			if err := r.SetQueryParam("flexcache.bandwidth_savings", qFlexcacheBandwidthSavings); err != nil {
				return err
			}
		}
	}

	if o.FlexcacheCacheMissPercent != nil {

		// query param flexcache.cache_miss_percent
		var qrFlexcacheCacheMissPercent int64

		if o.FlexcacheCacheMissPercent != nil {
			qrFlexcacheCacheMissPercent = *o.FlexcacheCacheMissPercent
		}
		qFlexcacheCacheMissPercent := swag.FormatInt64(qrFlexcacheCacheMissPercent)
		if qFlexcacheCacheMissPercent != "" {

			if err := r.SetQueryParam("flexcache.cache_miss_percent", qFlexcacheCacheMissPercent); err != nil {
				return err
			}
		}
	}

	if o.FlexcacheDuration != nil {

		// query param flexcache.duration
		var qrFlexcacheDuration string

		if o.FlexcacheDuration != nil {
			qrFlexcacheDuration = *o.FlexcacheDuration
		}
		qFlexcacheDuration := qrFlexcacheDuration
		if qFlexcacheDuration != "" {

			if err := r.SetQueryParam("flexcache.duration", qFlexcacheDuration); err != nil {
				return err
			}
		}
	}

	if o.FlexcacheStatus != nil {

		// query param flexcache.status
		var qrFlexcacheStatus string

		if o.FlexcacheStatus != nil {
			qrFlexcacheStatus = *o.FlexcacheStatus
		}
		qFlexcacheStatus := qrFlexcacheStatus
		if qFlexcacheStatus != "" {

			if err := r.SetQueryParam("flexcache.status", qFlexcacheStatus); err != nil {
				return err
			}
		}
	}

	if o.FlexcacheTimestamp != nil {

		// query param flexcache.timestamp
		var qrFlexcacheTimestamp string

		if o.FlexcacheTimestamp != nil {
			qrFlexcacheTimestamp = *o.FlexcacheTimestamp
		}
		qFlexcacheTimestamp := qrFlexcacheTimestamp
		if qFlexcacheTimestamp != "" {

			if err := r.SetQueryParam("flexcache.timestamp", qFlexcacheTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.IopsOther != nil {

		// query param iops.other
		var qrIopsOther int64

		if o.IopsOther != nil {
			qrIopsOther = *o.IopsOther
		}
		qIopsOther := swag.FormatInt64(qrIopsOther)
		if qIopsOther != "" {

			if err := r.SetQueryParam("iops.other", qIopsOther); err != nil {
				return err
			}
		}
	}

	if o.IopsRead != nil {

		// query param iops.read
		var qrIopsRead int64

		if o.IopsRead != nil {
			qrIopsRead = *o.IopsRead
		}
		qIopsRead := swag.FormatInt64(qrIopsRead)
		if qIopsRead != "" {

			if err := r.SetQueryParam("iops.read", qIopsRead); err != nil {
				return err
			}
		}
	}

	if o.IopsTotal != nil {

		// query param iops.total
		var qrIopsTotal int64

		if o.IopsTotal != nil {
			qrIopsTotal = *o.IopsTotal
		}
		qIopsTotal := swag.FormatInt64(qrIopsTotal)
		if qIopsTotal != "" {

			if err := r.SetQueryParam("iops.total", qIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.IopsWrite != nil {

		// query param iops.write
		var qrIopsWrite int64

		if o.IopsWrite != nil {
			qrIopsWrite = *o.IopsWrite
		}
		qIopsWrite := swag.FormatInt64(qrIopsWrite)
		if qIopsWrite != "" {

			if err := r.SetQueryParam("iops.write", qIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.LatencyOther != nil {

		// query param latency.other
		var qrLatencyOther int64

		if o.LatencyOther != nil {
			qrLatencyOther = *o.LatencyOther
		}
		qLatencyOther := swag.FormatInt64(qrLatencyOther)
		if qLatencyOther != "" {

			if err := r.SetQueryParam("latency.other", qLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.LatencyRead != nil {

		// query param latency.read
		var qrLatencyRead int64

		if o.LatencyRead != nil {
			qrLatencyRead = *o.LatencyRead
		}
		qLatencyRead := swag.FormatInt64(qrLatencyRead)
		if qLatencyRead != "" {

			if err := r.SetQueryParam("latency.read", qLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.LatencyTotal != nil {

		// query param latency.total
		var qrLatencyTotal int64

		if o.LatencyTotal != nil {
			qrLatencyTotal = *o.LatencyTotal
		}
		qLatencyTotal := swag.FormatInt64(qrLatencyTotal)
		if qLatencyTotal != "" {

			if err := r.SetQueryParam("latency.total", qLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.LatencyWrite != nil {

		// query param latency.write
		var qrLatencyWrite int64

		if o.LatencyWrite != nil {
			qrLatencyWrite = *o.LatencyWrite
		}
		qLatencyWrite := swag.FormatInt64(qrLatencyWrite)
		if qLatencyWrite != "" {

			if err := r.SetQueryParam("latency.write", qLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.ThroughputOther != nil {

		// query param throughput.other
		var qrThroughputOther int64

		if o.ThroughputOther != nil {
			qrThroughputOther = *o.ThroughputOther
		}
		qThroughputOther := swag.FormatInt64(qrThroughputOther)
		if qThroughputOther != "" {

			if err := r.SetQueryParam("throughput.other", qThroughputOther); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputTotal != nil {

		// query param throughput.total
		var qrThroughputTotal int64

		if o.ThroughputTotal != nil {
			qrThroughputTotal = *o.ThroughputTotal
		}
		qThroughputTotal := swag.FormatInt64(qrThroughputTotal)
		if qThroughputTotal != "" {

			if err := r.SetQueryParam("throughput.total", qThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVolumeMetricsCollectionGet binds the parameter fields
func (o *VolumeMetricsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamVolumeMetricsCollectionGet binds the parameter order_by
func (o *VolumeMetricsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
