// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeMetricsCollectionGetReader is a Reader for the VolumeMetricsCollectionGet structure.
type VolumeMetricsCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeMetricsCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeMetricsCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeMetricsCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeMetricsCollectionGetOK creates a VolumeMetricsCollectionGetOK with default headers values
func NewVolumeMetricsCollectionGetOK() *VolumeMetricsCollectionGetOK {
	return &VolumeMetricsCollectionGetOK{}
}

/*
VolumeMetricsCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type VolumeMetricsCollectionGetOK struct {
	Payload *models.VolumeMetricsResponse
}

// IsSuccess returns true when this volume metrics collection get o k response has a 2xx status code
func (o *VolumeMetricsCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume metrics collection get o k response has a 3xx status code
func (o *VolumeMetricsCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume metrics collection get o k response has a 4xx status code
func (o *VolumeMetricsCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume metrics collection get o k response has a 5xx status code
func (o *VolumeMetricsCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume metrics collection get o k response a status code equal to that given
func (o *VolumeMetricsCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume metrics collection get o k response
func (o *VolumeMetricsCollectionGetOK) Code() int {
	return 200
}

func (o *VolumeMetricsCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/metrics][%d] volumeMetricsCollectionGetOK %s", 200, payload)
}

func (o *VolumeMetricsCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/metrics][%d] volumeMetricsCollectionGetOK %s", 200, payload)
}

func (o *VolumeMetricsCollectionGetOK) GetPayload() *models.VolumeMetricsResponse {
	return o.Payload
}

func (o *VolumeMetricsCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeMetricsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeMetricsCollectionGetDefault creates a VolumeMetricsCollectionGetDefault with default headers values
func NewVolumeMetricsCollectionGetDefault(code int) *VolumeMetricsCollectionGetDefault {
	return &VolumeMetricsCollectionGetDefault{
		_statusCode: code,
	}
}

/*
VolumeMetricsCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type VolumeMetricsCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume metrics collection get default response has a 2xx status code
func (o *VolumeMetricsCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume metrics collection get default response has a 3xx status code
func (o *VolumeMetricsCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume metrics collection get default response has a 4xx status code
func (o *VolumeMetricsCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume metrics collection get default response has a 5xx status code
func (o *VolumeMetricsCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume metrics collection get default response a status code equal to that given
func (o *VolumeMetricsCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume metrics collection get default response
func (o *VolumeMetricsCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *VolumeMetricsCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/metrics][%d] volume_metrics_collection_get default %s", o._statusCode, payload)
}

func (o *VolumeMetricsCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/metrics][%d] volume_metrics_collection_get default %s", o._statusCode, payload)
}

func (o *VolumeMetricsCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeMetricsCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
