// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VolumeModifyCollectionReader is a Reader for the VolumeModifyCollection structure.
type VolumeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewVolumeModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVolumeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVolumeModifyCollectionOK creates a VolumeModifyCollectionOK with default headers values
func NewVolumeModifyCollectionOK() *VolumeModifyCollectionOK {
	return &VolumeModifyCollectionOK{}
}

/*
VolumeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VolumeModifyCollectionOK struct {
	Payload *models.VolumeJobLinkResponse
}

// IsSuccess returns true when this volume modify collection o k response has a 2xx status code
func (o *VolumeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume modify collection o k response has a 3xx status code
func (o *VolumeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume modify collection o k response has a 4xx status code
func (o *VolumeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume modify collection o k response has a 5xx status code
func (o *VolumeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume modify collection o k response a status code equal to that given
func (o *VolumeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the volume modify collection o k response
func (o *VolumeModifyCollectionOK) Code() int {
	return 200
}

func (o *VolumeModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volumeModifyCollectionOK %s", 200, payload)
}

func (o *VolumeModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volumeModifyCollectionOK %s", 200, payload)
}

func (o *VolumeModifyCollectionOK) GetPayload() *models.VolumeJobLinkResponse {
	return o.Payload
}

func (o *VolumeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeModifyCollectionAccepted creates a VolumeModifyCollectionAccepted with default headers values
func NewVolumeModifyCollectionAccepted() *VolumeModifyCollectionAccepted {
	return &VolumeModifyCollectionAccepted{}
}

/*
VolumeModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type VolumeModifyCollectionAccepted struct {
	Payload *models.VolumeJobLinkResponse
}

// IsSuccess returns true when this volume modify collection accepted response has a 2xx status code
func (o *VolumeModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume modify collection accepted response has a 3xx status code
func (o *VolumeModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume modify collection accepted response has a 4xx status code
func (o *VolumeModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume modify collection accepted response has a 5xx status code
func (o *VolumeModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this volume modify collection accepted response a status code equal to that given
func (o *VolumeModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the volume modify collection accepted response
func (o *VolumeModifyCollectionAccepted) Code() int {
	return 202
}

func (o *VolumeModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volumeModifyCollectionAccepted %s", 202, payload)
}

func (o *VolumeModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volumeModifyCollectionAccepted %s", 202, payload)
}

func (o *VolumeModifyCollectionAccepted) GetPayload() *models.VolumeJobLinkResponse {
	return o.Payload
}

func (o *VolumeModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VolumeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeModifyCollectionDefault creates a VolumeModifyCollectionDefault with default headers values
func NewVolumeModifyCollectionDefault(code int) *VolumeModifyCollectionDefault {
	return &VolumeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	VolumeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262256 | Tags cannot be modified for the volume because of the specified reason. |
| 524511 | Failed to restore snapshot \"restore_to.snapshot.name\". |
| 524849 | Attribute cannot be modified for the target volume because of the specified reason.<personalities supports=unified> |
| 787141 | The specified \"aggregates.name\" and \"aggregates.uuid\" refer to different aggregates. |
| 787144 | The volume is on an aggregate that is not part of a FabricPool. |
| 917505 | SVM not found. |
| 917534 | The value specified for field \"-size\" is too small. Update the field \"-size\" with the minimum size allowed and retry. |
| 917597 | Provisioning a volume on a root aggregate is not supported. |
| 917617 | Cannot modify snapshot policy on volumes of type DC, DP, LS or TMP. |
| 917628 | Modification of the specified fields is not allowed for the target volume type. |
| 917829 | Volume autosize grow threshold must be larger than autosize shrink threshold. |
| 917831 | Volume minimum autosize must be smaller than the maximum autosize. |
| 917888 | Invalid character in volume name. It can have '_' and alphanumeric characters.; |
| 918183 | The specified tiering policy is not supported for the current system configuration. |
| 918193 | Cannot modify tiering min cooling days when vol move is in progress.</personalities> |
| 918194 | Tiering min cooling days not supported for SVMDR.<personalities supports=unified> |
| 918195 | Tiering min cooling days not supported for non data volumes. |
| 918196 | Tiering min cooling days not allowed for the provided tiering policy. |
| 918248 | Specifying a value is not valid for initiating volume FlexClone split operation. |
| 918251 | Specifying a value is not valid for a snapshot restore operation. |
| 918252 | specified \"nas.path\" is invalid. |
| 918265 | Volume is on the same aggregate. |
| 918266 | \"movement.destination_aggregate\" and \"movement.state\" are mutually exclusive, unless the state is \"cutover-wait\". |
| 918267 | The specified \"movement.destination_aggregate\" does not exist.</personalities> |
| 918291 | Invalid volume cloud retrieval policy for the provided tiering policy. |
| 918292 | cloud retrieval policy not supported for non data volume.<personalities supports=unified> |
| 918293 | Cannot modify cloud retrieval policy when vol move is in progress.</personalities> |
| 918334 | Cache cloud retrieval policy requires an effective cluster version of 9.14 or later. |
| 918521 | The volume maximum autosize must be smaller than or equal to the maximum volume size. |
| 918532 | The FlexClone match-parent-storage-tier option requires an effective cluster version of 9.9.1 or later. |
| 918533 | The FlexClone match-parent-storage-tier option not applicable for FlexClone volumes hosted on non-FabricPool storage. |
| 918534 | The tiering policy values are different for the FlexClone volume and its parent volume. The match-parent-storage-tier option cannot be set to true. |
| 918535 | The tiering minimum cooling day values are different for the FlexClone volume and its parent volume. The match-parent-storage-tier option cannot be set to true. |
| 918537 | Could not get the FlexClone volume tiering policy or its parent volume tiering policy. Wait a minute and try again. |
| 918538 | The match-parent-storage-tier option is not supported for clone creation. |
| 918577 | Only FlexVol to FlexGroup conversions are currently supported. |
| 918583 | Disabling large volume size is not supported because the volume contains files larger than 16TB or the volume size is larger than 100TB. |
| 918599 | Cloud write requires an effective cluster version of 9.13.1 or later. |
| 918600 | Cloud write is only supported for volumes in a FabricPool on FSx for ONTAP or Cloud Volumes ONTAP. |
| 918601 | Only the \\\"all\\\" tiering policy is allowed on a volume with cloud write.<personalities supports=unified> |
| 918602 | Cannot move volume when cloud write is enabled.</personalities> |
| 918603 | Cloud write is only supported on volumes with Read-Write access. |
| 918604 | Cloud write is not supported because the volume is the destination or source endpoint of one or more SnapMirror relationships. |
| 918605 | Cloud write cannot be enabled on a clone volume. |
| 918606 | Cloud write cannot be enabled on a volume containing LUNs. |
| 918607 | Cloud write is not supported because this volume belongs to an SVM that is the source of a DR relationship. |
| 918624 | Tiering storage class requires an effective cluster version of ONTAP 9.13.1 or later. |
| 918625 | Tiering storage class is only supported for volumes in a FabricPool on FSx for ONTAP or Cloud Volumes ONTAP for AWS. |
| 918626 | Tiering storage class is not supported for volumes in a FlexGroup. |
| 918627 | The specified value for \"tiering.storage_class\" is not supported. |
| 918636 | Volume \"name\" in SVM \"svm.name\" is part of a Consistency Group. Snapshot locking cannot be enabled on a volume that is part of a Consistency Group. |
| 918639 | One or more of the fields \"-max-size\",\"-max-autosize\",\"-size\" are being set or modified. Set the values so that \"-max-size\" is always greater than or equal to \"-max-autosize\" and \"-size\". |
| 918641 | The value passed for \"-max-size\" is invalid. Valid values for the current platform are specified. |
| 918647 | One or more of the fields \"-max-autosize\",\"-size\" are being set or modified. Set the values so that \"-max-autosize\" and \"-size\" are always less than or equal to the specified value. |
| 918650 | The asynchronous directory delete trash bin name cannot be specified unless asynchronous directory delete from the client is being enabled. |
| 918652 | \"error\" is an invalid value for field \"-state\". Valid values are \"online\", \"offline\" and \"restricted\". |
| 918655 | Cloud write is not supported on the current configuration. |
| 918658 | Volume is on a FabricPool-enabled aggregate. CIFS applications might time out when cloud write is enabled on a volume that is on a FabricPool-enabled aggregate. |
| 918659 | Cloud write can only be enabled on FabricPool-enabled aggregates.<personalities supports=unified> |
| 918660 | Cloud write enabled volumes can only be moved to FabricPool-enabled aggregates. Disable cloud write to move the volume to a non-FabricPool aggregates.</personalities> |
| 918703 | Modification of the specified volume properties are not supported on this platform. |
| 918775 | The \"constituent_count\" parameter must be greater than the current number of constituents in the FlexGroup volume. |
| 918776 | The \"constituent_count\" and \"size\" parameters cannot both be specified. |
| 918777 | The \"aggregates\" parameter cannot contain both storage pods and aggregates. |
| 918786 | The specified value for the \"movement.state\" parameter is invalid. Valid values are \"replicating\", \"cutover\", \"aborted\", \"paused\" and \"cutover_wait\". |
| 1638480 | Failed to promote snapshot \"restore_to.snapshot.name\" because one or more newer snapshots are currently used as a reference snapshot for data protection operations. |
| 1638590 | Promoting a \"-pre-conversion\" snapshot is not supported. |
| 2424998 | Unable to determine whether MetroCluster is configured. |
| 2621572 | Modification of the specified field is not permitted on an SVM that is configured as the destination for identity discard SVM DR. |
| 6488103 | Async directory delete from the client is already enabled on volume \"name\" in SVM \"svm.name\". |
| 6488104 | Async directory delete from the client is already disabled on volume \"name\" in SVM \"svm.name\". |
| 6881612 | Cannot enable inline deduplication on a non AFF Platform or on non HYA aggregate. |
| 6881640 | The \"efficiency.state\" field is only supported on read-write volumes on FSx for ONTAP and Cloud Volumes ONTAP. |
| 6881651 | File compression is not supported on volumes with \"max-size > 300TB\". Modify the volume max-size, then retry. |
| 6881659 | Changing \"storage-efficiency-mode\" from \"efficient\" to \"default\" is not supported. |
| 6881661 | Volume efficiency scanner cannot be started on volume with efficiency policy set as inline-only. |
| 8454210 | Failed to complete the operation because a QoS workload could not be created, modified or deleted. Wait a few seconds, and then try the operation again. |
| 9437885 | The volume is not online. |
| 9437886 | Volume snapshot restore failed because there are newer unexpired locked snapshots in the volume. |
| 13107256 | Operation is only supported on FlexGroup volumes. |
| 13107349 | Operation is only supported on flexible volumes and FlexGroup volumes. |
| 13107371 | Operation is only supported on read-write FlexGroup volumes. |
| 13107404 | When adding new resources to a FlexGroup by specifying \"aggregates.name\" or \"aggregates.uuid\", the FlexGroup cannot be resized using \"size\". These operations must be done separately. |
| 13107415 | Failed to lookup a volume property. |
| 13107431 | Failed to lookup an SVM property. |
| 13107433 | A snapshot is scheduled to be taken within the volume capacity rebalancing runtime. |
| 13107434 | A SnapMirror update is scheduled within the volume capacity rebalancing runtime. |
| 13109187 | When adding new resources to a FlexGroup using \"sizing_method\", \"size\" must be specified.  Neither \"aggregates.name\" nor \"aggregates.uuid\" are allowed to be specified, as the aggregates are selected automatically by the system. |
| 13109198 | Resizing by adding new resources is only supported for FlexGroups. |
| 13109258 | Cannot enable granular data on volume \"name\" in Vserver \"svm.name\". This setting can only be enabled on FlexGroups. |
| 13109259 | Granular data cannot be disabled on volume \"name\" in Vserver \"svm.name\". This property can only be disabled by restoring a snapshot. |
| 13109260 | Failed to enable granular data on the volume. |
| 13763477 | Cannot modify the SnapLock configuration on volume "name" in SVM "svm.name" because the volume is a part of a consistency group. |
| 65536965 | The key manager on data Vserver \\\"{0}\\\" is in the blocked state due to key access errors. Possible reasons for a blocked state include the top-level external key protection key is disabled or not found or the current user does not have access to perform the requested action. Fix the issues with the key manager that manages the top-level external key protection key on data Vserver \\\"{0}\\\" to bring the key manager to the active state and then try to bring the volume online again. |
| 65539432 | Cannot online volume \\\"{1}\\\" on Vserver \\\"{0}\\\" while the keystore is being initialized. Wait until the keystore is in the active state, and rerun the volume operation. |
| 65539433 | Cannot online volume \\\"{1}\\\" on Vserver \\\"{0}\\\" while the keystore is being disabled. |
| 66846758 | Modification of the specified fields is not allowed for FlexCache volumes. |
| 66846772 | Modification of the specified fields is not allowed for origin of FlexCache volumes. |
| 111411201 | File system analytics cannot be enabled on the target volume because of the specified reason. |
| 111411202 | File system analytics cannot be disabled on the target volume because of the specified reason. |
| 111411205 | File system analytics requires an effective cluster version of 9.8 or later. |
| 111411206 | The specified \"analytics.state\" is invalid. |
| 111411207 | File system analytics cannot be enabled on volumes that contain LUNs. |
| 111411207 | Volume file system analytics is not supported on volumes that contain LUNs. |
| 111411209 | Volume file system analytics is not supported on FlexCache volumes. |
| 111411210 | Volume file system analytics is not supported on audit staging volumes. |
| 111411211 | Volume file system analytics is not supported on object store server volumes. |
| 111411212 | Volume file system analytics is not supported on SnapMirror destination volumes. |
| 111411216 | Enabling or disabling volume file system analytics is not supported on individual FlexGroup constituents. |
| 111411217 | Volume file system analytics is not supported on SnapLock volumes. |
| 111411230 | Volume file system analytics is not supported on volumes that contain NVMe namespaces. |
| 111411241 | Volume file system analytics is not supported for All SAN Array clusters. |
| 111411252 | Failed to enable file system analytics on volume \"name\" in SVM \"svm.name\" because there is insufficient available space. Ensure there is at least \"space.available_percent`\" available space in the volume, then try the operation again. |
| 111411253 | Failed to enable file system analytics on volume \"name\" in SVM \"svm.name\" because there is insufficient available space. Ensure there is at least \"space.available_percent\" available space in all constituents of the FlexGroup, then try the operation again." |
| 111411257 | Failed to enable file system analytics on volume \"name\" in SVM \"svm.name\" because there is insufficient available space. Increase the volume size to \"size\", then try the operation again." |
| 124518405 | Volume activity tracking is not supported on volumes that contain LUNs. |
| 124518407 | Volume activity tracking is not supported on FlexCache volumes. |
| 124518408 | Volume activity tracking is not supported on audit staging volumes. |
| 124518409 | Volume activity tracking is not supported on object store server volumes. |
| 124518410 | Volume activity tracking is not supported on SnapMirror destination volumes. |
| 124518411 | Enabling or disabling volume activity tracking is not supported on individual FlexGroup constituents. |
| 124518412 | Volume activity tracking is not supported on SnapLock volumes. |
| 124518414 | Volume activity tracking is not supported on volumes that contain NVMe namespaces. |
| 124518422 | Volume activity tracking is not supported on All SAN Array clusters. |
| 144180203 | Volume capacity rebalancing is not supported on FlexCache volumes. |
| 144180204 | Volume capacity rebalancing is not supported on object store volumes. |
| 144180207 | Volume capacity rebalancing is not supported on inactive MetroCluster configurations. |
| 144182201 | Volume capacity rebalancing using non-disruptive file move operations and granular data requires an effective cluster version of 9.11.1 or later. |
| 144182203 | The specified value for the \"rebalancing.state\" parameter is invalid for a PATCH operation. Valid values are \"starting\" and \"stopping\". |
| 144182207 | Modifying the volume capacity rebalancing configuration is not supported in the same operation that volume capacity rebalancing is being stopped. |
| 144182211 | The specified value for \"-max-file-moves\" is not valid. |
| 144182212 | The \"-min-file-size\" value specified must be larger than 0. |
| 144182213 | The \"-min-threshold\" value specified must be larger than 0. |
| 144182214 | The \"-max-threshold\" value specified must be larger than 0. |
| 144182215 | The maximum imbalance threshold value must be larger than the minimum imbalance threshold value. |
| 144182216 | Volume capacity rebalancing is running on the volume. |
| 144182219 | Volume capacity rebalancing for the volume has been started on some constituents. |
| 144182221 | The \"-max-runtime\" value specified must be 30 minutes or longer. |
| 144182223 | Volume capacity rebalancing is not running on the volume. |
| 144182225 | Internal error in the data component. |
| 144182226 | Failed to load the volume capacity rebalancing configuration for the volume. |
| 144182233 | The specified rebalancing start time must be set to the current time or a later time. |
| 144182235 | The \"-min-file-size\" value specified must be larger than or equal to 20MB. |
| 144182238 | Volume capacity rebalancing is running on the volume. |
| 196608022 | Failed to start rekey on volume \"name\" in SVM \"svm.name\" because of the specified reason. |
| 196608023 | Failed to pause rekey on volume \"name\" because of the specified reason. |
| 196608024 | Failed to resume rekey on volume \"name\" because of the specified reason. |
| 196608038 | Failed to start conversion on volume \"name\" in SVM \"svm.name\" because of the specified reason. |
| 196608039 | Failed to pause conversion on volume \"name\" because of the specified reason. |
| 196608041 | Failed to resume conversion on volume \"name\" because of the specified reason. |
| 196608207 | Rekey operation is already in progress on volume \"name\". |
| 196608208 | Encryption conversion operation is already in progress on volume \"name\". |
| 196608209 | Operation is already paused. |
| 203161623 | Disabling anti-ransomware for volume \"volume_name\" in SVM \"vserver_name\" is in progress. Wait a few minutes, and try the operation again. |
| 203161629 | Anti-ransomware is not supported on a volume with Snapshot autodelete commitment set to \"destroy\". |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VolumeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this volume modify collection default response has a 2xx status code
func (o *VolumeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this volume modify collection default response has a 3xx status code
func (o *VolumeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this volume modify collection default response has a 4xx status code
func (o *VolumeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this volume modify collection default response has a 5xx status code
func (o *VolumeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this volume modify collection default response a status code equal to that given
func (o *VolumeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the volume modify collection default response
func (o *VolumeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VolumeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volume_modify_collection default %s", o._statusCode, payload)
}

func (o *VolumeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes][%d] volume_modify_collection default %s", o._statusCode, payload)
}

func (o *VolumeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VolumeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeModifyCollectionBody volume modify collection body
swagger:model VolumeModifyCollectionBody
*/
type VolumeModifyCollectionBody struct {

	// links
	Links *models.VolumeInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not access time updates are enabled on the volume.
	AccessTimeEnabled *bool `json:"access_time_enabled,omitempty"`

	// activity tracking
	ActivityTracking *models.VolumeInlineActivityTracking `json:"activity_tracking,omitempty"`

	// Specifies the `aggressive_readahead_mode` enabled on the volume. When set to _file_prefetch_, on a file read, the system aggressively issues readaheads for all of the blocks in the file and retains those blocks in a cache for a finite period of time. When the option is set to _sequential_read_, the system aggressively prefetches the file completely, or to a certain length based on the file size limit, and continues as the read makes progress. If the option is set to _cross_file_sequential_read_, then the system aggressively prefetches multiple files completely, or to a certain length, and continues as the read makes progress.
	// Enum: ["none","file_prefetch","sequential_read","cross_file_sequential_read"]
	AggressiveReadaheadMode *string `json:"aggressive_readahead_mode,omitempty"`

	// analytics
	Analytics *models.VolumeInlineAnalytics `json:"analytics,omitempty"`

	// anti ransomware
	AntiRansomware *models.VolumeInlineAntiRansomware `json:"anti_ransomware,omitempty"`

	// application
	Application *models.VolumeInlineApplication `json:"application,omitempty"`

	// asynchronous directory delete
	AsynchronousDirectoryDelete *models.VolumeInlineAsynchronousDirectoryDelete `json:"asynchronous_directory_delete,omitempty"`

	// autosize
	Autosize *models.VolumeInlineAutosize `json:"autosize,omitempty"`

	// clone
	Clone *models.VolumeInlineClone `json:"clone,omitempty"`

	// This parameter specifies the cloud retrieval policy for the volume. This policy determines which tiered out blocks to retrieve from the capacity tier to the performance tier. The available cloud retrieval policies are
	// "default" policy retrieves tiered data based on the underlying tiering policy. If the tiering policy is 'auto', tiered data is retrieved only for random client driven data reads. If the tiering policy is 'none' or 'snapshot_only', tiered data is retrieved for random and sequential client driven data reads. If the tiering policy is 'all', tiered data is not retrieved.
	// "on_read" policy retrieves tiered data for all client driven data reads.
	// "never" policy never retrieves tiered data.
	// "promote" policy retrieves all eligible tiered data automatically during the next scheduled scan. It is only supported when the tiering policy is 'none' or 'snapshot_only'. If the tiering policy is 'snapshot_only', the only data brought back is the data in the AFS. Data that is only in a snapshot copy stays in the cloud and if tiering policy is 'none' then all data is retrieved.
	//
	// Enum: ["default","on_read","never","promote"]
	CloudRetrievalPolicy *string `json:"cloud_retrieval_policy,omitempty"`

	// Indicates whether or not cloud writes are enabled on the volume. NFS writes to this volume are sent to the cloud directly instead of the local performance tier.
	// This feature is only available on volumes in FabricPools.
	//
	CloudWriteEnabled *bool `json:"cloud_write_enabled,omitempty"`

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *models.VolumeInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// Specifies the number of total constituents in the FlexGroup volume. Valid for POST, PATCH and GET requests. In volume create (POST), you can alternatively specify the number of constituents in the constituents_per_aggregate parameter and specify the storage availability zone in the aggregates parameter. If none of these values are specified, ONTAP determines the number of constituents to create based on the size of the FlexGroup volume.
	// Minimum: 1
	ConstituentCount *int64 `json:"constituent_count,omitempty"`

	// <personalities supports=unified,asar2>
	// Specifies the number of times to iterate over the aggregates listed with the "aggregates.name" or "aggregates.uuid" when creating or expanding a FlexGroup volume. If a volume is being created on a single aggregate, the system creates a flexible volume if the "constituents_per_aggregate" field is not specified, or a FlexGroup volume if it is specified. If a volume is being created on multiple aggregates, the system always creates a FlexGroup volume. If a volume is being created on multiple aggregates and the "constituents_per_aggregate" field is not specified, the default value of the "constituents_per_aggregate" field is 4. The root constituent of a FlexGroup volume is always placed on the first aggregate in the list, unless 'optimize_aggregates' is specified as 'true'. If the "aggregates.name" or "aggregates.uuid" is specified in a PATCH request to expand an existing FlexGroup volume, the default value of the "constituents_per_aggregate" field is 1. The volume expand operation is only supported on FlexGroup volumes.
	// </personalities>
	// <personalities supports=aiml>
	// Optional. Only supported in volume create (POST), and specifies how many constituents the FlexGroup volume should have. If supplied, the aggregates must also be supplied, and it must contain only the storage availability zone. Provided for backward-compatibility only. Using constituent_count instead of it and aggregates is always preferred.
	// </personalities>
	//
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// Specifies whether directory Unicode format conversion is enabled when directories are accessed by NFS clients.
	ConvertUnicode *bool `json:"convert_unicode,omitempty"`

	// Creation time of the volume. This field is generated when the volume is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// efficiency
	Efficiency *models.VolumeInlineEfficiency `json:"efficiency,omitempty"`

	// encryption
	Encryption *models.VolumeInlineEncryption `json:"encryption,omitempty"`

	// error state
	ErrorState *models.VolumeInlineErrorState `json:"error_state,omitempty"`

	// files
	Files *models.VolumeInlineFiles `json:"files,omitempty"`

	// flash pool
	FlashPool *models.VolumeInlineFlashPool `json:"flash_pool,omitempty"`

	// FlexCache endpoint type. <br>none &dash; The volume is neither a FlexCache nor origin of any FlexCache. <br>cache &dash; The volume is a FlexCache volume. <br>origin &dash; The volume is origin of a FlexCache volume.
	// Read Only: true
	// Enum: ["none","cache","origin"]
	FlexcacheEndpointType *string `json:"flexcache_endpoint_type,omitempty"`

	// flexgroup
	Flexgroup *models.VolumeInlineFlexgroup `json:"flexgroup,omitempty"`

	// State of granular data on the volume. This setting is `true` by default when creating an AWS S3 FlexGroup volume via a POST request and `false` by default for creating any other type of FlexGroup volume via a POST request. On FlexVol volumes, the setting is always `false`, as only FlexGroup volumes support this feature. Once enabled, this setting can only be disabled by restoring a snapshot. Earlier versions of ONTAP (pre 9.12) are not compatible with this feature. Therefore, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the setting was enabled.
	GranularData *bool `json:"granular_data,omitempty"`

	// Mode of granular data on the volume. This setting defaults to `basic` when the `granular_data` parameter is set to `true`, but can be specified at the time of creation via a POST request. Earlier versions of ONTAP (pre 9.12) are not compatible with the `basic` setting. Therefore, when set to `basic`, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the `basic` mode was enabled. Earlier versions of ONTAP (pre 9.16) are not compatible with the `advanced` setting. Therefore, when set to `advanced`, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the `advanced` mode was enabled.
	// Enum: ["disabled","basic","advanced"]
	GranularDataMode *string `json:"granular_data_mode,omitempty"`

	// guarantee
	Guarantee *models.VolumeInlineGuarantee `json:"guarantee,omitempty"`

	// Specifies whether the volume has directories with public index files.
	HasDirIndexPublic *bool `json:"has_dir_index_public,omitempty"`

	// Specifies whether the volume has directories bigger than 4GB.
	HasLargeDir *bool `json:"has_large_dir,omitempty"`

	// When set to true, this field enables support for directory index transfer.
	IsDirIndexTransferEnabled *bool `json:"is_dir_index_transfer_enabled,omitempty"`

	// When set to true, this field enables the large directory feature on a volume.
	IsLargeDirEnabled *bool `json:"is_large_dir_enabled,omitempty"`

	// Specifies whether the volume is provisioned for an object store server.
	// Read Only: true
	IsObjectStore *bool `json:"is_object_store,omitempty"`

	// Specifies that the volume should allow Amazon S3 multipart uploads with arbitrary part lengths. This is only supported for FlexGroup volumes with `advanced` granular_data. The default value is `false`. When set to `true`, it cannot be reverted to `false`. Clusters with any volumes where this is `true` cannot be reverted to a release that does not support this feature.
	IsS3ArbitraryPartSizeEnabled *bool `json:"is_s3_arbitrary_part_size_enabled,omitempty"`

	// Specifies whether the volume is a root volume of the SVM it belongs to.
	// Read Only: true
	IsSvmRoot *bool `json:"is_svm_root,omitempty"`

	// Language encoding setting for volume. If no language is specified, the volume inherits its SVM language encoding setting.
	// Enum: ["ar","ar.utf_8","c","c.utf_8","cs","cs.utf_8","da","da.utf_8","de","de.utf_8","en","en.utf_8","en_us","en_us.utf_8","es","es.utf_8","fi","fi.utf_8","fr","fr.utf_8","he","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it","it.utf_8","ja","ja.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck","ja_jp.pck.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ja_v1","ja_v1.utf_8","ko","ko.utf_8","nl","nl.utf_8","no","no.utf_8","pl","pl.utf_8","pt","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv","sv.utf_8","tr","tr.utf_8","utf8mb4","zh","zh.gbk","zh.gbk.utf_8","zh.utf_8","zh_tw","zh_tw.big5","zh_tw.big5.utf_8","zh_tw.utf_8"]
	Language *string `json:"language,omitempty"`

	// Maximum directory size. This value sets maximum size, in bytes, to which a directory can grow. The default maximum directory size for FlexVol volumes is model-dependent, and optimized for the size of system memory. Before increasing the maximum directory size, involve technical support.
	MaxDirSize *int64 `json:"max_dir_size,omitempty"`

	// metric
	Metric *models.VolumeInlineMetric `json:"metric,omitempty"`

	// movement
	Movement *models.VolumeInlineMovement `json:"movement,omitempty"`

	// The volume's Master Set ID.
	Msid *int64 `json:"msid,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *models.VolumeInlineNas `json:"nas,omitempty"`

	// Specifies whether to create the constituents of the FlexGroup volume on the aggregates specified in the order they are specified, or whether the system should optimize the ordering of the aggregates. If this value is 'true', the system optimizes the ordering of the aggregates specified. If this value is false, the order of the aggregates is unchanged. The default value is 'false'.
	OptimizeAggregates *bool `json:"optimize_aggregates,omitempty"`

	// qos
	Qos *models.VolumeInlineQos `json:"qos,omitempty"`

	// Specifies whether the volume is queued for encryption.
	QueueForEncryption *bool `json:"queue_for_encryption,omitempty"`

	// quota
	Quota *models.VolumeInlineQuota `json:"quota,omitempty"`

	// rebalancing
	Rebalancing *models.VolumeInlineRebalancing `json:"rebalancing,omitempty"`

	// Naming Scheme for automatic snapshots:
	// * create_time - Automatic snapshots are saved as per the start of their current date and time.
	// * ordinal - Latest automatic snapshot copy is saved as <scheduled_frequency>.0 and subsequent copies will follow the create_time naming convention.
	//
	// Enum: ["create_time","ordinal"]
	ScheduledSnapshotNamingScheme *string `json:"scheduled_snapshot_naming_scheme,omitempty"`

	// Physical size of the volume, in bytes. The minimum size for a FlexVol volume is 20MB and the minimum size for a FlexGroup volume is 200MB per constituent. The recommended size for a FlexGroup volume is a minimum of 100GB per constituent. For all volumes, the default size is equal to the minimum size.
	Size *int64 `json:"size,omitempty"`

	// When expanding a FlexGroup volume, this specifies whether to add new constituents, or to resize the current constituents.
	// Enum: ["use_existing_resources","add_new_resources"]
	SizingMethod *string `json:"sizing_method,omitempty"`

	// snaplock
	Snaplock *models.VolumeInlineSnaplock `json:"snaplock,omitempty"`

	// snapmirror
	Snapmirror *models.VolumeInlineSnapmirror `json:"snapmirror,omitempty"`

	// Number of snapshots in the volume.
	// Read Only: true
	// Maximum: 1023
	// Minimum: 0
	SnapshotCount *int64 `json:"snapshot_count,omitempty"`

	// This field, if true, enables the visible ".snapshot" directory from the client. The ".snapshot" directory will be available in every directory on the volume.
	SnapshotDirectoryAccessEnabled *bool `json:"snapshot_directory_access_enabled,omitempty"`

	// Specifies whether or not snapshot copy locking is enabled on the volume.
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *models.VolumeInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// space
	Space *models.VolumeInlineSpace `json:"space,omitempty"`

	// Volume state. Client access is supported only when volume is online and junctioned. Taking volume to offline or restricted state removes its junction path and blocks client access. When volume is in restricted state some operations like parity reconstruction and iron on commit are allowed. The 'mixed' state applies to FlexGroup volumes only and cannot be specified as a target state. An 'error' state implies that the volume is not in a state to serve data.
	// Enum: ["error","mixed","offline","online","restricted"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.VolumeInlineStatistics `json:"statistics,omitempty"`

	// The style of the volume. If "style" is not specified, the volume type is determined based on the specified aggregates or license. Specifying a single aggregate, without "constituents_per_aggregate", creates a flexible volume. Specifying multiple aggregates, or a single aggregate with "constituents_per_aggregate", creates a FlexGroup volume. When the UDO License is installed, and no aggregates are specified, the system automatically provisions a FlexGroup volume on system selected aggregates. Specifying a volume "style" creates a volume of that type. For example, if the style is "flexvol", you must specify a single aggregate. If the style is "flexgroup", the system either uses the specified aggregates or automatically provisions aggregates if there are no specified aggregates. The style "flexgroup_constituent" is not supported when creating a volume.<br>flexvol &dash; flexible volumes and FlexClone volumes<br>flexgroup &dash; FlexGroup volumes<br>flexgroup_constituent &dash; FlexGroup volume constituents.
	// Enum: ["flexvol","flexgroup","flexgroup_constituent"]
	Style *string `json:"style,omitempty"`

	// svm
	Svm *models.VolumeInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *models.VolumeInlineTiering `json:"tiering,omitempty"`

	// Type of the volume.<br>rw &dash; read-write volume.<br>dp &dash; data-protection volume.<br>ls &dash; load-sharing `dp` volume. Valid in GET.
	// Enum: ["rw","dp","ls"]
	Type *string `json:"type,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning a FlexGroup without specifying "aggregates.name" or "aggregates.uuid". Only mirrored aggregates are used if this parameter is set to 'true' and only unmirrored aggregates are used if this parameter is set to 'false'. Aggregate level mirroring for a FlexGroup volume can be changed by moving all of the constituents to the required aggregates. The default value is 'true' for a MetroCluster configuration and is 'false' for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Validate the volume move or volume conversion operations and their parameters, without actually performing the operation.
	ValidateOnly *bool `json:"validate_only,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VolumeInlineTags []*string `json:"_tags,omitempty"`

	// <personalities supports=unified,asar2>
	// Aggregate(s) hosting the volume. Optional.
	// </personalities>
	// <personalities supports=aiml>
	// Optional. Only supported in volume create (POST), and must hold only the storage availability zone. If supplied, the constituents_per_aggregate must also be supplied. Provided for backward-compatibility only. Using constituent_count instead of it and constituents_per_aggregate is always preferred.
	// </personalities>
	//
	VolumeInlineAggregates []*models.VolumeInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// FlexGroup volume constituents. FlexGroup volume constituents can be retrieved more efficiently by specifying "is_constituent=true" or "is_constituent=true&flexgroup.uuid=<flexgroup.uuid>" as query parameters.
	VolumeInlineConstituents []*models.VolumeInlineConstituentsInlineArrayItem `json:"constituents,omitempty"`

	// List of the nodes hosting the volume.
	VolumeInlineNodes []*models.VolumeInlineNodesInlineArrayItem `json:"nodes,omitempty"`

	// Describes the current status of a volume.
	// Read Only: true
	VolumeInlineStatus []*string `json:"status,omitempty"`

	// volume response inline records
	VolumeResponseInlineRecords []*models.Volume `json:"records,omitempty"`
}

// Validate validates this volume modify collection body
func (o *VolumeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateActivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggressiveReadaheadMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAnalytics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAsynchronousDirectoryDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAutosize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloudRetrievalPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConstituentCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateErrorState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlashPool(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheEndpointType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGranularDataMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLanguage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuota(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRebalancing(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScheduledSnapshotNamingScheme(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSizingMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirror(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeInlineConstituents(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateActivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(o.ActivityTracking) { // not required
		return nil
	}

	if o.ActivityTracking != nil {
		if err := o.ActivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "activity_tracking")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeAggressiveReadaheadModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","file_prefetch","sequential_read","cross_file_sequential_read"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeAggressiveReadaheadModePropEnum = append(volumeModifyCollectionBodyTypeAggressiveReadaheadModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// none
	// END DEBUGGING
	// VolumeModifyCollectionBodyAggressiveReadaheadModeNone captures enum value "none"
	VolumeModifyCollectionBodyAggressiveReadaheadModeNone string = "none"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// file_prefetch
	// END DEBUGGING
	// VolumeModifyCollectionBodyAggressiveReadaheadModeFilePrefetch captures enum value "file_prefetch"
	VolumeModifyCollectionBodyAggressiveReadaheadModeFilePrefetch string = "file_prefetch"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// sequential_read
	// END DEBUGGING
	// VolumeModifyCollectionBodyAggressiveReadaheadModeSequentialRead captures enum value "sequential_read"
	VolumeModifyCollectionBodyAggressiveReadaheadModeSequentialRead string = "sequential_read"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// cross_file_sequential_read
	// END DEBUGGING
	// VolumeModifyCollectionBodyAggressiveReadaheadModeCrossFileSequentialRead captures enum value "cross_file_sequential_read"
	VolumeModifyCollectionBodyAggressiveReadaheadModeCrossFileSequentialRead string = "cross_file_sequential_read"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateAggressiveReadaheadModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeAggressiveReadaheadModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateAggressiveReadaheadMode(formats strfmt.Registry) error {
	if swag.IsZero(o.AggressiveReadaheadMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateAggressiveReadaheadModeEnum("info"+"."+"aggressive_readahead_mode", "body", *o.AggressiveReadaheadMode); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateAnalytics(formats strfmt.Registry) error {
	if swag.IsZero(o.Analytics) { // not required
		return nil
	}

	if o.Analytics != nil {
		if err := o.Analytics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(o.AntiRansomware) { // not required
		return nil
	}

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "application")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateAsynchronousDirectoryDelete(formats strfmt.Registry) error {
	if swag.IsZero(o.AsynchronousDirectoryDelete) { // not required
		return nil
	}

	if o.AsynchronousDirectoryDelete != nil {
		if err := o.AsynchronousDirectoryDelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "asynchronous_directory_delete")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateAutosize(formats strfmt.Registry) error {
	if swag.IsZero(o.Autosize) { // not required
		return nil
	}

	if o.Autosize != nil {
		if err := o.Autosize.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "autosize")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeCloudRetrievalPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","on_read","never","promote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeCloudRetrievalPolicyPropEnum = append(volumeModifyCollectionBodyTypeCloudRetrievalPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// default
	// END DEBUGGING
	// VolumeModifyCollectionBodyCloudRetrievalPolicyDefault captures enum value "default"
	VolumeModifyCollectionBodyCloudRetrievalPolicyDefault string = "default"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// on_read
	// END DEBUGGING
	// VolumeModifyCollectionBodyCloudRetrievalPolicyOnRead captures enum value "on_read"
	VolumeModifyCollectionBodyCloudRetrievalPolicyOnRead string = "on_read"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// never
	// END DEBUGGING
	// VolumeModifyCollectionBodyCloudRetrievalPolicyNever captures enum value "never"
	VolumeModifyCollectionBodyCloudRetrievalPolicyNever string = "never"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// promote
	// END DEBUGGING
	// VolumeModifyCollectionBodyCloudRetrievalPolicyPromote captures enum value "promote"
	VolumeModifyCollectionBodyCloudRetrievalPolicyPromote string = "promote"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateCloudRetrievalPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeCloudRetrievalPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateCloudRetrievalPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudRetrievalPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateCloudRetrievalPolicyEnum("info"+"."+"cloud_retrieval_policy", "body", *o.CloudRetrievalPolicy); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroup) { // not required
		return nil
	}

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateConstituentCount(formats strfmt.Registry) error {
	if swag.IsZero(o.ConstituentCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"constituent_count", "body", *o.ConstituentCount, 1, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(o.Efficiency) { // not required
		return nil
	}

	if o.Efficiency != nil {
		if err := o.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateErrorState(formats strfmt.Registry) error {
	if swag.IsZero(o.ErrorState) { // not required
		return nil
	}

	if o.ErrorState != nil {
		if err := o.ErrorState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error_state")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateFiles(formats strfmt.Registry) error {
	if swag.IsZero(o.Files) { // not required
		return nil
	}

	if o.Files != nil {
		if err := o.Files.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "files")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateFlashPool(formats strfmt.Registry) error {
	if swag.IsZero(o.FlashPool) { // not required
		return nil
	}

	if o.FlashPool != nil {
		if err := o.FlashPool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "flash_pool")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeFlexcacheEndpointTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","cache","origin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeFlexcacheEndpointTypePropEnum = append(volumeModifyCollectionBodyTypeFlexcacheEndpointTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// none
	// END DEBUGGING
	// VolumeModifyCollectionBodyFlexcacheEndpointTypeNone captures enum value "none"
	VolumeModifyCollectionBodyFlexcacheEndpointTypeNone string = "none"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// cache
	// END DEBUGGING
	// VolumeModifyCollectionBodyFlexcacheEndpointTypeCache captures enum value "cache"
	VolumeModifyCollectionBodyFlexcacheEndpointTypeCache string = "cache"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// origin
	// END DEBUGGING
	// VolumeModifyCollectionBodyFlexcacheEndpointTypeOrigin captures enum value "origin"
	VolumeModifyCollectionBodyFlexcacheEndpointTypeOrigin string = "origin"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateFlexcacheEndpointTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeFlexcacheEndpointTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateFlexcacheEndpointType(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheEndpointType) { // not required
		return nil
	}

	// value enum
	if err := o.validateFlexcacheEndpointTypeEnum("info"+"."+"flexcache_endpoint_type", "body", *o.FlexcacheEndpointType); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateFlexgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Flexgroup) { // not required
		return nil
	}

	if o.Flexgroup != nil {
		if err := o.Flexgroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "flexgroup")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeGranularDataModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","basic","advanced"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeGranularDataModePropEnum = append(volumeModifyCollectionBodyTypeGranularDataModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// granular_data_mode
	// GranularDataMode
	// disabled
	// END DEBUGGING
	// VolumeModifyCollectionBodyGranularDataModeDisabled captures enum value "disabled"
	VolumeModifyCollectionBodyGranularDataModeDisabled string = "disabled"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// granular_data_mode
	// GranularDataMode
	// basic
	// END DEBUGGING
	// VolumeModifyCollectionBodyGranularDataModeBasic captures enum value "basic"
	VolumeModifyCollectionBodyGranularDataModeBasic string = "basic"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// granular_data_mode
	// GranularDataMode
	// advanced
	// END DEBUGGING
	// VolumeModifyCollectionBodyGranularDataModeAdvanced captures enum value "advanced"
	VolumeModifyCollectionBodyGranularDataModeAdvanced string = "advanced"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateGranularDataModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeGranularDataModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateGranularDataMode(formats strfmt.Registry) error {
	if swag.IsZero(o.GranularDataMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateGranularDataModeEnum("info"+"."+"granular_data_mode", "body", *o.GranularDataMode); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeLanguagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ar","ar.utf_8","c","c.utf_8","cs","cs.utf_8","da","da.utf_8","de","de.utf_8","en","en.utf_8","en_us","en_us.utf_8","es","es.utf_8","fi","fi.utf_8","fr","fr.utf_8","he","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it","it.utf_8","ja","ja.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck","ja_jp.pck.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ja_v1","ja_v1.utf_8","ko","ko.utf_8","nl","nl.utf_8","no","no.utf_8","pl","pl.utf_8","pt","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv","sv.utf_8","tr","tr.utf_8","utf8mb4","zh","zh.gbk","zh.gbk.utf_8","zh.utf_8","zh_tw","zh_tw.big5","zh_tw.big5.utf_8","zh_tw.utf_8"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeLanguagePropEnum = append(volumeModifyCollectionBodyTypeLanguagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ar
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageAr captures enum value "ar"
	VolumeModifyCollectionBodyLanguageAr string = "ar"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ar.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageArDotUTF8 captures enum value "ar.utf_8"
	VolumeModifyCollectionBodyLanguageArDotUTF8 string = "ar.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// c
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageC captures enum value "c"
	VolumeModifyCollectionBodyLanguageC string = "c"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// c.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageCDotUTF8 captures enum value "c.utf_8"
	VolumeModifyCollectionBodyLanguageCDotUTF8 string = "c.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// cs
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageCs captures enum value "cs"
	VolumeModifyCollectionBodyLanguageCs string = "cs"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// cs.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageCsDotUTF8 captures enum value "cs.utf_8"
	VolumeModifyCollectionBodyLanguageCsDotUTF8 string = "cs.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// da
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageDa captures enum value "da"
	VolumeModifyCollectionBodyLanguageDa string = "da"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// da.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageDaDotUTF8 captures enum value "da.utf_8"
	VolumeModifyCollectionBodyLanguageDaDotUTF8 string = "da.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// de
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageDe captures enum value "de"
	VolumeModifyCollectionBodyLanguageDe string = "de"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// de.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageDeDotUTF8 captures enum value "de.utf_8"
	VolumeModifyCollectionBodyLanguageDeDotUTF8 string = "de.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// en
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEn captures enum value "en"
	VolumeModifyCollectionBodyLanguageEn string = "en"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// en.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEnDotUTF8 captures enum value "en.utf_8"
	VolumeModifyCollectionBodyLanguageEnDotUTF8 string = "en.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// en_us
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEnUs captures enum value "en_us"
	VolumeModifyCollectionBodyLanguageEnUs string = "en_us"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// en_us.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEnUsDotUTF8 captures enum value "en_us.utf_8"
	VolumeModifyCollectionBodyLanguageEnUsDotUTF8 string = "en_us.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// es
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEs captures enum value "es"
	VolumeModifyCollectionBodyLanguageEs string = "es"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// es.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageEsDotUTF8 captures enum value "es.utf_8"
	VolumeModifyCollectionBodyLanguageEsDotUTF8 string = "es.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// fi
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageFi captures enum value "fi"
	VolumeModifyCollectionBodyLanguageFi string = "fi"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// fi.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageFiDotUTF8 captures enum value "fi.utf_8"
	VolumeModifyCollectionBodyLanguageFiDotUTF8 string = "fi.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// fr
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageFr captures enum value "fr"
	VolumeModifyCollectionBodyLanguageFr string = "fr"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// fr.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageFrDotUTF8 captures enum value "fr.utf_8"
	VolumeModifyCollectionBodyLanguageFrDotUTF8 string = "fr.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// he
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHe captures enum value "he"
	VolumeModifyCollectionBodyLanguageHe string = "he"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// he.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHeDotUTF8 captures enum value "he.utf_8"
	VolumeModifyCollectionBodyLanguageHeDotUTF8 string = "he.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// hr
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHr captures enum value "hr"
	VolumeModifyCollectionBodyLanguageHr string = "hr"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// hr.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHrDotUTF8 captures enum value "hr.utf_8"
	VolumeModifyCollectionBodyLanguageHrDotUTF8 string = "hr.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// hu
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHu captures enum value "hu"
	VolumeModifyCollectionBodyLanguageHu string = "hu"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// hu.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageHuDotUTF8 captures enum value "hu.utf_8"
	VolumeModifyCollectionBodyLanguageHuDotUTF8 string = "hu.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// it
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageIt captures enum value "it"
	VolumeModifyCollectionBodyLanguageIt string = "it"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// it.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageItDotUTF8 captures enum value "it.utf_8"
	VolumeModifyCollectionBodyLanguageItDotUTF8 string = "it.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJa captures enum value "ja"
	VolumeModifyCollectionBodyLanguageJa string = "ja"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaDotUTF8 captures enum value "ja.utf_8"
	VolumeModifyCollectionBodyLanguageJaDotUTF8 string = "ja.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.932
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDot932 captures enum value "ja_jp.932"
	VolumeModifyCollectionBodyLanguageJaJpDot932 string = "ja_jp.932"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.932.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDot932DotUTF8 captures enum value "ja_jp.932.utf_8"
	VolumeModifyCollectionBodyLanguageJaJpDot932DotUTF8 string = "ja_jp.932.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.pck
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDotPck captures enum value "ja_jp.pck"
	VolumeModifyCollectionBodyLanguageJaJpDotPck string = "ja_jp.pck"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.pck.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDotPckDotUTF8 captures enum value "ja_jp.pck.utf_8"
	VolumeModifyCollectionBodyLanguageJaJpDotPckDotUTF8 string = "ja_jp.pck.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.pck_v2
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDotPckV2 captures enum value "ja_jp.pck_v2"
	VolumeModifyCollectionBodyLanguageJaJpDotPckV2 string = "ja_jp.pck_v2"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_jp.pck_v2.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaJpDotPckV2DotUTF8 captures enum value "ja_jp.pck_v2.utf_8"
	VolumeModifyCollectionBodyLanguageJaJpDotPckV2DotUTF8 string = "ja_jp.pck_v2.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_v1
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaV1 captures enum value "ja_v1"
	VolumeModifyCollectionBodyLanguageJaV1 string = "ja_v1"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ja_v1.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageJaV1DotUTF8 captures enum value "ja_v1.utf_8"
	VolumeModifyCollectionBodyLanguageJaV1DotUTF8 string = "ja_v1.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ko
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageKo captures enum value "ko"
	VolumeModifyCollectionBodyLanguageKo string = "ko"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ko.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageKoDotUTF8 captures enum value "ko.utf_8"
	VolumeModifyCollectionBodyLanguageKoDotUTF8 string = "ko.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// nl
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageNl captures enum value "nl"
	VolumeModifyCollectionBodyLanguageNl string = "nl"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// nl.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageNlDotUTF8 captures enum value "nl.utf_8"
	VolumeModifyCollectionBodyLanguageNlDotUTF8 string = "nl.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// no
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageNo captures enum value "no"
	VolumeModifyCollectionBodyLanguageNo string = "no"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// no.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageNoDotUTF8 captures enum value "no.utf_8"
	VolumeModifyCollectionBodyLanguageNoDotUTF8 string = "no.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// pl
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguagePl captures enum value "pl"
	VolumeModifyCollectionBodyLanguagePl string = "pl"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// pl.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguagePlDotUTF8 captures enum value "pl.utf_8"
	VolumeModifyCollectionBodyLanguagePlDotUTF8 string = "pl.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// pt
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguagePt captures enum value "pt"
	VolumeModifyCollectionBodyLanguagePt string = "pt"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// pt.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguagePtDotUTF8 captures enum value "pt.utf_8"
	VolumeModifyCollectionBodyLanguagePtDotUTF8 string = "pt.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ro
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageRo captures enum value "ro"
	VolumeModifyCollectionBodyLanguageRo string = "ro"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ro.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageRoDotUTF8 captures enum value "ro.utf_8"
	VolumeModifyCollectionBodyLanguageRoDotUTF8 string = "ro.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ru
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageRu captures enum value "ru"
	VolumeModifyCollectionBodyLanguageRu string = "ru"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// ru.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageRuDotUTF8 captures enum value "ru.utf_8"
	VolumeModifyCollectionBodyLanguageRuDotUTF8 string = "ru.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sk
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSk captures enum value "sk"
	VolumeModifyCollectionBodyLanguageSk string = "sk"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sk.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSkDotUTF8 captures enum value "sk.utf_8"
	VolumeModifyCollectionBodyLanguageSkDotUTF8 string = "sk.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sl
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSl captures enum value "sl"
	VolumeModifyCollectionBodyLanguageSl string = "sl"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sl.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSlDotUTF8 captures enum value "sl.utf_8"
	VolumeModifyCollectionBodyLanguageSlDotUTF8 string = "sl.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sv
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSv captures enum value "sv"
	VolumeModifyCollectionBodyLanguageSv string = "sv"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// sv.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageSvDotUTF8 captures enum value "sv.utf_8"
	VolumeModifyCollectionBodyLanguageSvDotUTF8 string = "sv.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// tr
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageTr captures enum value "tr"
	VolumeModifyCollectionBodyLanguageTr string = "tr"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// tr.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageTrDotUTF8 captures enum value "tr.utf_8"
	VolumeModifyCollectionBodyLanguageTrDotUTF8 string = "tr.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// utf8mb4
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageUtf8mb4 captures enum value "utf8mb4"
	VolumeModifyCollectionBodyLanguageUtf8mb4 string = "utf8mb4"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZh captures enum value "zh"
	VolumeModifyCollectionBodyLanguageZh string = "zh"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh.gbk
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhDotGbk captures enum value "zh.gbk"
	VolumeModifyCollectionBodyLanguageZhDotGbk string = "zh.gbk"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh.gbk.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhDotGbkDotUTF8 captures enum value "zh.gbk.utf_8"
	VolumeModifyCollectionBodyLanguageZhDotGbkDotUTF8 string = "zh.gbk.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhDotUTF8 captures enum value "zh.utf_8"
	VolumeModifyCollectionBodyLanguageZhDotUTF8 string = "zh.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh_tw
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhTw captures enum value "zh_tw"
	VolumeModifyCollectionBodyLanguageZhTw string = "zh_tw"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh_tw.big5
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhTwDotBig5 captures enum value "zh_tw.big5"
	VolumeModifyCollectionBodyLanguageZhTwDotBig5 string = "zh_tw.big5"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh_tw.big5.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhTwDotBig5DotUTF8 captures enum value "zh_tw.big5.utf_8"
	VolumeModifyCollectionBodyLanguageZhTwDotBig5DotUTF8 string = "zh_tw.big5.utf_8"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// language
	// Language
	// zh_tw.utf_8
	// END DEBUGGING
	// VolumeModifyCollectionBodyLanguageZhTwDotUTF8 captures enum value "zh_tw.utf_8"
	VolumeModifyCollectionBodyLanguageZhTwDotUTF8 string = "zh_tw.utf_8"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateLanguageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeLanguagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateLanguage(formats strfmt.Registry) error {
	if swag.IsZero(o.Language) { // not required
		return nil
	}

	// value enum
	if err := o.validateLanguageEnum("info"+"."+"language", "body", *o.Language); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(o.Movement) { // not required
		return nil
	}

	if o.Movement != nil {
		if err := o.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateQuota(formats strfmt.Registry) error {
	if swag.IsZero(o.Quota) { // not required
		return nil
	}

	if o.Quota != nil {
		if err := o.Quota.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "quota")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateRebalancing(formats strfmt.Registry) error {
	if swag.IsZero(o.Rebalancing) { // not required
		return nil
	}

	if o.Rebalancing != nil {
		if err := o.Rebalancing.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeScheduledSnapshotNamingSchemePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create_time","ordinal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeScheduledSnapshotNamingSchemePropEnum = append(volumeModifyCollectionBodyTypeScheduledSnapshotNamingSchemePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// scheduled_snapshot_naming_scheme
	// ScheduledSnapshotNamingScheme
	// create_time
	// END DEBUGGING
	// VolumeModifyCollectionBodyScheduledSnapshotNamingSchemeCreateTime captures enum value "create_time"
	VolumeModifyCollectionBodyScheduledSnapshotNamingSchemeCreateTime string = "create_time"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// scheduled_snapshot_naming_scheme
	// ScheduledSnapshotNamingScheme
	// ordinal
	// END DEBUGGING
	// VolumeModifyCollectionBodyScheduledSnapshotNamingSchemeOrdinal captures enum value "ordinal"
	VolumeModifyCollectionBodyScheduledSnapshotNamingSchemeOrdinal string = "ordinal"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateScheduledSnapshotNamingSchemeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeScheduledSnapshotNamingSchemePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateScheduledSnapshotNamingScheme(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduledSnapshotNamingScheme) { // not required
		return nil
	}

	// value enum
	if err := o.validateScheduledSnapshotNamingSchemeEnum("info"+"."+"scheduled_snapshot_naming_scheme", "body", *o.ScheduledSnapshotNamingScheme); err != nil {
		return err
	}

	return nil
}

var volumeModifyCollectionBodyTypeSizingMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["use_existing_resources","add_new_resources"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeSizingMethodPropEnum = append(volumeModifyCollectionBodyTypeSizingMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// sizing_method
	// SizingMethod
	// use_existing_resources
	// END DEBUGGING
	// VolumeModifyCollectionBodySizingMethodUseExistingResources captures enum value "use_existing_resources"
	VolumeModifyCollectionBodySizingMethodUseExistingResources string = "use_existing_resources"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// sizing_method
	// SizingMethod
	// add_new_resources
	// END DEBUGGING
	// VolumeModifyCollectionBodySizingMethodAddNewResources captures enum value "add_new_resources"
	VolumeModifyCollectionBodySizingMethodAddNewResources string = "add_new_resources"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateSizingMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeSizingMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateSizingMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.SizingMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateSizingMethodEnum("info"+"."+"sizing_method", "body", *o.SizingMethod); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSnapmirror(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapmirror) { // not required
		return nil
	}

	if o.Snapmirror != nil {
		if err := o.Snapmirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSnapshotCount(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"snapshot_count", "body", *o.SnapshotCount, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"snapshot_count", "body", *o.SnapshotCount, 1023, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","mixed","offline","online","restricted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeStatePropEnum = append(volumeModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// state
	// State
	// error
	// END DEBUGGING
	// VolumeModifyCollectionBodyStateError captures enum value "error"
	VolumeModifyCollectionBodyStateError string = "error"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeModifyCollectionBodyStateMixed captures enum value "mixed"
	VolumeModifyCollectionBodyStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// state
	// State
	// offline
	// END DEBUGGING
	// VolumeModifyCollectionBodyStateOffline captures enum value "offline"
	VolumeModifyCollectionBodyStateOffline string = "offline"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// state
	// State
	// online
	// END DEBUGGING
	// VolumeModifyCollectionBodyStateOnline captures enum value "online"
	VolumeModifyCollectionBodyStateOnline string = "online"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// state
	// State
	// restricted
	// END DEBUGGING
	// VolumeModifyCollectionBodyStateRestricted captures enum value "restricted"
	VolumeModifyCollectionBodyStateRestricted string = "restricted"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["flexvol","flexgroup","flexgroup_constituent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeStylePropEnum = append(volumeModifyCollectionBodyTypeStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// style
	// Style
	// flexvol
	// END DEBUGGING
	// VolumeModifyCollectionBodyStyleFlexvol captures enum value "flexvol"
	VolumeModifyCollectionBodyStyleFlexvol string = "flexvol"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// style
	// Style
	// flexgroup
	// END DEBUGGING
	// VolumeModifyCollectionBodyStyleFlexgroup captures enum value "flexgroup"
	VolumeModifyCollectionBodyStyleFlexgroup string = "flexgroup"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// style
	// Style
	// flexgroup_constituent
	// END DEBUGGING
	// VolumeModifyCollectionBodyStyleFlexgroupConstituent captures enum value "flexgroup_constituent"
	VolumeModifyCollectionBodyStyleFlexgroupConstituent string = "flexgroup_constituent"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.Style) { // not required
		return nil
	}

	// value enum
	if err := o.validateStyleEnum("info"+"."+"style", "body", *o.Style); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

var volumeModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["rw","dp","ls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeModifyCollectionBodyTypeTypePropEnum = append(volumeModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// type
	// Type
	// rw
	// END DEBUGGING
	// VolumeModifyCollectionBodyTypeRw captures enum value "rw"
	VolumeModifyCollectionBodyTypeRw string = "rw"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// type
	// Type
	// dp
	// END DEBUGGING
	// VolumeModifyCollectionBodyTypeDp captures enum value "dp"
	VolumeModifyCollectionBodyTypeDp string = "dp"

	// BEGIN DEBUGGING
	// VolumeModifyCollectionBody
	// VolumeModifyCollectionBody
	// type
	// Type
	// ls
	// END DEBUGGING
	// VolumeModifyCollectionBodyTypeLs captures enum value "ls"
	VolumeModifyCollectionBodyTypeLs string = "ls"
)

// prop value enum
func (o *VolumeModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateVolumeInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeInlineTags) { // not required
		return nil
	}

	iVolumeInlineTagsSize := int64(len(o.VolumeInlineTags))

	if err := validate.MaxItems("info"+"."+"_tags", "body", iVolumeInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateVolumeInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeInlineAggregates); i++ {
		if swag.IsZero(o.VolumeInlineAggregates[i]) { // not required
			continue
		}

		if o.VolumeInlineAggregates[i] != nil {
			if err := o.VolumeInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateVolumeInlineConstituents(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeInlineConstituents) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeInlineConstituents); i++ {
		if swag.IsZero(o.VolumeInlineConstituents[i]) { // not required
			continue
		}

		if o.VolumeInlineConstituents[i] != nil {
			if err := o.VolumeInlineConstituents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "constituents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateVolumeInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeInlineNodes); i++ {
		if swag.IsZero(o.VolumeInlineNodes[i]) { // not required
			continue
		}

		if o.VolumeInlineNodes[i] != nil {
			if err := o.VolumeInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) validateVolumeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeResponseInlineRecords); i++ {
		if swag.IsZero(o.VolumeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VolumeResponseInlineRecords[i] != nil {
			if err := o.VolumeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume modify collection body based on the context it is used
func (o *VolumeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateActivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnalytics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAsynchronousDirectoryDelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAutosize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateErrorState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlashPool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheEndpointType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsObjectStore(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSvmRoot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQuota(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRebalancing(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeInlineConstituents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeInlineStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateActivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if o.ActivityTracking != nil {
		if err := o.ActivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "activity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateAnalytics(ctx context.Context, formats strfmt.Registry) error {

	if o.Analytics != nil {
		if err := o.Analytics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "application")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateAsynchronousDirectoryDelete(ctx context.Context, formats strfmt.Registry) error {

	if o.AsynchronousDirectoryDelete != nil {
		if err := o.AsynchronousDirectoryDelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "asynchronous_directory_delete")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateAutosize(ctx context.Context, formats strfmt.Registry) error {

	if o.Autosize != nil {
		if err := o.Autosize.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "autosize")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if o.Efficiency != nil {
		if err := o.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateErrorState(ctx context.Context, formats strfmt.Registry) error {

	if o.ErrorState != nil {
		if err := o.ErrorState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error_state")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateFiles(ctx context.Context, formats strfmt.Registry) error {

	if o.Files != nil {
		if err := o.Files.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "files")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateFlashPool(ctx context.Context, formats strfmt.Registry) error {

	if o.FlashPool != nil {
		if err := o.FlashPool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "flash_pool")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateFlexcacheEndpointType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flexcache_endpoint_type", "body", o.FlexcacheEndpointType); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateFlexgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Flexgroup != nil {
		if err := o.Flexgroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "flexgroup")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateIsObjectStore(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_object_store", "body", o.IsObjectStore); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateIsSvmRoot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_svm_root", "body", o.IsSvmRoot); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if o.Movement != nil {
		if err := o.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateQuota(ctx context.Context, formats strfmt.Registry) error {

	if o.Quota != nil {
		if err := o.Quota.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "quota")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateRebalancing(ctx context.Context, formats strfmt.Registry) error {

	if o.Rebalancing != nil {
		if err := o.Rebalancing.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSnapmirror(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapmirror != nil {
		if err := o.Snapmirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSnapshotCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot_count", "body", o.SnapshotCount); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateVolumeInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeInlineAggregates); i++ {

		if o.VolumeInlineAggregates[i] != nil {
			if err := o.VolumeInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateVolumeInlineConstituents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeInlineConstituents); i++ {

		if o.VolumeInlineConstituents[i] != nil {
			if err := o.VolumeInlineConstituents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "constituents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateVolumeInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeInlineNodes); i++ {

		if o.VolumeInlineNodes[i] != nil {
			if err := o.VolumeInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateVolumeInlineStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status", "body", []*string(o.VolumeInlineStatus)); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionBody) contextValidateVolumeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeResponseInlineRecords); i++ {

		if o.VolumeResponseInlineRecords[i] != nil {
			if err := o.VolumeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res VolumeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0 volume modify collection params body activity tracking notices items0
swagger:model VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0
*/
type VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0 struct {

	// An error code related to activity tracking.
	// Example: 124518424
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A notice message related to activity tracking.
	// Example: The top metrics report contains partial data for read operations because NFSv4 reads using Multi-Processor I/O (MPIO) are not tracked.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume modify collection params body activity tracking notices items0
func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume modify collection params body activity tracking notices items0 based on the context it is used
func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0) UnmarshalBinary(b []byte) error {
	var res VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0 volume modify collection params body anti ransomware suspect files items0
swagger:model VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0
*/
type VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0 struct {

	// Total number of `suspect_files.format` files observed by the Anti-ransomware analytics engine on the volume.
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Indicates the entropy level of this file type.
	// Read Only: true
	Entropy *string `json:"entropy,omitempty"`

	// File formats observed by the Anti-ransomware analytics engine on the volume.
	// Read Only: true
	Format *string `json:"format,omitempty"`
}

// Validate validates this volume modify collection params body anti ransomware suspect files items0
func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume modify collection params body anti ransomware suspect files items0 based on the context it is used
func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEntropy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) contextValidateEntropy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entropy", "body", o.Entropy); err != nil {
		return err
	}

	return nil
}

func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", o.Format); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0) UnmarshalBinary(b []byte) error {
	var res VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineLinks volume inline links
swagger:model volume_inline__links
*/
type VolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline links
func (o *VolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline links based on the context it is used
func (o *VolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineActivityTracking volume inline activity tracking
swagger:model volume_inline_activity_tracking
*/
type VolumeInlineActivityTracking struct {

	// List of activity-tracking notices.
	Notices []*VolumeModifyCollectionParamsBodyActivityTrackingNoticesItems0 `json:"notices,omitempty"`

	// Activity tracking state of the volume. If this value is "on", ONTAP collects top metrics information for the volume in real time. There is a slight impact to I/O performance in order to collect this information. If this value is "off", no activity tracking information is collected or available to view.
	// Enum: ["off","on"]
	State *string `json:"state,omitempty"`

	// This field indicates whether or not volume activity tracking is supported on the volume. If volume activity tracking is not supported, the reason why is provided in the "activity_tracking.unsupported_reason" field.
	// Read Only: true
	Supported *bool `json:"supported,omitempty"`

	// unsupported reason
	UnsupportedReason *models.VolumeInlineActivityTrackingInlineUnsupportedReason `json:"unsupported_reason,omitempty"`
}

// Validate validates this volume inline activity tracking
func (o *VolumeInlineActivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNotices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnsupportedReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineActivityTracking) validateNotices(formats strfmt.Registry) error {
	if swag.IsZero(o.Notices) { // not required
		return nil
	}

	for i := 0; i < len(o.Notices); i++ {
		if swag.IsZero(o.Notices[i]) { // not required
			continue
		}

		if o.Notices[i] != nil {
			if err := o.Notices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "activity_tracking" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var volumeInlineActivityTrackingTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","on"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineActivityTrackingTypeStatePropEnum = append(volumeInlineActivityTrackingTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_activity_tracking
	// VolumeInlineActivityTracking
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineActivityTrackingStateOff captures enum value "off"
	VolumeInlineActivityTrackingStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_activity_tracking
	// VolumeInlineActivityTracking
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineActivityTrackingStateOn captures enum value "on"
	VolumeInlineActivityTrackingStateOn string = "on"
)

// prop value enum
func (o *VolumeInlineActivityTracking) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineActivityTrackingTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineActivityTracking) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"activity_tracking"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineActivityTracking) validateUnsupportedReason(formats strfmt.Registry) error {
	if swag.IsZero(o.UnsupportedReason) { // not required
		return nil
	}

	if o.UnsupportedReason != nil {
		if err := o.UnsupportedReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "activity_tracking" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline activity tracking based on the context it is used
func (o *VolumeInlineActivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNotices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnsupportedReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineActivityTracking) contextValidateNotices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Notices); i++ {

		if o.Notices[i] != nil {
			if err := o.Notices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "activity_tracking" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineActivityTracking) contextValidateSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"activity_tracking"+"."+"supported", "body", o.Supported); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineActivityTracking) contextValidateUnsupportedReason(ctx context.Context, formats strfmt.Registry) error {

	if o.UnsupportedReason != nil {
		if err := o.UnsupportedReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "activity_tracking" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineActivityTracking) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineActivityTracking) UnmarshalBinary(b []byte) error {
	var res VolumeInlineActivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineActivityTrackingInlineUnsupportedReason volume inline activity tracking inline unsupported reason
swagger:model volume_inline_activity_tracking_inline_unsupported_reason
*/
type VolumeInlineActivityTrackingInlineUnsupportedReason struct {

	// If volume activity tracking is not supported on the volume, this field provides an appropriate error code.
	// Example: 124518405
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// If volume activity tracking is not supported on the volume, this field provides an error message detailing why this is the case.
	// Example: Volume activity tracking cannot be enabled on volumes that contain LUNs.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline activity tracking inline unsupported reason
func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline activity tracking inline unsupported reason based on the context it is used
func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"activity_tracking"+"."+"unsupported_reason"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"activity_tracking"+"."+"unsupported_reason"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineActivityTrackingInlineUnsupportedReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineActivityTrackingInlineUnsupportedReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAggregatesInlineArrayItem Aggregate
swagger:model volume_inline_aggregates_inline_array_item
*/
type VolumeInlineAggregatesInlineArrayItem struct {

	// links
	Links *models.VolumeInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline aggregates inline array item
func (o *VolumeInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline aggregates inline array item based on the context it is used
func (o *VolumeInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAggregatesInlineArrayItemInlineLinks volume inline aggregates inline array item inline links
swagger:model volume_inline_aggregates_inline_array_item_inline__links
*/
type VolumeInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline aggregates inline array item inline links
func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline aggregates inline array item inline links based on the context it is used
func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalytics volume inline analytics
swagger:model volume_inline_analytics
*/
type VolumeInlineAnalytics struct {

	// by accessed time
	ByAccessedTime *models.VolumeInlineAnalyticsInlineByAccessedTime `json:"by_accessed_time,omitempty"`

	// by modified time
	ByModifiedTime *models.VolumeInlineAnalyticsInlineByModifiedTime `json:"by_modified_time,omitempty"`

	// Number of bytes used on-disk.
	// Example: 15436648448
	// Read Only: true
	BytesUsed *int64 `json:"bytes_used,omitempty"`

	// Number of descendants.
	// Example: 21134
	// Read Only: true
	FileCount *int64 `json:"file_count,omitempty"`

	// Number of files in the volume that the file system analytics initialization scan has processed. Only returned when the state is `initializing`.
	// Example: 43002
	// Read Only: true
	FilesScanned *int64 `json:"files_scanned,omitempty"`

	// Returns true if data collection is incomplete for this directory tree.
	// Read Only: true
	IncompleteData *bool `json:"incomplete_data,omitempty"`

	// initialization
	Initialization *models.VolumeInlineAnalyticsInlineInitialization `json:"initialization,omitempty"`

	// Time of data collection.
	// Example: 2024-11-06 13:57:15-05:00
	// Read Only: true
	// Format: date-time
	ReportTime *strfmt.DateTime `json:"report_time,omitempty"`

	// Percentage of files in the volume that the file system analytics initialization scan has processed. Only returned when the state is `initializing`.
	// Example: 17
	// Read Only: true
	ScanProgress *int64 `json:"scan_progress,omitempty"`

	// scan throttle reason
	ScanThrottleReason *models.VolumeInlineAnalyticsInlineScanThrottleReason `json:"scan_throttle_reason,omitempty"`

	// File system analytics state of the volume. If this value is "on", ONTAP collects extra file system analytics information for all directories on the volume. There will be a slight impact to I/O performance to collect this information. If this value is "off", file system analytics information is not collected and not available to be viewed. If this value is "initializing", that means file system analytics was recently turned on, and the initialization scan to gather information for all existing files and directories is currently running. If this value is "initialization_paused", this means that the initialization scan is currently paused. If this value is 'unknown', this means that there was an internal error when determining the file system analytics state for the volume.
	// Enum: ["unknown","initializing","initialization_paused","off","on"]
	State *string `json:"state,omitempty"`

	// Number of sub-directories.
	// Example: 35
	// Read Only: true
	SubdirCount *int64 `json:"subdir_count,omitempty"`

	// This field indicates whether or not file system analytics is supported on the volume. If file system analytics is not supported, the reason will be specified in the "analytics.unsupported_reason" field.
	// Read Only: true
	Supported *bool `json:"supported,omitempty"`

	// Total number of files in the volume that the file system analytics initialization scan will process. Only returned when the state is `initializing`.
	// Example: 101890
	// Read Only: true
	TotalFiles *int64 `json:"total_files,omitempty"`

	// unsupported reason
	UnsupportedReason *models.VolumeInlineAnalyticsInlineUnsupportedReason `json:"unsupported_reason,omitempty"`
}

// Validate validates this volume inline analytics
func (o *VolumeInlineAnalytics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateByAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateByModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitialization(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReportTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScanThrottleReason(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnsupportedReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalytics) validateByAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ByAccessedTime) { // not required
		return nil
	}

	if o.ByAccessedTime != nil {
		if err := o.ByAccessedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) validateByModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ByModifiedTime) { // not required
		return nil
	}

	if o.ByModifiedTime != nil {
		if err := o.ByModifiedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) validateInitialization(formats strfmt.Registry) error {
	if swag.IsZero(o.Initialization) { // not required
		return nil
	}

	if o.Initialization != nil {
		if err := o.Initialization.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "initialization")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) validateReportTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ReportTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"analytics"+"."+"report_time", "body", "date-time", o.ReportTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) validateScanThrottleReason(formats strfmt.Registry) error {
	if swag.IsZero(o.ScanThrottleReason) { // not required
		return nil
	}

	if o.ScanThrottleReason != nil {
		if err := o.ScanThrottleReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "scan_throttle_reason")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAnalyticsTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","initializing","initialization_paused","off","on"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAnalyticsTypeStatePropEnum = append(volumeInlineAnalyticsTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// unknown
	// END DEBUGGING
	// VolumeInlineAnalyticsStateUnknown captures enum value "unknown"
	VolumeInlineAnalyticsStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineAnalyticsStateInitializing captures enum value "initializing"
	VolumeInlineAnalyticsStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// initialization_paused
	// END DEBUGGING
	// VolumeInlineAnalyticsStateInitializationPaused captures enum value "initialization_paused"
	VolumeInlineAnalyticsStateInitializationPaused string = "initialization_paused"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineAnalyticsStateOff captures enum value "off"
	VolumeInlineAnalyticsStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineAnalyticsStateOn captures enum value "on"
	VolumeInlineAnalyticsStateOn string = "on"
)

// prop value enum
func (o *VolumeInlineAnalytics) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAnalyticsTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAnalytics) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"analytics"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) validateUnsupportedReason(formats strfmt.Registry) error {
	if swag.IsZero(o.UnsupportedReason) { // not required
		return nil
	}

	if o.UnsupportedReason != nil {
		if err := o.UnsupportedReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics based on the context it is used
func (o *VolumeInlineAnalytics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateByAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateByModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilesScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIncompleteData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitialization(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReportTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScanProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScanThrottleReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubdirCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnsupportedReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalytics) contextValidateByAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if o.ByAccessedTime != nil {
		if err := o.ByAccessedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateByModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if o.ByModifiedTime != nil {
		if err := o.ByModifiedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"bytes_used", "body", o.BytesUsed); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateFileCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"file_count", "body", o.FileCount); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateFilesScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"files_scanned", "body", o.FilesScanned); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateIncompleteData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"incomplete_data", "body", o.IncompleteData); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateInitialization(ctx context.Context, formats strfmt.Registry) error {

	if o.Initialization != nil {
		if err := o.Initialization.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "initialization")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateReportTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"report_time", "body", o.ReportTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateScanProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"scan_progress", "body", o.ScanProgress); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateScanThrottleReason(ctx context.Context, formats strfmt.Registry) error {

	if o.ScanThrottleReason != nil {
		if err := o.ScanThrottleReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "scan_throttle_reason")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateSubdirCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"subdir_count", "body", o.SubdirCount); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"supported", "body", o.Supported); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateTotalFiles(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"total_files", "body", o.TotalFiles); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalytics) contextValidateUnsupportedReason(ctx context.Context, formats strfmt.Registry) error {

	if o.UnsupportedReason != nil {
		if err := o.UnsupportedReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalytics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalytics) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalytics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineByAccessedTime File system analytics information, broken down by date of last access.
swagger:model volume_inline_analytics_inline_by_accessed_time
*/
type VolumeInlineAnalyticsInlineByAccessedTime struct {

	// bytes used
	BytesUsed *models.VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume inline analytics inline by accessed time
func (o *VolumeInlineAnalyticsInlineByAccessedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(o.BytesUsed) { // not required
		return nil
	}

	if o.BytesUsed != nil {
		if err := o.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by accessed time based on the context it is used
func (o *VolumeInlineAnalyticsInlineByAccessedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if o.BytesUsed != nil {
		if err := o.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByAccessedTime) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByAccessedTime) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByAccessedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last access.
swagger:model volume_inline_analytics_inline_by_accessed_time_inline_bytes_used
*/
type VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels models.AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *models.AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *models.AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this volume inline analytics inline by accessed time inline bytes used
func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(o.Labels) { // not required
		return nil
	}

	if err := o.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(o.NewestLabel) { // not required
		return nil
	}

	if o.NewestLabel != nil {
		if err := o.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(o.OldestLabel) { // not required
		return nil
	}

	if o.OldestLabel != nil {
		if err := o.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by accessed time inline bytes used based on the context it is used
func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if o.NewestLabel != nil {
		if err := o.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if o.OldestLabel != nil {
		if err := o.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineByModifiedTime File system analytics information, broken down by date of last modification.
swagger:model volume_inline_analytics_inline_by_modified_time
*/
type VolumeInlineAnalyticsInlineByModifiedTime struct {

	// bytes used
	BytesUsed *models.VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume inline analytics inline by modified time
func (o *VolumeInlineAnalyticsInlineByModifiedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(o.BytesUsed) { // not required
		return nil
	}

	if o.BytesUsed != nil {
		if err := o.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by modified time based on the context it is used
func (o *VolumeInlineAnalyticsInlineByModifiedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if o.BytesUsed != nil {
		if err := o.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByModifiedTime) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByModifiedTime) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByModifiedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last modification.
swagger:model volume_inline_analytics_inline_by_modified_time_inline_bytes_used
*/
type VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels models.AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *models.AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *models.AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this volume inline analytics inline by modified time inline bytes used
func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(o.Labels) { // not required
		return nil
	}

	if err := o.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(o.NewestLabel) { // not required
		return nil
	}

	if o.NewestLabel != nil {
		if err := o.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(o.OldestLabel) { // not required
		return nil
	}

	if o.OldestLabel != nil {
		if err := o.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by modified time inline bytes used based on the context it is used
func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if o.NewestLabel != nil {
		if err := o.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if o.OldestLabel != nil {
		if err := o.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineInitialization volume inline analytics inline initialization
swagger:model volume_inline_analytics_inline_initialization
*/
type VolumeInlineAnalyticsInlineInitialization struct {

	// State of the analytics file system scan.
	// Enum: ["running","paused"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline analytics inline initialization
func (o *VolumeInlineAnalyticsInlineInitialization) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAnalyticsInlineInitializationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["running","paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAnalyticsInlineInitializationTypeStatePropEnum = append(volumeInlineAnalyticsInlineInitializationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_analytics_inline_initialization
	// VolumeInlineAnalyticsInlineInitialization
	// state
	// State
	// running
	// END DEBUGGING
	// VolumeInlineAnalyticsInlineInitializationStateRunning captures enum value "running"
	VolumeInlineAnalyticsInlineInitializationStateRunning string = "running"

	// BEGIN DEBUGGING
	// volume_inline_analytics_inline_initialization
	// VolumeInlineAnalyticsInlineInitialization
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineAnalyticsInlineInitializationStatePaused captures enum value "paused"
	VolumeInlineAnalyticsInlineInitializationStatePaused string = "paused"
)

// prop value enum
func (o *VolumeInlineAnalyticsInlineInitialization) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAnalyticsInlineInitializationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineInitialization) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"analytics"+"."+"initialization"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline analytics inline initialization based on context it is used
func (o *VolumeInlineAnalyticsInlineInitialization) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineInitialization) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineInitialization) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineInitialization
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineScanThrottleReason volume inline analytics inline scan throttle reason
swagger:model volume_inline_analytics_inline_scan_throttle_reason
*/
type VolumeInlineAnalyticsInlineScanThrottleReason struct {

	// Arguments present in the warning message encountered.
	Arguments []*string `json:"arguments,omitempty"`

	// Warning code indicating why scanner throttling is reported.
	// Example: 6739881
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message that provides details for scan throttling.
	// Example: The file system analytics scan running on volume \"fsavol2\" in SVM \"vs2\" has slowed down on node \"my_node\". Reason: Computing resources are being used by higher priority workloads.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline analytics inline scan throttle reason
func (o *VolumeInlineAnalyticsInlineScanThrottleReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline analytics inline scan throttle reason based on the context it is used
func (o *VolumeInlineAnalyticsInlineScanThrottleReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineScanThrottleReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"scan_throttle_reason"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineScanThrottleReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"scan_throttle_reason"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineScanThrottleReason) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineScanThrottleReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineScanThrottleReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAnalyticsInlineUnsupportedReason volume inline analytics inline unsupported reason
swagger:model volume_inline_analytics_inline_unsupported_reason
*/
type VolumeInlineAnalyticsInlineUnsupportedReason struct {

	// If file system analytics is not supported on the volume, this field provides the error code explaining why.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// If file system analytics is not supported on the volume, this field provides the error message explaining why.
	// Example: File system analytics cannot be enabled on volumes that contain LUNs.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline analytics inline unsupported reason
func (o *VolumeInlineAnalyticsInlineUnsupportedReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline analytics inline unsupported reason based on the context it is used
func (o *VolumeInlineAnalyticsInlineUnsupportedReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAnalyticsInlineUnsupportedReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"unsupported_reason"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAnalyticsInlineUnsupportedReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"analytics"+"."+"unsupported_reason"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineUnsupportedReason) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAnalyticsInlineUnsupportedReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineUnsupportedReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomware Anti-ransomware related information of the volume.
swagger:model volume_inline_anti_ransomware
*/
type VolumeInlineAntiRansomware struct {

	// This field specifies whether the attack was reported by `File Analysis` or `Encrypted data percentage analysis`.
	// Read Only: true
	// Enum: ["file_analysis","encryption_percentage_analysis"]
	AttackDetectedBy *string `json:"attack_detected_by,omitempty"`

	// attack detection parameters
	AttackDetectionParameters *models.AntiRansomwareVolumeAttackDetectionParameters `json:"attack_detection_parameters,omitempty"`

	// Probability of a ransomware attack.<br>`none` No suspected ransomware activity.<br>`low` Minimally suspected ransomware activity.<br>`moderate` Moderately suspected ransomware activity.<br>`high` Significantly suspected ransomware activity.
	// Read Only: true
	// Enum: ["none","low","moderate","high"]
	AttackProbability *string `json:"attack_probability,omitempty"`

	// attack reports
	// Read Only: true
	AttackReports []*models.AntiRansomwareAttackReport `json:"attack_reports,omitempty"`

	// This field specifies the block device evaluation start time.
	// Read Only: true
	// Format: date-time
	BlockDeviceDetectionStartTime *strfmt.DateTime `json:"block_device_detection_start_time,omitempty"`

	// This field specifies the block device attack detection status. <br> `evaluation_period` Attack detection is currently in its evaluation phase. <br> `active_unsuitable_workload` Attack detection is active, but the current workload is not suitable for Anti-ransomware protection. <br> `active_suitable_workload` Attack detection is active, and the current workload is appropriate for Anti-ransomware protection.
	// Read Only: true
	// Enum: ["evaluation_period","active_unsuitable_workload","active_suitable_workload"]
	BlockDeviceDetectionState *string `json:"block_device_detection_state,omitempty"`

	// clear suspect
	ClearSuspect *models.VolumeInlineAntiRansomwareInlineClearSuspect `json:"clear_suspect,omitempty"`

	// Time when Anti-ransomware monitoring `state` is set to dry-run value for starting evaluation mode.
	// Read Only: true
	// Format: date-time
	DryRunStartTime *strfmt.DateTime `json:"dry_run_start_time,omitempty"`

	// event log
	EventLog *models.VolumeInlineAntiRansomwareInlineEventLog `json:"event_log,omitempty"`

	// space
	Space *models.VolumeInlineAntiRansomwareInlineSpace `json:"space,omitempty"`

	// Anti-ransomware state.<br>`disabled` Anti-ransomware monitoring is disabled on the volume. This is the default state in a POST operation.<br>`disable_in_progress` Anti-ransomware monitoring is being disabled and a cleanup operation is in effect. Valid in GET operation.<br>`dry_run` Anti-ransomware monitoring is enabled in the evaluation mode.<br>`enabled` Anti-ransomware monitoring is active on the volume.<br>`paused` Anti-ransomware monitoring is paused on the volume.<br>`enable_paused` Anti-ransomware monitoring is paused on the volume from its earlier enabled state. Valid in GET operation. <br>`dry_run_paused` Anti-ransomware monitoring is paused on the volume from its earlier dry_run state. Valid in GET operation. <br>For POST, the valid Anti-ransomware states are only `disabled`, `enabled` and `dry_run`, whereas for PATCH, `paused` is also valid along with the three valid states for POST.
	// Enum: ["disabled","disable_in_progress","dry_run","enabled","paused","enable_paused","dry_run_paused"]
	State *string `json:"state,omitempty"`

	// Indicates whether or not to set the surge values as historical values. This field is no longer supported. Use update_baseline_from_surge instead.
	SurgeAsNormal *bool `json:"surge_as_normal,omitempty"`

	// surge usage
	SurgeUsage *models.VolumeInlineAntiRansomwareInlineSurgeUsage `json:"surge_usage,omitempty"`

	// suspect files
	// Read Only: true
	SuspectFiles []*VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0 `json:"suspect_files,omitempty"`

	// typical usage
	TypicalUsage *models.VolumeInlineAntiRansomwareInlineTypicalUsage `json:"typical_usage,omitempty"`

	// Sets the observed surge value as the new baseline on a volume.
	UpdateBaselineFromSurge *bool `json:"update_baseline_from_surge,omitempty"`

	// workload
	Workload *models.AntiRansomwareVolumeWorkload `json:"workload,omitempty"`
}

// Validate validates this volume inline anti ransomware
func (o *VolumeInlineAntiRansomware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAttackDetectedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAttackDetectionParameters(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAttackProbability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAttackReports(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBlockDeviceDetectionStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBlockDeviceDetectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClearSuspect(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDryRunStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEventLog(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSurgeUsage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSuspectFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTypicalUsage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkload(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file_analysis","encryption_percentage_analysis"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum = append(volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_detected_by
	// AttackDetectedBy
	// file_analysis
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackDetectedByFileAnalysis captures enum value "file_analysis"
	VolumeInlineAntiRansomwareAttackDetectedByFileAnalysis string = "file_analysis"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_detected_by
	// AttackDetectedBy
	// encryption_percentage_analysis
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackDetectedByEncryptionPercentageAnalysis captures enum value "encryption_percentage_analysis"
	VolumeInlineAntiRansomwareAttackDetectedByEncryptionPercentageAnalysis string = "encryption_percentage_analysis"
)

// prop value enum
func (o *VolumeInlineAntiRansomware) validateAttackDetectedByEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAntiRansomware) validateAttackDetectedBy(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackDetectedBy) { // not required
		return nil
	}

	// value enum
	if err := o.validateAttackDetectedByEnum("info"+"."+"anti_ransomware"+"."+"attack_detected_by", "body", *o.AttackDetectedBy); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateAttackDetectionParameters(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackDetectionParameters) { // not required
		return nil
	}

	if o.AttackDetectionParameters != nil {
		if err := o.AttackDetectionParameters.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_detection_parameters")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","low","moderate","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum = append(volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// none
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityNone captures enum value "none"
	VolumeInlineAntiRansomwareAttackProbabilityNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// low
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityLow captures enum value "low"
	VolumeInlineAntiRansomwareAttackProbabilityLow string = "low"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// moderate
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityModerate captures enum value "moderate"
	VolumeInlineAntiRansomwareAttackProbabilityModerate string = "moderate"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// high
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityHigh captures enum value "high"
	VolumeInlineAntiRansomwareAttackProbabilityHigh string = "high"
)

// prop value enum
func (o *VolumeInlineAntiRansomware) validateAttackProbabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAntiRansomware) validateAttackProbability(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackProbability) { // not required
		return nil
	}

	// value enum
	if err := o.validateAttackProbabilityEnum("info"+"."+"anti_ransomware"+"."+"attack_probability", "body", *o.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateAttackReports(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackReports) { // not required
		return nil
	}

	for i := 0; i < len(o.AttackReports); i++ {
		if swag.IsZero(o.AttackReports[i]) { // not required
			continue
		}

		if o.AttackReports[i] != nil {
			if err := o.AttackReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateBlockDeviceDetectionStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockDeviceDetectionStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"anti_ransomware"+"."+"block_device_detection_start_time", "body", "date-time", o.BlockDeviceDetectionStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["evaluation_period","active_unsuitable_workload","active_suitable_workload"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum = append(volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// evaluation_period
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateEvaluationPeriod captures enum value "evaluation_period"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateEvaluationPeriod string = "evaluation_period"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// active_unsuitable_workload
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveUnsuitableWorkload captures enum value "active_unsuitable_workload"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveUnsuitableWorkload string = "active_unsuitable_workload"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// active_suitable_workload
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveSuitableWorkload captures enum value "active_suitable_workload"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveSuitableWorkload string = "active_suitable_workload"
)

// prop value enum
func (o *VolumeInlineAntiRansomware) validateBlockDeviceDetectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAntiRansomware) validateBlockDeviceDetectionState(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockDeviceDetectionState) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockDeviceDetectionStateEnum("info"+"."+"anti_ransomware"+"."+"block_device_detection_state", "body", *o.BlockDeviceDetectionState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateClearSuspect(formats strfmt.Registry) error {
	if swag.IsZero(o.ClearSuspect) { // not required
		return nil
	}

	if o.ClearSuspect != nil {
		if err := o.ClearSuspect.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "clear_suspect")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateDryRunStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.DryRunStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"anti_ransomware"+"."+"dry_run_start_time", "body", "date-time", o.DryRunStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateEventLog(formats strfmt.Registry) error {
	if swag.IsZero(o.EventLog) { // not required
		return nil
	}

	if o.EventLog != nil {
		if err := o.EventLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "event_log")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAntiRansomwareTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","disable_in_progress","dry_run","enabled","paused","enable_paused","dry_run_paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeStatePropEnum = append(volumeInlineAntiRansomwareTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDisabled captures enum value "disabled"
	VolumeInlineAntiRansomwareStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// disable_in_progress
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDisableInProgress captures enum value "disable_in_progress"
	VolumeInlineAntiRansomwareStateDisableInProgress string = "disable_in_progress"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// dry_run
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDryRun captures enum value "dry_run"
	VolumeInlineAntiRansomwareStateDryRun string = "dry_run"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// enabled
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateEnabled captures enum value "enabled"
	VolumeInlineAntiRansomwareStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStatePaused captures enum value "paused"
	VolumeInlineAntiRansomwareStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// enable_paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateEnablePaused captures enum value "enable_paused"
	VolumeInlineAntiRansomwareStateEnablePaused string = "enable_paused"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// dry_run_paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDryRunPaused captures enum value "dry_run_paused"
	VolumeInlineAntiRansomwareStateDryRunPaused string = "dry_run_paused"
)

// prop value enum
func (o *VolumeInlineAntiRansomware) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAntiRansomware) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"anti_ransomware"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateSurgeUsage(formats strfmt.Registry) error {
	if swag.IsZero(o.SurgeUsage) { // not required
		return nil
	}

	if o.SurgeUsage != nil {
		if err := o.SurgeUsage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "surge_usage")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateSuspectFiles(formats strfmt.Registry) error {
	if swag.IsZero(o.SuspectFiles) { // not required
		return nil
	}

	for i := 0; i < len(o.SuspectFiles); i++ {
		if swag.IsZero(o.SuspectFiles[i]) { // not required
			continue
		}

		if o.SuspectFiles[i] != nil {
			if err := o.SuspectFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "suspect_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateTypicalUsage(formats strfmt.Registry) error {
	if swag.IsZero(o.TypicalUsage) { // not required
		return nil
	}

	if o.TypicalUsage != nil {
		if err := o.TypicalUsage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "typical_usage")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) validateWorkload(formats strfmt.Registry) error {
	if swag.IsZero(o.Workload) { // not required
		return nil
	}

	if o.Workload != nil {
		if err := o.Workload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "workload")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline anti ransomware based on the context it is used
func (o *VolumeInlineAntiRansomware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAttackDetectedBy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAttackDetectionParameters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAttackProbability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAttackReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockDeviceDetectionStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockDeviceDetectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClearSuspect(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDryRunStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEventLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSurgeUsage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSuspectFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTypicalUsage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateAttackDetectedBy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"attack_detected_by", "body", o.AttackDetectedBy); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateAttackDetectionParameters(ctx context.Context, formats strfmt.Registry) error {

	if o.AttackDetectionParameters != nil {
		if err := o.AttackDetectionParameters.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_detection_parameters")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateAttackProbability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"attack_probability", "body", o.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateAttackReports(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"attack_reports", "body", []*models.AntiRansomwareAttackReport(o.AttackReports)); err != nil {
		return err
	}

	for i := 0; i < len(o.AttackReports); i++ {

		if o.AttackReports[i] != nil {
			if err := o.AttackReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateBlockDeviceDetectionStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"block_device_detection_start_time", "body", o.BlockDeviceDetectionStartTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateBlockDeviceDetectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"block_device_detection_state", "body", o.BlockDeviceDetectionState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateClearSuspect(ctx context.Context, formats strfmt.Registry) error {

	if o.ClearSuspect != nil {
		if err := o.ClearSuspect.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "clear_suspect")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateDryRunStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"dry_run_start_time", "body", o.DryRunStartTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateEventLog(ctx context.Context, formats strfmt.Registry) error {

	if o.EventLog != nil {
		if err := o.EventLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "event_log")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateSurgeUsage(ctx context.Context, formats strfmt.Registry) error {

	if o.SurgeUsage != nil {
		if err := o.SurgeUsage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "surge_usage")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateSuspectFiles(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"suspect_files", "body", []*VolumeModifyCollectionParamsBodyAntiRansomwareSuspectFilesItems0(o.SuspectFiles)); err != nil {
		return err
	}

	for i := 0; i < len(o.SuspectFiles); i++ {

		if o.SuspectFiles[i] != nil {
			if err := o.SuspectFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "suspect_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateTypicalUsage(ctx context.Context, formats strfmt.Registry) error {

	if o.TypicalUsage != nil {
		if err := o.TypicalUsage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "typical_usage")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineAntiRansomware) contextValidateWorkload(ctx context.Context, formats strfmt.Registry) error {

	if o.Workload != nil {
		if err := o.Workload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "workload")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomware) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomware) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomwareInlineClearSuspect Clear suspect status.
//
swagger:model volume_inline_anti_ransomware_inline_clear_suspect
*/
type VolumeInlineAntiRansomwareInlineClearSuspect struct {

	// Clear suspect phase.
	// Enum: ["file_extension_processing","snapshot_processing","done"]
	Phase *string `json:"phase,omitempty"`

	// Clear suspect start time.
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this volume inline anti ransomware inline clear suspect
func (o *VolumeInlineAntiRansomwareInlineClearSuspect) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePhase(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file_extension_processing","snapshot_processing","done"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum = append(volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// file_extension_processing
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseFileExtensionProcessing captures enum value "file_extension_processing"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseFileExtensionProcessing string = "file_extension_processing"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// snapshot_processing
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseSnapshotProcessing captures enum value "snapshot_processing"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseSnapshotProcessing string = "snapshot_processing"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// done
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseDone captures enum value "done"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseDone string = "done"
)

// prop value enum
func (o *VolumeInlineAntiRansomwareInlineClearSuspect) validatePhaseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAntiRansomwareInlineClearSuspect) validatePhase(formats strfmt.Registry) error {
	if swag.IsZero(o.Phase) { // not required
		return nil
	}

	// value enum
	if err := o.validatePhaseEnum("info"+"."+"anti_ransomware"+"."+"clear_suspect"+"."+"phase", "body", *o.Phase); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineClearSuspect) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"anti_ransomware"+"."+"clear_suspect"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline anti ransomware inline clear suspect based on context it is used
func (o *VolumeInlineAntiRansomwareInlineClearSuspect) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineClearSuspect) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineClearSuspect) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineClearSuspect
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomwareInlineEventLog volume inline anti ransomware inline event log
swagger:model volume_inline_anti_ransomware_inline_event_log
*/
type VolumeInlineAntiRansomwareInlineEventLog struct {

	// Specifies whether to send an EMS when a new file extension is discovered.
	IsEnabledOnNewFileExtensionSeen *bool `json:"is_enabled_on_new_file_extension_seen,omitempty"`

	// Specifies whether to send an EMS when a snapshot is created.
	IsEnabledOnSnapshotCopyCreation *bool `json:"is_enabled_on_snapshot_copy_creation,omitempty"`
}

// Validate validates this volume inline anti ransomware inline event log
func (o *VolumeInlineAntiRansomwareInlineEventLog) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline anti ransomware inline event log based on context it is used
func (o *VolumeInlineAntiRansomwareInlineEventLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineEventLog) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineEventLog) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineEventLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomwareInlineSpace volume inline anti ransomware inline space
swagger:model volume_inline_anti_ransomware_inline_space
*/
type VolumeInlineAntiRansomwareInlineSpace struct {

	// Total number of Anti-ransomware backup snapshots.
	// Read Only: true
	SnapshotCount *int64 `json:"snapshot_count,omitempty"`

	// Total space in bytes used by the Anti-ransomware feature.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Space in bytes used by the Anti-ransomware analytics logs.
	// Read Only: true
	UsedByLogs *int64 `json:"used_by_logs,omitempty"`

	// Space in bytes used by the Anti-ransomware backup snapshots.
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`
}

// Validate validates this volume inline anti ransomware inline space
func (o *VolumeInlineAntiRansomwareInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline anti ransomware inline space based on the context it is used
func (o *VolumeInlineAntiRansomwareInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshotCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedByLogs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSpace) contextValidateSnapshotCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"space"+"."+"snapshot_count", "body", o.SnapshotCount); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsedByLogs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"space"+"."+"used_by_logs", "body", o.UsedByLogs); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"space"+"."+"used_by_snapshots", "body", o.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomwareInlineSurgeUsage Usage values of the volume's workload during surge. This object is no longer supported use surge_statistics instead.
swagger:model volume_inline_anti_ransomware_inline_surge_usage
*/
type VolumeInlineAntiRansomwareInlineSurgeUsage struct {

	// Peak rate of file creates per minute in the workload of the volume during surge.
	// Example: 10
	// Read Only: true
	FileCreatePeakRatePerMinute *int64 `json:"file_create_peak_rate_per_minute,omitempty"`

	// Peak rate of file deletes per minute in the workload of the volume during surge.
	// Example: 50
	// Read Only: true
	FileDeletePeakRatePerMinute *int64 `json:"file_delete_peak_rate_per_minute,omitempty"`

	// Peak rate of file renames per minute in the workload of the volume during surge.
	// Example: 30
	// Read Only: true
	FileRenamePeakRatePerMinute *int64 `json:"file_rename_peak_rate_per_minute,omitempty"`

	// Peak percentage of high entropy data writes in the volume during surge.
	// Example: 30
	// Read Only: true
	HighEntropyDataWritePeakPercent *int64 `json:"high_entropy_data_write_peak_percent,omitempty"`

	// Peak high entropy data write rate in the volume during surge, in KBs per minute.
	// Example: 2500
	// Read Only: true
	HighEntropyDataWritePeakRateKbPerMinute *int64 `json:"high_entropy_data_write_peak_rate_kb_per_minute,omitempty"`

	// Timestamp at which the first surge in the volume's workload is observed.
	// Example: 2021-12-01 23:16:20+05:30
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this volume inline anti ransomware inline surge usage
func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"time", "body", "date-time", o.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline anti ransomware inline surge usage based on the context it is used
func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFileCreatePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileDeletePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileRenamePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHighEntropyDataWritePeakPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileCreatePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"file_create_peak_rate_per_minute", "body", o.FileCreatePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileDeletePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"file_delete_peak_rate_per_minute", "body", o.FileDeletePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileRenamePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"file_rename_peak_rate_per_minute", "body", o.FileRenamePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateHighEntropyDataWritePeakPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"high_entropy_data_write_peak_percent", "body", o.HighEntropyDataWritePeakPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"high_entropy_data_write_peak_rate_kb_per_minute", "body", o.HighEntropyDataWritePeakRateKbPerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"surge_usage"+"."+"time", "body", o.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineSurgeUsage) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineSurgeUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAntiRansomwareInlineTypicalUsage Typical usage values of volume workload. This object is no longer supported use historical_statistics instead.
swagger:model volume_inline_anti_ransomware_inline_typical_usage
*/
type VolumeInlineAntiRansomwareInlineTypicalUsage struct {

	// Typical peak rate of file creates per minute in the workload of the volume.
	// Example: 50
	// Read Only: true
	FileCreatePeakRatePerMinute *int64 `json:"file_create_peak_rate_per_minute,omitempty"`

	// Typical peak rate of file deletes per minute in the workload of the volume.
	// Example: 10
	// Read Only: true
	FileDeletePeakRatePerMinute *int64 `json:"file_delete_peak_rate_per_minute,omitempty"`

	// Typical peak rate of file renames per minute in the workload of the volume.
	// Example: 5
	// Read Only: true
	FileRenamePeakRatePerMinute *int64 `json:"file_rename_peak_rate_per_minute,omitempty"`

	// Typical peak percentage of high entropy data writes in the volume.
	// Example: 10
	// Read Only: true
	HighEntropyDataWritePeakPercent *int64 `json:"high_entropy_data_write_peak_percent,omitempty"`

	// Typical peak high entropy data write rate in the volume, in KBs per minute.
	// Example: 1200
	// Read Only: true
	HighEntropyDataWritePeakRateKbPerMinute *int64 `json:"high_entropy_data_write_peak_rate_kb_per_minute,omitempty"`
}

// Validate validates this volume inline anti ransomware inline typical usage
func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline anti ransomware inline typical usage based on the context it is used
func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFileCreatePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileDeletePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileRenamePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHighEntropyDataWritePeakPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileCreatePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"typical_usage"+"."+"file_create_peak_rate_per_minute", "body", o.FileCreatePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileDeletePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"typical_usage"+"."+"file_delete_peak_rate_per_minute", "body", o.FileDeletePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileRenamePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"typical_usage"+"."+"file_rename_peak_rate_per_minute", "body", o.FileRenamePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateHighEntropyDataWritePeakPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"typical_usage"+"."+"high_entropy_data_write_peak_percent", "body", o.HighEntropyDataWritePeakPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"typical_usage"+"."+"high_entropy_data_write_peak_rate_kb_per_minute", "body", o.HighEntropyDataWritePeakRateKbPerMinute); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAntiRansomwareInlineTypicalUsage) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineTypicalUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineApplication volume inline application
swagger:model volume_inline_application
*/
type VolumeInlineApplication struct {

	// Name of the application to which the volume belongs. Available only when the volume is part of an application.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// UUID of the application to which the volume belongs. Available only when the volume is part of an application.
	// Example: 1cd8a442-86d1-11e0-ae1d-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline application
func (o *VolumeInlineApplication) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline application based on the context it is used
func (o *VolumeInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineApplication) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"application"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineApplication) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"application"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineApplication) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineApplication) UnmarshalBinary(b []byte) error {
	var res VolumeInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAsynchronousDirectoryDelete Configuration for asynchronous directory delete from the client. This is only supported on Flexible volumes and FlexGroup volumes.
swagger:model volume_inline_asynchronous_directory_delete
*/
type VolumeInlineAsynchronousDirectoryDelete struct {

	// Specifies whether asynchronous directory delete from the client is enabled on the volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of the trash bin directory. If no "trash_bin" property is specified when enabling, the default trash bin name, "._ontaptrashbin", is used.
	TrashBin *string `json:"trash_bin,omitempty"`
}

// Validate validates this volume inline asynchronous directory delete
func (o *VolumeInlineAsynchronousDirectoryDelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline asynchronous directory delete based on context it is used
func (o *VolumeInlineAsynchronousDirectoryDelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAsynchronousDirectoryDelete) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAsynchronousDirectoryDelete) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAsynchronousDirectoryDelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineAutosize volume inline autosize
swagger:model volume_inline_autosize
*/
type VolumeInlineAutosize struct {

	// Used space threshold size, in percentage, for the automatic growth of the volume. When the amount of used space in the volume becomes greater than this threshold, the volume automatically grows unless it has reached the maximum size. The volume grows when 'space.used' is greater than this percent of 'space.size'. The 'grow_threshold' size cannot be less than or equal to the 'shrink_threshold' size..
	GrowThreshold *int64 `json:"grow_threshold,omitempty"`

	// Maximum size in bytes up to which a volume grows automatically. This size cannot be less than the current volume size, or less than or equal to the minimum size of volume.
	Maximum *int64 `json:"maximum,omitempty"`

	// Minimum size in bytes up to which the volume shrinks automatically. This size cannot be greater than or equal to the maximum size of volume.
	Minimum *int64 `json:"minimum,omitempty"`

	// Autosize mode for the volume.<br>grow &dash; Volume automatically grows when the amount of used space is above the 'grow_threshold' value.<br>grow_shrink &dash; Volume grows or shrinks in response to the amount of space used.<br>off &dash; Autosizing of the volume is disabled.
	// Enum: ["grow","grow_shrink","off"]
	Mode *string `json:"mode,omitempty"`

	// Used space threshold size, in percentage, for the automatic shrinkage of the volume.  When the amount of used space in the volume drops below this threshold, the volume automatically shrinks unless it has reached the minimum size. The volume shrinks when the 'space.used' is less than the 'shrink_threshold' percent of 'space.size'. The 'shrink_threshold' size cannot be greater than or equal to the 'grow_threshold' size.
	ShrinkThreshold *int64 `json:"shrink_threshold,omitempty"`
}

// Validate validates this volume inline autosize
func (o *VolumeInlineAutosize) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAutosizeTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["grow","grow_shrink","off"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAutosizeTypeModePropEnum = append(volumeInlineAutosizeTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// grow
	// END DEBUGGING
	// VolumeInlineAutosizeModeGrow captures enum value "grow"
	VolumeInlineAutosizeModeGrow string = "grow"

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// grow_shrink
	// END DEBUGGING
	// VolumeInlineAutosizeModeGrowShrink captures enum value "grow_shrink"
	VolumeInlineAutosizeModeGrowShrink string = "grow_shrink"

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// off
	// END DEBUGGING
	// VolumeInlineAutosizeModeOff captures enum value "off"
	VolumeInlineAutosizeModeOff string = "off"
)

// prop value enum
func (o *VolumeInlineAutosize) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAutosizeTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineAutosize) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"autosize"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline autosize based on context it is used
func (o *VolumeInlineAutosize) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineAutosize) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineAutosize) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAutosize
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineClone volume inline clone
swagger:model volume_inline_clone
*/
type VolumeInlineClone struct {

	// Specifies whether this volume is a parent of any FlexClone volume.
	// Read Only: true
	HasFlexclone *bool `json:"has_flexclone,omitempty"`

	// Inherited physical used from the clone's base snapshot.
	// Read Only: true
	InheritedPhysicalUsed *int64 `json:"inherited_physical_used,omitempty"`

	// Inherited savings from the clone's base snapshot.
	// Read Only: true
	InheritedSavings *int64 `json:"inherited_savings,omitempty"`

	// Specifies if this volume is a normal FlexVol volume or FlexClone volume. This field needs to be set when creating a FlexClone volume. Valid in POST.
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// This optional parameter specifies the name of a LUN that will be non-disruptively migrated to the newly created FlexClone volume. If not specified, no LUNs are migrated.
	LunName *string `json:"lun_name,omitempty"`

	// parent snapshot
	ParentSnapshot *models.SnapshotReference `json:"parent_snapshot,omitempty"`

	// parent svm
	ParentSvm *models.VolumeInlineCloneInlineParentSvm `json:"parent_svm,omitempty"`

	// parent volume
	ParentVolume *models.VolumeInlineCloneInlineParentVolume `json:"parent_volume,omitempty"`

	// This optional parameter specifies the name of the qtree containing the LUN that will be non-disruptively migrated to the newly created FlexClone volume.
	QtreeName *string `json:"qtree_name,omitempty"`

	// Percentage of FlexClone volume blocks split from its parent volume.
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required by the containing-aggregate to split the FlexClone volume.
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// This field is set when a split is executed on any FlexClone volume, that is when the FlexClone volume is split from its parent FlexVol volume. Setting this field initiates a split of a FlexClone volume from a FlexVol volume. Valid in PATCH.
	SplitInitiated *bool `json:"split_initiated,omitempty"`
}

// Validate validates this volume inline clone
func (o *VolumeInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateParentSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineClone) validateParentSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentSnapshot) { // not required
		return nil
	}

	if o.ParentSnapshot != nil {
		if err := o.ParentSnapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineClone) validateParentSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentSvm) { // not required
		return nil
	}

	if o.ParentSvm != nil {
		if err := o.ParentSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineClone) validateParentVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentVolume) { // not required
		return nil
	}

	if o.ParentVolume != nil {
		if err := o.ParentVolume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone based on the context it is used
func (o *VolumeInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHasFlexclone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInheritedPhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInheritedSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineClone) contextValidateHasFlexclone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"clone"+"."+"has_flexclone", "body", o.HasFlexclone); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateInheritedPhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"clone"+"."+"inherited_physical_used", "body", o.InheritedPhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateInheritedSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"clone"+"."+"inherited_savings", "body", o.InheritedSavings); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateParentSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentSnapshot != nil {
		if err := o.ParentSnapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateParentSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentSvm != nil {
		if err := o.ParentSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateParentVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentVolume != nil {
		if err := o.ParentVolume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"clone"+"."+"split_complete_percent", "body", o.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"clone"+"."+"split_estimate", "body", o.SplitEstimate); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineClone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineClone) UnmarshalBinary(b []byte) error {
	var res VolumeInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineCloneInlineParentSvm SVM, applies only to SVM-scoped objects.
swagger:model volume_inline_clone_inline_parent_svm
*/
type VolumeInlineCloneInlineParentSvm struct {

	// links
	Links *models.VolumeInlineCloneInlineParentSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline clone inline parent svm
func (o *VolumeInlineCloneInlineParentSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent svm based on the context it is used
func (o *VolumeInlineCloneInlineParentSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentSvm) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineCloneInlineParentSvmInlineLinks volume inline clone inline parent svm inline links
swagger:model volume_inline_clone_inline_parent_svm_inline__links
*/
type VolumeInlineCloneInlineParentSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline clone inline parent svm inline links
func (o *VolumeInlineCloneInlineParentSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent svm inline links based on the context it is used
func (o *VolumeInlineCloneInlineParentSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineCloneInlineParentVolume volume inline clone inline parent volume
swagger:model volume_inline_clone_inline_parent_volume
*/
type VolumeInlineCloneInlineParentVolume struct {

	// links
	Links *models.VolumeInlineCloneInlineParentVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline clone inline parent volume
func (o *VolumeInlineCloneInlineParentVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent volume based on the context it is used
func (o *VolumeInlineCloneInlineParentVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentVolume) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineCloneInlineParentVolumeInlineLinks volume inline clone inline parent volume inline links
swagger:model volume_inline_clone_inline_parent_volume_inline__links
*/
type VolumeInlineCloneInlineParentVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline clone inline parent volume inline links
func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent volume inline links based on the context it is used
func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "parent_volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineCloneInlineParentVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConsistencyGroup Consistency group the volume is part of.
swagger:model volume_inline_consistency_group
*/
type VolumeInlineConsistencyGroup struct {

	// The name of the consistency group to which the volume belongs. Available only when the volume is part of a consistency group. If this volume belongs to a child consistency group, then this will be the UUID of the parent consistency group.
	// Example: consistency_group_1
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group to which the volume belongs. Available only when the volume is part of a consistency group. If this volume belongs to a child consistency group, then this will be the UUID of the parent consistency group.
	// Example: 1cd8a442-86d1-11e0-ae1d-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline consistency group
func (o *VolumeInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline consistency group based on the context it is used
func (o *VolumeInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"consistency_group"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItem volume inline constituents inline array item
swagger:model volume_inline_constituents_inline_array_item
*/
type VolumeInlineConstituentsInlineArrayItem struct {

	// aggregates
	Aggregates *models.VolumeInlineConstituentsInlineArrayItemInlineAggregates `json:"aggregates,omitempty"`

	// movement
	Movement *models.VolumeInlineConstituentsInlineArrayItemInlineMovement `json:"movement,omitempty"`

	// FlexGroup volume constituent name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *models.VolumeInlineConstituentsInlineArrayItemInlineNode `json:"node,omitempty"`

	// space
	Space *models.VolumeInlineConstituentsInlineArrayItemInlineSpace `json:"space,omitempty"`
}

// Validate validates this volume inline constituents inline array item
func (o *VolumeInlineConstituentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) validateAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregates) { // not required
		return nil
	}

	if o.Aggregates != nil {
		if err := o.Aggregates.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregates")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(o.Movement) { // not required
		return nil
	}

	if o.Movement != nil {
		if err := o.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) contextValidateAggregates(ctx context.Context, formats strfmt.Registry) error {

	if o.Aggregates != nil {
		if err := o.Aggregates.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregates")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if o.Movement != nil {
		if err := o.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineAggregates volume inline constituents inline array item inline aggregates
swagger:model volume_inline_constituents_inline_array_item_inline_aggregates
*/
type VolumeInlineConstituentsInlineArrayItemInlineAggregates struct {

	// Name of the aggregate hosting the FlexGroup volume constituent.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Unique identifier for the aggregate.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline aggregates
func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline aggregates based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineAggregates) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineAggregates
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineMovement Volume movement. All attributes are modify, that is, not writable through POST. Set PATCH state to destination_aggregate to initiate a volume move operation.
swagger:model volume_inline_constituents_inline_array_item_inline_movement
*/
type VolumeInlineConstituentsInlineArrayItemInlineMovement struct {

	// Time window in seconds for cutover. The allowed range is between 30 to 300 seconds.
	// Example: 30
	CutoverWindow *int64 `json:"cutover_window,omitempty"`

	// destination aggregate
	DestinationAggregate *models.VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate `json:"destination_aggregate,omitempty"`

	// Completion percentage
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// State of volume move operation. PATCH the state to "aborted" to abort the move operation. PATCH the state to "cutover" to trigger cutover. PATCH the state to "paused" to pause the volume move operation in progress. PATCH the state to "replicating" to resume the paused volume move operation. PATCH the state to "cutover_wait" to go into cutover manually. When volume move operation is waiting to go into "cutover" state, this is indicated by the "cutover_pending" state. A change of state is only supported if volume movement is in progress.
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`

	// Tiering policy for FabricPool
	// Enum: ["all","auto","backup","none","snapshot_only"]
	TieringPolicy *string `json:"tiering_policy,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestinationAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTieringPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateDestinationAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.DestinationAggregate) { // not required
		return nil
	}

	if o.DestinationAggregate != nil {
		if err := o.DestinationAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum = append(volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateAborted captures enum value "aborted"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutover captures enum value "cutover"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverWait captures enum value "cutover_wait"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverPending captures enum value "cutover_pending"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateFailed captures enum value "failed"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStatePaused captures enum value "paused"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateQueued captures enum value "queued"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateReplicating captures enum value "replicating"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateSuccess captures enum value "success"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateSuccess string = "success"
)

// prop value enum
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("movement"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum = append(volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// all
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAll captures enum value "all"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAuto captures enum value "auto"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// backup
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyBackup captures enum value "backup"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// none
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyNone captures enum value "none"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateTieringPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateTieringPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.TieringPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateTieringPolicyEnum("movement"+"."+"tiering_policy", "body", *o.TieringPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestinationAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) contextValidateDestinationAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.DestinationAggregate != nil {
		if err := o.DestinationAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"percent_complete", "body", o.PercentComplete); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate Aggregate
swagger:model volume_inline_constituents_inline_array_item_inline_movement_inline_destination_aggregate
*/
type VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate struct {

	// links
	Links *models.VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement inline destination aggregate
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement inline destination aggregate based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks volume inline constituents inline array item inline movement inline destination aggregate inline links
swagger:model volume_inline_constituents_inline_array_item_inline_movement_inline_destination_aggregate_inline__links
*/
type VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement inline destination aggregate inline links
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement inline destination aggregate inline links based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineNode volume inline constituents inline array item inline node
swagger:model volume_inline_constituents_inline_array_item_inline_node
*/
type VolumeInlineConstituentsInlineArrayItemInlineNode struct {

	// List of the node names hosting the FlexGroup volume constituent.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// List of the node UUIDs hosting the FlexGroup volume constituent.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline node
func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline node based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineSpace volume inline constituents inline array item inline space
swagger:model volume_inline_constituents_inline_array_item_inline_space
*/
type VolumeInlineConstituentsInlineArrayItemInlineSpace struct {

	// Total size of AFS, excluding snap-reserve, in bytes.
	AfsTotal *int64 `json:"afs_total,omitempty"`

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The space available, as a percent.
	AvailablePercent *int64 `json:"available_percent,omitempty"`

	// The size that is physically used in the block storage of the volume and has a cold temperature. In bytes. This parameter is only supported if the volume is in an aggregate that is either attached to a cloud store or could be attached to a cloud store.
	// Read Only: true
	BlockStorageInactiveUserData *int64 `json:"block_storage_inactive_user_data,omitempty"`

	// Space used by capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprint *int64 `json:"capacity_tier_footprint,omitempty"`

	// Data used for this volume in the aggregate, in bytes.
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// Specifies whether the support for large volumes and large files is enabled on the volume.
	LargeSizeEnabled *bool `json:"large_size_enabled,omitempty"`

	// Space used by the local tier for this volume in the aggregate, in bytes.
	// Read Only: true
	LocalTierFootprint *int64 `json:"local_tier_footprint,omitempty"`

	// logical space
	LogicalSpace *models.VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace `json:"logical_space,omitempty"`

	// Indicates the maximum size supported for each constituent of the FlexGroup volume.
	// Enum: ["100T","300T","600T"]
	MaxSize *string `json:"max_size,omitempty"`

	// Space used by the volume metadata in the aggregate, in bytes.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// The amount of space not available for this volume in the aggregate, in bytes.
	// Read Only: true
	OverProvisioned *int64 `json:"over_provisioned,omitempty"`

	// Space used by the performance tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	PerformanceTierFootprint *int64 `json:"performance_tier_footprint,omitempty"`

	// Total provisioned size. The default size is equal to the minimum size of 20MB, in bytes.
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// Data and metadata used for this volume in the aggregate, in bytes.
	// Read Only: true
	TotalFootprint *int64 `json:"total_footprint,omitempty"`

	// Space used by the total metadata in the volume, in bytes.
	// Read Only: true
	TotalMetadata *int64 `json:"total_metadata,omitempty"`

	// Space used by the volume metadata footprint in the aggregate, in bytes.
	// Read Only: true
	TotalMetadataFootprint *int64 `json:"total_metadata_footprint,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The space used by Active Filesystem, in bytes.
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, as a percent.
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLogicalSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateLogicalSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.LogicalSpace) { // not required
		return nil
	}

	if o.LogicalSpace != nil {
		if err := o.LogicalSpace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["100T","300T","600T"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum = append(volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 100T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr100T captures enum value "100T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr100T string = "100T"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 300T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr300T captures enum value "300T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr300T string = "300T"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 600T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr600T captures enum value "600T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr600T string = "600T"
)

// prop value enum
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateMaxSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateMaxSize(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateMaxSizeEnum("space"+"."+"max_size", "body", *o.MaxSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockStorageInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCapacityTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOverProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePerformanceTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalMetadataFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateBlockStorageInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage_inactive_user_data", "body", o.BlockStorageInactiveUserData); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateCapacityTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"capacity_tier_footprint", "body", o.CapacityTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"footprint", "body", o.Footprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateLocalTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"local_tier_footprint", "body", o.LocalTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateLogicalSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.LogicalSpace != nil {
		if err := o.LogicalSpace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"metadata", "body", o.Metadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateOverProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"over_provisioned", "body", o.OverProvisioned); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidatePerformanceTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"performance_tier_footprint", "body", o.PerformanceTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_footprint", "body", o.TotalFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata", "body", o.TotalMetadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalMetadataFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata_footprint", "body", o.TotalMetadataFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace volume inline constituents inline array item inline space inline logical space
swagger:model volume_inline_constituents_inline_array_item_inline_space_inline_logical_space
*/
type VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace struct {

	// The amount of space available in this volume with storage efficiency space considered used, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Specifies whether space accounting for operations on the volume is done along with storage efficiency.
	Enforcement *bool `json:"enforcement,omitempty"`

	// Specifies whether space reporting on the volume is done along with storage efficiency.
	Reporting *bool `json:"reporting,omitempty"`

	// The virtual space used by AFS alone (includes volume reserves) and along with storage efficiency, in bytes.
	// Read Only: true
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space inline logical space
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space inline logical space based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedByAfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) contextValidateUsedByAfs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used_by_afs", "body", o.UsedByAfs); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot volume inline constituents inline array item inline space inline snapshot
swagger:model volume_inline_constituents_inline_array_item_inline_space_inline_snapshot
*/
type VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot struct {

	// Specifies whether snapshot autodelete is currently enabled on this volume.
	AutodeleteEnabled *bool `json:"autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// The total space used by snapshots in the volume, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space inline snapshot
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space inline snapshot based on the context it is used
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEfficiency volume inline efficiency
swagger:model volume_inline_efficiency
*/
type VolumeInlineEfficiency struct {

	// Block size to use by compression. 8k and auto are only allowed for POST. Only auto is supported on QAT supported platforms.
	// Enum: ["8k","16k","32k","auto"]
	ApplicationIoSize *string `json:"application_io_size,omitempty"`

	// Automatic deduplication schedule volume state.<br>auto &dash; Volumes with auto_state set to auto start post-process deduplication automatically.<br>deprioritized &dash; Volumes with auto_state set to deprioritized do not start post-process deduplication automatically.
	// Read Only: true
	// Enum: ["auto","deprioritized"]
	AutoState *string `json:"auto_state,omitempty"`

	// The system can be enabled/disabled compaction.<br>inline &dash; Data will be compacted first and written to the volume.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are compaction enabled and some are disabled.
	// Enum: ["inline","none","mixed"]
	Compaction *string `json:"compaction,omitempty"`

	// The system can be enabled/disabled compression. Disabling compression is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be compressed first and written to the volume. <br>background &dash; Data will be written to the volume and compressed later. <br>both &dash; Inline compression compresses the data and write to the volume, background compression compresses only the blocks on which inline compression is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are compression enabled and some are disabled. <br>Note that On volumes with container compression enabled, background compression refers to inactive data compression scan enabled on the volume.
	// Enum: ["inline","background","both","none","mixed"]
	Compression *string `json:"compression,omitempty"`

	// Compression type to use by compression. Valid for PATCH and GET.
	// Enum: ["none","secondary","adaptive"]
	CompressionType *string `json:"compression_type,omitempty"`

	// The system can be enabled/disabled cross volume dedupe. it can be enabled only when dedupe is enabled. Disabling cross volume dedupe is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be cross volume deduped first and written to the volume.<br>background &dash; Data will be written to the volume and cross volume deduped later.<br>both &dash; Inline cross volume dedupe dedupes the data and write to the volume, background cross volume dedupe dedupes only the blocks on which inline dedupe is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are cross volume dedupe enabled and some are disabled.
	// Enum: ["inline","background","both","none","mixed"]
	CrossVolumeDedupe *string `json:"cross_volume_dedupe,omitempty"`

	// The system can be enabled/disabled dedupe. Disabling dedupe is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be deduped first and written to the volume.<br>background &dash; Data will be written to the volume and deduped later.<br>both &dash; Inline dedupe dedupes the data and write to the volume, background dedupe dedupes only the blocks on which inline dedupe is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are dedupe enabled and some are disabled.
	// Enum: ["inline","background","both","none","mixed"]
	Dedupe *string `json:"dedupe,omitempty"`

	// When true, indicates that the volume contains shared(deduplication, file clones) or compressed data.
	// Read Only: true
	HasSavings *bool `json:"has_savings,omitempty"`

	// idcs scanner
	IdcsScanner *models.VolumeInlineEfficiencyInlineIdcsScanner `json:"idcs_scanner,omitempty"`

	// Last sis operation begin timestamp.
	// Read Only: true
	LastOpBegin *string `json:"last_op_begin,omitempty"`

	// Last sis operation end timestamp.
	// Read Only: true
	LastOpEnd *string `json:"last_op_end,omitempty"`

	// Last sis operation error text.
	// Read Only: true
	LastOpErr *string `json:"last_op_err,omitempty"`

	// Last sis operation size.
	// Read Only: true
	LastOpSize *int64 `json:"last_op_size,omitempty"`

	// Last sis operation state.
	// Read Only: true
	LastOpState *string `json:"last_op_state,omitempty"`

	// When true, indicates that space savings for any newly-written data are being logged.
	// Read Only: true
	LoggingEnabled *bool `json:"logging_enabled,omitempty"`

	// Sis status of the volume.
	// Read Only: true
	// Enum: ["idle","initializing","active","undoing","pending","downgrading","disabled"]
	OpState *string `json:"op_state,omitempty"`

	// policy
	Policy *models.VolumeInlineEfficiencyInlinePolicy `json:"policy,omitempty"`

	// Sis progress of the volume.
	// Read Only: true
	Progress *string `json:"progress,omitempty"`

	// Storage efficiency that does not include the savings provided by snapshots.
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// scanner
	Scanner *models.VolumeInlineEfficiencyInlineScanner `json:"scanner,omitempty"`

	// Schedule associated with volume.
	// Read Only: true
	Schedule *string `json:"schedule,omitempty"`

	// space savings
	SpaceSavings *models.VolumeInlineEfficiencyInlineSpaceSavings `json:"space_savings,omitempty"`

	// Storage efficiency state of the volume. Currently, this field supports POST/PATCH only for RW (Read-Write) volumes on FSx for ONTAP and Cloud Volumes ONTAP.<br>disabled &dash; All storage efficiency features are disabled.<br>mixed &dash; Read-only field for FlexGroup volumes, storage efficiency is enabled on certain constituents and disabled on others.<br>On FSx for ONTAP and Cloud Volumes ONTAP &dash; <br> &emsp; enabled &dash; All supported storage efficiency features for the volume are enabled.<br> &emsp; custom &dash; Read-only field currently only supported for the FSx for ONTAP and Cloud Volumes ONTAP, user-defined storage efficiency features are enabled.<br>For other platforms &dash; <br> &emsp; enabled &dash; At least one storage efficiency feature for the volume is enabled.
	// Enum: ["disabled","enabled","mixed","custom"]
	State *string `json:"state,omitempty"`

	// Storage efficiency mode used by volume. This parameter is supported only on AFF platforms. There is no difference between default and efficient modes on QAT supported platforms and auto adaptive compression is set irrespective of the modes.
	// Enum: ["default","efficient"]
	StorageEfficiencyMode *string `json:"storage_efficiency_mode,omitempty"`

	// Sis Type of the volume.
	// Read Only: true
	// Enum: ["regular","snapvault"]
	Type *string `json:"type,omitempty"`

	// Absolute volume path of the volume.
	// Read Only: true
	VolumePath *string `json:"volume_path,omitempty"`
}

// Validate validates this volume inline efficiency
func (o *VolumeInlineEfficiency) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateApplicationIoSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAutoState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCompaction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCompression(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCompressionType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCrossVolumeDedupe(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDedupe(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIdcsScanner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOpState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpaceSavings(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageEfficiencyMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyTypeApplicationIoSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["8k","16k","32k","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeApplicationIoSizePropEnum = append(volumeInlineEfficiencyTypeApplicationIoSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 8k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr8k captures enum value "8k"
	VolumeInlineEfficiencyApplicationIoSizeNr8k string = "8k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 16k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr16k captures enum value "16k"
	VolumeInlineEfficiencyApplicationIoSizeNr16k string = "16k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 32k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr32k captures enum value "32k"
	VolumeInlineEfficiencyApplicationIoSizeNr32k string = "32k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// auto
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeAuto captures enum value "auto"
	VolumeInlineEfficiencyApplicationIoSizeAuto string = "auto"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateApplicationIoSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeApplicationIoSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateApplicationIoSize(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationIoSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateApplicationIoSizeEnum("info"+"."+"efficiency"+"."+"application_io_size", "body", *o.ApplicationIoSize); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeAutoStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto","deprioritized"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeAutoStatePropEnum = append(volumeInlineEfficiencyTypeAutoStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// auto_state
	// AutoState
	// auto
	// END DEBUGGING
	// VolumeInlineEfficiencyAutoStateAuto captures enum value "auto"
	VolumeInlineEfficiencyAutoStateAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// auto_state
	// AutoState
	// deprioritized
	// END DEBUGGING
	// VolumeInlineEfficiencyAutoStateDeprioritized captures enum value "deprioritized"
	VolumeInlineEfficiencyAutoStateDeprioritized string = "deprioritized"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateAutoStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeAutoStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateAutoState(formats strfmt.Registry) error {
	if swag.IsZero(o.AutoState) { // not required
		return nil
	}

	// value enum
	if err := o.validateAutoStateEnum("info"+"."+"efficiency"+"."+"auto_state", "body", *o.AutoState); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompactionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompactionPropEnum = append(volumeInlineEfficiencyTypeCompactionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionInline captures enum value "inline"
	VolumeInlineEfficiencyCompactionInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionNone captures enum value "none"
	VolumeInlineEfficiencyCompactionNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionMixed captures enum value "mixed"
	VolumeInlineEfficiencyCompactionMixed string = "mixed"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateCompactionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompactionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateCompaction(formats strfmt.Registry) error {
	if swag.IsZero(o.Compaction) { // not required
		return nil
	}

	// value enum
	if err := o.validateCompactionEnum("info"+"."+"efficiency"+"."+"compaction", "body", *o.Compaction); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompressionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompressionPropEnum = append(volumeInlineEfficiencyTypeCompressionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionInline captures enum value "inline"
	VolumeInlineEfficiencyCompressionInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionBackground captures enum value "background"
	VolumeInlineEfficiencyCompressionBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionBoth captures enum value "both"
	VolumeInlineEfficiencyCompressionBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionNone captures enum value "none"
	VolumeInlineEfficiencyCompressionNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionMixed captures enum value "mixed"
	VolumeInlineEfficiencyCompressionMixed string = "mixed"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateCompressionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompressionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateCompression(formats strfmt.Registry) error {
	if swag.IsZero(o.Compression) { // not required
		return nil
	}

	// value enum
	if err := o.validateCompressionEnum("info"+"."+"efficiency"+"."+"compression", "body", *o.Compression); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompressionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","secondary","adaptive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompressionTypePropEnum = append(volumeInlineEfficiencyTypeCompressionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeNone captures enum value "none"
	VolumeInlineEfficiencyCompressionTypeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// secondary
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeSecondary captures enum value "secondary"
	VolumeInlineEfficiencyCompressionTypeSecondary string = "secondary"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// adaptive
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeAdaptive captures enum value "adaptive"
	VolumeInlineEfficiencyCompressionTypeAdaptive string = "adaptive"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateCompressionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompressionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateCompressionType(formats strfmt.Registry) error {
	if swag.IsZero(o.CompressionType) { // not required
		return nil
	}

	// value enum
	if err := o.validateCompressionTypeEnum("info"+"."+"efficiency"+"."+"compression_type", "body", *o.CompressionType); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum = append(volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeInline captures enum value "inline"
	VolumeInlineEfficiencyCrossVolumeDedupeInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeBackground captures enum value "background"
	VolumeInlineEfficiencyCrossVolumeDedupeBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeBoth captures enum value "both"
	VolumeInlineEfficiencyCrossVolumeDedupeBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeNone captures enum value "none"
	VolumeInlineEfficiencyCrossVolumeDedupeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeMixed captures enum value "mixed"
	VolumeInlineEfficiencyCrossVolumeDedupeMixed string = "mixed"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateCrossVolumeDedupeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateCrossVolumeDedupe(formats strfmt.Registry) error {
	if swag.IsZero(o.CrossVolumeDedupe) { // not required
		return nil
	}

	// value enum
	if err := o.validateCrossVolumeDedupeEnum("info"+"."+"efficiency"+"."+"cross_volume_dedupe", "body", *o.CrossVolumeDedupe); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeDedupePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeDedupePropEnum = append(volumeInlineEfficiencyTypeDedupePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeInline captures enum value "inline"
	VolumeInlineEfficiencyDedupeInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeBackground captures enum value "background"
	VolumeInlineEfficiencyDedupeBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeBoth captures enum value "both"
	VolumeInlineEfficiencyDedupeBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeNone captures enum value "none"
	VolumeInlineEfficiencyDedupeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeMixed captures enum value "mixed"
	VolumeInlineEfficiencyDedupeMixed string = "mixed"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateDedupeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeDedupePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateDedupe(formats strfmt.Registry) error {
	if swag.IsZero(o.Dedupe) { // not required
		return nil
	}

	// value enum
	if err := o.validateDedupeEnum("info"+"."+"efficiency"+"."+"dedupe", "body", *o.Dedupe); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) validateIdcsScanner(formats strfmt.Registry) error {
	if swag.IsZero(o.IdcsScanner) { // not required
		return nil
	}

	if o.IdcsScanner != nil {
		if err := o.IdcsScanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "idcs_scanner")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEfficiencyTypeOpStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","initializing","active","undoing","pending","downgrading","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeOpStatePropEnum = append(volumeInlineEfficiencyTypeOpStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateIdle captures enum value "idle"
	VolumeInlineEfficiencyOpStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// initializing
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateInitializing captures enum value "initializing"
	VolumeInlineEfficiencyOpStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateActive captures enum value "active"
	VolumeInlineEfficiencyOpStateActive string = "active"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// undoing
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateUndoing captures enum value "undoing"
	VolumeInlineEfficiencyOpStateUndoing string = "undoing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// pending
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStatePending captures enum value "pending"
	VolumeInlineEfficiencyOpStatePending string = "pending"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// downgrading
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateDowngrading captures enum value "downgrading"
	VolumeInlineEfficiencyOpStateDowngrading string = "downgrading"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyOpStateDisabled string = "disabled"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateOpStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeOpStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateOpState(formats strfmt.Registry) error {
	if swag.IsZero(o.OpState) { // not required
		return nil
	}

	// value enum
	if err := o.validateOpStateEnum("info"+"."+"efficiency"+"."+"op_state", "body", *o.OpState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(o.Scanner) { // not required
		return nil
	}

	if o.Scanner != nil {
		if err := o.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) validateSpaceSavings(formats strfmt.Registry) error {
	if swag.IsZero(o.SpaceSavings) { // not required
		return nil
	}

	if o.SpaceSavings != nil {
		if err := o.SpaceSavings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "space_savings")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEfficiencyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","mixed","custom"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeStatePropEnum = append(volumeInlineEfficiencyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// enabled
	// END DEBUGGING
	// VolumeInlineEfficiencyStateEnabled captures enum value "enabled"
	VolumeInlineEfficiencyStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyStateMixed captures enum value "mixed"
	VolumeInlineEfficiencyStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// custom
	// END DEBUGGING
	// VolumeInlineEfficiencyStateCustom captures enum value "custom"
	VolumeInlineEfficiencyStateCustom string = "custom"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"efficiency"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","efficient"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum = append(volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// storage_efficiency_mode
	// StorageEfficiencyMode
	// default
	// END DEBUGGING
	// VolumeInlineEfficiencyStorageEfficiencyModeDefault captures enum value "default"
	VolumeInlineEfficiencyStorageEfficiencyModeDefault string = "default"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// storage_efficiency_mode
	// StorageEfficiencyMode
	// efficient
	// END DEBUGGING
	// VolumeInlineEfficiencyStorageEfficiencyModeEfficient captures enum value "efficient"
	VolumeInlineEfficiencyStorageEfficiencyModeEfficient string = "efficient"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateStorageEfficiencyModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateStorageEfficiencyMode(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageEfficiencyMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageEfficiencyModeEnum("info"+"."+"efficiency"+"."+"storage_efficiency_mode", "body", *o.StorageEfficiencyMode); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","snapvault"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeTypePropEnum = append(volumeInlineEfficiencyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// type
	// Type
	// regular
	// END DEBUGGING
	// VolumeInlineEfficiencyTypeRegular captures enum value "regular"
	VolumeInlineEfficiencyTypeRegular string = "regular"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// type
	// Type
	// snapvault
	// END DEBUGGING
	// VolumeInlineEfficiencyTypeSnapvault captures enum value "snapvault"
	VolumeInlineEfficiencyTypeSnapvault string = "snapvault"
)

// prop value enum
func (o *VolumeInlineEfficiency) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiency) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"efficiency"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline efficiency based on the context it is used
func (o *VolumeInlineEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAutoState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHasSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIdcsScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOpBegin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOpEnd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOpErr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOpSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOpState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLoggingEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOpState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpaceSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineEfficiency) contextValidateAutoState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"auto_state", "body", o.AutoState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateHasSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"has_savings", "body", o.HasSavings); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateIdcsScanner(ctx context.Context, formats strfmt.Registry) error {

	if o.IdcsScanner != nil {
		if err := o.IdcsScanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "idcs_scanner")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLastOpBegin(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"last_op_begin", "body", o.LastOpBegin); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLastOpEnd(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"last_op_end", "body", o.LastOpEnd); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLastOpErr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"last_op_err", "body", o.LastOpErr); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLastOpSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"last_op_size", "body", o.LastOpSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLastOpState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"last_op_state", "body", o.LastOpState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateLoggingEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"logging_enabled", "body", o.LoggingEnabled); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateOpState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"op_state", "body", o.OpState); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"progress", "body", o.Progress); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"ratio", "body", o.Ratio); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if o.Scanner != nil {
		if err := o.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"schedule", "body", o.Schedule); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateSpaceSavings(ctx context.Context, formats strfmt.Registry) error {

	if o.SpaceSavings != nil {
		if err := o.SpaceSavings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "efficiency" + "." + "space_savings")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiency) contextValidateVolumePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"volume_path", "body", o.VolumePath); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEfficiency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEfficiency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEfficiencyInlineIdcsScanner Inactive data compression scan looks and picks up blocks that have not been read for a certain amount of time(threshold_inactive_days). These blocks are then compressed in 32K chunks. All attributes are valid for GET only, except for 'operation_state' which is valid for PATCH and GET, and is used to start/stop the scanner.
swagger:model volume_inline_efficiency_inline_idcs_scanner
*/
type VolumeInlineEfficiencyInlineIdcsScanner struct {

	// Specifies the administrative state of the inactive data compression scanner. Disabling inactive data compression is not allowed on Capacity optimized Flash with QAT supported platforms.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Data blocks older than, or equal to, 'inactive_days' are picked up by the inactive data compression scanner. Valid for PATCH only. Only applicable when 'operation_state' set to 'active'.
	InactiveDays *int64 `json:"inactive_days,omitempty"`

	// Specifies the mode of inactive data compression scanner. Valid for PATCH and GET.
	// Enum: ["default","compute_compression_savings"]
	Mode *string `json:"mode,omitempty"`

	// Specifies the operational state of the inactive data compression scanner. VALID for PATCH and GET. Valid options for PATCH are "idle" and "active".
	// Enum: ["idle","active"]
	OperationState *string `json:"operation_state,omitempty"`

	// Status of last inactive data compression scan on the volume.
	// Read Only: true
	// Enum: ["success","failure"]
	Status *string `json:"status,omitempty"`

	// Time interval after which inactive data compression is automatically triggered. The value is in days and is represented in the ISO-8601 format "P<num>D", for example "P3D" represents a duration of 3 days. This field is not supported on QAT supported platforms.
	// Example: P14D
	// Read Only: true
	ThresholdInactiveTime *string `json:"threshold_inactive_time,omitempty"`
}

// Validate validates this volume inline efficiency inline idcs scanner
func (o *VolumeInlineEfficiencyInlineIdcsScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOperationState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","compute_compression_savings"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// mode
	// Mode
	// default
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerModeDefault captures enum value "default"
	VolumeInlineEfficiencyInlineIdcsScannerModeDefault string = "default"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// mode
	// Mode
	// compute_compression_savings
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerModeComputeCompressionSavings captures enum value "compute_compression_savings"
	VolumeInlineEfficiencyInlineIdcsScannerModeComputeCompressionSavings string = "compute_compression_savings"
)

// prop value enum
func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","active"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// operation_state
	// OperationState
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerOperationStateIdle captures enum value "idle"
	VolumeInlineEfficiencyInlineIdcsScannerOperationStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// operation_state
	// OperationState
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerOperationStateActive captures enum value "active"
	VolumeInlineEfficiencyInlineIdcsScannerOperationStateActive string = "active"
)

// prop value enum
func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateOperationStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateOperationState(formats strfmt.Registry) error {
	if swag.IsZero(o.OperationState) { // not required
		return nil
	}

	// value enum
	if err := o.validateOperationStateEnum("info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"operation_state", "body", *o.OperationState); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// status
	// Status
	// success
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerStatusSuccess captures enum value "success"
	VolumeInlineEfficiencyInlineIdcsScannerStatusSuccess string = "success"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// status
	// Status
	// failure
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerStatusFailure captures enum value "failure"
	VolumeInlineEfficiencyInlineIdcsScannerStatusFailure string = "failure"
)

// prop value enum
func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline efficiency inline idcs scanner based on the context it is used
func (o *VolumeInlineEfficiencyInlineIdcsScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThresholdInactiveTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateThresholdInactiveTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"idcs_scanner"+"."+"threshold_inactive_time", "body", o.ThresholdInactiveTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineIdcsScanner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineIdcsScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineIdcsScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEfficiencyInlinePolicy volume inline efficiency inline policy
swagger:model volume_inline_efficiency_inline_policy
*/
type VolumeInlineEfficiencyInlinePolicy struct {

	// Specifies the name of the efficiency policy. The "inline-only" and "none" policies are not supported on Capacity optimized Flash with QAT supported platform.
	Name *string `json:"name,omitempty"`
}

// Validate validates this volume inline efficiency inline policy
func (o *VolumeInlineEfficiencyInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline efficiency inline policy based on context it is used
func (o *VolumeInlineEfficiencyInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlinePolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEfficiencyInlineScanner volume inline efficiency inline scanner
swagger:model volume_inline_efficiency_inline_scanner
*/
type VolumeInlineEfficiencyInlineScanner struct {

	// Start compression if scanning old data. Valid for PATCH and GET. This option is not supported for FSX/CVO platforms.
	Compression *bool `json:"compression,omitempty"`

	// Start deduplication if scanning old data. Valid for PATCH and GET.
	Dedupe *bool `json:"dedupe,omitempty"`

	// Indicates whether or not to scan old data. Valid for PATCH and GET.
	ScanOldData *bool `json:"scan_old_data,omitempty"`

	// State of the volume efficiency scanner. Valid for PATCH and GET. Valid options for PATCH are "idle" and "active".
	// Enum: ["idle","initializing","active","undoing","pending","downgrading","disabled"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline efficiency inline scanner
func (o *VolumeInlineEfficiencyInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyInlineScannerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","initializing","active","undoing","pending","downgrading","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineScannerTypeStatePropEnum = append(volumeInlineEfficiencyInlineScannerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateIdle captures enum value "idle"
	VolumeInlineEfficiencyInlineScannerStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateInitializing captures enum value "initializing"
	VolumeInlineEfficiencyInlineScannerStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateActive captures enum value "active"
	VolumeInlineEfficiencyInlineScannerStateActive string = "active"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// undoing
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateUndoing captures enum value "undoing"
	VolumeInlineEfficiencyInlineScannerStateUndoing string = "undoing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// pending
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStatePending captures enum value "pending"
	VolumeInlineEfficiencyInlineScannerStatePending string = "pending"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// downgrading
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateDowngrading captures enum value "downgrading"
	VolumeInlineEfficiencyInlineScannerStateDowngrading string = "downgrading"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyInlineScannerStateDisabled string = "disabled"
)

// prop value enum
func (o *VolumeInlineEfficiencyInlineScanner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineScannerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineScanner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"efficiency"+"."+"scanner"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline efficiency inline scanner based on context it is used
func (o *VolumeInlineEfficiencyInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineScanner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEfficiencyInlineSpaceSavings volume inline efficiency inline space savings
swagger:model volume_inline_efficiency_inline_space_savings
*/
type VolumeInlineEfficiencyInlineSpaceSavings struct {

	// Total disk space that is saved by compressing blocks on the referenced file system, in bytes.
	// Read Only: true
	Compression *int64 `json:"compression,omitempty"`

	// Percentage of total disk space that is saved by compressing blocks on the referenced file system.
	// Read Only: true
	CompressionPercent *int64 `json:"compression_percent,omitempty"`

	// Total disk space that is saved by deduplication and file cloning, in bytes.
	// Read Only: true
	Dedupe *int64 `json:"dedupe,omitempty"`

	// Percentage of total disk space that is saved by deduplication and file cloning.
	// Read Only: true
	DedupePercent *int64 `json:"dedupe_percent,omitempty"`

	// Total disk space that is shared due to deduplication and file cloning.
	// Read Only: true
	DedupeSharing *int64 `json:"dedupe_sharing,omitempty"`

	// Total disk space saved in the volume due to deduplication, compression and file cloning, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Percentage of total disk space saved in the volume due to deduplication, compression and file cloning.
	// Read Only: true
	TotalPercent *int64 `json:"total_percent,omitempty"`
}

// Validate validates this volume inline efficiency inline space savings
func (o *VolumeInlineEfficiencyInlineSpaceSavings) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline efficiency inline space savings based on the context it is used
func (o *VolumeInlineEfficiencyInlineSpaceSavings) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCompression(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCompressionPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupeSharing(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateCompression(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"compression", "body", o.Compression); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateCompressionPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"compression_percent", "body", o.CompressionPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"dedupe", "body", o.Dedupe); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"dedupe_percent", "body", o.DedupePercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupeSharing(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"dedupe_sharing", "body", o.DedupeSharing); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateTotalPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"efficiency"+"."+"space_savings"+"."+"total_percent", "body", o.TotalPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineSpaceSavings) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEfficiencyInlineSpaceSavings) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineSpaceSavings
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEncryption volume inline encryption
swagger:model volume_inline_encryption
*/
type VolumeInlineEncryption struct {

	// This field can be used to pause an ongoing rekey or conversion operation or resume a paused rekey or conversion operation. Valid in PATCH. The following actions are supported for this field:<br>conversion_pause &dash; Pause an encryption conversion operation currently in progress.<br>conversion_resume &dash; Resume a paused encryption conversion operation.<br>rekey_pause &dash; Pause an encryption rekey operation currently in progress.<br>rekey_resume &dash; Resume a paused encryption rekey operation.
	// Enum: ["conversion_pause","conversion_resume","rekey_pause","rekey_resume"]
	Action *string `json:"action,omitempty"`

	// Creates an encrypted or an unencrypted volume. For POST, when set to 'true', a new key is generated and used to encrypt the given volume. In that case, the underlying SVM must be configured with the key manager. When set to 'false', the volume created will be unencrypted. For PATCH, when set to 'true', it encrypts an unencrypted volume. Specifying the parameter as 'false' in a PATCH operation for an encrypted volume is only supported when moving the volume to another aggregate.
	Enabled *bool `json:"enabled,omitempty"`

	// Encryption key creation time of the volume.
	// Example: 2022-01-01 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	KeyCreateTime *strfmt.DateTime `json:"key_create_time,omitempty"`

	// The key ID used for creating encrypted volume. A new key-id is generated for creating an encrypted volume. This key-id is associated with the generated key.
	// Read Only: true
	KeyID *string `json:"key_id,omitempty"`

	// Specifies an additional key manager attribute that is an identifier-value pair, separated by '='. For example, CRN=unique-value. This parameter is required when using the POST method and an IBM Key Lore key manager is configured on the SVM.
	// Example: CRN=v1:bluemix:public:containers-kubernetes:us-south:a/asdfghjkl1234:asdfghjkl1234:worker:kubernetes-asdfghjkl-worker1
	KeyManagerAttribute *string `json:"key_manager_attribute,omitempty"`

	// If set to 'true', re-encrypts the volume with a new key. Valid in PATCH.
	Rekey *bool `json:"rekey,omitempty"`

	// Volume encryption state.<br>encrypted &dash; The volume is completely encrypted.<br>encrypting &dash; Encryption operation is in progress.<br>partial &dash; Some constituents are encrypted and some are not. Applicable only for FlexGroup volume.<br>rekeying. Encryption of volume with a new key is in progress.<br>unencrypted &dash; The volume is a plain-text one.
	// Read Only: true
	// Enum: ["encrypted","encrypting","partial","rekeying","unencrypted"]
	State *string `json:"state,omitempty"`

	// status
	Status *models.VolumeInlineEncryptionInlineStatus `json:"status,omitempty"`

	// Volume encryption type.<br>none &dash; The volume is a plain-text one.<br>volume &dash; The volume is encrypted with NVE (NetApp Volume Encryption).<br>aggregate &dash; The volume is encrypted with NAE (NetApp Aggregate Encryption).
	// Read Only: true
	// Enum: ["none","volume","aggregate"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this volume inline encryption
func (o *VolumeInlineEncryption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKeyCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEncryptionTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["conversion_pause","conversion_resume","rekey_pause","rekey_resume"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeActionPropEnum = append(volumeInlineEncryptionTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// conversion_pause
	// END DEBUGGING
	// VolumeInlineEncryptionActionConversionPause captures enum value "conversion_pause"
	VolumeInlineEncryptionActionConversionPause string = "conversion_pause"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// conversion_resume
	// END DEBUGGING
	// VolumeInlineEncryptionActionConversionResume captures enum value "conversion_resume"
	VolumeInlineEncryptionActionConversionResume string = "conversion_resume"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// rekey_pause
	// END DEBUGGING
	// VolumeInlineEncryptionActionRekeyPause captures enum value "rekey_pause"
	VolumeInlineEncryptionActionRekeyPause string = "rekey_pause"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// rekey_resume
	// END DEBUGGING
	// VolumeInlineEncryptionActionRekeyResume captures enum value "rekey_resume"
	VolumeInlineEncryptionActionRekeyResume string = "rekey_resume"
)

// prop value enum
func (o *VolumeInlineEncryption) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEncryption) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("info"+"."+"encryption"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryption) validateKeyCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyCreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"encryption"+"."+"key_create_time", "body", "date-time", o.KeyCreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineEncryptionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["encrypted","encrypting","partial","rekeying","unencrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeStatePropEnum = append(volumeInlineEncryptionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// encrypted
	// END DEBUGGING
	// VolumeInlineEncryptionStateEncrypted captures enum value "encrypted"
	VolumeInlineEncryptionStateEncrypted string = "encrypted"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// encrypting
	// END DEBUGGING
	// VolumeInlineEncryptionStateEncrypting captures enum value "encrypting"
	VolumeInlineEncryptionStateEncrypting string = "encrypting"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// partial
	// END DEBUGGING
	// VolumeInlineEncryptionStatePartial captures enum value "partial"
	VolumeInlineEncryptionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// rekeying
	// END DEBUGGING
	// VolumeInlineEncryptionStateRekeying captures enum value "rekeying"
	VolumeInlineEncryptionStateRekeying string = "rekeying"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// unencrypted
	// END DEBUGGING
	// VolumeInlineEncryptionStateUnencrypted captures enum value "unencrypted"
	VolumeInlineEncryptionStateUnencrypted string = "unencrypted"
)

// prop value enum
func (o *VolumeInlineEncryption) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEncryption) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"encryption"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryption) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption" + "." + "status")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEncryptionTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","volume","aggregate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeTypePropEnum = append(volumeInlineEncryptionTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// none
	// END DEBUGGING
	// VolumeInlineEncryptionTypeNone captures enum value "none"
	VolumeInlineEncryptionTypeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// volume
	// END DEBUGGING
	// VolumeInlineEncryptionTypeVolume captures enum value "volume"
	VolumeInlineEncryptionTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// aggregate
	// END DEBUGGING
	// VolumeInlineEncryptionTypeAggregate captures enum value "aggregate"
	VolumeInlineEncryptionTypeAggregate string = "aggregate"
)

// prop value enum
func (o *VolumeInlineEncryption) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineEncryption) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"encryption"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline encryption based on the context it is used
func (o *VolumeInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateKeyCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateKeyID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineEncryption) contextValidateKeyCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"key_create_time", "body", o.KeyCreateTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryption) contextValidateKeyID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"key_id", "body", o.KeyID); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryption) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryption) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineEncryption) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEncryption) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineEncryptionInlineStatus volume inline encryption inline status
swagger:model volume_inline_encryption_inline_status
*/
type VolumeInlineEncryptionInlineStatus struct {

	// Encryption progress message code.
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Encryption progress message.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline encryption inline status
func (o *VolumeInlineEncryptionInlineStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline encryption inline status based on the context it is used
func (o *VolumeInlineEncryptionInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineEncryptionInlineStatus) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"status"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineEncryptionInlineStatus) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"status"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineEncryptionInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineEncryptionInlineStatus) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEncryptionInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineErrorState volume inline error state
swagger:model volume_inline_error_state
*/
type VolumeInlineErrorState struct {

	// Indicates whether the volume has any corrupt data blocks. If the damaged data block is accessed, an IO error, such as EIO for NFS or STATUS_FILE_CORRUPT for CIFS, is returned.
	// Read Only: true
	HasBadBlocks *bool `json:"has_bad_blocks,omitempty"`

	// Indicates whether the file system has any inconsistencies.<br>true &dash; File system is inconsistent.<br>false &dash; File system in not inconsistent.
	// Read Only: true
	IsInconsistent *bool `json:"is_inconsistent,omitempty"`
}

// Validate validates this volume inline error state
func (o *VolumeInlineErrorState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline error state based on the context it is used
func (o *VolumeInlineErrorState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHasBadBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsInconsistent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineErrorState) contextValidateHasBadBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error_state"+"."+"has_bad_blocks", "body", o.HasBadBlocks); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineErrorState) contextValidateIsInconsistent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error_state"+"."+"is_inconsistent", "body", o.IsInconsistent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineErrorState) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineErrorState) UnmarshalBinary(b []byte) error {
	var res VolumeInlineErrorState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineFiles volume inline files
swagger:model volume_inline_files
*/
type VolumeInlineFiles struct {

	// Number of inodes that can currently be stored on the volume for user-visible files.  This number dynamically increases as more user-visible files are created.
	// Read Only: true
	InodefileCapacity *int64 `json:"inodefile_capacity,omitempty"`

	// The maximum number of files (inodes) for user-visible data allowed on the volume. This value can be increased or decreased. Increasing the maximum number of files does not immediately cause additional disk space to be used to track files. Instead, as more files are created on the volume, the system dynamically increases the number of disk blocks that are used to track files. The space assigned to track files is never freed, and this value cannot be decreased below the current number of files that can be tracked within the assigned space for the volume. Valid in PATCH.
	Maximum *int64 `json:"maximum,omitempty"`

	// Number of files (inodes) used for user-visible data permitted on the volume. This field is valid only when the volume is online.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline files
func (o *VolumeInlineFiles) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline files based on the context it is used
func (o *VolumeInlineFiles) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateInodefileCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineFiles) contextValidateInodefileCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"files"+"."+"inodefile_capacity", "body", o.InodefileCapacity); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineFiles) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"files"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineFiles) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineFiles) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFiles
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineFlashPool volume inline flash pool
swagger:model volume_inline_flash_pool
*/
type VolumeInlineFlashPool struct {

	// If this parameter is specified, the command displays information only about the volume or volumes with the specified Flash Pool caching attributes.
	// Read Only: true
	// Enum: ["read","read_write","none"]
	CacheEligibility *string `json:"cache_eligibility,omitempty"`

	// If this parameter is specified, the command displays the volumes that match the specified cache retention priority policy. A cache retention priority defines how long the blocks of a volume will be cached in the Flash Pool once they become cold.
	// Read Only: true
	// Enum: ["normal","low","high"]
	CacheRetentionPriority *string `json:"cache_retention_priority,omitempty"`

	// This optionally specifies the caching policy to apply to the volume. A caching policy defines how the system caches a volume's data in Flash Cache modules. If a caching policy is not assigned to a volume, the system uses the caching policy that is assigned to the containing SVM. If a caching policy is not assigned to the containing SVM, the system uses the default cluster-wide policy.
	// Read Only: true
	// Enum: ["none","auto","meta","random_read","random_read_write","all_read","all_read_random_write","all","noread_random_write","meta_random_write","random_read_write_random_write","all_read_random_write_random_write","all_random_write"]
	CachingPolicy *string `json:"caching_policy,omitempty"`
}

// Validate validates this volume inline flash pool
func (o *VolumeInlineFlashPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCacheEligibility(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCacheRetentionPriority(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCachingPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineFlashPoolTypeCacheEligibilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","read_write","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCacheEligibilityPropEnum = append(volumeInlineFlashPoolTypeCacheEligibilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// read
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityRead captures enum value "read"
	VolumeInlineFlashPoolCacheEligibilityRead string = "read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// read_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityReadWrite captures enum value "read_write"
	VolumeInlineFlashPoolCacheEligibilityReadWrite string = "read_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// none
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityNone captures enum value "none"
	VolumeInlineFlashPoolCacheEligibilityNone string = "none"
)

// prop value enum
func (o *VolumeInlineFlashPool) validateCacheEligibilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCacheEligibilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineFlashPool) validateCacheEligibility(formats strfmt.Registry) error {
	if swag.IsZero(o.CacheEligibility) { // not required
		return nil
	}

	// value enum
	if err := o.validateCacheEligibilityEnum("info"+"."+"flash_pool"+"."+"cache_eligibility", "body", *o.CacheEligibility); err != nil {
		return err
	}

	return nil
}

var volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","low","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum = append(volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// normal
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityNormal captures enum value "normal"
	VolumeInlineFlashPoolCacheRetentionPriorityNormal string = "normal"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// low
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityLow captures enum value "low"
	VolumeInlineFlashPoolCacheRetentionPriorityLow string = "low"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// high
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityHigh captures enum value "high"
	VolumeInlineFlashPoolCacheRetentionPriorityHigh string = "high"
)

// prop value enum
func (o *VolumeInlineFlashPool) validateCacheRetentionPriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineFlashPool) validateCacheRetentionPriority(formats strfmt.Registry) error {
	if swag.IsZero(o.CacheRetentionPriority) { // not required
		return nil
	}

	// value enum
	if err := o.validateCacheRetentionPriorityEnum("info"+"."+"flash_pool"+"."+"cache_retention_priority", "body", *o.CacheRetentionPriority); err != nil {
		return err
	}

	return nil
}

var volumeInlineFlashPoolTypeCachingPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","auto","meta","random_read","random_read_write","all_read","all_read_random_write","all","noread_random_write","meta_random_write","random_read_write_random_write","all_read_random_write_random_write","all_random_write"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCachingPolicyPropEnum = append(volumeInlineFlashPoolTypeCachingPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// none
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyNone captures enum value "none"
	VolumeInlineFlashPoolCachingPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAuto captures enum value "auto"
	VolumeInlineFlashPoolCachingPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// meta
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyMeta captures enum value "meta"
	VolumeInlineFlashPoolCachingPolicyMeta string = "meta"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomRead captures enum value "random_read"
	VolumeInlineFlashPoolCachingPolicyRandomRead string = "random_read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomReadWrite captures enum value "random_read_write"
	VolumeInlineFlashPoolCachingPolicyRandomReadWrite string = "random_read_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllRead captures enum value "all_read"
	VolumeInlineFlashPoolCachingPolicyAllRead string = "all_read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllReadRandomWrite captures enum value "all_read_random_write"
	VolumeInlineFlashPoolCachingPolicyAllReadRandomWrite string = "all_read_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAll captures enum value "all"
	VolumeInlineFlashPoolCachingPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// noread_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyNoreadRandomWrite captures enum value "noread_random_write"
	VolumeInlineFlashPoolCachingPolicyNoreadRandomWrite string = "noread_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// meta_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyMetaRandomWrite captures enum value "meta_random_write"
	VolumeInlineFlashPoolCachingPolicyMetaRandomWrite string = "meta_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read_write_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomReadWriteRandomWrite captures enum value "random_read_write_random_write"
	VolumeInlineFlashPoolCachingPolicyRandomReadWriteRandomWrite string = "random_read_write_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read_random_write_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllReadRandomWriteRandomWrite captures enum value "all_read_random_write_random_write"
	VolumeInlineFlashPoolCachingPolicyAllReadRandomWriteRandomWrite string = "all_read_random_write_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllRandomWrite captures enum value "all_random_write"
	VolumeInlineFlashPoolCachingPolicyAllRandomWrite string = "all_random_write"
)

// prop value enum
func (o *VolumeInlineFlashPool) validateCachingPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCachingPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineFlashPool) validateCachingPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.CachingPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateCachingPolicyEnum("info"+"."+"flash_pool"+"."+"caching_policy", "body", *o.CachingPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline flash pool based on the context it is used
func (o *VolumeInlineFlashPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCacheEligibility(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCacheRetentionPriority(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCachingPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineFlashPool) contextValidateCacheEligibility(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flash_pool"+"."+"cache_eligibility", "body", o.CacheEligibility); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineFlashPool) contextValidateCacheRetentionPriority(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flash_pool"+"."+"cache_retention_priority", "body", o.CacheRetentionPriority); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineFlashPool) contextValidateCachingPolicy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flash_pool"+"."+"caching_policy", "body", o.CachingPolicy); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineFlashPool) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineFlashPool) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFlashPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineFlexgroup volume inline flexgroup
swagger:model volume_inline_flexgroup
*/
type VolumeInlineFlexgroup struct {

	// Name of the FlexGroup volume that the constituent is part of.
	// Example: my_flexgroup
	// Read Only: true
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the FlexGroup volume that the constituent is part of.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline flexgroup
func (o *VolumeInlineFlexgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineFlexgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"flexgroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"flexgroup"+"."+"name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline flexgroup based on the context it is used
func (o *VolumeInlineFlexgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineFlexgroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flexgroup"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineFlexgroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"flexgroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineFlexgroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineFlexgroup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFlexgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineGuarantee volume inline guarantee
swagger:model volume_inline_guarantee
*/
type VolumeInlineGuarantee struct {

	// Is the space guarantee of this volume honored in the aggregate?
	// Read Only: true
	Honored *bool `json:"honored,omitempty"`

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this volume inline guarantee
func (o *VolumeInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineGuaranteeTypeTypePropEnum = append(volumeInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_guarantee
	// VolumeInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// VolumeInlineGuaranteeTypeVolume captures enum value "volume"
	VolumeInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_guarantee
	// VolumeInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// VolumeInlineGuaranteeTypeNone captures enum value "none"
	VolumeInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (o *VolumeInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"guarantee"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline guarantee based on the context it is used
func (o *VolumeInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHonored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineGuarantee) contextValidateHonored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"guarantee"+"."+"honored", "body", o.Honored); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res VolumeInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetric Performance numbers, such as IOPS, latency and throughput.
swagger:model volume_inline_metric
*/
type VolumeInlineMetric struct {

	// links
	Links *models.VolumeInlineMetricInlineLinks `json:"_links,omitempty"`

	// cloud
	Cloud *models.VolumeInlineMetricInlineCloud `json:"cloud,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// flexcache
	Flexcache *models.VolumeInlineMetricInlineFlexcache `json:"flexcache,omitempty"`

	// iops
	Iops *models.VolumeInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.VolumeInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.VolumeInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric
func (o *VolumeInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(o.Cloud) { // not required
		return nil
	}

	if o.Cloud != nil {
		if err := o.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricTypeDurationPropEnum = append(volumeInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT4M captures enum value "PT4M"
	VolumeInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeInlineMetricDurationP1D captures enum value "P1D"
	VolumeInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *VolumeInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetric) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(o.Flexcache) { // not required
		return nil
	}

	if o.Flexcache != nil {
		if err := o.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "flexcache")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricTypeStatusPropEnum = append(volumeInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricStatusOk captures enum value "ok"
	VolumeInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricStatusError captures enum value "error"
	VolumeInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric based on the context it is used
func (o *VolumeInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if o.Cloud != nil {
		if err := o.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if o.Flexcache != nil {
		if err := o.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "flexcache")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetric) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineLinks volume inline metric inline links
swagger:model volume_inline_metric_inline__links
*/
type VolumeInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline metric inline links
func (o *VolumeInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline metric inline links based on the context it is used
func (o *VolumeInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineCloud Performance numbers (IOPS and latency) for cloud store. These numbers are relevant only for volumes hosted on FabricPools.
swagger:model volume_inline_metric_inline_cloud
*/
type VolumeInlineMetricInlineCloud struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.VolumeInlineMetricInlineCloudInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.VolumeInlineMetricInlineCloudInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric inline cloud
func (o *VolumeInlineMetricInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineMetricInlineCloudTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineCloudTypeDurationPropEnum = append(volumeInlineMetricInlineCloudTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricInlineCloudDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT4M captures enum value "PT4M"
	VolumeInlineMetricInlineCloudDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricInlineCloudDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricInlineCloudDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationP1D captures enum value "P1D"
	VolumeInlineMetricInlineCloudDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricInlineCloudDurationPT5M string = "PT5M"
)

// prop value enum
func (o *VolumeInlineMetricInlineCloud) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineCloudTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetricInlineCloud) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"cloud"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineCloudTypeStatusPropEnum = append(volumeInlineMetricInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusOk captures enum value "ok"
	VolumeInlineMetricInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusError captures enum value "error"
	VolumeInlineMetricInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineMetricInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetricInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"cloud"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"cloud"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric inline cloud based on the context it is used
func (o *VolumeInlineMetricInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetricInlineCloud) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"cloud"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"cloud"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"cloud"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloud) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineCloudInlineIops The rate of I/O operations observed at the storage object.
swagger:model volume_inline_metric_inline_cloud_inline_iops
*/
type VolumeInlineMetricInlineCloudInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline cloud inline iops
func (o *VolumeInlineMetricInlineCloudInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline cloud inline iops based on the context it is used
func (o *VolumeInlineMetricInlineCloudInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloudInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloudInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloudInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineCloudInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model volume_inline_metric_inline_cloud_inline_latency
*/
type VolumeInlineMetricInlineCloudInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline cloud inline latency
func (o *VolumeInlineMetricInlineCloudInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline cloud inline latency based on the context it is used
func (o *VolumeInlineMetricInlineCloudInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloudInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineCloudInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloudInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineFlexcache Performance number for FlexCache used to measure cache effectiveness.
swagger:model volume_inline_metric_inline_flexcache
*/
type VolumeInlineMetricInlineFlexcache struct {

	// Bandwidth savings denoting the amount of data served locally by the cache, in bytes.
	// Example: 4096
	BandwidthSavings *int64 `json:"bandwidth_savings,omitempty"`

	// Cache miss percentage.
	// Example: 20
	CacheMissPercent *int64 `json:"cache_miss_percent,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT1D
	// Read Only: true
	// Enum: ["PT15S","PT5M","PT30M","PT2H","PT1D"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric inline flexcache
func (o *VolumeInlineMetricInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineMetricInlineFlexcacheTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","PT1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineFlexcacheTypeDurationPropEnum = append(volumeInlineMetricInlineFlexcacheTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricInlineFlexcacheDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricInlineFlexcacheDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricInlineFlexcacheDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricInlineFlexcacheDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT1D
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT1D captures enum value "PT1D"
	VolumeInlineMetricInlineFlexcacheDurationPT1D string = "PT1D"
)

// prop value enum
func (o *VolumeInlineMetricInlineFlexcache) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineFlexcacheTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"flexcache"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

var volumeInlineMetricInlineFlexcacheTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineFlexcacheTypeStatusPropEnum = append(volumeInlineMetricInlineFlexcacheTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusOk captures enum value "ok"
	VolumeInlineMetricInlineFlexcacheStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusError captures enum value "error"
	VolumeInlineMetricInlineFlexcacheStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricInlineFlexcacheStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricInlineFlexcacheStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricInlineFlexcacheStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricInlineFlexcacheStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricInlineFlexcacheStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineMetricInlineFlexcache) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineFlexcacheTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"flexcache"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"flexcache"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric inline flexcache based on the context it is used
func (o *VolumeInlineMetricInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"flexcache"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"flexcache"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMetricInlineFlexcache) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"flexcache"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineFlexcache) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model volume_inline_metric_inline_iops
*/
type VolumeInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline iops
func (o *VolumeInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline iops based on the context it is used
func (o *VolumeInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model volume_inline_metric_inline_latency
*/
type VolumeInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline latency
func (o *VolumeInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline latency based on the context it is used
func (o *VolumeInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model volume_inline_metric_inline_throughput
*/
type VolumeInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline throughput
func (o *VolumeInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline throughput based on the context it is used
func (o *VolumeInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMovement Volume movement. All attributes are modify, that is, not writable through POST. Set PATCH state to destination_aggregate to initiate a volume move operation.
swagger:model volume_inline_movement
*/
type VolumeInlineMovement struct {

	// Specifies whether this move should perform optimized volume move for the capacity tier, in which data in the capacity tier does not need to be copied over.
	CapacityTierOptimized *bool `json:"capacity_tier_optimized,omitempty"`

	// Time window in seconds for cutover. The allowed range is between 30 to 300 seconds.
	// Example: 30
	CutoverWindow *int64 `json:"cutover_window,omitempty"`

	// destination aggregate
	DestinationAggregate *models.VolumeInlineMovementInlineDestinationAggregate `json:"destination_aggregate,omitempty"`

	// Completion percentage
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// Start time of volume move.
	// Example: 2020-12-07 03:45:12-05:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// State of volume move operation. PATCH the state to "aborted" to abort the move operation. PATCH the state to "cutover" to trigger cutover. PATCH the state to "paused" to pause the volume move operation in progress. PATCH the state to "replicating" to resume the paused volume move operation. PATCH the state to "cutover_wait" to go into cutover manually. When volume move operation is waiting to go into "cutover" state, this is indicated by the "cutover_pending" state. A change of state is only supported if volume movement is in progress.
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`

	// Tiering policy for FabricPool
	// Enum: ["all","auto","backup","none","snapshot_only"]
	TieringPolicy *string `json:"tiering_policy,omitempty"`
}

// Validate validates this volume inline movement
func (o *VolumeInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestinationAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTieringPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovement) validateDestinationAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.DestinationAggregate) { // not required
		return nil
	}

	if o.DestinationAggregate != nil {
		if err := o.DestinationAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMovement) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"movement"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMovementTypeStatePropEnum = append(volumeInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// VolumeInlineMovementStateAborted captures enum value "aborted"
	VolumeInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// VolumeInlineMovementStateCutover captures enum value "cutover"
	VolumeInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// VolumeInlineMovementStateCutoverWait captures enum value "cutover_wait"
	VolumeInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// VolumeInlineMovementStateCutoverPending captures enum value "cutover_pending"
	VolumeInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// VolumeInlineMovementStateFailed captures enum value "failed"
	VolumeInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineMovementStatePaused captures enum value "paused"
	VolumeInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// VolumeInlineMovementStateQueued captures enum value "queued"
	VolumeInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// VolumeInlineMovementStateReplicating captures enum value "replicating"
	VolumeInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// VolumeInlineMovementStateSuccess captures enum value "success"
	VolumeInlineMovementStateSuccess string = "success"
)

// prop value enum
func (o *VolumeInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"movement"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineMovementTypeTieringPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMovementTypeTieringPolicyPropEnum = append(volumeInlineMovementTypeTieringPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// all
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyAll captures enum value "all"
	VolumeInlineMovementTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyAuto captures enum value "auto"
	VolumeInlineMovementTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// backup
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyBackup captures enum value "backup"
	VolumeInlineMovementTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// none
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyNone captures enum value "none"
	VolumeInlineMovementTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineMovementTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *VolumeInlineMovement) validateTieringPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMovementTypeTieringPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineMovement) validateTieringPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.TieringPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateTieringPolicyEnum("info"+"."+"movement"+"."+"tiering_policy", "body", *o.TieringPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline movement based on the context it is used
func (o *VolumeInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestinationAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovement) contextValidateDestinationAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.DestinationAggregate != nil {
		if err := o.DestinationAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"movement"+"."+"percent_complete", "body", o.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineMovement) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"movement"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMovement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMovementInlineDestinationAggregate Aggregate
swagger:model volume_inline_movement_inline_destination_aggregate
*/
type VolumeInlineMovementInlineDestinationAggregate struct {

	// links
	Links *models.VolumeInlineMovementInlineDestinationAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline movement inline destination aggregate
func (o *VolumeInlineMovementInlineDestinationAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovementInlineDestinationAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline movement inline destination aggregate based on the context it is used
func (o *VolumeInlineMovementInlineDestinationAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovementInlineDestinationAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMovementInlineDestinationAggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMovementInlineDestinationAggregate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovementInlineDestinationAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineMovementInlineDestinationAggregateInlineLinks volume inline movement inline destination aggregate inline links
swagger:model volume_inline_movement_inline_destination_aggregate_inline__links
*/
type VolumeInlineMovementInlineDestinationAggregateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline movement inline destination aggregate inline links
func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline movement inline destination aggregate inline links based on the context it is used
func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineMovementInlineDestinationAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovementInlineDestinationAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNas volume inline nas
swagger:model volume_inline_nas
*/
type VolumeInlineNas struct {

	// export policy
	ExportPolicy *models.VolumeInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *models.VolumeInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within a SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; Unix-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number. It consists of 4 digits derived by adding up bits 4 (read), 2 (write) and 1 (execute). First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. The second digit selects permission for the owner of the file; the third selects permissions for other users in the same group; the fourth for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group and other permissions are given (as in 755, representing the second, third and fourth dight), first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this volume inline nas
func (o *VolumeInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var volumeInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineNasTypeSecurityStylePropEnum = append(volumeInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleMixed captures enum value "mixed"
	VolumeInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleNtfs captures enum value "ntfs"
	VolumeInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleUnified captures enum value "unified"
	VolumeInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleUnix captures enum value "unix"
	VolumeInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *VolumeInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("info"+"."+"nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline nas based on the context it is used
func (o *VolumeInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNas) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNasInlineExportPolicy Export Policy
swagger:model volume_inline_nas_inline_export_policy
*/
type VolumeInlineNasInlineExportPolicy struct {

	// links
	Links *models.VolumeInlineNasInlineExportPolicyInlineLinks `json:"_links,omitempty"`

	// id
	// Example: 100
	ID *int64 `json:"id,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`
}

// Validate validates this volume inline nas inline export policy
func (o *VolumeInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline export policy based on the context it is used
func (o *VolumeInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNasInlineExportPolicyInlineLinks volume inline nas inline export policy inline links
swagger:model volume_inline_nas_inline_export_policy_inline__links
*/
type VolumeInlineNasInlineExportPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline nas inline export policy inline links
func (o *VolumeInlineNasInlineExportPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineExportPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline export policy inline links based on the context it is used
func (o *VolumeInlineNasInlineExportPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineExportPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNasInlineExportPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNasInlineExportPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineExportPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNasInlineJunctionParent volume inline nas inline junction parent
swagger:model volume_inline_nas_inline_junction_parent
*/
type VolumeInlineNasInlineJunctionParent struct {

	// links
	Links *models.VolumeInlineNasInlineJunctionParentInlineLinks `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline nas inline junction parent
func (o *VolumeInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline junction parent based on the context it is used
func (o *VolumeInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNasInlineJunctionParentInlineLinks volume inline nas inline junction parent inline links
swagger:model volume_inline_nas_inline_junction_parent_inline__links
*/
type VolumeInlineNasInlineJunctionParentInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline nas inline junction parent inline links
func (o *VolumeInlineNasInlineJunctionParentInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineJunctionParentInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline junction parent inline links based on the context it is used
func (o *VolumeInlineNasInlineJunctionParentInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNasInlineJunctionParentInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas" + "." + "junction_parent" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNasInlineJunctionParentInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNasInlineJunctionParentInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineJunctionParentInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineNodesInlineArrayItem volume inline nodes inline array item
swagger:model volume_inline_nodes_inline_array_item
*/
type VolumeInlineNodesInlineArrayItem struct {

	// List of the node names hosting the volume.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// List of the node UUIDs hosting the volume.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline nodes inline array item
func (o *VolumeInlineNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline nodes inline array item based on the context it is used
func (o *VolumeInlineNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineNodesInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineNodesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineQos QoS information
swagger:model volume_inline_qos
*/
type VolumeInlineQos struct {

	// policy
	Policy *models.VolumeInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this volume inline qos
func (o *VolumeInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline qos based on the context it is used
func (o *VolumeInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineQos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineQos) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineQosInlinePolicy When "min_throughput_iops", "min_throughput_mbps", "min_throughput", "max_throughput_iops", "max_throughput_mbps" or "max_throughput" attributes are specified, the storage object is assigned to an auto-generated QoS policy group. If the attributes are later modified, the auto-generated QoS policy-group attributes are modified. Attributes can be removed by specifying "0" and policy group by specifying "none". Upon deletion of the storage object or if the attributes are removed, then the QoS policy-group is also removed.
swagger:model volume_inline_qos_inline_policy
*/
type VolumeInlineQosInlinePolicy struct {

	// links
	Links *models.VolumeInlineQosInlinePolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline qos inline policy
func (o *VolumeInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineQosInlinePolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineQosInlinePolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineQosInlinePolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineQosInlinePolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline qos inline policy based on the context it is used
func (o *VolumeInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineQosInlinePolicyInlineLinks volume inline qos inline policy inline links
swagger:model volume_inline_qos_inline_policy_inline__links
*/
type VolumeInlineQosInlinePolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline qos inline policy inline links
func (o *VolumeInlineQosInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQosInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline qos inline policy inline links based on the context it is used
func (o *VolumeInlineQosInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQosInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineQosInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineQosInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQosInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineQuota Quotas track the space or file usage of a user, group, or qtree in a FlexVol volume or a FlexGroup volume.
swagger:model volume_inline_quota
*/
type VolumeInlineQuota struct {

	// This option is used to enable or disable the quota for the volume. This option is valid only in PATCH. Quotas are enabled for FlexVol volumes or FlexGroup volumes when the quota state is "on". Quotas are disabled for FlexVol volumes or FlexGroup volumes when the quota state is "off".
	Enabled *bool `json:"enabled,omitempty"`

	// Quota state of the volume
	// Read Only: true
	// Enum: ["corrupt","initializing","mixed","off","on","resizing"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline quota
func (o *VolumeInlineQuota) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineQuotaTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["corrupt","initializing","mixed","off","on","resizing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineQuotaTypeStatePropEnum = append(volumeInlineQuotaTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// corrupt
	// END DEBUGGING
	// VolumeInlineQuotaStateCorrupt captures enum value "corrupt"
	VolumeInlineQuotaStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineQuotaStateInitializing captures enum value "initializing"
	VolumeInlineQuotaStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeInlineQuotaStateMixed captures enum value "mixed"
	VolumeInlineQuotaStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineQuotaStateOff captures enum value "off"
	VolumeInlineQuotaStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineQuotaStateOn captures enum value "on"
	VolumeInlineQuotaStateOn string = "on"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// resizing
	// END DEBUGGING
	// VolumeInlineQuotaStateResizing captures enum value "resizing"
	VolumeInlineQuotaStateResizing string = "resizing"
)

// prop value enum
func (o *VolumeInlineQuota) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineQuotaTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineQuota) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"quota"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline quota based on the context it is used
func (o *VolumeInlineQuota) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineQuota) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"quota"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineQuota) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineQuota) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQuota
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancing Configuration and runtime properties involving non-disruptive volume capacity rebalancing for a FlexGroup volume.
swagger:model volume_inline_rebalancing
*/
type VolumeInlineRebalancing struct {

	// links
	Links *models.VolumeInlineRebalancingInlineLinks `json:"_links,omitempty"`

	// The amount of data that has been moved in or out of a constituent. A positive value represents data moving into the constituent while a negative value is data moving out of the constituent.
	// Read Only: true
	DataMoved *int64 `json:"data_moved,omitempty"`

	// engine
	Engine *models.VolumeInlineRebalancingInlineEngine `json:"engine,omitempty"`

	// Specifies whether or not to exclude files that are stuck in snapshots during rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "exclude_snapshots" value. Once the operation is started, any changes to the "exclude_snapshots" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "exclude_snapshots" value.
	ExcludeSnapshots *bool `json:"exclude_snapshots,omitempty"`

	// Represents the percentage the volume is out of balance.
	// Read Only: true
	ImbalancePercent *int64 `json:"imbalance_percent,omitempty"`

	// Represents how much the volume is out of balance, in bytes.
	// Read Only: true
	ImbalanceSize *int64 `json:"imbalance_size,omitempty"`

	// Absolute percentage of the constituent that is most out of balance. This value will update every 30 seconds when rebalancing is not active and every 10 seconds when rebalancing is active.
	// Read Only: true
	MaxConstituentImbalancePercent *int64 `json:"max_constituent_imbalance_percent,omitempty"`

	// Specifies the maximum number of concurrent file moves in a volume capacity rebalancing operation on a constituent of the FlexGroup volume. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_file_moves" value. Once the operation is started, any changes to the "max_file_moves" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_file_moves" value.
	MaxFileMoves *int64 `json:"max_file_moves,omitempty"`

	// This optional field specifies the maximum time a capacity rebalancing operation runs for. Once the maximum runtime has passed, the capacity rebalancing operation stops. If it is not set, the default value is 6 hours. This value cannot be updated while a capacity rebalancing operation is running.  The maximum runtime can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P3D" represents a duration of 3 days. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively.
	MaxRuntime *string `json:"max_runtime,omitempty"`

	// Specifies the maximum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is larger than this value, files are moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_threshold" value. Once the operation is started, any changes to the "max_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_threshold" value.
	MaxThreshold *int64 `json:"max_threshold,omitempty"`

	// Specifies the minimum file size to consider for a volume capacity rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "min_file_size" value. Once the operation is started, any changes to the "min_file_size" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_file_size" value. The value must be a multiple of 4KB. If it is not set, the default value is 100MB. Setting "min-file-size" to less than the default value leads to more files being moved. Moved files use granular data, which may impact read/write I/O performance.
	MinFileSize *int64 `json:"min_file_size,omitempty"`

	// Specifies the minimum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is smaller than this value, files are not moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it will use the current "min_threshold" value. Once the operation is started, any changes to the "min_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_threshold" value.
	MinThreshold *int64 `json:"min_threshold,omitempty"`

	// Capacity rebalancing notice messages.
	// Read Only: true
	Notices []*models.Error `json:"notices,omitempty"`

	// Duration the capacity rebalancing operation has been running.
	// Read Only: true
	Runtime *string `json:"runtime,omitempty"`

	// Time when the current capacity rebalancing operation started, or when a future scheduled rebalancing operation begins.
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// State of the volume capacity rebalancing operation. PATCH the state to "starting" to trigger the capacity rebalance operation, and include start_time to schedule rebalancing. PATCH the state to "stopping" to stop the capacity rebalance operation, or cancel a scheduled rebalancing operation. PATCH without the state with a valid start_time to modify the start_time of an existing scheduled rebalance operation.<br><br>While a FlexGroup volume is rebalancing, every constituent will have a rebalancing engine that can either be scanning the filesystem for space usage and files to move, actively moving files or temporarily doing neither.<br><br>If one or more constituents has a state of "rebalancing_source" or "rebalancing_dest", then files are being moved to rebalance the FlexGroup volume.<br><br>If no files are being moved, more information about what the rebalancing engine is doing for each constituent is available using the "rebalancing.engine" property.<br><br>The following values apply to FlexGroup volumes.<br>not_running &dash; capacity rebalancing is not running on the volume.<br>starting &dash; used in a PATCH operation to start a capacity rebalancing operation.<br>rebalancing &dash; capacity rebalancing is running on the volume.<br> paused &dash; volume capacity rebalancing is paused on the volume.<br>stopping &dash; used in a PATCH operation to stop a capacity rebalancing operation.<br>unknown &dash; the system was unable to determine the rebalancing state for the volume.<br><br>The following values apply to FlexGroup volume constituents.<br>idle &dash; capacity rebalancing is running on the constituent, however, no active scanning or file movement is currently occurring.<br>scanning &dash; the constituent's file system is being scanned to find files to move and determine free space.<br>rebalancing_source &dash; a file is being moved off of the constituent.<br>rebalancing_dest &dash; a file is being moved to the constituent.<br>not_running &dash; capacity rebalancing is not running on the constituent.<br>unknown &dash; the system was unable to determine the rebalancing state for the constituent.
	// Example: rebalancing
	// Enum: ["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]
	State *string `json:"state,omitempty"`

	// Time when the capacity rebalancing operation stopped.
	// Read Only: true
	// Format: date-time
	StopTime *strfmt.DateTime `json:"stop_time,omitempty"`

	// Represents the ideal used size of each constituent. Calculated by dividing the total FlexGroup volume used size by the number of constituents.
	// Read Only: true
	TargetUsed *int64 `json:"target_used,omitempty"`

	// Represents the used size of each constituent, as determined by the rebalancing engine. Calculated by subtracting the size used by snapshots, the size of files pending deletion and the size of filesystem metadata from the volume used size.
	// Read Only: true
	UsedForImbalance *int64 `json:"used_for_imbalance,omitempty"`
}

// Validate validates this volume inline rebalancing
func (o *VolumeInlineRebalancing) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNotices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStopTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancing) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancing) validateEngine(formats strfmt.Registry) error {
	if swag.IsZero(o.Engine) { // not required
		return nil
	}

	if o.Engine != nil {
		if err := o.Engine.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancing) validateNotices(formats strfmt.Registry) error {
	if swag.IsZero(o.Notices) { // not required
		return nil
	}

	for i := 0; i < len(o.Notices); i++ {
		if swag.IsZero(o.Notices[i]) { // not required
			continue
		}

		if o.Notices[i] != nil {
			if err := o.Notices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rebalancing" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineRebalancing) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"rebalancing"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineRebalancingTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineRebalancingTypeStatePropEnum = append(volumeInlineRebalancingTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// not_running
	// END DEBUGGING
	// VolumeInlineRebalancingStateNotRunning captures enum value "not_running"
	VolumeInlineRebalancingStateNotRunning string = "not_running"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// starting
	// END DEBUGGING
	// VolumeInlineRebalancingStateStarting captures enum value "starting"
	VolumeInlineRebalancingStateStarting string = "starting"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancing captures enum value "rebalancing"
	VolumeInlineRebalancingStateRebalancing string = "rebalancing"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineRebalancingStatePaused captures enum value "paused"
	VolumeInlineRebalancingStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// stopping
	// END DEBUGGING
	// VolumeInlineRebalancingStateStopping captures enum value "stopping"
	VolumeInlineRebalancingStateStopping string = "stopping"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// idle
	// END DEBUGGING
	// VolumeInlineRebalancingStateIdle captures enum value "idle"
	VolumeInlineRebalancingStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// scanning
	// END DEBUGGING
	// VolumeInlineRebalancingStateScanning captures enum value "scanning"
	VolumeInlineRebalancingStateScanning string = "scanning"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing_source
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancingSource captures enum value "rebalancing_source"
	VolumeInlineRebalancingStateRebalancingSource string = "rebalancing_source"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing_dest
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancingDest captures enum value "rebalancing_dest"
	VolumeInlineRebalancingStateRebalancingDest string = "rebalancing_dest"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// unknown
	// END DEBUGGING
	// VolumeInlineRebalancingStateUnknown captures enum value "unknown"
	VolumeInlineRebalancingStateUnknown string = "unknown"
)

// prop value enum
func (o *VolumeInlineRebalancing) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineRebalancingTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineRebalancing) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"rebalancing"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) validateStopTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StopTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"rebalancing"+"."+"stop_time", "body", "date-time", o.StopTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing based on the context it is used
func (o *VolumeInlineRebalancing) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataMoved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEngine(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImbalanceSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxConstituentImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNotices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRuntime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStopTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTargetUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedForImbalance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancing) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateDataMoved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"data_moved", "body", o.DataMoved); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateEngine(ctx context.Context, formats strfmt.Registry) error {

	if o.Engine != nil {
		if err := o.Engine.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"imbalance_percent", "body", o.ImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateImbalanceSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"imbalance_size", "body", o.ImbalanceSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateMaxConstituentImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"max_constituent_imbalance_percent", "body", o.MaxConstituentImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateNotices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"notices", "body", []*models.Error(o.Notices)); err != nil {
		return err
	}

	for i := 0; i < len(o.Notices); i++ {

		if o.Notices[i] != nil {
			if err := o.Notices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rebalancing" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateRuntime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"runtime", "body", o.Runtime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateStopTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"stop_time", "body", o.StopTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateTargetUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"target_used", "body", o.TargetUsed); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancing) contextValidateUsedForImbalance(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"used_for_imbalance", "body", o.UsedForImbalance); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancing) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancing) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancing
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineLinks volume inline rebalancing inline links
swagger:model volume_inline_rebalancing_inline__links
*/
type VolumeInlineRebalancingInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline rebalancing inline links
func (o *VolumeInlineRebalancingInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline links based on the context it is used
func (o *VolumeInlineRebalancingInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngine Each constituent has one rebalancing engine that co-ordinates scanning constituents for free space and files to move, as well as moving files between constituents. The engine properties must be explicitly requested, are meant for helping diagnose why the volume rebalancer is making decisions.
swagger:model volume_inline_rebalancing_inline_engine
*/
type VolumeInlineRebalancingInlineEngine struct {

	// movement
	Movement *models.VolumeInlineRebalancingInlineEngineInlineMovement `json:"movement,omitempty"`

	// scanner
	Scanner *models.VolumeInlineRebalancingInlineEngineInlineScanner `json:"scanner,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine
func (o *VolumeInlineRebalancingInlineEngine) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngine) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(o.Movement) { // not required
		return nil
	}

	if o.Movement != nil {
		if err := o.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngine) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(o.Scanner) { // not required
		return nil
	}

	if o.Scanner != nil {
		if err := o.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine based on the context it is used
func (o *VolumeInlineRebalancingInlineEngine) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngine) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if o.Movement != nil {
		if err := o.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngine) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if o.Scanner != nil {
		if err := o.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngine) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngine) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngine
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngineInlineMovement Properties on this constituent related to file movement.
swagger:model volume_inline_rebalancing_inline_engine_inline_movement
*/
type VolumeInlineRebalancingInlineEngineInlineMovement struct {

	// Number of file moves started on this constituent.
	// Read Only: true
	FileMovesStarted *int64 `json:"file_moves_started,omitempty"`

	// last error
	LastError *models.VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError `json:"last_error,omitempty"`

	// Start time of the most recent file move on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	MostRecentStartTime *strfmt.DateTime `json:"most_recent_start_time,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline movement
func (o *VolumeInlineRebalancingInlineEngineInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLastError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMostRecentStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovement) validateLastError(formats strfmt.Registry) error {
	if swag.IsZero(o.LastError) { // not required
		return nil
	}

	if o.LastError != nil {
		if err := o.LastError.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovement) validateMostRecentStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.MostRecentStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"most_recent_start_time", "body", "date-time", o.MostRecentStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline movement based on the context it is used
func (o *VolumeInlineRebalancingInlineEngineInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFileMovesStarted(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMostRecentStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateFileMovesStarted(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"file_moves_started", "body", o.FileMovesStarted); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateLastError(ctx context.Context, formats strfmt.Registry) error {

	if o.LastError != nil {
		if err := o.LastError.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateMostRecentStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"most_recent_start_time", "body", o.MostRecentStartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineMovement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError Error information for the last failed file move on the constituent.
swagger:model volume_inline_rebalancing_inline_engine_inline_movement_inline_last_error
*/
type VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError struct {

	// Error code of the last file move error on the constituent.
	// Read Only: true
	Code *int64 `json:"code,omitempty"`

	// DSID of the destination constituent of the last file move error on the constituent.
	// Read Only: true
	Destination *int64 `json:"destination,omitempty"`

	// File ID of the last file move error on the constituent.
	// Read Only: true
	FileID *int64 `json:"file_id,omitempty"`

	// Time of the last file move error on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline movement inline last error
func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", "date-time", o.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline movement inline last error based on the context it is used
func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"destination", "body", o.Destination); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateFileID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"file_id", "body", o.FileID); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", o.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngineInlineScanner Properties related to determining which files to move and where to move them to.
swagger:model volume_inline_rebalancing_inline_engine_inline_scanner
*/
type VolumeInlineRebalancingInlineEngineInlineScanner struct {

	// Number of blocks scanned on this constituent.
	// Read Only: true
	BlocksScanned *int64 `json:"blocks_scanned,omitempty"`

	// blocks skipped
	BlocksSkipped *models.VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped `json:"blocks_skipped,omitempty"`

	// Number of files scanned on this constituent.
	// Read Only: true
	FilesScanned *int64 `json:"files_scanned,omitempty"`

	// files skipped
	FilesSkipped *models.VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped `json:"files_skipped,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner
func (o *VolumeInlineRebalancingInlineEngineInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlocksSkipped(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFilesSkipped(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) validateBlocksSkipped(formats strfmt.Registry) error {
	if swag.IsZero(o.BlocksSkipped) { // not required
		return nil
	}

	if o.BlocksSkipped != nil {
		if err := o.BlocksSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) validateFilesSkipped(formats strfmt.Registry) error {
	if swag.IsZero(o.FilesSkipped) { // not required
		return nil
	}

	if o.FilesSkipped != nil {
		if err := o.FilesSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner based on the context it is used
func (o *VolumeInlineRebalancingInlineEngineInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBlocksScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlocksSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilesScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilesSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateBlocksScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_scanned", "body", o.BlocksScanned); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateBlocksSkipped(ctx context.Context, formats strfmt.Registry) error {

	if o.BlocksSkipped != nil {
		if err := o.BlocksSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateFilesScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_scanned", "body", o.FilesScanned); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateFilesSkipped(ctx context.Context, formats strfmt.Registry) error {

	if o.FilesSkipped != nil {
		if err := o.FilesSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rebalancing" + "." + "engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScanner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped Number of blocks skipped by the scanner on this constituent due to various reasons.
swagger:model volume_inline_rebalancing_inline_engine_inline_scanner_inline_blocks_skipped
*/
type VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped struct {

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because fast truncate is currently running on files.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files with invalid space footprints.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of incompatible files.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of on demand destination files.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of blocks skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner inline blocks skipped
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner inline blocks skipped based on the context it is used
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_blocks", "body", o.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_percent", "body", o.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"fast_truncate", "body", o.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"footprint_invalid", "body", o.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"in_snapshot", "body", o.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"incompatible", "body", o.Incompatible); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"metadata", "body", o.Metadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"on_demand_destination", "body", o.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"other", "body", o.Other); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"remote_cache", "body", o.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_large", "body", o.TooLarge); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_small", "body", o.TooSmall); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"write_fenced", "body", o.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped Number of files skipped by the scanner on this constituent due to various reasons.
swagger:model volume_inline_rebalancing_inline_engine_inline_scanner_inline_files_skipped
*/
type VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped struct {

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of files skipped by the scanner on this constituent because fast truncate is currently running on the file.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of files skipped by the scanner on this constituent because their space footprints are invalid.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are trapped in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are incompatible.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of files skipped by the scanner on this constituent because they metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are on demand destinations.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of files skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner inline files skipped
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner inline files skipped based on the context it is used
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_blocks", "body", o.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_percent", "body", o.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"fast_truncate", "body", o.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"footprint_invalid", "body", o.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"in_snapshot", "body", o.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"incompatible", "body", o.Incompatible); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"metadata", "body", o.Metadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"on_demand_destination", "body", o.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"other", "body", o.Other); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"remote_cache", "body", o.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_large", "body", o.TooLarge); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_small", "body", o.TooSmall); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"write_fenced", "body", o.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnaplock volume inline snaplock
swagger:model volume_inline_snaplock
*/
type VolumeInlineSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// This is the volume compliance clock time which is used to manage the SnapLock objects in the volume.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`

	// Expiry time of the volume. For volumes with an infinite, indefinite or unspecified SnapLock expiry time, "9999-12-31T23:59:59" is used to denote the time.
	// Example: Wed Sep  5 11:02:42 GMT 2018
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates if this volume has been configured as SnapLock audit log volume for the SVM .
	// Example: true
	// Read Only: true
	IsAuditLog *bool `json:"is_audit_log,omitempty"`

	// Litigation count indicates the number of active legal-holds on the volume.
	// Example: 10
	// Read Only: true
	LitigationCount *int64 `json:"litigation_count,omitempty"`

	// Specifies the privileged-delete attribute of a SnapLock volume. On a SnapLock Enterprise (SLE) volume, a designated privileged user can selectively delete files irrespective of the retention time of the file. SLE volumes can have privileged delete as disabled, enabled or permanently_disabled and for SnapLock Compliance (SLC) volumes it is always permanently_disabled.
	// Example: enabled
	// Enum: ["disabled","enabled","permanently_disabled"]
	PrivilegedDelete *string `json:"privileged_delete,omitempty"`

	// retention
	Retention *models.VolumeInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`

	// Indicates the number of files with an unspecified retention time in the volume.
	// Example: 10
	// Read Only: true
	UnspecifiedRetentionFileCount *int64 `json:"unspecified_retention_file_count,omitempty"`
}

// Validate validates this volume inline snaplock
func (o *VolumeInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePrivilegedDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snaplock"+"."+"compliance_clock_time", "body", "date-time", o.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snaplock"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineSnaplockTypePrivilegedDeletePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","permanently_disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSnaplockTypePrivilegedDeletePropEnum = append(volumeInlineSnaplockTypePrivilegedDeletePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// disabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeleteDisabled captures enum value "disabled"
	VolumeInlineSnaplockPrivilegedDeleteDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// enabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeleteEnabled captures enum value "enabled"
	VolumeInlineSnaplockPrivilegedDeleteEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// permanently_disabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeletePermanentlyDisabled captures enum value "permanently_disabled"
	VolumeInlineSnaplockPrivilegedDeletePermanentlyDisabled string = "permanently_disabled"
)

// prop value enum
func (o *VolumeInlineSnaplock) validatePrivilegedDeleteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSnaplockTypePrivilegedDeletePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSnaplock) validatePrivilegedDelete(formats strfmt.Registry) error {
	if swag.IsZero(o.PrivilegedDelete) { // not required
		return nil
	}

	// value enum
	if err := o.validatePrivilegedDeleteEnum("info"+"."+"snaplock"+"."+"privileged_delete", "body", *o.PrivilegedDelete); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(o.Retention) { // not required
		return nil
	}

	if o.Retention != nil {
		if err := o.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSnaplockTypeTypePropEnum = append(volumeInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// VolumeInlineSnaplockTypeCompliance captures enum value "compliance"
	VolumeInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// VolumeInlineSnaplockTypeEnterprise captures enum value "enterprise"
	VolumeInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// VolumeInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	VolumeInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (o *VolumeInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"snaplock"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline snaplock based on the context it is used
func (o *VolumeInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComplianceClockTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsAuditLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLitigationCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnspecifiedRetentionFileCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnaplock) contextValidateComplianceClockTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"compliance_clock_time", "body", o.ComplianceClockTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"expiry_time", "body", o.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) contextValidateIsAuditLog(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"is_audit_log", "body", o.IsAuditLog); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) contextValidateLitigationCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"litigation_count", "body", o.LitigationCount); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if o.Retention != nil {
		if err := o.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineSnaplock) contextValidateUnspecifiedRetentionFileCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"unspecified_retention_file_count", "body", o.UnspecifiedRetentionFileCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnaplock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnaplockInlineRetention volume inline snaplock inline retention
swagger:model volume_inline_snaplock_inline_retention
*/
type VolumeInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this volume inline snaplock inline retention
func (o *VolumeInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline snaplock inline retention based on context it is used
func (o *VolumeInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnapmirror Specifies attributes for SnapMirror protection.
swagger:model volume_inline_snapmirror
*/
type VolumeInlineSnapmirror struct {

	// destinations
	Destinations *models.VolumeInlineSnapmirrorInlineDestinations `json:"destinations,omitempty"`

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this volume inline snapmirror
func (o *VolumeInlineSnapmirror) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestinations(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapmirror) validateDestinations(formats strfmt.Registry) error {
	if swag.IsZero(o.Destinations) { // not required
		return nil
	}

	if o.Destinations != nil {
		if err := o.Destinations.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror" + "." + "destinations")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapmirror based on the context it is used
func (o *VolumeInlineSnapmirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestinations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapmirror) contextValidateDestinations(ctx context.Context, formats strfmt.Registry) error {

	if o.Destinations != nil {
		if err := o.Destinations.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror" + "." + "destinations")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineSnapmirror) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"is_protected", "body", o.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnapmirror) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnapmirror) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapmirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnapmirrorInlineDestinations volume inline snapmirror inline destinations
swagger:model volume_inline_snapmirror_inline_destinations
*/
type VolumeInlineSnapmirrorInlineDestinations struct {

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data to a cloud destination.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data to an ONTAP destination.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this volume inline snapmirror inline destinations
func (o *VolumeInlineSnapmirrorInlineDestinations) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline snapmirror inline destinations based on the context it is used
func (o *VolumeInlineSnapmirrorInlineDestinations) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapmirrorInlineDestinations) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"destinations"+"."+"is_cloud", "body", o.IsCloud); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSnapmirrorInlineDestinations) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"destinations"+"."+"is_ontap", "body", o.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnapmirrorInlineDestinations) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnapmirrorInlineDestinations) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapmirrorInlineDestinations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnapshotPolicy This is a reference to the snapshot policy.
swagger:model volume_inline_snapshot_policy
*/
type VolumeInlineSnapshotPolicy struct {

	// links
	Links *models.VolumeInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline snapshot policy
func (o *VolumeInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapshot policy based on the context it is used
func (o *VolumeInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSnapshotPolicyInlineLinks volume inline snapshot policy inline links
swagger:model volume_inline_snapshot_policy_inline__links
*/
type VolumeInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline snapshot policy inline links
func (o *VolumeInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapshot policy inline links based on the context it is used
func (o *VolumeInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSpace volume inline space
swagger:model volume_inline_space
*/
type VolumeInlineSpace struct {

	// Total size of AFS, excluding snap-reserve, in bytes.
	AfsTotal *int64 `json:"afs_total,omitempty"`

	// Savings achieved due to Auto Adaptive Compression, in bytes.
	// Read Only: true
	AutoAdaptiveCompressionFootprintDataReduction *int64 `json:"auto_adaptive_compression_footprint_data_reduction,omitempty"`

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The space available, as a percent.
	AvailablePercent *int64 `json:"available_percent,omitempty"`

	// The size that is physically used in the block storage of the volume and has a cold temperature. In bytes. This parameter is only supported if the volume is in an aggregate that is either attached to a cloud store or could be attached to a cloud store.
	// Read Only: true
	BlockStorageInactiveUserData *int64 `json:"block_storage_inactive_user_data,omitempty"`

	// Percentage of size that is physically used in the performance tier of the volume.
	// Read Only: true
	BlockStorageInactiveUserDataPercent *int64 `json:"block_storage_inactive_user_data_percent,omitempty"`

	// Space used by capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprint *int64 `json:"capacity_tier_footprint,omitempty"`

	// Savings achieved in the space used by the capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprintDataReduction *int64 `json:"capacity_tier_footprint_data_reduction,omitempty"`

	// Savings achieved due to Data Compaction, in bytes.
	// Read Only: true
	CompactionFootprintDataReduction *int64 `json:"compaction_footprint_data_reduction,omitempty"`

	// Cross volume deduplication metadata footprint, in bytes.
	// Read Only: true
	CrossVolumeDedupeMetafilesFootprint *int64 `json:"cross_volume_dedupe_metafiles_footprint,omitempty"`

	// Cross volume temporary deduplication metadata footprint, in bytes.
	// Read Only: true
	CrossVolumeDedupeMetafilesTemporaryFootprint *int64 `json:"cross_volume_dedupe_metafiles_temporary_footprint,omitempty"`

	// Deduplication metadata footprint, in bytes.
	// Read Only: true
	DedupeMetafilesFootprint *int64 `json:"dedupe_metafiles_footprint,omitempty"`

	// Temporary deduplication metadata footprint, in bytes.
	// Read Only: true
	DedupeMetafilesTemporaryFootprint *int64 `json:"dedupe_metafiles_temporary_footprint,omitempty"`

	// Delayed free blocks footprint, in bytes.
	// Read Only: true
	DelayedFreeFootprint *int64 `json:"delayed_free_footprint,omitempty"`

	// Volume footprint after efficiency savings, in bytes. effective total footprint represents total footprint after deducting auto adaptive compression and compaction savings. effective-footprint includes aggregate metadata used by volume.
	// Read Only: true
	EffectiveTotalFootprint *int64 `json:"effective_total_footprint,omitempty"`

	// Size that should be available for the volume, irrespective of available size in the aggregate, in bytes.
	ExpectedAvailable *int64 `json:"expected_available,omitempty"`

	// File operation metadata footprint, in bytes.
	// Read Only: true
	FileOperationMetadata *int64 `json:"file_operation_metadata,omitempty"`

	// Total usable size of the volume, in bytes.
	// Read Only: true
	FilesystemSize *int64 `json:"filesystem_size,omitempty"`

	// Specifies whether the file system is to remain of the same size when set to true or to grow when set to false. This option is automatically set to true when a volume becomes SnapMirrored.
	FilesystemSizeFixed *bool `json:"filesystem_size_fixed,omitempty"`

	// Data used for this volume in the aggregate, in bytes.
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// Used to change the amount of space reserved for overwrites of reserved objects in a volume.
	FractionalReserve *int64 `json:"fractional_reserve,omitempty"`

	// Volume full threshold percentage at which EMS warnings can be sent.
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// Specifies if the virtual space used is stale.
	// Read Only: true
	IsUsedStale *bool `json:"is_used_stale,omitempty"`

	// Indicates if the support for large FlexVol volumes and large files is enabled on this volume. When configured to true, FlexVol volume size can reach up to 300TB and single file size can reach 128TB.
	LargeSizeEnabled *bool `json:"large_size_enabled,omitempty"`

	// Space used by the local tier for this volume in the aggregate, in bytes.
	// Read Only: true
	LocalTierFootprint *int64 `json:"local_tier_footprint,omitempty"`

	// logical space
	LogicalSpace *models.VolumeInlineSpaceInlineLogicalSpace `json:"logical_space,omitempty"`

	// Indicates the maximum size supported for the FlexVol volume or for each constituent of the FlexGroup volume.
	// Enum: ["100T","300T","600T"]
	MaxSize *string `json:"max_size,omitempty"`

	// Space used by the volume metadata in the aggregate, in bytes.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Volume nearly full threshold percentage at which EMS warnings can be sent.
	NearlyFullThresholdPercent *int64 `json:"nearly_full_threshold_percent,omitempty"`

	// The amount of space not available for this volume in the aggregate, in bytes.
	// Read Only: true
	OverProvisioned *int64 `json:"over_provisioned,omitempty"`

	// Reserved space for overwrites, in bytes.
	// Read Only: true
	OverwriteReserve *int64 `json:"overwrite_reserve,omitempty"`

	// Overwrite logical reserve space used, in bytes.
	// Read Only: true
	OverwriteReserveUsed *int64 `json:"overwrite_reserve_used,omitempty"`

	// Percentage of the volume size that is used.
	// Read Only: true
	PercentUsed *int64 `json:"percent_used,omitempty"`

	// Space used by the performance tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	PerformanceTierFootprint *int64 `json:"performance_tier_footprint,omitempty"`

	// Size that is physically used in the volume, in bytes. Physical used is effective total footprint which is equivalent to total footprint after deducting auto adaptive compression and compaction savings. Physical-used also includes aggregate metadata used by volume.
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// Size that is physically used in the volume, as a percentage.
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// Total provisioned size. The default size is equal to the minimum size of 20MB, in bytes.
	Size *int64 `json:"size,omitempty"`

	// Available space for snapshots from snap-reserve, in bytes.
	// Read Only: true
	SizeAvailableForSnapshots *int64 `json:"size_available_for_snapshots,omitempty"`

	// SnapMirror destination footprint, in bytes.
	// Read Only: true
	SnapmirrorDestinationFootprint *int64 `json:"snapmirror_destination_footprint,omitempty"`

	// snapshot
	Snapshot *models.VolumeInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// Snapshot reserve that is not available for snapshot creation, in bytes.
	// Read Only: true
	SnapshotReserveUnusable *int64 `json:"snapshot_reserve_unusable,omitempty"`

	// Space used by the snapshot copies beyond the snap-reserve, in bytes.
	// Read Only: true
	SnapshotSpill *int64 `json:"snapshot_spill,omitempty"`

	// Data and metadata used for this volume in the aggregate, in bytes.
	// Read Only: true
	TotalFootprint *int64 `json:"total_footprint,omitempty"`

	// Space used by the total metadata in the volume, in bytes.
	// Read Only: true
	TotalMetadata *int64 `json:"total_metadata,omitempty"`

	// Space used by the volume metadata footprint in the aggregate, in bytes.
	// Read Only: true
	TotalMetadataFootprint *int64 `json:"total_metadata_footprint,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The space used by Active Filesystem, in bytes.
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// User data, in bytes.
	// Read Only: true
	UserData *int64 `json:"user_data,omitempty"`

	// Space reserved for future writes in the volume, in bytes.
	// Read Only: true
	VolumeGuaranteeFootprint *int64 `json:"volume_guarantee_footprint,omitempty"`
}

// Validate validates this volume inline space
func (o *VolumeInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLogicalSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSpace) validateLogicalSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.LogicalSpace) { // not required
		return nil
	}

	if o.LogicalSpace != nil {
		if err := o.LogicalSpace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSpaceTypeMaxSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["100T","300T","600T"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceTypeMaxSizePropEnum = append(volumeInlineSpaceTypeMaxSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 100T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr100T captures enum value "100T"
	VolumeInlineSpaceMaxSizeNr100T string = "100T"

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 300T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr300T captures enum value "300T"
	VolumeInlineSpaceMaxSizeNr300T string = "300T"

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 600T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr600T captures enum value "600T"
	VolumeInlineSpaceMaxSizeNr600T string = "600T"
)

// prop value enum
func (o *VolumeInlineSpace) validateMaxSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceTypeMaxSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpace) validateMaxSize(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateMaxSizeEnum("info"+"."+"space"+"."+"max_size", "body", *o.MaxSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline space based on the context it is used
func (o *VolumeInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAutoAdaptiveCompressionFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockStorageInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockStorageInactiveUserDataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCapacityTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCapacityTierFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCompactionFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCrossVolumeDedupeMetafilesFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCrossVolumeDedupeMetafilesTemporaryFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupeMetafilesFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupeMetafilesTemporaryFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDelayedFreeFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEffectiveTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFileOperationMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilesystemSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsUsedStale(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOverProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOverwriteReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOverwriteReserveUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePercentUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePerformanceTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSizeAvailableForSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorDestinationFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotReserveUnusable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotSpill(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalMetadataFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeGuaranteeFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSpace) contextValidateAutoAdaptiveCompressionFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"auto_adaptive_compression_footprint_data_reduction", "body", o.AutoAdaptiveCompressionFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateBlockStorageInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage_inactive_user_data", "body", o.BlockStorageInactiveUserData); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateBlockStorageInactiveUserDataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage_inactive_user_data_percent", "body", o.BlockStorageInactiveUserDataPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateCapacityTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"capacity_tier_footprint", "body", o.CapacityTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateCapacityTierFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"capacity_tier_footprint_data_reduction", "body", o.CapacityTierFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateCompactionFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"compaction_footprint_data_reduction", "body", o.CompactionFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateCrossVolumeDedupeMetafilesFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"cross_volume_dedupe_metafiles_footprint", "body", o.CrossVolumeDedupeMetafilesFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateCrossVolumeDedupeMetafilesTemporaryFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"cross_volume_dedupe_metafiles_temporary_footprint", "body", o.CrossVolumeDedupeMetafilesTemporaryFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateDedupeMetafilesFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"dedupe_metafiles_footprint", "body", o.DedupeMetafilesFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateDedupeMetafilesTemporaryFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"dedupe_metafiles_temporary_footprint", "body", o.DedupeMetafilesTemporaryFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateDelayedFreeFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"delayed_free_footprint", "body", o.DelayedFreeFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateEffectiveTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"effective_total_footprint", "body", o.EffectiveTotalFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateFileOperationMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"file_operation_metadata", "body", o.FileOperationMetadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateFilesystemSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"filesystem_size", "body", o.FilesystemSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"footprint", "body", o.Footprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateIsUsedStale(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"is_used_stale", "body", o.IsUsedStale); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateLocalTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"local_tier_footprint", "body", o.LocalTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateLogicalSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.LogicalSpace != nil {
		if err := o.LogicalSpace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"metadata", "body", o.Metadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateOverProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"over_provisioned", "body", o.OverProvisioned); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateOverwriteReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"overwrite_reserve", "body", o.OverwriteReserve); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateOverwriteReserveUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"overwrite_reserve_used", "body", o.OverwriteReserveUsed); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidatePercentUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"percent_used", "body", o.PercentUsed); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidatePerformanceTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"performance_tier_footprint", "body", o.PerformanceTierFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateSizeAvailableForSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"size_available_for_snapshots", "body", o.SizeAvailableForSnapshots); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateSnapmirrorDestinationFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapmirror_destination_footprint", "body", o.SnapmirrorDestinationFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateSnapshotReserveUnusable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot_reserve_unusable", "body", o.SnapshotReserveUnusable); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateSnapshotSpill(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot_spill", "body", o.SnapshotSpill); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total_footprint", "body", o.TotalFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateTotalMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total_metadata", "body", o.TotalMetadata); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateTotalMetadataFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total_metadata_footprint", "body", o.TotalMetadataFootprint); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"user_data", "body", o.UserData); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpace) contextValidateVolumeGuaranteeFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"volume_guarantee_footprint", "body", o.VolumeGuaranteeFootprint); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSpaceInlineLogicalSpace volume inline space inline logical space
swagger:model volume_inline_space_inline_logical_space
*/
type VolumeInlineSpaceInlineLogicalSpace struct {

	// The amount of space available in this volume with storage efficiency space considered used, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Specifies whether space accounting for operations on the volume is done along with storage efficiency.
	Enforcement *bool `json:"enforcement,omitempty"`

	// Specifies whether space reporting on the volume is done along with storage efficiency.
	Reporting *bool `json:"reporting,omitempty"`

	// SUM of (physical-used, shared_refs, compression_saved_in_plane0, vbn_zero, future_blk_cnt), in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The virtual space used by AFS alone (includes volume reserves) and along with storage efficiency, in bytes.
	// Read Only: true
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// Size that is logically used across all snapshots in the volume, in bytes.
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`

	// SUM of (physical-used, shared_refs, compression_saved_in_plane0, vbn_zero, future_blk_cnt), as a percentage.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this volume inline space inline logical space
func (o *VolumeInlineSpaceInlineLogicalSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline space inline logical space based on the context it is used
func (o *VolumeInlineSpaceInlineLogicalSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedByAfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSpaceInlineLogicalSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedByAfs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_space"+"."+"used_by_afs", "body", o.UsedByAfs); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_space"+"."+"used_by_snapshots", "body", o.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_space"+"."+"used_percent", "body", o.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineLogicalSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineLogicalSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineLogicalSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSpaceInlineSnapshot volume inline space inline snapshot
swagger:model volume_inline_space_inline_snapshot
*/
type VolumeInlineSpaceInlineSnapshot struct {

	// autodelete
	Autodelete *models.VolumeInlineSpaceInlineSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Specifies whether snapshot autodelete is currently enabled on this volume. This field will no longer be supported in a future release. Use autodelete.enabled instead.
	AutodeleteEnabled *bool `json:"autodelete_enabled,omitempty"`

	// Specifies when the system should trigger an autodelete of snapshots. When set to _volume_, autodelete is triggered based on volume fullness. When set to _snap_reserve_, autodelete is triggered based on snapshot reserve fullness. The default value is _volume_. This field will no longer be supported in a future release. Use autodelete.trigger instead.
	// Enum: ["volume","snap_reserve"]
	AutodeleteTrigger *string `json:"autodelete_trigger,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been set aside as a reserve for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size in the volume that has been set aside as a reserve for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots in the volume, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline space inline snapshot
func (o *VolumeInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAutodeleteTrigger(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(o.Autodelete) { // not required
		return nil
	}

	if o.Autodelete != nil {
		if err := o.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","snap_reserve"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum = append(volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot
	// VolumeInlineSpaceInlineSnapshot
	// autodelete_trigger
	// AutodeleteTrigger
	// volume
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotAutodeleteTriggerVolume captures enum value "volume"
	VolumeInlineSpaceInlineSnapshotAutodeleteTriggerVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot
	// VolumeInlineSpaceInlineSnapshot
	// autodelete_trigger
	// AutodeleteTrigger
	// snap_reserve
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotAutodeleteTriggerSnapReserve captures enum value "snap_reserve"
	VolumeInlineSpaceInlineSnapshotAutodeleteTriggerSnapReserve string = "snap_reserve"
)

// prop value enum
func (o *VolumeInlineSpaceInlineSnapshot) validateAutodeleteTriggerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) validateAutodeleteTrigger(formats strfmt.Registry) error {
	if swag.IsZero(o.AutodeleteTrigger) { // not required
		return nil
	}

	// value enum
	if err := o.validateAutodeleteTriggerEnum("info"+"."+"space"+"."+"snapshot"+"."+"autodelete_trigger", "body", *o.AutodeleteTrigger); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline space inline snapshot based on the context it is used
func (o *VolumeInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if o.Autodelete != nil {
		if err := o.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"reserve_available", "body", o.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"reserve_size", "body", o.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"space_used_percent", "body", o.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSpaceInlineSnapshotInlineAutodelete volume inline space inline snapshot inline autodelete
swagger:model volume_inline_space_inline_snapshot_inline_autodelete
*/
type VolumeInlineSpaceInlineSnapshotInlineAutodelete struct {

	// By default, snapshot autodelete does not delete snapshots locked by Snapmirror, clones of a volume, a LUN, an NVMe namespace, or a file.  Deletion of snapshots locked by these applications is specified using this option. The default value is try.
	// Enum: ["try","disrupt","destroy"]
	Commitment *string `json:"commitment,omitempty"`

	// Allows the user to inform snapshot autodelete to defer the deletion of a specified snapshot until the end. The default value is user_created.
	// Enum: ["scheduled","user_created","prefix","none"]
	DeferDelete *string `json:"defer_delete,omitempty"`

	// Specifies the order in which snapshot autodelete occurs. Ordering is done using the date and time the snapshot is created. The default value is oldest_first.
	// Enum: ["newest_first","oldest_first"]
	DeleteOrder *string `json:"delete_order,omitempty"`

	// Specifies whether snapshot autodelete is currently enabled on this volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the prefix of the snapshot which if matched, is deleted last. Used with autodelete_defer_delete when used with a prefix value.
	Prefix *string `json:"prefix,omitempty"`

	// Snapshots are deleted, one at a time, until the used volume space reaches the value specified. The default is 20% free space or 80% utilized.
	TargetFreeSpace *int64 `json:"target_free_space,omitempty"`

	// Specifies when the system should trigger an autodelete of snapshots. When set to _volume_, autodelete is triggered based on volume fullness. When set to _snap_reserve_, autodelete is triggered based on snapshot reserve fullness. The default value is _volume_.
	// Enum: ["volume","snap_reserve"]
	Trigger *string `json:"trigger,omitempty"`
}

// Validate validates this volume inline space inline snapshot inline autodelete
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCommitment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDeferDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDeleteOrder(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTrigger(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["try","disrupt","destroy"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// try
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentTry captures enum value "try"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentTry string = "try"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// disrupt
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDisrupt captures enum value "disrupt"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDisrupt string = "disrupt"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// destroy
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDestroy captures enum value "destroy"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDestroy string = "destroy"
)

// prop value enum
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateCommitmentEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateCommitment(formats strfmt.Registry) error {
	if swag.IsZero(o.Commitment) { // not required
		return nil
	}

	// value enum
	if err := o.validateCommitmentEnum("info"+"."+"space"+"."+"snapshot"+"."+"autodelete"+"."+"commitment", "body", *o.Commitment); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["scheduled","user_created","prefix","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// scheduled
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteScheduled captures enum value "scheduled"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteScheduled string = "scheduled"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// user_created
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteUserCreated captures enum value "user_created"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteUserCreated string = "user_created"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// prefix
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeletePrefix captures enum value "prefix"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeletePrefix string = "prefix"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// none
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteNone captures enum value "none"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteNone string = "none"
)

// prop value enum
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeferDeleteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeferDelete(formats strfmt.Registry) error {
	if swag.IsZero(o.DeferDelete) { // not required
		return nil
	}

	// value enum
	if err := o.validateDeferDeleteEnum("info"+"."+"space"+"."+"snapshot"+"."+"autodelete"+"."+"defer_delete", "body", *o.DeferDelete); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["newest_first","oldest_first"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// delete_order
	// DeleteOrder
	// newest_first
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderNewestFirst captures enum value "newest_first"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderNewestFirst string = "newest_first"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// delete_order
	// DeleteOrder
	// oldest_first
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderOldestFirst captures enum value "oldest_first"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderOldestFirst string = "oldest_first"
)

// prop value enum
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeleteOrderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeleteOrder(formats strfmt.Registry) error {
	if swag.IsZero(o.DeleteOrder) { // not required
		return nil
	}

	// value enum
	if err := o.validateDeleteOrderEnum("info"+"."+"space"+"."+"snapshot"+"."+"autodelete"+"."+"delete_order", "body", *o.DeleteOrder); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","snap_reserve"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// trigger
	// Trigger
	// volume
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerVolume captures enum value "volume"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// trigger
	// Trigger
	// snap_reserve
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerSnapReserve captures enum value "snap_reserve"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerSnapReserve string = "snap_reserve"
)

// prop value enum
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateTriggerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateTrigger(formats strfmt.Registry) error {
	if swag.IsZero(o.Trigger) { // not required
		return nil
	}

	// value enum
	if err := o.validateTriggerEnum("info"+"."+"space"+"."+"snapshot"+"."+"autodelete"+"."+"trigger", "body", *o.Trigger); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline space inline snapshot inline autodelete based on context it is used
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSpaceInlineSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model volume_inline_statistics
*/
type VolumeInlineStatistics struct {

	// cifs ops raw
	CifsOpsRaw *models.VolumeInlineStatisticsInlineCifsOpsRaw `json:"cifs_ops_raw,omitempty"`

	// cloud
	Cloud *models.VolumeInlineStatisticsInlineCloud `json:"cloud,omitempty"`

	// flexcache raw
	FlexcacheRaw *models.VolumeInlineStatisticsInlineFlexcacheRaw `json:"flexcache_raw,omitempty"`

	// iops raw
	IopsRaw *models.VolumeInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.VolumeInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// nfs ops raw
	NfsOpsRaw *models.VolumeInlineStatisticsInlineNfsOpsRaw `json:"nfs_ops_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.VolumeInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics
func (o *VolumeInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNfsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatistics) validateCifsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsOpsRaw) { // not required
		return nil
	}

	if o.CifsOpsRaw != nil {
		if err := o.CifsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(o.Cloud) { // not required
		return nil
	}

	if o.Cloud != nil {
		if err := o.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateFlexcacheRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheRaw) { // not required
		return nil
	}

	if o.FlexcacheRaw != nil {
		if err := o.FlexcacheRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateNfsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.NfsOpsRaw) { // not required
		return nil
	}

	if o.NfsOpsRaw != nil {
		if err := o.NfsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

var volumeInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsTypeStatusPropEnum = append(volumeInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsStatusOk captures enum value "ok"
	VolumeInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsStatusError captures enum value "error"
	VolumeInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics based on the context it is used
func (o *VolumeInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNfsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatistics) contextValidateCifsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.CifsOpsRaw != nil {
		if err := o.CifsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if o.Cloud != nil {
		if err := o.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateFlexcacheRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.FlexcacheRaw != nil {
		if err := o.FlexcacheRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateNfsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.NfsOpsRaw != nil {
		if err := o.NfsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatistics) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRaw Raw data component performance values for CIFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
swagger:model volume_inline_statistics_inline_cifs_ops_raw
*/
type VolumeInlineStatisticsInlineCifsOpsRaw struct {

	// access
	Access *models.VolumeInlineStatisticsInlineCifsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *models.VolumeInlineStatisticsInlineCifsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *models.VolumeInlineStatisticsInlineCifsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *models.VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *models.VolumeInlineStatisticsInlineCifsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *models.VolumeInlineStatisticsInlineCifsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *models.VolumeInlineStatisticsInlineCifsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *models.VolumeInlineStatisticsInlineCifsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *models.VolumeInlineStatisticsInlineCifsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *models.VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *models.VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *models.VolumeInlineStatisticsInlineCifsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *models.VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *models.VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *models.VolumeInlineStatisticsInlineCifsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *models.VolumeInlineStatisticsInlineCifsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw
func (o *VolumeInlineStatisticsInlineCifsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(o.Access) { // not required
		return nil
	}

	if o.Access != nil {
		if err := o.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(o.Audit) { // not required
		return nil
	}

	if o.Audit != nil {
		if err := o.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(o.Create) { // not required
		return nil
	}

	if o.Create != nil {
		if err := o.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(o.Getattr) { // not required
		return nil
	}

	if o.Getattr != nil {
		if err := o.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(o.Link) { // not required
		return nil
	}

	if o.Link != nil {
		if err := o.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(o.Lock) { // not required
		return nil
	}

	if o.Lock != nil {
		if err := o.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(o.Lookup) { // not required
		return nil
	}

	if o.Lookup != nil {
		if err := o.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(o.Open) { // not required
		return nil
	}

	if o.Open != nil {
		if err := o.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(o.Read) { // not required
		return nil
	}

	if o.Read != nil {
		if err := o.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(o.Readdir) { // not required
		return nil
	}

	if o.Readdir != nil {
		if err := o.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Readlink) { // not required
		return nil
	}

	if o.Readlink != nil {
		if err := o.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(o.Rename) { // not required
		return nil
	}

	if o.Rename != nil {
		if err := o.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(o.Setattr) { // not required
		return nil
	}

	if o.Setattr != nil {
		if err := o.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Unlink) { // not required
		return nil
	}

	if o.Unlink != nil {
		if err := o.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(o.Watch) { // not required
		return nil
	}

	if o.Watch != nil {
		if err := o.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(o.Write) { // not required
		return nil
	}

	if o.Write != nil {
		if err := o.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw based on the context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if o.Access != nil {
		if err := o.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if o.Audit != nil {
		if err := o.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if o.Create != nil {
		if err := o.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if o.Getattr != nil {
		if err := o.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if o.Link != nil {
		if err := o.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if o.Lock != nil {
		if err := o.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if o.Lookup != nil {
		if err := o.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if o.Open != nil {
		if err := o.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if o.Read != nil {
		if err := o.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if o.Readdir != nil {
		if err := o.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Readlink != nil {
		if err := o.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if o.Rename != nil {
		if err := o.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if o.Setattr != nil {
		if err := o.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Unlink != nil {
		if err := o.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if o.Watch != nil {
		if err := o.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if o.Write != nil {
		if err := o.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineAccess Raw count and latency data for access operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_access
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline access
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline access based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_audit
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline audit
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline audit based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineCreate Raw count and latency data for create operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreate struct {

	// dir
	Dir *models.VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *models.VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *models.VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *models.VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(o.Dir) { // not required
		return nil
	}

	if o.Dir != nil {
		if err := o.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(o.File) { // not required
		return nil
	}

	if o.File != nil {
		if err := o.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(o.Other) { // not required
		return nil
	}

	if o.Other != nil {
		if err := o.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Symlink) { // not required
		return nil
	}

	if o.Symlink != nil {
		if err := o.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline create based on the context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if o.Dir != nil {
		if err := o.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if o.File != nil {
		if err := o.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if o.Other != nil {
		if err := o.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Symlink != nil {
		if err := o.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_dir
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline dir
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline dir based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_file
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline file
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline file based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_other
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline other
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline other based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_symlink
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline symlink
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline symlink based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr Raw count and latency data for getattr operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_getattr
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline getattr
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline getattr based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineLink Raw count and latency data for link operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_link
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline link
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline link based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineLock Raw count and latency data for lock operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_lock
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline lock
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline lock based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineLookup Raw count and latency data for lookup operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_lookup
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline lookup
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline lookup based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineOpen Raw count and latency data for open operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_open
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline open
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline open based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_read
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline read
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline read based on the context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"total_time", "body", o.TotalTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir Raw count and latency data for readdir operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_readdir
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline readdir
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline readdir based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink Raw count and latency data for readlink operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_readlink
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline readlink
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline readlink based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineRename Raw count and latency data for rename operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_rename
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline rename
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline rename based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr Raw count and latency data for setattr operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_setattr
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline setattr
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline setattr based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink Raw count and latency data for unlink operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_unlink
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline unlink
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline unlink based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_watch
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline watch
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline watch based on context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCifsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_write
*/
type VolumeInlineStatisticsInlineCifsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline write
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline write based on the context it is used
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"total_time", "body", o.TotalTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCloud These are raw performance numbers (IOPS and latency) for the cloud store. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster. These numbers are relevant only for volumes hosted on FabricPools.
swagger:model volume_inline_statistics_inline_cloud
*/
type VolumeInlineStatisticsInlineCloud struct {

	// iops raw
	IopsRaw *models.VolumeInlineStatisticsInlineCloudInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.VolumeInlineStatisticsInlineCloudInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics inline cloud
func (o *VolumeInlineStatisticsInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var volumeInlineStatisticsInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsInlineCloudTypeStatusPropEnum = append(volumeInlineStatisticsInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusOk captures enum value "ok"
	VolumeInlineStatisticsInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusError captures enum value "error"
	VolumeInlineStatisticsInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineStatisticsInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"cloud"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"cloud"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cloud based on the context it is used
func (o *VolumeInlineStatisticsInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cloud"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"cloud"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloud) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCloudInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model volume_inline_statistics_inline_cloud_inline_iops_raw
*/
type VolumeInlineStatisticsInlineCloudInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cloud inline iops raw
func (o *VolumeInlineStatisticsInlineCloudInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cloud inline iops raw based on the context it is used
func (o *VolumeInlineStatisticsInlineCloudInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloudInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloudInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloudInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineCloudInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model volume_inline_statistics_inline_cloud_inline_latency_raw
*/
type VolumeInlineStatisticsInlineCloudInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cloud inline latency raw
func (o *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cloud inline latency raw based on the context it is used
func (o *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloudInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineFlexcacheRaw Performance numbers for FlexCache used to measure cache effectiveness.
swagger:model volume_inline_statistics_inline_flexcache_raw
*/
type VolumeInlineStatisticsInlineFlexcacheRaw struct {

	// Blocks retrieved from origin in case of a cache miss. This can be divided by the raw client_requested_blocks and multiplied by 100 to calculate the cache miss percentage.
	// Example: 10
	CacheMissBlocks *int64 `json:"cache_miss_blocks,omitempty"`

	// Total blocks requested by the client.
	// Example: 500
	ClientRequestedBlocks *int64 `json:"client_requested_blocks,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics inline flexcache raw
func (o *VolumeInlineStatisticsInlineFlexcacheRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum = append(volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusOk captures enum value "ok"
	VolumeInlineStatisticsInlineFlexcacheRawStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusError captures enum value "error"
	VolumeInlineStatisticsInlineFlexcacheRawStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsInlineFlexcacheRawStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *VolumeInlineStatisticsInlineFlexcacheRaw) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineFlexcacheRaw) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"flexcache_raw"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineFlexcacheRaw) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"flexcache_raw"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline flexcache raw based on the context it is used
func (o *VolumeInlineStatisticsInlineFlexcacheRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineFlexcacheRaw) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"flexcache_raw"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineFlexcacheRaw) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"flexcache_raw"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineFlexcacheRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineFlexcacheRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineFlexcacheRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model volume_inline_statistics_inline_iops_raw
*/
type VolumeInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline iops raw
func (o *VolumeInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline iops raw based on the context it is used
func (o *VolumeInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model volume_inline_statistics_inline_latency_raw
*/
type VolumeInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline latency raw
func (o *VolumeInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline latency raw based on the context it is used
func (o *VolumeInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRaw Raw data component performance values for NFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
swagger:model volume_inline_statistics_inline_nfs_ops_raw
*/
type VolumeInlineStatisticsInlineNfsOpsRaw struct {

	// access
	Access *models.VolumeInlineStatisticsInlineNfsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *models.VolumeInlineStatisticsInlineNfsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *models.VolumeInlineStatisticsInlineNfsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *models.VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *models.VolumeInlineStatisticsInlineNfsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *models.VolumeInlineStatisticsInlineNfsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *models.VolumeInlineStatisticsInlineNfsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *models.VolumeInlineStatisticsInlineNfsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *models.VolumeInlineStatisticsInlineNfsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *models.VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *models.VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *models.VolumeInlineStatisticsInlineNfsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *models.VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *models.VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *models.VolumeInlineStatisticsInlineNfsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *models.VolumeInlineStatisticsInlineNfsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw
func (o *VolumeInlineStatisticsInlineNfsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(o.Access) { // not required
		return nil
	}

	if o.Access != nil {
		if err := o.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(o.Audit) { // not required
		return nil
	}

	if o.Audit != nil {
		if err := o.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(o.Create) { // not required
		return nil
	}

	if o.Create != nil {
		if err := o.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(o.Getattr) { // not required
		return nil
	}

	if o.Getattr != nil {
		if err := o.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(o.Link) { // not required
		return nil
	}

	if o.Link != nil {
		if err := o.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(o.Lock) { // not required
		return nil
	}

	if o.Lock != nil {
		if err := o.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(o.Lookup) { // not required
		return nil
	}

	if o.Lookup != nil {
		if err := o.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(o.Open) { // not required
		return nil
	}

	if o.Open != nil {
		if err := o.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(o.Read) { // not required
		return nil
	}

	if o.Read != nil {
		if err := o.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(o.Readdir) { // not required
		return nil
	}

	if o.Readdir != nil {
		if err := o.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Readlink) { // not required
		return nil
	}

	if o.Readlink != nil {
		if err := o.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(o.Rename) { // not required
		return nil
	}

	if o.Rename != nil {
		if err := o.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(o.Setattr) { // not required
		return nil
	}

	if o.Setattr != nil {
		if err := o.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Unlink) { // not required
		return nil
	}

	if o.Unlink != nil {
		if err := o.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(o.Watch) { // not required
		return nil
	}

	if o.Watch != nil {
		if err := o.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(o.Write) { // not required
		return nil
	}

	if o.Write != nil {
		if err := o.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw based on the context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if o.Access != nil {
		if err := o.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if o.Audit != nil {
		if err := o.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if o.Create != nil {
		if err := o.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if o.Getattr != nil {
		if err := o.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if o.Link != nil {
		if err := o.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if o.Lock != nil {
		if err := o.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if o.Lookup != nil {
		if err := o.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if o.Open != nil {
		if err := o.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if o.Read != nil {
		if err := o.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if o.Readdir != nil {
		if err := o.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Readlink != nil {
		if err := o.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if o.Rename != nil {
		if err := o.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if o.Setattr != nil {
		if err := o.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Unlink != nil {
		if err := o.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if o.Watch != nil {
		if err := o.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if o.Write != nil {
		if err := o.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineAccess Raw count and latency data for access operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_access
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline access
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline access based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_audit
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline audit
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline audit based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineCreate Raw count and latency data for create operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreate struct {

	// dir
	Dir *models.VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *models.VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *models.VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *models.VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(o.Dir) { // not required
		return nil
	}

	if o.Dir != nil {
		if err := o.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(o.File) { // not required
		return nil
	}

	if o.File != nil {
		if err := o.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(o.Other) { // not required
		return nil
	}

	if o.Other != nil {
		if err := o.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(o.Symlink) { // not required
		return nil
	}

	if o.Symlink != nil {
		if err := o.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline create based on the context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if o.Dir != nil {
		if err := o.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if o.File != nil {
		if err := o.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if o.Other != nil {
		if err := o.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if o.Symlink != nil {
		if err := o.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_dir
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline dir
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline dir based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_file
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline file
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline file based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_other
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline other
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline other based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_symlink
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline symlink
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline symlink based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr Raw count and latency data for getattr operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_getattr
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline getattr
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline getattr based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineLink Raw count and latency data for link operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_link
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline link
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline link based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineLock Raw count and latency data for lock operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_lock
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline lock
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline lock based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineLookup Raw count and latency data for lookup operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_lookup
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline lookup
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline lookup based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineOpen Raw count and latency data for open operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_open
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline open
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline open based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_read
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline read
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline read based on the context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"total_time", "body", o.TotalTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir Raw count and latency data for readdir operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_readdir
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline readdir
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline readdir based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink Raw count and latency data for readlink operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_readlink
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline readlink
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline readlink based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineRename Raw count and latency data for rename operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_rename
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline rename
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline rename based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr Raw count and latency data for setattr operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_setattr
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline setattr
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline setattr based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink Raw count and latency data for unlink operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_unlink
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline unlink
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline unlink based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_watch
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline watch
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline watch based on context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineNfsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_write
*/
type VolumeInlineStatisticsInlineNfsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline write
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline write based on the context it is used
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"total_time", "body", o.TotalTime); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", o.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model volume_inline_statistics_inline_throughput_raw
*/
type VolumeInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline throughput raw
func (o *VolumeInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline throughput raw based on the context it is used
func (o *VolumeInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSvm SVM containing the volume. Required on POST.
swagger:model volume_inline_svm
*/
type VolumeInlineSvm struct {

	// links
	Links *models.VolumeInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline svm
func (o *VolumeInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline svm based on the context it is used
func (o *VolumeInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSvm) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineSvmInlineLinks volume inline svm inline links
swagger:model volume_inline_svm_inline__links
*/
type VolumeInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this volume inline svm inline links
func (o *VolumeInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline svm inline links based on the context it is used
func (o *VolumeInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeInlineTiering volume inline tiering
swagger:model volume_inline_tiering
*/
type VolumeInlineTiering struct {

	// This parameter specifies the minimum number of days that user data blocks of the volume must be cooled before they can be considered cold and tiered out to the cloud tier. Note that this parameter is only used for tiering purposes and does not affect the reporting of inactive data. The value specified should be greater than the frequency with which applications in the volume shift between different sets of data. This parameter cannot be set when volume tiering policy is either "none" or "all". The default value of this parameter depends on the volume's tiering policy. See the tiering policy section of this documentation for corresponding default values. If the tiering policy on the volume gets changed, then this parameter will be reset to the default value corresponding to the new tiering policy.
	// Maximum: 183
	// Minimum: 2
	MinCoolingDays *int64 `json:"min_cooling_days,omitempty"`

	// This parameter specifies tags of a volume for objects stored on a FabricPool-enabled aggregate. Each tag is a key,value pair and should be in the format "key=value".
	// Max Items: 4
	// Min Items: 0
	// Unique: true
	ObjectTags []*string `json:"object_tags,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold. FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br>all &dash; This policy allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br>auto &dash; This policy allows tiering of both snapshot and active file system user data to the cloud store<br>none &dash; Volume blocks will not be tiered to the cloud store.<br>snapshot_only &dash; This policy allows tiering of only the volume snapshots not associated with the active file system. The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy is 31 days.
	// Enum: ["all","auto","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`

	// This parameter specifies whether or not FabricPools are selected when provisioning a FlexGroup volume without specifying "aggregates.name" or "aggregates.uuid". Only FabricPool aggregates are used if this parameter is set to true and only non FabricPool aggregates are used if this parameter is set to false. Tiering support for a FlexGroup volume can be changed by moving all of the constituents to the required aggregates. Note that in order to tier data, not only does the volume need to support tiering by using FabricPools, the tiering "policy" must not be 'none'. A volume that uses FabricPools but has a tiering "policy" of 'none' supports tiering, but will not tier any data.
	Supported *bool `json:"supported,omitempty"`
}

// Validate validates this volume inline tiering
func (o *VolumeInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMinCoolingDays(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VolumeInlineTiering) validateMinCoolingDays(formats strfmt.Registry) error {
	if swag.IsZero(o.MinCoolingDays) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"tiering"+"."+"min_cooling_days", "body", *o.MinCoolingDays, 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"tiering"+"."+"min_cooling_days", "body", *o.MinCoolingDays, 183, false); err != nil {
		return err
	}

	return nil
}

func (o *VolumeInlineTiering) validateObjectTags(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectTags) { // not required
		return nil
	}

	iObjectTagsSize := int64(len(o.ObjectTags))

	if err := validate.MinItems("info"+"."+"tiering"+"."+"object_tags", "body", iObjectTagsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"tiering"+"."+"object_tags", "body", iObjectTagsSize, 4); err != nil {
		return err
	}

	if err := validate.UniqueItems("info"+"."+"tiering"+"."+"object_tags", "body", o.ObjectTags); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectTags); i++ {
		if swag.IsZero(o.ObjectTags[i]) { // not required
			continue
		}

		if err := validate.MaxLength("info"+"."+"tiering"+"."+"object_tags"+"."+strconv.Itoa(i), "body", *o.ObjectTags[i], 257); err != nil {
			return err
		}

		if err := validate.Pattern("info"+"."+"tiering"+"."+"object_tags"+"."+strconv.Itoa(i), "body", *o.ObjectTags[i], `[_a-zA-Z][_a-zA-Z0-9]{0,126}=[_a-zA-Z0-9]{1,127}`); err != nil {
			return err
		}

	}

	return nil
}

var volumeInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineTieringTypePolicyPropEnum = append(volumeInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// VolumeInlineTieringPolicyAll captures enum value "all"
	VolumeInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// VolumeInlineTieringPolicyAuto captures enum value "auto"
	VolumeInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// VolumeInlineTieringPolicyNone captures enum value "none"
	VolumeInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *VolumeInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VolumeInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("info"+"."+"tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline tiering based on context it is used
func (o *VolumeInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeInlineTiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeInlineTiering) UnmarshalBinary(b []byte) error {
	var res VolumeInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
