// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewVolumeModifyParams creates a new VolumeModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeModifyParams() *VolumeModifyParams {
	return &VolumeModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeModifyParamsWithTimeout creates a new VolumeModifyParams object
// with the ability to set a timeout on a request.
func NewVolumeModifyParamsWithTimeout(timeout time.Duration) *VolumeModifyParams {
	return &VolumeModifyParams{
		timeout: timeout,
	}
}

// NewVolumeModifyParamsWithContext creates a new VolumeModifyParams object
// with the ability to set a context for a request.
func NewVolumeModifyParamsWithContext(ctx context.Context) *VolumeModifyParams {
	return &VolumeModifyParams{
		Context: ctx,
	}
}

// NewVolumeModifyParamsWithHTTPClient creates a new VolumeModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeModifyParamsWithHTTPClient(client *http.Client) *VolumeModifyParams {
	return &VolumeModifyParams{
		HTTPClient: client,
	}
}

/*
VolumeModifyParams contains all the parameters to send to the API endpoint

	for the volume modify operation.

	Typically these are written to a http.Request.
*/
type VolumeModifyParams struct {

	/* AggressiveReadaheadMode.

	   Specifies the `aggressive_readahead_mode` enabled on the volume. When set to _file_prefetch_, on a file read, the system aggressively issues readaheads for all of the blocks in the file and retains those blocks in a cache for a finite period of time. This feature is only available on FabricPool volumes on FSx for ONTAP and Cloud Volumes ONTAP. When the option is set to _sequential_read_, the system aggressively prefetches the file completely, or to a certain length based on the file size limit, and continues as the read makes progress. If the option is set to _cross_file_sequential_read_, then the system aggressively prefetches multiple files completely, or to a certain length, and continues as the read makes progress.

	   Default: "none"
	*/
	AggressiveReadaheadMode *string

	/* CloneMatchParentStorageTier.

	   Specifies whether the FlexClone volume splits the data blocks by matching its parent storage tier. This option is applicable only if the tiering policy and the tiering minimum cooling days of the parent volume and the FlexClone volume are the same.
	*/
	CloneMatchParentStorageTier *bool

	/* Info.

	   Info specification
	*/
	Info *models.Volume

	/* Nvfail.

	   When this option is "on", the filer performs additional work at boot time if it finds that there has been any potential data loss due to an NVRAM failure. In such situations, it causes the invalidation of all NFS file handles on all volumes affected by the problem so that client-side users are forced to remount the affected file system (and thus not continue to use potentially incorrect data). It is also possible to specify a set of files per volume that are renamed in such cases. The filer sends error messages to the console whenever such problems are found.
	*/
	Nvfail *string

	/* PreserveLunIds.

	   Specifies whether LUN IDs need to be preserved during a snapshot restore operation.
	*/
	PreserveLunIds *bool

	/* RestoreToByteCount.

	   Number of bytes to restore from the source file, in multiples of 4096.
	*/
	RestoreToByteCount *float64

	/* RestoreToPath.

	   Path to the file which is restored from the snapshot.
	*/
	RestoreToPath *string

	/* RestoreToRestorePath.

	   Specifies the destination location inside the volume where the file is restored.
	*/
	RestoreToRestorePath *string

	/* RestoreToSnapshotName.

	   Name of the snapshot to restore volume to the point in time the snapshot was taken.
	*/
	RestoreToSnapshotName *string

	/* RestoreToSnapshotUUID.

	   UUID of the snapshot to restore volume to the point in time the snapshot was taken.
	*/
	RestoreToSnapshotUUID *string

	/* RestoreToStartByte.

	   Starting byte offset of the source file, in multiples of 4096.
	*/
	RestoreToStartByte *float64

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* ScheduledSnapshotNamingScheme.

	     Naming Scheme for automatic snapshots:
	* create_time - Automatic snapshots are saved as per the start of their current date and time.
	* ordinal - Latest automatic snapshot copy is saved as <scheduled_frequency>.0 and subsequent copies will follow the create_time naming convention.


	     Default: "create_time"
	*/
	ScheduledSnapshotNamingScheme *string

	/* SizingMethod.

	     Represents the method to modify the size of a Flexgroup. The following methods are supported:
	* use_existing_resources - Increases or decreases the size of the FlexGroup by increasing or decreasing the size of the current FlexGroup resources
	* add_new_resources - Increases the size of the FlexGroup by adding new resources. This is limited to two new resources per available aggregate.


	     Default: "use_existing_resources"
	*/
	SizingMethod *string

	/* SnapshotDirectoryAccessEnabled.

	   This field, if true, enables the visible ".snapshot" directory from the client. The ".snapshot" directory will be available in every directory on the volume.

	   Default: true
	*/
	SnapshotDirectoryAccessEnabled *bool

	/* UUID.

	   Unique identifier of the volume.
	*/
	UUID string

	/* ValidateOnly.

	   Validate the volume move or volume conversion operations and their parameters, without actually performing the operation.

	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeModifyParams) WithDefaults() *VolumeModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeModifyParams) SetDefaults() {
	var (
		aggressiveReadaheadModeDefault = string("none")

		preserveLunIdsDefault = bool(false)

		returnTimeoutDefault = int64(0)

		scheduledSnapshotNamingSchemeDefault = string("create_time")

		sizingMethodDefault = string("use_existing_resources")

		snapshotDirectoryAccessEnabledDefault = bool(true)
	)

	val := VolumeModifyParams{
		AggressiveReadaheadMode:        &aggressiveReadaheadModeDefault,
		PreserveLunIds:                 &preserveLunIdsDefault,
		ReturnTimeout:                  &returnTimeoutDefault,
		ScheduledSnapshotNamingScheme:  &scheduledSnapshotNamingSchemeDefault,
		SizingMethod:                   &sizingMethodDefault,
		SnapshotDirectoryAccessEnabled: &snapshotDirectoryAccessEnabledDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the volume modify params
func (o *VolumeModifyParams) WithTimeout(timeout time.Duration) *VolumeModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume modify params
func (o *VolumeModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume modify params
func (o *VolumeModifyParams) WithContext(ctx context.Context) *VolumeModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume modify params
func (o *VolumeModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume modify params
func (o *VolumeModifyParams) WithHTTPClient(client *http.Client) *VolumeModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume modify params
func (o *VolumeModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggressiveReadaheadMode adds the aggressiveReadaheadMode to the volume modify params
func (o *VolumeModifyParams) WithAggressiveReadaheadMode(aggressiveReadaheadMode *string) *VolumeModifyParams {
	o.SetAggressiveReadaheadMode(aggressiveReadaheadMode)
	return o
}

// SetAggressiveReadaheadMode adds the aggressiveReadaheadMode to the volume modify params
func (o *VolumeModifyParams) SetAggressiveReadaheadMode(aggressiveReadaheadMode *string) {
	o.AggressiveReadaheadMode = aggressiveReadaheadMode
}

// WithCloneMatchParentStorageTier adds the cloneMatchParentStorageTier to the volume modify params
func (o *VolumeModifyParams) WithCloneMatchParentStorageTier(cloneMatchParentStorageTier *bool) *VolumeModifyParams {
	o.SetCloneMatchParentStorageTier(cloneMatchParentStorageTier)
	return o
}

// SetCloneMatchParentStorageTier adds the cloneMatchParentStorageTier to the volume modify params
func (o *VolumeModifyParams) SetCloneMatchParentStorageTier(cloneMatchParentStorageTier *bool) {
	o.CloneMatchParentStorageTier = cloneMatchParentStorageTier
}

// WithInfo adds the info to the volume modify params
func (o *VolumeModifyParams) WithInfo(info *models.Volume) *VolumeModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the volume modify params
func (o *VolumeModifyParams) SetInfo(info *models.Volume) {
	o.Info = info
}

// WithNvfail adds the nvfail to the volume modify params
func (o *VolumeModifyParams) WithNvfail(nvfail *string) *VolumeModifyParams {
	o.SetNvfail(nvfail)
	return o
}

// SetNvfail adds the nvfail to the volume modify params
func (o *VolumeModifyParams) SetNvfail(nvfail *string) {
	o.Nvfail = nvfail
}

// WithPreserveLunIds adds the preserveLunIds to the volume modify params
func (o *VolumeModifyParams) WithPreserveLunIds(preserveLunIds *bool) *VolumeModifyParams {
	o.SetPreserveLunIds(preserveLunIds)
	return o
}

// SetPreserveLunIds adds the preserveLunIds to the volume modify params
func (o *VolumeModifyParams) SetPreserveLunIds(preserveLunIds *bool) {
	o.PreserveLunIds = preserveLunIds
}

// WithRestoreToByteCount adds the restoreToByteCount to the volume modify params
func (o *VolumeModifyParams) WithRestoreToByteCount(restoreToByteCount *float64) *VolumeModifyParams {
	o.SetRestoreToByteCount(restoreToByteCount)
	return o
}

// SetRestoreToByteCount adds the restoreToByteCount to the volume modify params
func (o *VolumeModifyParams) SetRestoreToByteCount(restoreToByteCount *float64) {
	o.RestoreToByteCount = restoreToByteCount
}

// WithRestoreToPath adds the restoreToPath to the volume modify params
func (o *VolumeModifyParams) WithRestoreToPath(restoreToPath *string) *VolumeModifyParams {
	o.SetRestoreToPath(restoreToPath)
	return o
}

// SetRestoreToPath adds the restoreToPath to the volume modify params
func (o *VolumeModifyParams) SetRestoreToPath(restoreToPath *string) {
	o.RestoreToPath = restoreToPath
}

// WithRestoreToRestorePath adds the restoreToRestorePath to the volume modify params
func (o *VolumeModifyParams) WithRestoreToRestorePath(restoreToRestorePath *string) *VolumeModifyParams {
	o.SetRestoreToRestorePath(restoreToRestorePath)
	return o
}

// SetRestoreToRestorePath adds the restoreToRestorePath to the volume modify params
func (o *VolumeModifyParams) SetRestoreToRestorePath(restoreToRestorePath *string) {
	o.RestoreToRestorePath = restoreToRestorePath
}

// WithRestoreToSnapshotName adds the restoreToSnapshotName to the volume modify params
func (o *VolumeModifyParams) WithRestoreToSnapshotName(restoreToSnapshotName *string) *VolumeModifyParams {
	o.SetRestoreToSnapshotName(restoreToSnapshotName)
	return o
}

// SetRestoreToSnapshotName adds the restoreToSnapshotName to the volume modify params
func (o *VolumeModifyParams) SetRestoreToSnapshotName(restoreToSnapshotName *string) {
	o.RestoreToSnapshotName = restoreToSnapshotName
}

// WithRestoreToSnapshotUUID adds the restoreToSnapshotUUID to the volume modify params
func (o *VolumeModifyParams) WithRestoreToSnapshotUUID(restoreToSnapshotUUID *string) *VolumeModifyParams {
	o.SetRestoreToSnapshotUUID(restoreToSnapshotUUID)
	return o
}

// SetRestoreToSnapshotUUID adds the restoreToSnapshotUuid to the volume modify params
func (o *VolumeModifyParams) SetRestoreToSnapshotUUID(restoreToSnapshotUUID *string) {
	o.RestoreToSnapshotUUID = restoreToSnapshotUUID
}

// WithRestoreToStartByte adds the restoreToStartByte to the volume modify params
func (o *VolumeModifyParams) WithRestoreToStartByte(restoreToStartByte *float64) *VolumeModifyParams {
	o.SetRestoreToStartByte(restoreToStartByte)
	return o
}

// SetRestoreToStartByte adds the restoreToStartByte to the volume modify params
func (o *VolumeModifyParams) SetRestoreToStartByte(restoreToStartByte *float64) {
	o.RestoreToStartByte = restoreToStartByte
}

// WithReturnTimeout adds the returnTimeout to the volume modify params
func (o *VolumeModifyParams) WithReturnTimeout(returnTimeout *int64) *VolumeModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the volume modify params
func (o *VolumeModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScheduledSnapshotNamingScheme adds the scheduledSnapshotNamingScheme to the volume modify params
func (o *VolumeModifyParams) WithScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme *string) *VolumeModifyParams {
	o.SetScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme)
	return o
}

// SetScheduledSnapshotNamingScheme adds the scheduledSnapshotNamingScheme to the volume modify params
func (o *VolumeModifyParams) SetScheduledSnapshotNamingScheme(scheduledSnapshotNamingScheme *string) {
	o.ScheduledSnapshotNamingScheme = scheduledSnapshotNamingScheme
}

// WithSizingMethod adds the sizingMethod to the volume modify params
func (o *VolumeModifyParams) WithSizingMethod(sizingMethod *string) *VolumeModifyParams {
	o.SetSizingMethod(sizingMethod)
	return o
}

// SetSizingMethod adds the sizingMethod to the volume modify params
func (o *VolumeModifyParams) SetSizingMethod(sizingMethod *string) {
	o.SizingMethod = sizingMethod
}

// WithSnapshotDirectoryAccessEnabled adds the snapshotDirectoryAccessEnabled to the volume modify params
func (o *VolumeModifyParams) WithSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled *bool) *VolumeModifyParams {
	o.SetSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled)
	return o
}

// SetSnapshotDirectoryAccessEnabled adds the snapshotDirectoryAccessEnabled to the volume modify params
func (o *VolumeModifyParams) SetSnapshotDirectoryAccessEnabled(snapshotDirectoryAccessEnabled *bool) {
	o.SnapshotDirectoryAccessEnabled = snapshotDirectoryAccessEnabled
}

// WithUUID adds the uuid to the volume modify params
func (o *VolumeModifyParams) WithUUID(uuid string) *VolumeModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the volume modify params
func (o *VolumeModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the volume modify params
func (o *VolumeModifyParams) WithValidateOnly(validateOnly *bool) *VolumeModifyParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the volume modify params
func (o *VolumeModifyParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggressiveReadaheadMode != nil {

		// query param aggressive_readahead_mode
		var qrAggressiveReadaheadMode string

		if o.AggressiveReadaheadMode != nil {
			qrAggressiveReadaheadMode = *o.AggressiveReadaheadMode
		}
		qAggressiveReadaheadMode := qrAggressiveReadaheadMode
		if qAggressiveReadaheadMode != "" {

			if err := r.SetQueryParam("aggressive_readahead_mode", qAggressiveReadaheadMode); err != nil {
				return err
			}
		}
	}

	if o.CloneMatchParentStorageTier != nil {

		// query param clone.match_parent_storage_tier
		var qrCloneMatchParentStorageTier bool

		if o.CloneMatchParentStorageTier != nil {
			qrCloneMatchParentStorageTier = *o.CloneMatchParentStorageTier
		}
		qCloneMatchParentStorageTier := swag.FormatBool(qrCloneMatchParentStorageTier)
		if qCloneMatchParentStorageTier != "" {

			if err := r.SetQueryParam("clone.match_parent_storage_tier", qCloneMatchParentStorageTier); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.Nvfail != nil {

		// query param nvfail
		var qrNvfail string

		if o.Nvfail != nil {
			qrNvfail = *o.Nvfail
		}
		qNvfail := qrNvfail
		if qNvfail != "" {

			if err := r.SetQueryParam("nvfail", qNvfail); err != nil {
				return err
			}
		}
	}

	if o.PreserveLunIds != nil {

		// query param preserve_lun_ids
		var qrPreserveLunIds bool

		if o.PreserveLunIds != nil {
			qrPreserveLunIds = *o.PreserveLunIds
		}
		qPreserveLunIds := swag.FormatBool(qrPreserveLunIds)
		if qPreserveLunIds != "" {

			if err := r.SetQueryParam("preserve_lun_ids", qPreserveLunIds); err != nil {
				return err
			}
		}
	}

	if o.RestoreToByteCount != nil {

		// query param restore_to.byte_count
		var qrRestoreToByteCount float64

		if o.RestoreToByteCount != nil {
			qrRestoreToByteCount = *o.RestoreToByteCount
		}
		qRestoreToByteCount := swag.FormatFloat64(qrRestoreToByteCount)
		if qRestoreToByteCount != "" {

			if err := r.SetQueryParam("restore_to.byte_count", qRestoreToByteCount); err != nil {
				return err
			}
		}
	}

	if o.RestoreToPath != nil {

		// query param restore_to.path
		var qrRestoreToPath string

		if o.RestoreToPath != nil {
			qrRestoreToPath = *o.RestoreToPath
		}
		qRestoreToPath := qrRestoreToPath
		if qRestoreToPath != "" {

			if err := r.SetQueryParam("restore_to.path", qRestoreToPath); err != nil {
				return err
			}
		}
	}

	if o.RestoreToRestorePath != nil {

		// query param restore_to.restore_path
		var qrRestoreToRestorePath string

		if o.RestoreToRestorePath != nil {
			qrRestoreToRestorePath = *o.RestoreToRestorePath
		}
		qRestoreToRestorePath := qrRestoreToRestorePath
		if qRestoreToRestorePath != "" {

			if err := r.SetQueryParam("restore_to.restore_path", qRestoreToRestorePath); err != nil {
				return err
			}
		}
	}

	if o.RestoreToSnapshotName != nil {

		// query param restore_to.snapshot.name
		var qrRestoreToSnapshotName string

		if o.RestoreToSnapshotName != nil {
			qrRestoreToSnapshotName = *o.RestoreToSnapshotName
		}
		qRestoreToSnapshotName := qrRestoreToSnapshotName
		if qRestoreToSnapshotName != "" {

			if err := r.SetQueryParam("restore_to.snapshot.name", qRestoreToSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.RestoreToSnapshotUUID != nil {

		// query param restore_to.snapshot.uuid
		var qrRestoreToSnapshotUUID string

		if o.RestoreToSnapshotUUID != nil {
			qrRestoreToSnapshotUUID = *o.RestoreToSnapshotUUID
		}
		qRestoreToSnapshotUUID := qrRestoreToSnapshotUUID
		if qRestoreToSnapshotUUID != "" {

			if err := r.SetQueryParam("restore_to.snapshot.uuid", qRestoreToSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.RestoreToStartByte != nil {

		// query param restore_to.start_byte
		var qrRestoreToStartByte float64

		if o.RestoreToStartByte != nil {
			qrRestoreToStartByte = *o.RestoreToStartByte
		}
		qRestoreToStartByte := swag.FormatFloat64(qrRestoreToStartByte)
		if qRestoreToStartByte != "" {

			if err := r.SetQueryParam("restore_to.start_byte", qRestoreToStartByte); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScheduledSnapshotNamingScheme != nil {

		// query param scheduled_snapshot_naming_scheme
		var qrScheduledSnapshotNamingScheme string

		if o.ScheduledSnapshotNamingScheme != nil {
			qrScheduledSnapshotNamingScheme = *o.ScheduledSnapshotNamingScheme
		}
		qScheduledSnapshotNamingScheme := qrScheduledSnapshotNamingScheme
		if qScheduledSnapshotNamingScheme != "" {

			if err := r.SetQueryParam("scheduled_snapshot_naming_scheme", qScheduledSnapshotNamingScheme); err != nil {
				return err
			}
		}
	}

	if o.SizingMethod != nil {

		// query param sizing_method
		var qrSizingMethod string

		if o.SizingMethod != nil {
			qrSizingMethod = *o.SizingMethod
		}
		qSizingMethod := qrSizingMethod
		if qSizingMethod != "" {

			if err := r.SetQueryParam("sizing_method", qSizingMethod); err != nil {
				return err
			}
		}
	}

	if o.SnapshotDirectoryAccessEnabled != nil {

		// query param snapshot_directory_access_enabled
		var qrSnapshotDirectoryAccessEnabled bool

		if o.SnapshotDirectoryAccessEnabled != nil {
			qrSnapshotDirectoryAccessEnabled = *o.SnapshotDirectoryAccessEnabled
		}
		qSnapshotDirectoryAccessEnabled := swag.FormatBool(qrSnapshotDirectoryAccessEnabled)
		if qSnapshotDirectoryAccessEnabled != "" {

			if err := r.SetQueryParam("snapshot_directory_access_enabled", qSnapshotDirectoryAccessEnabled); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
