// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAutoUpdateConfigurationCollectionGetParams creates a new AutoUpdateConfigurationCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAutoUpdateConfigurationCollectionGetParams() *AutoUpdateConfigurationCollectionGetParams {
	return &AutoUpdateConfigurationCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAutoUpdateConfigurationCollectionGetParamsWithTimeout creates a new AutoUpdateConfigurationCollectionGetParams object
// with the ability to set a timeout on a request.
func NewAutoUpdateConfigurationCollectionGetParamsWithTimeout(timeout time.Duration) *AutoUpdateConfigurationCollectionGetParams {
	return &AutoUpdateConfigurationCollectionGetParams{
		timeout: timeout,
	}
}

// NewAutoUpdateConfigurationCollectionGetParamsWithContext creates a new AutoUpdateConfigurationCollectionGetParams object
// with the ability to set a context for a request.
func NewAutoUpdateConfigurationCollectionGetParamsWithContext(ctx context.Context) *AutoUpdateConfigurationCollectionGetParams {
	return &AutoUpdateConfigurationCollectionGetParams{
		Context: ctx,
	}
}

// NewAutoUpdateConfigurationCollectionGetParamsWithHTTPClient creates a new AutoUpdateConfigurationCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAutoUpdateConfigurationCollectionGetParamsWithHTTPClient(client *http.Client) *AutoUpdateConfigurationCollectionGetParams {
	return &AutoUpdateConfigurationCollectionGetParams{
		HTTPClient: client,
	}
}

/*
AutoUpdateConfigurationCollectionGetParams contains all the parameters to send to the API endpoint

	for the auto update configuration collection get operation.

	Typically these are written to a http.Request.
*/
type AutoUpdateConfigurationCollectionGetParams struct {

	/* Action.

	   Filter by action
	*/
	Action *string

	/* Category.

	   Filter by category
	*/
	Category *string

	/* DescriptionCode.

	   Filter by description.code
	*/
	DescriptionCode *string

	/* DescriptionMessage.

	   Filter by description.message
	*/
	DescriptionMessage *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the auto update configuration collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateConfigurationCollectionGetParams) WithDefaults() *AutoUpdateConfigurationCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the auto update configuration collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateConfigurationCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AutoUpdateConfigurationCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithTimeout(timeout time.Duration) *AutoUpdateConfigurationCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithContext(ctx context.Context) *AutoUpdateConfigurationCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithHTTPClient(client *http.Client) *AutoUpdateConfigurationCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithAction(action *string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetAction(action *string) {
	o.Action = action
}

// WithCategory adds the category to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithCategory(category *string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetCategory(category)
	return o
}

// SetCategory adds the category to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetCategory(category *string) {
	o.Category = category
}

// WithDescriptionCode adds the descriptionCode to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithDescriptionCode(descriptionCode *string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetDescriptionCode(descriptionCode)
	return o
}

// SetDescriptionCode adds the descriptionCode to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetDescriptionCode(descriptionCode *string) {
	o.DescriptionCode = descriptionCode
}

// WithDescriptionMessage adds the descriptionMessage to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithDescriptionMessage(descriptionMessage *string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetDescriptionMessage(descriptionMessage)
	return o
}

// SetDescriptionMessage adds the descriptionMessage to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetDescriptionMessage(descriptionMessage *string) {
	o.DescriptionMessage = descriptionMessage
}

// WithFields adds the fields to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithFields(fields []string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithMaxRecords(maxRecords *int64) *AutoUpdateConfigurationCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithOrderBy(orderBy []string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithReturnRecords(returnRecords *bool) *AutoUpdateConfigurationCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *AutoUpdateConfigurationCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) WithUUID(uuid *string) *AutoUpdateConfigurationCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the auto update configuration collection get params
func (o *AutoUpdateConfigurationCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AutoUpdateConfigurationCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.Category != nil {

		// query param category
		var qrCategory string

		if o.Category != nil {
			qrCategory = *o.Category
		}
		qCategory := qrCategory
		if qCategory != "" {

			if err := r.SetQueryParam("category", qCategory); err != nil {
				return err
			}
		}
	}

	if o.DescriptionCode != nil {

		// query param description.code
		var qrDescriptionCode string

		if o.DescriptionCode != nil {
			qrDescriptionCode = *o.DescriptionCode
		}
		qDescriptionCode := qrDescriptionCode
		if qDescriptionCode != "" {

			if err := r.SetQueryParam("description.code", qDescriptionCode); err != nil {
				return err
			}
		}
	}

	if o.DescriptionMessage != nil {

		// query param description.message
		var qrDescriptionMessage string

		if o.DescriptionMessage != nil {
			qrDescriptionMessage = *o.DescriptionMessage
		}
		qDescriptionMessage := qrDescriptionMessage
		if qDescriptionMessage != "" {

			if err := r.SetQueryParam("description.message", qDescriptionMessage); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAutoUpdateConfigurationCollectionGet binds the parameter fields
func (o *AutoUpdateConfigurationCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAutoUpdateConfigurationCollectionGet binds the parameter order_by
func (o *AutoUpdateConfigurationCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
