// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewAutoUpdateConfigurationModifyParams creates a new AutoUpdateConfigurationModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAutoUpdateConfigurationModifyParams() *AutoUpdateConfigurationModifyParams {
	return &AutoUpdateConfigurationModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAutoUpdateConfigurationModifyParamsWithTimeout creates a new AutoUpdateConfigurationModifyParams object
// with the ability to set a timeout on a request.
func NewAutoUpdateConfigurationModifyParamsWithTimeout(timeout time.Duration) *AutoUpdateConfigurationModifyParams {
	return &AutoUpdateConfigurationModifyParams{
		timeout: timeout,
	}
}

// NewAutoUpdateConfigurationModifyParamsWithContext creates a new AutoUpdateConfigurationModifyParams object
// with the ability to set a context for a request.
func NewAutoUpdateConfigurationModifyParamsWithContext(ctx context.Context) *AutoUpdateConfigurationModifyParams {
	return &AutoUpdateConfigurationModifyParams{
		Context: ctx,
	}
}

// NewAutoUpdateConfigurationModifyParamsWithHTTPClient creates a new AutoUpdateConfigurationModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewAutoUpdateConfigurationModifyParamsWithHTTPClient(client *http.Client) *AutoUpdateConfigurationModifyParams {
	return &AutoUpdateConfigurationModifyParams{
		HTTPClient: client,
	}
}

/*
AutoUpdateConfigurationModifyParams contains all the parameters to send to the API endpoint

	for the auto update configuration modify operation.

	Typically these are written to a http.Request.
*/
type AutoUpdateConfigurationModifyParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.AutoUpdateConfiguration

	/* UUID.

	   Unique identifier for configuration record.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the auto update configuration modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateConfigurationModifyParams) WithDefaults() *AutoUpdateConfigurationModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the auto update configuration modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateConfigurationModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) WithTimeout(timeout time.Duration) *AutoUpdateConfigurationModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) WithContext(ctx context.Context) *AutoUpdateConfigurationModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) WithHTTPClient(client *http.Client) *AutoUpdateConfigurationModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) WithInfo(info *models.AutoUpdateConfiguration) *AutoUpdateConfigurationModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) SetInfo(info *models.AutoUpdateConfiguration) {
	o.Info = info
}

// WithUUID adds the uuid to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) WithUUID(uuid string) *AutoUpdateConfigurationModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the auto update configuration modify params
func (o *AutoUpdateConfigurationModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AutoUpdateConfigurationModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
