// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewAutoUpdateInfoModifyParams creates a new AutoUpdateInfoModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAutoUpdateInfoModifyParams() *AutoUpdateInfoModifyParams {
	return &AutoUpdateInfoModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAutoUpdateInfoModifyParamsWithTimeout creates a new AutoUpdateInfoModifyParams object
// with the ability to set a timeout on a request.
func NewAutoUpdateInfoModifyParamsWithTimeout(timeout time.Duration) *AutoUpdateInfoModifyParams {
	return &AutoUpdateInfoModifyParams{
		timeout: timeout,
	}
}

// NewAutoUpdateInfoModifyParamsWithContext creates a new AutoUpdateInfoModifyParams object
// with the ability to set a context for a request.
func NewAutoUpdateInfoModifyParamsWithContext(ctx context.Context) *AutoUpdateInfoModifyParams {
	return &AutoUpdateInfoModifyParams{
		Context: ctx,
	}
}

// NewAutoUpdateInfoModifyParamsWithHTTPClient creates a new AutoUpdateInfoModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewAutoUpdateInfoModifyParamsWithHTTPClient(client *http.Client) *AutoUpdateInfoModifyParams {
	return &AutoUpdateInfoModifyParams{
		HTTPClient: client,
	}
}

/*
AutoUpdateInfoModifyParams contains all the parameters to send to the API endpoint

	for the auto update info modify operation.

	Typically these are written to a http.Request.
*/
type AutoUpdateInfoModifyParams struct {

	/* Force.

	   Set the force flag to true to enable the automatic update feature regardless of how AutoSupport is configured. Without this flag set to true, an attempt to enable the automatic update feature fails unless AutoSupport is enabled, its transport is HTTPS, and the AutoSupport OnDemand feature is enabled.

	*/
	Force *bool

	/* Info.

	   Information specification
	*/
	Info *models.AutoUpdateInfo

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the auto update info modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateInfoModifyParams) WithDefaults() *AutoUpdateInfoModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the auto update info modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateInfoModifyParams) SetDefaults() {
	var (
		forceDefault = bool(false)
	)

	val := AutoUpdateInfoModifyParams{
		Force: &forceDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) WithTimeout(timeout time.Duration) *AutoUpdateInfoModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) WithContext(ctx context.Context) *AutoUpdateInfoModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) WithHTTPClient(client *http.Client) *AutoUpdateInfoModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) WithForce(force *bool) *AutoUpdateInfoModifyParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) SetForce(force *bool) {
	o.Force = force
}

// WithInfo adds the info to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) WithInfo(info *models.AutoUpdateInfo) *AutoUpdateInfoModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the auto update info modify params
func (o *AutoUpdateInfoModifyParams) SetInfo(info *models.AutoUpdateInfo) {
	o.Info = info
}

// WriteToRequest writes these params to a swagger request
func (o *AutoUpdateInfoModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
