// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAutoUpdateStatusModifyCollectionParams creates a new AutoUpdateStatusModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAutoUpdateStatusModifyCollectionParams() *AutoUpdateStatusModifyCollectionParams {
	return &AutoUpdateStatusModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAutoUpdateStatusModifyCollectionParamsWithTimeout creates a new AutoUpdateStatusModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewAutoUpdateStatusModifyCollectionParamsWithTimeout(timeout time.Duration) *AutoUpdateStatusModifyCollectionParams {
	return &AutoUpdateStatusModifyCollectionParams{
		timeout: timeout,
	}
}

// NewAutoUpdateStatusModifyCollectionParamsWithContext creates a new AutoUpdateStatusModifyCollectionParams object
// with the ability to set a context for a request.
func NewAutoUpdateStatusModifyCollectionParamsWithContext(ctx context.Context) *AutoUpdateStatusModifyCollectionParams {
	return &AutoUpdateStatusModifyCollectionParams{
		Context: ctx,
	}
}

// NewAutoUpdateStatusModifyCollectionParamsWithHTTPClient creates a new AutoUpdateStatusModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAutoUpdateStatusModifyCollectionParamsWithHTTPClient(client *http.Client) *AutoUpdateStatusModifyCollectionParams {
	return &AutoUpdateStatusModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
AutoUpdateStatusModifyCollectionParams contains all the parameters to send to the API endpoint

	for the auto update status modify collection operation.

	Typically these are written to a http.Request.
*/
type AutoUpdateStatusModifyCollectionParams struct {

	/* Action.

	   Action to be performed on the update
	*/
	Action string

	/* ContentCategory.

	   Filter by content_category
	*/
	ContentCategory *string

	/* ContentType.

	   Filter by content_type
	*/
	ContentType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreationTime.

	   Filter by creation_time
	*/
	CreationTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* ExpiryTime.

	   Filter by expiry_time
	*/
	ExpiryTime *string

	/* Info.

	   Info specification
	*/
	Info AutoUpdateStatusModifyCollectionBody

	/* LastStateChangeTime.

	   Filter by last_state_change_time
	*/
	LastStateChangeTime *string

	/* PackageID.

	   Filter by package_id
	*/
	PackageID *string

	/* PercentComplete.

	   Filter by percent_complete
	*/
	PercentComplete *int64

	/* RemainingTime.

	   Filter by remaining_time
	*/
	RemainingTime *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScheduleTime.

	   Date and Time for which update is to be scheduled. This parameter is required only when action is "schedule". It should be in the ISO-8601 Date and Time format. Example- "2020-12-05T09:12:23Z".

	   Format: date-time
	*/
	ScheduleTime *strfmt.DateTime

	/* ScheduledTime.

	   Filter by scheduled_time
	*/
	ScheduledTime *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatusArgumentsCode.

	   Filter by status.arguments.code
	*/
	StatusArgumentsCode *string

	/* StatusArgumentsMessage.

	   Filter by status.arguments.message
	*/
	StatusArgumentsMessage *string

	/* StatusCode.

	   Filter by status.code
	*/
	StatusCode *string

	/* StatusMessage.

	   Filter by status.message
	*/
	StatusMessage *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the auto update status modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateStatusModifyCollectionParams) WithDefaults() *AutoUpdateStatusModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the auto update status modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutoUpdateStatusModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := AutoUpdateStatusModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithTimeout(timeout time.Duration) *AutoUpdateStatusModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithContext(ctx context.Context) *AutoUpdateStatusModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithHTTPClient(client *http.Client) *AutoUpdateStatusModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithAction(action string) *AutoUpdateStatusModifyCollectionParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetAction(action string) {
	o.Action = action
}

// WithContentCategory adds the contentCategory to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithContentCategory(contentCategory *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetContentCategory(contentCategory)
	return o
}

// SetContentCategory adds the contentCategory to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetContentCategory(contentCategory *string) {
	o.ContentCategory = contentCategory
}

// WithContentType adds the contentType to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithContentType(contentType *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetContentType(contentType)
	return o
}

// SetContentType adds the contentType to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetContentType(contentType *string) {
	o.ContentType = contentType
}

// WithContinueOnFailure adds the continueOnFailure to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *AutoUpdateStatusModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreationTime adds the creationTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithCreationTime(creationTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetCreationTime(creationTime)
	return o
}

// SetCreationTime adds the creationTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetCreationTime(creationTime *string) {
	o.CreationTime = creationTime
}

// WithDescription adds the description to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithDescription(description *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEndTime adds the endTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithEndTime(endTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithExpiryTime adds the expiryTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithExpiryTime(expiryTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetExpiryTime(expiryTime)
	return o
}

// SetExpiryTime adds the expiryTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetExpiryTime(expiryTime *string) {
	o.ExpiryTime = expiryTime
}

// WithInfo adds the info to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithInfo(info AutoUpdateStatusModifyCollectionBody) *AutoUpdateStatusModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetInfo(info AutoUpdateStatusModifyCollectionBody) {
	o.Info = info
}

// WithLastStateChangeTime adds the lastStateChangeTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithLastStateChangeTime(lastStateChangeTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetLastStateChangeTime(lastStateChangeTime)
	return o
}

// SetLastStateChangeTime adds the lastStateChangeTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetLastStateChangeTime(lastStateChangeTime *string) {
	o.LastStateChangeTime = lastStateChangeTime
}

// WithPackageID adds the packageID to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithPackageID(packageID *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetPackageID(packageID)
	return o
}

// SetPackageID adds the packageId to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetPackageID(packageID *string) {
	o.PackageID = packageID
}

// WithPercentComplete adds the percentComplete to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithPercentComplete(percentComplete *int64) *AutoUpdateStatusModifyCollectionParams {
	o.SetPercentComplete(percentComplete)
	return o
}

// SetPercentComplete adds the percentComplete to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetPercentComplete(percentComplete *int64) {
	o.PercentComplete = percentComplete
}

// WithRemainingTime adds the remainingTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithRemainingTime(remainingTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetRemainingTime(remainingTime)
	return o
}

// SetRemainingTime adds the remainingTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetRemainingTime(remainingTime *string) {
	o.RemainingTime = remainingTime
}

// WithReturnRecords adds the returnRecords to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithReturnRecords(returnRecords *bool) *AutoUpdateStatusModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *AutoUpdateStatusModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScheduleTime adds the scheduleTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithScheduleTime(scheduleTime *strfmt.DateTime) *AutoUpdateStatusModifyCollectionParams {
	o.SetScheduleTime(scheduleTime)
	return o
}

// SetScheduleTime adds the scheduleTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetScheduleTime(scheduleTime *strfmt.DateTime) {
	o.ScheduleTime = scheduleTime
}

// WithScheduledTime adds the scheduledTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithScheduledTime(scheduledTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetScheduledTime(scheduledTime)
	return o
}

// SetScheduledTime adds the scheduledTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetScheduledTime(scheduledTime *string) {
	o.ScheduledTime = scheduledTime
}

// WithSerialRecords adds the serialRecords to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithSerialRecords(serialRecords *bool) *AutoUpdateStatusModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStartTime adds the startTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithStartTime(startTime *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WithState adds the state to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithState(state *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatusArgumentsCode adds the statusArgumentsCode to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithStatusArgumentsCode(statusArgumentsCode *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetStatusArgumentsCode(statusArgumentsCode)
	return o
}

// SetStatusArgumentsCode adds the statusArgumentsCode to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetStatusArgumentsCode(statusArgumentsCode *string) {
	o.StatusArgumentsCode = statusArgumentsCode
}

// WithStatusArgumentsMessage adds the statusArgumentsMessage to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithStatusArgumentsMessage(statusArgumentsMessage *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetStatusArgumentsMessage(statusArgumentsMessage)
	return o
}

// SetStatusArgumentsMessage adds the statusArgumentsMessage to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetStatusArgumentsMessage(statusArgumentsMessage *string) {
	o.StatusArgumentsMessage = statusArgumentsMessage
}

// WithStatusCode adds the statusCode to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithStatusCode(statusCode *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetStatusCode(statusCode)
	return o
}

// SetStatusCode adds the statusCode to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetStatusCode(statusCode *string) {
	o.StatusCode = statusCode
}

// WithStatusMessage adds the statusMessage to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithStatusMessage(statusMessage *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetStatusMessage(statusMessage)
	return o
}

// SetStatusMessage adds the statusMessage to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetStatusMessage(statusMessage *string) {
	o.StatusMessage = statusMessage
}

// WithUUID adds the uuid to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) WithUUID(uuid *string) *AutoUpdateStatusModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the auto update status modify collection params
func (o *AutoUpdateStatusModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AutoUpdateStatusModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action
	qrAction := o.Action
	qAction := qrAction
	if qAction != "" {

		if err := r.SetQueryParam("action", qAction); err != nil {
			return err
		}
	}

	if o.ContentCategory != nil {

		// query param content_category
		var qrContentCategory string

		if o.ContentCategory != nil {
			qrContentCategory = *o.ContentCategory
		}
		qContentCategory := qrContentCategory
		if qContentCategory != "" {

			if err := r.SetQueryParam("content_category", qContentCategory); err != nil {
				return err
			}
		}
	}

	if o.ContentType != nil {

		// query param content_type
		var qrContentType string

		if o.ContentType != nil {
			qrContentType = *o.ContentType
		}
		qContentType := qrContentType
		if qContentType != "" {

			if err := r.SetQueryParam("content_type", qContentType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreationTime != nil {

		// query param creation_time
		var qrCreationTime string

		if o.CreationTime != nil {
			qrCreationTime = *o.CreationTime
		}
		qCreationTime := qrCreationTime
		if qCreationTime != "" {

			if err := r.SetQueryParam("creation_time", qCreationTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}

	if o.ExpiryTime != nil {

		// query param expiry_time
		var qrExpiryTime string

		if o.ExpiryTime != nil {
			qrExpiryTime = *o.ExpiryTime
		}
		qExpiryTime := qrExpiryTime
		if qExpiryTime != "" {

			if err := r.SetQueryParam("expiry_time", qExpiryTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LastStateChangeTime != nil {

		// query param last_state_change_time
		var qrLastStateChangeTime string

		if o.LastStateChangeTime != nil {
			qrLastStateChangeTime = *o.LastStateChangeTime
		}
		qLastStateChangeTime := qrLastStateChangeTime
		if qLastStateChangeTime != "" {

			if err := r.SetQueryParam("last_state_change_time", qLastStateChangeTime); err != nil {
				return err
			}
		}
	}

	if o.PackageID != nil {

		// query param package_id
		var qrPackageID string

		if o.PackageID != nil {
			qrPackageID = *o.PackageID
		}
		qPackageID := qrPackageID
		if qPackageID != "" {

			if err := r.SetQueryParam("package_id", qPackageID); err != nil {
				return err
			}
		}
	}

	if o.PercentComplete != nil {

		// query param percent_complete
		var qrPercentComplete int64

		if o.PercentComplete != nil {
			qrPercentComplete = *o.PercentComplete
		}
		qPercentComplete := swag.FormatInt64(qrPercentComplete)
		if qPercentComplete != "" {

			if err := r.SetQueryParam("percent_complete", qPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.RemainingTime != nil {

		// query param remaining_time
		var qrRemainingTime string

		if o.RemainingTime != nil {
			qrRemainingTime = *o.RemainingTime
		}
		qRemainingTime := qrRemainingTime
		if qRemainingTime != "" {

			if err := r.SetQueryParam("remaining_time", qRemainingTime); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScheduleTime != nil {

		// query param schedule_time
		var qrScheduleTime strfmt.DateTime

		if o.ScheduleTime != nil {
			qrScheduleTime = *o.ScheduleTime
		}
		qScheduleTime := qrScheduleTime.String()
		if qScheduleTime != "" {

			if err := r.SetQueryParam("schedule_time", qScheduleTime); err != nil {
				return err
			}
		}
	}

	if o.ScheduledTime != nil {

		// query param scheduled_time
		var qrScheduledTime string

		if o.ScheduledTime != nil {
			qrScheduledTime = *o.ScheduledTime
		}
		qScheduledTime := qrScheduledTime
		if qScheduledTime != "" {

			if err := r.SetQueryParam("scheduled_time", qScheduledTime); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatusArgumentsCode != nil {

		// query param status.arguments.code
		var qrStatusArgumentsCode string

		if o.StatusArgumentsCode != nil {
			qrStatusArgumentsCode = *o.StatusArgumentsCode
		}
		qStatusArgumentsCode := qrStatusArgumentsCode
		if qStatusArgumentsCode != "" {

			if err := r.SetQueryParam("status.arguments.code", qStatusArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.StatusArgumentsMessage != nil {

		// query param status.arguments.message
		var qrStatusArgumentsMessage string

		if o.StatusArgumentsMessage != nil {
			qrStatusArgumentsMessage = *o.StatusArgumentsMessage
		}
		qStatusArgumentsMessage := qrStatusArgumentsMessage
		if qStatusArgumentsMessage != "" {

			if err := r.SetQueryParam("status.arguments.message", qStatusArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.StatusCode != nil {

		// query param status.code
		var qrStatusCode string

		if o.StatusCode != nil {
			qrStatusCode = *o.StatusCode
		}
		qStatusCode := qrStatusCode
		if qStatusCode != "" {

			if err := r.SetQueryParam("status.code", qStatusCode); err != nil {
				return err
			}
		}
	}

	if o.StatusMessage != nil {

		// query param status.message
		var qrStatusMessage string

		if o.StatusMessage != nil {
			qrStatusMessage = *o.StatusMessage
		}
		qStatusMessage := qrStatusMessage
		if qStatusMessage != "" {

			if err := r.SetQueryParam("status.message", qStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
