// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AutoUpdateStatusModifyCollectionReader is a Reader for the AutoUpdateStatusModifyCollection structure.
type AutoUpdateStatusModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AutoUpdateStatusModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAutoUpdateStatusModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAutoUpdateStatusModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAutoUpdateStatusModifyCollectionOK creates a AutoUpdateStatusModifyCollectionOK with default headers values
func NewAutoUpdateStatusModifyCollectionOK() *AutoUpdateStatusModifyCollectionOK {
	return &AutoUpdateStatusModifyCollectionOK{}
}

/*
AutoUpdateStatusModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AutoUpdateStatusModifyCollectionOK struct {
}

// IsSuccess returns true when this auto update status modify collection o k response has a 2xx status code
func (o *AutoUpdateStatusModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this auto update status modify collection o k response has a 3xx status code
func (o *AutoUpdateStatusModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this auto update status modify collection o k response has a 4xx status code
func (o *AutoUpdateStatusModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this auto update status modify collection o k response has a 5xx status code
func (o *AutoUpdateStatusModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this auto update status modify collection o k response a status code equal to that given
func (o *AutoUpdateStatusModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the auto update status modify collection o k response
func (o *AutoUpdateStatusModifyCollectionOK) Code() int {
	return 200
}

func (o *AutoUpdateStatusModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /support/auto-update/updates][%d] autoUpdateStatusModifyCollectionOK", 200)
}

func (o *AutoUpdateStatusModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /support/auto-update/updates][%d] autoUpdateStatusModifyCollectionOK", 200)
}

func (o *AutoUpdateStatusModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAutoUpdateStatusModifyCollectionDefault creates a AutoUpdateStatusModifyCollectionDefault with default headers values
func NewAutoUpdateStatusModifyCollectionDefault(code int) *AutoUpdateStatusModifyCollectionDefault {
	return &AutoUpdateStatusModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	AutoUpdateStatusModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262248 | Unexpected parameter missing a delimiter. |
| 131072200 | Invalid Automatic Update ID. |
| 131072201 | No schedule to cancel for automatic update ID. |
| 131072202 | Cannot abort an automatic update that is not in progress. |
| 131072203 | Cannot dismiss a non-pending automatic update. |
| 131072204 | Cannot reactivate an automatic update that has not been dismissed. |
| 131072205 | Cannot schedule a non-pending automatic update to start. |
| 131072206 | Cannot schedule an automatic update past its expiration date. |
| 131072207 | Cannot schedule an automatic update in the past. |
| 131072208 | Cannot schedule automatic update while the feature is disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AutoUpdateStatusModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this auto update status modify collection default response has a 2xx status code
func (o *AutoUpdateStatusModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this auto update status modify collection default response has a 3xx status code
func (o *AutoUpdateStatusModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this auto update status modify collection default response has a 4xx status code
func (o *AutoUpdateStatusModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this auto update status modify collection default response has a 5xx status code
func (o *AutoUpdateStatusModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this auto update status modify collection default response a status code equal to that given
func (o *AutoUpdateStatusModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the auto update status modify collection default response
func (o *AutoUpdateStatusModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AutoUpdateStatusModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/auto-update/updates][%d] auto_update_status_modify_collection default %s", o._statusCode, payload)
}

func (o *AutoUpdateStatusModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/auto-update/updates][%d] auto_update_status_modify_collection default %s", o._statusCode, payload)
}

func (o *AutoUpdateStatusModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AutoUpdateStatusModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AutoUpdateStatusModifyCollectionBody auto update status modify collection body
swagger:model AutoUpdateStatusModifyCollectionBody
*/
type AutoUpdateStatusModifyCollectionBody struct {

	// links
	Links *models.AutoUpdateStatusInlineLinks `json:"_links,omitempty"`

	// Action to be applied to the automatic update.
	// Example: schedule_now
	// Enum: ["cancel_schedule","dismiss","schedule","schedule_now","abort","undismiss"]
	Action *string `json:"action,omitempty"`

	// auto update status response inline records
	AutoUpdateStatusResponseInlineRecords []*models.AutoUpdateStatus `json:"records,omitempty"`

	// Category of the update
	// Example: Firmware
	// Read Only: true
	ContentCategory *string `json:"content_category,omitempty"`

	// Image or package type.
	// Example: disk_fw
	// Read Only: true
	ContentType *string `json:"content_type,omitempty"`

	// The date and time at which the update request was received.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	CreationTime *strfmt.DateTime `json:"creation_time,omitempty"`

	// Description of the update.
	// Example: disk_fw version 3.0
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The date and time at which the update request processing ended.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// The date and time at which the update request will expire.
	// Example: 2021-06-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// The date and time at which the state of the update changed last.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	LastStateChangeTime *strfmt.DateTime `json:"last_state_change_time,omitempty"`

	// Unique identifier provided by the back-end.
	// Example: 572361f3-e769-439d-9c04-2ba48a08ff47
	// Read Only: true
	PackageID *string `json:"package_id,omitempty"`

	// Percentage of update completed
	// Example: 85
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// The time remaining for the update processing to complete in an ISO-8601 duration formatted string.
	// Example: PT1H45M13S
	// Read Only: true
	RemainingTime *string `json:"remaining_time,omitempty"`

	// Date and time when an automatic update action is scheduled.
	// This field is required when the action field is set to "schedule".
	//
	// Example: 2020-12-20 21:00:00+00:00
	// Format: date-time
	ScheduleTime *strfmt.DateTime `json:"schedule_time,omitempty"`

	// The date and time at which the update request is currently scheduled for.
	// Example: 2020-12-05 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	ScheduledTime *strfmt.DateTime `json:"scheduled_time,omitempty"`

	// The date and time at which the update request processing started.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// Current state of the update.
	// Example: pending_confirmation
	// Read Only: true
	// Enum: ["pending_confirmation","downloading","applying","applied","dismissed","scheduled","failed","aborted"]
	State *string `json:"state,omitempty"`

	// status
	Status *models.AutoUpdateStatusInlineStatus `json:"status,omitempty"`

	// Unique identifier for this update.
	// Example: 440ae2e4-fd8f-4225-9bee-94e2da3f9d8d
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this auto update status modify collection body
func (o *AutoUpdateStatusModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAutoUpdateStatusResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreationTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastStateChangeTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScheduleTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScheduledTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var autoUpdateStatusModifyCollectionBodyTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cancel_schedule","dismiss","schedule","schedule_now","abort","undismiss"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autoUpdateStatusModifyCollectionBodyTypeActionPropEnum = append(autoUpdateStatusModifyCollectionBodyTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// cancel_schedule
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionCancelSchedule captures enum value "cancel_schedule"
	AutoUpdateStatusModifyCollectionBodyActionCancelSchedule string = "cancel_schedule"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// dismiss
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionDismiss captures enum value "dismiss"
	AutoUpdateStatusModifyCollectionBodyActionDismiss string = "dismiss"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// schedule
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionSchedule captures enum value "schedule"
	AutoUpdateStatusModifyCollectionBodyActionSchedule string = "schedule"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// schedule_now
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionScheduleNow captures enum value "schedule_now"
	AutoUpdateStatusModifyCollectionBodyActionScheduleNow string = "schedule_now"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// abort
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionAbort captures enum value "abort"
	AutoUpdateStatusModifyCollectionBodyActionAbort string = "abort"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// action
	// Action
	// undismiss
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyActionUndismiss captures enum value "undismiss"
	AutoUpdateStatusModifyCollectionBodyActionUndismiss string = "undismiss"
)

// prop value enum
func (o *AutoUpdateStatusModifyCollectionBody) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autoUpdateStatusModifyCollectionBodyTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("info"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateAutoUpdateStatusResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AutoUpdateStatusResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AutoUpdateStatusResponseInlineRecords); i++ {
		if swag.IsZero(o.AutoUpdateStatusResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AutoUpdateStatusResponseInlineRecords[i] != nil {
			if err := o.AutoUpdateStatusResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateCreationTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"creation_time", "body", "date-time", o.CreationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(o.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"end_time", "body", "date-time", o.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateLastStateChangeTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastStateChangeTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"last_state_change_time", "body", "date-time", o.LastStateChangeTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateScheduleTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduleTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"schedule_time", "body", "date-time", o.ScheduleTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateScheduledTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduledTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"scheduled_time", "body", "date-time", o.ScheduledTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var autoUpdateStatusModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pending_confirmation","downloading","applying","applied","dismissed","scheduled","failed","aborted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autoUpdateStatusModifyCollectionBodyTypeStatePropEnum = append(autoUpdateStatusModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// pending_confirmation
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStatePendingConfirmation captures enum value "pending_confirmation"
	AutoUpdateStatusModifyCollectionBodyStatePendingConfirmation string = "pending_confirmation"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// downloading
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateDownloading captures enum value "downloading"
	AutoUpdateStatusModifyCollectionBodyStateDownloading string = "downloading"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// applying
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateApplying captures enum value "applying"
	AutoUpdateStatusModifyCollectionBodyStateApplying string = "applying"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// applied
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateApplied captures enum value "applied"
	AutoUpdateStatusModifyCollectionBodyStateApplied string = "applied"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// dismissed
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateDismissed captures enum value "dismissed"
	AutoUpdateStatusModifyCollectionBodyStateDismissed string = "dismissed"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// scheduled
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateScheduled captures enum value "scheduled"
	AutoUpdateStatusModifyCollectionBodyStateScheduled string = "scheduled"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// failed
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateFailed captures enum value "failed"
	AutoUpdateStatusModifyCollectionBodyStateFailed string = "failed"

	// BEGIN DEBUGGING
	// AutoUpdateStatusModifyCollectionBody
	// AutoUpdateStatusModifyCollectionBody
	// state
	// State
	// aborted
	// END DEBUGGING
	// AutoUpdateStatusModifyCollectionBodyStateAborted captures enum value "aborted"
	AutoUpdateStatusModifyCollectionBodyStateAborted string = "aborted"
)

// prop value enum
func (o *AutoUpdateStatusModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autoUpdateStatusModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status modify collection body based on the context it is used
func (o *AutoUpdateStatusModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAutoUpdateStatusResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateContentCategory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateContentType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastStateChangeTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePackageID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemainingTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScheduledTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateAutoUpdateStatusResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AutoUpdateStatusResponseInlineRecords); i++ {

		if o.AutoUpdateStatusResponseInlineRecords[i] != nil {
			if err := o.AutoUpdateStatusResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateContentCategory(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"content_category", "body", o.ContentCategory); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateContentType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"content_type", "body", o.ContentType); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateCreationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"creation_time", "body", o.CreationTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"end_time", "body", o.EndTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"expiry_time", "body", o.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateLastStateChangeTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_state_change_time", "body", o.LastStateChangeTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidatePackageID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"package_id", "body", o.PackageID); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"percent_complete", "body", o.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateRemainingTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"remaining_time", "body", o.RemainingTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateScheduledTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scheduled_time", "body", o.ScheduledTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *AutoUpdateStatusModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AutoUpdateStatusModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AutoUpdateStatusModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AutoUpdateStatusInlineLinks auto update status inline links
swagger:model auto_update_status_inline__links
*/
type AutoUpdateStatusInlineLinks struct {

	// self
	Self *models.AutoUpdateStatusInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this auto update status inline links
func (o *AutoUpdateStatusInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status inline links based on the context it is used
func (o *AutoUpdateStatusInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AutoUpdateStatusInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AutoUpdateStatusInlineLinks) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AutoUpdateStatusInlineLinksInlineSelf auto update status inline links inline self
swagger:model auto_update_status_inline__links_inline_self
*/
type AutoUpdateStatusInlineLinksInlineSelf struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this auto update status inline links inline self
func (o *AutoUpdateStatusInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineLinksInlineSelf) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status inline links inline self based on the context it is used
func (o *AutoUpdateStatusInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineLinksInlineSelf) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AutoUpdateStatusInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AutoUpdateStatusInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AutoUpdateStatusInlineStatus Status of the update.
// ONTAP Message Codes
// | Code       | Description |
// | ---------- | ----------- |
// | 8650878 | Get-url request to AutoSupport OnDemand Server failed. |
// | 131072105 | Package installation successful. |
// | 131072106 | Package installation failed. |
// | 131072107 | Package installation is in progress. |
// | 131072108 | An internal error occurred. |
// | 131072109 | No errors found. |
// | 131072110 | Failed to extract package. |
// | 131072111 | Failed to create entry in status table. |
// | 131072209 | Failed to download package. |
// | 131072210 | Failed to obtain download links. Will be retried. |
// | 131072211 | Installation cannot start because the following nodes are not up. Will be retried. |
// | 131072212 | Automatic update cannot start. Will be retried. |
// | 131072213 | Installation complete. |
// | 131072214 | Installation in progress. |
// | 131072215 | Scheduled to start. |
// | 131072301 | Unable to create directory. |
// | 131072302 | Update not required. It is already on the target firmware version. |
// | 131072303 | Unable to move installable to installation location. |
// | 131072304 | Successfully updated. All nodes already updated and skipped. |
// | 131072306 | Firmware distribution starting. |
// | 131072307 | Firmware distribution restarting. |
// | 131072308 | Firmware distribution failed. |
// | 131072309 | Firmware installation successful on node. |
// | 131072310 | Firmware installable is corrupt on node. |
// | 131072311 | Could not apply firmware update on nodes. |
// | 131072312 | Firmware update operation failed. |
// | 131072313 | Install failed to initiate on node. |
// | 131072314 | Install initiated on node. |
// | 131072315 | Install failed on node. |
// | 131072316 | Update in progress on node. |
// | 131072317 | Unexpected state occurred during firmware installation on node. |
// | 131072318 | Successfully updated SP/BMC firmware. |
// | 131072319 | Backup SP image is running. Firmware installation failed prematurely on node. |
// | 131072320 | SP rebooted with an unexpected firmware version on node. |
// | 131072321 | Waiting for shelf firmware to update. |
// | 131072322 | Update complete. |
// | 131072323 | Shelf update timed out. |
// | 131072324 | Successfully updated shelves on nodes. |
// | 131072325 | Waiting for disk firmware to update. |
// | 131072326 | Disk update completed. |
// | 131072327 | Disk update timed out. |
// | 131072328 | Successfully updated disks on nodes. |
// | 131072329 | Waiting for DQP firmware to update. |
// | 131072330 | Successfully updated DQP on nodes. |
// | 131072331 | DQP update timed out. |
// | 131072332 | Failed to copy firmware. |
//
swagger:model auto_update_status_inline_status
*/
type AutoUpdateStatusInlineStatus struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this auto update status inline status
func (o *AutoUpdateStatusInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineStatus) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "status" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this auto update status inline status based on the context it is used
func (o *AutoUpdateStatusInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AutoUpdateStatusInlineStatus) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "status" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AutoUpdateStatusInlineStatus) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *AutoUpdateStatusInlineStatus) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AutoUpdateStatusInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AutoUpdateStatusInlineStatus) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
