// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AutoUpdateStatusModifyReader is a Reader for the AutoUpdateStatusModify structure.
type AutoUpdateStatusModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AutoUpdateStatusModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAutoUpdateStatusModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAutoUpdateStatusModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAutoUpdateStatusModifyOK creates a AutoUpdateStatusModifyOK with default headers values
func NewAutoUpdateStatusModifyOK() *AutoUpdateStatusModifyOK {
	return &AutoUpdateStatusModifyOK{}
}

/*
AutoUpdateStatusModifyOK describes a response with status code 200, with default header values.

OK
*/
type AutoUpdateStatusModifyOK struct {
}

// IsSuccess returns true when this auto update status modify o k response has a 2xx status code
func (o *AutoUpdateStatusModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this auto update status modify o k response has a 3xx status code
func (o *AutoUpdateStatusModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this auto update status modify o k response has a 4xx status code
func (o *AutoUpdateStatusModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this auto update status modify o k response has a 5xx status code
func (o *AutoUpdateStatusModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this auto update status modify o k response a status code equal to that given
func (o *AutoUpdateStatusModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the auto update status modify o k response
func (o *AutoUpdateStatusModifyOK) Code() int {
	return 200
}

func (o *AutoUpdateStatusModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /support/auto-update/updates/{uuid}][%d] autoUpdateStatusModifyOK", 200)
}

func (o *AutoUpdateStatusModifyOK) String() string {
	return fmt.Sprintf("[PATCH /support/auto-update/updates/{uuid}][%d] autoUpdateStatusModifyOK", 200)
}

func (o *AutoUpdateStatusModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAutoUpdateStatusModifyDefault creates a AutoUpdateStatusModifyDefault with default headers values
func NewAutoUpdateStatusModifyDefault(code int) *AutoUpdateStatusModifyDefault {
	return &AutoUpdateStatusModifyDefault{
		_statusCode: code,
	}
}

/*
	AutoUpdateStatusModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262248 | Unexpected parameter missing a delimiter. |
| 131072200 | Invalid Automatic Update ID. |
| 131072201 | No schedule to cancel for automatic update ID. |
| 131072202 | Cannot abort an automatic update that is not in progress. |
| 131072203 | Cannot dismiss a non-pending automatic update. |
| 131072204 | Cannot reactivate an automatic update that has not been dismissed. |
| 131072205 | Cannot schedule a non-pending automatic update to start. |
| 131072206 | Cannot schedule an automatic update past its expiration date. |
| 131072207 | Cannot schedule an automatic update in the past. |
| 131072208 | Cannot schedule automatic update while the feature is disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AutoUpdateStatusModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this auto update status modify default response has a 2xx status code
func (o *AutoUpdateStatusModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this auto update status modify default response has a 3xx status code
func (o *AutoUpdateStatusModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this auto update status modify default response has a 4xx status code
func (o *AutoUpdateStatusModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this auto update status modify default response has a 5xx status code
func (o *AutoUpdateStatusModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this auto update status modify default response a status code equal to that given
func (o *AutoUpdateStatusModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the auto update status modify default response
func (o *AutoUpdateStatusModifyDefault) Code() int {
	return o._statusCode
}

func (o *AutoUpdateStatusModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/auto-update/updates/{uuid}][%d] auto_update_status_modify default %s", o._statusCode, payload)
}

func (o *AutoUpdateStatusModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/auto-update/updates/{uuid}][%d] auto_update_status_modify default %s", o._statusCode, payload)
}

func (o *AutoUpdateStatusModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AutoUpdateStatusModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
