// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AutosupportGetReader is a Reader for the AutosupportGet structure.
type AutosupportGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AutosupportGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAutosupportGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAutosupportGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAutosupportGetOK creates a AutosupportGetOK with default headers values
func NewAutosupportGetOK() *AutosupportGetOK {
	return &AutosupportGetOK{}
}

/*
AutosupportGetOK describes a response with status code 200, with default header values.

OK
*/
type AutosupportGetOK struct {
	Payload *models.Autosupport
}

// IsSuccess returns true when this autosupport get o k response has a 2xx status code
func (o *AutosupportGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this autosupport get o k response has a 3xx status code
func (o *AutosupportGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this autosupport get o k response has a 4xx status code
func (o *AutosupportGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this autosupport get o k response has a 5xx status code
func (o *AutosupportGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this autosupport get o k response a status code equal to that given
func (o *AutosupportGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the autosupport get o k response
func (o *AutosupportGetOK) Code() int {
	return 200
}

func (o *AutosupportGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/autosupport][%d] autosupportGetOK %s", 200, payload)
}

func (o *AutosupportGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/autosupport][%d] autosupportGetOK %s", 200, payload)
}

func (o *AutosupportGetOK) GetPayload() *models.Autosupport {
	return o.Payload
}

func (o *AutosupportGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Autosupport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAutosupportGetDefault creates a AutosupportGetDefault with default headers values
func NewAutosupportGetDefault(code int) *AutosupportGetDefault {
	return &AutosupportGetDefault{
		_statusCode: code,
	}
}

/*
AutosupportGetDefault describes a response with status code -1, with default header values.

Error
*/
type AutosupportGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this autosupport get default response has a 2xx status code
func (o *AutosupportGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this autosupport get default response has a 3xx status code
func (o *AutosupportGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this autosupport get default response has a 4xx status code
func (o *AutosupportGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this autosupport get default response has a 5xx status code
func (o *AutosupportGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this autosupport get default response a status code equal to that given
func (o *AutosupportGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the autosupport get default response
func (o *AutosupportGetDefault) Code() int {
	return o._statusCode
}

func (o *AutosupportGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/autosupport][%d] autosupport_get default %s", o._statusCode, payload)
}

func (o *AutosupportGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/autosupport][%d] autosupport_get default %s", o._statusCode, payload)
}

func (o *AutosupportGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AutosupportGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
