// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAutosupportMessageCollectionGetParams creates a new AutosupportMessageCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAutosupportMessageCollectionGetParams() *AutosupportMessageCollectionGetParams {
	return &AutosupportMessageCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAutosupportMessageCollectionGetParamsWithTimeout creates a new AutosupportMessageCollectionGetParams object
// with the ability to set a timeout on a request.
func NewAutosupportMessageCollectionGetParamsWithTimeout(timeout time.Duration) *AutosupportMessageCollectionGetParams {
	return &AutosupportMessageCollectionGetParams{
		timeout: timeout,
	}
}

// NewAutosupportMessageCollectionGetParamsWithContext creates a new AutosupportMessageCollectionGetParams object
// with the ability to set a context for a request.
func NewAutosupportMessageCollectionGetParamsWithContext(ctx context.Context) *AutosupportMessageCollectionGetParams {
	return &AutosupportMessageCollectionGetParams{
		Context: ctx,
	}
}

// NewAutosupportMessageCollectionGetParamsWithHTTPClient creates a new AutosupportMessageCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAutosupportMessageCollectionGetParamsWithHTTPClient(client *http.Client) *AutosupportMessageCollectionGetParams {
	return &AutosupportMessageCollectionGetParams{
		HTTPClient: client,
	}
}

/*
AutosupportMessageCollectionGetParams contains all the parameters to send to the API endpoint

	for the autosupport message collection get operation.

	Typically these are written to a http.Request.
*/
type AutosupportMessageCollectionGetParams struct {

	/* Destination.

	   Filter by destination
	*/
	Destination *string

	/* ErrorCode.

	   Filter by error.code
	*/
	ErrorCode *int64

	/* ErrorMessage.

	   Filter by error.message
	*/
	ErrorMessage *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GeneratedOn.

	   Filter by generated_on
	*/
	GeneratedOn *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* Subject.

	   Filter by subject
	*/
	Subject *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the autosupport message collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutosupportMessageCollectionGetParams) WithDefaults() *AutosupportMessageCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the autosupport message collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AutosupportMessageCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AutosupportMessageCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithTimeout(timeout time.Duration) *AutosupportMessageCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithContext(ctx context.Context) *AutosupportMessageCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithHTTPClient(client *http.Client) *AutosupportMessageCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDestination adds the destination to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithDestination(destination *string) *AutosupportMessageCollectionGetParams {
	o.SetDestination(destination)
	return o
}

// SetDestination adds the destination to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetDestination(destination *string) {
	o.Destination = destination
}

// WithErrorCode adds the errorCode to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithErrorCode(errorCode *int64) *AutosupportMessageCollectionGetParams {
	o.SetErrorCode(errorCode)
	return o
}

// SetErrorCode adds the errorCode to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetErrorCode(errorCode *int64) {
	o.ErrorCode = errorCode
}

// WithErrorMessage adds the errorMessage to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithErrorMessage(errorMessage *string) *AutosupportMessageCollectionGetParams {
	o.SetErrorMessage(errorMessage)
	return o
}

// SetErrorMessage adds the errorMessage to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetErrorMessage(errorMessage *string) {
	o.ErrorMessage = errorMessage
}

// WithFields adds the fields to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithFields(fields []string) *AutosupportMessageCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGeneratedOn adds the generatedOn to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithGeneratedOn(generatedOn *string) *AutosupportMessageCollectionGetParams {
	o.SetGeneratedOn(generatedOn)
	return o
}

// SetGeneratedOn adds the generatedOn to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetGeneratedOn(generatedOn *string) {
	o.GeneratedOn = generatedOn
}

// WithIndex adds the index to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithIndex(index *int64) *AutosupportMessageCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithMaxRecords(maxRecords *int64) *AutosupportMessageCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithNodeName(nodeName *string) *AutosupportMessageCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithNodeUUID(nodeUUID *string) *AutosupportMessageCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithOrderBy(orderBy []string) *AutosupportMessageCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithReturnRecords(returnRecords *bool) *AutosupportMessageCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *AutosupportMessageCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithState adds the state to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithState(state *string) *AutosupportMessageCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSubject adds the subject to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) WithSubject(subject *string) *AutosupportMessageCollectionGetParams {
	o.SetSubject(subject)
	return o
}

// SetSubject adds the subject to the autosupport message collection get params
func (o *AutosupportMessageCollectionGetParams) SetSubject(subject *string) {
	o.Subject = subject
}

// WriteToRequest writes these params to a swagger request
func (o *AutosupportMessageCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Destination != nil {

		// query param destination
		var qrDestination string

		if o.Destination != nil {
			qrDestination = *o.Destination
		}
		qDestination := qrDestination
		if qDestination != "" {

			if err := r.SetQueryParam("destination", qDestination); err != nil {
				return err
			}
		}
	}

	if o.ErrorCode != nil {

		// query param error.code
		var qrErrorCode int64

		if o.ErrorCode != nil {
			qrErrorCode = *o.ErrorCode
		}
		qErrorCode := swag.FormatInt64(qrErrorCode)
		if qErrorCode != "" {

			if err := r.SetQueryParam("error.code", qErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorMessage != nil {

		// query param error.message
		var qrErrorMessage string

		if o.ErrorMessage != nil {
			qrErrorMessage = *o.ErrorMessage
		}
		qErrorMessage := qrErrorMessage
		if qErrorMessage != "" {

			if err := r.SetQueryParam("error.message", qErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.GeneratedOn != nil {

		// query param generated_on
		var qrGeneratedOn string

		if o.GeneratedOn != nil {
			qrGeneratedOn = *o.GeneratedOn
		}
		qGeneratedOn := qrGeneratedOn
		if qGeneratedOn != "" {

			if err := r.SetQueryParam("generated_on", qGeneratedOn); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Subject != nil {

		// query param subject
		var qrSubject string

		if o.Subject != nil {
			qrSubject = *o.Subject
		}
		qSubject := qrSubject
		if qSubject != "" {

			if err := r.SetQueryParam("subject", qSubject); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAutosupportMessageCollectionGet binds the parameter fields
func (o *AutosupportMessageCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAutosupportMessageCollectionGet binds the parameter order_by
func (o *AutosupportMessageCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
