// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConfigurationBackupFileCollectionGetParams creates a new ConfigurationBackupFileCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConfigurationBackupFileCollectionGetParams() *ConfigurationBackupFileCollectionGetParams {
	return &ConfigurationBackupFileCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConfigurationBackupFileCollectionGetParamsWithTimeout creates a new ConfigurationBackupFileCollectionGetParams object
// with the ability to set a timeout on a request.
func NewConfigurationBackupFileCollectionGetParamsWithTimeout(timeout time.Duration) *ConfigurationBackupFileCollectionGetParams {
	return &ConfigurationBackupFileCollectionGetParams{
		timeout: timeout,
	}
}

// NewConfigurationBackupFileCollectionGetParamsWithContext creates a new ConfigurationBackupFileCollectionGetParams object
// with the ability to set a context for a request.
func NewConfigurationBackupFileCollectionGetParamsWithContext(ctx context.Context) *ConfigurationBackupFileCollectionGetParams {
	return &ConfigurationBackupFileCollectionGetParams{
		Context: ctx,
	}
}

// NewConfigurationBackupFileCollectionGetParamsWithHTTPClient creates a new ConfigurationBackupFileCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewConfigurationBackupFileCollectionGetParamsWithHTTPClient(client *http.Client) *ConfigurationBackupFileCollectionGetParams {
	return &ConfigurationBackupFileCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ConfigurationBackupFileCollectionGetParams contains all the parameters to send to the API endpoint

	for the configuration backup file collection get operation.

	Typically these are written to a http.Request.
*/
type ConfigurationBackupFileCollectionGetParams struct {

	/* Auto.

	   Filter by auto
	*/
	Auto *bool

	/* BackupNodesName.

	   Filter by backup_nodes.name
	*/
	BackupNodesName *string

	/* DownloadLink.

	   Filter by download_link
	*/
	DownloadLink *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Time.

	   Filter by time
	*/
	Time *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the configuration backup file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileCollectionGetParams) WithDefaults() *ConfigurationBackupFileCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the configuration backup file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ConfigurationBackupFileCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithTimeout(timeout time.Duration) *ConfigurationBackupFileCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithContext(ctx context.Context) *ConfigurationBackupFileCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithHTTPClient(client *http.Client) *ConfigurationBackupFileCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuto adds the auto to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithAuto(auto *bool) *ConfigurationBackupFileCollectionGetParams {
	o.SetAuto(auto)
	return o
}

// SetAuto adds the auto to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetAuto(auto *bool) {
	o.Auto = auto
}

// WithBackupNodesName adds the backupNodesName to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithBackupNodesName(backupNodesName *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetBackupNodesName(backupNodesName)
	return o
}

// SetBackupNodesName adds the backupNodesName to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetBackupNodesName(backupNodesName *string) {
	o.BackupNodesName = backupNodesName
}

// WithDownloadLink adds the downloadLink to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithDownloadLink(downloadLink *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetDownloadLink(downloadLink)
	return o
}

// SetDownloadLink adds the downloadLink to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetDownloadLink(downloadLink *string) {
	o.DownloadLink = downloadLink
}

// WithFields adds the fields to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithFields(fields []string) *ConfigurationBackupFileCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithMaxRecords(maxRecords *int64) *ConfigurationBackupFileCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithName(name *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithNodeName(nodeName *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithNodeUUID(nodeUUID *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithOrderBy(orderBy []string) *ConfigurationBackupFileCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithReturnRecords(returnRecords *bool) *ConfigurationBackupFileCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ConfigurationBackupFileCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSize adds the size to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithSize(size *int64) *ConfigurationBackupFileCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithTime adds the time to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithTime(time *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetTime(time)
	return o
}

// SetTime adds the time to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetTime(time *string) {
	o.Time = time
}

// WithType adds the typeVar to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithType(typeVar *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithVersion adds the version to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) WithVersion(version *string) *ConfigurationBackupFileCollectionGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the configuration backup file collection get params
func (o *ConfigurationBackupFileCollectionGetParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ConfigurationBackupFileCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Auto != nil {

		// query param auto
		var qrAuto bool

		if o.Auto != nil {
			qrAuto = *o.Auto
		}
		qAuto := swag.FormatBool(qrAuto)
		if qAuto != "" {

			if err := r.SetQueryParam("auto", qAuto); err != nil {
				return err
			}
		}
	}

	if o.BackupNodesName != nil {

		// query param backup_nodes.name
		var qrBackupNodesName string

		if o.BackupNodesName != nil {
			qrBackupNodesName = *o.BackupNodesName
		}
		qBackupNodesName := qrBackupNodesName
		if qBackupNodesName != "" {

			if err := r.SetQueryParam("backup_nodes.name", qBackupNodesName); err != nil {
				return err
			}
		}
	}

	if o.DownloadLink != nil {

		// query param download_link
		var qrDownloadLink string

		if o.DownloadLink != nil {
			qrDownloadLink = *o.DownloadLink
		}
		qDownloadLink := qrDownloadLink
		if qDownloadLink != "" {

			if err := r.SetQueryParam("download_link", qDownloadLink); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Time != nil {

		// query param time
		var qrTime string

		if o.Time != nil {
			qrTime = *o.Time
		}
		qTime := qrTime
		if qTime != "" {

			if err := r.SetQueryParam("time", qTime); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamConfigurationBackupFileCollectionGet binds the parameter fields
func (o *ConfigurationBackupFileCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamConfigurationBackupFileCollectionGet binds the parameter order_by
func (o *ConfigurationBackupFileCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
