// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConfigurationBackupFileDeleteCollectionParams creates a new ConfigurationBackupFileDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConfigurationBackupFileDeleteCollectionParams() *ConfigurationBackupFileDeleteCollectionParams {
	return &ConfigurationBackupFileDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConfigurationBackupFileDeleteCollectionParamsWithTimeout creates a new ConfigurationBackupFileDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewConfigurationBackupFileDeleteCollectionParamsWithTimeout(timeout time.Duration) *ConfigurationBackupFileDeleteCollectionParams {
	return &ConfigurationBackupFileDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewConfigurationBackupFileDeleteCollectionParamsWithContext creates a new ConfigurationBackupFileDeleteCollectionParams object
// with the ability to set a context for a request.
func NewConfigurationBackupFileDeleteCollectionParamsWithContext(ctx context.Context) *ConfigurationBackupFileDeleteCollectionParams {
	return &ConfigurationBackupFileDeleteCollectionParams{
		Context: ctx,
	}
}

// NewConfigurationBackupFileDeleteCollectionParamsWithHTTPClient creates a new ConfigurationBackupFileDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewConfigurationBackupFileDeleteCollectionParamsWithHTTPClient(client *http.Client) *ConfigurationBackupFileDeleteCollectionParams {
	return &ConfigurationBackupFileDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ConfigurationBackupFileDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the configuration backup file delete collection operation.

	Typically these are written to a http.Request.
*/
type ConfigurationBackupFileDeleteCollectionParams struct {

	/* Auto.

	   Filter by auto
	*/
	Auto *bool

	/* BackupNodesName.

	   Filter by backup_nodes.name
	*/
	BackupNodesName *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DownloadLink.

	   Filter by download_link
	*/
	DownloadLink *string

	/* Info.

	   Info specification
	*/
	Info ConfigurationBackupFileDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Time.

	   Filter by time
	*/
	Time *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the configuration backup file delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileDeleteCollectionParams) WithDefaults() *ConfigurationBackupFileDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the configuration backup file delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ConfigurationBackupFileDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithTimeout(timeout time.Duration) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithContext(ctx context.Context) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithHTTPClient(client *http.Client) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuto adds the auto to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithAuto(auto *bool) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetAuto(auto)
	return o
}

// SetAuto adds the auto to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetAuto(auto *bool) {
	o.Auto = auto
}

// WithBackupNodesName adds the backupNodesName to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithBackupNodesName(backupNodesName *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetBackupNodesName(backupNodesName)
	return o
}

// SetBackupNodesName adds the backupNodesName to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetBackupNodesName(backupNodesName *string) {
	o.BackupNodesName = backupNodesName
}

// WithContinueOnFailure adds the continueOnFailure to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDownloadLink adds the downloadLink to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithDownloadLink(downloadLink *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetDownloadLink(downloadLink)
	return o
}

// SetDownloadLink adds the downloadLink to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetDownloadLink(downloadLink *string) {
	o.DownloadLink = downloadLink
}

// WithInfo adds the info to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithInfo(info ConfigurationBackupFileDeleteCollectionBody) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetInfo(info ConfigurationBackupFileDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithName(name *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithNodeName(nodeName *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithNodeUUID(nodeUUID *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithReturnRecords adds the returnRecords to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSize adds the size to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithSize(size *int64) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetSize(size *int64) {
	o.Size = size
}

// WithTime adds the time to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithTime(time *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetTime(time)
	return o
}

// SetTime adds the time to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetTime(time *string) {
	o.Time = time
}

// WithType adds the typeVar to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithType(typeVar *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithVersion adds the version to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) WithVersion(version *string) *ConfigurationBackupFileDeleteCollectionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the configuration backup file delete collection params
func (o *ConfigurationBackupFileDeleteCollectionParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ConfigurationBackupFileDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Auto != nil {

		// query param auto
		var qrAuto bool

		if o.Auto != nil {
			qrAuto = *o.Auto
		}
		qAuto := swag.FormatBool(qrAuto)
		if qAuto != "" {

			if err := r.SetQueryParam("auto", qAuto); err != nil {
				return err
			}
		}
	}

	if o.BackupNodesName != nil {

		// query param backup_nodes.name
		var qrBackupNodesName string

		if o.BackupNodesName != nil {
			qrBackupNodesName = *o.BackupNodesName
		}
		qBackupNodesName := qrBackupNodesName
		if qBackupNodesName != "" {

			if err := r.SetQueryParam("backup_nodes.name", qBackupNodesName); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DownloadLink != nil {

		// query param download_link
		var qrDownloadLink string

		if o.DownloadLink != nil {
			qrDownloadLink = *o.DownloadLink
		}
		qDownloadLink := qrDownloadLink
		if qDownloadLink != "" {

			if err := r.SetQueryParam("download_link", qDownloadLink); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Time != nil {

		// query param time
		var qrTime string

		if o.Time != nil {
			qrTime = *o.Time
		}
		qTime := qrTime
		if qTime != "" {

			if err := r.SetQueryParam("time", qTime); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
