// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConfigurationBackupFileDeleteCollectionReader is a Reader for the ConfigurationBackupFileDeleteCollection structure.
type ConfigurationBackupFileDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConfigurationBackupFileDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConfigurationBackupFileDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConfigurationBackupFileDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConfigurationBackupFileDeleteCollectionOK creates a ConfigurationBackupFileDeleteCollectionOK with default headers values
func NewConfigurationBackupFileDeleteCollectionOK() *ConfigurationBackupFileDeleteCollectionOK {
	return &ConfigurationBackupFileDeleteCollectionOK{}
}

/*
ConfigurationBackupFileDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ConfigurationBackupFileDeleteCollectionOK struct {
}

// IsSuccess returns true when this configuration backup file delete collection o k response has a 2xx status code
func (o *ConfigurationBackupFileDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this configuration backup file delete collection o k response has a 3xx status code
func (o *ConfigurationBackupFileDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this configuration backup file delete collection o k response has a 4xx status code
func (o *ConfigurationBackupFileDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this configuration backup file delete collection o k response has a 5xx status code
func (o *ConfigurationBackupFileDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this configuration backup file delete collection o k response a status code equal to that given
func (o *ConfigurationBackupFileDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the configuration backup file delete collection o k response
func (o *ConfigurationBackupFileDeleteCollectionOK) Code() int {
	return 200
}

func (o *ConfigurationBackupFileDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/configuration-backup/backups][%d] configurationBackupFileDeleteCollectionOK", 200)
}

func (o *ConfigurationBackupFileDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/configuration-backup/backups][%d] configurationBackupFileDeleteCollectionOK", 200)
}

func (o *ConfigurationBackupFileDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConfigurationBackupFileDeleteCollectionDefault creates a ConfigurationBackupFileDeleteCollectionDefault with default headers values
func NewConfigurationBackupFileDeleteCollectionDefault(code int) *ConfigurationBackupFileDeleteCollectionDefault {
	return &ConfigurationBackupFileDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ConfigurationBackupFileDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5963826 | Failed to delete backup file. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConfigurationBackupFileDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this configuration backup file delete collection default response has a 2xx status code
func (o *ConfigurationBackupFileDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this configuration backup file delete collection default response has a 3xx status code
func (o *ConfigurationBackupFileDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this configuration backup file delete collection default response has a 4xx status code
func (o *ConfigurationBackupFileDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this configuration backup file delete collection default response has a 5xx status code
func (o *ConfigurationBackupFileDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this configuration backup file delete collection default response a status code equal to that given
func (o *ConfigurationBackupFileDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the configuration backup file delete collection default response
func (o *ConfigurationBackupFileDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ConfigurationBackupFileDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/configuration-backup/backups][%d] configuration_backup_file_delete_collection default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupFileDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/configuration-backup/backups][%d] configuration_backup_file_delete_collection default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupFileDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConfigurationBackupFileDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ConfigurationBackupFileDeleteCollectionBody configuration backup file delete collection body
swagger:model ConfigurationBackupFileDeleteCollectionBody
*/
type ConfigurationBackupFileDeleteCollectionBody struct {

	// configuration backup file response inline records
	ConfigurationBackupFileResponseInlineRecords []*models.ConfigurationBackupFile `json:"records,omitempty"`
}

// Validate validates this configuration backup file delete collection body
func (o *ConfigurationBackupFileDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConfigurationBackupFileResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConfigurationBackupFileDeleteCollectionBody) validateConfigurationBackupFileResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ConfigurationBackupFileResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ConfigurationBackupFileResponseInlineRecords); i++ {
		if swag.IsZero(o.ConfigurationBackupFileResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ConfigurationBackupFileResponseInlineRecords[i] != nil {
			if err := o.ConfigurationBackupFileResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this configuration backup file delete collection body based on the context it is used
func (o *ConfigurationBackupFileDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConfigurationBackupFileResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConfigurationBackupFileDeleteCollectionBody) contextValidateConfigurationBackupFileResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConfigurationBackupFileResponseInlineRecords); i++ {

		if o.ConfigurationBackupFileResponseInlineRecords[i] != nil {
			if err := o.ConfigurationBackupFileResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConfigurationBackupFileDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConfigurationBackupFileDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ConfigurationBackupFileDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
