// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConfigurationBackupFileGetParams creates a new ConfigurationBackupFileGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConfigurationBackupFileGetParams() *ConfigurationBackupFileGetParams {
	return &ConfigurationBackupFileGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConfigurationBackupFileGetParamsWithTimeout creates a new ConfigurationBackupFileGetParams object
// with the ability to set a timeout on a request.
func NewConfigurationBackupFileGetParamsWithTimeout(timeout time.Duration) *ConfigurationBackupFileGetParams {
	return &ConfigurationBackupFileGetParams{
		timeout: timeout,
	}
}

// NewConfigurationBackupFileGetParamsWithContext creates a new ConfigurationBackupFileGetParams object
// with the ability to set a context for a request.
func NewConfigurationBackupFileGetParamsWithContext(ctx context.Context) *ConfigurationBackupFileGetParams {
	return &ConfigurationBackupFileGetParams{
		Context: ctx,
	}
}

// NewConfigurationBackupFileGetParamsWithHTTPClient creates a new ConfigurationBackupFileGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewConfigurationBackupFileGetParamsWithHTTPClient(client *http.Client) *ConfigurationBackupFileGetParams {
	return &ConfigurationBackupFileGetParams{
		HTTPClient: client,
	}
}

/*
ConfigurationBackupFileGetParams contains all the parameters to send to the API endpoint

	for the configuration backup file get operation.

	Typically these are written to a http.Request.
*/
type ConfigurationBackupFileGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   Name of the configuration backup.
	*/
	Name string

	/* NodeUUID.

	   UUID of the node that owns the configuration backup.
	*/
	NodeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the configuration backup file get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileGetParams) WithDefaults() *ConfigurationBackupFileGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the configuration backup file get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConfigurationBackupFileGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithTimeout(timeout time.Duration) *ConfigurationBackupFileGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithContext(ctx context.Context) *ConfigurationBackupFileGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithHTTPClient(client *http.Client) *ConfigurationBackupFileGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithFields(fields []string) *ConfigurationBackupFileGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithName(name string) *ConfigurationBackupFileGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetName(name string) {
	o.Name = name
}

// WithNodeUUID adds the nodeUUID to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) WithNodeUUID(nodeUUID string) *ConfigurationBackupFileGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the configuration backup file get params
func (o *ConfigurationBackupFileGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ConfigurationBackupFileGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamConfigurationBackupFileGet binds the parameter fields
func (o *ConfigurationBackupFileGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
