// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConfigurationBackupGetReader is a Reader for the ConfigurationBackupGet structure.
type ConfigurationBackupGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConfigurationBackupGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConfigurationBackupGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConfigurationBackupGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConfigurationBackupGetOK creates a ConfigurationBackupGetOK with default headers values
func NewConfigurationBackupGetOK() *ConfigurationBackupGetOK {
	return &ConfigurationBackupGetOK{}
}

/*
ConfigurationBackupGetOK describes a response with status code 200, with default header values.

OK
*/
type ConfigurationBackupGetOK struct {
	Payload *models.ConfigurationBackup
}

// IsSuccess returns true when this configuration backup get o k response has a 2xx status code
func (o *ConfigurationBackupGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this configuration backup get o k response has a 3xx status code
func (o *ConfigurationBackupGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this configuration backup get o k response has a 4xx status code
func (o *ConfigurationBackupGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this configuration backup get o k response has a 5xx status code
func (o *ConfigurationBackupGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this configuration backup get o k response a status code equal to that given
func (o *ConfigurationBackupGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the configuration backup get o k response
func (o *ConfigurationBackupGetOK) Code() int {
	return 200
}

func (o *ConfigurationBackupGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/configuration-backup][%d] configurationBackupGetOK %s", 200, payload)
}

func (o *ConfigurationBackupGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/configuration-backup][%d] configurationBackupGetOK %s", 200, payload)
}

func (o *ConfigurationBackupGetOK) GetPayload() *models.ConfigurationBackup {
	return o.Payload
}

func (o *ConfigurationBackupGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConfigurationBackup)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConfigurationBackupGetDefault creates a ConfigurationBackupGetDefault with default headers values
func NewConfigurationBackupGetDefault(code int) *ConfigurationBackupGetDefault {
	return &ConfigurationBackupGetDefault{
		_statusCode: code,
	}
}

/*
ConfigurationBackupGetDefault describes a response with status code -1, with default header values.

Error
*/
type ConfigurationBackupGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this configuration backup get default response has a 2xx status code
func (o *ConfigurationBackupGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this configuration backup get default response has a 3xx status code
func (o *ConfigurationBackupGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this configuration backup get default response has a 4xx status code
func (o *ConfigurationBackupGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this configuration backup get default response has a 5xx status code
func (o *ConfigurationBackupGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this configuration backup get default response a status code equal to that given
func (o *ConfigurationBackupGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the configuration backup get default response
func (o *ConfigurationBackupGetDefault) Code() int {
	return o._statusCode
}

func (o *ConfigurationBackupGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/configuration-backup][%d] configuration_backup_get default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/configuration-backup][%d] configuration_backup_get default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConfigurationBackupGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
