// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConfigurationBackupModifyReader is a Reader for the ConfigurationBackupModify structure.
type ConfigurationBackupModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConfigurationBackupModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConfigurationBackupModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConfigurationBackupModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConfigurationBackupModifyOK creates a ConfigurationBackupModifyOK with default headers values
func NewConfigurationBackupModifyOK() *ConfigurationBackupModifyOK {
	return &ConfigurationBackupModifyOK{}
}

/*
ConfigurationBackupModifyOK describes a response with status code 200, with default header values.

OK
*/
type ConfigurationBackupModifyOK struct {
}

// IsSuccess returns true when this configuration backup modify o k response has a 2xx status code
func (o *ConfigurationBackupModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this configuration backup modify o k response has a 3xx status code
func (o *ConfigurationBackupModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this configuration backup modify o k response has a 4xx status code
func (o *ConfigurationBackupModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this configuration backup modify o k response has a 5xx status code
func (o *ConfigurationBackupModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this configuration backup modify o k response a status code equal to that given
func (o *ConfigurationBackupModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the configuration backup modify o k response
func (o *ConfigurationBackupModifyOK) Code() int {
	return 200
}

func (o *ConfigurationBackupModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /support/configuration-backup][%d] configurationBackupModifyOK", 200)
}

func (o *ConfigurationBackupModifyOK) String() string {
	return fmt.Sprintf("[PATCH /support/configuration-backup][%d] configurationBackupModifyOK", 200)
}

func (o *ConfigurationBackupModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConfigurationBackupModifyDefault creates a ConfigurationBackupModifyDefault with default headers values
func NewConfigurationBackupModifyDefault(code int) *ConfigurationBackupModifyDefault {
	return &ConfigurationBackupModifyDefault{
		_statusCode: code,
	}
}

/*
	ConfigurationBackupModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 39387137   | Invalid URL |
| 39387138   | Invalid URL Scheme |
|  5963792   | Using HTTPS for URL requires an effective cluster version of 9.7.0 or later. |
|  5963794   | Validating the certificate is supported for the HTTPS protocol only. |
*/
type ConfigurationBackupModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this configuration backup modify default response has a 2xx status code
func (o *ConfigurationBackupModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this configuration backup modify default response has a 3xx status code
func (o *ConfigurationBackupModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this configuration backup modify default response has a 4xx status code
func (o *ConfigurationBackupModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this configuration backup modify default response has a 5xx status code
func (o *ConfigurationBackupModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this configuration backup modify default response a status code equal to that given
func (o *ConfigurationBackupModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the configuration backup modify default response
func (o *ConfigurationBackupModifyDefault) Code() int {
	return o._statusCode
}

func (o *ConfigurationBackupModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/configuration-backup][%d] configuration_backup_modify default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/configuration-backup][%d] configuration_backup_modify default %s", o._statusCode, payload)
}

func (o *ConfigurationBackupModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConfigurationBackupModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
