// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCoredumpDeleteCollectionParams creates a new CoredumpDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCoredumpDeleteCollectionParams() *CoredumpDeleteCollectionParams {
	return &CoredumpDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCoredumpDeleteCollectionParamsWithTimeout creates a new CoredumpDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCoredumpDeleteCollectionParamsWithTimeout(timeout time.Duration) *CoredumpDeleteCollectionParams {
	return &CoredumpDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCoredumpDeleteCollectionParamsWithContext creates a new CoredumpDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCoredumpDeleteCollectionParamsWithContext(ctx context.Context) *CoredumpDeleteCollectionParams {
	return &CoredumpDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCoredumpDeleteCollectionParamsWithHTTPClient creates a new CoredumpDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCoredumpDeleteCollectionParamsWithHTTPClient(client *http.Client) *CoredumpDeleteCollectionParams {
	return &CoredumpDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CoredumpDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the coredump delete collection operation.

	Typically these are written to a http.Request.
*/
type CoredumpDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info CoredumpDeleteCollectionBody

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *bool

	/* IsSaved.

	   Filter by is_saved
	*/
	IsSaved *bool

	/* Md5DataChecksum.

	   Filter by md5_data_checksum
	*/
	Md5DataChecksum *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* PanicTime.

	   Filter by panic_time
	*/
	PanicTime *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Type.

	   Filter by type
	*/
	Type *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the coredump delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CoredumpDeleteCollectionParams) WithDefaults() *CoredumpDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the coredump delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CoredumpDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CoredumpDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithTimeout(timeout time.Duration) *CoredumpDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithContext(ctx context.Context) *CoredumpDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithHTTPClient(client *http.Client) *CoredumpDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CoredumpDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithInfo(info CoredumpDeleteCollectionBody) *CoredumpDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetInfo(info CoredumpDeleteCollectionBody) {
	o.Info = info
}

// WithIsPartial adds the isPartial to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithIsPartial(isPartial *bool) *CoredumpDeleteCollectionParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetIsPartial(isPartial *bool) {
	o.IsPartial = isPartial
}

// WithIsSaved adds the isSaved to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithIsSaved(isSaved *bool) *CoredumpDeleteCollectionParams {
	o.SetIsSaved(isSaved)
	return o
}

// SetIsSaved adds the isSaved to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetIsSaved(isSaved *bool) {
	o.IsSaved = isSaved
}

// WithMd5DataChecksum adds the md5DataChecksum to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithMd5DataChecksum(md5DataChecksum *string) *CoredumpDeleteCollectionParams {
	o.SetMd5DataChecksum(md5DataChecksum)
	return o
}

// SetMd5DataChecksum adds the md5DataChecksum to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetMd5DataChecksum(md5DataChecksum *string) {
	o.Md5DataChecksum = md5DataChecksum
}

// WithName adds the name to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithName(name *string) *CoredumpDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithNodeName(nodeName *string) *CoredumpDeleteCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithNodeUUID(nodeUUID *string) *CoredumpDeleteCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithPanicTime adds the panicTime to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithPanicTime(panicTime *string) *CoredumpDeleteCollectionParams {
	o.SetPanicTime(panicTime)
	return o
}

// SetPanicTime adds the panicTime to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetPanicTime(panicTime *string) {
	o.PanicTime = panicTime
}

// WithReturnRecords adds the returnRecords to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CoredumpDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CoredumpDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CoredumpDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSize adds the size to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithSize(size *int64) *CoredumpDeleteCollectionParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetSize(size *int64) {
	o.Size = size
}

// WithType adds the typeVar to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) WithType(typeVar *string) *CoredumpDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the coredump delete collection params
func (o *CoredumpDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WriteToRequest writes these params to a swagger request
func (o *CoredumpDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial bool

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := swag.FormatBool(qrIsPartial)
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.IsSaved != nil {

		// query param is_saved
		var qrIsSaved bool

		if o.IsSaved != nil {
			qrIsSaved = *o.IsSaved
		}
		qIsSaved := swag.FormatBool(qrIsSaved)
		if qIsSaved != "" {

			if err := r.SetQueryParam("is_saved", qIsSaved); err != nil {
				return err
			}
		}
	}

	if o.Md5DataChecksum != nil {

		// query param md5_data_checksum
		var qrMd5DataChecksum string

		if o.Md5DataChecksum != nil {
			qrMd5DataChecksum = *o.Md5DataChecksum
		}
		qMd5DataChecksum := qrMd5DataChecksum
		if qMd5DataChecksum != "" {

			if err := r.SetQueryParam("md5_data_checksum", qMd5DataChecksum); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PanicTime != nil {

		// query param panic_time
		var qrPanicTime string

		if o.PanicTime != nil {
			qrPanicTime = *o.PanicTime
		}
		qPanicTime := qrPanicTime
		if qPanicTime != "" {

			if err := r.SetQueryParam("panic_time", qPanicTime); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
