// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CoredumpDeleteCollectionReader is a Reader for the CoredumpDeleteCollection structure.
type CoredumpDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CoredumpDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCoredumpDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCoredumpDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCoredumpDeleteCollectionOK creates a CoredumpDeleteCollectionOK with default headers values
func NewCoredumpDeleteCollectionOK() *CoredumpDeleteCollectionOK {
	return &CoredumpDeleteCollectionOK{}
}

/*
CoredumpDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CoredumpDeleteCollectionOK struct {
}

// IsSuccess returns true when this coredump delete collection o k response has a 2xx status code
func (o *CoredumpDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this coredump delete collection o k response has a 3xx status code
func (o *CoredumpDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this coredump delete collection o k response has a 4xx status code
func (o *CoredumpDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this coredump delete collection o k response has a 5xx status code
func (o *CoredumpDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this coredump delete collection o k response a status code equal to that given
func (o *CoredumpDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the coredump delete collection o k response
func (o *CoredumpDeleteCollectionOK) Code() int {
	return 200
}

func (o *CoredumpDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/coredump/coredumps][%d] coredumpDeleteCollectionOK", 200)
}

func (o *CoredumpDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/coredump/coredumps][%d] coredumpDeleteCollectionOK", 200)
}

func (o *CoredumpDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCoredumpDeleteCollectionDefault creates a CoredumpDeleteCollectionDefault with default headers values
func NewCoredumpDeleteCollectionDefault(code int) *CoredumpDeleteCollectionDefault {
	return &CoredumpDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
CoredumpDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type CoredumpDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this coredump delete collection default response has a 2xx status code
func (o *CoredumpDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this coredump delete collection default response has a 3xx status code
func (o *CoredumpDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this coredump delete collection default response has a 4xx status code
func (o *CoredumpDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this coredump delete collection default response has a 5xx status code
func (o *CoredumpDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this coredump delete collection default response a status code equal to that given
func (o *CoredumpDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the coredump delete collection default response
func (o *CoredumpDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CoredumpDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/coredump/coredumps][%d] coredump_delete_collection default %s", o._statusCode, payload)
}

func (o *CoredumpDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/coredump/coredumps][%d] coredump_delete_collection default %s", o._statusCode, payload)
}

func (o *CoredumpDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CoredumpDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CoredumpDeleteCollectionBody coredump delete collection body
swagger:model CoredumpDeleteCollectionBody
*/
type CoredumpDeleteCollectionBody struct {

	// coredump response inline records
	CoredumpResponseInlineRecords []*models.Coredump `json:"records,omitempty"`
}

// Validate validates this coredump delete collection body
func (o *CoredumpDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCoredumpResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CoredumpDeleteCollectionBody) validateCoredumpResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CoredumpResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CoredumpResponseInlineRecords); i++ {
		if swag.IsZero(o.CoredumpResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CoredumpResponseInlineRecords[i] != nil {
			if err := o.CoredumpResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this coredump delete collection body based on the context it is used
func (o *CoredumpDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCoredumpResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CoredumpDeleteCollectionBody) contextValidateCoredumpResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CoredumpResponseInlineRecords); i++ {

		if o.CoredumpResponseInlineRecords[i] != nil {
			if err := o.CoredumpResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CoredumpDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CoredumpDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CoredumpDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
