// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCoredumpDeleteParams creates a new CoredumpDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCoredumpDeleteParams() *CoredumpDeleteParams {
	return &CoredumpDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCoredumpDeleteParamsWithTimeout creates a new CoredumpDeleteParams object
// with the ability to set a timeout on a request.
func NewCoredumpDeleteParamsWithTimeout(timeout time.Duration) *CoredumpDeleteParams {
	return &CoredumpDeleteParams{
		timeout: timeout,
	}
}

// NewCoredumpDeleteParamsWithContext creates a new CoredumpDeleteParams object
// with the ability to set a context for a request.
func NewCoredumpDeleteParamsWithContext(ctx context.Context) *CoredumpDeleteParams {
	return &CoredumpDeleteParams{
		Context: ctx,
	}
}

// NewCoredumpDeleteParamsWithHTTPClient creates a new CoredumpDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewCoredumpDeleteParamsWithHTTPClient(client *http.Client) *CoredumpDeleteParams {
	return &CoredumpDeleteParams{
		HTTPClient: client,
	}
}

/*
CoredumpDeleteParams contains all the parameters to send to the API endpoint

	for the coredump delete operation.

	Typically these are written to a http.Request.
*/
type CoredumpDeleteParams struct {

	/* Name.

	   Core name
	*/
	Name string

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the coredump delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CoredumpDeleteParams) WithDefaults() *CoredumpDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the coredump delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CoredumpDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := CoredumpDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the coredump delete params
func (o *CoredumpDeleteParams) WithTimeout(timeout time.Duration) *CoredumpDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the coredump delete params
func (o *CoredumpDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the coredump delete params
func (o *CoredumpDeleteParams) WithContext(ctx context.Context) *CoredumpDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the coredump delete params
func (o *CoredumpDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the coredump delete params
func (o *CoredumpDeleteParams) WithHTTPClient(client *http.Client) *CoredumpDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the coredump delete params
func (o *CoredumpDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the coredump delete params
func (o *CoredumpDeleteParams) WithName(name string) *CoredumpDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the coredump delete params
func (o *CoredumpDeleteParams) SetName(name string) {
	o.Name = name
}

// WithNodeUUID adds the nodeUUID to the coredump delete params
func (o *CoredumpDeleteParams) WithNodeUUID(nodeUUID string) *CoredumpDeleteParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the coredump delete params
func (o *CoredumpDeleteParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithReturnTimeout adds the returnTimeout to the coredump delete params
func (o *CoredumpDeleteParams) WithReturnTimeout(returnTimeout *int64) *CoredumpDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the coredump delete params
func (o *CoredumpDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *CoredumpDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
