// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CoredumpDeleteReader is a Reader for the CoredumpDelete structure.
type CoredumpDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CoredumpDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCoredumpDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCoredumpDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCoredumpDeleteOK creates a CoredumpDeleteOK with default headers values
func NewCoredumpDeleteOK() *CoredumpDeleteOK {
	return &CoredumpDeleteOK{}
}

/*
CoredumpDeleteOK describes a response with status code 200, with default header values.

OK
*/
type CoredumpDeleteOK struct {
}

// IsSuccess returns true when this coredump delete o k response has a 2xx status code
func (o *CoredumpDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this coredump delete o k response has a 3xx status code
func (o *CoredumpDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this coredump delete o k response has a 4xx status code
func (o *CoredumpDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this coredump delete o k response has a 5xx status code
func (o *CoredumpDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this coredump delete o k response a status code equal to that given
func (o *CoredumpDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the coredump delete o k response
func (o *CoredumpDeleteOK) Code() int {
	return 200
}

func (o *CoredumpDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /support/coredump/coredumps/{node.uuid}/{name}][%d] coredumpDeleteOK", 200)
}

func (o *CoredumpDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /support/coredump/coredumps/{node.uuid}/{name}][%d] coredumpDeleteOK", 200)
}

func (o *CoredumpDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCoredumpDeleteDefault creates a CoredumpDeleteDefault with default headers values
func NewCoredumpDeleteDefault(code int) *CoredumpDeleteDefault {
	return &CoredumpDeleteDefault{
		_statusCode: code,
	}
}

/*
CoredumpDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type CoredumpDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this coredump delete default response has a 2xx status code
func (o *CoredumpDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this coredump delete default response has a 3xx status code
func (o *CoredumpDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this coredump delete default response has a 4xx status code
func (o *CoredumpDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this coredump delete default response has a 5xx status code
func (o *CoredumpDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this coredump delete default response a status code equal to that given
func (o *CoredumpDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the coredump delete default response
func (o *CoredumpDeleteDefault) Code() int {
	return o._statusCode
}

func (o *CoredumpDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/coredump/coredumps/{node.uuid}/{name}][%d] coredump_delete default %s", o._statusCode, payload)
}

func (o *CoredumpDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/coredump/coredumps/{node.uuid}/{name}][%d] coredump_delete default %s", o._statusCode, payload)
}

func (o *CoredumpDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CoredumpDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
